// Code generated by smithy-go-codegen DO NOT EDIT.

package sagemaker

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/sagemaker/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// Description of the compute allocation definition.
func (c *Client) DescribeComputeQuota(ctx context.Context, params *DescribeComputeQuotaInput, optFns ...func(*Options)) (*DescribeComputeQuotaOutput, error) {
	if params == nil {
		params = &DescribeComputeQuotaInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "DescribeComputeQuota", params, optFns, c.addOperationDescribeComputeQuotaMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*DescribeComputeQuotaOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type DescribeComputeQuotaInput struct {

	// ID of the compute allocation definition.
	//
	// This member is required.
	ComputeQuotaId *string

	// Version of the compute allocation definition.
	ComputeQuotaVersion *int32

	noSmithyDocumentSerde
}

type DescribeComputeQuotaOutput struct {

	// ARN of the compute allocation definition.
	//
	// This member is required.
	ComputeQuotaArn *string

	// ID of the compute allocation definition.
	//
	// This member is required.
	ComputeQuotaId *string

	// The target entity to allocate compute resources to.
	//
	// This member is required.
	ComputeQuotaTarget *types.ComputeQuotaTarget

	// Version of the compute allocation definition.
	//
	// This member is required.
	ComputeQuotaVersion *int32

	// Creation time of the compute allocation configuration.
	//
	// This member is required.
	CreationTime *time.Time

	// Name of the compute allocation definition.
	//
	// This member is required.
	Name *string

	// Status of the compute allocation definition.
	//
	// This member is required.
	Status types.SchedulerResourceStatus

	// The state of the compute allocation being described. Use to enable or disable
	// compute allocation.
	//
	// Default is Enabled .
	ActivationState types.ActivationState

	// ARN of the cluster.
	ClusterArn *string

	// Configuration of the compute allocation definition. This includes the resource
	// sharing option, and the setting to preempt low priority tasks.
	ComputeQuotaConfig *types.ComputeQuotaConfig

	// Information about the user who created or modified a SageMaker resource.
	CreatedBy *types.UserContext

	// Description of the compute allocation definition.
	Description *string

	// Failure reason of the compute allocation definition.
	FailureReason *string

	// Information about the user who created or modified a SageMaker resource.
	LastModifiedBy *types.UserContext

	// Last modified time of the compute allocation configuration.
	LastModifiedTime *time.Time

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationDescribeComputeQuotaMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpDescribeComputeQuota{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpDescribeComputeQuota{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "DescribeComputeQuota"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpDescribeComputeQuotaValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opDescribeComputeQuota(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptExecution(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptTransmit(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeDeserialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterDeserialization(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opDescribeComputeQuota(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "DescribeComputeQuota",
	}
}
