// Code generated by smithy-go-codegen DO NOT EDIT.

package qapps

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/qapps/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// Retrieves details about a library item for an Amazon Q App, including its
// metadata, categories, ratings, and usage statistics.
func (c *Client) GetLibraryItem(ctx context.Context, params *GetLibraryItemInput, optFns ...func(*Options)) (*GetLibraryItemOutput, error) {
	if params == nil {
		params = &GetLibraryItemInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "GetLibraryItem", params, optFns, c.addOperationGetLibraryItemMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*GetLibraryItemOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type GetLibraryItemInput struct {

	// The unique identifier of the Amazon Q Business application environment instance.
	//
	// This member is required.
	InstanceId *string

	// The unique identifier of the library item to retrieve.
	//
	// This member is required.
	LibraryItemId *string

	// The unique identifier of the Amazon Q App associated with the library item.
	AppId *string

	noSmithyDocumentSerde
}

type GetLibraryItemOutput struct {

	// The unique identifier of the Q App associated with the library item.
	//
	// This member is required.
	AppId *string

	// The version of the Q App associated with the library item.
	//
	// This member is required.
	AppVersion *int32

	// The categories associated with the library item for discovery.
	//
	// This member is required.
	Categories []types.Category

	// The date and time the library item was created.
	//
	// This member is required.
	CreatedAt *time.Time

	// The user who created the library item.
	//
	// This member is required.
	CreatedBy *string

	// The unique identifier of the library item.
	//
	// This member is required.
	LibraryItemId *string

	// The number of ratings the library item has received from users.
	//
	// This member is required.
	RatingCount *int32

	// The status of the library item, such as "Published".
	//
	// This member is required.
	Status *string

	// Whether the current user has rated the library item.
	IsRatedByUser *bool

	// Indicates whether the library item has been verified.
	IsVerified *bool

	// The date and time the library item was last updated.
	UpdatedAt *time.Time

	// The user who last updated the library item.
	UpdatedBy *string

	// The number of users who have associated the Q App with their account.
	UserCount *int32

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationGetLibraryItemMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpGetLibraryItem{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpGetLibraryItem{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "GetLibraryItem"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpGetLibraryItemValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opGetLibraryItem(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opGetLibraryItem(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "GetLibraryItem",
	}
}
