// Code generated by smithy-go-codegen DO NOT EDIT.

package medialive

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/medialive/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// Initiates the creation of a new signal map. Will discover a new
// mediaResourceMap based on the provided discoveryEntryPointArn.
func (c *Client) CreateSignalMap(ctx context.Context, params *CreateSignalMapInput, optFns ...func(*Options)) (*CreateSignalMapOutput, error) {
	if params == nil {
		params = &CreateSignalMapInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "CreateSignalMap", params, optFns, c.addOperationCreateSignalMapMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*CreateSignalMapOutput)
	out.ResultMetadata = metadata
	return out, nil
}

// Placeholder documentation for CreateSignalMapRequest
type CreateSignalMapInput struct {

	// A top-level supported AWS resource ARN to discovery a signal map from.
	//
	// This member is required.
	DiscoveryEntryPointArn *string

	// A resource's name. Names must be unique within the scope of a resource type in
	// a specific region.
	//
	// This member is required.
	Name *string

	// Placeholder documentation for __listOf__stringPatternS
	CloudWatchAlarmTemplateGroupIdentifiers []string

	// A resource's optional description.
	Description *string

	// Placeholder documentation for __listOf__stringPatternS
	EventBridgeRuleTemplateGroupIdentifiers []string

	// An ID that you assign to a create request. This ID ensures idempotency when
	// creating resources.
	RequestId *string

	// Represents the tags associated with a resource.
	Tags map[string]string

	noSmithyDocumentSerde
}

// Placeholder documentation for CreateSignalMapResponse
type CreateSignalMapOutput struct {

	// A signal map's ARN (Amazon Resource Name)
	Arn *string

	// Placeholder documentation for __listOf__stringMin7Max11PatternAws097
	CloudWatchAlarmTemplateGroupIds []string

	// Placeholder documentation for __timestampIso8601
	CreatedAt *time.Time

	// A resource's optional description.
	Description *string

	// A top-level supported AWS resource ARN to discovery a signal map from.
	DiscoveryEntryPointArn *string

	// Error message associated with a failed creation or failed update attempt of a
	// signal map.
	ErrorMessage *string

	// Placeholder documentation for __listOf__stringMin7Max11PatternAws097
	EventBridgeRuleTemplateGroupIds []string

	// A map representing an incomplete AWS media workflow as a graph.
	FailedMediaResourceMap map[string]types.MediaResource

	// A signal map's id.
	Id *string

	// Placeholder documentation for __timestampIso8601
	LastDiscoveredAt *time.Time

	// Represents the latest successful monitor deployment of a signal map.
	LastSuccessfulMonitorDeployment *types.SuccessfulMonitorDeployment

	// A map representing an AWS media workflow as a graph.
	MediaResourceMap map[string]types.MediaResource

	// Placeholder documentation for __timestampIso8601
	ModifiedAt *time.Time

	// If true, there are pending monitor changes for this signal map that can be
	// deployed.
	MonitorChangesPendingDeployment *bool

	// Represents the latest monitor deployment of a signal map.
	MonitorDeployment *types.MonitorDeployment

	// A resource's name. Names must be unique within the scope of a resource type in
	// a specific region.
	Name *string

	// A signal map's current status which is dependent on its lifecycle actions or
	// associated jobs.
	Status types.SignalMapStatus

	// Represents the tags associated with a resource.
	Tags map[string]string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationCreateSignalMapMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpCreateSignalMap{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpCreateSignalMap{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "CreateSignalMap"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addIdempotencyToken_opCreateSignalMapMiddleware(stack, options); err != nil {
		return err
	}
	if err = addOpCreateSignalMapValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opCreateSignalMap(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

type idempotencyToken_initializeOpCreateSignalMap struct {
	tokenProvider IdempotencyTokenProvider
}

func (*idempotencyToken_initializeOpCreateSignalMap) ID() string {
	return "OperationIdempotencyTokenAutoFill"
}

func (m *idempotencyToken_initializeOpCreateSignalMap) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	if m.tokenProvider == nil {
		return next.HandleInitialize(ctx, in)
	}

	input, ok := in.Parameters.(*CreateSignalMapInput)
	if !ok {
		return out, metadata, fmt.Errorf("expected middleware input to be of type *CreateSignalMapInput ")
	}

	if input.RequestId == nil {
		t, err := m.tokenProvider.GetIdempotencyToken()
		if err != nil {
			return out, metadata, err
		}
		input.RequestId = &t
	}
	return next.HandleInitialize(ctx, in)
}
func addIdempotencyToken_opCreateSignalMapMiddleware(stack *middleware.Stack, cfg Options) error {
	return stack.Initialize.Add(&idempotencyToken_initializeOpCreateSignalMap{tokenProvider: cfg.IdempotencyTokenProvider}, middleware.Before)
}

func newServiceMetadataMiddleware_opCreateSignalMap(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "CreateSignalMap",
	}
}
