// Code generated by smithy-go-codegen DO NOT EDIT.

package iotfleetwise

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Updates a state template.
//
// Access to certain Amazon Web Services IoT FleetWise features is currently
// gated. For more information, see [Amazon Web Services Region and feature availability]in the Amazon Web Services IoT FleetWise
// Developer Guide.
//
// [Amazon Web Services Region and feature availability]: https://docs.aws.amazon.com/iot-fleetwise/latest/developerguide/fleetwise-regions.html
func (c *Client) UpdateStateTemplate(ctx context.Context, params *UpdateStateTemplateInput, optFns ...func(*Options)) (*UpdateStateTemplateOutput, error) {
	if params == nil {
		params = &UpdateStateTemplateInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "UpdateStateTemplate", params, optFns, c.addOperationUpdateStateTemplateMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*UpdateStateTemplateOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type UpdateStateTemplateInput struct {

	// The unique ID of the state template.
	//
	// This member is required.
	Identifier *string

	// A list of vehicle attributes to associate with the payload published on the
	// state template's MQTT topic. (See [Processing last known state vehicle data using MQTT messaging]). For example, if you add
	// Vehicle.Attributes.Make and Vehicle.Attributes.Model attributes, Amazon Web
	// Services IoT FleetWise will enrich the protobuf encoded payload with those
	// attributes in the extraDimensions field.
	//
	// Default: An empty array
	//
	// [Processing last known state vehicle data using MQTT messaging]: https://docs.aws.amazon.com/iot-fleetwise/latest/developerguide/process-visualize-data.html#process-last-known-state-vehicle-data
	DataExtraDimensions []string

	// A brief description of the state template.
	Description *string

	// A list of vehicle attributes to associate with user properties of the messages
	// published on the state template's MQTT topic. (See [Processing last known state vehicle data using MQTT messaging]). For example, if you add
	// Vehicle.Attributes.Make and Vehicle.Attributes.Model attributes, Amazon Web
	// Services IoT FleetWise will include these attributes as User Properties with the
	// MQTT message.
	//
	// [Processing last known state vehicle data using MQTT messaging]: https://docs.aws.amazon.com/iot-fleetwise/latest/developerguide/process-visualize-data.html#process-last-known-state-vehicle-data
	MetadataExtraDimensions []string

	// Add signals from which data is collected as part of the state template.
	StateTemplatePropertiesToAdd []string

	// Remove signals from which data is collected as part of the state template.
	StateTemplatePropertiesToRemove []string

	noSmithyDocumentSerde
}

type UpdateStateTemplateOutput struct {

	// The Amazon Resource Name (ARN) of the state template.
	Arn *string

	// The unique ID of the state template.
	Id *string

	// The name of the state template.
	Name *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationUpdateStateTemplateMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson10_serializeOpUpdateStateTemplate{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson10_deserializeOpUpdateStateTemplate{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "UpdateStateTemplate"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpUpdateStateTemplateValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opUpdateStateTemplate(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opUpdateStateTemplate(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "UpdateStateTemplate",
	}
}
