// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	smithydocument "github.com/aws/smithy-go/document"
	"time"
)

// A check on the environment to identify environment health and validate VMware
// VCF licensing compliance.
type Check struct {

	// The time when environment health began to be impaired.
	ImpairedSince *time.Time

	//  The check result.
	Result CheckResult

	// The check type. Amazon EVS performs the following checks.
	//
	//   - KEY_REUSE : checks that the VCF license key is not used by another Amazon
	//   EVS environment. This check fails if a used license is added to the environment.
	//
	//   - KEY_COVERAGE : checks that your VCF license key allocates sufficient vCPU
	//   cores for all deployed hosts. The check fails when any assigned hosts in the EVS
	//   environment are not covered by license keys, or when any unassigned hosts cannot
	//   be covered by available vCPU cores in keys.
	//
	//   - REACHABILITY : checks that the Amazon EVS control plane has a persistent
	//   connection to SDDC Manager. If Amazon EVS cannot reach the environment, this
	//   check fails.
	//
	//   - HOST_COUNT : Checks that your environment has a minimum of 4 hosts, which is
	//   a requirement for VCF 5.2.1.
	//
	// If this check fails, you will need to add hosts so that your environment meets
	//   this minimum requirement. Amazon EVS only supports environments with 4-16 hosts.
	Type CheckType

	noSmithyDocumentSerde
}

// The connectivity configuration for the environment. Amazon EVS requires that
// you specify two route server peer IDs. During environment creation, the route
// server endpoints peer with the NSX uplink VLAN for connectivity to the NSX
// overlay network.
type ConnectivityInfo struct {

	// The unique IDs for private route server peers.
	//
	// This member is required.
	PrivateRouteServerPeerings []string

	noSmithyDocumentSerde
}

// An object that represents an Amazon EVS environment.
type Environment struct {

	// A check on the environment to identify instance health and VMware VCF licensing
	// issues.
	Checks []Check

	// The connectivity configuration for the environment. Amazon EVS requires that
	// you specify two route server peer IDs. During environment creation, the route
	// server endpoints peer with the NSX uplink VLAN for connectivity to the NSX
	// overlay network.
	ConnectivityInfo *ConnectivityInfo

	// The date and time that the environment was created.
	CreatedAt *time.Time

	// The VCF credentials that are stored as Amazon EVS managed secrets in Amazon Web
	// Services Secrets Manager.
	//
	// Amazon EVS stores credentials that are needed to install vCenter Server, NSX,
	// and SDDC Manager.
	Credentials []Secret

	// The Amazon Resource Name (ARN) that is associated with the environment.
	EnvironmentArn *string

	// The unique ID for the environment.
	EnvironmentId *string

	// The name of the environment.
	EnvironmentName *string

	// The state of an environment.
	EnvironmentState EnvironmentState

	// Reports impaired functionality that stems from issues internal to the
	// environment, such as impaired reachability.
	EnvironmentStatus CheckResult

	// The Amazon Web Services KMS key ID that Amazon Web Services Secrets Manager
	// uses to encrypt secrets that are associated with the environment. These secrets
	// contain the VCF credentials that are needed to install vCenter Server, NSX, and
	// SDDC Manager.
	//
	// By default, Amazon EVS use the Amazon Web Services Secrets Manager managed key
	// aws/secretsmanager . You can also specify a customer managed key.
	KmsKeyId *string

	//  The license information that Amazon EVS requires to create an environment.
	// Amazon EVS requires two license keys: a VCF solution key and a vSAN license key.
	LicenseInfo []LicenseInfo

	//  The date and time that the environment was modified.
	ModifiedAt *time.Time

	// The security groups that allow traffic between the Amazon EVS control plane and
	// your VPC for service access. If a security group is not specified, Amazon EVS
	// uses the default security group in your account for service access.
	ServiceAccessSecurityGroups *ServiceAccessSecurityGroups

	//  The subnet that is used to establish connectivity between the Amazon EVS
	// control plane and VPC. Amazon EVS uses this subnet to perform validations and
	// create the environment.
	ServiceAccessSubnetId *string

	// The Broadcom Site ID that is associated with your Amazon EVS environment.
	// Amazon EVS uses the Broadcom Site ID that you provide to meet Broadcom VCF
	// license usage reporting requirements for Amazon EVS.
	SiteId *string

	// A detailed description of the environmentState of an environment.
	StateDetails *string

	// Customer confirmation that the customer has purchased and maintains sufficient
	// VCF software licenses to cover all physical processor cores in the environment,
	// in compliance with VMware's licensing requirements and terms of use.
	TermsAccepted *bool

	// The DNS hostnames to be used by the VCF management appliances in your
	// environment.
	//
	// For environment creation to be successful, each hostname entry must resolve to
	// a domain name that you've registered in your DNS service of choice and
	// configured in the DHCP option set of your VPC. DNS hostnames cannot be changed
	// after environment creation has started.
	VcfHostnames *VcfHostnames

	// The VCF version of the environment.
	VcfVersion VcfVersion

	// The VPC associated with the environment.
	VpcId *string

	noSmithyDocumentSerde
}

// A list of environments with summarized environment details.
type EnvironmentSummary struct {

	//  The date and time that the environment was created.
	CreatedAt *time.Time

	// The Amazon Resource Name (ARN) that is associated with the environment.
	EnvironmentArn *string

	// A unique ID for the environment.
	EnvironmentId *string

	//  The name of the environment.
	EnvironmentName *string

	// The state of an environment.
	EnvironmentState EnvironmentState

	// Reports impaired functionality that stems from issues internal to the
	// environment, such as impaired reachability.
	EnvironmentStatus CheckResult

	//  The date and time that the environment was modified.
	ModifiedAt *time.Time

	// The VCF version of the environment.
	VcfVersion VcfVersion

	noSmithyDocumentSerde
}

// An ESXi host that runs on an Amazon EC2 bare metal instance. Four hosts are
// created in an Amazon EVS environment during environment creation. You can add
// hosts to an environment using the CreateEnvironmentHost operation. Amazon EVS
// supports 4-16 hosts per environment.
type Host struct {

	//  The date and time that the host was created.
	CreatedAt *time.Time

	// The unique ID of the Amazon EC2 Dedicated Host.
	DedicatedHostId *string

	// The unique ID of the EC2 instance that represents the host.
	Ec2InstanceId *string

	// The DNS hostname of the host. DNS hostnames for hosts must be unique across
	// Amazon EVS environments and within VCF.
	HostName *string

	//  The state of the host.
	HostState HostState

	// The EC2 instance type of the host.
	//
	// EC2 instances created through Amazon EVS do not support associating an IAM
	// instance profile.
	InstanceType InstanceType

	// The IP address of the host.
	IpAddress *string

	// The name of the SSH key that is used to access the host.
	KeyName *string

	//  The date and time that the host was modified.
	ModifiedAt *time.Time

	// The elastic network interfaces that are attached to the host.
	NetworkInterfaces []NetworkInterface

	// The unique ID of the placement group where the host is placed.
	PlacementGroupId *string

	//  A detailed description of the hostState of a host.
	StateDetails *string

	noSmithyDocumentSerde
}

// An object that represents a host.
//
// You cannot use dedicatedHostId and placementGroupId together in the same
// HostInfoForCreate object. This results in a ValidationException response.
type HostInfoForCreate struct {

	// The DNS hostname of the host. DNS hostnames for hosts must be unique across
	// Amazon EVS environments and within VCF.
	//
	// This member is required.
	HostName *string

	// The EC2 instance type that represents the host.
	//
	// This member is required.
	InstanceType InstanceType

	// The name of the SSH key that is used to access the host.
	//
	// This member is required.
	KeyName *string

	// The unique ID of the Amazon EC2 Dedicated Host.
	DedicatedHostId *string

	// The unique ID of the placement group where the host is placed.
	PlacementGroupId *string

	noSmithyDocumentSerde
}

// An object that represents an initial VLAN subnet for the environment. Amazon
// EVS creates initial VLAN subnets when you first create the environment. You must
// specify a non-overlapping CIDR block for each VLAN subnet. Amazon EVS creates
// the following 10 VLAN subnets: host management VLAN, vMotion VLAN, vSAN VLAN,
// VTEP VLAN, Edge VTEP VLAN, Management VM VLAN, HCX uplink VLAN, NSX uplink VLAN,
// expansion VLAN 1, expansion VLAN 2.
type InitialVlanInfo struct {

	//  The CIDR block that you provide to create a VLAN subnet. VLAN CIDR blocks must
	// not overlap with other subnets in the VPC.
	//
	// This member is required.
	Cidr *string

	noSmithyDocumentSerde
}

// The initial VLAN subnets for the environment. You must specify a
// non-overlapping CIDR block for each VLAN subnet.
type InitialVlans struct {

	// The edge VTEP VLAN subnet. This VLAN subnet manages traffic flowing between the
	// internal network and external networks, including internet access and other site
	// connections.
	//
	// This member is required.
	EdgeVTep *InitialVlanInfo

	// An additional VLAN subnet that can be used to extend VCF capabilities once
	// configured. For example, you can configure an expansion VLAN subnet to use NSX
	// Federation for centralized management and synchronization of multiple NSX
	// deployments across different locations.
	//
	// This member is required.
	ExpansionVlan1 *InitialVlanInfo

	// An additional VLAN subnet that can be used to extend VCF capabilities once
	// configured. For example, you can configure an expansion VLAN subnet to use NSX
	// Federation for centralized management and synchronization of multiple NSX
	// deployments across different locations.
	//
	// This member is required.
	ExpansionVlan2 *InitialVlanInfo

	// The HCX VLAN subnet. This VLAN subnet allows the HCX Interconnnect (IX) and HCX
	// Network Extension (NE) to reach their peers and enable HCX Service Mesh
	// creation.
	//
	// This member is required.
	Hcx *InitialVlanInfo

	//  The NSX uplink VLAN subnet. This VLAN subnet allows connectivity to the NSX
	// overlay network.
	//
	// This member is required.
	NsxUplink *InitialVlanInfo

	//  The vMotion VLAN subnet. This VLAN subnet carries traffic for vSphere vMotion.
	//
	// This member is required.
	VMotion *InitialVlanInfo

	//  The vSAN VLAN subnet. This VLAN subnet carries the communication between ESXi
	// hosts to implement a vSAN shared storage pool.
	//
	// This member is required.
	VSan *InitialVlanInfo

	//  The VTEP VLAN subnet. This VLAN subnet handles internal network traffic
	// between virtual machines within a VCF instance.
	//
	// This member is required.
	VTep *InitialVlanInfo

	// The VM management VLAN subnet. This VLAN subnet carries traffic for vSphere
	// virtual machines.
	//
	// This member is required.
	VmManagement *InitialVlanInfo

	//  The VMkernel management VLAN subnet. This VLAN subnet carries traffic for
	// managing ESXi hosts and communicating with VMware vCenter Server.
	//
	// This member is required.
	VmkManagement *InitialVlanInfo

	noSmithyDocumentSerde
}

//	The license information that Amazon EVS requires to create an environment.
//
// Amazon EVS requires two license keys: a VCF solution key and a vSAN license key.
type LicenseInfo struct {

	//  The VCF solution key. This license unlocks VMware VCF product features,
	// including vSphere, NSX, SDDC Manager, and vCenter Server.
	//
	// This member is required.
	SolutionKey *string

	//  The VSAN license key. This license unlocks vSAN features.
	//
	// This member is required.
	VsanKey *string

	noSmithyDocumentSerde
}

// An elastic network interface (ENI) that connects hosts to the VLAN subnets.
// Amazon EVS provisions two identically configured ENIs in the VMkernel management
// subnet during host creation. One ENI is active, and the other is in standby mode
// for automatic switchover during a failure scenario.
type NetworkInterface struct {

	// The unique ID of the elastic network interface.
	NetworkInterfaceId *string

	noSmithyDocumentSerde
}

// A managed secret that contains the credentials for installing vCenter Server,
// NSX, and SDDC Manager. During environment creation, the Amazon EVS control plane
// uses Amazon Web Services Secrets Manager to create, encrypt, validate, and store
// secrets. If you choose to delete your environment, Amazon EVS also deletes the
// secrets that are associated with your environment. Amazon EVS does not provide
// managed rotation of secrets. We recommend that you rotate secrets regularly to
// ensure that secrets are not long-lived.
type Secret struct {

	//  The Amazon Resource Name (ARN) of the secret.
	SecretArn *string

	noSmithyDocumentSerde
}

// The security groups that allow traffic between the Amazon EVS control plane and
// your VPC for Amazon EVS service access. If a security group is not specified,
// Amazon EVS uses the default security group in your account for service access.
type ServiceAccessSecurityGroups struct {

	// The security groups that allow service access.
	SecurityGroups []string

	noSmithyDocumentSerde
}

// Stores information about a field passed inside a request that resulted in an
// exception.
type ValidationExceptionField struct {

	//  A message describing why the field failed validation.
	//
	// This member is required.
	Message *string

	//  The field name.
	//
	// This member is required.
	Name *string

	noSmithyDocumentSerde
}

// The DNS hostnames that Amazon EVS uses to install VMware vCenter Server, NSX,
// SDDC Manager, and Cloud Builder. Each hostname must be unique, and resolve to a
// domain name that you've registered in your DNS service of choice. Hostnames
// cannot be changed.
//
// VMware VCF requires the deployment of two NSX Edge nodes, and three NSX Manager
// virtual machines.
type VcfHostnames struct {

	// The hostname for VMware Cloud Builder.
	//
	// This member is required.
	CloudBuilder *string

	// The VMware NSX hostname.
	//
	// This member is required.
	Nsx *string

	// The hostname for the first NSX Edge node.
	//
	// This member is required.
	NsxEdge1 *string

	// The hostname for the second NSX Edge node.
	//
	// This member is required.
	NsxEdge2 *string

	// The hostname for the first VMware NSX Manager virtual machine (VM).
	//
	// This member is required.
	NsxManager1 *string

	// The hostname for the second VMware NSX Manager virtual machine (VM).
	//
	// This member is required.
	NsxManager2 *string

	// The hostname for the third VMware NSX Manager virtual machine (VM).
	//
	// This member is required.
	NsxManager3 *string

	// The hostname for SDDC Manager.
	//
	// This member is required.
	SddcManager *string

	// The VMware vCenter hostname.
	//
	// This member is required.
	VCenter *string

	noSmithyDocumentSerde
}

// The VLANs that Amazon EVS creates during environment creation.
type Vlan struct {

	// The availability zone of the VLAN.
	AvailabilityZone *string

	//  The CIDR block of the VLAN.
	Cidr *string

	// The date and time that the VLAN was created.
	CreatedAt *time.Time

	// The VMware VCF traffic type that is carried over the VLAN. For example, a VLAN
	// with a functionName of hcx is being used to carry VMware HCX traffic.
	FunctionName *string

	//  The date and time that the VLAN was modified.
	ModifiedAt *time.Time

	// The state details of the VLAN.
	StateDetails *string

	//  The unique ID of the VLAN subnet.
	SubnetId *string

	// The unique ID of the VLAN.
	VlanId *int32

	//  The state of the VLAN.
	VlanState VlanState

	noSmithyDocumentSerde
}

type noSmithyDocumentSerde = smithydocument.NoSerde
