// Code generated by smithy-go-codegen DO NOT EDIT.

package codepipeline

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/codepipeline/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Lists the targets for the deploy action.
func (c *Client) ListDeployActionExecutionTargets(ctx context.Context, params *ListDeployActionExecutionTargetsInput, optFns ...func(*Options)) (*ListDeployActionExecutionTargetsOutput, error) {
	if params == nil {
		params = &ListDeployActionExecutionTargetsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListDeployActionExecutionTargets", params, optFns, c.addOperationListDeployActionExecutionTargetsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListDeployActionExecutionTargetsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListDeployActionExecutionTargetsInput struct {

	// The execution ID for the deploy action.
	//
	// This member is required.
	ActionExecutionId *string

	// Filters the targets for a specified deploy action.
	Filters []types.TargetFilter

	// The maximum number of results to return in a single call. To retrieve the
	// remaining results, make another call with the returned nextToken value.
	MaxResults *int32

	// An identifier that was returned from the previous list action types call, which
	// can be used to return the next set of action types in the list.
	NextToken *string

	// The name of the pipeline with the deploy action.
	PipelineName *string

	noSmithyDocumentSerde
}

type ListDeployActionExecutionTargetsOutput struct {

	// An identifier that was returned from the previous list action types call, which
	// can be used to return the next set of action types in the list.
	NextToken *string

	// The targets for the deploy action.
	Targets []types.DeployActionExecutionTarget

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListDeployActionExecutionTargetsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpListDeployActionExecutionTargets{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpListDeployActionExecutionTargets{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListDeployActionExecutionTargets"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpListDeployActionExecutionTargetsValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListDeployActionExecutionTargets(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

// ListDeployActionExecutionTargetsPaginatorOptions is the paginator options for
// ListDeployActionExecutionTargets
type ListDeployActionExecutionTargetsPaginatorOptions struct {
	// The maximum number of results to return in a single call. To retrieve the
	// remaining results, make another call with the returned nextToken value.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListDeployActionExecutionTargetsPaginator is a paginator for
// ListDeployActionExecutionTargets
type ListDeployActionExecutionTargetsPaginator struct {
	options   ListDeployActionExecutionTargetsPaginatorOptions
	client    ListDeployActionExecutionTargetsAPIClient
	params    *ListDeployActionExecutionTargetsInput
	nextToken *string
	firstPage bool
}

// NewListDeployActionExecutionTargetsPaginator returns a new
// ListDeployActionExecutionTargetsPaginator
func NewListDeployActionExecutionTargetsPaginator(client ListDeployActionExecutionTargetsAPIClient, params *ListDeployActionExecutionTargetsInput, optFns ...func(*ListDeployActionExecutionTargetsPaginatorOptions)) *ListDeployActionExecutionTargetsPaginator {
	if params == nil {
		params = &ListDeployActionExecutionTargetsInput{}
	}

	options := ListDeployActionExecutionTargetsPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListDeployActionExecutionTargetsPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListDeployActionExecutionTargetsPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListDeployActionExecutionTargets page.
func (p *ListDeployActionExecutionTargetsPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListDeployActionExecutionTargetsOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListDeployActionExecutionTargets(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListDeployActionExecutionTargetsAPIClient is a client that implements the
// ListDeployActionExecutionTargets operation.
type ListDeployActionExecutionTargetsAPIClient interface {
	ListDeployActionExecutionTargets(context.Context, *ListDeployActionExecutionTargetsInput, ...func(*Options)) (*ListDeployActionExecutionTargetsOutput, error)
}

var _ ListDeployActionExecutionTargetsAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListDeployActionExecutionTargets(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListDeployActionExecutionTargets",
	}
}
