subroutine mrtcal_copy_command(line,error)
  use gildas_def
  use gbl_message
  use mrtcal_dependencies_interfaces
  use mrtcal_interfaces, except_this=>mrtcal_copy_command
  use mrtcal_index_vars
  !---------------------------------------------------------------------
  ! @ public
  !  Support routine for command
  !   MCOPY [IN|CURRENT] /FILE FileName
  !  Copy the named index from memory to disk
  !---------------------------------------------------------------------
  character(len=*), intent(in)    :: line
  logical,          intent(inout) :: error
  ! Local
  character(len=*), parameter :: rname='MCOPY'
  character(len=filename_length) :: file
  integer(kind=4) :: nc
  type(mrtindex_optimize_t), pointer :: optx
  character(len=12) :: optname
  integer(kind=4), parameter :: optcomm=0
  integer(kind=4), parameter :: optfile=1
  !
  call mrtcal_index_parse(rname,line,optcomm,1,optx,optname,error)
  if (error)  return
  call sic_ch(line,optfile,1,file,nc,.true.,error)
  if (error)  return
  !
  call mrtindex_copy_index(file,optx,error)
  if (error) then
    call mrtindex_message(seve%e,rname,  &
      'Error copying '//trim(optname)//' index to file '//file)
    return
  endif
  !
end subroutine mrtcal_copy_command
