!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
! Routines to manage CUBE TOOLS messages
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!
module cubetools_messaging
  use gpack_def
  use gbl_message
  use cubetools_parameters
  use cubetools_help_tool
  !
  public :: toolseve,seve,mess_l
  public :: cubetools_message_set_id,cubetools_message
  public :: cubetools_message_get_alloc,cubetools_message_set_alloc
  public :: cubetools_message_get_trace,cubetools_message_set_trace
  public :: cubetools_message_get_others,cubetools_message_set_others
  private
  !
  type :: cubetools_messaging_t
     integer(kind=code_k) :: alloc = seve%d
     integer(kind=code_k) :: trace = seve%t
     integer(kind=code_k) :: others = seve%d
     integer(kind=code_k) :: help = sevehelp
  end type cubetools_messaging_t
  type(cubetools_messaging_t) :: toolseve
  !
  ! Identifier used for message identification
  integer(kind=4) :: cubetools_message_id = gpack_global_id ! Default value for startup message
  !
contains
  !
  subroutine cubetools_message_set_id(id)
    !---------------------------------------------------------------------
    ! Alter library id into input id. Should be called by the library
    ! which wants to share its id with the current one.
    !---------------------------------------------------------------------
    integer(kind=4), intent(in) :: id
    !
    character(len=message_length) :: mess
    character(len=*), parameter :: rname='MESSAGE>SET>ID'
    !
    cubetools_message_id = id
    write (mess,'(A,I3)') 'Now use id #',cubetools_message_id
    call cubetools_message(seve%d,rname,mess)
  end subroutine cubetools_message_set_id
  !
  subroutine cubetools_message(mkind,procname,message)
    use cubetools_cmessaging
    !---------------------------------------------------------------------
    ! Messaging facility for the current library. Calls the low-level
    ! (internal) messaging routine with its own identifier.
    !---------------------------------------------------------------------
    integer(kind=4),  intent(in) :: mkind     ! Message kind
    character(len=*), intent(in) :: procname  ! Name of calling procedure
    character(len=*), intent(in) :: message   ! Message string
    !
    type(help_tool_t) :: help
    !
    if (mkind.eq.toolseve%help) then
      call help%message(cubetools_message_id,'TOOLS>'//procname,message)
    else
      call cubetools_cmessage(cubetools_message_id,mkind,'TOOLS>'//procname,message)
    endif
  end subroutine cubetools_message
  !
  subroutine cubetools_message_set_alloc(on)
    !---------------------------------------------------------------------
    ! 
    !---------------------------------------------------------------------
    logical, intent(in) :: on
    !
    if (on) then
       toolseve%alloc = seve%i
    else
       toolseve%alloc = seve%d
    endif
  end subroutine cubetools_message_set_alloc
  !
  subroutine cubetools_message_set_trace(on)
    !---------------------------------------------------------------------
    ! 
    !---------------------------------------------------------------------
    logical, intent(in) :: on
    !
    if (on) then
       toolseve%trace = seve%i
    else
       toolseve%trace = seve%t
    endif
  end subroutine cubetools_message_set_trace
  !
  subroutine cubetools_message_set_others(on)
    !---------------------------------------------------------------------
    ! 
    !---------------------------------------------------------------------
    logical, intent(in) :: on
    !
    if (on) then
       toolseve%others = seve%i
    else
       toolseve%others = seve%d
    endif
  end subroutine cubetools_message_set_others
  !
  function cubetools_message_get_alloc()
    !---------------------------------------------------------------------
    ! 
    !---------------------------------------------------------------------
    logical :: cubetools_message_get_alloc
    !
    cubetools_message_get_alloc = toolseve%alloc.eq.seve%i
  end function cubetools_message_get_alloc
  !
  function cubetools_message_get_trace()
    !---------------------------------------------------------------------
    ! 
    !---------------------------------------------------------------------
    logical :: cubetools_message_get_trace
    !
    cubetools_message_get_trace = toolseve%trace.eq.seve%i
  end function cubetools_message_get_trace
  !
  function cubetools_message_get_others()
    !---------------------------------------------------------------------
    ! 
    !---------------------------------------------------------------------
    logical :: cubetools_message_get_others
    !
    cubetools_message_get_others = toolseve%others.eq.seve%i
  end function cubetools_message_get_others
end module cubetools_messaging
!
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
