!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
! Routines to manage CUBE SYNTAX messages
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!
module cubesyntax_messaging
  use gpack_def
  use gbl_message
  use cubetools_parameters
  use cubetools_help_tool
  !
  public :: syntaxseve,seve,mess_l
  public :: cubesyntax_message_set_id,cubesyntax_message
  public :: cubesyntax_message_get_alloc,cubesyntax_message_set_alloc
  public :: cubesyntax_message_get_trace,cubesyntax_message_set_trace
  public :: cubesyntax_message_get_others,cubesyntax_message_set_others
  private
  !
  type :: cubesyntax_messaging_t
     integer(kind=code_k) :: alloc = seve%d
     integer(kind=code_k) :: trace = seve%t
     integer(kind=code_k) :: others = seve%d
     integer(kind=code_k) :: help = sevehelp
  end type cubesyntax_messaging_t
  type(cubesyntax_messaging_t) :: syntaxseve
  !
  ! Identifier used for message identification
  integer(kind=4) :: cubesyntax_message_id = gpack_global_id ! Default value for startup message
  !
contains
  !
  subroutine cubesyntax_message_set_id(id)
    !---------------------------------------------------------------------
    ! Alter library id into input id. Should be called by the library
    ! which wants to share its id with the current one.
    !---------------------------------------------------------------------
    integer(kind=4), intent(in) :: id
    !
    character(len=message_length) :: mess
    character(len=*), parameter :: rname='MESSAGE>SET>ID'
    !
    cubesyntax_message_id = id
    write (mess,'(A,I0)') 'Now use id #',cubesyntax_message_id
    call cubesyntax_message(seve%d,rname,mess)
  end subroutine cubesyntax_message_set_id
  !
  subroutine cubesyntax_message(mkind,procname,message)
    use cubetools_cmessaging
    !---------------------------------------------------------------------
    ! Messaging facility for the current library. Calls the low-level
    ! (internal) messaging routine with its own identifier.
    !---------------------------------------------------------------------
    integer(kind=4),  intent(in) :: mkind     ! Message kind
    character(len=*), intent(in) :: procname  ! Name of calling procedure
    character(len=*), intent(in) :: message   ! Message string
    !
    type(help_tool_t) :: help
    !
    if (mkind.eq.syntaxseve%help) then
      call help%message(cubesyntax_message_id,'SYNTAX>'//procname,message)
    else
      call cubetools_cmessage(cubesyntax_message_id,mkind,'SYNTAX>'//procname,message)
    endif
  end subroutine cubesyntax_message
  !
  subroutine cubesyntax_message_set_alloc(on)
    !---------------------------------------------------------------------
    ! 
    !---------------------------------------------------------------------
    logical, intent(in) :: on
    !
    if (on) then
       syntaxseve%alloc = seve%i
    else
       syntaxseve%alloc = seve%d
    endif
  end subroutine cubesyntax_message_set_alloc
  !
  subroutine cubesyntax_message_set_trace(on)
    !---------------------------------------------------------------------
    ! 
    !---------------------------------------------------------------------
    logical, intent(in) :: on
    !
    if (on) then
       syntaxseve%trace = seve%i
    else
       syntaxseve%trace = seve%t
    endif
  end subroutine cubesyntax_message_set_trace
  !
  subroutine cubesyntax_message_set_others(on)
    !---------------------------------------------------------------------
    ! 
    !---------------------------------------------------------------------
    logical, intent(in) :: on
    !
    if (on) then
       syntaxseve%others = seve%i
    else
       syntaxseve%others = seve%d
    endif
  end subroutine cubesyntax_message_set_others
  !
  function cubesyntax_message_get_alloc()
    !---------------------------------------------------------------------
    ! 
    !---------------------------------------------------------------------
    logical :: cubesyntax_message_get_alloc
    !
    cubesyntax_message_get_alloc = syntaxseve%alloc.eq.seve%i
  end function cubesyntax_message_get_alloc
  !
  function cubesyntax_message_get_trace()
    !---------------------------------------------------------------------
    ! 
    !---------------------------------------------------------------------
    logical :: cubesyntax_message_get_trace
    !
    cubesyntax_message_get_trace = syntaxseve%trace.eq.seve%i
  end function cubesyntax_message_get_trace
  !
  function cubesyntax_message_get_others()
    !---------------------------------------------------------------------
    ! 
    !---------------------------------------------------------------------
    logical :: cubesyntax_message_get_others
    !
    cubesyntax_message_get_others = syntaxseve%others.eq.seve%i
  end function cubesyntax_message_get_others
end module cubesyntax_messaging
!
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
