{-# LANGUAGE DeriveGeneric #-}

module Distribution.Simple.Build.PackageInfoModule.Z (render, Z (..)) where

import Distribution.ZinzaPrelude

data Z = Z
  { zPackageName :: String
  , zVersionDigits :: String
  , zSynopsis :: String
  , zCopyright :: String
  , zHomepage :: String
  , zSupportsNoRebindableSyntax :: Bool
  }
  deriving (Generic)

render :: Z -> String
render z_root = execWriter $ do
  if (zSupportsNoRebindableSyntax z_root)
    then do
      tell "{-# LANGUAGE NoRebindableSyntax #-}\n"
      return ()
    else do
      return ()
  tell "{-# OPTIONS_GHC -Wno-missing-import-lists #-}\n"
  tell "{-# OPTIONS_GHC -w #-}\n"
  tell "\n"
  tell "{-|\n"
  tell "Module      : PackageInfo_"
  tell (zPackageName z_root)
  tell "\n"
  tell "Description : Contents of some of the package's Cabal file's fields.\n"
  tell "\n"
  tell "WARNING: This module was generated by Cabal. Any modifications will be\n"
  tell "overwritten if the module is regenerated.\n"
  tell "\n"
  tell "This module exports values that record information from some of the fields of\n"
  tell "the package's Cabal package description file (Cabal file).\n"
  tell "\n"
  tell "For further information about the fields in a Cabal file, see the Cabal User\n"
  tell "Guide.\n"
  tell "-}\n"
  tell "\n"
  tell "module PackageInfo_"
  tell (zPackageName z_root)
  tell " (\n"
  tell "    name,\n"
  tell "    version,\n"
  tell "    synopsis,\n"
  tell "    copyright,\n"
  tell "    homepage,\n"
  tell "  ) where\n"
  tell "\n"
  tell "import Data.Version (Version(..))\n"
  tell "import Prelude\n"
  tell "\n"
  tell "-- |The content of the @name@ field of the package's Cabal file, but with any\n"
  tell "-- hyphen characters replaced by underscore characters.\n"
  tell "name :: String\n"
  tell "name = "
  tell (show $ zPackageName z_root)
  tell "\n"
  tell "-- |The content of the @version@ field of the package's Cabal file.\n"
  tell "version :: Version\n"
  tell "version = Version "
  tell (zVersionDigits z_root)
  tell " []\n"
  tell "\n"
  tell "-- |The content of the @synopsis@ field of the package's Cabal file.\n"
  tell "synopsis :: String\n"
  tell "synopsis = "
  tell (show $ zSynopsis z_root)
  tell "\n"
  tell "-- |The content of the @copyright@ field of the package's Cabal file.\n"
  tell "copyright :: String\n"
  tell "copyright = "
  tell (show $ zCopyright z_root)
  tell "\n"
  tell "-- |The content of the @homepage@ field of the package's Cabal file.\n"
  tell "homepage :: String\n"
  tell "homepage = "
  tell (show $ zHomepage z_root)
  tell "\n"
