/* Premake's Lua scripts, as static data buffers for release mode builds */
/* DO NOT EDIT - this file is autogenerated - see BUILD.txt */
/* To regenerate this file, run: premake4 embed */ 

const char* builtin_scripts[] = {
	/* base/os.lua */
	"function os.executef(cmd, ...)\nlocal arg={...}\ncmd = string.format(cmd, table.unpack(arg))\nreturn os.execute(cmd)\nend\nlocal function parse_ld_so_conf(conf_file)\nlocal first, last\nlocal dirs = { }\nlocal file = io.open(conf_file)\nif file == nil then\nreturn dirs\nend\nfor line in file:lines() do\nfirst = line:find(\"#\", 1, true)\nif first ~= nil then\nline = line:sub(1, first - 1)\nend\nif line ~= \"\" then\nfirst, last = line:find(\"include%s+\")\nif first ~= nil then\nlocal include_glob = line:sub(last + 1)\nlocal includes = os.matchfiles(include_glob)\nfor _, v in ipairs(includes) do\ndirs = table.join(dirs, parse_ld_so_conf(v))\nend\nelse\ntable.insert(dirs, line)\nend\nend\nend\nreturn dirs\nend\nfunction os.findlib(libname)\nlocal path, formats\nif os.is(\"windows\") then\nformats = { \"%s.dll\", \"%s\" }\npath = os.getenv(\"PATH\")\nelse\nif os.is(\"macosx\") then\nformats = { \"lib%s.dylib\", \"%s.dylib\" }\npath = os.getenv(\"DYLD_LIBRARY_PATH\")\nelse\nformats = { \"lib%s.so\", \"%s.so\" }\np"
	"ath = os.getenv(\"LD_LIBRARY_PATH\") or \"\"\nfor _, v in ipairs(parse_ld_so_conf(\"/etc/ld.so.conf\")) do\npath = path .. \":\" .. v\nend\nend\ntable.insert(formats, \"%s\")\npath = path or \"\"\nif os.is64bit() then\npath = path .. \":/lib64:/usr/lib64/:usr/local/lib64\"\nend\npath = path .. \":/lib:/usr/lib:/usr/local/lib\"\nend\nfor _, fmt in ipairs(formats) do\nlocal name = string.format(fmt, libname)\nlocal result = os.pathsearch(name, path)\nif result then return result end\nend\nend\nfunction os.get()\nreturn _OPTIONS.os or _OS\nend\nfunction os.is(id)\nreturn (os.get():lower() == id:lower())\nend\nlocal _64BitHostTypes = {\n\"x86_64\",\n\"ia64\",\n\"amd64\",\n\"ppc64\",\n\"powerpc64\",\n\"sparc64\",\n\"arm64\"\n}\nfunction os.is64bit()\nif (os._is64bit()) then\nreturn true\nend\nlocal arch = \"\"\nif _OS == \"windows\" then\narch = os.getenv(\"PROCESSOR_ARCHITECTURE\")\nelseif _OS == \"macosx\" then\narch = os.outputof(\"echo $HOSTTYPE\")\nelse\narch = os.outputof(\"uname -m\")\nend\nif nil ~= arch th"
	"en\narch = arch:lower()\nfor _, hosttype in ipairs(_64BitHostTypes) do\nif arch:find(hosttype) then\nreturn true\nend\nend\nend\nreturn false\nend\nlocal function domatch(result, mask, wantfiles)\nif mask:startswith(\"./\") then\nmask = mask:sub(3)\nend\nlocal basedir = mask\nlocal starpos = mask:find(\"%*\")\nif starpos then\nbasedir = basedir:sub(1, starpos - 1)\nend\nbasedir = path.getdirectory(basedir)\nif (basedir == \".\") then basedir = \"\" end\nlocal recurse = mask:find(\"**\", nil, true)\nmask = path.wildcards(mask)\nlocal function matchwalker(basedir)\nlocal wildcard = path.join(basedir, \"*\")\nlocal m = os.matchstart(wildcard)\nwhile (os.matchnext(m)) do\nlocal isfile = os.matchisfile(m)\nif ((wantfiles and isfile) or (not wantfiles and not isfile)) then\nlocal fname = path.join(basedir, os.matchname(m))\nif fname:match(mask) == fname then\ntable.insert(result, fname)\nend\nend\nend\nos.matchdone(m)\nif recurse then\nm = os.matchstart(wildcard)\nwhile (os.matchnext(m)) do\nif not os.matchisfile(m)"
	" then\nlocal dirname = os.matchname(m)\nmatchwalker(path.join(basedir, dirname))\nend\nend\nos.matchdone(m)\nend\nend\nmatchwalker(basedir)\nend\nfunction os.matchdirs(...)\nlocal arg={...}\nlocal result = { }\nfor _, mask in ipairs(arg) do\ndomatch(result, mask, false)\nend\nreturn result\nend\nfunction os.matchfiles(...)\nlocal arg={...}\nlocal result = { }\nfor _, mask in ipairs(arg) do\ndomatch(result, mask, true)\nend\nreturn result\nend\nlocal builtin_mkdir = os.mkdir\nfunction os.mkdir(p)\nlocal dir = iif(p:startswith(\"/\"), \"/\", \"\")\nfor part in p:gmatch(\"[^/]+\") do\ndir = dir .. part\nif (part ~= \"\" and not path.isabsolute(part) and not os.isdir(dir)) then\nlocal ok, err = builtin_mkdir(dir)\nif (not ok) then\nreturn nil, err\nend\nend\ndir = dir .. \"/\"\nend\nreturn true\nend\nfunction os.outputof(cmd)\nlocal pipe = io.popen(cmd)\nlocal result = pipe:read('*a')\npipe:close()\nreturn result\nend\nlocal builtin_rmdir = os.rmdir\nfunction os.rmdir(p)\nlocal dirs = os.matchdirs(p .. \"/*\")\nfo"
	"r _, dname in ipairs(dirs) do\nos.rmdir(dname)\nend\nlocal files = os.matchfiles(p .. \"/*\")\nfor _, fname in ipairs(files) do\nos.remove(fname)\nend\nbuiltin_rmdir(p)\nend\n",

	/* base/path.lua */
	"function path.getbasename(p)\nlocal name = path.getname(p)\nlocal i = name:findlast(\".\", true)\nif (i) then\nreturn name:sub(1, i - 1)\nelse\nreturn name\nend\nend\nfunction path.removeext(name)\nlocal i = name:findlast(\".\", true)\nif (i) then\nreturn name:sub(1, i - 1)\nelse\nreturn name\nend\nend\nfunction path.getdirectory(p)\nlocal i = p:findlast(\"/\", true)\nif (i) then\nif i > 1 then i = i - 1 end\nreturn p:sub(1, i)\nelse\nreturn \".\"\nend\nend\nfunction path.getdrive(p)\nlocal ch1 = p:sub(1,1)\nlocal ch2 = p:sub(2,2)\nif ch2 == \":\" then\nreturn ch1\nend\nend\nfunction path.getextension(p)\nlocal i = p:findlast(\".\", true)\nif (i) then\nreturn p:sub(i)\nelse\nreturn \"\"\nend\nend\nfunction path.getname(p)\nlocal i = p:findlast(\"[/\\\\]\")\nif (i) then\nreturn p:sub(i + 1)\nelse\nreturn p\nend\nend\nfunction path.getcommonbasedir(a, b)\na = path.getdirectory(a)..'/'\nb = path.getdirectory(b)..'/'\nlocal idx = 0\nwhile (true) do\nlocal tst = a:find('/', idx + 1, true)\nif tst then\nif a:sub(1,t"
	"st) == b:sub(1,tst) then\nidx = tst\nelse\nbreak\nend\nelse\nbreak\nend\nend\nlocal result = ''\nif idx > 1 then\nresult = a:sub(1, idx - 1)-- Remove the trailing slash to be consistent with other functions.\nend\nreturn result\nend\nfunction path.hasextension(fname, extensions)\nlocal fext = path.getextension(fname):lower()\nif type(extensions) == \"table\" then\nfor _, extension in pairs(extensions) do\nif fext == extension then\nreturn true\nend\nend\nreturn false\nelse\nreturn (fext == extensions)\nend\nend\nfunction path.iscfile(fname)\nreturn path.hasextension(fname, { \".c\", \".m\" })\nend\nfunction path.iscppfile(fname)\nreturn path.hasextension(fname, { \".cc\", \".cpp\", \".cxx\", \".c++\", \".c\", \".m\", \".mm\" })\nend\nfunction path.iscxfile(fname)\nreturn path.hasextension(fname, \".cx\")\nend\nfunction path.isobjcfile(fname)\nreturn path.hasextension(fname, { \".m\", \".mm\" })\nend\nfunction path.iscppheader(fname)\nreturn path.hasextension(fname, { \".h\", \".hh\", \".hpp\", \".hxx\" })\nend"
	"\nfunction path.iscppmodule(fname)\nreturn path.hasextension(fname, { \".ixx\", \".cppm\" })\nend\nfunction path.isappxmanifest(fname)\nreturn path.hasextension(fname, \".appxmanifest\")\nend\nfunction path.isandroidbuildfile(fname)\nreturn path.getname(fname) == \"AndroidManifest.xml\"\nend\nfunction path.isnatvis(fname)\nreturn path.hasextension(fname, \".natvis\")\nend\nfunction path.isasmfile(fname)\nreturn path.hasextension(fname, { \".asm\", \".s\", \".S\" })\nend\nfunction path.isvalafile(fname)\nreturn path.hasextension(fname, \".vala\")\nend\nfunction path.isgresource(fname)\nlocal ending = \".gresource.xml\"\nreturn ending == \"\" or fname:sub(-#ending) == ending\nend\nfunction path.isswiftfile(fname)\nreturn path.hasextension(fname, \".swift\")\nend\nfunction path.issourcefile(fname)\nreturn path.iscfile(fname)\nor path.iscppfile(fname)\nor path.iscxfile(fname)\nor path.isasmfile(fname)\nor path.isvalafile(fname)\nor path.isswiftfile(fname)\nend\nfunction path.issourcefilevs(fname)\nreturn path.hase"
	"xtension(fname, { \".cc\", \".cpp\", \".cxx\", \".c++\", \".c\" })\nor path.iscxfile(fname)\nor path.iscppmodule(fname)\nend\nfunction path.isobjectfile(fname)\nreturn path.hasextension(fname, { \".o\", \".obj\" })\nend\nfunction path.isresourcefile(fname)\nreturn path.hasextension(fname, \".rc\")\nend\nfunction path.isimagefile(fname)\nlocal extensions = { \".png\" }\nlocal ext = path.getextension(fname):lower()\nreturn table.contains(extensions, ext)\nend\nfunction path.join(...)\nlocal arg={...}\nlocal numargs = select(\"#\", ...)\nif numargs == 0 then\nreturn \"\";\nend\nlocal allparts = {}\nfor i = numargs, 1, -1 do\nlocal part = select(i, ...)\nif part and #part > 0 and part ~= \".\" then\nwhile part:endswith(\"/\") do\npart = part:sub(1, -2)\nend\ntable.insert(allparts, 1, part)\nif path.isabsolute(part) then\nbreak\nend\nend\nend\nreturn table.concat(allparts, \"/\")\nend\nfunction path.rebase(p, oldbase, newbase)\np = path.getabsolute(path.join(oldbase, p))\np = path.getrelative(newbase, p)\nreturn p"
	"\nend\nfunction path.translate(p, sep)\nif (type(p) == \"table\") then\nlocal result = { }\nfor _, value in ipairs(p) do\ntable.insert(result, path.translate(value))\nend\nreturn result\nelse\nif (not sep) then\nif (os.is(\"windows\")) then\nsep = \"\\\\\"\nelse\nsep = \"/\"\nend\nend\nlocal result = p:gsub(\"[/\\\\]\", sep)\nreturn result\nend\nend\nfunction path.wildcards(pattern)\npattern = pattern:gsub(\"([%+%.%-%^%$%(%)%%])\", \"%%%1\")\npattern = pattern:gsub(\"%*%*\", \"\\001\")\npattern = pattern:gsub(\"%*\", \"\\002\")\npattern = pattern:gsub(\"\\001\", \".*\")\npattern = pattern:gsub(\"\\002\", \"[^/]*\")\nreturn pattern\nend\nfunction path.trimdots(p)\nlocal changed\nrepeat\nchanged = true\nif p:startswith(\"./\") then\np = p:sub(3)\nelseif p:startswith(\"../\") then\np = p:sub(4)\nelse\nchanged = false\nend\nuntil not changed\nreturn p\nend\nfunction path.rebase(p, oldbase, newbase)\np = path.getabsolute(path.join(oldbase, p))\np = path.getrelative(newbase, p)\nreturn p\nend\nfunction path.replacee"
	"xtension(p, newext)\nlocal ext = path.getextension(p)\nif not ext then\nreturn p\nend\nif #newext > 0 and not newext:findlast(\".\", true) then\nnewext = \".\"..newext\nend\nreturn p:match(\"^(.*)\"..ext..\"$\")..newext\nend\n",

	/* base/string.lua */
	"function string.explode(s, pattern, plain)\nif (pattern == '') then return false end\nlocal pos = 0\nlocal arr = { }\nfor st,sp in function() return s:find(pattern, pos, plain) end do\ntable.insert(arr, s:sub(pos, st-1))\npos = sp + 1\nend\ntable.insert(arr, s:sub(pos))\nreturn arr\nend\nfunction string.findlast(s, pattern, plain)\nlocal curr = 0\nlocal term = nil\nrepeat\nlocal next, nextterm = s:find(pattern, curr + 1, plain)\nif (next) then\ncurr = next\nterm = nextterm\nend\nuntil (not next)\nif (curr > 0) then\nreturn curr, term\nend\nend\nfunction string.startswith(haystack, needle)\nreturn (haystack:find(needle, 1, true) == 1)\nend\nfunction string.trim(s)\nreturn (s:gsub(\"^%s*(.-)%s*$\", \"%1\"))\nend\n",

	/* base/table.lua */
	"function table.contains(t, value)\nfor _, v in pairs(t) do\nif v == value then return true end\nend\nreturn false\nend\nfunction table.icontains(t, value)\nfor _, v in ipairs(t) do\nif v == value then return true end\nend\nreturn false\nend\nfunction table.deepcopy(object)\nlocal seen = {}\nlocal function copy(object)\nif type(object) ~= \"table\" then\nreturn object\nelseif seen[object] then\nreturn seen[object]\nend\nlocal clone = {}\nseen[object] = clone\nfor key, value in pairs(object) do\nclone[key] = copy(value)\nend\nsetmetatable(clone, getmetatable(object))\nreturn clone\nend\nreturn copy(object)\nend\nfunction table.extract(arr, fname)\nlocal result = { }\nfor _,v in ipairs(arr) do\ntable.insert(result, v[fname])\nend\nreturn result\nend\nfunction table.flatten(arr)\nlocal result = { }\nlocal function flatten(arr)\nfor _, v in ipairs(arr) do\nif type(v) == \"table\" then\nflatten(v)\nelse\ntable.insert(result, v)\nend\nend\nend\nflatten(arr)\nreturn result\nend\nfunction table.implode(arr, before, aft"
	"er, between)\nlocal result = \"\"\nfor _,v in ipairs(arr) do\nif (result ~= \"\" and between) then\nresult = result .. between\nend\nresult = result .. before .. v .. after\nend\nreturn result\nend\nfunction table.insertflat(tbl, values)\nif type(values) == \"table\" then\nfor _, value in ipairs(values) do\ntable.insertflat(tbl, value)\nend\nelse\ntable.insert(tbl, values)\nend\nend\nfunction table.isempty(t)\nreturn next(t) == nil\nend\nfunction table.join(...)\nlocal arg={...}\nlocal result = { }\nfor _,t in ipairs(arg) do\nif type(t) == \"table\" then\nfor _,v in ipairs(t) do\ntable.insert(result, v)\nend\nelse\ntable.insert(result, t)\nend\nend\nreturn result\nend\nfunction table.keys(tbl)\nlocal keys = {}\nfor k, _ in pairs(tbl) do\ntable.insert(keys, k)\nend\nreturn keys\nend\nfunction table.sortedpairs(t)\nlocal keys = table.keys(t)\nlocal i = 0\ntable.sort(keys)\nreturn function()\ni = i + 1\nif keys[i] == nil then\nreturn nil\nend\nreturn keys[i], t[keys[i]]\nend\nend\nfunction table.merge(...)\nlocal"
	" arg={...}\nlocal result = { }\nfor _,t in ipairs(arg) do\nif type(t) == \"table\" then\nfor k,v in pairs(t) do\nresult[k] = v\nend\nelse\nerror(\"invalid value\")\nend\nend\nreturn result\nend\nfunction table.translate(arr, translation)\nlocal result = { }\nfor _, value in ipairs(arr) do\nlocal tvalue\nif type(translation) == \"function\" then\ntvalue = translation(value)\nelse\ntvalue = translation[value]\nend\nif (tvalue) then\ntable.insert(result, tvalue)\nend\nend\nreturn result\nend\nfunction table.reverse(arr)\nfor i=1, math.floor(#arr / 2) do\narr[i], arr[#arr - i + 1] = arr[#arr - i + 1], arr[i]\nend\nreturn arr\nend\nfunction table.arglist(arg, value)\nif #value > 0 then\nlocal args = {}\nfor _, val in ipairs(value) do\ntable.insert(args, string.format(\"%s %s\", arg, val))\nend\nreturn table.concat(args, \" \")\nelse\nreturn \"\"\nend\nend\n",

	/* base/io.lua */
	"io.eol         = \"\\n\"\nio.indent      = \"\\t\"\nio.indentLevel = 0\nlocal function _escaper(v) return v end\n_esc = _escaper\nfunction io.capture()\nlocal prev = io.captured\nio.captured = ''\nreturn prev\nend\nfunction io.endcapture(restore)\nlocal captured = io.captured\nio.captured = restore\nreturn captured\nend\nlocal builtin_open = io.open\nfunction io.open(fname, mode)\nif (mode) then\nif (mode:find(\"w\")) then\nlocal dir = path.getdirectory(fname)\nok, err = os.mkdir(dir)\nif (not ok) then\nerror(err, 0)\nend\nend\nend\nreturn builtin_open(fname, mode)\nend\nfunction io.printf(msg, ...)\nlocal arg={...}\nif not io.eol then\nio.eol = \"\\n\"\nend\nif not io.indent then\nio.indent = \"\\t\"\nend\nif type(msg) == \"number\" then\ns = string.rep(io.indent, msg) .. string.format(table.unpack(arg))\nelse\ns = string.format(msg, table.unpack(arg))\nend\nif io.captured then\nio.captured = io.captured .. s .. io.eol\nelse\nio.write(s)\nio.write(io.eol)\nend\nend\nfunction io.xprintf(msg, ...)\nlocal arg = "
	"{...}\nfor i = 1, #arg do\narg[i] = io.esc(arg[i])\nend\nio.printf(msg, unpack(arg))\nend\nfunction io.esc(value)\nif type(value) == \"table\" then\nlocal result = {}\nlocal n = #value\nfor i = 1, n do\ntable.insert(result, io.esc(value[i]))\nend\nreturn result\nend\nreturn _esc(value or \"\")\nend\nfunction io.escaper(func)\n_esc = func or _escaper\nend\n_p = io.printf\n_x = io.xprintf\n",

	/* base/globals.lua */
	"premake = { }\npremake.platforms =\n{\nNative =\n{\ncfgsuffix       = \"\",\n},\nx32 =\n{\ncfgsuffix       = \"32\",\n},\nx64 =\n{\ncfgsuffix       = \"64\",\n},\nUniversal =\n{\ncfgsuffix       = \"univ\",\n},\nUniversal32 =\n{\ncfgsuffix       = \"univ32\",\n},\nUniversal64 =\n{\ncfgsuffix       = \"univ64\",\n},\nPS3 =\n{\ncfgsuffix       = \"ps3\",\niscrosscompiler = true,\nnosharedlibs    = true,\nnamestyle       = \"PS3\",\n},\nWiiDev =\n{\ncfgsuffix       = \"wii\",\niscrosscompiler = true,\nnamestyle       = \"PS3\",\n},\nXbox360 =\n{\ncfgsuffix       = \"xbox360\",\niscrosscompiler = true,\nnamestyle       = \"windows\",\n},\nPowerPC =\n{\ncfgsuffix       = \"ppc\",\niscrosscompiler = true,\n},\nARM =\n{\ncfgsuffix       = \"ARM\",\niscrosscompiler = true,\n},\nARM64 =\n{\ncfgsuffix       = \"ARM64\",\niscrosscompiler = true,\n},\nOrbis =\n{\ncfgsuffix       = \"orbis\",\niscrosscompiler = true,\nnamestyle       = \"Orbis\",\n},\nDurango =\n{\ncfgsuffix       = \"durango\",\niscrosscompiler = true,\nn"
	"osharedlibs    = true,\nnamestyle       = \"windows\",\n},\nTegraAndroid =\n{\ncfgsuffix       = \"tegraandroid\",\niscrosscompiler = true,\nnamestyle       = \"TegraAndroid\",\n},\nNX32 =\n{\ncfgsuffix       = \"nx32\",\niscrosscompiler = true,\nnamestyle       = \"NX\",\n},\nNX64 =\n{\ncfgsuffix       = \"nx64\",\niscrosscompiler = true,\nnamestyle       = \"NX\",\n},\nEmscripten =\n{\ncfgsuffix       = \"emscripten\",\niscrosscompiler = true,\nnosharedlibs    = true,\nnamestyle       = \"Emscripten\",\n},\n[\"gdk-desktop\"] =\n{\ncfgsuffix       = \"gdk-desktop\",\nnamestyle       = \"windows\",\n},\n[\"gdk-xboxone\"] =\n{\ncfgsuffix       = \"gdk-xboxone\",\nnamestyle       = \"windows\",\n},\n[\"gdk-scarlett\"] =\n{\ncfgsuffix       = \"gdk-scarlett\",\nnamestyle       = \"windows\",\n},\n}\nlocal builtin_dofile = dofile\nfunction dofile(fname)\nlocal oldcwd = os.getcwd()\nlocal oldfile = _SCRIPT\nif (not os.isfile(fname)) then\nlocal path = os.pathsearch(fname, _OPTIONS[\"scripts\"], os.getenv(\"PREMAKE_"
	"PATH\"))\nif (path) then\nfname = path..\"/\"..fname\nend\nend\n_SCRIPT = path.getabsolute(fname)\nlocal newcwd = path.getdirectory(_SCRIPT)\nos.chdir(newcwd)\nlocal a, b, c, d, e, f = builtin_dofile(_SCRIPT)\n_SCRIPT = oldfile\nos.chdir(oldcwd)\nreturn a, b, c, d, e, f\nend\nfunction iif(expr, trueval, falseval)\nif (expr) then\nreturn trueval\nelse\nreturn falseval\nend\nend\nfunction include(fname)\nlocal dir, name = premake.findDefaultScript(fname, false)\nif dir ~= nil then\nreturn dofile(dir .. \"/\" .. name)\nend\nreturn nil\nend\nfunction printf(msg, ...)\nlocal arg={...}\nprint(string.format(msg, table.unpack(arg)))\nend\nfunction typex(t)\nlocal mt = getmetatable(t)\nif (mt) then\nif (mt.__type) then\nreturn mt.__type\nend\nend\nreturn type(t)\nend\n",

	/* base/action.lua */
	"premake.action = { }\npremake.action.list = { }\nfunction premake.action.add(a)\nlocal missing\nfor _, field in ipairs({\"description\", \"trigger\"}) do\nif (not a[field]) then\nmissing = field\nend\nend\nif (missing) then\nerror(\"action needs a \" .. missing, 3)\nend\npremake.action.list[a.trigger] = a\nend\nfunction premake.action.call(name)\nlocal a = premake.action.list[name]\nfor sln in premake.solution.each() do\nif a.onsolution then\na.onsolution(sln)\nend\nif sln.postsolutioncallbacks then\nfor _,cb in ipairs(sln.postsolutioncallbacks) do\ncb(sln)\nend\nend\nfor prj in premake.solution.eachproject(sln) do\nif a.onproject then\na.onproject(prj)\nend\nif prj.postprojectcallbacks then\nfor _,cb in ipairs(prj.postprojectcallbacks) do\ncb(prj)\nend\nend\nend\nend\nif a.execute then\na.execute()\nend\nend\nfunction premake.action.current()\nreturn premake.action.get(_ACTION)\nend\nfunction premake.action.get(name)\nreturn premake.action.list[name]\nend\nfunction premake.action.each()\nlocal keys = { }\nfor"
	" _, action in pairs(premake.action.list) do\ntable.insert(keys, action.trigger)\nend\ntable.sort(keys)\nlocal i = 0\nreturn function()\ni = i + 1\nreturn premake.action.list[keys[i]]\nend\nend\nfunction premake.action.set(name)\n_ACTION = name\nlocal action = premake.action.get(name)\nif action then\n_OS = action.os or _OS\nend\nend\nfunction premake.action.supports(action, feature)\nif not action then\nreturn false\nend\nif action.valid_languages then\nif table.contains(action.valid_languages, feature) then\nreturn true\nend\nend\nif action.valid_kinds then\nif table.contains(action.valid_kinds, feature) then\nreturn true\nend\nend\nreturn false\nend\n",

	/* base/option.lua */
	"premake.option = { }\npremake.option.list = { }\nfunction premake.option.add(opt)\nlocal missing\nfor _, field in ipairs({ \"description\", \"trigger\" }) do\nif (not opt[field]) then\nmissing = field\nend\nend\nif (missing) then\nerror(\"option needs a \" .. missing, 3)\nend\npremake.option.list[opt.trigger] = opt\nend\nfunction premake.option.get(name)\nreturn premake.option.list[name]\nend\nfunction premake.option.each()\nlocal keys = { }\nfor _, option in pairs(premake.option.list) do\ntable.insert(keys, option.trigger)\nend\ntable.sort(keys)\nlocal i = 0\nreturn function()\ni = i + 1\nreturn premake.option.list[keys[i]]\nend\nend\nfunction premake.option.validate(values)\nfor key, value in pairs(values) do\nlocal opt = premake.option.get(key)\nif (not opt) then\nreturn false, \"invalid option '\" .. key .. \"'\"\nend\nif (opt.value and value == \"\") then\nreturn false, \"no value specified for option '\" .. key .. \"'\"\nend\nif opt.allowed then\nlocal found = false\nfor _, match in ipairs(opt.allowed) d"
	"o\nif match[1] == value then\nfound = true\nbreak\nend\nend\nif not found then\nreturn false, string.format(\"invalid value '%s' for option '%s'\", value, key)\nend\nend\nend\nreturn true\nend\n",

	/* base/tree.lua */
	"premake.tree = { }\nlocal tree = premake.tree\nfunction premake.tree.new(n)\nlocal t = {\nname = n,\nchildren = { }\n}\nreturn t\nend\nfunction premake.tree.add(tr, p, onaddfunc)\nif p == \".\" then\nreturn tr\nend\nif p == \"/\" then\nreturn tr\nend\nlocal parentnode = tree.add(tr, path.getdirectory(p), onaddfunc)\nlocal childname = path.getname(p)\nif childname == \"..\" then\nreturn parentnode\nend\nlocal childnode = parentnode.children[childname]\nif not childnode or childnode.path ~= p then\nchildnode = tree.insert(parentnode, tree.new(childname))\nchildnode.path = p\nif onaddfunc then\nonaddfunc(childnode)\nend\nend\nreturn childnode\nend\nfunction premake.tree.insert(parent, child)\ntable.insert(parent.children, child)\nif child.name then\nparent.children[child.name] = child\nend\nchild.parent = parent\nreturn child\nend\nfunction premake.tree.getlocalpath(node)\nif node.parent.path then\nreturn node.name\nelseif node.cfg then\nreturn node.cfg.name\nelse\nreturn node.path\nend\nend\nfunction premake.tre"
	"e.remove(node)\nlocal children = node.parent.children\nfor i = 1, #children do\nif children[i] == node then\ntable.remove(children, i)\nend\nend\nnode.children = {}\nend\nfunction premake.tree.sort(tr)\ntree.traverse(tr, {\nonnode = function(node)\ntable.sort(node.children, function(a,b)\nreturn a.name < b.name\nend)\nend\n}, true)\nend\nfunction premake.tree.traverse(t, fn, includeroot, initialdepth)\nlocal donode, dochildren\ndonode = function(node, fn, depth)\nif node.isremoved then\nreturn\nend\nif fn.onnode then\nfn.onnode(node, depth)\nend\nif #node.children > 0 then\nif fn.onbranchenter then\nfn.onbranchenter(node, depth)\nend\nif fn.onbranch then\nfn.onbranch(node, depth)\nend\ndochildren(node, fn, depth + 1)\nif fn.onbranchexit then\nfn.onbranchexit(node, depth)\nend\nelse\nif fn.onleaf then\nfn.onleaf(node, depth)\nend\nend\nend\ndochildren = function(parent, fn, depth)\nlocal i = 1\nwhile i <= #parent.children do\nlocal node = parent.children[i]\ndonode(node, fn, depth)\nif node == parent.children[i"
	"] then\ni = i + 1\nend\nend\nend\nif not initialdepth then\ninitialdepth = 0\nend\nif includeroot then\ndonode(t, fn, initialdepth)\nelse\ndochildren(t, fn, initialdepth)\nend\nend\n",

	/* base/solution.lua */
	"premake.solution = { }\npremake.solution.list = { }\nfunction premake.solution.new(name)\nlocal sln = { }\ntable.insert(premake.solution.list, sln)\npremake.solution.list[name] = sln\nsetmetatable(sln, { __type=\"solution\" })\nsln.name           = name\nsln.basedir        = os.getcwd()\nsln.projects       = { }\nsln.blocks         = { }\nsln.configurations = { }\nsln.groups         = { }\nsln.importedprojects = { }\nreturn sln\nend\nfunction premake.solution.each()\nlocal i = 0\nreturn function ()\ni = i + 1\nif i <= #premake.solution.list then\nreturn premake.solution.list[i]\nend\nend\nend\nfunction premake.solution.eachproject(sln)\nlocal i = 0\nreturn function ()\ni = i + 1\nif (i <= #sln.projects) then\nreturn premake.solution.getproject(sln, i)\nend\nend\nend\nfunction premake.solution.eachgroup(sln)\nlocal i = 0\nreturn function()\ni = i + 1\nif(i <= #sln.groups) then\nreturn premake.solution.getgroup(sln, i)\nend\nend\nend\nfunction premake.solution.get(key)\nreturn premake.solution.list[key]\nend\nfu"
	"nction premake.solution.getproject(sln, idx)\nlocal prj = sln.projects[idx]\nlocal cfg = premake.getconfig(prj)\ncfg.name = prj.name\nreturn cfg\nend\nfunction premake.solution.getgroup(sln, idx)\nlocal grp = sln.groups[idx]\nreturn grp\nend",

	/* base/project.lua */
	"premake.project = { }\nfunction premake.project.buildsourcetree(prj, allfiles)\nlocal tr = premake.tree.new(prj.name)\ntr.project = prj\nlocal isvpath\nlocal function onadd(node)\nnode.isvpath = isvpath\nend\nfor fcfg in premake.project.eachfile(prj, allfiles) do\nisvpath = (fcfg.name ~= fcfg.vpath)\nlocal node = premake.tree.add(tr, fcfg.vpath, onadd)\nnode.cfg = fcfg\nend\npremake.tree.sort(tr)\nreturn tr\nend\nfunction premake.eachconfig(prj, platform)\nif prj.project then prj = prj.project end\nlocal cfgs = prj.solution.configurations\nlocal i = 0\nreturn function ()\ni = i + 1\nif i <= #cfgs then\nreturn premake.getconfig(prj, cfgs[i], platform)\nend\nend\nend\nfunction premake.project.eachfile(prj, allfiles)\nif not prj.project then prj = premake.getconfig(prj) end\nlocal i = 0\nlocal t = iif(allfiles, prj.allfiles, prj.files)\nlocal c = iif(allfiles, prj.__allfileconfigs, prj.__fileconfigs)\nreturn function ()\ni = i + 1\nif (i <= #t) then\nlocal fcfg = c[t[i]]\nfcfg.vpath = premake.project.getvpath(prj"
	", fcfg.name)\nreturn fcfg\nend\nend\nend\nfunction premake.esc(value)\nif (type(value) == \"table\") then\nlocal result = { }\nfor _,v in ipairs(value) do\ntable.insert(result, premake.esc(v))\nend\nreturn result\nelse\nvalue = value:gsub('&',  \"&amp;\")\nvalue = value:gsub('\"',  \"&quot;\")\nvalue = value:gsub(\"'\",  \"&apos;\")\nvalue = value:gsub('<',  \"&lt;\")\nvalue = value:gsub('>',  \"&gt;\")\nvalue = value:gsub('\\r', \"&#x0D;\")\nvalue = value:gsub('\\n', \"&#x0A;\")\nreturn value\nend\nend\nfunction premake.filterplatforms(sln, map, default)\nlocal result = { }\nlocal keys = { }\nif sln.platforms then\nfor _, p in ipairs(sln.platforms) do\nif map[p] and not table.contains(keys, map[p]) then\ntable.insert(result, p)\ntable.insert(keys, map[p])\nend\nend\nend\nif #result == 0 and default then\ntable.insert(result, default)\nend\nreturn result\nend\nfunction premake.findproject(name)\nfor sln in premake.solution.each() do\nfor prj in premake.solution.eachproject(sln) do\nif (prj.name == name) then\n"
	"return  prj\nend\nend\nend\nend\nfunction premake.findfile(prj, extension)\nfor _, fname in ipairs(prj.files) do\nif fname:endswith(extension) then return fname end\nend\nend\nfunction premake.getconfig(prj, cfgname, pltname)\nprj = prj.project or prj\nif pltname == \"Native\" or not table.contains(prj.solution.platforms or {}, pltname) then\npltname = nil\nend\nlocal key = (cfgname or \"\")\nif pltname then key = key .. pltname end\nreturn prj.__configs[key]\nend\nfunction premake.getconfigname(cfgname, platform, useshortname)\nif cfgname then\nlocal name = cfgname\nif platform and platform ~= \"Native\" then\nif useshortname then\nname = name .. premake.platforms[platform].cfgsuffix\nelse\nname = name .. \"|\" .. platform\nend\nend\nreturn iif(useshortname, name:lower(), name)\nend\nend\nfunction premake.getdependencies(prj)\nprj = prj.project or prj\nlocal results = { }\nfor _, cfg in pairs(prj.__configs) do\nfor _, link in ipairs(cfg.links) do\nlocal dep = premake.findproject(link)\nif dep and not table.co"
	"ntains(results, dep) then\ntable.insert(results, dep)\nend\nend\nend\nreturn results\nend\nfunction premake.project.getbasename(prjname, pattern)\nreturn pattern:gsub(\"%%%%\", prjname)\nend\nfunction premake.project.getfilename(prj, pattern)\nlocal fname = premake.project.getbasename(prj.name, pattern)\nfname = path.join(prj.location, fname)\nreturn path.getrelative(os.getcwd(), fname)\nend\n function premake.getlinks(cfg, kind, part)\nlocal result = iif (part == \"directory\" and kind == \"all\", cfg.libdirs, {})\nlocal cfgname = iif(cfg.name == cfg.project.name, \"\", cfg.name)\nlocal pathstyle = premake.getpathstyle(cfg)\nlocal namestyle = premake.getnamestyle(cfg)\nlocal function canlink(source, target)\nif (target.kind ~= \"SharedLib\" and target.kind ~= \"StaticLib\") then\nreturn false\nend\nif premake.iscppproject(source) then\nreturn premake.iscppproject(target)\nelseif premake.isdotnetproject(source) then\nreturn premake.isdotnetproject(target)\nelseif premake.isswiftproject(source) then\nreturn pre"
	"make.isswiftproject(source) or premake.iscppproject(source)\nend\nend\nfor _, link in ipairs(cfg.links) do\nlocal item\nlocal prj = premake.findproject(link)\nif prj and kind ~= \"system\" then\nlocal prjcfg = premake.getconfig(prj, cfgname, cfg.platform)\nif kind == \"dependencies\" or canlink(cfg, prjcfg) then\nif (part == \"directory\") then\nitem = path.rebase(prjcfg.linktarget.directory, prjcfg.location, cfg.location)\nelseif (part == \"basename\") then\nitem = prjcfg.linktarget.basename\nelseif (part == \"fullpath\") then\nitem = path.rebase(prjcfg.linktarget.fullpath, prjcfg.location, cfg.location)\nelseif (part == \"object\") then\nitem = prjcfg\nend\nend\nelseif not prj and (kind == \"system\" or kind == \"all\") then\nif (part == \"directory\") then\nitem = path.getdirectory(link)\nelseif (part == \"fullpath\") then\nitem = link\nif namestyle == \"windows\" then\nif premake.iscppproject(cfg) then\nitem = item .. \".lib\"\nelseif premake.isdotnetproject(cfg) then\nitem = item .. \".dll\"\nend\nend\nel"
	"seif part == \"name\" then\nitem = path.getname(link)\nelseif part == \"basename\" then\nitem = path.getbasename(link)\nelse\nitem = link\nend\nif item:find(\"/\", nil, true) then\nitem = path.getrelative(cfg.project.location, item)\nend\nend\nif item then\nif pathstyle == \"windows\" and part ~= \"object\" then\nitem = path.translate(item, \"\\\\\")\nend\nif not table.contains(result, item) then\ntable.insert(result, item)\nend\nend\nend\nreturn result\nend\nfunction premake.getnamestyle(cfg)\nreturn premake.platforms[cfg.platform].namestyle or premake.gettool(cfg).namestyle or \"posix\"\nend\nfunction premake.getpathstyle(cfg)\nif premake.action.current().os == \"windows\" then\nreturn \"windows\"\nelse\nreturn \"posix\"\nend\nend\nfunction premake.gettarget(cfg, direction, pathstyle, namestyle, system)\nif system == \"bsd\" then\nsystem = \"linux\"\nend\nlocal kind = cfg.kind\nif premake.iscppproject(cfg) or premake.isvalaproject(cfg) then\nif (namestyle == \"windows\" or system == \"windows\")\nand kind =="
	" \"SharedLib\" and direction == \"link\"\nand not cfg.flags.NoImportLib\nthen\nkind = \"StaticLib\"\nend\nif namestyle == \"posix\" and system == \"windows\" and kind ~= \"StaticLib\" then\nnamestyle = \"windows\"\nend\nend\nlocal field   = \"build\"\nif direction == \"link\" and cfg.kind == \"SharedLib\" then\nfield = \"implib\"\nend\nlocal name    = cfg[field..\"name\"] or cfg.targetname or cfg.project.name\nlocal dir     = cfg[field..\"dir\"] or cfg.targetdir or path.getrelative(cfg.location, cfg.basedir)\nlocal subdir  = cfg[field..\"subdir\"] or cfg.targetsubdir or \".\"\nlocal prefix  = \"\"\nlocal suffix  = \"\"\nlocal ext     = \"\"\nlocal bundlepath, bundlename\ndir = path.join(dir, subdir)\nif namestyle == \"windows\" then\nif kind == \"ConsoleApp\" or kind == \"WindowedApp\" then\next = \".exe\"\nelseif kind == \"SharedLib\" then\next = \".dll\"\nelseif kind == \"StaticLib\" then\next = \".lib\"\nend\nelseif namestyle == \"posix\" then\nif kind == \"WindowedApp\" and system == \"macosx\" and not cfg"
	".options.SkipBundling then\nbundlename = name .. \".app\"\nbundlepath = path.join(dir, bundlename)\ndir = path.join(bundlepath, \"Contents/MacOS\")\nelseif (kind == \"ConsoleApp\" or kind == \"WindowedApp\") and system == \"os2\" then\next = \".exe\"\nelseif kind == \"SharedLib\" then\nprefix = \"lib\"\next = iif(system == \"macosx\", \".dylib\", \".so\")\nelseif kind == \"StaticLib\" then\nprefix = \"lib\"\next = \".a\"\nend\nelseif namestyle == \"PS3\" then\nif kind == \"ConsoleApp\" or kind == \"WindowedApp\" then\next = \".elf\"\nelseif kind == \"StaticLib\" then\nprefix = \"lib\"\next = \".a\"\nend\nelseif namestyle == \"Orbis\" then\nif kind == \"ConsoleApp\" or kind == \"WindowedApp\" then\next = \".elf\"\nelseif kind == \"StaticLib\" then\nprefix = \"lib\"\next = \".a\"\nelseif kind == \"SharedLib\" then\next = \".prx\"\nend\nelseif namestyle == \"TegraAndroid\" then\nif kind == \"ConsoleApp\" or kind == \"WindowedApp\" or kind == \"SharedLib\" then\nprefix = \"lib\"\next = \".so\"\nelseif kind == \"St"
	"aticLib\" then\nprefix = \"lib\"\next = \".a\"\nend\nelseif namestyle == \"NX\" then\nif kind == \"ConsoleApp\" or kind == \"WindowedApp\" then\next = \".nspd_root\"\nelseif kind == \"StaticLib\" then\next = \".a\"\nelseif kind == \"SharedLib\" then\next = \".nro\"\nend\nelseif namestyle == \"Emscripten\" then\nif kind == \"ConsoleApp\" or kind == \"WindowedApp\" then\next = \".html\"\nelseif kind == \"StaticLib\" then\next = \".a\"\nelseif kind == \"SharedLib\" then\next = \".js\"\nend\nend\nprefix = cfg[field..\"prefix\"] or cfg.targetprefix or prefix\nsuffix = cfg[field..\"suffix\"] or cfg.targetsuffix or suffix\next    = cfg[field..\"extension\"] or cfg.targetextension or ext\nlocal result = { }\nresult.basename     = name .. suffix\nresult.name         = prefix .. name .. suffix .. ext\nresult.directory    = dir\nresult.subdirectory = subdir\nresult.prefix       = prefix\nresult.suffix       = suffix\nresult.fullpath     = path.join(result.directory, result.name)\nresult.bundlepath   = bundlepath or resul"
	"t.fullpath\nif pathstyle == \"windows\" then\nresult.directory    = path.translate(result.directory, \"\\\\\")\nresult.subdirectory = path.translate(result.subdirectory, \"\\\\\")\nresult.fullpath     = path.translate(result.fullpath,  \"\\\\\")\nend\nreturn result\nend\nfunction premake.gettool(prj)\nif premake.iscppproject(prj) then\nif _OPTIONS.cc then\nreturn premake[_OPTIONS.cc]\nend\nlocal action = premake.action.current()\nif action.valid_tools then\nreturn premake[action.valid_tools.cc[1]]\nend\nreturn premake.gcc\nelseif premake.isdotnetproject(prj) then\nreturn premake.dotnet\nelseif premake.isswiftproject(prj) then\nreturn premake.swift\nelse\nreturn premake.valac\nend\nend\nfunction premake.project.getvpath(prj, abspath)\nlocal vpath = abspath\nlocal fname = path.getname(abspath)\nlocal max = abspath:len() - fname:len()\n        -- First check for an exact match from the inverse vpaths\n        if prj.inversevpaths and prj.inversevpaths[abspath] then\n            return path.join(prj.inversevpaths["
	"abspath], fname)\n        end\n        local matches = {}\nfor replacement, patterns in pairs(prj.vpaths or {}) do\nfor _, pattern in ipairs(patterns) do\nlocal i = abspath:find(path.wildcards(pattern))\nif i == 1 then\ni = pattern:find(\"*\", 1, true) or (pattern:len() + 1)\nlocal leaf\nif i < max then\nleaf = abspath:sub(i)\nelse\nleaf = fname\nend\nif leaf:startswith(\"/\") then\nleaf = leaf:sub(2)\nend\nlocal stem = \"\"\nif replacement:len() > 0 then\nstem, stars = replacement:gsub(\"%*\", \"\")\nif stars == 0 then\nleaf = path.getname(leaf)\nend\nelse\nleaf = path.getname(leaf)\nend\ntable.insert(matches, path.join(stem, leaf))\nend\nend\nend\n        if #matches > 0 then\n            -- for the sake of determinism, return the first alphabetically\n            table.sort(matches)\n            vpath = matches[1]\n        end\nreturn path.trimdots(vpath)\nend\nfunction premake.hascppproject(sln)\nfor prj in premake.solution.eachproject(sln) do\nif premake.iscppproject(prj) then\nreturn true\nend\nend\nend"
	"\nfunction premake.hasdotnetproject(sln)\nfor prj in premake.solution.eachproject(sln) do\nif premake.isdotnetproject(prj) then\nreturn true\nend\nend\nend\nfunction premake.project.iscproject(prj)\nlocal language = prj.language or prj.solution.language\nreturn language == \"C\"\nend\nfunction premake.iscppproject(prj)\nlocal language = prj.language or prj.solution.language\nreturn (language == \"C\" or language == \"C++\")\nend\nfunction premake.isdotnetproject(prj)\nlocal language = prj.language or prj.solution.language\nreturn (language == \"C#\")\nend\nfunction premake.isvalaproject(prj)\nlocal language = prj.language or prj.solution.language\nreturn (language == \"Vala\")\nend\nfunction premake.isswiftproject(prj)\nlocal language = prj.language or prj.solution.language\nreturn (language == \"Swift\")\nend\n",

	/* base/config.lua */
	"premake.config = { }\nlocal config = premake.config\nfunction premake.config.isdebugbuild(cfg)\nif cfg.flags.DebugRuntime then\nreturn true\nend\nif cfg.flags.ReleaseRuntime then\nreturn false\nend\nif cfg.flags.Optimize or cfg.flags.OptimizeSize or cfg.flags.OptimizeSpeed then\nreturn false\nend\nif not cfg.flags.Symbols then\nreturn false\nend\nreturn true\nend\nfunction premake.config.eachfile(cfg)\nlocal i = 0\nlocal t = cfg.files\nreturn function ()\ni = i + 1\nif (i <= #t) then\nlocal fcfg = cfg.__fileconfigs[t[i]]\nfcfg.vpath = premake.project.getvpath(cfg.project, fcfg.name)\nreturn fcfg\nend\nend\nend\nfunction premake.config.isincrementallink(cfg)\nif cfg.kind == \"StaticLib\" then\nreturn false\nend\nreturn not config.islinkeroptimizedbuild(cfg.flags) and not cfg.flags.NoIncrementalLink\nend\nfunction premake.config.isoptimizedbuild(flags)\nreturn flags.Optimize or flags.OptimizeSize or flags.OptimizeSpeed\nend\nfunction premake.config.islinkeroptimizedbuild(flags)\nreturn config.isoptimizedbuild(fl"
	"ags) and not flags.NoOptimizeLink\nend\nfunction premake.config.iseditandcontinue(cfg)\nif cfg.flags.NoEditAndContinue\nor cfg.flags.Managed\nor (cfg.kind ~= \"StaticLib\" and not config.isincrementallink(cfg))\nor config.islinkeroptimizedbuild(cfg.flags) then\nreturn false\nend\nreturn true\nend\n",

	/* base/bake.lua */
	"premake.bake = { }\nlocal bake = premake.bake\nlocal nocopy =\n{\nblocks    = true,\nkeywords  = true,\nprojects  = true,\n__configs = true,\n}\nlocal nocascade =\n{\nmakesettings = true,\n}\nlocal keeprelative =\n{\nbasedir  = true,\nlocation = true,\n}\nfunction premake.getactiveterms(obj)\nlocal terms = { _action = _ACTION:lower(), os = os.get() }\nfor key, value in pairs(_OPTIONS) do\nif value ~= \"\" then\ntable.insert(terms, value:lower())\nelse\ntable.insert(terms, key:lower())\nend\nend\nreturn terms\nend\nfunction premake.iskeywordmatch(keyword, terms)\nif keyword:startswith(\"not \") then\nreturn not premake.iskeywordmatch(keyword:sub(5), terms)\nend\nfor _, pattern in ipairs(keyword:explode(\" or \")) do\nfor termkey, term in pairs(terms) do\nif term:match(pattern) == term then\nreturn termkey\nend\nend\nend\nend\nfunction premake.iskeywordsmatch(keywords, terms)\nlocal hasrequired = false\nfor _, keyword in ipairs(keywords) do\nlocal matched = premake.iskeywordmatch(keyword, terms)\nif not matched "
	"then\nreturn false\nend\nif matched == \"required\" then\nhasrequired = true\nend\nend\nif terms.required and not hasrequired then\nreturn false\nelse\nreturn true\nend\nend\nlocal function adjustpaths(location, obj)\nfunction adjustpathlist(list)\nfor i, p in ipairs(list) do\nlist[i] = path.getrelative(location, p)\nend\nend\nif obj.allfiles ~= nil then\nadjustpathlist(obj.allfiles)\nend\nfor name, value in pairs(obj) do\nlocal field = premake.fields[name]\nif field and value and not keeprelative[name] then\nif field.kind == \"path\" then\nobj[name] = path.getrelative(location, value)\nelseif field.kind == \"dirlist\" or field.kind == \"filelist\" then\nadjustpathlist(value)\nelseif field.kind == \"keypath\" then\nfor k,v in pairs(value) do\nadjustpathlist(v)\nend\nend\nend\nend\nend\nlocal function removevalue(tbl, remove)\nfor index, item in ipairs(tbl) do\nif item == remove then\ntable.remove(tbl, index)\nbreak\nend\nend\nend\n local function removevalues(tbl, removes)\nfor i = #tbl, 1, -1 do\nfor _, patte"
	"rn in ipairs(removes) do\nif pattern == tbl[i] then\ntable.remove(tbl, i)\nbreak\nend\nend\nend\nfor k, v in pairs(tbl) do\nfor _, pattern in ipairs(removes) do\nif pattern == tbl[k] then\ntbl[k] = nil\nbreak\nend\nend\nend\nend\nlocal function mergefield(kind, dest, src, mergecopiestotail)\nlocal tbl = dest or { }\nif kind == \"keyvalue\" or kind == \"keypath\" then\nfor key, value in pairs(src) do\ntbl[key] = mergefield(\"list\", tbl[key], value, mergecopiestotail)\nend\nelse\nfor _, item in ipairs(src) do\nif tbl[item] then\nif mergecopiestotail then\nremovevalue(tbl, item)\ntable.insert(tbl, item)\ntbl[item] = item\nend\nelse\ntable.insert(tbl, item)\ntbl[item] = item\nend\nend\nend\nreturn tbl\nend\nlocal function mergeobject(dest, src)\nif not src then\nreturn\nend\nfor fieldname, value in pairs(src) do\nif not nocopy[fieldname] then\nlocal field = premake.fields[fieldname]\nif field then\nif type(value) == \"table\" then\ndest[fieldname] = mergefield(field.kind, dest[fieldname], value, field.mergecopies"
	"totail)\nif src.removes then\nremoves = src.removes[fieldname]\nif removes then\nremovevalues(dest[fieldname], removes)\nend\nend\nelse\ndest[fieldname] = value\nend\nelse\ndest[fieldname] = value\nend\nend\nend\nend\nlocal function merge(dest, obj, basis, terms, cfgname, pltname)\nlocal key = cfgname or \"\"\npltname = pltname or \"Native\"\nif pltname ~= \"Native\" then\nkey = key .. pltname\nend\nterms.config = (cfgname or \"\"):lower()\nterms.platform = pltname:lower()\nlocal cfg = {}\nmergeobject(cfg, basis[key])\nadjustpaths(obj.location, cfg)\nmergeobject(cfg, obj)\nif (cfg.kind) then\nterms['kind']=cfg.kind:lower()\nend\nfor _, blk in ipairs(obj.blocks) do\nif (premake.iskeywordsmatch(blk.keywords, terms))then\nmergeobject(cfg, blk)\nif (cfg.kind and not cfg.terms.kind) then\ncfg.terms['kind'] = cfg.kind:lower()\nterms['kind'] = cfg.kind:lower()\nend\nend\nend\ncfg.name      = cfgname\ncfg.platform  = pltname\nfor k,v in pairs(terms) do\ncfg.terms[k] =v\nend\ndest[key] = cfg\nend\nlocal function collap"
	"se(obj, basis)\nlocal result = {}\nbasis = basis or {}\nlocal sln = obj.solution or obj\nlocal terms = premake.getactiveterms(obj)\nmerge(result, obj, basis, terms)--this adjusts terms\nfor _, cfgname in ipairs(sln.configurations) do\nlocal terms_local = {}\nfor k,v in pairs(terms)do terms_local[k]=v end\nmerge(result, obj, basis, terms_local, cfgname, \"Native\")--terms cam also be adjusted here\nfor _, pltname in ipairs(sln.platforms or {}) do\nif pltname ~= \"Native\" then\nmerge(result, obj, basis,terms_local, cfgname, pltname)--terms also here\nend\nend\nend\nreturn result\nend\nlocal function builduniquedirs()\nlocal num_variations = 4\nlocal cfg_dirs = {}\nlocal hit_counts = {}\nfor sln in premake.solution.each() do\nfor _, prj in ipairs(sln.projects) do\nfor _, cfg in pairs(prj.__configs) do\nlocal dirs = { }\ndirs[1] = path.getabsolute(path.join(cfg.location, cfg.objdir or cfg.project.objdir or \"obj\"))\ndirs[2] = path.join(dirs[1], iif(cfg.platform == \"Native\", \"\", cfg.platform))\ndirs[3] = path"
	".join(dirs[2], cfg.name)\ndirs[4] = path.join(dirs[3], cfg.project.name)\ncfg_dirs[cfg] = dirs\nlocal start = iif(cfg.name, 2, 1)\nfor v = start, num_variations do\nlocal d = dirs[v]\nhit_counts[d] = (hit_counts[d] or 0) + 1\nend\nend\nend\nend\nfor sln in premake.solution.each() do\nfor _, prj in ipairs(sln.projects) do\nfor _, cfg in pairs(prj.__configs) do\nlocal dir\nlocal start = iif(cfg.name, 2, 1)\nfor v = start, iif(cfg.flags.SingleOutputDir==true,num_variations-1,num_variations) do\ndir = cfg_dirs[cfg][v]\nif hit_counts[dir] == 1 then break end\nend\ncfg.objectsdir = path.getrelative(cfg.location, dir)\nend\nend\nend\nend\nlocal function buildtargets()\nfor sln in premake.solution.each() do\nfor _, prj in ipairs(sln.projects) do\nfor _, cfg in pairs(prj.__configs) do\nlocal pathstyle = premake.getpathstyle(cfg)\nlocal namestyle = premake.getnamestyle(cfg)\ncfg.buildtarget = premake.gettarget(cfg, \"build\", pathstyle, namestyle, cfg.system)\ncfg.linktarget  = premake.gettarget(cfg, \"link\",  pathstyl"
	"e, namestyle, cfg.system)\nif pathstyle == \"windows\" then\ncfg.objectsdir = path.translate(cfg.objectsdir, \"\\\\\")\nend\nend\nend\nend\nend\n  local function getCfgKind(cfg)\n  if(cfg.kind) then\n  return cfg.kind;\n  end\n  if(cfg.project.__configs[\"\"] and cfg.project.__configs[\"\"].kind) then\n  return cfg.project.__configs[\"\"].kind;\n  end\n  return nil\n  end\n  local function getprojrec(dstArray, foundList, cfg, cfgname, searchField, bLinkage)\n  if(not cfg) then return end\n  local foundUsePrjs = {};\n  for _, useName in ipairs(cfg[searchField]) do\n  local testName = useName:lower();\n  if((not foundList[testName])) then\n  local theProj = nil;\n  local theUseProj = nil;\n  for _, prj in ipairs(cfg.project.solution.projects) do\n  if (prj.name:lower() == testName) then\n  if(prj.usage) then\n  theUseProj = prj;\n  else\n  theProj = prj;\n  end\n  end\n  end\n  --Must connect to a usage project.\n  if(theUseProj) then\n  foundList[testName] = true;\n  local prjEntry = {\n  name = testName,\n  pr"
	"oj = theProj,\n  usageProj = theUseProj,\n  bLinkageOnly = bLinkage,\n  };\n  dstArray[testName] = prjEntry;\n  table.insert(foundUsePrjs, theUseProj);\n  end\n  end\n  end\n  for _, usePrj in ipairs(foundUsePrjs) do\n  --Links can only recurse through static libraries.\n  if((searchField ~= \"links\") or\n  (getCfgKind(usePrj.__configs[cfgname]) == \"StaticLib\")) then\n  getprojrec(dstArray, foundList, usePrj.__configs[cfgname],\n  cfgname, searchField, bLinkage);\n  end\n  end\n  end\n  --\n  -- This function will recursively get all projects that the given configuration has in its \"uses\"\n  -- field. The return values are a list of tables. Each table in that list contains the following:\n  --name = The lowercase name of the project.\n  --proj = The project. Can be nil if it is usage-only.\n  --usageProj = The usage project. Can't be nil, as using a project that has no\n  -- usage project is not put into the list.\n  --bLinkageOnly = If this is true, then only the linkage information should be copied.\n  "
	"-- The recursion will only look at the \"uses\" field on *usage* projects.\n  -- This function will also add projects to the list that are mentioned in the \"links\"\n  -- field of usage projects. These will only copy linker information, but they will recurse.\n  -- through other \"links\" fields.\n  --\n  local function getprojectsconnections(cfg, cfgname)\n  local dstArray = {};\n  local foundList = {};\n  foundList[cfg.project.name:lower()] = true;\n  --First, follow the uses recursively.\n  getprojrec(dstArray, foundList, cfg, cfgname, \"uses\", false);\n  --Next, go through all of the usage projects and recursively get their links.\n  --But only if they're not already there. Get the links as linkage-only.\n  local linkArray = {};\n  for prjName, prjEntry in pairs(dstArray) do\n  getprojrec(linkArray, foundList, prjEntry.usageProj.__configs[cfgname], cfgname,\n  \"links\", true);\n  end\n  --Copy from linkArray into dstArray.\n  for prjName, prjEntry in pairs(linkArray) do\n  dstArray[prjName] = prjEntry;"
	"\n  end\n  return dstArray;\n  end\n  local function isnameofproj(cfg, strName)\n  local sln = cfg.project.solution;\n  local strTest = strName:lower();\n  for prjIx, prj in ipairs(sln.projects) do\n  if (prj.name:lower() == strTest) then\n  return true;\n  end\n  end\n  return false;\n  end\n  --\n  -- Copies the field from dstCfg to srcCfg.\n  --\n  local function copydependentfield(srcCfg, dstCfg, strSrcField)\n  local srcField = premake.fields[strSrcField];\n  local strDstField = strSrcField;\n  if type(srcCfg[strSrcField]) == \"table\" then\n  --handle paths.\n  if (srcField.kind == \"dirlist\" or srcField.kind == \"filelist\") and\n  (not keeprelative[strSrcField]) then\n  for i,p in ipairs(srcCfg[strSrcField]) do\n  table.insert(dstCfg[strDstField],\n  path.rebase(p, srcCfg.project.location, dstCfg.project.location))\n  end\n  else\n  if(strSrcField == \"links\") then\n  for i,p in ipairs(srcCfg[strSrcField]) do\n  if(not isnameofproj(dstCfg, p)) then\n  table.insert(dstCfg[strDstField], p)\n  else\n  p"
	"rintf(\"Failed to copy '%s' from proj '%s'.\",\n  p, srcCfg.project.name);\n  end\n  end\n  else\n  for i,p in ipairs(srcCfg[strSrcField]) do\n  table.insert(dstCfg[strDstField], p)\n  end\n  end\n  end\n  else\n  if(srcField.kind == \"path\" and (not keeprelative[strSrcField])) then\n  dstCfg[strDstField] = path.rebase(srcCfg[strSrcField],\n  prj.location, dstCfg.project.location);\n  else\n  dstCfg[strDstField] = srcCfg[strSrcField];\n  end\n  end\n  end\n  --\n  -- This function will take the list of project entries and apply their usage project data\n  -- to the given configuration. It will copy compiling information for the projects that are\n  -- not listed as linkage-only. It will copy the linking information for projects only if\n  -- the source project is not a static library. It won't copy linking information\n  -- if the project is in this solution; instead it will add that project to the configuration's\n  -- links field, expecting that Premake will handle the rest.\n  --\n  local function copyusag"
	"edata(cfg, cfgname, linkToProjs)\n  local myPrj = cfg.project;\n  local bIsStaticLib = (getCfgKind(cfg) == \"StaticLib\");\n  for prjName, prjEntry in pairs(linkToProjs) do\n  local srcPrj = prjEntry.usageProj;\n  local srcCfg = srcPrj.__configs[cfgname];\n  for name, field in pairs(premake.fields) do\n  if(srcCfg[name]) then\n  if(field.usagecopy) then\n  if(not prjEntry.bLinkageOnly) then\n  copydependentfield(srcCfg, cfg, name)\n  end\n  elseif(field.linkagecopy) then\n  --Copy the linkage data if we're building a non-static thing\n  --and this is a pure usage project. If it's not pure-usage, then\n  --we will simply put the project's name in the links field later.\n  if((not bIsStaticLib) and (not prjEntry.proj)) then\n  copydependentfield(srcCfg, cfg, name)\n  end\n  end\n  end\n  end\n  if((not bIsStaticLib) and prjEntry.proj) then\n  table.insert(cfg.links, prjEntry.proj.name);\n  end\n  end\n  end\n    local function inverseliteralvpaths()\n        for sln in premake.solution.each() do\n            for"
	" _,prj in ipairs(sln.projects) do\n                prj.inversevpaths = {}\n                for replacement, patterns in pairs(prj.vpaths or {}) do\n                    for _, pattern in ipairs(patterns) do\n                        if string.find(pattern, \"*\") == nil then\n                            prj.inversevpaths[pattern] = replacement\n                        end\n                    end\n                end\n            end\n        end\n    end\nfunction premake.bake.buildconfigs()\nfor sln in premake.solution.each() do\nfor _, prj in ipairs(sln.projects) do\nprj.location = prj.location or sln.location or prj.basedir\nadjustpaths(prj.location, prj)\nfor _, blk in ipairs(prj.blocks) do\nadjustpaths(prj.location, blk)\nend\nend\nsln.location = sln.location or sln.basedir\nend\n        -- convert paths for imported projects to be relative to solution location\nfor sln in premake.solution.each() do\nfor _, iprj in ipairs(sln.importedprojects) do\niprj.location = path.getabsolute(iprj.location)\nend\nend\n"
	"        inverseliteralvpaths()\nfor sln in premake.solution.each() do\nlocal basis = collapse(sln)\nfor _, prj in ipairs(sln.projects) do\nprj.__configs = collapse(prj, basis)\nfor _, cfg in pairs(prj.__configs) do\nbake.postprocess(prj, cfg)\nend\nend\nend\nfor sln in premake.solution.each() do\nfor prjIx, prj in ipairs(sln.projects) do\nif(not prj.usage) then\nfor cfgname, cfg in pairs(prj.__configs) do\nlocal usesPrjs = getprojectsconnections(cfg, cfgname);\ncopyusagedata(cfg, cfgname, usesPrjs)\nend\nend\nend\nend\nfor sln in premake.solution.each() do\nfor prjIx, prj in ipairs(sln.projects) do\nfor cfgName, cfg in pairs(prj.__configs) do\ncfg.build = true\nlocal removes = nil\nif cfg.removes ~= nil then\nremoves = cfg.removes[\"platforms\"];\nend\nif removes ~= nil  then\nfor _,p in ipairs(removes) do\nif p == cfg.platform then\ncfg.build = false\nend\nend\nend\nend\nend\nend\nfor sln in premake.solution.each() do\nlocal removeList = {};\nfor index, prj in ipairs(sln.projects) do\nif(prj.usage) then\ntabl"
	"e.insert(removeList, 1, index); --Add in reverse order.\nend\nend\nfor _, index in ipairs(removeList) do\ntable.remove(sln.projects, index);\nend\nend\nbuilduniquedirs()\nbuildtargets(cfg)\nend\nfunction premake.bake.postprocess(prj, cfg)\ncfg.project   = prj\ncfg.shortname = premake.getconfigname(cfg.name, cfg.platform, true)\ncfg.longname  = premake.getconfigname(cfg.name, cfg.platform)\ncfg.location = cfg.location or cfg.basedir\nlocal platform = premake.platforms[cfg.platform]\nif platform.iscrosscompiler then\ncfg.system = cfg.platform\nelse\ncfg.system = os.get()\nend\nif cfg.kind == \"Bundle\"\nand _ACTION ~= \"gmake\"\nand (_ACTION ~= \"ninja\" and (not prj.options or not prj.options.SkipBundling))\nand not _ACTION:match(\"xcode[0-9]\") then\ncfg.kind = \"SharedLib\"\nend\nif cfg.kind == \"SharedLib\" and platform.nosharedlibs then\ncfg.kind = \"StaticLib\"\nend\nlocal removefiles = cfg.removefiles\nif _ACTION == 'gmake' or _ACTION == 'ninja' then\nremovefiles = table.join(removefiles, cfg.excludes)\ne"
	"nd\nlocal removefilesDict = {}\nfor _, fname in ipairs(removefiles) do\nremovefilesDict[fname] = true\nend\nlocal files = {}\nfor _, fname in ipairs(cfg.files) do\nif removefilesDict[fname] == nil then\ntable.insert(files, fname)\nend\nend\ncfg.files = files\nlocal allfiles = {}\nlocal allfilesDict = {}\nif cfg.allfiles ~= nil then\nfor _, fname in ipairs(cfg.allfiles) do\nif allfilesDict[fname] == nil then\nif removefilesDict[fname] == nil then\nallfilesDict[fname] = true\ntable.insert(allfiles, fname)\nend\nend\nend\nend\ncfg.allfiles = allfiles\nfor name, field in pairs(premake.fields) do\nif field.isflags then\nlocal values = cfg[name]\nfor _, flag in ipairs(values) do values[flag] = true end\nend\nend\nlocal cfgfields = {\n{\"__fileconfigs\",    cfg.files},\n{\"__allfileconfigs\", cfg.allfiles},\n}\nfor _, cfgfield in ipairs(cfgfields) do\nlocal fieldname = cfgfield[1]\nlocal field     = cfgfield[2]\ncfg[fieldname] = { }\nfor _, fname in ipairs(field) do\nlocal fcfg = {}\nif premake._filelevelconfig then"
	"\ncfg.terms.required = fname:lower()\nfor _, blk in ipairs(cfg.project.blocks) do\nif (premake.iskeywordsmatch(blk.keywords, cfg.terms)) then\nmergeobject(fcfg, blk)\nend\nend\nend\nfcfg.name = fname\ncfg[fieldname][fname] = fcfg\ntable.insert(cfg[fieldname], fcfg)\nend\nend\nend\n",

	/* base/api.lua */
	"premake.fields = {}\npremake.check_paths = false\nfunction premake.checkvalue(value, allowed)\nif (allowed) then\nif (type(allowed) == \"function\") then\nreturn allowed(value)\nelse\nfor _,v in ipairs(allowed) do\nif (value:lower() == v:lower()) then\nreturn v\nend\nend\nreturn nil, \"invalid value '\" .. value .. \"'\"\nend\nelse\nreturn value\nend\nend\nfunction premake.getobject(t)\nlocal container\nif (t == \"container\" or t == \"solution\") then\ncontainer = premake.CurrentContainer\nelse\ncontainer = premake.CurrentConfiguration\nend\nif t == \"solution\" then\nif typex(container) == \"project\" then\ncontainer = container.solution\nend\nif typex(container) ~= \"solution\" then\ncontainer = nil\nend\nend\nlocal msg\nif (not container) then\nif (t == \"container\") then\nmsg = \"no active solution or project\"\nelseif (t == \"solution\") then\nmsg = \"no active solution\"\nelse\nmsg = \"no active solution, project, or configuration\"\nend\nend\nreturn container, msg\nend\nfunction premake.setarray(obj, "
	"fieldname, value, allowed)\nobj[fieldname] = obj[fieldname] or {}\nlocal function add(value, depth)\nif type(value) == \"table\" then\nfor _,v in ipairs(value) do\nadd(v, depth + 1)\nend\nelse\nvalue, err = premake.checkvalue(value, allowed)\nif not value then\nerror(err, depth)\nend\ntable.insert(obj[fieldname], value)\nend\nend\nif value then\nadd(value, 5)\nend\nreturn obj[fieldname]\nend\nfunction premake.settable(obj, fieldname, value, allowed)\nobj[fieldname] = obj[fieldname] or {}\ntable.insert(obj[fieldname], value)\nreturn obj[fieldname]\nend\nlocal function domatchedarray(fields, value, matchfunc)\nlocal result = { }\nfunction makeabsolute(value, depth)\nif (type(value) == \"table\") then\nfor _, item in ipairs(value) do\nmakeabsolute(item, depth + 1)\nend\nelseif type(value) == \"string\" then\nif value:find(\"*\") then\nlocal arr = matchfunc(value);\nif (premake.check_paths) and (#arr == 0) then\nerror(\"Can't find matching files for pattern :\" .. value)\nend\nmakeabsolute(arr, depth + 1)\nelse\nt"
	"able.insert(result, path.getabsolute(value))\nend\nelse\nerror(\"Invalid value in list: expected string, got \" .. type(value), depth)\nend\nend\nmakeabsolute(value, 3)\nlocal retval = {}\nfor index, field in ipairs(fields) do\nlocal ctype = field[1]\nlocal fieldname = field[2]\nlocal array = premake.setarray(ctype, fieldname, result)\nif index == 1 then\nretval = array\nend\nend\nreturn retval\nend\nfunction premake.setdirarray(fields, value)\nreturn domatchedarray(fields, value, os.matchdirs)\nend\nfunction premake.setfilearray(fields, value)\nreturn domatchedarray(fields, value, os.matchfiles)\nend\nfunction premake.setkeyvalue(ctype, fieldname, values)\nlocal container, err = premake.getobject(ctype)\nif not container then\nerror(err, 4)\nend\nif not container[fieldname] then\ncontainer[fieldname] = {}\nend\nif type(values) ~= \"table\" then\nerror(\"invalid value; table expected\", 4)\nend\nlocal field = container[fieldname]\nfor key,value in pairs(values) do\nif not field[key] then\nfield[key] = {}\nend"
	"\ntable.insertflat(field[key], value)\nend\nreturn field\nend\nfunction premake.setstring(ctype, fieldname, value, allowed)\nlocal container, err = premake.getobject(ctype)\nif (not container) then\nerror(err, 4)\nend\nif (value) then\nvalue, err = premake.checkvalue(value, allowed)\nif (not value) then\nerror(err, 4)\nend\ncontainer[fieldname] = value\nend\nreturn container[fieldname]\nend\nfunction premake.remove(fieldname, value)\nlocal cfg = premake.CurrentConfiguration\ncfg.removes = cfg.removes or {}\ncfg.removes[fieldname] = premake.setarray(cfg.removes, fieldname, value)\nend\nlocal function accessor(name, value)\nlocal kind    = premake.fields[name].kind\nlocal scope   = premake.fields[name].scope\nlocal allowed = premake.fields[name].allowed\nif (kind == \"string\" or kind == \"path\") and value then\nif type(value) ~= \"string\" then\nerror(\"string value expected\", 3)\nend\nend\nlocal container, err = premake.getobject(scope)\nif (not container) then\nerror(err, 3)\nend\nif kind == \"string\" then"
	"\nreturn premake.setstring(scope, name, value, allowed)\nelseif kind == \"path\" then\nif value then value = path.getabsolute(value) end\nreturn premake.setstring(scope, name, value)\nelseif kind == \"list\" then\nreturn premake.setarray(container, name, value, allowed)\nelseif kind == \"table\" then\nreturn premake.settable(container, name, value, allowed)\nelseif kind == \"dirlist\" then\nreturn premake.setdirarray({{container, name}}, value)\nelseif kind == \"filelist\" or kind == \"absolutefilelist\" then\nlocal fields = {{container, name}}\nif name == \"files\" then\nlocal prj, err = premake.getobject(\"container\")\nif (not prj) then\nerror(err, 2)\nend\ntable.insert(fields, {prj.blocks[1], \"allfiles\"})\nend\nreturn premake.setfilearray(fields, value)\nelseif kind == \"keyvalue\" or kind == \"keypath\" then\nreturn premake.setkeyvalue(scope, name, value)\nend\nend\nfunction configuration(terms)\nif not terms then\nreturn premake.CurrentConfiguration\nend\nlocal container, err = premake.getobject(\"cont"
	"ainer\")\nif (not container) then\nerror(err, 2)\nend\nlocal cfg = { }\ncfg.terms = table.flatten({terms})\ntable.insert(container.blocks, cfg)\npremake.CurrentConfiguration = cfg\ncfg.keywords = { }\nfor _, word in ipairs(cfg.terms) do\ntable.insert(cfg.keywords, path.wildcards(word):lower())\nend\nfor name, field in pairs(premake.fields) do\nif (field.kind ~= \"string\" and field.kind ~= \"path\") then\ncfg[name] = { }\nend\nend\nreturn cfg\nend\nlocal function creategroup(name, sln, curpath, parent, inpath)\nlocal group = {}\nsetmetatable(group, {\n__type = \"group\"\n})\ntable.insert(sln.groups, group)\nsln.groups[inpath] = group\nif parent ~= nil then\ntable.insert(parent.groups, group)\nend\ngroup.solution = sln\ngroup.name = name\ngroup.uuid = os.uuid(curpath)\ngroup.parent = parent\ngroup.projects = { }\ngroup.groups = { }\nreturn group\nend\nlocal function creategroupsfrompath(inpath, sln)\nif inpath == nil then return nil end\ninpath = path.translate(inpath, \"/\")\nlocal groups = string.explode(inpa"
	"th, \"/\")\nlocal curpath = \"\"\nlocal lastgroup = nil\nfor i, v in ipairs(groups) do\ncurpath = curpath .. \"/\" .. v:lower()\nlocal group = sln.groups[curpath]\nif group == nil then\ngroup = creategroup(v, sln, curpath, lastgroup, curpath)\nend\nlastgroup = group\nend\nreturn lastgroup\nend\nlocal function createproject(name, sln, isUsage)\nlocal prj = {}\nsetmetatable(prj, {\n__type = \"project\",\n})\ntable.insert(sln.projects, prj)\nif(isUsage) then\nif(sln.projects[name]) then\nsln.projects[name].usageProj = prj;\nelse\nsln.projects[name] = prj\nend\nelse\nif(sln.projects[name]) then\nprj.usageProj = sln.projects[name];\nend\nsln.projects[name] = prj\nend\nlocal group = creategroupsfrompath(premake.CurrentGroup, sln)\nif group ~= nil then\ntable.insert(group.projects, prj)\nend\nprj.solution       = sln\nprj.name           = name\nprj.basedir        = os.getcwd()\nprj.uuid           = os.uuid(prj.name)\nprj.blocks         = { }\nprj.usage          = isUsage\nprj.group          = group\nreturn prj;\nend"
	"\nfunction usage(name)\nif (not name) then\nif(typex(premake.CurrentContainer) ~= \"project\") then return nil end\nif(not premake.CurrentContainer.usage) then return nil end\nreturn premake.CurrentContainer\nend\nlocal sln\nif (typex(premake.CurrentContainer) == \"project\") then\nsln = premake.CurrentContainer.solution\nelse\nsln = premake.CurrentContainer\nend\nif (typex(sln) ~= \"solution\") then\nerror(\"no active solution\", 2)\nend\nif((not sln.projects[name]) or\n((not sln.projects[name].usage) and (not sln.projects[name].usageProj))) then\npremake.CurrentContainer = createproject(name, sln, true)\nelse\npremake.CurrentContainer = iff(sln.projects[name].usage,\nsln.projects[name], sln.projects[name].usageProj)\nend\nconfiguration { }\nreturn premake.CurrentContainer\nend\nfunction project(name)\nif (not name) then\nif(typex(premake.CurrentContainer) ~= \"project\") then return nil end\nif(premake.CurrentContainer.usage) then return nil end\nreturn premake.CurrentContainer\nend\nlocal sln\nif (typex(pre"
	"make.CurrentContainer) == \"project\") then\nsln = premake.CurrentContainer.solution\nelse\nsln = premake.CurrentContainer\nend\nif (typex(sln) ~= \"solution\") then\nerror(\"no active solution\", 2)\nend\nif((not sln.projects[name]) or sln.projects[name].usage) then\npremake.CurrentContainer = createproject(name, sln)\nelse\npremake.CurrentContainer = sln.projects[name];\nend\nconfiguration { }\nreturn premake.CurrentContainer\nend\nfunction solution(name)\nif not name then\nif typex(premake.CurrentContainer) == \"project\" then\nreturn premake.CurrentContainer.solution\nelse\nreturn premake.CurrentContainer\nend\nend\npremake.CurrentContainer = premake.solution.get(name)\nif (not premake.CurrentContainer) then\npremake.CurrentContainer = premake.solution.new(name)\nend\nconfiguration { }\nreturn premake.CurrentContainer\nend\nfunction group(name)\nif not name then\nreturn premake.CurrentGroup\nend\npremake.CurrentGroup = name\nreturn premake.CurrentGroup\nend\nfunction importvsproject(location)\nif string.fi"
	"nd(_ACTION, \"vs\") ~= 1 then\nerror(\"Only available for visual studio actions\")\nend\nsln, err = premake.getobject(\"solution\")\nif not sln then\nerror(err)\nend\nlocal group = creategroupsfrompath(premake.CurrentGroup, sln)\nlocal project = {}\nproject.location = location\nproject.group = group\nproject.flags = {}\ntable.insert(sln.importedprojects, project)\n    end\nfunction newaction(a)\npremake.action.add(a)\nend\nfunction newoption(opt)\npremake.option.add(opt)\nend\nfunction enablefilelevelconfig()\npremake._filelevelconfig = true\nend\nfunction newapifield(field)\npremake.fields[field.name] = field\n_G[field.name] = function(value)\nreturn accessor(field.name, value)\nend\nif field.kind == \"list\"\nor field.kind == \"dirlist\"\nor field.kind == \"filelist\"\nor field.kind == \"absolutefilelist\"\nthen\nif  field.name ~= \"removefiles\"\nand field.name ~= \"files\" then\n_G[\"remove\"..field.name] = function(value)\npremake.remove(field.name, value)\nend\nend\nend\nend\nnewapifield {\nname  = \"arc"
	"hivesplit_size\",\nkind  = \"string\",\nscope = \"config\",\n}\nnewapifield {\nname  = \"basedir\",\nkind  = \"path\",\nscope = \"container\",\n}\nnewapifield {\nname  = \"buildaction\",\nkind  = \"string\",\nscope = \"config\",\nallowed = {\n\"Compile\",\n\"Copy\",\n\"Embed\",\n\"None\"\n}\n}\nnewapifield {\nname  = \"buildoptions\",\nkind  = \"list\",\nscope = \"config\",\n}\nnewapifield {\nname  = \"buildoptions_asm\",\nkind  = \"list\",\nscope = \"config\",\n}\nnewapifield {\nname  = \"buildoptions_c\",\nkind  = \"list\",\nscope = \"config\",\n}\nnewapifield {\nname  = \"buildoptions_cpp\",\nkind  = \"list\",\nscope = \"config\",\n}\nnewapifield {\nname  = \"buildoptions_objc\",\nkind  = \"list\",\nscope = \"config\",\n}\nnewapifield {\nname  = \"buildoptions_objcpp\",\nkind  = \"list\",\nscope = \"config\",\n}\nnewapifield {\nname  = \"buildoptions_vala\",\nkind  = \"list\",\nscope = \"config\",\n}\nnewapifield {\nname  = \"clrreferences\",\nkind = \"list\",\nscope = \"container\",\n}\nnewapifield {\nname"
	"  = \"configurations\",\nkind  = \"list\",\nscope = \"solution\",\n}\nnewapifield {\nname  = \"custombuildtask\",\nkind  = \"table\",\nscope = \"config\",\n}\nnewapifield {\nname  = \"debugcmd\",\nkind = \"string\",\nscope = \"config\",\n}\nnewapifield {\nname  = \"debugargs\",\nkind = \"list\",\nscope = \"config\",\n}\nnewapifield {\nname  = \"debugdir\",\nkind = \"path\",\nscope = \"config\",\n}\nnewapifield {\nname  = \"debugenvs\" ,\nkind = \"list\",\nscope = \"config\",\n}\nnewapifield {\nname  = \"defines\",\nkind  = \"list\",\nscope = \"config\",\n}\nnewapifield {\nname  = \"deploymentoptions\",\nkind  = \"list\",\nscope = \"config\",\nusagecopy = true,\n}\nnewapifield {\nname  = \"dependency\",\nkind  = \"table\",\nscope = \"config\",\n}\nnewapifield {\nname  = \"deploymode\",\nkind = \"string\",\nscope = \"config\",\n}\nnewapifield {\nname  = \"excludes\",\nkind  = \"filelist\",\nscope = \"config\",\n}\nnewapifield {\nname  = \"forcenative\",\nkind = \"filelist\",\nscope = \"config\",\n}\nnewapifield "
	"{\nname  = \"nopch\",\nkind  = \"filelist\",\nscope = \"config\",\n}\nnewapifield {\nname  = \"files\",\nkind  = \"filelist\",\nscope = \"config\",\n}\nnewapifield {\nname  = \"removefiles\",\nkind  = \"filelist\",\nscope = \"config\",\n}\nnewapifield {\nname  = \"flags\",\nkind  = \"list\",\nscope = \"config\",\nisflags = true,\nusagecopy = true,\nallowed = function(value)\nlocal allowed_flags = {\nAntBuildDebuggable = 1,\nC7DebugInfo = 1,\nCpp11 = 1,\nCpp14 = 1,\nCpp17 = 1,\nCpp20 = 1,\nCppLatest = 1,\nDebugEnvsDontMerge = 1,\nDebugEnvsInherit = 1,\nDeploymentContent = 1,\nEnableMinimalRebuild = 1,\nEnableSSE = 1,\nEnableSSE2 = 1,\nEnableAVX = 1,\nEnableAVX2 = 1,\nPedanticWarnings = 1,\nExtraWarnings = 1,\nFatalWarnings = 1,\nFloatFast = 1,\nFloatStrict = 1,\nFullSymbols = 1,\nGenerateMapFiles = 1,\nHotpatchable = 1,\nLinkSupportCircularDependencies = 1,\nManaged = 1,\nMinimumWarnings = 1,\nNativeWChar = 1,\nNo64BitChecks = 1,\nNoBufferSecurityCheck = 1,\nNoEditAndContinue = 1,\nNoExceptions = 1,\nNoFramePoi"
	"nter = 1,\nNoImportLib = 1,\nNoIncrementalLink = 1,\nNoJMC = 1,\nNoManifest = 1,\nNoMultiProcessorCompilation = 1,\nNoNativeWChar = 1,\nNoOptimizeLink = 1,\nNoPCH = 1,\nNoRTTI = 1,\nNoRuntimeChecks = 1,\nNoWinMD = 1,    -- explicitly disables Windows Metadata\nNoWinRT = 1,    -- explicitly disables Windows Runtime Extension\nFastCall = 1,\nStdCall = 1,\nSingleOutputDir = 1,\nObjcARC = 1,\nOptimize = 1,\nOptimizeSize = 1,\nOptimizeSpeed = 1,\nDebugRuntime = 1,\nReleaseRuntime = 1,\nSEH = 1,\nStaticRuntime = 1,\nSymbols = 1,\nUnicode = 1,\nUnitySupport = 1,\nUnsafe = 1,\nUnsignedChar = 1,\nUseFullPaths = 1,\nUseLDResponseFile = 1,\nUseObjectResponseFile = 1,\nWinMain = 1\n}\nlocal englishToAmericanSpelling =\n{\nnooptimiselink = 'nooptimizelink',\noptimise = 'optimize',\noptimisesize = 'optimizesize',\noptimisespeed = 'optimizespeed',\n}\nlocal lowervalue = value:lower()\nlowervalue = englishToAmericanSpelling[lowervalue] or lowervalue\nfor v, _ in pairs(allowed_flags) do\nif v:lower() == lowervalue then\nreturn"
	" v\nend\nend\nreturn nil, \"invalid flag\"\nend,\n}\nnewapifield {\nname  = \"framework\",\nkind = \"string\",\nscope = \"container\",\nallowed = {\n\"1.0\",\n\"1.1\",\n\"2.0\",\n\"3.0\",\n\"3.5\",\n\"4.0\",\n\"4.5\",\n\"4.5.1\",\n\"4.5.2\",\n\"4.6\",\n\"4.6.1\",\n\"4.6.2\",\n}\n}\nnewapifield {\nname  = \"iostargetplatformversion\",\nkind  = \"string\",\nscope = \"project\",\n}\nnewapifield {\nname  = \"macostargetplatformversion\",\nkind  = \"string\",\nscope = \"project\",\n}\nnewapifield {\nname  = \"tvostargetplatformversion\",\nkind  = \"string\",\nscope = \"project\",\n}\nnewapifield {\nname  = \"visionostargetplatformversion\",\nkind  = \"string\",\nscope = \"project\",\n}\nnewapifield {\nname  = \"windowstargetplatformversion\",\nkind  = \"string\",\nscope = \"project\",\n}\nnewapifield {\nname  = \"windowstargetplatformminversion\",\nkind = \"string\",\nscope = \"project\",\n}\nnewapifield {\nname  = \"forcedincludes\",\nkind  = \"list\",\nscope = \"config\",\n}\nnewapifield {\nname  = \"imagepath\","
	"\nkind = \"path\",\nscope = \"config\",\n}\nnewapifield {\nname  = \"imageoptions\",\nkind  = \"list\",\nscope = \"config\",\n}\nnewapifield {\nname  = \"implibdir\",\nkind  = \"path\",\nscope = \"config\",\n}\nnewapifield {\nname  = \"implibextension\",\nkind  = \"string\",\nscope = \"config\",\n}\nnewapifield {\nname  = \"implibname\",\nkind  = \"string\",\nscope = \"config\",\n}\nnewapifield {\nname  = \"implibprefix\",\nkind  = \"string\",\nscope = \"config\",\n}\nnewapifield {\nname  = \"implibsuffix\",\nkind  = \"string\",\nscope = \"config\",\n}\nnewapifield {\nname  = \"includedirs\",\nkind  = \"dirlist\",\nscope = \"config\",\nusagecopy = true,\n}\nnewapifield {\nname  = \"systemincludedirs\",\nkind  = \"dirlist\",\nscope = \"config\",\nusagecopy = true,\n}\nnewapifield {\nname  = \"userincludedirs\",\nkind  = \"dirlist\",\nscope = \"config\",\nusagecopy = true,\n}\nnewapifield {\nname  = \"usingdirs\",\nkind  = \"dirlist\",\nscope = \"config\",\nusagecopy = true,\n}\nnewapifield {\nname  = \"kind\","
	"\nkind  = \"string\",\nscope = \"config\",\nallowed = {\n\"ConsoleApp\",\n\"WindowedApp\",\n\"StaticLib\",\n\"SharedLib\",\n\"Bundle\",\n}\n}\nnewapifield {\nname  = \"language\",\nkind  = \"string\",\nscope = \"container\",\nallowed = {\n\"C\",\n\"C++\",\n\"C#\",\n\"Vala\",\n\"Swift\",\n}\n}\nnewapifield {\nname  = \"libdirs\",\nkind  = \"dirlist\",\nscope = \"config\",\nlinkagecopy = true,\n}\nnewapifield {\nname  = \"linkoptions\",\nkind  = \"list\",\nscope = \"config\",\n}\nnewapifield {\nname  = \"links\",\nkind  = \"list\",\nscope = \"config\",\nallowed = function(value)\nif value:find('/', nil, true) then\nvalue = path.getabsolute(value)\nend\nreturn value\nend,\nlinkagecopy = true,\nmergecopiestotail = true,\n}\nnewapifield {\nname  = \"location\",\nkind  = \"path\",\nscope = \"container\",\n}\nnewapifield {\nname  = \"makesettings\",\nkind = \"list\",\nscope = \"config\",\n}\nnewapifield {\nname  = \"messageskip\",\nkind  = \"list\",\nscope = \"solution\",\nisflags = true,\nusagecopy = true,\nallowed "
	"= function(value)\nlocal allowed_messages = {\nSkipCreatingMessage = 1,\nSkipBuildingMessage = 1,\nSkipCleaningMessage = 1,\n}\nlocal lowervalue = value:lower()\nfor v, _ in pairs(allowed_messages) do\nif v:lower() == lowervalue then\nreturn v\nend\nend\nreturn nil, \"invalid message to skip\"\nend,\n}\nnewapifield {\nname  = \"msgarchiving\",\nkind  = \"string\",\nscope = \"config\",\n}\nnewapifield {\nname  = \"msgcompile\",\nkind  = \"string\",\nscope = \"config\",\n}\nnewapifield {\nname  = \"msgprecompile\",\nkind  = \"string\",\nscope = \"config\",\n}\nnewapifield {\nname  = \"msgcompile_objc\",\nkind  = \"string\",\nscope = \"config\",\n}\nnewapifield {\nname  = \"msgresource\",\nkind  = \"string\",\nscope = \"config\",\n}\nnewapifield {\nname  = \"msglinking\",\nkind  = \"string\",\nscope = \"config\",\n}\nnewapifield {\nname  = \"objdir\",\nkind  = \"path\",\nscope = \"config\",\n}\nnewapifield {\nname  = \"options\",\nkind  = \"list\",\nscope = \"container\",\nisflags = true,\nusagecopy = true,\nallo"
	"wed = function(value)\nlocal allowed_options = {\nForceCPP = 1,\nArchiveSplit = 1,\nSkipBundling = 1,\nXcodeLibrarySchemes = 1,\nXcodeSchemeNoConfigs = 1,\n}\nlocal lowervalue = value:lower()\nfor v, _ in pairs(allowed_options) do\nif v:lower() == lowervalue then\nreturn v\nend\nend\nreturn nil, \"invalid option\"\nend,\n}\nnewapifield {\nname  = \"pchheader\",\nkind  = \"string\",\nscope = \"config\",\n}\nnewapifield {\nname  = \"pchsource\",\nkind  = \"path\",\nscope = \"config\",\n}\nnewapifield {\nname  = \"platforms\",\nkind  = \"list\",\nscope = \"solution\",\nallowed = table.keys(premake.platforms),\n}\nnewapifield {\nname  = \"postbuildcommands\",\nkind  = \"list\",\nscope = \"config\",\n}\nnewapifield {\nname  = \"prebuildcommands\",\nkind  = \"list\",\nscope = \"config\",\n}\nnewapifield {\nname  = \"postcompiletasks\",\nkind  = \"list\",\nscope = \"config\",\n}\nnewapifield {\nname  = \"prelinkcommands\",\nkind  = \"list\",\nscope = \"config\",\n}\nnewapifield {\nname  = \"propertysheets\",\nkind  ="
	" \"dirlist\",\nscope = \"config\",\n}\nnewapifield {\nname  = \"pullmappingfile\",\nkind  = \"path\",\nscope = \"config\",\n}\nnewapifield {\nname  = \"applicationdatadir\",\nkind  = \"path\",\nscope = \"config\",\n}\nnewapifield {\nname  = \"finalizemetasource\",\nkind  = \"path\",\nscope = \"config\",\n}\nnewapifield {\nname  = \"resdefines\",\nkind  = \"list\",\nscope = \"config\",\n}\nnewapifield {\nname  = \"resincludedirs\",\nkind  = \"dirlist\",\nscope = \"config\",\n}\nnewapifield {\nname  = \"resoptions\",\nkind  = \"list\",\nscope = \"config\",\n}\nnewapifield {\nname  = \"sdkreferences\",\nkind  = \"list\",\nscope = \"config\",\n}\nnewapifield {\nname  = \"startproject\",\nkind  = \"string\",\nscope = \"solution\",\n}\nnewapifield {\nname  = \"targetdir\",\nkind  = \"path\",\nscope = \"config\",\n}\nnewapifield {\nname  = \"targetsubdir\",\nkind  = \"string\",\nscope = \"config\",\n}\nnewapifield {\nname  = \"targetextension\",\nkind  = \"string\",\nscope = \"config\",\n}\nnewapifield {\nname  = \"t"
	"argetname\",\nkind  = \"string\",\nscope = \"config\",\n}\nnewapifield {\nname  = \"targetprefix\",\nkind  = \"string\",\nscope = \"config\",\n}\nnewapifield {\nname  = \"targetsuffix\",\nkind  = \"string\",\nscope = \"config\",\n}\nnewapifield {\nname  = \"trimpaths\",\nkind = \"dirlist\",\nscope = \"config\",\n}\nnewapifield {\nname  = \"uuid\",\nkind  = \"string\",\nscope = \"container\",\nallowed = function(value)\nlocal ok = true\nif (#value ~= 36) then ok = false end\nfor i=1,36 do\nlocal ch = value:sub(i,i)\nif (not ch:find(\"[ABCDEFabcdef0123456789-]\")) then ok = false end\nend\nif (value:sub(9,9) ~= \"-\")   then ok = false end\nif (value:sub(14,14) ~= \"-\") then ok = false end\nif (value:sub(19,19) ~= \"-\") then ok = false end\nif (value:sub(24,24) ~= \"-\") then ok = false end\nif (not ok) then\nreturn nil, \"invalid UUID\"\nend\nreturn value:upper()\nend\n}\nnewapifield {\nname  = \"uses\",\nkind  = \"list\",\nscope = \"config\",\n}\nnewapifield {\nname  = \"vapidirs\",\nkind  = \"dirlist\",\nsc"
	"ope = \"config\",\n}\nnewapifield {\nname  = \"vpaths\",\nkind = \"keypath\",\nscope = \"container\",\n}\nnewapifield {\nname  = \"vsimportreferences\",\nkind = \"filelist\",\nscope = \"container\",\n}\nnewapifield {\nname  = \"dpiawareness\",\nkind = \"string\",\nscope = \"config\",\nallowed = {\n\"None\",\n\"High\",\n\"HighPerMonitor\",\n}\n}\nnewapifield {\nname  = \"xcodeprojectopts\",\nkind = \"table\",\nscope = \"config\",\n}\nnewapifield {\nname  = \"xcodetargetopts\",\nkind = \"table\",\nscope = \"config\",\n}\nnewapifield {\nname  = \"xcodescriptphases\",\nkind  = \"table\",\nscope = \"config\",\n}\nnewapifield {\nname  = \"xcodecopyresources\",\nkind  = \"table\",\nscope = \"project\",\n}\nnewapifield {\nname  = \"xcodecopyframeworks\",\nkind  = \"filelist\",\nscope = \"project\",\n}\nnewapifield {\nname  = \"wholearchive\",\nkind  = \"list\",\nscope = \"config\",\n}\nnewapifield {\nname  = \"swiftmodulemaps\",\nkind  = \"filelist\",\nscope = \"config\",\n}\nnewapifield {\nname  = \"buildoptions_swif"
	"t\",\nkind  = \"list\",\nscope = \"config\",\n}\nnewapifield {\nname  = \"linkoptions_swift\",\nkind  = \"list\",\nscope = \"config\",\n}\nnewapifield {\nname  = \"androidtargetapi\",\nkind = \"string\",\nscope = \"config\",\n}\nnewapifield {\nname  = \"androidminapi\",\nkind = \"string\",\nscope = \"config\",\n}\nnewapifield {\nname  = \"androidarch\",\nkind = \"string\",\nscope = \"config\",\nallowed = {\n\"armv7-a\",\n\"armv7-a-hard\",\n\"arm64-v8a\",\n\"x86\",\n\"x86_64\",\n}\n}\nnewapifield {\nname  = \"androidndktoolchainversion\",\nkind = \"string\",\nscope = \"config\",\n}\nnewapifield {\nname  = \"androidstltype\",\nkind = \"string\",\nscope = \"config\",\n}\nnewapifield {\nname  = \"androidcppstandard\",\nkind = \"string\",\nscope = \"config\",\nallowed = {\n\"c++98\",\n\"c++11\",\n\"c++1y\",\n\"gnu++98\",\n\"gnu++11\",\n\"gnu++1y\",\n}\n}\nnewapifield {\nname  = \"androidlinker\",\nkind = \"string\",\nscope = \"config\",\nallowed = {\n\"bfd\",\n\"gold\",\n}\n}\nnewapifield {\nname  = \"androiddebugi"
	"ntentparams\",\nkind = \"list\",\nscope = \"config\",\n}\nnewapifield {\nname  = \"antbuildjavasourcedirs\",\nkind = \"dirlist\",\nscope = \"config\",\n}\nnewapifield {\nname  = \"antbuildjardirs\",\nkind = \"dirlist\",\nscope = \"config\",\n}\nnewapifield {\nname  = \"antbuildjardependencies\",\nkind = \"list\",\nscope = \"config\",\n}\nnewapifield {\nname  = \"antbuildnativelibdirs\",\nkind = \"dirlist\",\nscope = \"config\",\n}\nnewapifield {\nname  = \"antbuildnativelibdependencies\",\nkind = \"list\",\nscope = \"config\",\n}\nnewapifield {\nname  = \"antbuildassetsdirs\",\nkind = \"dirlist\",\nscope = \"config\",\n}\nnewapifield {\nname  = \"postsolutioncallbacks\",\nkind  = \"list\",\nscope = \"solution\",\n}\nnewapifield {\nname  = \"postprojectcallbacks\",\nkind  = \"list\",\nscope = \"project\",\n}\n",

	/* base/cmdline.lua */
	"newoption\n{\ntrigger     = \"cc\",\nvalue       = \"VALUE\",\ndescription = \"Choose a C/C++ compiler set\",\nallowed = {\n{ \"gcc\", \"GNU GCC (gcc/g++)\" },\n{ \"ow\",  \"OpenWatcom\"        },\n{ \"ghs\", \"Green Hills Software\" },\n}\n}\nnewoption\n{\ntrigger     = \"dotnet\",\nvalue       = \"VALUE\",\ndescription = \"Choose a .NET compiler set\",\nallowed = {\n{ \"msnet\",   \"Microsoft .NET (csc)\" },\n{ \"mono\",    \"Novell Mono (mcs)\"    },\n{ \"pnet\",    \"Portable.NET (cscc)\"  },\n}\n}\nnewoption\n{\ntrigger     = \"file\",\nvalue       = \"FILE\",\ndescription = \"Read FILE as a Premake script; default is 'premake4.lua'\"\n}\nnewoption\n{\ntrigger     = \"help\",\ndescription = \"Display this information\"\n}\nnewoption\n{\ntrigger     = \"os\",\nvalue       = \"VALUE\",\ndescription = \"Generate files for a different operating system\",\nallowed = {\n{ \"bsd\",      \"OpenBSD, NetBSD, or FreeBSD\" },\n{ \"linux\",    \"Linux\" },\n{ \"macosx\",   \"Apple Mac OS X\" },\n{ \"solaris\",  \"Sola"
	"ris\" },\n{ \"windows\",  \"Microsoft Windows\" },\n}\n}\nnewoption\n{\ntrigger     = \"platform\",\nvalue       = \"VALUE\",\ndescription = \"Add target architecture (if supported by action)\",\nallowed = {\n{ \"x32\",         \"32-bit\" },\n{ \"x64\",         \"64-bit\" },\n{ \"universal\",   \"Mac OS X Universal, 32- and 64-bit\" },\n{ \"universal32\", \"Mac OS X Universal, 32-bit only\" },\n{ \"universal64\", \"Mac OS X Universal, 64-bit only\" },\n{ \"ps3\",         \"Playstation 3\" },\n{ \"orbis\",       \"Playstation 4\" },\n{ \"xbox360\",     \"Xbox 360\" },\n{ \"durango\",     \"Xbox One\" },\n{ \"ARM\",         \"ARM\" },\n{ \"ARM64\",         \"ARM64\" },\n{ \"PowerPC\",     \"PowerPC\" },\n{ \"nx32\",        \"Nintendo Switch, 32-bit only\" },\n{ \"nx64\",        \"Nintendo Switch, 64-bit only\" },\n{ \"gdk-desktop\", \"GDK Windows Desktop\" },\n{ \"gdk-xboxone\", \"GDK Xbox One\" },\n{ \"gdk-scarlett\",\"GDK Xbox Scarlett\" },\n}\n}\nnewoption\n{\ntrigger     = \"scripts\",\nvalue       = \"path"
	"\",\ndescription = \"Search for additional scripts on the given path\"\n}\nnewoption\n{\ntrigger     = \"debug-profiler\",\ndescription = \"GENie script generation profiler.\"\n}\nnewoption\n{\ntrigger     = \"version\",\ndescription = \"Display version information\"\n}\n",

	/* base/inspect.lua */
	"-- Copyright (c) 2013 Enrique García Cota\nlocal function smartQuote(str)\n  if str:match('\"') and not str:match(\"'\") then\n    return \"'\" .. str .. \"'\"\n  end\n  return '\"' .. str:gsub('\"', '\\\\\"') .. '\"'\nend\nlocal controlCharsTranslation = {\n  [\"\\a\"] = \"\\\\a\",  [\"\\b\"] = \"\\\\b\", [\"\\f\"] = \"\\\\f\",  [\"\\n\"] = \"\\\\n\",\n  [\"\\r\"] = \"\\\\r\",  [\"\\t\"] = \"\\\\t\", [\"\\v\"] = \"\\\\v\"\n}\nlocal function escapeChar(c) return controlCharsTranslation[c] end\nlocal function escape(str)\n  local result = str:gsub(\"\\\\\", \"\\\\\\\\\"):gsub(\"(%c)\", escapeChar)\n  return result\nend\nlocal function isIdentifier(str)\n  return type(str) == 'string' and str:match( \"^[_%a][_%a%d]*$\" )\nend\nlocal function isArrayKey(k, length)\n  return type(k) == 'number' and 1 <= k and k <= length\nend\nlocal function isDictionaryKey(k, length)\n  return not isArrayKey(k, length)\nend\nlocal defaultTypeOrders = {\n  ['number']   = 1, ['boolean']  = 2, ['string'] = 3, ['table'] = 4,\n  ['fu"
	"nction'] = 5, ['userdata'] = 6, ['thread'] = 7\n}\nlocal function sortKeys(a, b)\n  local ta, tb = type(a), type(b)\n  -- strings and numbers are sorted numerically/alphabetically\n  if ta == tb and (ta == 'string' or ta == 'number') then return a < b end\n  local dta, dtb = defaultTypeOrders[ta], defaultTypeOrders[tb]\n  -- Two default types are compared according to the defaultTypeOrders table\n  if dta and dtb then return defaultTypeOrders[ta] < defaultTypeOrders[tb]\n  elseif dta     then return true  -- default types before custom ones\n  elseif dtb     then return false -- custom types after default ones\n  end\n  -- custom types are sorted out alphabetically\n  return ta < tb\nend\nlocal function getDictionaryKeys(t)\n  local keys, length = {}, #t\n  for k,_ in pairs(t) do\n    if isDictionaryKey(k, length) then table.insert(keys, k) end\n  end\n  table.sort(keys, sortKeys)\n  return keys\nend\nlocal function getToStringResultSafely(t, mt)\n  local __tostring = type(mt) == 'table' and rawget(mt, '__tost"
	"ring')\n  local str, ok\n  if type(__tostring) == 'function' then\n    ok, str = pcall(__tostring, t)\n    str = ok and str or 'error: ' .. tostring(str)\n  end\n  if type(str) == 'string' and #str > 0 then return str end\nend\nlocal maxIdsMetaTable = {\n  __index = function(self, typeName)\n    rawset(self, typeName, 0)\n    return 0\n  end\n}\nlocal idsMetaTable = {\n  __index = function (self, typeName)\n    local col = setmetatable({}, {__mode = \"kv\"})\n    rawset(self, typeName, col)\n    return col\n  end\n}\nlocal function countTableAppearances(t, tableAppearances)\n  tableAppearances = tableAppearances or setmetatable({}, {__mode = \"k\"})\n  if type(t) == 'table' then\n    if not tableAppearances[t] then\n      tableAppearances[t] = 1\n      for k,v in pairs(t) do\n        countTableAppearances(k, tableAppearances)\n        countTableAppearances(v, tableAppearances)\n      end\n      countTableAppearances(getmetatable(t), tableAppearances)\n    else\n      tableAppearances[t] = tableAppearances[t] +"
	" 1\n    end\n  end\n  return tableAppearances\nend\nlocal function parse_filter(filter)\n  if type(filter) == 'function' then return filter end\n  -- not a function, so it must be a table or table-like\n  filter = type(filter) == 'table' and filter or {filter}\n  local dictionary = {}\n  for _,v in pairs(filter) do dictionary[v] = true end\n  return function(x) return dictionary[x] end\nend\nlocal function makePath(path, key)\n  local newPath, len = {}, #path\n  for i=1, len do newPath[i] = path[i] end\n  newPath[len+1] = key\n  return newPath\nend\nfunction inspect(rootObject, options)\n  options       = options or {}\n  local depth   = options.depth or math.huge\n  local filter  = parse_filter(options.filter or {})\n  local tableAppearances = countTableAppearances(rootObject)\n  local buffer = {}\n  local maxIds = setmetatable({}, maxIdsMetaTable)\n  local ids    = setmetatable({}, idsMetaTable)\n  local level  = 0\n  local blen   = 0 -- buffer length\n  local function puts(...)\n    local args = {...}\n    "
	"for i=1, #args do\n      blen = blen + 1\n      buffer[blen] = tostring(args[i])\n    end\n  end\n  local function down(f)\n    level = level + 1\n    f()\n    level = level - 1\n  end\n  local function tabify()\n    puts(\"\\n\", string.rep(\"  \", level))\n  end\n  local function commaControl(needsComma)\n    if needsComma then puts(',') end\n    return true\n  end\n  local function alreadyVisited(v)\n    return ids[type(v)][v] ~= nil\n  end\n  local function getId(v)\n    local tv = type(v)\n    local id = ids[tv][v]\n    if not id then\n      id         = maxIds[tv] + 1\n      maxIds[tv] = id\n      ids[tv][v] = id\n    end\n    return id\n  end\n  local putValue -- forward declaration that needs to go before putTable & putKey\n  local function putKey(k)\n    if isIdentifier(k) then return puts(k) end\n    puts( \"[\" )\n    putValue(k, {})\n    puts(\"]\")\n  end\n  local function putTable(t, path)\n    if alreadyVisited(t) then\n      puts('<table ', getId(t), '>')\n    elseif level >= depth then\n      "
	"puts('{...}')\n    else\n      if tableAppearances[t] > 1 then puts('<', getId(t), '>') end\n      local dictKeys          = getDictionaryKeys(t)\n      local length            = #t\n      local mt                = getmetatable(t)\n      local to_string_result  = getToStringResultSafely(t, mt)\n      puts('{')\n      down(function()\n        if to_string_result then\n          puts(' -- ', escape(to_string_result))\n          if length >= 1 then tabify() end -- tabify the array values\n        end\n        local needsComma = false\n        for i=1, length do\n          needsComma = commaControl(needsComma)\n          puts(' ')\n          putValue(t[i], makePath(path, i))\n        end\n        for _,k in ipairs(dictKeys) do\n          needsComma = commaControl(needsComma)\n          tabify()\n          putKey(k)\n          puts(' = ')\n          putValue(t[k], makePath(path, k))\n        end\n        if mt then\n          needsComma = commaControl(needsComma)\n          tabify()\n          puts('<metatable> = '"
	")\n          putValue(mt, makePath(path, '<metatable>'))\n        end\n      end)\n      if #dictKeys > 0 or mt then -- dictionary table. Justify closing }\n        tabify()\n      elseif length > 0 then -- array tables have one extra space before closing }\n        puts(' ')\n      end\n      puts('}')\n    end\n  end\n  -- putvalue is forward-declared before putTable & putKey\n  putValue = function(v, path)\n    if filter(v, path) then\n      puts('<filtered>')\n    else\n      local tv = type(v)\n      if tv == 'string' then\n        puts(smartQuote(escape(v)))\n      elseif tv == 'number' or tv == 'boolean' or tv == 'nil' then\n        puts(tostring(v))\n      elseif tv == 'table' then\n        putTable(v, path)\n      else\n        puts('<',tv,' ',getId(v),'>')\n      end\n    end\n  end\n  putValue(rootObject, {})\n  return table.concat(buffer)\nend\nfunction printtable(name, table)\nprint(\"table: \", name, inspect(table), \"\\n\")\nend\nfunction printstack()\nprint(debug.traceback(), \"\\n\")\nend\n",

	/* base/profiler.lua */
	"_profiler = {}\nfunction newProfiler(variant, sampledelay)\nif _profiler.running then\nprint(\"Profiler already running.\")\nreturn\nend\nvariant = variant or \"time\"\nif variant ~= \"time\" and variant ~= \"call\" then\nprint(\"Profiler method must be 'time' or 'call'.\")\nreturn\nend\nlocal newprof = {}\nfor k,v in pairs(_profiler) do\nnewprof[k] = v\nend\nnewprof.variant = variant\nnewprof.sampledelay = sampledelay or 100000\nreturn newprof\nend\nfunction _profiler.start(self)\nif _profiler.running then\nreturn\nend\n_profiler.running = self\nself.rawstats = {}\nself.callstack = {}\nif self.variant == \"time\" then\nself.lastclock = os.clock()\ndebug.sethook( _profiler_hook_wrapper_by_time, \"\", self.sampledelay )\nelseif self.variant == \"call\" then\ndebug.sethook( _profiler_hook_wrapper_by_call, \"cr\" )\nelse\nprint(\"Profiler method must be 'time' or 'call'.\")\nsys.exit(1)\nend\nend\nfunction _profiler.stop(self)\nif _profiler.running ~= self then\nreturn\nend\ndebug.sethook( nil )\n_profiler.runnin"
	"g = nil\nend\nfunction _profiler_hook_wrapper_by_call(action)\nif _profiler.running == nil then\ndebug.sethook( nil )\nend\n_profiler.running:_internal_profile_by_call(action)\nend\nfunction _profiler_hook_wrapper_by_time(action)\nif _profiler.running == nil then\ndebug.sethook( nil )\nend\n_profiler.running:_internal_profile_by_time(action)\nend\nfunction _profiler._internal_profile_by_call(self,action)\nlocal caller_info = debug.getinfo( 3 )\nif caller_info == nil then\nprint \"No caller_info\"\nreturn\nend\nlocal latest_ar = nil\nif table.getn(self.callstack) > 0 then\nlatest_ar = self.callstack[table.getn(self.callstack)]\nend\nlocal should_not_profile = 0\nfor k,v in pairs(self.prevented_functions) do\nif k == caller_info.func then\nshould_not_profile = v\nend\nend\nif latest_ar then\nif latest_ar.should_not_profile == 2 then\nshould_not_profile = 2\nend\nend\nif action == \"call\" then\nlocal this_ar = {}\nthis_ar.should_not_profile = should_not_profile\nthis_ar.parent_ar = latest_ar\nthis_ar.anon_child "
	"= 0\nthis_ar.name_child = 0\nthis_ar.children = {}\nthis_ar.children_time = {}\nthis_ar.clock_start = os.clock()\ntable.insert( self.callstack, this_ar )\nelse\nlocal this_ar = latest_ar\nif this_ar == nil then\nreturn -- No point in doing anything if no upper activation record\nend\nthis_ar.clock_end = os.clock()\nthis_ar.this_time = this_ar.clock_end - this_ar.clock_start\nif this_ar.parent_ar then\nthis_ar.parent_ar.children[caller_info.func] =\n(this_ar.parent_ar.children[caller_info.func] or 0) + 1\nthis_ar.parent_ar.children_time[caller_info.func] =\n(this_ar.parent_ar.children_time[caller_info.func] or 0 ) +\nthis_ar.this_time\nif caller_info.name == nil then\nthis_ar.parent_ar.anon_child =\nthis_ar.parent_ar.anon_child + this_ar.this_time\nelse\nthis_ar.parent_ar.name_child =\nthis_ar.parent_ar.name_child + this_ar.this_time\nend\nend\nif this_ar.should_not_profile == 0 then\nlocal inforec = self:_get_func_rec(caller_info.func,1)\ninforec.count = inforec.count + 1\ninforec.time = inforec.time + this_ar"
	".this_time\ninforec.anon_child_time = inforec.anon_child_time + this_ar.anon_child\ninforec.name_child_time = inforec.name_child_time + this_ar.name_child\ninforec.func_info = caller_info\nfor k,v in pairs(this_ar.children) do\ninforec.children[k] = (inforec.children[k] or 0) + v\ninforec.children_time[k] =\n(inforec.children_time[k] or 0) + this_ar.children_time[k]\nend\nend\ntable.remove( self.callstack, table.getn( self.callstack ) )\nend\nend\nfunction _profiler._internal_profile_by_time(self,action)\nlocal timetaken = os.clock() - self.lastclock\nlocal depth = 3\nlocal at_top = true\nlocal last_caller\nlocal caller = debug.getinfo(depth)\nwhile caller do\nif not caller.func then caller.func = \"(tail call)\" end\nif self.prevented_functions[caller.func] == nil then\nlocal info = self:_get_func_rec(caller.func, 1, caller)\ninfo.count = info.count + 1\ninfo.time = info.time + timetaken\nif last_caller then\nif last_caller.name then\ninfo.name_child_time = info.name_child_time + timetaken\nelse\ninfo.anon_ch"
	"ild_time = info.anon_child_time + timetaken\nend\ninfo.children[last_caller.func] =\n(info.children[last_caller.func] or 0) + 1\ninfo.children_time[last_caller.func] =\n(info.children_time[last_caller.func] or 0) + timetaken\nend\nend\ndepth = depth + 1\nlast_caller = caller\ncaller = debug.getinfo(depth)\nend\nself.lastclock = os.clock()\nend\nfunction _profiler._get_func_rec(self,func,force,info)\nlocal ret = self.rawstats[func]\nif ret == nil and force ~= 1 then\nreturn nil\nend\nif ret == nil then\nret = {}\nret.func = func\nret.count = 0\nret.time = 0\nret.anon_child_time = 0\nret.name_child_time = 0\nret.children = {}\nret.children_time = {}\nret.func_info = info\nself.rawstats[func] = ret\nend\nreturn ret\nend\nfunction _profiler.report( self, outfile, sort_by_total_time )\noutfile:write\n[[Lua Profile output created by profiler.lua. Copyright Pepperfish 2002+\n]]\nlocal terms = {}\nif self.variant == \"time\" then\nterms.capitalized = \"Sample\"\nterms.single = \"sample\"\nterms.pastverb = \"sampled\""
	"\nelseif self.variant == \"call\" then\nterms.capitalized = \"Call\"\nterms.single = \"call\"\nterms.pastverb = \"called\"\nelse\nassert(false)\nend\nlocal total_time = 0\nlocal ordering = {}\nfor func,record in pairs(self.rawstats) do\ntable.insert(ordering, func)\nend\nif sort_by_total_time then\ntable.sort( ordering,\nfunction(a,b) return self.rawstats[a].time > self.rawstats[b].time end\n)\nelse\ntable.sort( ordering,\nfunction(a,b)\nlocal arec = self.rawstats[a]\nlocal brec = self.rawstats[b]\nlocal atime = arec.time - (arec.anon_child_time + arec.name_child_time)\nlocal btime = brec.time - (brec.anon_child_time + brec.name_child_time)\nreturn atime > btime\nend\n)\nend\nfor i=1,#ordering do\nlocal func = ordering[i]\nlocal record = self.rawstats[func]\nlocal thisfuncname = \" \" .. self:_pretty_name(func) .. \" \"\nif string.len( thisfuncname ) < 42 then\nthisfuncname = string.rep( \"-\", math.floor((42 - string.len(thisfuncname))/2) ) .. thisfuncname\nthisfuncname = thisfuncname .. string.rep( \"-\", 42"
	" - string.len(thisfuncname) )\nend\ntotal_time = total_time + ( record.time - ( record.anon_child_time +\nrecord.name_child_time ) )\noutfile:write( string.rep( \"-\", 19 ) .. thisfuncname ..\nstring.rep( \"-\", 19 ) .. \"\\n\" )\noutfile:write( terms.capitalized..\" count:         \" ..\nstring.format( \"%4d\", record.count ) .. \"\\n\" )\noutfile:write( \"Time spend total:       \" ..\nstring.format( \"%4.3f\", record.time ) .. \"s\\n\" )\noutfile:write( \"Time spent in children: \" ..\nstring.format(\"%4.3f\",record.anon_child_time+record.name_child_time) ..\n\"s\\n\" )\nlocal timeinself =\nrecord.time - (record.anon_child_time + record.name_child_time)\noutfile:write( \"Time spent in self:     \" ..\nstring.format(\"%4.3f\", timeinself) .. \"s\\n\" )\noutfile:write( \"Time spent per \" .. terms.single .. \":  \" ..\nstring.format(\"%4.5f\", record.time/record.count) ..\n\"s/\" .. terms.single .. \"\\n\" )\noutfile:write( \"Time spent in self per \"..terms.single..\": \" ..\nstring.format( \"%4.5f\", timein"
	"self/record.count ) .. \"s/\" ..\nterms.single..\"\\n\" )\nlocal added_blank = 0\nfor k,v in pairs(record.children) do\nif self.prevented_functions[k] == nil or\nself.prevented_functions[k] == 0\nthen\nif added_blank == 0 then\noutfile:write( \"\\n\" ) -- extra separation line\nadded_blank = 1\nend\noutfile:write( \"Child \" .. self:_pretty_name(k) ..\nstring.rep( \" \", 41-string.len(self:_pretty_name(k)) ) .. \" \" ..\nterms.pastverb..\" \" .. string.format(\"%6d\", v) )\noutfile:write( \" times. Took \" ..\nstring.format(\"%4.2f\", record.children_time[k] ) .. \"s\\n\" )\nend\nend\noutfile:write( \"\\n\" ) -- extra separation line\noutfile:flush()\nend\noutfile:write( \"\\n\\n\" )\noutfile:write( \"Total time spent in profiled functions: \" ..\nstring.format(\"%5.3g\",total_time) .. \"s\\n\" )\noutfile:write( [[\nEND\n]] )\noutfile:flush()\nend\nfunction _profiler.lua_report(self,outfile)\nlocal ordering = {}\nlocal functonum = {}\nfor func,record in pairs(self.rawstats) do\ntable.insert(ordering, func)\nfu"
	"nctonum[func] = table.getn(ordering)\nend\noutfile:write(\n\"-- Profile generated by profiler.lua Copyright Pepperfish 2002+\\n\\n\" )\noutfile:write( \"-- Function names\\nfuncnames = {}\\n\" )\nfor i=1,table.getn(ordering) do\nlocal thisfunc = ordering[i]\noutfile:write( \"funcnames[\" .. i .. \"] = \" ..\nstring.format(\"%q\", self:_pretty_name(thisfunc)) .. \"\\n\" )\nend\noutfile:write( \"\\n\" )\noutfile:write( \"-- Function times\\nfunctimes = {}\\n\" )\nfor i=1,table.getn(ordering) do\nlocal thisfunc = ordering[i]\nlocal record = self.rawstats[thisfunc]\noutfile:write( \"functimes[\" .. i .. \"] = { \" )\noutfile:write( \"tot=\" .. record.time .. \", \" )\noutfile:write( \"achild=\" .. record.anon_child_time .. \", \" )\noutfile:write( \"nchild=\" .. record.name_child_time .. \", \" )\noutfile:write( \"count=\" .. record.count .. \" }\\n\" )\nend\noutfile:write( \"\\n\" )\noutfile:write( \"-- Child links\\nchildren = {}\\n\" )\nfor i=1,table.getn(ordering) do\nlocal thisfunc = ordering[i]\nlocal record"
	" = self.rawstats[thisfunc]\noutfile:write( \"children[\" .. i .. \"] = { \" )\nfor k,v in pairs(record.children) do\nif functonum[k] then -- non-recorded functions will be ignored now\noutfile:write( functonum[k] .. \", \" )\nend\nend\noutfile:write( \"}\\n\" )\nend\noutfile:write( \"\\n\" )\noutfile:write( \"-- Child call counts\\nchildcounts = {}\\n\" )\nfor i=1,table.getn(ordering) do\nlocal thisfunc = ordering[i]\nlocal record = self.rawstats[thisfunc]\noutfile:write( \"children[\" .. i .. \"] = { \" )\nfor k,v in record.children do\nif functonum[k] then -- non-recorded functions will be ignored now\noutfile:write( v .. \", \" )\nend\nend\noutfile:write( \"}\\n\" )\nend\noutfile:write( \"\\n\" )\noutfile:write( \"-- Child call time\\nchildtimes = {}\\n\" )\nfor i=1,table.getn(ordering) do\nlocal thisfunc = ordering[i]\nlocal record = self.rawstats[thisfunc];\noutfile:write( \"children[\" .. i .. \"] = { \" )\nfor k,v in pairs(record.children) do\nif functonum[k] then -- non-recorded functions will be ignor"
	"ed now\noutfile:write( record.children_time[k] .. \", \" )\nend\nend\noutfile:write( \"}\\n\" )\nend\noutfile:write( \"\\n\\n-- That is all.\\n\\n\" )\noutfile:flush()\nend\nfunction _profiler._pretty_name(self,func)\nlocal info = self.rawstats[ func ].func_info\nlocal name = \"\"\nif info.what == \"Lua\" then\nname = \"L:\"\nend\nif info.what == \"C\" then\nname = \"C:\"\nend\nif info.what == \"main\" then\nname = \" :\"\nend\nif info.name == nil then\nname = name .. \"<\"..tostring(func) .. \">\"\nelse\nname = name .. info.name\nend\nif info.source then\nname = name\nelse\nif info.what == \"C\" then\nname = name .. \"@?\"\nelse\nname = name .. \"@<string>\"\nend\nend\nname = name .. \":\"\nif info.what == \"C\" then\nname = name .. \"?\"\nelse\nname = name .. info.linedefined\nend\nreturn name\nend\nfunction _profiler.prevent(self, func, level)\nself.prevented_functions[func] = (level or 1)\nend\n_profiler.prevented_functions = {\n[_profiler.start] = 2,\n[_profiler.stop] = 2,\n[_profiler._internal_profile_by"
	"_time] = 2,\n[_profiler._internal_profile_by_call] = 2,\n[_profiler_hook_wrapper_by_time] = 2,\n[_profiler_hook_wrapper_by_call] = 2,\n[_profiler.prevent] = 2,\n[_profiler._get_func_rec] = 2,\n[_profiler.report] = 2,\n[_profiler.lua_report] = 2,\n[_profiler._pretty_name] = 2\n}\n",

	/* tools/dotnet.lua */
	"premake.dotnet = { }\npremake.dotnet.namestyle = \"windows\"\nlocal flags =\n{\nFatalWarning   = \"/warnaserror\",\nOptimize       = \"/optimize\",\nOptimizeSize   = \"/optimize\",\nOptimizeSpeed  = \"/optimize\",\nSymbols        = \"/debug\",\nUnsafe         = \"/unsafe\"\n}\nfunction premake.dotnet.getbuildaction(fcfg)\nlocal ext = path.getextension(fcfg.name):lower()\nif fcfg.buildaction == \"Compile\" or ext == \".cs\" then\nreturn \"Compile\"\nelseif fcfg.buildaction == \"Embed\" or ext == \".resx\" then\nreturn \"EmbeddedResource\"\nelseif fcfg.buildaction == \"Copy\" or ext == \".asax\" or ext == \".aspx\" then\nreturn \"Content\"\nelse\nreturn \"None\"\nend\nend\nfunction premake.dotnet.getcompilervar(cfg)\nif (_OPTIONS.dotnet == \"msnet\") then\nreturn \"csc\"\nelseif (_OPTIONS.dotnet == \"mono\") then\nreturn \"mcs\"\nelse\nreturn \"cscc\"\nend\nend\nfunction premake.dotnet.getflags(cfg)\nlocal result = table.translate(cfg.flags, flags)\nreturn result\nend\nfunction premake.dotnet.getkind(cfg)\nif (c"
	"fg.kind == \"ConsoleApp\") then\nreturn \"Exe\"\nelseif (cfg.kind == \"WindowedApp\") then\nreturn \"WinExe\"\nelseif (cfg.kind == \"SharedLib\") then\nreturn \"Library\"\nend\nend\n",

	/* tools/gcc.lua */
	"premake.gcc = { }\npremake.gcc.cc     = \"gcc\"\npremake.gcc.cxx    = \"g++\"\npremake.gcc.ar     = \"ar\"\npremake.gcc.rc     = \"windres\"\npremake.gcc.llvm   = false\nlocal cflags =\n{\nEnableSSE        = \"-msse\",\nEnableSSE2       = \"-msse2\",\nEnableAVX        = \"-mavx\",\nEnableAVX2       = \"-mavx2\",\nPedanticWarnings = \"-Wall -Wextra -pedantic\",\nExtraWarnings    = \"-Wall -Wextra\",\nFatalWarnings    = \"-Werror\",\nFloatFast        = \"-ffast-math\",\nFloatStrict      = \"-ffloat-store\",\nNoFramePointer   = \"-fomit-frame-pointer\",\nOptimize         = \"-O2\",\nOptimizeSize     = \"-Os\",\nOptimizeSpeed    = \"-O3\",\nSymbols          = \"-g\",\n}\nlocal cxxflags =\n{\nCpp11        = \"-std=c++11\",\nCpp14        = \"-std=c++14\",\nCpp17        = \"-std=c++17\",\nCpp20        = \"-std=c++20\",\nCppLatest    = \"-std=c++2b\",\nNoExceptions = \"-fno-exceptions\",\nNoRTTI       = \"-fno-rtti\",\nUnsignedChar = \"-funsigned-char\",\n}\nlocal objcflags =\n{\nObjcARC = \"-fobjc-arc\",\n}\npremake."
	"gcc.platforms =\n{\nNative = {\ncppflags = \"-MMD -MP\",\n},\nx32 = {\ncppflags = \"-MMD -MP\",\nflags    = \"-m32\",\n},\nx64 = {\ncppflags = \"-MMD -MP\",\nflags    = \"-m64\",\n},\nUniversal = {\nar       = \"libtool\",\ncppflags = \"-MMD -MP\",\nflags    = \"-arch i386 -arch x86_64 -arch ppc -arch ppc64\",\n},\nUniversal32 = {\nar       = \"libtool\",\ncppflags = \"-MMD -MP\",\nflags    = \"-arch i386 -arch ppc\",\n},\nUniversal64 = {\nar       = \"libtool\",\ncppflags = \"-MMD -MP\",\nflags    = \"-arch x86_64 -arch ppc64\",\n},\nPS3 = {\ncc         = \"ppu-lv2-g++\",\ncxx        = \"ppu-lv2-g++\",\nar         = \"ppu-lv2-ar\",\ncppflags   = \"-MMD -MP\",\n},\nWiiDev = {\ncppflags    = \"-MMD -MP -I$(LIBOGC_INC) $(MACHDEP)\",\nldflags= \"-L$(LIBOGC_LIB) $(MACHDEP)\",\ncfgsettings = [[\n  ifeq ($(strip $(DEVKITPPC)),)\n    $(error \"DEVKITPPC environment variable is not set\")'\n  endif\n  include $(DEVKITPPC)/wii_rules']],\n},\nOrbis = {\ncc         = \"orbis-clang\",\ncxx        = \"orbis-clang++\",\nar "
	"        = \"orbis-ar\",\ncppflags   = \"-MMD -MP\",\n},\nEmscripten = {\ncc         = \"$(EMSCRIPTEN)/emcc\",\ncxx        = \"$(EMSCRIPTEN)/em++\",\nar         = \"$(EMSCRIPTEN)/emar\",\ncppflags   = \"-MMD -MP\",\n},\nNX32 = {\ncc         = \"clang\",\ncxx        = \"clang++\",\nar         = \"armv7l-nintendo-nx-eabihf-ar\",\ncppflags   = \"-MMD -MP\",\nflags      = \"-march=armv7l\",\n},\nNX64 = {\ncc         = \"clang\",\ncxx        = \"clang++\",\nar         = \"aarch64-nintendo-nx-elf-ar\",\ncppflags   = \"-MMD -MP\",\nflags      = \"-march=aarch64\",\n},\n}\nlocal platforms = premake.gcc.platforms\nfunction premake.gcc.getcppflags(cfg)\nlocal flags = { }\ntable.insert(flags, platforms[cfg.platform].cppflags)\nif flags[1]:startswith(\"-MMD\") then\ntable.insert(flags, \"-MP\")\nend\nreturn flags\nend\nfunction premake.gcc.getcflags(cfg)\nlocal result = table.translate(cfg.flags, cflags)\ntable.insert(result, platforms[cfg.platform].flags)\nif cfg.system ~= \"windows\" and cfg.kind == \"SharedLib\" then\nt"
	"able.insert(result, \"-fPIC\")\nend\nreturn result\nend\nfunction premake.gcc.getcxxflags(cfg)\nlocal result = table.translate(cfg.flags, cxxflags)\nreturn result\nend\nfunction premake.gcc.getobjcflags(cfg)\nreturn table.translate(cfg.flags, objcflags)\nend\nfunction premake.gcc.getldflags(cfg)\nlocal result = { }\nif not cfg.flags.Symbols then\nif cfg.system == \"macosx\" then\nelse\ntable.insert(result, \"-s\")\nend\nend\nif cfg.kind == \"Bundle\" then\ntable.insert(result, \"-bundle\")\nend\nif cfg.kind == \"SharedLib\" then\nif cfg.system == \"macosx\" then\ntable.insert(result, \"-dynamiclib\")\nelse\ntable.insert(result, \"-shared\")\nend\nif cfg.system == \"windows\" and not cfg.flags.NoImportLib then\ntable.insert(result, '-Wl,--out-implib=\"' .. cfg.linktarget.fullpath .. '\"')\nend\nend\nif cfg.kind == \"WindowedApp\" and cfg.system == \"windows\" then\ntable.insert(result, \"-mwindows\")\nend\nlocal platform = platforms[cfg.platform]\ntable.insert(result, platform.flags)\ntable.insert(result, platf"
	"orm.ldflags)\nreturn result\nend\nfunction premake.gcc.getlibdirflags(cfg)\nlocal result = { }\nfor _, value in ipairs(premake.getlinks(cfg, \"all\", \"directory\")) do\ntable.insert(result, '-L\\\"' .. value .. '\\\"')\nend\nreturn result\nend\nfunction premake.gcc.islibfile(p)\nif path.getextension(p) == \".a\" then\nreturn true\nend\nreturn false\nend\nfunction premake.gcc.getlibfiles(cfg)\nlocal result = {}\nfor _, value in ipairs(premake.getlinks(cfg, \"system\", \"fullpath\")) do\nif premake.gcc.islibfile(value) then\ntable.insert(result, _MAKE.esc(value))\nend\nend\nreturn result\nend\nfunction premake.gcc.getlinkflags(cfg)\nlocal result = {}\nfor _, value in ipairs(premake.getlinks(cfg, \"system\", \"fullpath\")) do\nif premake.gcc.islibfile(value) then\nvalue = path.rebase(value, cfg.project.location, cfg.location)\ntable.insert(result, _MAKE.esc(value))\nelseif path.getextension(value) == \".framework\" then\ntable.insert(result, '-framework ' .. _MAKE.esc(path.getbasename(value)))\nelse\ntable.inser"
	"t(result, '-l' .. _MAKE.esc(path.getname(value)))\nend\nend\nreturn result\nend\nfunction premake.gcc.wholearchive(lib)\nif premake.gcc.llvm then\nreturn {\"-force_load\", lib}\nelseif os.get() == \"macosx\" then\nreturn {\"-Wl,-force_load\", lib}\nelse\nreturn {\"-Wl,--whole-archive\", lib, \"-Wl,--no-whole-archive\"}\nend\nend\nfunction premake.gcc.getarchiveflags(prj, cfg, ndx)\nlocal result = {}\nif cfg.platform:startswith(\"Universal\") then\nif prj.options.ArchiveSplit then\nerror(\"gcc tool 'Universal*' platforms do not support split archives\")\nend\ntable.insert(result, '-o')\nelse\nif (not prj.options.ArchiveSplit) then\nif premake.gcc.llvm then\ntable.insert(result, 'rcs')\nelse\ntable.insert(result, '-rcs')\nend\nelse\nif premake.gcc.llvm then\nif (not ndx) then\ntable.insert(result, 'qc')\nelse\ntable.insert(result, 'cs')\nend\nelse\nif (not ndx) then\ntable.insert(result, '-qc')\nelse\ntable.insert(result, '-cs')\nend\nend\nend\nend\nreturn result\nend\nfunction premake.gcc.getdefines(defines)\nl"
	"ocal result = { }\nfor _,def in ipairs(defines) do\ntable.insert(result, \"-D\" .. def)\nend\nreturn result\nend\nfunction premake.gcc.getincludedirs(includedirs)\nlocal result = { }\nfor _,dir in ipairs(includedirs) do\ntable.insert(result, \"-I\\\"\" .. dir .. \"\\\"\")\nend\nreturn result\nend\nfunction premake.gcc.getquoteincludedirs(includedirs)\nlocal result = { }\nfor _,dir in ipairs(includedirs) do\ntable.insert(result, \"-iquote \\\"\" .. dir .. \"\\\"\")\nend\nreturn result\nend\nfunction premake.gcc.getsystemincludedirs(includedirs)\nlocal result = { }\nfor _,dir in ipairs(includedirs) do\ntable.insert(result, \"-isystem \\\"\" .. dir .. \"\\\"\")\nend\nreturn result\nend\nfunction premake.gcc.getcfgsettings(cfg)\nreturn platforms[cfg.platform].cfgsettings\nend\n",

	/* tools/ghs.lua */
	"premake.ghs = { }\npremake.ghs.namestyle = \"PS3\"\npremake.ghs.cc     = \"ccppc\"\npremake.ghs.cxx    = \"cxppc\"\npremake.ghs.ar     = \"cxppc\"\nlocal cflags =\n{\nFatalWarnings  = \"--quit_after_warnings\",\nOptimize       = \"-Ogeneral\",\nOptimizeSize   = \"-Osize\",\nOptimizeSpeed  = \"-Ospeed\",\nSymbols        = \"-g\",\n}\nlocal cxxflags =\n{\nNoExceptions   = \"--no_exceptions\",\nNoRTTI         = \"--no_rtti\",\nUnsignedChar   = \"--unsigned_chars\",\n}\npremake.ghs.platforms =\n{\nNative = {\ncppflags = \"-MMD\",\n},\nPowerPC = {\ncc         = \"ccppc\",\ncxx       = \"cxppc\",\nar       = \"cxppc\",\ncppflags   = \"-MMD\",\narflags    = \"-archive -o\",\n},\nARM = {\ncc         = \"ccarm\",\ncxx        = \"cxarm\",\nar         = \"cxarm\",\ncppflags   = \"-MMD\",\narflags    = \"-archive -o\",\n}\n}\nlocal platforms = premake.ghs.platforms\nfunction premake.ghs.getcppflags(cfg)\nlocal flags = { }\ntable.insert(flags, platforms[cfg.platform].cppflags)\nreturn flags\nend\nfunction premake.ghs.getcf"
	"lags(cfg)\nlocal result = table.translate(cfg.flags, cflags)\ntable.insert(result, platforms[cfg.platform].flags)\nreturn result\nend\nfunction premake.ghs.getcxxflags(cfg)\nlocal result = table.translate(cfg.flags, cxxflags)\nreturn result\nend\nfunction premake.ghs.getldflags(cfg)\nlocal result = { }\nlocal platform = platforms[cfg.platform]\ntable.insert(result, platform.flags)\ntable.insert(result, platform.ldflags)\nreturn result\nend\nfunction premake.ghs.getlibdirflags(cfg)\nlocal result = { }\nfor _, value in ipairs(premake.getlinks(cfg, \"all\", \"directory\")) do\ntable.insert(result, '-L' .. _MAKE.esc(value))\nend\nreturn result\nend\nfunction premake.ghs.getlibfiles(cfg)\nlocal result = {}\nreturn result\nend\nfunction premake.ghs.getlinkflags(cfg)\nlocal result = {}\nfor _, value in ipairs(premake.getlinks(cfg, \"system\", \"name\")) do\ntable.insert(result, '-lnk=' .. _MAKE.esc(value))\nend\nreturn result\nend\nfunction premake.ghs.getarchiveflags(prj, cfg, ndx)\nif prj.options.ArchiveSplit then"
	"\nerror(\"ghs tool does not support split archives\")\nend\nlocal result = {}\nlocal platform = platforms[cfg.platform]\ntable.insert(result, platform.arflags)\nreturn result\nend\nfunction premake.ghs.getdefines(defines)\nlocal result = { }\nfor _,def in ipairs(defines) do\ntable.insert(result, '-D' .. def)\nend\nreturn result\nend\nfunction premake.ghs.getincludedirs(includedirs)\nlocal result = { }\nfor _,dir in ipairs(includedirs) do\ntable.insert(result, \"-I\" .. _MAKE.esc(dir))\nend\nreturn result\nend\nfunction premake.ghs.getcfgsettings(cfg)\nreturn platforms[cfg.platform].cfgsettings\nend\n",

	/* tools/msc.lua */
	"premake.msc = { }\npremake.msc.namestyle = \"windows\"\n",

	/* tools/ow.lua */
	"premake.ow = { }\npremake.ow.namestyle = \"windows\"\npremake.ow.cc     = \"WCL386\"\npremake.ow.cxx    = \"WCL386\"\npremake.ow.ar     = \"ar\"\nlocal cflags =\n{\nPedanticWarnings = \"-wx\",\nExtraWarnings    = \"-wx\",\nFatalWarning     = \"-we\",\nFloatFast        = \"-omn\",\nFloatStrict      = \"-op\",\nOptimize         = \"-ox\",\nOptimizeSize     = \"-os\",\nOptimizeSpeed    = \"-ot\",\nSymbols          = \"-d2\",\n}\nlocal cxxflags =\n{\nNoExceptions   = \"-xd\",\nNoRTTI         = \"-xr\",\n}\npremake.ow.platforms =\n{\nNative = {\nflags = \"\"\n},\n}\nfunction premake.ow.getcppflags(cfg)\nreturn {}\nend\nfunction premake.ow.getcflags(cfg)\nlocal result = table.translate(cfg.flags, cflags)\nif (cfg.flags.Symbols) then\ntable.insert(result, \"-hw\")   -- Watcom debug format for Watcom debugger\nend\nreturn result\nend\nfunction premake.ow.getcxxflags(cfg)\nlocal result = table.translate(cfg.flags, cxxflags)\nreturn result\nend\nfunction premake.ow.getldflags(cfg)\nlocal result = { }\nif (cfg.flags.Symb"
	"ols) then\ntable.insert(result, \"op symf\")\nend\nreturn result\nend\nfunction premake.ow.getlibfiles(cfg)\nlocal result = {}\nreturn result\nend\nfunction premake.ow.getlinkflags(cfg)\nlocal result = { }\nreturn result\nend\nfunction premake.ow.getdefines(defines)\nlocal result = { }\nfor _,def in ipairs(defines) do\ntable.insert(result, '-D' .. def)\nend\nreturn result\nend\nfunction premake.ow.getincludedirs(includedirs)\nlocal result = { }\nfor _,dir in ipairs(includedirs) do\ntable.insert(result, '-I \"' .. dir .. '\"')\nend\nreturn result\nend\n",

	/* tools/snc.lua */
	"premake.snc = { }\npremake.snc.cc     = \"snc\"\npremake.snc.cxx    = \"g++\"\npremake.snc.ar     = \"ar\"\nlocal cflags =\n{\nPedanticWarnings = \"-Xdiag=2\",\nExtraWarnings    = \"-Xdiag=2\",\nFatalWarnings    = \"-Xquit=2\",\n}\nlocal cxxflags =\n{\nNoExceptions   = \"\", -- No exceptions is the default in the SNC compiler.\nNoRTTI         = \"-Xc-=rtti\",\n}\npremake.snc.platforms =\n{\nPS3 = {\ncc         = \"ppu-lv2-g++\",\ncxx        = \"ppu-lv2-g++\",\nar         = \"ppu-lv2-ar\",\ncppflags   = \"-MMD -MP\",\n}\n}\nlocal platforms = premake.snc.platforms\nfunction premake.snc.getcppflags(cfg)\nlocal result = { }\ntable.insert(result, platforms[cfg.platform].cppflags)\nreturn result\nend\nfunction premake.snc.getcflags(cfg)\nlocal result = table.translate(cfg.flags, cflags)\ntable.insert(result, platforms[cfg.platform].flags)\nif cfg.kind == \"SharedLib\" then\ntable.insert(result, \"-fPIC\")\nend\nreturn result\nend\nfunction premake.snc.getcxxflags(cfg)\nlocal result = table.translate(cfg.flags, cxxfl"
	"ags)\nreturn result\nend\nfunction premake.snc.getldflags(cfg)\nlocal result = { }\nif not cfg.flags.Symbols then\ntable.insert(result, \"-s\")\nend\nif cfg.kind == \"SharedLib\" then\ntable.insert(result, \"-shared\")\nif not cfg.flags.NoImportLib then\ntable.insert(result, '-Wl,--out-implib=\"' .. cfg.linktarget.fullpath .. '\"')\nend\nend\nlocal platform = platforms[cfg.platform]\ntable.insert(result, platform.flags)\ntable.insert(result, platform.ldflags)\nreturn result\nend\nfunction premake.snc.getlibdirflags(cfg)\nlocal result = { }\nfor _, value in ipairs(premake.getlinks(cfg, \"all\", \"directory\")) do\ntable.insert(result, '-L' .. _MAKE.esc(value))\nend\nreturn result\nend\nfunction premake.snc.getlibfiles(cfg)\nlocal result = {}\nreturn result\nend\nfunction premake.snc.getlinkflags(cfg)\nlocal result = {}\nfor _, value in ipairs(premake.getlinks(cfg, \"system\", \"name\")) do\ntable.insert(result, '-l' .. _MAKE.esc(value))\nend\nreturn result\nend\nfunction premake.snc.getdefines(defines)\nlocal r"
	"esult = { }\nfor _,def in ipairs(defines) do\ntable.insert(result, '-D' .. def)\nend\nreturn result\nend\nfunction premake.snc.getincludedirs(includedirs)\nlocal result = { }\nfor _,dir in ipairs(includedirs) do\ntable.insert(result, \"-I\" .. _MAKE.esc(dir))\nend\nreturn result\nend\n",

	/* tools/valac.lua */
	"premake.valac = { }\npremake.valac.valac  = \"valac\"\npremake.valac.cc     = premake.gcc.cc\npremake.valac.glibrc = \"glib-compile-resources\"\nlocal valaflags =\n{\nDisableAssert             = \"--disable-assert\",               -- Disable assertions\nDisableSinceCheck         = \"--disable-since-check\",          -- Do not check whether used symbols exist in local packages\nDisableWarnings           = \"--disable-warnings\",             -- Disable warnings\nEnableChecking            = \"--enable-checking\",              -- Enable additional run-time checks\nEnableDeprecated          = \"--enable-deprecated\",            -- Enable deprecated features\nEnableExperimental        = \"--enable-experimental\",          -- Enable experimental features\nEnableExperimentalNonNull = \"--enable-experimental-non-null\", -- Enable experimental enhancements for non-null types\nEnableGObjectTracing      = \"--enable-gobject-tracing\",       -- Enable GObject creation tracing\nEnableMemProfiler         = \"--enable-mem-pro"
	"filer\",          -- Enable GLib memory profiler\nFatalWarnings             = \"--fatal-warnings\",               -- Treat warnings as fatal\nHideInternal              = \"--hide-internal\",                -- Hide symbols marked as internal\nNoStdPkg                  = \"--nostdpkg\",                     -- Do not include standard packages\nSymbols                   = \"-g\",                             -- Produce debug information\n}\nlocal valaccflags =\n{\nOptimize                  = \"-O2\",\nOptimizeSize              = \"-Os\",\nOptimizeSpeed             = \"-O3\",\nSymbols                   = \"-g\",                             -- Produce debug information\n}\npremake.valac.platforms =\n{\nNative = {\n},\nx64 = {\nflags = \"-m64\"\n},\n}\nfunction premake.valac.getvalaflags(cfg)\nreturn table.translate(cfg.flags, valaflags)\nend\nfunction premake.valac.getvalaccflags(cfg)\nreturn table.translate(cfg.flags, valaccflags)\nend\nfunction premake.valac.getlinks(links)\nlocal result = { }\nfor _, pkg in ipairs"
	"(links) do\ntable.insert(result, '--pkg ' .. pkg)\nend\nreturn result\nend\nfunction premake.valac.getdefines(defines)\nlocal result = { }\nfor _, def in ipairs(defines) do\ntable.insert(result, '-D ' .. def)\nend\nreturn result\nend\nfunction premake.valac.getvapidirs(vapidirs)\nlocal result = { }\nfor _, def in ipairs(vapidirs) do\ntable.insert(result, '--vapidir=' .. def)\nend\nreturn result\nend\n",

	/* tools/swift.lua */
	"premake.swift = { }\npremake.swift.swiftc   = \"swiftc\"\npremake.swift.swift    = \"swift\"\npremake.swift.cc       = \"gcc\"\npremake.swift.ar       = \"ar\"\npremake.swift.ld       = \"ld\"\npremake.swift.dsymutil = \"dsymutil\"\nlocal swiftcflags =\n{\nSymbols                   = \"-g\",                             -- Produce debug information\nDisableWarnings           = \"--suppress-warnings\",            -- Disable warnings\nFatalWarnings             = \"--warnings-as-errors\",           -- Treat warnings as fatal\nOptimize                  = \"-O -whole-module-optimization\",\nOptimizeSize              = \"-O -whole-module-optimization\",\nOptimizeSpeed             = \"-Ounchecked -whole-module-optimization\",\nMinimumWarnings           = \"-minimum-warnings\",\n}\nlocal swiftlinkflags = {\nStaticRuntime             = \"-static-stdlib\",\n}\npremake.swift.platforms = {\nNative = {\nswiftcflags    = \"\",\nswiftlinkflags = \"\",\n},\nx64 = {\nswiftcflags    = \"\",\nswiftlinkflags = \"\",\n}\n}\nlocal p"
	"latforms = premake.swift.platforms\nfunction premake.swift.get_sdk_path(cfg)\nreturn string.trim(os.outputof(\"xcrun --show-sdk-path\"))\nend\nfunction premake.swift.get_sdk_platform_path(cfg)\nreturn string.trim(os.outputof(\"xcrun --show-sdk-platform-path\"))\nend\nfunction premake.swift.get_toolchain_path(cfg)\nreturn string.trim(os.outputof(\"xcode-select -p\")) .. \"/Toolchains/XcodeDefault.xctoolchain\"\nend\nfunction premake.swift.gettarget(cfg)\nreturn \"-target x86_64-apple-macosx10.11\"\nend\nfunction premake.swift.getswiftcflags(cfg)\nlocal result = table.translate(cfg.flags, swiftcflags)\ntable.insert(result, platforms[cfg.platform].swiftcflags)\nresult = table.join(result, cfg.buildoptions_swift)\nif cfg.kind == \"SharedLib\" or cfg.kind == \"StaticLib\" then\ntable.insert(result, \"-parse-as-library\")\nend\ntable.insert(result, premake.swift.gettarget(cfg))\nreturn result\nend\nfunction premake.swift.getswiftlinkflags(cfg)\nlocal result = table.translate(cfg.flags, swiftlinkflags)\ntable.insert("
	"result, platforms[cfg.platform].swiftlinkflags)\nresult = table.join(result, cfg.linkoptions_swift)\nif cfg.kind == \"SharedLib\" or cfg.kind == \"StaticLib\" then\ntable.insert(result, \"-emit-library\")\nelse\ntable.insert(result, \"-emit-executable\")\nend\ntable.insert(result, premake.swift.gettarget(cfg))\nreturn result\nend\nfunction premake.swift.getmodulemaps(cfg)\nlocal maps = {}\nif next(cfg.swiftmodulemaps) then\nfor _, mod in ipairs(cfg.swiftmodulemaps) do\ntable.insert(maps, string.format(\"-Xcc -fmodule-map-file=%s\", mod))\nend\nend\nreturn maps\nend\nfunction premake.swift.getlibdirflags(cfg)\nreturn premake.gcc.getlibdirflags(cfg)\nend\nfunction premake.swift.getldflags(cfg)\nlocal result = { platforms[cfg.platform].ldflags }\nlocal links = premake.getlinks(cfg, \"siblings\", \"basename\")\nfor _,v in ipairs(links) do\nif path.getextension(v) == \".framework\" then\ntable.insert(result, \"-framework \"..v)\nelse\ntable.insert(result, \"-l\"..v)\nend\nend\nreturn result\nend\nfunction premake.s"
	"wift.getlinkflags(cfg)\nreturn premake.gcc.getlinkflags(cfg)\nend\nfunction premake.swift.getarchiveflags(cfg)\nreturn \"\"\nend\n",

	/* base/validate.lua */
	"function premake.checkprojects()\nlocal action = premake.action.current()\nfor sln in premake.solution.each() do\nif (#sln.projects == 0) then\nreturn nil, \"solution '\" .. sln.name .. \"' needs at least one project\"\nend\nif (#sln.configurations == 0) then\nreturn nil, \"solution '\" .. sln.name .. \"' needs configurations\"\nend\nfor prj in premake.solution.eachproject(sln) do\nif (not prj.language) then\nreturn nil, \"project '\" ..prj.name .. \"' needs a language\"\nend\nif (action.valid_languages) then\nif (not table.contains(action.valid_languages, prj.language)) then\nreturn nil, \"the \" .. action.shortname .. \" action does not support \" .. prj.language .. \" projects\"\nend\nend\nfor cfg in premake.eachconfig(prj) do\nif (not cfg.kind) then\nreturn nil, \"project '\" ..prj.name .. \"' needs a kind in configuration '\" .. cfg.name .. \"'\"\nend\nif (action.valid_kinds) then\nif (not table.contains(action.valid_kinds, cfg.kind)) then\nreturn nil, \"the \" .. action.shortname .. \" action does not su"
	"pport \" .. cfg.kind .. \" projects\"\nend\nend\nend\nif action.oncheckproject then\naction.oncheckproject(prj)\nend\nend\nend\nreturn true\nend\nfunction premake.checktools()\nlocal action = premake.action.current()\nif (not action.valid_tools) then \nreturn true \nend\nfor tool, values in pairs(action.valid_tools) do\nif (_OPTIONS[tool]) then\nif (not table.contains(values, _OPTIONS[tool])) then\nreturn nil, \"the \" .. action.shortname .. \" action does not support /\" .. tool .. \"=\" .. _OPTIONS[tool] .. \" (yet)\"\nend\nelse\n_OPTIONS[tool] = values[1]\nend\nend\nreturn true\nend\n",

	/* base/help.lua */
	"function premake.showhelp()\nprintf(\"\")\nprintf(\"Usage: genie [options] action [arguments]\")\nprintf(\"\")\nprintf(\"OPTIONS\")\nprintf(\"\")\nfor option in premake.option.each() do\nlocal trigger = option.trigger\nlocal description = option.description\nif (option.value) then trigger = trigger .. \"=\" .. option.value end\nif (option.allowed) then description = description .. \"; one of:\" end\nprintf(\" --%-15s %s\", trigger, description)\nif (option.allowed) then\nfor _, value in ipairs(option.allowed) do\nprintf(\"     %-14s %s\", value[1], value[2])\nend\nend\nprintf(\"\")\nend\nprintf(\"ACTIONS\")\nprintf(\"\")\nfor action in premake.action.each() do\nprintf(\" %-17s %s\", action.trigger, action.description)\nend\nprintf(\"\")\nprintf(\"For additional information, see https://github.com/bkaradzic/genie\")\nend\n",

	/* base/premake.lua */
	"premake._filelevelconfig = false\npremake._checkgenerate = true\nfunction premake.generate(obj, filename, callback)\nlocal prev  = io.capture()\nlocal abort = (callback(obj) == false)\nlocal new   = io.endcapture(prev)\nif abort then\npremake.stats.num_skipped = premake.stats.num_skipped + 1\nreturn\nend\nfilename = premake.project.getfilename(obj, filename)\nif (premake._checkgenerate) then\nlocal delta = false\nlocal f, err = io.open(filename, \"rb\")\nif (not f) then\nif string.find(err, \"No such file or directory\") then\ndelta = true\nelse\nerror(err, 0)\nend\nelse\nlocal existing = f:read(\"*all\")\nif existing ~= new then\ndelta = true\nend\nf:close()\nend\nif delta then\nprintf(\"Generating %q\", filename)\nlocal f, err = io.open(filename, \"wb\")\nif (not f) then\nerror(err, 0)\nend\nf:write(new)\nf:close()\npremake.stats.num_generated = premake.stats.num_generated + 1\nelse\npremake.stats.num_skipped = premake.stats.num_skipped + 1\nend\nelse\nprintf(\"Generating %q\", filename)\nlocal f, err = io.o"
	"pen(filename, \"wb\")\nif (not f) then\nerror(err, 0)\nend\nf:write(new)\nf:close()\npremake.stats.num_generated = premake.stats.num_generated + 1\nend\nend\nfunction premake.findDefaultScript(dir, search_upwards)\nsearch_upwards = search_upwards or true\nlocal last = \"\"\nwhile dir ~= last do\nfor _, name in ipairs({ \"genie.lua\", \"solution.lua\", \"premake4.lua\" }) do\nlocal script0 = dir .. \"/\" .. name\nif (os.isfile(script0)) then\nreturn dir, name\nend\nlocal script1 = dir .. \"/scripts/\" .. name\nif (os.isfile(script1)) then\nreturn dir .. \"/scripts/\", name\nend\nend\nlast = dir\ndir  = path.getabsolute(dir .. \"/..\")\nif dir == \".\" or not search_upwards then break end\nend\nreturn nil, nil\nend\n",

	/* base/iter.lua */
	"iter = {}\nfunction iter.sortByKeys(arr, f)\nlocal a = table.keys(arr)\ntable.sort(a, f)\nlocal i = 0\nreturn function()\ni = i + 1\nif a[i] ~= nil then \nreturn a[i], arr[a[i]]\nend\nend\nend\n",

	/* base/set.lua */
	"Set_mt = {}\nfunction Set(t)\nlocal set = {}\nfor k, l in ipairs(t) do \nset[l] = true \nend\nsetmetatable(set, Set_mt)\nreturn set\nend\nfunction Set_mt.union(a, b)\nlocal res = Set{}\nfor k in pairs(a) do res[k] = true end\nfor k in pairs(b) do res[k] = true end\nreturn res\nend\nfunction Set_mt.intersection(a, b)\nlocal res = Set{}\nfor k in pairs(a) do\nres[k] = b[k]\nend\nreturn res\nend\nlocal function get_cache(a)\nif not rawget(a, \"__cache\") then\nrawset(a, \"__cache\", Set_mt.totable(a))\nend\nreturn rawget(a, \"__cache\")\nend\nfunction Set_mt.len(a)\nreturn #get_cache(a)\nend\nfunction Set_mt.implode(a, sep)\nreturn table.concat(get_cache(a), sep)\nend\nfunction Set_mt.totable(a)\nlocal res = {}\nfor k in pairs(a) do\ntable.insert(res, k)\nend\nreturn res\nend\nfunction Set_mt.difference(a, b)\nif getmetatable(b) ~= Set_mt then\nif type(b) ~= \"table\" then\nerror(type(b)..\" is not a Set or table\")\nend\nb=Set(b)\nend\nlocal res = Set{}\nfor k in pairs(a) do\nres[k] = not b[k] or nil\nend\nrawse"
	"t(res, \"__cache\", nil)\nreturn res\nend\nfunction Set_mt.__index(a, i)\nif type(i) == \"number\" then\nreturn get_cache(a)[i]\nend\nreturn Set_mt[i] or rawget(a, i)\nend\nSet_mt.__add = Set_mt.union\nSet_mt.__mul = Set_mt.intersection\nSet_mt.__sub = Set_mt.difference\nSet_mt.__len = Set_mt.len\nSet_mt.__concat = Set_mt.implode",

	/* actions/cmake/_cmake.lua */
	"premake.cmake = { }\nnewaction {\ntrigger         = \"cmake\",\nshortname       = \"CMake\",\ndescription     = \"Generate CMake project files\",\nvalid_kinds     = { \"ConsoleApp\", \"WindowedApp\", \"StaticLib\", \"SharedLib\", \"Bundle\" },\nvalid_languages = { \"C\", \"C++\" },\nvalid_tools     = {\ncc   = { \"gcc\" },\n},\nonsolution = function(sln)\npremake.generate(sln, \"CMakeLists.txt\", premake.cmake.workspace)\nend,\nonproject = function(prj)\npremake.generate(prj, \"%%/CMakeLists.txt\", premake.cmake.project)\nend,\noncleansolution = function(sln)\npremake.clean.file(sln, \"CMakeLists.txt\")\nend,\noncleanproject = function(prj)\npremake.clean.file(prj, \"%%/CMakeLists.txt\")\nend\n}",

	/* actions/cmake/cmake_workspace.lua */
	"function premake.cmake.workspace(sln)\nif (sln.location ~= _WORKING_DIR) then\nlocal name = string.format(\"%s/CMakeLists.txt\", _WORKING_DIR)\nlocal f, err = io.open(name, \"wb\")\nif (not f) then\nerror(err, 0)\nend\nf:write([[\n# CMakeLists autogenerated by GENie\nproject(GENie)\ncmake_minimum_required(VERSION 3.15)\n#########################################################################\n# Set a default build type if none was specified\n# Source: https://blog.kitware.com/cmake-and-the-default-build-type/\nset(default_build_type \"Release\")\nif(EXISTS \"${CMAKE_SOURCE_DIR}/.git\")\n  set(default_build_type \"Debug\")\nendif()\nif(NOT CMAKE_BUILD_TYPE AND NOT CMAKE_CONFIGURATION_TYPES)\n  message(STATUS \"Setting build type to '${default_build_type}' as none was specified.\")\n  set(CMAKE_BUILD_TYPE \"${default_build_type}\" CACHE STRING \"Choose the type of build.\" FORCE)\n  # Set the possible values of build type for cmake-gui\n  set_property(CACHE CMAKE_BUILD_TYPE PROPERTY STRINGS \"Debug\" \"Release"
	"\" \"MinSizeRel\" \"RelWithDebInfo\")\nendif()\n#########################################################################\n]])\nif os.is(\"windows\") then\nf:write('cmake_policy(SET CMP0091 NEW)\\n')\nend\nf:write('add_subdirectory('.. path.getrelative(_WORKING_DIR, sln.location) ..')\\n')\nf:close()\nend\n_p([[\n# CMakeLists autogenerated by GENie\ncmake_minimum_required(VERSION 3.15)\n]])\nif os.is(\"windows\") then\n_p('cmake_policy(SET CMP0091 NEW)')\nend\nfor i,prj in ipairs(sln.projects) do\nlocal name = premake.esc(prj.name)\n_p('add_subdirectory(%s)', name)\nend\nend\n",

	/* actions/cmake/cmake_project.lua */
	"local cmake = premake.cmake\nlocal tree = premake.tree\nlocal includestr = 'include_directories(../%s)'\nlocal definestr = 'add_definitions(-D%s)'\nlocal function is_excluded(prj, cfg, file)\n    if table.icontains(prj.excludes, file) then\n        return true\n    end\n    if table.icontains(cfg.excludes, file) then\n        return true\n    end\n    return false\nend\nfunction cmake.excludedFiles(prj, cfg, src)\n    for _, v in ipairs(src) do\n        if (is_excluded(prj, cfg, v)) then\n            _p(1, 'list(REMOVE_ITEM source_list ../%s)', v)\n        end\n    end\nend\nfunction cmake.list(value)\n    if #value > 0 then\n        return \" \" .. table.concat(value, \" \")\n    else\n        return \"\"\n    end\nend\nfunction cmake.listWrapped(value, prefix, postfix)\n    if #value > 0 then\n        return prefix .. table.concat(value, postfix .. prefix) .. postfix\n    else\n        return \"\"\n    end\nend\nfunction cmake.files(prj)\n    local ret = {}\n    local tr = premake.project.buildsourcetree(prj"
	")\n    tree.traverse(tr, {\n        onbranchenter = function(node, depth)\n        end,\n        onbranchexit = function(node, depth)\n        end,\n        onleaf = function(node, depth)\n            assert(node, \"unexpected empty node\")\n            if node.cfg then\n                table.insert(ret, node.cfg.name)\n                _p(1, '../%s', node.cfg.name)\n            end\n        end,\n    }, true, 1)\n    return ret\nend\nfunction cmake.header(prj)\n    _p('# %s project autogenerated by GENie', premake.action.current().shortname)\n    _p('cmake_minimum_required(VERSION 3.15)')\n    if os.is(\"windows\") then\n        -- Add support for CMP0091, see https://cmake.org/cmake/help/latest/policy/CMP0091.html\n        _p('cmake_policy(SET CMP0091 NEW)')\n    end\n    _p('')\n    _p('project(%s)', premake.esc(prj.name))\n    _p('')\n    _p('include(GNUInstallDirs)')\nend\nfunction cmake.customtasks(prj)\n    local dirs = {}\n    local tasks = {}\n    for _, custombuildtask in ipairs(prj.custombuildtask or"
	" {}) do\n        for _, buildtask in ipairs(custombuildtask or {}) do\n            table.insert(tasks, buildtask)\n            local d = string.format(\"${CMAKE_CURRENT_SOURCE_DIR}/../%s\", path.getdirectory(path.getrelative(prj.location, buildtask[2])))\n            if not table.contains(dirs, d) then\n                table.insert(dirs, d)\n                _p('file(MAKE_DIRECTORY \\\"%s\\\")', d)\n            end\n        end\n    end\n    _p('')\n    for _, buildtask in ipairs(tasks) do\n        local deps = string.format(\"${CMAKE_CURRENT_SOURCE_DIR}/../%s \", path.getrelative(prj.location, buildtask[1]))\n        local outputs = string.format(\"${CMAKE_CURRENT_SOURCE_DIR}/../%s \", path.getrelative(prj.location, buildtask[2]))\n        local msg = \"\"\n        for _, depdata in ipairs(buildtask[3] or {}) do\n            deps = deps .. string.format(\"${CMAKE_CURRENT_SOURCE_DIR}/../%s \", path.getrelative(prj.location, depdata))\n        end\n        _p('add_custom_command(')\n        _p(1, 'OUTPUT %s', ou"
	"tputs)\n        _p(1, 'DEPENDS %s', deps)\n        for _, cmdline in ipairs(buildtask[4] or {}) do\n            if (cmdline:sub(1, 1) ~= \"@\") then\n                local cmd = cmdline\n                local num = 1\n                for _, depdata in ipairs(buildtask[3] or {}) do\n                    cmd = string.gsub(cmd, \"%$%(\" .. num .. \"%)\", string.format(\"${CMAKE_CURRENT_SOURCE_DIR}/../%s \", path.getrelative(prj.location, depdata)))\n                    num = num + 1\n                end\n                cmd = string.gsub(cmd, \"%$%(<%)\", string.format(\"${CMAKE_CURRENT_SOURCE_DIR}/../%s \", path.getrelative(prj.location, buildtask[1])))\n                cmd = string.gsub(cmd, \"%$%(@%)\", outputs)\n                _p(1, 'COMMAND %s', cmd)\n            else\n                msg = cmdline\n            end\n        end\n        _p(1, 'COMMENT \\\"%s\\\"', msg)\n        _p(')')\n        _p('')\n    end\nend\nfunction cmake.depRules(prj)\n    local maintable = {}\n    for _, dependency in ipairs(prj.d"
	"ependency) do\n        for _, dep in ipairs(dependency) do\n            if path.issourcefile(dep[1]) then\n                local dep1 = premake.esc(path.getrelative(prj.location, dep[1]))\n                local dep2 = premake.esc(path.getrelative(prj.location, dep[2]))\n                if not maintable[dep1] then maintable[dep1] = {} end\n                table.insert(maintable[dep1], dep2)\n            end\n        end\n    end\n    for key, _ in pairs(maintable) do\n        local deplist = {}\n        local depsname = string.format('%s_deps', path.getname(key))\n        for _, d2 in pairs(maintable[key]) do\n            table.insert(deplist, d2)\n        end\n        _p('set(')\n        _p(1, depsname)\n        for _, v in pairs(deplist) do\n            _p(1, '${CMAKE_CURRENT_SOURCE_DIR}/../%s', v)\n        end\n        _p(')')\n        _p('')\n        _p('set_source_files_properties(')\n        _p(1, '\\\"${CMAKE_CURRENT_SOURCE_DIR}/../%s\\\"', key)\n        _p(1, 'PROPERTIES OBJECT_DEPENDS \\\"${%s}\\\"', d"
	"epsname)\n        _p(')')\n        _p('')\n    end\nend\nfunction cmake.commonRules(conf, str)\n    local Dupes = {}\n    local t2 = {}\n    for _, cfg in ipairs(conf) do\n        local cfgd = iif(str == includestr, cfg.includedirs, cfg.defines)\n        for _, v in ipairs(cfgd) do\n            if(t2[v] == #conf - 1) then\n                _p(str, v)\n                table.insert(Dupes, v)\n            end\n            if not t2[v] then\n                t2[v] = 1\n            else\n                t2[v] = t2[v] + 1\n            end\n        end\n    end\n    return Dupes\nend\nfunction cmake.cfgRules(cfg, dupes, str)\n    for _, v in ipairs(cfg) do\n        if (not table.icontains(dupes, v)) then\n            _p(1, str, v)\n        end\n    end\nend\nfunction cmake.removeCrosscompiler(platforms)\n    for i = #platforms, 1, -1 do\n        if premake.platforms[platforms[i]].iscrosscompiler then\n            table.remove(platforms, i)\n        end\n    end\nend\nfunction cmake.project(prj)\n    io.indent = \"  \""
	"\n    cmake.header(prj)\n    _p('set(')\n    _p('source_list')\n    local source_files = cmake.files(prj)\n    _p(')')\n    _p('')\n    local nativeplatform = iif(os.is64bit(), \"x64\", \"x32\")\n    local cc = premake.gettool(prj)\n    local platforms = premake.filterplatforms(prj.solution, cc.platforms, \"Native\")\n    cmake.removeCrosscompiler(platforms)\n    local configurations = {}\n    for _, platform in ipairs(platforms) do\n        for cfg in premake.eachconfig(prj, platform) do\n            -- TODO: Extend support for 32-bit targets on 64-bit hosts\n            if cfg.platform == nativeplatform then\n                table.insert(configurations, cfg)\n            end\n        end\n    end\n    local commonIncludes = cmake.commonRules(configurations, includestr)\n    local commonDefines = cmake.commonRules(configurations, definestr)\n    _p('')\n    for _, cfg in ipairs(configurations) do\n        _p('if(CMAKE_BUILD_TYPE MATCHES \\\"%s\\\")', cfg.name)\n        -- list excluded files\n        cmake.ex"
	"cludedFiles(prj, cfg, source_files)\n        -- add includes directories\n        cmake.cfgRules(cfg.includedirs, commonIncludes, includestr)\n        -- add build defines\n        cmake.cfgRules(cfg.defines, commonDefines, definestr)\n        -- set CXX flags\n        _p(1, 'set(CMAKE_CXX_FLAGS \\\"${CMAKE_CXX_FLAGS} %s\\\")', cmake.list(table.join(cc.getcppflags(cfg), cc.getcflags(cfg), cc.getcxxflags(cfg), cfg.buildoptions, cfg.buildoptions_cpp)))\n        -- set C flags\n        _p(1, 'set(CMAKE_C_FLAGS \\\"${CMAKE_C_FLAGS} %s\\\")', cmake.list(table.join(cc.getcppflags(cfg), cc.getcflags(cfg), cfg.buildoptions, cfg.buildoptions_c)))\n        _p('endif()')\n        _p('')\n    end\n    -- force CPP if needed\n    if (prj.options.ForceCPP) then\n        _p('set_source_files_properties(${source_list} PROPERTIES LANGUAGE CXX)')\n    end\n    -- add custom tasks\n    cmake.customtasks(prj)\n    -- per-dependency build rules\n    cmake.depRules(prj)\n    for _, cfg in ipairs(configurations) do\n        _p('if(C"
	"MAKE_BUILD_TYPE MATCHES \\\"%s\\\")', cfg.name)\n        if (prj.kind == 'StaticLib') then\n            _p(1, 'add_library(%s STATIC ${source_list})', premake.esc(cfg.buildtarget.basename))\n            -- Install\n            _p(1, 'install(TARGETS %s RUNTIME DESTINATION ${CMAKE_INSTALL_LIBDIR})', premake.esc(cfg.buildtarget.basename))\n        end\n        if (prj.kind == 'SharedLib') then\n            _p(1, 'add_library(%s SHARED ${source_list})', premake.esc(cfg.buildtarget.basename))\n            -- Install\n            _p(1, 'install(TARGETS %s RUNTIME DESTINATION ${CMAKE_INSTALL_LIBDIR})', premake.esc(cfg.buildtarget.basename))\n        end\n        if (prj.kind == 'ConsoleApp' or prj.kind == 'WindowedApp') then\n            _p(1, 'add_executable(%s ${source_list})', premake.esc(cfg.buildtarget.basename))\n            local libdirs = cmake.listWrapped(premake.esc(premake.getlinks(cfg, \"all\", \"directory\")), \" -L\\\"../\", \"\\\"\")\n            _p(1, 'target_link_libraries(%s%s%s%s%s%s)', premake.es"
	"c(cfg.buildtarget.basename), libdirs, cmake.list(cfg.linkoptions), cmake.list(cc.getldflags(cfg)), cmake.list(premake.esc(premake.getlinks(cfg, \"siblings\", \"basename\"))), cmake.list(cc.getlinkflags(cfg)))\n            -- Install\n            _p(1, 'install(TARGETS %s RUNTIME DESTINATION ${CMAKE_INSTALL_BINDIR})', premake.esc(cfg.buildtarget.basename))\n        end\n        _p('endif()')\n        _p('')\n    end\nend",

	/* actions/make/_make.lua */
	"_MAKE = { }\npremake.make = { }\nlocal make = premake.make\nfunction _MAKE.esc(value)\nlocal result\nif (type(value) == \"table\") then\nresult = { }\nfor _,v in ipairs(value) do\ntable.insert(result, _MAKE.esc(v))\nend\nreturn result\nelse\nresult = value:gsub(\"\\\\\", \"\\\\\\\\\")\nresult = result:gsub(\" \", \"\\\\ \")\nresult = result:gsub(\"%%(\", \"\\\\%(\")\nresult = result:gsub(\"%%)\", \"\\\\%)\")\nresult = result:gsub(\"$\\\\%((.-)\\\\%)\", \"$%(%1%)\")\nreturn result\nend\nend\nfunction _MAKE.escquote(value)\nlocal result\nif (type(value) == \"table\") then\nresult = { }\nfor _,v in ipairs(value) do\ntable.insert(result, _MAKE.escquote(v))\nend\nreturn result\nelse\nresult = value:gsub(\" \", \"\\\\ \")\nresult = result:gsub(\"\\\"\", \"\\\\\\\"\")\nreturn result\nend\nend\nfunction premake.make_copyrule(source, target)\n_p('%s: %s', target, source)\n_p('\\t@echo Copying $(notdir %s)', target)\n_p('\\t-$(call COPY,%s,%s)', source, target)\nend\nfunction premake.make_mkdirrule(var)\n_p('\\t@echo Cr"
	"eating %s', var)\n_p('\\t-$(call MKDIR,%s)', var)\n_p('')\nend\nfunction make.list(value)\nif #value > 0 then\nreturn \" \" .. table.concat(value, \" \")\nelse\nreturn \"\"\nend\nend\nfunction _MAKE.getmakefilename(this, searchprjs)\nlocal count = 0\nfor sln in premake.solution.each() do\nif (sln.location == this.location) then count = count + 1 end\nif (searchprjs) then\nfor _,prj in ipairs(sln.projects) do\nif (prj.location == this.location) then count = count + 1 end\nend\nend\nend\nif (count == 1) then\nreturn \"Makefile\"\nelse\nreturn this.name .. \".make\"\nend\nend\nfunction _MAKE.getnames(tbl)\nlocal result = table.extract(tbl, \"name\")\nfor k,v in pairs(result) do\nresult[k] = _MAKE.esc(v)\nend\nreturn result\nend\nfunction make.settings(cfg, cc)\nif #cfg.makesettings > 0 then\nfor _, value in ipairs(cfg.makesettings) do\n_p(value)\nend\nend\nlocal toolsettings = cc.platforms[cfg.platform].cfgsettings\nif toolsettings then\n_p(toolsettings)\nend\nend\nnewaction {\ntrigger         = \"gmake\",\nshort"
	"name       = \"GNU Make\",\ndescription     = \"Generate GNU makefiles for POSIX, MinGW, and Cygwin\",\nvalid_kinds     = { \"ConsoleApp\", \"WindowedApp\", \"StaticLib\", \"SharedLib\", \"Bundle\" },\nvalid_languages = { \"C\", \"C++\", \"C#\", \"Vala\", \"Swift\" },\nvalid_tools     = {\ncc     = { \"gcc\", \"ghs\" },\ndotnet = { \"mono\", \"msnet\", \"pnet\" },\nvalac  = { \"valac\" },\nswift  = { \"swift\" },\n},\nonsolution = function(sln)\npremake.generate(sln, _MAKE.getmakefilename(sln, false), premake.make_solution)\nend,\nonproject = function(prj)\nlocal makefile = _MAKE.getmakefilename(prj, true)\nif premake.isdotnetproject(prj) then\npremake.generate(prj, makefile, premake.make_csharp)\nelseif premake.iscppproject(prj) then\npremake.generate(prj, makefile, premake.make_cpp)\nelseif premake.isswiftproject(prj) then\npremake.generate(prj, makefile, premake.make_swift)\nelse\npremake.generate(prj, makefile, premake.make_vala)\nend\nend,\noncleansolution = function(sln)\npremake.clean.file(sln, _MAKE.ge"
	"tmakefilename(sln, false))\nend,\noncleanproject = function(prj)\npremake.clean.file(prj, _MAKE.getmakefilename(prj, true))\nend,\ngmake = {}\n}\n",

	/* actions/make/make_solution.lua */
	"function premake.make_solution(sln)\nlocal cc = premake[_OPTIONS.cc]\nlocal platforms = premake.filterplatforms(sln, cc.platforms, \"Native\")\n_p('# %s solution makefile autogenerated by GENie', premake.action.current().shortname)\n_p('# Type \"make help\" for usage help')\n_p('')\n_p('ifndef config')\n_p('  config=%s', _MAKE.esc(premake.getconfigname(sln.configurations[1], platforms[1], true)))\n_p('endif')\n_p('export config')\n_p('')\nlocal projects = table.extract(sln.projects, \"name\")\ntable.sort(projects)\n_p('PROJECTS := %s', table.concat(_MAKE.esc(projects), \" \"))\n_p('')\n_p('.PHONY: all clean help $(PROJECTS)')\n_p('')\n_p('all: $(PROJECTS)')\n_p('')\nfor _, prj in ipairs(sln.projects) do\n_p('%s: %s', _MAKE.esc(prj.name), table.concat(_MAKE.esc(table.extract(premake.getdependencies(prj), \"name\")), \" \"))\nif (not sln.messageskip) or (not table.contains(sln.messageskip, \"SkipBuildingMessage\")) then\n_p('\\t@echo \"==== Building %s ($(config)) ====\"', prj.name)\nend\n_p('\\t@${MAKE} --no-pr"
	"int-directory -C %s -f %s', _MAKE.esc(path.getrelative(sln.location, prj.location)), _MAKE.esc(_MAKE.getmakefilename(prj, true)))\n_p('')\nend\n_p('clean:')\nfor _ ,prj in ipairs(sln.projects) do\n_p('\\t@${MAKE} --no-print-directory -C %s -f %s clean', _MAKE.esc(path.getrelative(sln.location, prj.location)), _MAKE.esc(_MAKE.getmakefilename(prj, true)))\nend\n_p('')\n_p('help:')\n_p(1,'@echo \"Usage: make [config=name] [target]\"')\n_p(1,'@echo \"\"')\n_p(1,'@echo \"CONFIGURATIONS:\"')\nlocal cfgpairs = { }\nfor _, platform in ipairs(platforms) do\nfor _, cfgname in ipairs(sln.configurations) do\n_p(1,'@echo \"   %s\"', premake.getconfigname(cfgname, platform, true))\nend\nend\n_p(1,'@echo \"\"')\n_p(1,'@echo \"TARGETS:\"')\n_p(1,'@echo \"   all (default)\"')\n_p(1,'@echo \"   clean\"')\nfor _, prj in ipairs(sln.projects) do\n_p(1,'@echo \"   %s\"', prj.name)\nend\n_p(1,'@echo \"\"')\n_p(1,'@echo \"For more information, see https://github.com/bkaradzic/genie\"')\nend\n",

	/* actions/make/make_cpp.lua */
	"-- --\npremake.make.cpp = { }\npremake.make.override = { }\npremake.make.makefile_ignore = false\nlocal cpp = premake.make.cpp\nlocal make = premake.make\nfunction premake.make_cpp(prj)\nlocal cc = premake.gettool(prj)\nlocal platforms = premake.filterplatforms(prj.solution, cc.platforms, \"Native\")\nlocal action = premake.action.current()\npremake.gmake_cpp_header(prj, cc, platforms)\npremake.gmake_cpp_configs(prj, cc, platforms)\ntable.sort(prj.allfiles)\nlocal objdirs = {}\nlocal additionalobjdirs = {}\nfor _, file in ipairs(prj.allfiles) do\nif path.issourcefile(file) then\nobjdirs[_MAKE.esc(path.getdirectory(path.trimdots(file)))] = 1\nend\nend\nfor _, custombuildtask in ipairs(prj.custombuildtask or {}) do\nfor _, buildtask in ipairs(custombuildtask or {}) do\nadditionalobjdirs[_MAKE.esc(path.getdirectory(path.getrelative(prj.location,buildtask[2])))] = 1\nend\nend\n_p('OBJDIRS := \\\\')\n_p('\\t$(OBJDIR) \\\\')\nfor dir, _ in iter.sortByKeys(objdirs) do\n_p('\\t$(OBJDIR)/%s \\\\', dir)\nend\nfor dir, _"
	" in iter.sortByKeys(additionalobjdirs) do\n_p('\\t%s \\\\', dir)\nend\n_p('')\n_p('RESOURCES := \\\\')\nfor _, file in ipairs(prj.allfiles) do\nif path.isresourcefile(file) then\n_p('\\t$(OBJDIR)/%s.res \\\\', _MAKE.esc(path.getbasename(file)))\nend\nend\n_p('')\n_p('.PHONY: clean prebuild prelink')\n_p('')\nif os.is(\"MacOSX\") and prj.kind == \"WindowedApp\" and not prj.options.SkipBundling then\n_p('all: $(OBJDIRS) $(TARGETDIR) prebuild prelink $(TARGET) $(dir $(TARGETDIR))PkgInfo $(dir $(TARGETDIR))Info.plist')\nelse\n_p('all: $(OBJDIRS) $(TARGETDIR) prebuild prelink $(TARGET)')\nend\n_p('\\t@:')\n_p('')\nif (prj.kind == \"StaticLib\" and prj.options.ArchiveSplit) then\n_p('define max_args')\n_p('\\t$(eval _args:=)')\n_p('\\t$(foreach obj,$3,$(eval _args+=$(obj))$(if $(word $2,$(_args)),$1 $(_args)$(EOL)$(eval _args:=)))')\n_p('\\t$(if $(_args),$1 $(_args))')\n_p('endef')\n_p('')\n_p('define EOL')\n_p('')\n_p('')\n_p('endef')\n_p('')\nend\n_p('$(TARGET): $(GCH) $(OBJECTS) $(LIBDEPS) $(EXTERNAL_LIBS) $(RESO"
	"URCES) $(OBJRESP) $(LDRESP) | $(TARGETDIR) $(OBJDIRS)')\nif prj.kind == \"StaticLib\" then\nif prj.msgarchiving then\n_p('\\t@echo ' .. prj.msgarchiving)\nelse\n_p('\\t@echo Archiving %s', prj.name)\nend\nif (not prj.archivesplit_size) then\nprj.archivesplit_size=200\nend\nif (not prj.options.ArchiveSplit) then\n_p('ifeq (posix,$(SHELLTYPE))')\n_p('\\t$(SILENT) rm -f  $(TARGET)')\n_p('else')\n_p('\\t$(SILENT) if exist $(subst /,\\\\\\\\,$(TARGET)) del $(subst /,\\\\\\\\,$(TARGET))')\n_p('endif')\n_p('\\t$(SILENT) $(LINKCMD) $(LINKOBJS)' .. (os.is(\"MacOSX\") and \" 2>&1 > /dev/null | sed -e '/.o) has no symbols$$/d'\" or \"\"))\nelse\n_p('\\t$(call RM,$(TARGET))')\n_p('\\t@$(call max_args,$(LINKCMD),'.. prj.archivesplit_size ..',$(LINKOBJS))' .. (os.is(\"MacOSX\") and \" 2>&1 > /dev/null | sed -e '/.o) has no symbols$$/d'\" or \"\"))\n_p('\\t$(SILENT) $(LINKCMD_NDX)')\nend\nelse\nif prj.msglinking then\n_p('\\t@echo ' .. prj.msglinking)\nelse\n_p('\\t@echo Linking %s', prj.name)\nend\n_p('\\t$(SILENT) $(LINKCM"
	"D)')\nend\n_p('\\t$(POSTBUILDCMDS)')\n_p('')\n_p('$(TARGETDIR):')\npremake.make_mkdirrule(\"$(TARGETDIR)\")\n_p('$(OBJDIRS):')\nif (not prj.solution.messageskip) or (not table.contains(prj.solution.messageskip, \"SkipCreatingMessage\")) then\n_p('\\t@echo Creating $(@)')\nend\n_p('\\t-$(call MKDIR,$@)')\n_p('')\nif os.is(\"MacOSX\") and prj.kind == \"WindowedApp\" and not prj.options.SkipBundling then\n_p('$(dir $(TARGETDIR))PkgInfo:')\n_p('$(dir $(TARGETDIR))Info.plist:')\n_p('')\nend\n_p('clean:')\nif (not prj.solution.messageskip) or (not table.contains(prj.solution.messageskip, \"SkipCleaningMessage\")) then\n_p('\\t@echo Cleaning %s', prj.name)\nend\n_p('ifeq (posix,$(SHELLTYPE))')\n_p('\\t$(SILENT) rm -f  $(TARGET)')\n_p('\\t$(SILENT) rm -rf $(OBJDIR)')\n_p('else')\n_p('\\t$(SILENT) if exist $(subst /,\\\\\\\\,$(TARGET)) del $(subst /,\\\\\\\\,$(TARGET))')\n_p('\\t$(SILENT) if exist $(subst /,\\\\\\\\,$(OBJDIR)) rmdir /s /q $(subst /,\\\\\\\\,$(OBJDIR))')\n_p('endif')\n_p('')\n_p('prebuild:')\n_p('\\t$(P"
	"REBUILDCMDS)')\n_p('')\n_p('prelink:')\n_p('\\t$(PRELINKCMDS)')\n_p('')\ncpp.pchrules(prj)\ncpp.fileRules(prj, cc)\ncpp.dependencyRules(prj)\nfor _, custombuildtask in ipairs(prj.custombuildtask or {}) do\nfor _, buildtask in ipairs(custombuildtask or {}) do\nlocal deps =  string.format(\"%s \",path.getrelative(prj.location,buildtask[1]))\nfor _, depdata in ipairs(buildtask[3] or {}) do\ndeps = deps .. string.format(\"%s \",path.getrelative(prj.location,depdata))\nend\n_p('%s: %s | $(TARGETDIR) $(OBJDIRS)'\n,path.getrelative(prj.location,buildtask[2])\n, deps\n)\nfor _, cmdline in ipairs(buildtask[4] or {}) do\nlocal cmd = cmdline\nlocal num = 1\nfor _, depdata in ipairs(buildtask[3] or {}) do\ncmd = string.gsub(cmd,\"%$%(\" .. num ..\"%)\", string.format(\"%s \",path.getrelative(prj.location,depdata)))\nnum = num + 1\nend\ncmd = string.gsub(cmd, \"%$%(<%)\", \"$<\")\ncmd = string.gsub(cmd, \"%$%(@%)\", \"$@\")\n_p('\\t$(SILENT) %s',cmd)\nend\n_p('')\nend\nend\n_p('-include $(OBJECTS:%%.o=%%.d)')\n_p('ifneq (,"
	"$(PCH))')\n_p('  -include $(OBJDIR)/$(notdir $(PCH)).d')\n_p('  -include $(OBJDIR)/$(notdir $(PCH))_objc.d')\n_p('endif')\nend\nfunction premake.gmake_cpp_header(prj, cc, platforms)\n_p('# %s project makefile autogenerated by GENie', premake.action.current().shortname)\n_p('')\n_p('.SUFFIXES:') -- Delete the default suffix rules.\n_p('')\n_p('ifndef config')\n_p('  config=%s', _MAKE.esc(premake.getconfigname(prj.solution.configurations[1], platforms[1], true)))\n_p('endif')\n_p('')\n_p('ifndef verbose')\n_p('  SILENT = @')\n_p('endif')\n_p('')\n_p('SHELLTYPE := msdos')\n_p('ifeq (,$(ComSpec)$(COMSPEC))')\n_p('  SHELLTYPE := posix')\n_p('endif')\n_p('ifeq (/bin,$(findstring /bin,$(SHELL)))')\n_p('  SHELLTYPE := posix')\n_p('endif')\n_p('ifeq (/bin,$(findstring /bin,$(MAKESHELL)))')\n_p('  SHELLTYPE := posix')\n_p('endif')\n_p('')\n_p('ifeq (posix,$(SHELLTYPE))')\n_p('  MKDIR = $(SILENT) mkdir -p \"$(1)\"')\n_p('  COPY  = $(SILENT) cp -fR \"$(1)\" \"$(2)\"')\n_p('  RM    = $(SILENT) rm -f \"$(1)\"')\n_p('else')"
	"\n_p('  MKDIR = $(SILENT) mkdir \"$(subst /,\\\\\\\\,$(1))\" 2> nul || exit 0')\n_p('  COPY  = $(SILENT) copy /Y \"$(subst /,\\\\\\\\,$(1))\" \"$(subst /,\\\\\\\\,$(2))\"')\n_p('  RM    = $(SILENT) del /F \"$(subst /,\\\\\\\\,$(1))\" 2> nul || exit 0')\n_p('endif')\n_p('')\n_p('CC  = %s', cc.cc)\n_p('CXX = %s', cc.cxx)\n_p('AR  = %s', cc.ar)\n_p('')\n_p('ifndef RESCOMP')\n_p('  ifdef WINDRES')\n_p('    RESCOMP = $(WINDRES)')\n_p('  else')\n_p('    RESCOMP = %s', cc.rc or 'windres')\n_p('  endif')\n_p('endif')\n_p('')\nif (not premake.make.makefile_ignore) then\n_p('MAKEFILE = %s', _MAKE.getmakefilename(prj, true))\n_p('')\nend\nend\nlocal function is_excluded(prj, cfg, file)\nif table.icontains(prj.excludes, file) then\nreturn true\nend\nif table.icontains(cfg.excludes, file) then\nreturn true\nend\nreturn false\nend\nfunction premake.gmake_cpp_configs(prj, cc, platforms)\nfor _, platform in ipairs(platforms) do\nfor cfg in premake.eachconfig(prj, platform) do\npremake.gmake_cpp_config(prj, cfg, cc)\nend\nend"
	"\nend\nfunction premake.gmake_cpp_config(prj, cfg, cc)\n_p('ifeq ($(config),%s)', _MAKE.esc(cfg.shortname))\ncpp.platformtools(cfg, cc)\nlocal targetDir = _MAKE.esc(cfg.buildtarget.directory)\n_p('  ' .. (table.contains(premake.make.override,\"OBJDIR\") and \"override \" or \"\") ..    'OBJDIR              = %s', _MAKE.esc(cfg.objectsdir))\n_p('  ' .. (table.contains(premake.make.override,\"TARGETDIR\") and \"override \" or \"\") .. 'TARGETDIR           = %s', iif(targetDir == \"\", \".\", targetDir))\n_p('  ' .. (table.contains(premake.make.override,\"TARGET\") and \"override \" or \"\") ..    'TARGET              = $(TARGETDIR)/%s', _MAKE.esc(cfg.buildtarget.name))\n_p('  DEFINES            +=%s', make.list(_MAKE.escquote(cc.getdefines(cfg.defines))))\nlocal id  = make.list(cc.getincludedirs(cfg.includedirs));\nlocal uid = make.list(cc.getquoteincludedirs(cfg.userincludedirs))\nlocal sid = make.list(cc.getsystemincludedirs(cfg.systemincludedirs))\nif id ~= \"\" then\n_p('  INCLUDES           +=%s', id)\nend"
	"\nif uid ~= \"\" then\n_p('  INCLUDES           +=%s', uid)\nend\nif sid ~= \"\" then\n_p('  INCLUDES           +=%s', sid)\nend\ncpp.pchconfig(cfg)\ncpp.flags(cfg, cc)\ncpp.linker(prj, cfg, cc)\ntable.sort(cfg.files)\nif cfg.flags.UseObjectResponseFile then\n_p('  OBJRESP             = $(OBJDIR)/%s_objects', prj.name)\nelse\n_p('  OBJRESP             =')\nend\n_p('  OBJECTS := \\\\')\nfor _, file in ipairs(cfg.files) do\nif path.issourcefile(file) then\nif not is_excluded(prj, cfg, file) then\n_p('\\t$(OBJDIR)/%s.o \\\\'\n, _MAKE.esc(path.trimdots(path.removeext(file)))\n)\nend\nend\nend\n_p('')\n_p('  define PREBUILDCMDS')\nif #cfg.prebuildcommands > 0 then\n_p('\\t@echo Running pre-build commands')\n_p('\\t%s', table.implode(cfg.prebuildcommands, \"\", \"\", \"\\n\\t\"))\nend\n_p('  endef')\n_p('  define PRELINKCMDS')\nif #cfg.prelinkcommands > 0 then\n_p('\\t@echo Running pre-link commands')\n_p('\\t%s', table.implode(cfg.prelinkcommands, \"\", \"\", \"\\n\\t\"))\nend\n_p('  endef')\n_p('  define POSTBUILD"
	"CMDS')\nif #cfg.postbuildcommands > 0 then\n_p('\\t@echo Running post-build commands')\n_p('\\t%s', table.implode(cfg.postbuildcommands, \"\", \"\", \"\\n\\t\"))\nend\n_p('  endef')\nmake.settings(cfg, cc)\n_p('endif')\n_p('')\nend\nfunction cpp.platformtools(cfg, cc)\nlocal platform = cc.platforms[cfg.platform]\nif platform.cc then\n_p('  CC         = %s', platform.cc)\nend\nif platform.cxx then\n_p('  CXX        = %s', platform.cxx)\nend\nif platform.ar then\n_p('  AR         = %s', platform.ar)\nend\nend\nfunction cpp.flags(cfg, cc)\nif cfg.pchheader and not cfg.flags.NoPCH then\n_p('  FORCE_INCLUDE      += -include $(OBJDIR)/$(notdir $(PCH))')\n_p('  FORCE_INCLUDE_OBJC += -include $(OBJDIR)/$(notdir $(PCH))_objc')\nend\nif #cfg.forcedincludes > 0 then\n_p('  FORCE_INCLUDE      += -include %s'\n,_MAKE.esc(table.concat(cfg.forcedincludes, \";\")))\nend\n_p('  ALL_CPPFLAGS       += $(CPPFLAGS) %s $(DEFINES) $(INCLUDES)', table.concat(cc.getcppflags(cfg), \" \"))\n_p('  ALL_ASMFLAGS       += $(ASMFLAGS) $(CFLA"
	"GS) $(ALL_CPPFLAGS) $(ARCH)%s', make.list(table.join(cc.getcflags(cfg), cfg.buildoptions, cfg.buildoptions_asm)))\n_p('  ALL_CFLAGS         += $(CFLAGS) $(ALL_CPPFLAGS) $(ARCH)%s', make.list(table.join(cc.getcflags(cfg), cfg.buildoptions, cfg.buildoptions_c)))\n_p('  ALL_CXXFLAGS       += $(CXXFLAGS) $(CFLAGS) $(ALL_CPPFLAGS) $(ARCH)%s', make.list(table.join(cc.getcflags(cfg), cc.getcxxflags(cfg), cfg.buildoptions, cfg.buildoptions_cpp)))\n_p('  ALL_OBJCFLAGS      += $(CFLAGS) $(ALL_CPPFLAGS) $(ARCH)%s', make.list(table.join(cc.getcflags(cfg), cc.getobjcflags(cfg), cfg.buildoptions, cfg.buildoptions_objc)))\n_p('  ALL_OBJCPPFLAGS    += $(CXXFLAGS) $(CFLAGS) $(ALL_CPPFLAGS) $(ARCH)%s', make.list(table.join(cc.getcflags(cfg), cc.getcxxflags(cfg), cc.getobjcflags(cfg), cfg.buildoptions, cfg.buildoptions_objcpp)))\n_p('  ALL_RESFLAGS       += $(RESFLAGS) $(DEFINES) $(INCLUDES)%s',\n        make.list(table.join(cc.getdefines(cfg.resdefines),\n                                cc.getincludedirs(cfg.resincludedirs), cf"
	"g.resoptions)))\nend\nfunction cpp.linker(prj, cfg, cc)\nlocal libdeps\nlocal lddeps\nif #cfg.wholearchive > 0 then\nlibdeps = {}\nlddeps  = {}\nfor _, linkcfg in ipairs(premake.getlinks(cfg, \"siblings\", \"object\")) do\nlocal linkpath = path.rebase(linkcfg.linktarget.fullpath, linkcfg.location, cfg.location)\nif table.icontains(cfg.wholearchive, linkcfg.project.name) then\nlddeps = table.join(lddeps, cc.wholearchive(linkpath))\nelse\ntable.insert(lddeps, linkpath)\nend\ntable.insert(libdeps, linkpath)\nend\nlibdeps = make.list(_MAKE.esc(libdeps))\nlddeps  = make.list(_MAKE.esc(lddeps))\nelse\nlibdeps = make.list(_MAKE.esc(premake.getlinks(cfg, \"siblings\", \"fullpath\")))\nlddeps  = libdeps\nend\n_p('  ALL_LDFLAGS        += $(LDFLAGS)%s', make.list(table.join(cc.getlibdirflags(cfg), cc.getldflags(cfg), cfg.linkoptions)))\n_p('  LIBDEPS            +=%s', libdeps)\n_p('  LDDEPS             +=%s', lddeps)\nif cfg.flags.UseLDResponseFile then\n_p('  LDRESP              = $(OBJDIR)/%s_libs', prj.name)\n_p('  LI"
	"BS               += @$(LDRESP)%s', make.list(cc.getlinkflags(cfg)))\nelse\n_p('  LDRESP              =')\n_p('  LIBS               += $(LDDEPS)%s', make.list(cc.getlinkflags(cfg)))\nend\n_p('  EXTERNAL_LIBS      +=%s', make.list(cc.getlibfiles(cfg)))\n_p('  LINKOBJS            = %s', (cfg.flags.UseObjectResponseFile and \"@$(OBJRESP)\" or \"$(OBJECTS)\"))\nif cfg.kind == \"StaticLib\" then\nif (not prj.options.ArchiveSplit) then\n_p('  LINKCMD             = $(AR) %s $(TARGET)', make.list(cc.getarchiveflags(prj, cfg, false)))\nelse\n_p('  LINKCMD             = $(AR) %s $(TARGET)', make.list(cc.getarchiveflags(prj, cfg, false)))\n_p('  LINKCMD_NDX         = $(AR) %s $(TARGET)', make.list(cc.getarchiveflags(prj, cfg, true)))\nend\nelse\nlocal tool = iif(cfg.language == \"C\", \"CC\", \"CXX\")\nlocal startgroup = ''\nlocal endgroup = ''\nif (cfg.flags.LinkSupportCircularDependencies) then\nstartgroup = '-Wl,--start-group '\nendgroup   = ' -Wl,--end-group'\nend\n_p('  LINKCMD             = $(%s) -o $(TARGET) $(LINK"
	"OBJS) $(RESOURCES) $(ARCH) $(ALL_LDFLAGS) %s$(LIBS)%s', tool, startgroup, endgroup)\nend\nend\nfunction cpp.pchconfig(cfg)\nif not cfg.pchheader or cfg.flags.NoPCH then\nreturn\nend\nlocal pch = cfg.pchheader\nfor _, incdir in ipairs(cfg.includedirs) do\nlocal abspath = path.getabsolute(path.join(cfg.project.location, incdir))\nlocal testname = path.join(abspath, pch)\nif os.isfile(testname) then\npch = path.getrelative(cfg.location, testname)\nbreak\nend\nend\n_p('  PCH                 = %s', _MAKE.esc(pch))\n_p('  GCH                 = $(OBJDIR)/$(notdir $(PCH)).gch')\n_p('  GCH_OBJC            = $(OBJDIR)/$(notdir $(PCH))_objc.gch')\nend\nfunction cpp.pchrules(prj)\n_p('ifneq (,$(PCH))')\n_p('$(GCH): $(PCH) $(MAKEFILE) | $(OBJDIR)')\nif prj.msgprecompile then\n_p('\\t@echo ' .. prj.msgprecompile)\nelse\n_p('\\t@echo $(notdir $<)')\nend\nlocal cmd = iif(prj.language == \"C\", \"$(CC) $(ALL_CFLAGS) -x c-header\", \"$(CXX) $(ALL_CXXFLAGS) -x c++-header\")\n_p('\\t$(SILENT) %s $(DEFINES) $(INCLUDES) -o \"$@\" -"
	"c \"$<\"', cmd)\n_p('')\n_p('$(GCH_OBJC): $(PCH) $(MAKEFILE) | $(OBJDIR)')\nif prj.msgprecompile then\n_p('\\t@echo ' .. prj.msgprecompile)\nelse\n_p('\\t@echo $(notdir $<)')\nend\nlocal cmd = iif(prj.language == \"C\", \"$(CC) $(ALL_OBJCFLAGS) -x objective-c-header\", \"$(CXX) $(ALL_OBJCPPFLAGS) -x objective-c++-header\")\n_p('\\t$(SILENT) %s $(DEFINES) $(INCLUDES) -o \"$@\" -c \"$<\"', cmd)\n_p('endif')\n_p('')\nend\nfunction cpp.fileRules(prj, cc)\nlocal platforms = premake.filterplatforms(prj.solution, cc.platforms, \"Native\")\n_p('ifneq (,$(OBJRESP))')\n_p('$(OBJRESP): $(OBJECTS) | $(TARGETDIR) $(OBJDIRS)')\n_p('\\t$(SILENT) echo $^')\n_p('\\t$(SILENT) echo $^ > $@')\n_p('endif')\n_p('')\n_p('ifneq (,$(LDRESP))')\n_p('$(LDRESP): $(LDDEPS) | $(TARGETDIR) $(OBJDIRS)')\n_p('\\t$(SILENT) echo $^')\n_p('\\t$(SILENT) echo $^ > $@')\n_p('endif')\n_p('')\ntable.sort(prj.allfiles)\nfor _, file in ipairs(prj.allfiles or {}) do\nif path.issourcefile(file) then\nif (path.isobjcfile(file)) then\n_p('$(OBJDIR)/%s.o: %"
	"s $(GCH_OBJC) $(MAKEFILE) | $(OBJDIR)/%s'\n, _MAKE.esc(path.trimdots(path.removeext(file)))\n, _MAKE.esc(file)\n, _MAKE.esc(path.getdirectory(path.trimdots(file)))\n)\nelse\n_p('$(OBJDIR)/%s.o: %s $(GCH) $(MAKEFILE) | $(OBJDIR)/%s'\n, _MAKE.esc(path.trimdots(path.removeext(file)))\n, _MAKE.esc(file)\n, _MAKE.esc(path.getdirectory(path.trimdots(file)))\n)\nend\nif (path.isobjcfile(file) and prj.msgcompile_objc) then\n_p('\\t@echo ' .. prj.msgcompile_objc)\nelseif prj.msgcompile then\n_p('\\t@echo ' .. prj.msgcompile)\nelse\n_p('\\t@echo $(notdir $<)')\nend\nif (path.isobjcfile(file)) then\nif (path.iscfile(file)) then\n_p('\\t$(SILENT) $(CXX) $(ALL_OBJCFLAGS) $(FORCE_INCLUDE_OBJC) -o \"$@\" -c \"$<\"')\nelse\n_p('\\t$(SILENT) $(CXX) $(ALL_OBJCPPFLAGS) $(FORCE_INCLUDE_OBJC) -o \"$@\" -c \"$<\"')\nend\nelseif (path.isasmfile(file)) then\n_p('\\t$(SILENT) $(CC) $(ALL_ASMFLAGS) -o \"$@\" -c \"$<\"')\nelse\ncpp.buildcommand(path.iscfile(file) and not prj.options.ForceCPP, \"o\")\nend\nfor _, task in ipairs(prj.postc"
	"ompiletasks or {}) do\n_p('\\t$(SILENT) %s', task)\n_p('')\nend\n_p('')\nelseif (path.getextension(file) == \".rc\") then\n_p('$(OBJDIR)/%s.res: %s', _MAKE.esc(path.getbasename(file)), _MAKE.esc(file))\nif prj.msgresource then\n_p('\\t@echo ' .. prj.msgresource)\nelse\n_p('\\t@echo $(notdir $<)')\nend\n_p('\\t$(SILENT) $(RESCOMP) $< -O coff -o \"$@\" $(ALL_RESFLAGS)')\n_p('')\nend\nend\nend\nfunction cpp.dependencyRules(prj)\nfor _, dependency in ipairs(prj.dependency or {}) do\nfor _, dep in ipairs(dependency or {}) do\nif (dep[3]==nil or dep[3]==false) then\n_p('$(OBJDIR)/%s.o: %s'\n, _MAKE.esc(path.trimdots(path.removeext(path.getrelative(prj.location, dep[1]))))\n, _MAKE.esc(path.getrelative(prj.location, dep[2]))\n)\nelse\n_p('%s: %s'\n, _MAKE.esc(dep[1])\n, _MAKE.esc(path.getrelative(prj.location, dep[2]))\n)\nend\n_p('')\nend\nend\nend\nfunction cpp.buildcommand(iscfile, objext)\nlocal flags = iif(iscfile, '$(CC) $(ALL_CFLAGS)', '$(CXX) $(ALL_CXXFLAGS)')\n_p('\\t$(SILENT) %s $(FORCE_INCLUDE) -o \"$@\" -"
	"c \"$<\"', flags, objext)\nend\n",

	/* actions/make/make_csharp.lua */
	"local function getresourcefilename(cfg, fname)\nif path.getextension(fname) == \".resx\" then\nlocal name = cfg.buildtarget.basename .. \".\"\nlocal dir = path.getdirectory(fname)\nif dir ~= \".\" then\nname = name .. path.translate(dir, \".\") .. \".\"\nend\nreturn \"$(OBJDIR)/\" .. _MAKE.esc(name .. path.getbasename(fname)) .. \".resources\"\nelse\nreturn fname\nend\nend\nfunction premake.make_csharp(prj)\nlocal csc = premake.dotnet\nlocal cfglibs = { }\nlocal cfgpairs = { }\nlocal anycfg\nfor cfg in premake.eachconfig(prj) do\nanycfg = cfg\ncfglibs[cfg] = premake.getlinks(cfg, \"siblings\", \"fullpath\")\ncfgpairs[cfg] = { }\nfor _, fname in ipairs(cfglibs[cfg]) do\nif path.getdirectory(fname) ~= cfg.buildtarget.directory then\ncfgpairs[cfg][\"$(TARGETDIR)/\" .. _MAKE.esc(path.getname(fname))] = _MAKE.esc(fname)\nend\nend\nend\nlocal sources = {}\nlocal embedded = { }\nlocal copypairs = { }\nfor fcfg in premake.project.eachfile(prj) do\nlocal action = csc.getbuildaction(fcfg)\nif action == \"Compile\" then"
	"\ntable.insert(sources, fcfg.name)\nelseif action == \"EmbeddedResource\" then\ntable.insert(embedded, fcfg.name)\nelseif action == \"Content\" then\ncopypairs[\"$(TARGETDIR)/\" .. _MAKE.esc(path.getname(fcfg.name))] = _MAKE.esc(fcfg.name)\nelseif path.getname(fcfg.name):lower() == \"app.config\" then\ncopypairs[\"$(TARGET).config\"] = _MAKE.esc(fcfg.name)\nend\nend\nlocal paths = table.translate(prj.libdirs, function(v) return path.join(prj.basedir, v) end)\npaths = table.join({prj.basedir}, paths)\nfor _, libname in ipairs(premake.getlinks(prj, \"system\", \"fullpath\")) do\nlocal libdir = os.pathsearch(libname..\".dll\", unpack(paths))\nif (libdir) then\nlocal target = \"$(TARGETDIR)/\" .. _MAKE.esc(path.getname(libname))\nlocal source = path.getrelative(prj.basedir, path.join(libdir, libname))..\".dll\"\ncopypairs[target] = _MAKE.esc(source)\nend\nend\n_p('# %s project makefile autogenerated by GENie', premake.action.current().shortname)\n_p('')\n_p('.SUFFIXES:') -- Delete the default suffix rules.\n_p('')"
	"\n_p('ifndef config')\n_p('  config=%s', _MAKE.esc(prj.configurations[1]:lower()))\n_p('endif')\n_p('')\n_p('ifndef verbose')\n_p('  SILENT = @')\n_p('endif')\n_p('')\n_p('SHELLTYPE := msdos')\n_p('ifeq (,$(ComSpec)$(COMSPEC))')\n_p('  SHELLTYPE := posix')\n_p('endif')\n_p('ifeq (/bin,$(findstring /bin,$(SHELL)))')\n_p('  SHELLTYPE := posix')\n_p('endif')\n_p('ifeq (/bin,$(findstring /bin,$(MAKESHELL)))')\n_p('  SHELLTYPE := posix')\n_p('endif')\n_p('')\n_p('ifeq (posix,$(SHELLTYPE))')\n_p('  MKDIR = $(SILENT) mkdir -p \"$(1)\"')\n_p('  COPY  = $(SILENT) cp -fR \"$(1)\" \"$(2)\"')\n_p('else')\n_p('  MKDIR = $(SILENT) mkdir \"$(subst /,\\\\\\\\,$(1))\" 2> nul')\n_p('  COPY  = $(SILENT) copy /Y \"$(subst /,\\\\\\\\,$(1))\" \"$(subst /,\\\\\\\\,$(2))\"')\n_p('endif')\n_p('')\n_p('ifndef CSC')\n_p('  CSC=%s', csc.getcompilervar(prj))\n_p('endif')\n_p('')\n_p('ifndef RESGEN')\n_p('  RESGEN=resgen')\n_p('endif')\n_p('')\nlocal platforms = premake.filterplatforms(prj.solution, premake[_OPTIONS.cc].platforms)\ntable.i"
	"nsert(platforms, 1, \"\")\nfor cfg in premake.eachconfig(prj) do\npremake.gmake_cs_config(cfg, csc, cfglibs)\nend\n_p('# To maintain compatibility with VS.NET, these values must be set at the project level')\n_p('TARGET     := $(TARGETDIR)/%s', _MAKE.esc(prj.buildtarget.name))\n_p('FLAGS      += /t:%s %s', csc.getkind(prj):lower(), table.implode(_MAKE.esc(prj.libdirs), \"/lib:\", \"\", \" \"))\n_p('REFERENCES += %s', table.implode(_MAKE.esc(premake.getlinks(prj, \"system\", \"basename\")), \"/r:\", \".dll\", \" \"))\n_p('')\n_p('SOURCES := \\\\')\nfor _, fname in ipairs(sources) do\n_p('\\t%s \\\\', _MAKE.esc(path.translate(fname)))\nend\n_p('')\n_p('EMBEDFILES := \\\\')\nfor _, fname in ipairs(embedded) do\n_p('\\t%s \\\\', getresourcefilename(prj, fname))\nend\n_p('')\n_p('COPYFILES += \\\\')\nfor target, source in pairs(cfgpairs[anycfg]) do\n_p('\\t%s \\\\', target)\nend\nfor target, source in pairs(copypairs) do\n_p('\\t%s \\\\', target)\nend\n_p('')\n_p('SHELLTYPE := msdos')\n_p('ifeq (,$(ComSpec)$(COMSPE"
	"C))')\n_p('  SHELLTYPE := posix')\n_p('endif')\n_p('ifeq (/bin,$(findstring /bin,$(SHELL)))')\n_p('  SHELLTYPE := posix')\n_p('endif')\n_p('ifeq (/bin,$(findstring /bin,$(MAKESHELL)))')\n_p('  SHELLTYPE := posix')\n_p('endif')\n_p('')\n_p('.PHONY: clean prebuild prelink')\n_p('')\n_p('all: $(TARGETDIR) $(OBJDIR) prebuild $(EMBEDFILES) $(COPYFILES) prelink $(TARGET)')\n_p('')\n_p('$(TARGET): $(SOURCES) $(EMBEDFILES) $(DEPENDS)')\n_p('\\t$(SILENT) $(CSC) /nologo /out:$@ $(FLAGS) $(REFERENCES) $(SOURCES) $(patsubst %%,/resource:%%,$(EMBEDFILES))')\n_p('\\t$(POSTBUILDCMDS)')\n_p('')\n_p('$(TARGETDIR):')\npremake.make_mkdirrule(\"$(TARGETDIR)\")\n_p('$(OBJDIR):')\npremake.make_mkdirrule(\"$(OBJDIR)\")\n_p('clean:')\n_p('\\t@echo Cleaning %s', prj.name)\n_p('ifeq (posix,$(SHELLTYPE))')\n_p('\\t$(SILENT) rm -f $(TARGET) $(COPYFILES)')\n_p('\\t$(SILENT) rm -rf $(OBJDIR)')\n_p('else')\n_p('\\t$(SILENT) if exist $(subst /,\\\\\\\\,$(TARGETDIR)/%s.*) del $(subst /,\\\\\\\\,$(TARGETDIR)/%s.*)', prj.buildtarget.basename, p"
	"rj.buildtarget.basename)\nfor target, source in pairs(cfgpairs[anycfg]) do\n_p('\\t$(SILENT) if exist $(subst /,\\\\\\\\,%s) del $(subst /,\\\\\\\\,%s)', target, target)\nend\nfor target, source in pairs(copypairs) do\n_p('\\t$(SILENT) if exist $(subst /,\\\\\\\\,%s) del $(subst /,\\\\\\\\,%s)', target, target)\nend\n_p('\\t$(SILENT) if exist $(subst /,\\\\\\\\,$(OBJDIR)) rmdir /s /q $(subst /,\\\\\\\\,$(OBJDIR))')\n_p('endif')\n_p('')\n_p('prebuild:')\n_p('\\t$(PREBUILDCMDS)')\n_p('')\n_p('prelink:')\n_p('\\t$(PRELINKCMDS)')\n_p('')\n_p('# Per-configuration copied file rules')\nfor cfg in premake.eachconfig(prj) do\n_p('ifneq (,$(findstring %s,$(config)))', _MAKE.esc(cfg.name:lower()))\nfor target, source in pairs(cfgpairs[cfg]) do\npremake.make_copyrule(source, target)\nend\n_p('endif')\n_p('')\nend\n_p('# Copied file rules')\nfor target, source in pairs(copypairs) do\npremake.make_copyrule(source, target)\nend\n_p('# Embedded file rules')\nfor _, fname in ipairs(embedded) do\nif path.getextension(fname) == "
	"\".resx\" then\n_p('%s: %s', getresourcefilename(prj, fname), _MAKE.esc(fname))\n_p('\\t$(SILENT) $(RESGEN) $^ $@')\nend\n_p('')\nend\nend\nfunction premake.gmake_cs_config(cfg, csc, cfglibs)\nlocal targetDir = _MAKE.esc(cfg.buildtarget.directory)\n_p('ifneq (,$(findstring %s,$(config)))', _MAKE.esc(cfg.name:lower()))\n_p('  TARGETDIR  := %s', iif(targetDir == \"\", \".\", targetDir))\n_p('  OBJDIR     := %s', _MAKE.esc(cfg.objectsdir))\n_p('  DEPENDS    := %s', table.concat(_MAKE.esc(premake.getlinks(cfg, \"dependencies\", \"fullpath\")), \" \"))\n_p('  REFERENCES := %s', table.implode(_MAKE.esc(cfglibs[cfg]), \"/r:\", \"\", \" \"))\n_p('  FLAGS      += %s %s', table.implode(cfg.defines, \"/d:\", \"\", \" \"), table.concat(table.join(csc.getflags(cfg), cfg.buildoptions), \" \"))\n_p('  define PREBUILDCMDS')\nif #cfg.prebuildcommands > 0 then\n_p('\\t@echo Running pre-build commands')\n_p('\\t%s', table.implode(cfg.prebuildcommands, \"\", \"\", \"\\n\\t\"))\nend\n_p('  endef')\n_p('  define PRELINKCMDS')\nif #"
	"cfg.prelinkcommands > 0 then\n_p('\\t@echo Running pre-link commands')\n_p('\\t%s', table.implode(cfg.prelinkcommands, \"\", \"\", \"\\n\\t\"))\nend\n_p('  endef')\n_p('  define POSTBUILDCMDS')\nif #cfg.postbuildcommands > 0 then\n_p('\\t@echo Running post-build commands')\n_p('\\t%s', table.implode(cfg.postbuildcommands, \"\", \"\", \"\\n\\t\"))\nend\n_p('  endef')\n_p('endif')\n_p('')\nend\n",

	/* actions/make/make_vala.lua */
	"premake.make.vala = { }\npremake.make.makefile_ignore = false\nlocal vala = premake.make.vala\nlocal make = premake.make\nfunction premake.make_vala(prj)\nlocal valac = premake.gettool(prj)\nlocal platforms = premake.filterplatforms(prj.solution, valac.platforms, \"Native\")\npremake.gmake_vala_header(prj, valac, platforms)\nfor _, platform in ipairs(platforms) do\nfor cfg in premake.eachconfig(prj, platform) do\npremake.gmake_valac_config(prj, cfg, valac)\nend\nend\nlocal objdirs = {}\nlocal additionalobjdirs = {}\nfor _, file in ipairs(prj.allfiles) do\nif path.issourcefile(file) or path.isgresource(file) then\nobjdirs[_MAKE.esc(path.getdirectory(path.trimdots(file)))] = 1\nend\nend\n_p('OBJDIRS := \\\\')\n_p('\\t$(OBJDIR) \\\\')\nfor dir, _ in iter.sortByKeys(objdirs) do\n_p('\\t$(OBJDIR)/%s \\\\', dir)\nend\nfor dir, _ in iter.sortByKeys(additionalobjdirs) do\n_p('\\t%s \\\\', dir)\nend\n_p('')\n_p('.PHONY: clean prebuild prelink')\n_p('')\n_p('all: $(OBJDIRS) $(TARGETDIR) prebuild prelink $(TARGET)')\n_p("
	"'\\t@:')\n_p('')\n_p('$(TARGET): $(OBJECTS) | $(TARGETDIR)')\n_p('\\t@echo Linking %s', prj.name)\n_p('\\t$(SILENT) $(LINKCMD)')\n_p('\\t$(POSTBUILDCMDS)')\n_p('')\n_p('$(TARGETDIR):')\npremake.make_mkdirrule(\"$(TARGETDIR)\")\n_p('$(OBJDIRS):')\nif (not prj.solution.messageskip) or (not table.contains(prj.solution.messageskip, \"SkipCreatingMessage\")) then\n_p('\\t@echo Creating $(@)')\nend\n_p('\\t-$(call MKDIR,$@)')\n_p('')\n_p('clean:')\nif (not prj.solution.messageskip) or (not table.contains(prj.solution.messageskip, \"SkipCleaningMessage\")) then\n_p('\\t@echo Cleaning %s', prj.name)\nend\n_p('ifeq (posix,$(SHELLTYPE))')\n_p('\\t$(SILENT) rm -f  $(TARGET)')\n_p('else')\n_p('\\t$(SILENT) if exist $(subst /,\\\\\\\\,$(TARGET)) del $(subst /,\\\\\\\\,$(TARGET))')\n_p('endif')\n_p('')\n_p('prebuild:')\n_p('\\t$(PREBUILDCMDS)')\n_p('')\n_p('prelink:')\n_p('\\t$(PRELINKCMDS)')\n_p('')\nvala.fileRules(prj, valac)\nend\nfunction premake.gmake_vala_header(prj, valac, platforms)\n_p('# %s project makefile autoge"
	"nerated by GENie', premake.action.current().shortname)\n_p('')\n_p('.SUFFIXES:') -- Delete the default suffix rules.\n_p('')\n_p('ifndef config')\n_p('  config=%s', _MAKE.esc(premake.getconfigname(prj.solution.configurations[1], platforms[1], true)))\n_p('endif')\n_p('')\n_p('ifndef verbose')\n_p('  SILENT = @')\n_p('endif')\n_p('')\n_p('SHELLTYPE := msdos')\n_p('ifeq (,$(ComSpec)$(COMSPEC))')\n_p('  SHELLTYPE := posix')\n_p('endif')\n_p('ifeq (/bin,$(findstring /bin,$(SHELL)))')\n_p('  SHELLTYPE := posix')\n_p('endif')\n_p('ifeq (/bin,$(findstring /bin,$(MAKESHELL)))')\n_p('  SHELLTYPE := posix')\n_p('endif')\n_p('')\n_p('ifeq (posix,$(SHELLTYPE))')\n_p('  MKDIR = $(SILENT) mkdir -p \"$(1)\"')\n_p('  COPY  = $(SILENT) cp -fR \"$(1)\" \"$(2)\"')\n_p('  RM    = $(SILENT) rm -f \"$(1)\"')\n_p('else')\n_p('  MKDIR = $(SILENT) mkdir \"$(subst /,\\\\\\\\,$(1))\" 2> nul || exit 0')\n_p('  COPY  = $(SILENT) copy /Y \"$(subst /,\\\\\\\\,$(1))\" \"$(subst /,\\\\\\\\,$(2))\"')\n_p('  RM    = $(SILENT) del /F \"$(subst /"
	",\\\\\\\\,$(1))\" 2> nul || exit 0')\n_p('endif')\n_p('')\n_p('VALAC  = %s', valac.valac)\n_p('CC     = %s', valac.cc)\n_p('GLIBRC = %s', valac.glibrc)\n_p('')\nif (not premake.make.makefile_ignore) then\n_p('MAKEFILE = %s', _MAKE.getmakefilename(prj, true))\n_p('')\nend\nend\nlocal function is_excluded(prj, cfg, file)\nif table.icontains(prj.excludes, file) then\nreturn true\nend\nif table.icontains(cfg.excludes, file) then\nreturn true\nend\nreturn false\nend\nfunction premake.gmake_valac_config(prj, cfg, valac)\n_p('ifeq ($(config),%s)', _MAKE.esc(cfg.shortname))\n_p('  BASEDIR     = %s', _MAKE.esc(path.getrelative(cfg.location, _WORKING_DIR)))\n_p('  OBJDIR      = %s', _MAKE.esc(cfg.objectsdir))\n_p('  TARGETDIR   = %s', _MAKE.esc(cfg.buildtarget.directory))\n_p('  TARGET      = $(TARGETDIR)/%s', _MAKE.esc(cfg.buildtarget.name))\n_p('  DEFINES    +=%s', make.list(valac.getdefines(cfg.defines)))\n_p('  VAPIDIRS   +=%s', make.list(valac.getvapidirs(cfg.vapidirs)))\n_p('  PKGS       +=%s', make.list(valac.get"
	"links(cfg.links)))\n_p('  FLAGS      += $(DEFINES) $(VAPIDIRS) $(PKGS)%s', make.list(table.join(valac.getvalaflags(cfg), cfg.buildoptions_vala)))\n_p('  VALA_LDFLAGS= $(shell pkg-config --libs%s)', make.list(cfg.links))\n_p('  ALL_LDFLAGS+= $(LDFLAGS)%s $(VALA_LDFLAGS)', make.list(table.join(cfg.linkoptions)))\n_p('  LINKOBJS    = %s', \"$(OBJECTS)\")\n_p('  VALA_CFLAGS = $(shell pkg-config --cflags%s)%s', make.list(cfg.links), make.list(valac.getvalaccflags(cfg)))\n_p('  ALL_CFLAGS += $(CFLAGS) $(ARCH)%s $(VALA_CFLAGS)', make.list(table.join(cfg.buildoptions, cfg.buildoptions_c)))\n_p('  LINKCMD     = $(CC) -o $(TARGET) $(LINKOBJS) $(ARCH) $(ALL_LDFLAGS)');\ntable.sort(cfg.files)\n_p('  OBJECTS := \\\\')\nfor _, file in ipairs(cfg.files) do\nif path.issourcefile(file) or path.isgresource(file) then\nif not is_excluded(prj, cfg, file) then\n_p('\\t$(OBJDIR)/%s.o \\\\'\n, _MAKE.esc(path.trimdots(path.removeext(file)))\n)\nend\nend\nend\n_p('')\n_p('  SOURCES := \\\\')\nfor _, file in ipairs(cfg.files) do\nif pa"
	"th.issourcefile(file) and path.isvalafile(file) then\nif not is_excluded(prj, cfg, file) then\n_p('\\t%s \\\\', _MAKE.esc(file))\nend\nend\nend\n_p('')\n_p('  GRESOURCES := \\\\')\nfor _, file in ipairs(cfg.files) do\nif path.isgresource(file) then\nif not is_excluded(prj, cfg, file) then\n_p('\\t%s \\\\', _MAKE.esc(file))\nend\nend\nend\n_p('')\n_p('  define PREBUILDCMDS')\nif #cfg.prebuildcommands > 0 then\n_p('\\t@echo Running pre-build commands')\n_p('\\t%s', table.implode(cfg.prebuildcommands, \"\", \"\", \"\\n\\t\"))\nend\n_p('  endef')\n_p('  define PRELINKCMDS')\nif #cfg.prelinkcommands > 0 then\n_p('\\t@echo Running pre-link commands')\n_p('\\t%s', table.implode(cfg.prelinkcommands, \"\", \"\", \"\\n\\t\"))\nend\n_p('  endef')\n_p('  define POSTBUILDCMDS')\nif #cfg.postbuildcommands > 0 then\n_p('\\t@echo Running post-build commands')\n_p('\\t%s', table.implode(cfg.postbuildcommands, \"\", \"\", \"\\n\\t\"))\nend\n_p('  endef')\n_p('endif')\n_p('')\nend\nfunction vala.fileRules(prj, cc)\nlocal platfor"
	"ms = premake.filterplatforms(prj.solution, cc.platforms, \"Native\")\n_p('ifneq (,$(OBJRESP))')\n_p('$(OBJRESP): $(OBJECTS) | $(TARGETDIR) $(OBJDIRS)')\n_p('\\t$(SILENT) echo $^')\n_p('\\t$(SILENT) echo $^ > $@')\n_p('endif')\n_p('')\n_p('ifneq (,$(LDRESP))')\n_p('$(LDRESP): $(LDDEPS) | $(TARGETDIR) $(OBJDIRS)')\n_p('\\t$(SILENT) echo $^')\n_p('\\t$(SILENT) echo $^ > $@')\n_p('endif')\n_p('')\nlocal pattern_targets = \"\"\ntable.sort(prj.allfiles)\nfor _, file in ipairs(prj.allfiles or {}) do\nif path.issourcefile(file) or path.isgresource(file) then\nif path.isvalafile(file) or path.iscfile(file) or path.isgresource(file) then\nif path.isvalafile(file) or path.isgresource(file) then\n_p('$(OBJDIR)/%s.o: $(OBJDIR)/%s.c $(GCH) $(MAKEFILE) | $(OBJDIR)/%s'\n, _MAKE.esc(path.trimdots(path.removeext(file)))\n, _MAKE.esc(path.trimdots(path.removeext(file)))\n, _MAKE.esc(path.getdirectory(path.trimdots(file)))\n)\nif not path.isgresource(file) then\npattern_targets = pattern_targets\n.. \"$(OBJDIR)/\"\n.. _MAKE.esc(p"
	"ath.trimdots(path.removeext(file)))\n.. \".% \\\\\\n\" -- Pattern rule: https://stackoverflow.com/a/3077254\nend\nelse\n_p('$(OBJDIR)/%s.o: %s $(GCH) $(MAKEFILE) | $(OBJDIR)/%s'\n, _MAKE.esc(path.trimdots(path.removeext(file)))\n, file\n, _MAKE.esc(path.getdirectory(path.trimdots(file)))\n)\nend\nif prj.msgcompile then\n_p('\\t@echo ' .. prj.msgcompile)\nelse\n_p('\\t@echo $(notdir $<)')\nend\n_p('\\t$(SILENT) %s $(FORCE_INCLUDE) -o \"$@\" -c \"$<\"'\n, \"$(CC) $(ALL_CFLAGS)\"\n, _MAKE.esc(path.getbasename(file))\n)\nfor _, task in ipairs(prj.postcompiletasks or {}) do\n_p('\\t$(SILENT) %s', task)\n_p('')\nend\n_p('')\nif path.isgresource(file) then\n_p('$(OBJDIR)/%s.c: %s $(GCH) $(MAKEFILE) | $(OBJDIR)/%s'\n, _MAKE.esc(path.trimdots(path.removeext(file)))\n, _MAKE.esc(file)\n, _MAKE.esc(path.getdirectory(path.trimdots(file)))\n)\nif prj.msgcompile then\n_p('\\t@echo ' .. prj.msgcompile)\nelse\n_p('\\t@echo $(notdir $<)')\nend\n_p('\\t$(SILENT) %s \"$<\" --target=\"$@\" --sourcedir=\"%s\" --generate'\n, \"$(GL"
	"IBRC)\"\n, _MAKE.esc(path.getdirectory(file))\n)\nfor _, task in ipairs(prj.postcompiletasks or {}) do\n_p('\\t$(SILENT) %s', task)\n_p('')\nend\nend\n_p('')\nend\nend\nend\nif pattern_targets ~= \"\" then\n_p('%s: $(SOURCES) $(GRESOURCES) $(GCH) $(MAKEFILE)', pattern_targets)\nif prj.msgcompile then\n_p('\\t@echo ' .. prj.msgcompile)\nelse\n_p('\\t@echo [GEN] valac')\nend\n_p('\\t$(SILENT) %s $(SOURCES) --directory $(OBJDIR) --basedir $(BASEDIR) --gresources=$(GRESOURCES) -C'\n, \"$(VALAC) $(FLAGS)\"\n)\nfor _, task in ipairs(prj.postcompiletasks or {}) do\n_p('\\t$(SILENT) %s', task)\n_p('')\nend\nend\nend\n",

	/* actions/make/make_swift.lua */
	"local make = premake.make\nlocal swift = { }\nfunction premake.make_swift(prj)\nlocal tool = premake.gettool(prj)\nlocal platforms = premake.filterplatforms(prj.solution, tool.platforms, \"Native\")\n_p('# %s project makefile autogenerated by GENie', premake.action.current().shortname)\n_p('')\n_p('.SUFFIXES:') -- Delete the default suffix rules.\n_p('')\n_p('ifndef config')\n_p(1, 'config=%s', _MAKE.esc(premake.getconfigname(prj.solution.configurations[1], platforms[1], true)))\n_p('endif')\n_p('')\n_p('ifndef verbose')\n_p(1, 'SILENT = @')\n_p('endif')\n_p('')\n_p('SHELLTYPE := msdos')\n_p('ifeq (,$(ComSpec)$(COMSPEC))')\n_p(1, 'SHELLTYPE := posix')\n_p('endif')\n_p('ifeq (/bin,$(findstring /bin,$(SHELL)))')\n_p(1, 'SHELLTYPE := posix')\n_p('endif')\n_p('ifeq (/bin,$(findstring /bin,$(MAKESHELL)))')\n_p(1, 'SHELLTYPE := posix')\n_p('endif')\n_p('')\n_p('ifeq (posix,$(SHELLTYPE))')\n_p(1, 'MKDIR = $(SILENT) mkdir -p \"$(1)\"')\n_p(1, 'COPY  = $(SILENT) cp -fR \"$(1)\" \"$(2)\"')\n_p(1, 'RM    = $(SILENT) rm -"
	"f \"$(1)\"')\n_p('else')\n_p(1, 'MKDIR = $(SILENT) mkdir \"$(subst /,\\\\\\\\,$(1))\" 2> nul || exit 0')\n_p(1, 'COPY  = $(SILENT) copy /Y \"$(subst /,\\\\\\\\,$(1))\" \"$(subst /,\\\\\\\\,$(2))\"')\n_p(1, 'RM    = $(SILENT) del /F \"$(subst /,\\\\\\\\,$(1))\" 2> nul || exit 0')\n_p('endif')\n_p('')\n_p('SWIFTC = %s', tool.swift)\n_p('SWIFTLINK = %s', tool.swiftc)\n_p('DSYMUTIL = %s', tool.dsymutil)\n_p('AR = %s', tool.ar)\n_p('')\nfor _, platform in ipairs(platforms) do\nfor cfg in premake.eachconfig(prj, platform) do\nswift.generate_config(prj, cfg, tool)\nend\nend\n_p('.PHONY: ')\n_p('')\n_p('all: $(WORK_DIRS) $(TARGET)')\n_p('')\n_p('$(WORK_DIRS):')\n_p(1, '$(SILENT) $(call MKDIR,$@)')\n_p('')\n_p('SOURCES := \\\\')\nfor _, file in ipairs(prj.files) do\nif path.isswiftfile(file) then\n_p(1, '%s \\\\', _MAKE.esc(file))\nend\nend\n_p('')\nlocal objfiles = {}\n_p('OBJECTS_WITNESS := $(OBJDIR)/build.stamp')\n_p('OBJECTS := \\\\')\nfor _, file in ipairs(prj.files) do\nif path.isswiftfile(file) then\nlocal objna"
	"me = _MAKE.esc(swift.objectname(file))\ntable.insert(objfiles, objname)\n_p(1, '%s \\\\', objname)\nend\nend\n_p('')\nswift.file_rules(prj, objfiles)\nswift.linker(prj, tool)\nswift.generate_clean(prj)\nend\nfunction swift.objectname(file)\nreturn path.join(\"$(OBJDIR)\", path.getname(file)..\".o\")\nend\nfunction swift.file_rules(prj, objfiles)\n_p('$(OBJECTS_WITNESS): $(SOURCES)')\n_p(1, \"@rm -f $(OBJDIR)/data.tmp\")\n_p(1, \"@touch $(OBJDIR)/data.tmp\")\n_p(1, \"$(SILENT) $(SWIFTC) -frontend -c $(SOURCES) -enable-objc-interop $(SDK) -I $(OUT_DIR) $(SWIFTC_FLAGS) -module-cache-path $(MODULECACHE_DIR) -D SWIFT_PACKAGE $(MODULE_MAPS) -emit-module-doc-path $(OUT_DIR)/$(MODULE_NAME).swiftdoc -module-name $(MODULE_NAME) -emit-module-path $(OUT_DIR)/$(MODULE_NAME).swiftmodule -num-threads 8 %s\", table.arglist(\"-o\", objfiles))\n_p(1, \"@mv -f $(OBJDIR)/data.tmp $(OBJECTS_WITNESS)\")\n_p('')\n_p('$(OBJECTS): $(OBJECTS_WITNESS)')\n_p(1, '@if test -f $@; then :; else \\\\')\n_p(2, 'rm -f $(OBJECTS_WITNESS); \\\\')"
	"\n_p(2, '$(MAKE) $(AM_MAKEFLAGS) $(OBJECTS_WITNESS); \\\\')\n_p(1, 'fi')\n_p('')\nend\nfunction swift.linker(prj, tool)\nlocal lddeps = make.list(premake.getlinks(prj, \"siblings\", \"fullpath\"))\nif prj.kind == \"StaticLib\" then\n_p(\"$(TARGET): $(OBJECTS) %s \", lddeps)\n_p(1, \"$(SILENT) $(AR) cr $(AR_FLAGS) $@ $(OBJECTS) %s\", (os.is(\"MacOSX\") and \" 2>&1 > /dev/null | sed -e '/.o) has no symbols$$/d'\" or \"\"))\nelse\n_p(\"$(TARGET): $(OBJECTS) $(LDDEPS)\", lddeps)\n_p(1, \"$(SILENT) $(SWIFTLINK) $(SDK) -L $(OUT_DIR) -o $@ $(SWIFTLINK_FLAGS) $(LD_FLAGS) $(OBJECTS)\")\n_p(\"ifdef SYMBOLS\")\n_p(1, \"$(SILENT) $(DSYMUTIL) $(TARGET) -o $(SYMBOLS)\")\n_p(\"endif\")\nend\n_p('')\nend\nfunction swift.generate_clean(prj)\n_p('clean:')\nif (not prj.solution.messageskip) or (not table.contains(prj.solution.messageskip, \"SkipCleaningMessage\")) then\n_p('\\t@echo Cleaning %s', prj.name)\nend\n_p('ifeq (posix,$(SHELLTYPE))')\n_p('\\t$(SILENT) rm -f  $(TARGET)')\n_p('\\t$(SILENT) rm -rf $(OBJDIR)')\n_p('\\t$(SI"
	"LENT) rm -rf $(SYMBOLS)')\n_p('\\t$(SILENT) rm -rf $(MODULECACHE_DIR)')\n_p('else')\n_p('\\t$(SILENT) if exist $(subst /,\\\\\\\\,$(TARGET)) del $(subst /,\\\\\\\\,$(TARGET))')\n_p('\\t$(SILENT) if exist $(subst /,\\\\\\\\,$(OBJDIR)) rmdir /s /q $(subst /,\\\\\\\\,$(OBJDIR))')\n_p('\\t$(SILENT) if exist $(subst /,\\\\\\\\,$(SYMBOLS)) rmdir /s /q $(subst /,\\\\\\\\,$(SYMBOLS))')\n_p('\\t$(SILENT) if exist $(subst /,\\\\\\\\,$(MODULECACHE_DIR)) rmdir /s /q $(subst /,\\\\\\\\,$(MODULECACHE_DIR))')\n_p('endif')\n_p('')\nend\nfunction swift.generate_config(prj, cfg, tool)\n_p('ifeq ($(config),%s)', _MAKE.esc(cfg.shortname))\n_p(1, \"OUT_DIR = %s\", cfg.buildtarget.directory)\n  _p(1, \"MODULECACHE_DIR = $(OUT_DIR)/ModuleCache\")\n_p(1, \"TARGET = $(OUT_DIR)/%s\", _MAKE.esc(cfg.buildtarget.name))\nlocal objdir = path.join(cfg.objectsdir, prj.name .. \".build\")\n_p(1, \"OBJDIR = %s\", objdir)\n_p(1, \"MODULE_NAME = %s\", prj.name)\n_p(1, \"MODULE_MAPS = %s\", make.list(tool.getmodulemaps(cfg)))\n_p(1, \"SWIFTC_FLAGS"
	" = %s\", make.list(tool.getswiftcflags(cfg)))\n_p(1, \"SWIFTLINK_FLAGS = %s\", make.list(tool.getswiftlinkflags(cfg)))\n_p(1, \"AR_FLAGS = %s\", make.list(tool.getarchiveflags(cfg, cfg, false)))\n_p(1, \"LD_FLAGS = %s\", make.list(tool.getldflags(cfg)))\n_p(1, \"LDDEPS = %s\", make.list(premake.getlinks(cfg, \"siblings\", \"fullpath\")))\nif cfg.flags.Symbols then\n_p(1, \"SYMBOLS = $(TARGET).dSYM\")\nend\nlocal sdk = tool.get_sdk_path(cfg)\nif sdk then\n_p(1, \"TOOLCHAIN_PATH = %s\", tool.get_toolchain_path(cfg))\n_p(1, \"SDK_PATH = %s\", sdk)\n_p(1, \"PLATFORM_PATH = %s\", tool.get_sdk_platform_path(cfg))\n_p(1, \"SDK = -sdk $(SDK_PATH)\")\nelse\n_p(1, \"SDK_PATH =\")\n_p(1, \"SDK =\")\nend\n_p(1,'WORK_DIRS = $(OUT_DIR) $(OBJDIR)')\n_p('endif')\n_p('')\nend\n",

	/* actions/vstudio/_vstudio.lua */
	"premake.vstudio = { }\nlocal toolsets = {\nvs2010 = \"v100\",\nvs2012 = \"v110\",\nvs2013 = \"v120\",\nvs2015 = \"v140\",\nvs2017 = \"v141\",\nvs2019 = \"v142\",\nvs2022 = \"v143\",\n}\npremake.vstudio.toolset = toolsets[_ACTION] or \"unknown?\"\npremake.vstudio.splashpath = ''\npremake.vstudio.xpwarning = true\nlocal vstudio = premake.vstudio\nvstudio.platforms = {\nany           = \"Any CPU\",\nmixed         = \"Mixed Platforms\",\nNative        = \"Win32\",\nx86           = \"x86\",\nx32           = \"Win32\",\nx64           = \"x64\",\nPS3           = \"PS3\",\nXbox360       = \"Xbox 360\",\nARM           = \"ARM\",\nARM64         = \"ARM64\",\nOrbis         = \"ORBIS\",\nDurango       = \"Durango\",\nTegraAndroid  = \"Tegra-Android\",\nNX32          = \"NX32\",\nNX64          = \"NX64\",\nEmscripten    = \"Emscripten\",\n[\"gdk-desktop\"]  = \"Gaming.Desktop.x64\",\n[\"gdk-xboxone\"]  = \"Gaming.Xbox.XboxOne.x64\",\n[\"gdk-scarlett\"] = \"Gaming.Xbox.Scarlett.x64\",\n}\nfunction vstudio.arch(prj)\nif (prj"
	".language == \"C#\") then\nreturn \"Any CPU\"\nelse\nreturn \"Win32\"\nend\nend\nfunction vstudio.iswinrt()\nreturn vstudio.storeapp ~= nil and vstudio.storeapp ~= ''\nend\nfunction vstudio.isgdkconsole(cfg)\nfor _,p in pairs({\"gdk-xboxone\", \"gdk-scarlett\"}) do\nif cfg.platform == p then\nreturn true\nend\nend\nreturn false\nend\nfunction vstudio.isgdkdesktop(cfg)\nreturn cfg.platform == \"gdk-desktop\"\nend\nfunction vstudio.isgdk(cfg)\nreturn vstudio.isgdkconsole(cfg) or vstudio.isgdkdesktop(cfg)\nend\n        \nfunction vstudio.buildconfigs(sln)\nlocal cfgs = { }\nlocal platforms = premake.filterplatforms(sln, vstudio.platforms, \"Native\")\nlocal hascpp    = premake.hascppproject(sln)\nlocal hasdotnet = premake.hasdotnetproject(sln)\nif hasdotnet and (_ACTION > \"vs2008\" or hascpp) then\ntable.insert(platforms, 1, \"mixed\")\nend\nif hasdotnet and (_ACTION < \"vs2010\" or not hascpp) then\ntable.insert(platforms, 1, \"any\")\nend\nif _ACTION > \"vs2008\" then\nlocal platforms2010 = { }\nfor _, platfor"
	"m in ipairs(platforms) do\nif vstudio.platforms[platform] == \"Win32\" then\nif hascpp then\ntable.insert(platforms2010, platform)\nend\nif hasdotnet then\ntable.insert(platforms2010, \"x86\")\nend\nelse\ntable.insert(platforms2010, platform)\nend\nend\nplatforms = platforms2010\nend\nfor _, buildcfg in ipairs(sln.configurations) do\nfor _, platform in ipairs(platforms) do\nlocal entry = { }\nentry.src_buildcfg = buildcfg\nentry.src_platform = platform\nif platform ~= \"PS3\" or _ACTION > \"vs2008\" then\nentry.buildcfg = buildcfg\nentry.platform = vstudio.platforms[platform]\nelse\nentry.buildcfg = platform .. \" \" .. buildcfg\nentry.platform = \"Win32\"\nend\nentry.name = entry.buildcfg .. \"|\" .. entry.platform\nentry.isreal = (platform ~= \"any\" and platform ~= \"mixed\")\ntable.insert(cfgs, entry)\nend\nend\nreturn cfgs\nend\nfunction premake.vstudio.bakeimports(sln)\nfor _,iprj in ipairs(sln.importedprojects) do\nif string.find(iprj.location, \".csproj\") ~= nil then\niprj.language = \"C#\"\nelse\nipr"
	"j.language = \"C++\"\nend\nlocal f, err = io.open(iprj.location, \"r\")\nif (not f) then\nerror(err, 1)\nend\nlocal projcontents = f:read(\"*all\")\nf:close()\nlocal found, _, uuid = string.find(projcontents, \"<ProjectGuid>{([%w%-]+)}</ProjectGuid>\")\nif not found then\nerror(\"Could not find ProjectGuid element in project \" .. iprj.location, 1)\nend\niprj.uuid = uuid\nif iprj.language == \"C++\" and string.find(projcontents, \"<CLRSupport>true</CLRSupport>\") then\niprj.flags.Managed = true\nend\niprj.relpath = path.getrelative(sln.location, iprj.location)\nend\nend\nfunction premake.vstudio.getimportprj(prjpath, sln)\nfor _,iprj in ipairs(sln.importedprojects) do\nif prjpath == iprj.relpath then\nreturn iprj\nend\nend\nerror(\"Could not find reference import project \" .. prjpath, 1)\nend\nfunction vstudio.cleansolution(sln)\npremake.clean.file(sln, \"%%.sln\")\npremake.clean.file(sln, \"%%.suo\")\npremake.clean.file(sln, \"%%.ncb\")\npremake.clean.file(sln, \"%%.userprefs\")\npremake.clean.file(sln, \"%%"
	".usertasks\")\nend\nfunction vstudio.cleanproject(prj)\nlocal fname = premake.project.getfilename(prj, \"%%\")\nos.remove(fname .. \".vcproj\")\nos.remove(fname .. \".vcproj.user\")\nos.remove(fname .. \".vcxproj\")\nos.remove(fname .. \".vcxproj.user\")\nos.remove(fname .. \".vcxproj.filters\")\nos.remove(fname .. \".csproj\")\nos.remove(fname .. \".csproj.user\")\nos.remove(fname .. \".pidb\")\nos.remove(fname .. \".sdf\")\nend\nfunction vstudio.cleantarget(name)\nos.remove(name .. \".pdb\")\nos.remove(name .. \".idb\")\nos.remove(name .. \".ilk\")\nos.remove(name .. \".vshost.exe\")\nos.remove(name .. \".exe.manifest\")\nend\nfunction vstudio.projectfile(prj)\nlocal pattern\nif prj.language == \"C#\" then\npattern = \"%%.csproj\"\nelse\npattern = iif(_ACTION > \"vs2008\", \"%%.vcxproj\", \"%%.vcproj\")\nend\nlocal fname = premake.project.getbasename(prj.name, pattern)\nfname = path.join(prj.location, fname)\nreturn fname\nend\nfunction vstudio.tool(prj)\nif (prj.language == \"C#\") then\nreturn \"FAE04EC0-3"
	"01F-11D3-BF4B-00C04F79EFBC\"\nelse\nreturn \"8BC9CEB8-8B4A-11D0-8D11-00A0C91BC942\"\nend\nend\n",

	/* actions/vstudio/vstudio_solution.lua */
	"premake.vstudio.sln2005 = { }\nlocal vstudio = premake.vstudio\nlocal sln2005 = premake.vstudio.sln2005\nfunction sln2005.generate(sln)\nio.eol = '\\r\\n'\nsln.vstudio_configs = premake.vstudio.buildconfigs(sln)\npremake.vstudio.bakeimports(sln)\n_p('\\239\\187\\191')\nsln2005.reorderProjects(sln)\nsln2005.header(sln)\nfor grp in premake.solution.eachgroup(sln) do\nsln2005.group(grp)\nend\nfor prj in premake.solution.eachproject(sln) do\nsln2005.project(prj)\nend\n        \nfor _,iprj in ipairs(sln.importedprojects) do\nsln2005.importproject(iprj)\nend\n_p('Global')\nsln2005.platforms(sln)\nsln2005.project_platforms(sln)\nsln2005.properties(sln)\nsln2005.project_groups(sln)\n_p('EndGlobal')\nend\nfunction sln2005.reorderProjects(sln)\nif sln.startproject then\nfor i, prj in ipairs(sln.projects) do\nif sln.startproject == prj.name then\nlocal cur = prj.group\nwhile cur ~= nil do\nfor j, group in ipairs(sln.groups) do\nif group == cur then\ntable.remove(sln.groups, j)\nbreak\nend\nend\ntable.insert(sln.groups, 1"
	", cur)\ncur = cur.parent\nend\ntable.remove(sln.projects, i)\ntable.insert(sln.projects, 1, prj)\nbreak\nend\nend\nend\nend\nfunction sln2005.header(sln)\nlocal action = premake.action.current()\n_p('Microsoft Visual Studio Solution File, Format Version %d.00', action.vstudio.solutionVersion)\nif(_ACTION:sub(3) == \"2015\" or  _ACTION:sub(3) == \"2017\") then\n_p('# Visual Studio %s', action.vstudio.toolsVersion:sub(1,2))\nelseif(_ACTION:sub(3) == \"2019\") then\n_p('# Visual Studio Version %s', action.vstudio.toolsVersion:sub(1,2))\nelse\n_p('# Visual Studio %s', _ACTION:sub(3))\nend\nend\nfunction sln2005.project(prj)\nlocal projpath = path.translate(path.getrelative(prj.solution.location, vstudio.projectfile(prj)), \"\\\\\")\n_p('Project(\"{%s}\") = \"%s\", \"%s\", \"{%s}\"', vstudio.tool(prj), prj.name, projpath, prj.uuid)\nsln2005.projectdependencies(prj)\n_p('EndProject')\nend\nfunction sln2005.group(grp)\n_p('Project(\"{2150E333-8FDC-42A3-9474-1A3956D46DE8}\") = \"%s\", \"%s\", \"{%s}\"', grp.name, grp."
	"name, grp.uuid)\n_p('EndProject')\nend\n    \nfunction sln2005.importproject(iprj)\n_p('Project(\"{%s}\") = \"%s\", \"%s\", \"{%s}\"', vstudio.tool(iprj), path.getbasename(iprj.location), iprj.relpath, iprj.uuid)\n_p('EndProject')\nend\nfunction sln2005.projectdependencies(prj)\nlocal deps = premake.getdependencies(prj)\nif #deps > 0 then\nlocal function compareuuid(a, b) return a.uuid < b.uuid end\ntable.sort(deps, compareuuid)\n_p('\\tProjectSection(ProjectDependencies) = postProject')\nfor _, dep in ipairs(deps) do\n_p('\\t\\t{%s} = {%s}', dep.uuid, dep.uuid)\nend\n_p('\\tEndProjectSection')\nend\nend\nfunction sln2005.platforms(sln)\n_p('\\tGlobalSection(SolutionConfigurationPlatforms) = preSolution')\nfor _, cfg in ipairs(sln.vstudio_configs) do\n_p('\\t\\t%s = %s', cfg.name, cfg.name)\nend\n_p('\\tEndGlobalSection')\nend\nfunction sln2005.project_platform(prj, sln)\nfor _, cfg in ipairs(sln.vstudio_configs) do\nlocal mapped\nlocal buildfor\nif premake.isdotnetproject(prj) then\nbuildfor = \"x64\"\nmapped"
	" = \"Any CPU\"\nelseif prj.flags and prj.flags.Managed then\nmapped = \"x64\"\nelse\nif cfg.platform == \"Any CPU\" or cfg.platform == \"Mixed Platforms\" then\nmapped = sln.vstudio_configs[3].platform\nelse\nmapped = cfg.platform\nend\nend\nlocal build_project = true\nif prj.solution ~= nil then\n    build_project = premake.getconfig(prj, cfg.src_buildcfg, cfg.src_platform).build\nend\n_p('\\t\\t{%s}.%s.ActiveCfg = %s|%s', prj.uuid, cfg.name, cfg.buildcfg, mapped)\nif build_project then\n    if mapped == cfg.platform or cfg.platform == \"Mixed Platforms\" or buildfor == cfg.platform then\n    _p('\\t\\t{%s}.%s.Build.0 = %s|%s',  prj.uuid, cfg.name, cfg.buildcfg, mapped)\n    end\n    if premake.vstudio.iswinrt() and prj.kind == \"WindowedApp\" then\n       _p('\\t\\t{%s}.%s.Deploy.0 = %s|%s',  prj.uuid, cfg.name, cfg.buildcfg, mapped)\n    end\n    if premake.vstudio.isgdk(cfg) and prj.kind == \"WindowedApp\" then\n    _p('\\t\\t{%s}.%s.Deploy.0 = %s|%s',  prj.uuid, cfg.name, cfg.buildcfg, mapped)\n    end\ne"
	"nd\nend\nend\nfunction sln2005.project_platforms(sln)\n_p('\\tGlobalSection(ProjectConfigurationPlatforms) = postSolution')\nfor prj in premake.solution.eachproject(sln) do\nsln2005.project_platform(prj, sln)\nend\nfor _,iprj in ipairs(sln.importedprojects) do\nsln2005.project_platform(iprj, sln)\nend\n_p('\\tEndGlobalSection')\nend\nfunction sln2005.properties(sln)\n_p('\\tGlobalSection(SolutionProperties) = preSolution')\n_p('\\t\\tHideSolutionNode = FALSE')\n_p('\\tEndGlobalSection')\nend\nfunction sln2005.project_groups(sln)\n_p('\\tGlobalSection(NestedProjects) = preSolution')\nfor grp in premake.solution.eachgroup(sln) do\nif grp.parent ~= nil then\n_p('\\t\\t{%s} = {%s}', grp.uuid, grp.parent.uuid)\nend\nend\nfor prj in premake.solution.eachproject(sln) do\nif prj.group ~= nil then\n_p('\\t\\t{%s} = {%s}', prj.uuid, prj.group.uuid)\nend\nend\nfor _,iprj in ipairs(sln.importedprojects) do\nif iprj.group ~= nil then\n_p('\\t\\t{%s} = {%s}', iprj.uuid, iprj.group.uuid)\nend\nend\n        \n_p('\\tEndGlobal"
	"Section')\nend\n",

	/* actions/vstudio/vstudio_vcxproj.lua */
	"premake.vstudio.vc2010 = { }\nlocal vc2010 = premake.vstudio.vc2010\nlocal vstudio = premake.vstudio\nlocal function vs2010_config(prj)\nfor _, cfginfo in ipairs(prj.solution.vstudio_configs) do\nif cfginfo.src_platform == \"TegraAndroid\" then\n_p(1,'<PropertyGroup Label=\"NsightTegraProject\">')\n_p(2,'<NsightTegraProjectRevisionNumber>11</NsightTegraProjectRevisionNumber>')\n_p(1,'</PropertyGroup>')\nbreak\nend\nend\n_p(1,'<ItemGroup Label=\"ProjectConfigurations\">')\nfor _, cfginfo in ipairs(prj.solution.vstudio_configs) do\n_p(2,'<ProjectConfiguration Include=\"%s\">', premake.esc(cfginfo.name))\n_p(3,'<Configuration>%s</Configuration>',cfginfo.buildcfg)\n_p(3,'<Platform>%s</Platform>',cfginfo.platform)\n_p(2,'</ProjectConfiguration>')\nend\n_p(1,'</ItemGroup>')\nend\nlocal function vs2010_globals(prj)\nlocal action = premake.action.current()\n_p(1,'<PropertyGroup Label=\"Globals\">')\n_p(2, '<ProjectGuid>{%s}</ProjectGuid>',prj.uuid)\n_p(2, '<RootNamespace>%s</RootNamespace>',prj.name)\nif vstudio.store"
	"app ~= \"durango\" then\nlocal windowsTargetPlatformVersion = prj.windowstargetplatformversion or action.vstudio.windowsTargetPlatformVersion\nif windowsTargetPlatformVersion ~= nil then\n_p(2,'<WindowsTargetPlatformVersion>%s</WindowsTargetPlatformVersion>',windowsTargetPlatformVersion)\nif windowsTargetPlatformVersion and string.startswith(windowsTargetPlatformVersion, \"10.\") then\n_p(2,'<WindowsTargetPlatformMinVersion>%s</WindowsTargetPlatformMinVersion>', prj.windowstargetplatformminversion or \"10.0.10240.0\")\nend\nend\nend\nif prj.flags and prj.flags.Managed then\nlocal frameworkVersion = prj.framework or \"4.0\"\n_p(2, '<TargetFrameworkVersion>v%s</TargetFrameworkVersion>', frameworkVersion)\n_p(2, '<Keyword>ManagedCProj</Keyword>')\nelseif vstudio.iswinrt() then\n_p(2, '<DefaultLanguage>en-US</DefaultLanguage>')\nif vstudio.storeapp == \"durango\" then\n_p(2, '<Keyword>Win32Proj</Keyword>')\n_p(2, '<ApplicationEnvironment>title</ApplicationEnvironment>')\n_p(2, '<MinimumVisualStudioVersion>14.0</Mi"
	"nimumVisualStudioVersion>')\n_p(2, '<TargetRuntime>Native</TargetRuntime>')\nelse\n_p(2, '<AppContainerApplication>true</AppContainerApplication>')\n_p(2, '<MinimumVisualStudioVersion>12.0</MinimumVisualStudioVersion>')\n_p(2, '<ApplicationType>Windows Store</ApplicationType>')\n_p(2, '<ApplicationTypeRevision>%s</ApplicationTypeRevision>', vstudio.storeapp)\nend\nelse\n_p(2, '<Keyword>Win32Proj</Keyword>')\nend\nif not vstudio.xpwarning then\n_p(2, '<XPDeprecationWarning>false</XPDeprecationWarning>')\nend\n_p(1,'</PropertyGroup>')\nend\nfunction vc2010.config_type(config)\nlocal t =\n{\nSharedLib = \"DynamicLibrary\",\nStaticLib = \"StaticLibrary\",\nConsoleApp = \"Application\",\nWindowedApp = \"Application\"\n}\nreturn t[config.kind]\nend\nlocal function if_config_and_platform()\nreturn 'Condition=\"\\'$(Configuration)|$(Platform)\\'==\\'%s\\'\"'\nend\nlocal function optimisation(cfg)\nlocal result = \"Disabled\"\nfor _, value in ipairs(cfg.flags) do\nif (value == \"Optimize\") then\nresult = \"Full\"\nels"
	"eif (value == \"OptimizeSize\") then\nresult = \"MinSpace\"\nelseif (value == \"OptimizeSpeed\") then\nresult = \"MaxSpeed\"\nend\nend\nreturn result\nend\nfunction vc2010.configurationPropertyGroup(cfg, cfginfo)\n_p(1, '<PropertyGroup '..if_config_and_platform() ..' Label=\"Configuration\">'\n, premake.esc(cfginfo.name))\nlocal is2019 = premake.action.current() == premake.action.get(\"vs2019\")\nlocal is2022 = premake.action.current() == premake.action.get(\"vs2022\")\nif is2019 or is2022 then\n    _p(2, '<VCProjectVersion>%s</VCProjectVersion>', action.vstudio.toolsVersion)\nif cfg.flags.UnitySupport then\n    _p(2, '<EnableUnitySupport>true</EnableUnitySupport>')\nend\nend\n_p(2, '<ConfigurationType>%s</ConfigurationType>', vc2010.config_type(cfg))\n_p(2, '<UseDebugLibraries>%s</UseDebugLibraries>', iif(optimisation(cfg) == \"Disabled\",\"true\",\"false\"))\n_p(2, '<PlatformToolset>%s</PlatformToolset>',     premake.vstudio.toolset)\nif os.is64bit() then\n_p(2, '<PreferredToolArchitecture>x64</PreferredTool"
	"Architecture>')\nend\nif cfg.flags.Unicode then\n_p(2,'<CharacterSet>Unicode</CharacterSet>')\nend\nif cfg.flags.Managed then\n_p(2,'<CLRSupport>true</CLRSupport>')\nend\nif cfg.platform == \"TegraAndroid\" then\nif cfg.androidtargetapi then\n_p(2,'<AndroidTargetAPI>android-%s</AndroidTargetAPI>', cfg.androidtargetapi)\nend\nif cfg.androidminapi then\n_p(2,'<AndroidMinAPI>android-%s</AndroidMinAPI>', cfg.androidminapi)\nend\nif cfg.androidarch then\n_p(2,'<AndroidArch>%s</AndroidArch>', cfg.androidarch)\nend\nif cfg.androidndktoolchainversion then\n_p(2,'<NdkToolchainVersion>%s</NdkToolchainVersion>', cfg.androidndktoolchainversion)\nend\nif cfg.androidstltype then\n_p(2,'<AndroidStlType>%s</AndroidStlType>', cfg.androidstltype)\nend\nend\nif cfg.platform == \"NX32\" or cfg.platform == \"NX64\" then\n_p(2,'<NintendoSdkRoot>$(NINTENDO_SDK_ROOT)\\\\</NintendoSdkRoot>')\n_p(2,'<NintendoSdkSpec>NX</NintendoSdkSpec>')\nif premake.config.isdebugbuild(cfg) then\n_p(2,'<NintendoSdkBuildType>Debug</NintendoSdkBuildType"
	">')\nelse\n_p(2,'<NintendoSdkBuildType>Release</NintendoSdkBuildType>')\nend\nend\nif cfg.flags.Symbols and (premake.action.current() == premake.action.get(\"vs2017\") or is2019) then\n_p(2, '<DebugSymbols>true</DebugSymbols>')\nend\n_p(1,'</PropertyGroup>')\nend\nlocal function import_props(prj)\nfor _, cfginfo in ipairs(prj.solution.vstudio_configs) do\nlocal cfg = premake.getconfig(prj, cfginfo.src_buildcfg, cfginfo.src_platform)\n_p(1,'<ImportGroup '..if_config_and_platform() ..' Label=\"PropertySheets\">'\n,premake.esc(cfginfo.name))\n_p(2,'<Import Project=\"$(UserRootDir)\\\\Microsoft.Cpp.$(Platform).user.props\" Condition=\"exists(\\'$(UserRootDir)\\\\Microsoft.Cpp.$(Platform).user.props\\')\" Label=\"LocalAppDataPlatform\" />')\nif #cfg.propertysheets > 0 then\nlocal dirs = cfg.propertysheets\nfor _, dir in ipairs(dirs) do\nlocal translated = path.translate(dir)\n_p(2,'<Import Project=\"%s\" Condition=\"exists(\\'%s\\')\" />', translated, translated)\nend\nend\n_p(1,'</ImportGroup>')\nend\nend\nlocal f"
	"unction add_trailing_backslash(dir)\nif dir:len() > 0 and dir:sub(-1) ~= \"\\\\\" then\nreturn dir..\"\\\\\"\nend\nreturn dir\nend\nfunction vc2010.outputProperties(prj)\nfor _, cfginfo in ipairs(prj.solution.vstudio_configs) do\nlocal cfg = premake.getconfig(prj, cfginfo.src_buildcfg, cfginfo.src_platform)\nlocal target = cfg.buildtarget\nlocal outdir = add_trailing_backslash(target.directory)\nlocal intdir = add_trailing_backslash(iif(action.vstudio.intDirAbsolute\n, path.translate(\n  path.join(prj.solution.location, cfg.objectsdir)\n, '\\\\')\n, cfg.objectsdir\n))\n_p(1,'<PropertyGroup '..if_config_and_platform() ..'>', premake.esc(cfginfo.name))\n_p(2,'<OutDir>%s</OutDir>', iif(outdir:len() > 0, premake.esc(outdir), \".\\\\\"))\nif cfg.platform == \"Xbox360\" then\n_p(2,'<OutputFile>$(OutDir)%s</OutputFile>', premake.esc(target.name))\nend\n_p(2,'<IntDir>%s</IntDir>', premake.esc(intdir))\n_p(2,'<TargetName>%s</TargetName>', premake.esc(path.getbasename(target.name)))\n_p(2,'<TargetExt>%s</TargetExt>', pr"
	"emake.esc(path.getextension(target.name)))\nif cfg.kind == \"SharedLib\" then\nlocal ignore = (cfg.flags.NoImportLib ~= nil)\n_p(2,'<IgnoreImportLibrary>%s</IgnoreImportLibrary>', tostring(ignore))\nend\nif cfg.platform == \"NX32\" or cfg.platform == \"NX64\" then\nif cfg.flags.Cpp17 then\n_p(2,'<CppLanguageStandard>Gnu++17</CppLanguageStandard>')\nelseif cfg.flags.Cpp20 then\n_p(2,'<CppLanguageStandard>Gnu++20</CppLanguageStandard>')\nend\nend\nif cfg.platform == \"Durango\" then\n_p(2, '<ReferencePath>$(Console_SdkLibPath);$(Console_SdkWindowsMetadataPath)</ReferencePath>')\n_p(2, '<LibraryPath>$(Console_SdkLibPath)</LibraryPath>')\n_p(2, '<LibraryWPath>$(Console_SdkLibPath);$(Console_SdkWindowsMetadataPath)</LibraryWPath>')\n_p(2, '<IncludePath>$(Console_SdkIncludeRoot)</IncludePath>')\n_p(2, '<ExecutablePath>$(Console_SdkRoot)bin;$(VCInstallDir)bin\\\\x86_amd64;$(VCInstallDir)bin;$(WindowsSDK_ExecutablePath_x86);$(VSInstallDir)Common7\\\\Tools\\\\bin;$(VSInstallDir)Common7\\\\tools;$(VSInstallDir)Common7"
	"\\\\ide;$(ProgramFiles)\\\\HTML Help Workshop;$(MSBuildToolsPath32);$(FxCopDir);$(PATH);</ExecutablePath>')\nif cfg.imagepath then\n_p(2, '<LayoutDir>%s</LayoutDir>', cfg.imagepath)\nelse\n_p(2, '<LayoutDir>%s</LayoutDir>', prj.name)\nend\nif cfg.pullmappingfile ~= nil then\n_p(2,'<PullMappingFile>%s</PullMappingFile>', premake.esc(cfg.pullmappingfile))\nend\n_p(2, '<LayoutExtensionFilter>*.pdb;*.ilk;*.exp;*.lib;*.winmd;*.appxrecipe;*.pri;*.idb</LayoutExtensionFilter>')\n_p(2, '<IsolateConfigurationsOnDeploy>true</IsolateConfigurationsOnDeploy>')\nend\nif vstudio.isgdkconsole(cfg) then\n_p(2, '<ExecutablePath>$(Console_SdkRoot)bin;$(Console_SdkToolPath);$(ExecutablePath)</ExecutablePath>')\n_p(2, '<IncludePath>$(Console_SdkIncludeRoot)</IncludePath>')\n_p(2, '<ReferencePath>$(Console_SdkLibPath);$(Console_SdkWindowsMetadataPath)</ReferencePath>')\n_p(2, '<LibraryPath>$(Console_SdkLibPath)</LibraryPath>')\n_p(2, '<LibraryWPath>$(Console_SdkLibPath);$(Console_SdkWindowsMetadataPath)</LibraryWPath>')\nend\nif vst"
	"udio.isgdkdesktop(cfg) then\n_p(2, '<IncludePath>$(Console_SdkIncludeRoot);$(IncludePath)</IncludePath>')\n_p(2, '<LibraryPath>$(Console_SdkLibPath);$(LibraryPath)</LibraryPath>')\nend\nif cfg.kind ~= \"StaticLib\" then\n_p(2,'<LinkIncremental>%s</LinkIncremental>', tostring(premake.config.isincrementallink(cfg)))\nend\nif cfg.applicationdatadir ~= nil then\n_p(2,'<ApplicationDataDir>%s</ApplicationDataDir>', premake.esc(cfg.applicationdatadir))\nend\nif cfg.flags.NoManifest then\n_p(2,'<GenerateManifest>false</GenerateManifest>')\nend\n_p(1,'</PropertyGroup>')\nend\nend\nlocal function runtime(cfg)\nlocal runtime\nlocal flags = cfg.flags\nif premake.config.isdebugbuild(cfg) then\nruntime = iif(flags.StaticRuntime and not flags.Managed, \"MultiThreadedDebug\", \"MultiThreadedDebugDLL\")\nelse\nruntime = iif(flags.StaticRuntime and not flags.Managed, \"MultiThreaded\", \"MultiThreadedDLL\")\nend\nreturn runtime\nend\nlocal function precompiled_header(cfg)\n      if not cfg.flags.NoPCH and cfg.pchheader then\n_p"
	"(3,'<PrecompiledHeader>Use</PrecompiledHeader>')\n_p(3,'<PrecompiledHeaderFile>%s</PrecompiledHeaderFile>', cfg.pchheader)\nelse\n_p(3,'<PrecompiledHeader></PrecompiledHeader>')\nend\nend\nlocal function preprocessor(indent,cfg,escape)\nif #cfg.defines > 0 then\nlocal defines = table.concat(cfg.defines, \";\")\nif escape then\ndefines = defines:gsub('\"', '\\\\\"')\nend\nlocal isPreprocessorDefinitionPresent = string.find(defines, \"%%%(PreprocessorDefinitions%)\")\nif isPreprocessorDefinitionPresent then\n_p(indent,'<PreprocessorDefinitions>%s</PreprocessorDefinitions>'\n,premake.esc(defines))\nelse\n_p(indent,'<PreprocessorDefinitions>%s;%%(PreprocessorDefinitions)</PreprocessorDefinitions>'\n,premake.esc(defines))\nend\nelse\n_p(indent,'<PreprocessorDefinitions></PreprocessorDefinitions>')\nend\nend\nlocal function include_dirs(indent,cfg)\nlocal includedirs = table.join(cfg.userincludedirs, cfg.includedirs, cfg.systemincludedirs)\nif #includedirs> 0 then\n_p(indent,'<AdditionalIncludeDirectories>%s;%%(Addi"
	"tionalIncludeDirectories)</AdditionalIncludeDirectories>'\n,premake.esc(path.translate(table.concat(includedirs, \";\"), '\\\\')))\nend\nend\nlocal function using_dirs(indent,cfg)\nif #cfg.usingdirs > 0 then\n_p(indent,'<AdditionalUsingDirectories>%s;%%(AdditionalUsingDirectories)</AdditionalUsingDirectories>'\n,premake.esc(path.translate(table.concat(cfg.usingdirs, \";\"), '\\\\')))\nend\nend\nlocal function resource_compile(cfg)\n_p(2,'<ResourceCompile>')\npreprocessor(3,cfg,true)\ninclude_dirs(3,cfg)\n_p(2,'</ResourceCompile>')\nend\nlocal function cppstandard(cfg)\nif cfg.flags.CppLatest then\n_p(3, '<LanguageStandard>stdcpplatest</LanguageStandard>')\n_p(3, '<EnableModules>true</EnableModules>')\nelseif cfg.flags.Cpp20 then\n_p(3, '<LanguageStandard>stdcpp20</LanguageStandard>')\nelseif cfg.flags.Cpp17 then\n_p(3, '<LanguageStandard>stdcpp17</LanguageStandard>')\nelseif cfg.flags.Cpp14 then\n_p(3, '<LanguageStandard>stdcpp14</LanguageStandard>')\nend\nend\nlocal function exceptions(cfg)\nif cfg.platform ="
	"= \"Orbis\" then\nif cfg.flags.NoExceptions then\n_p(3, '<CppExceptions>false</CppExceptions>')\nend\nelseif cfg.platform == \"TegraAndroid\" then\nif cfg.flags.NoExceptions then\n_p(3, '<GccExceptionHandling>false</GccExceptionHandling>')\nend\nelseif cfg.platform == \"NX32\" or cfg.platform == \"NX64\" then\nif cfg.flags.NoExceptions then\n_p(3, '<CppExceptions>false</CppExceptions>')\nelse\n_p(3, '<CppExceptions>true</CppExceptions>')\nend\nelse\nif cfg.flags.NoExceptions then\n_p(3, '<ExceptionHandling>false</ExceptionHandling>')\nelseif cfg.flags.SEH then\n_p(3, '<ExceptionHandling>Async</ExceptionHandling>')\nend\nend\nend\nlocal function rtti(cfg)\nif cfg.flags.NoRTTI and not cfg.flags.Managed then\n_p(3,'<RuntimeTypeInfo>false</RuntimeTypeInfo>')\nend\nend\nlocal function calling_convention(cfg)\nif cfg.flags.FastCall then\n_p(3,'<CallingConvention>FastCall</CallingConvention>')\nelseif cfg.flags.StdCall then\n_p(3,'<CallingConvention>StdCall</CallingConvention>')\nend\nend\nlocal function wchar_t_buil"
	"tin(cfg)\nif cfg.flags.NativeWChar then\n_p(3,'<TreatWChar_tAsBuiltInType>true</TreatWChar_tAsBuiltInType>')\nelseif cfg.flags.NoNativeWChar then\n_p(3,'<TreatWChar_tAsBuiltInType>false</TreatWChar_tAsBuiltInType>')\nend\nend\nlocal function sse(cfg)\nif cfg.flags.EnableSSE then\n_p(3, '<EnableEnhancedInstructionSet>StreamingSIMDExtensions</EnableEnhancedInstructionSet>')\nelseif cfg.flags.EnableSSE2 then\n_p(3, '<EnableEnhancedInstructionSet>StreamingSIMDExtensions2</EnableEnhancedInstructionSet>')\nelseif cfg.flags.EnableAVX then\n_p(3, '<EnableEnhancedInstructionSet>AdvancedVectorExtensions</EnableEnhancedInstructionSet>')\nelseif cfg.flags.EnableAVX2 then\n_p(3, '<EnableEnhancedInstructionSet>AdvancedVectorExtensions2</EnableEnhancedInstructionSet>')\nend\nend\nlocal function floating_point(cfg)\nif cfg.platform == \"Orbis\" then\nif cfg.flags.FloatFast then\n_p(3,'<FastMath>true</FastMath>')\nend\nelseif cfg.platform == \"TegraAndroid\" then\nelseif cfg.platform == \"NX32\" or cfg.platform == \"NX64\" the"
	"n\nif cfg.flags.FloatFast then\n_p(3, '<FastMath>true</FastMath>')\nend\nelse\nif cfg.flags.FloatFast then\n_p(3,'<FloatingPointModel>Fast</FloatingPointModel>')\nelseif cfg.flags.FloatStrict and not cfg.flags.Managed then\n_p(3,'<FloatingPointModel>Strict</FloatingPointModel>')\nend\nend\nend\nlocal function debug_info(cfg)\nlocal debug_info = ''\nif cfg.flags.Symbols then\nif cfg.flags.C7DebugInfo then\ndebug_info = \"OldStyle\"\nelseif (action.vstudio.supports64bitEditContinue == false and cfg.platform == \"x64\")\nor not premake.config.iseditandcontinue(cfg)\nthen\ndebug_info = \"ProgramDatabase\"\nelse\ndebug_info = \"EditAndContinue\"\nend\nend\n_p(3,'<DebugInformationFormat>%s</DebugInformationFormat>',debug_info)\nend\nlocal function minimal_build(cfg)\nif premake.config.isdebugbuild(cfg) and cfg.flags.EnableMinimalRebuild then\n_p(3,'<MinimalRebuild>true</MinimalRebuild>')\nelse\n_p(3,'<MinimalRebuild>false</MinimalRebuild>')\nend\nend\nlocal function compile_language(cfg)\nif cfg.options.ForceCPP the"
	"n\n_p(3,'<CompileAs>CompileAsCpp</CompileAs>')\nelse\nif cfg.language == \"C\" then\n_p(3,'<CompileAs>CompileAsC</CompileAs>')\nend\nend\nend\nlocal function forcedinclude_files(indent,cfg)\nif #cfg.forcedincludes > 0 then\n_p(indent,'<ForcedIncludeFiles>%s</ForcedIncludeFiles>'\n,premake.esc(path.translate(table.concat(cfg.forcedincludes, \";\"), '\\\\')))\nend\nend\nlocal function vs10_clcompile(cfg)\n_p(2,'<ClCompile>')\nlocal unsignedChar = \"/J \"\nlocal buildoptions = cfg.buildoptions\nif cfg.platform == \"Orbis\" then\nunsignedChar = \"-funsigned-char \";\n_p(3,'<GenerateDebugInformation>%s</GenerateDebugInformation>', tostring(cfg.flags.Symbols ~= nil))\nend\nif cfg.platform == \"NX32\" or cfg.platform == \"NX64\" then\nunsignedChar = \"-funsigned-char \";\n_p(3,'<GenerateDebugInformation>%s</GenerateDebugInformation>', tostring(cfg.flags.Symbols ~= nil))\nend\nif cfg.language == \"C\" and not cfg.options.ForceCPP then\nbuildoptions = table.join(buildoptions, cfg.buildoptions_c)\nelse\nbuildoptions = t"
	"able.join(buildoptions, cfg.buildoptions_cpp)\nend\n_p(3,'<AdditionalOptions>%s %s%%(AdditionalOptions)</AdditionalOptions>'\n, table.concat(premake.esc(buildoptions), \" \")\n, iif(cfg.flags.UnsignedChar and cfg.platform ~= \"TegraAndroid\", unsignedChar, \" \")\n)\nif cfg.platform == \"TegraAndroid\" then\n_p(3,'<SignedChar>%s</SignedChar>', tostring(cfg.flags.UnsignedChar == nil))\n_p(3,'<GenerateDebugInformation>%s</GenerateDebugInformation>', tostring(cfg.flags.Symbols ~= nil))\nif cfg.androidcppstandard then\n_p(3,'<CppLanguageStandard>%s</CppLanguageStandard>', cfg.androidcppstandard)\nend\nend\nif cfg.platform == \"Orbis\" then\nlocal opt = optimisation(cfg)\nif opt == \"Disabled\" then\n_p(3,'<OptimizationLevel>Level0</OptimizationLevel>')\nelseif opt == \"MinSpace\" then\n_p(3,'<OptimizationLevel>Levelz</OptimizationLevel>') -- Oz is more aggressive than Os\nelseif opt == \"MaxSpeed\" then\n_p(3,'<OptimizationLevel>Level3</OptimizationLevel>')\nelse\n_p(3,'<OptimizationLevel>Level2</OptimizationLevel"
	">')\nend\nelseif cfg.platform == \"TegraAndroid\" then\nlocal opt = optimisation(cfg)\nif opt == \"Disabled\" then\n_p(3,'<OptimizationLevel>O0</OptimizationLevel>')\nelseif opt == \"MinSpace\" then\n_p(3,'<OptimizationLevel>Os</OptimizationLevel>')\nelseif opt == \"MaxSpeed\" then\n_p(3,'<OptimizationLevel>O3</OptimizationLevel>')\nelse\n_p(3,'<OptimizationLevel>O2</OptimizationLevel>')\nend\nelseif cfg.platform == \"NX32\" or cfg.platform == \"NX64\" then\nlocal opt = optimisation(cfg)\nif opt == \"Disabled\" then\n_p(3,'<OptimizationLevel>O0</OptimizationLevel>')\nelseif opt == \"MinSpace\" then\n_p(3,'<OptimizationLevel>Os</OptimizationLevel>')\nelseif opt == \"MaxSpeed\" then\n_p(3,'<OptimizationLevel>O3</OptimizationLevel>')\nelse\n_p(3,'<OptimizationLevel>O2</OptimizationLevel>')\nend\nelse\n_p(3,'<Optimization>%s</Optimization>', optimisation(cfg))\nend\ninclude_dirs(3, cfg)\nusing_dirs(3, cfg)\npreprocessor(3, cfg)\nminimal_build(cfg)\nif premake.config.isoptimizedbuild(cfg.flags) then\nif cfg.flags.N"
	"oOptimizeLink and cfg.flags.NoEditAndContinue then\n_p(3, '<StringPooling>false</StringPooling>')\n_p(3, '<FunctionLevelLinking>false</FunctionLevelLinking>')\nelse\n_p(3, '<StringPooling>true</StringPooling>')\n_p(3, '<FunctionLevelLinking>true</FunctionLevelLinking>')\nend\nelse\n_p(3, '<FunctionLevelLinking>true</FunctionLevelLinking>')\nif cfg.flags.NoRuntimeChecks then\n_p(3, '<BasicRuntimeChecks>Default</BasicRuntimeChecks>')\nelseif not cfg.flags.Managed then\n_p(3, '<BasicRuntimeChecks>EnableFastChecks</BasicRuntimeChecks>')\nend\nif cfg.flags.ExtraWarnings then\nend\nend\nif cfg.platform == \"Durango\" or cfg.flags.NoWinRT then\n_p(3, '<CompileAsWinRT>false</CompileAsWinRT>')\nend\n_p(3, '<RuntimeLibrary>%s</RuntimeLibrary>', runtime(cfg))\nif cfg.flags.NoBufferSecurityCheck then\n_p(3, '<BufferSecurityCheck>false</BufferSecurityCheck>')\nend\nif not cfg.flags.NoMultiProcessorCompilation and not cfg.flags.EnableMinimalRebuild then\n_p(3, '<MultiProcessorCompilation>true</MultiProcessorCompilation>')\n"
	"else\n_p(3, '<MultiProcessorCompilation>false</MultiProcessorCompilation>')\nend\nprecompiled_header(cfg)\nif cfg.platform == \"Orbis\" then\nif cfg.flags.PedanticWarnings then\n_p(3, '<Warnings>MoreWarnings</Warnings>')\n_p(3, '<ExtraWarnings>true</ExtraWarnings>')\nelseif cfg.flags.ExtraWarnings then\n_p(3, '<Warnings>NormalWarnings</Warnings>')\n_p(3, '<ExtraWarnings>true</ExtraWarnings>')\nelseif cfg.flags.MinimumWarnings then\n_p(3, '<Warnings>WarningsOff</Warnings>')\n_p(3, '<ExtraWarnings>false</ExtraWarnings>')\nelse\n_p(3, '<Warnings>NormalWarnings</Warnings>')\n_p(3, '<ExtraWarnings>false</ExtraWarnings>')\nend\nif cfg.flags.FatalWarnings then\n_p(3, '<WarningsAsErrors>true</WarningsAsErrors>')\nend\nelseif cfg.platform == \"TegraAndroid\" then\nif cfg.flags.PedanticWarnings or cfg.flags.ExtraWarnings then\n_p(3, '<Warnings>AllWarnings</Warnings>')\nelseif cfg.flags.MinimumWarnings then\n_p(3, '<Warnings>DisableAllWarnings</Warnings>')\nelse\n_p(3, '<Warnings>NormalWarnings</Warnings>')\nend\nif cfg."
	"flags.FatalWarnings then\n_p(3, '<WarningsAsErrors>true</WarningsAsErrors>')\nend\nelseif cfg.platform == \"NX32\" or cfg.platform == \"NX64\" then\nif cfg.flags.PedanticWarnings then\n_p(3, '<Warnings>MoreWarnings</Warnings>')\n_p(3, '<ExtraWarnings>true</ExtraWarnings>')\nelseif cfg.flags.ExtraWarnings then\n_p(3, '<Warnings>NormalWarnings</Warnings>')\n_p(3, '<ExtraWarnings>true</ExtraWarnings>')\nelseif cfg.flags.MinimumWarnings then\n_p(3, '<Warnings>WarningsOff</Warnings>')\n_p(3, '<ExtraWarnings>false</ExtraWarnings>')\nelse\n_p(3, '<Warnings>NormalWarnings</Warnings>')\n_p(3, '<ExtraWarnings>false</ExtraWarnings>')\nend\nif cfg.flags.FatalWarnings then\n_p(3, '<WarningsAsErrors>true</WarningsAsErrors>')\nend\nelse\nif cfg.flags.PedanticWarnings then\n_p(3, '<WarningLevel>EnableAllWarnings</WarningLevel>')\nelseif cfg.flags.ExtraWarnings then\n_p(3, '<WarningLevel>Level4</WarningLevel>')\nelseif cfg.flags.MinimumWarnings then\n_p(3, '<WarningLevel>Level1</WarningLevel>')\nelse\n_p(3 ,'<WarningLevel>Leve"
	"l3</WarningLevel>')\nend\nend\nif cfg.flags.FatalWarnings then\n_p(3, '<TreatWarningAsError>true</TreatWarningAsError>')\nend\nif premake.action.current() == premake.action.get(\"vs2017\") or\n   premake.action.current() == premake.action.get(\"vs2019\") or\n   premake.action.current() == premake.action.get(\"vs2022\") then\ncppstandard(cfg)\nend\nexceptions(cfg)\nrtti(cfg)\ncalling_convention(cfg)\nwchar_t_builtin(cfg)\nsse(cfg)\nfloating_point(cfg)\ndebug_info(cfg)\nif cfg.flags.Symbols then\nif cfg.kind == \"StaticLib\" then\n_p(3, '<ProgramDataBaseFileName>$(OutDir)%s.pdb</ProgramDataBaseFileName>'\n, path.getbasename(cfg.buildtarget.name)\n)\nelse\n_p(3, '<ProgramDataBaseFileName>$(IntDir)%s.compile.pdb</ProgramDataBaseFileName>'\n, path.getbasename(cfg.buildtarget.name)\n)\nend\nend\nif cfg.flags.Hotpatchable then\n_p(3, '<CreateHotpatchableImage>true</CreateHotpatchableImage>')\nend\nif cfg.flags.NoFramePointer then\n_p(3, '<OmitFramePointers>true</OmitFramePointers>')\nend\nif cfg.flags.UseFullPaths th"
	"en\n_p(3, '<UseFullPaths>true</UseFullPaths>')\nend\nif cfg.flags.NoJMC then\n_p(3,'<SupportJustMyCode>false</SupportJustMyCode>' )\nend\ncompile_language(cfg)\nforcedinclude_files(3,cfg);\nif vstudio.diagformat then\n_p(3, '<DiagnosticsFormat>%s</DiagnosticsFormat>', vstudio.diagformat)\nelse\n_p(3, '<DiagnosticsFormat>Caret</DiagnosticsFormat>')\nend\n_p(2,'</ClCompile>')\nend\nlocal function event_hooks(cfg)\nif #cfg.postbuildcommands> 0 then\n    _p(2,'<PostBuildEvent>')\n_p(3,'<Command>%s</Command>',premake.esc(table.implode(cfg.postbuildcommands, \"\", \"\", \"\\r\\n\")))\n_p(2,'</PostBuildEvent>')\nend\nif #cfg.prebuildcommands> 0 then\n    _p(2,'<PreBuildEvent>')\n_p(3,'<Command>%s</Command>',premake.esc(table.implode(cfg.prebuildcommands, \"\", \"\", \"\\r\\n\")))\n_p(2,'</PreBuildEvent>')\nend\nif #cfg.prelinkcommands> 0 then\n    _p(2,'<PreLinkEvent>')\n_p(3,'<Command>%s</Command>',premake.esc(table.implode(cfg.prelinkcommands, \"\", \"\", \"\\r\\n\")))\n_p(2,'</PreLinkEvent>')\nend\nend\nlocal func"
	"tion additional_options(indent,cfg)\nif #cfg.linkoptions > 0 then\n_p(indent,'<AdditionalOptions>%s %%(AdditionalOptions)</AdditionalOptions>',\ntable.concat(premake.esc(cfg.linkoptions), \" \"))\nend\nend\nlocal function link_target_machine(index,cfg)\nlocal platforms = {x32 = 'MachineX86', x64 = 'MachineX64'}\nif platforms[cfg.platform] then\n_p(index,'<TargetMachine>%s</TargetMachine>', platforms[cfg.platform])\nend\nend\nlocal function item_def_lib(cfg)\nif cfg.kind == 'StaticLib' and cfg.platform ~= \"Xbox360\" then\n_p(1,'<Lib>')\n_p(2,'<OutputFile>$(OutDir)%s</OutputFile>',cfg.buildtarget.name)\nadditional_options(2,cfg)\nlink_target_machine(2,cfg)\n_p(1,'</Lib>')\nend\nend\nlocal function import_lib(cfg)\nif cfg.kind == \"SharedLib\" then\nlocal implibname = cfg.linktarget.fullpath\n_p(3,'<ImportLibrary>%s</ImportLibrary>',iif(cfg.flags.NoImportLib, cfg.objectsdir .. \"\\\\\" .. path.getname(implibname), implibname))\nend\nend\nlocal function hasmasmfiles(prj)\nlocal files = vc2010.getfilegroup(prj, \""
	"MASM\")\nreturn #files > 0\nend\nlocal function ismanagedprj(prj, cfgname, pltname)\nlocal cfg = premake.getconfig(prj, cfgname, pltname)\nreturn cfg.flags.Managed == true\nend\nlocal function getcfglinks(cfg)\nlocal haswholearchive = #cfg.wholearchive > 0\nlocal msvcnaming   = premake.getnamestyle(cfg) == \"windows\"\nlocal iscppprj     = premake.iscppproject(cfg)\nlocal isnetprj     = premake.isdotnetproject(cfg)\nlocal linkobjs     = {}\nlocal links        = iif(haswholearchive\n, premake.getlinks(cfg, \"all\", \"object\")\n, premake.getlinks(cfg, \"system\", \"fullpath\")\n)\nfor _, link in ipairs(links) do\nlocal name      = nil\nlocal directory = nil\nlocal whole     = nil\nif type(link) == \"table\" then\nif not ismanagedprj(link.project, cfg.name, cfg.platform) then\nname      = link.linktarget.basename\ndirectory = path.rebase(link.linktarget.directory, link.location, cfg.location)\nwhole     = table.icontains(cfg.wholearchive, link.project.name)\nend\nelse\nname      = link\nwhole     = table.icontai"
	"ns(cfg.wholearchive, link)\nend\nif name then\nif haswholearchive and msvcnaming then\nif iscppprj then\nname = name .. \".lib\"\nelseif isnetprj then\nname = name .. \".dll\"\nend\nend\ntable.insert(linkobjs, {name=name, directory=directory, wholearchive=whole})\nend\nend\nreturn linkobjs\nend\nlocal function vs10_masm(prj, cfg)\nif hasmasmfiles(prj) then\n_p(2, '<MASM>')\n_p(3,'<AdditionalOptions>%s %%(AdditionalOptions)</AdditionalOptions>'\n, table.concat(premake.esc(table.join(cfg.buildoptions, cfg.buildoptions_asm)), \" \")\n)\nlocal includedirs = table.join(cfg.userincludedirs, cfg.includedirs, cfg.systemincludedirs)\nif #includedirs > 0 then\n_p(3, '<IncludePaths>%s;%%(IncludePaths)</IncludePaths>'\n, premake.esc(path.translate(table.concat(includedirs, \";\"), '\\\\'))\n)\nend\nlocal defines = table.join(cfg.defines)\ntable.insertflat(defines, iif(premake.config.isdebugbuild(cfg), \"_DEBUG\", {}))\ntable.insert(defines, iif(cfg.platform == \"x64\" or cfg.platform == \"ARM64\", \"_WIN64\", \"_WIN32\"))"
	"\ntable.insert(defines, iif(prj.kind == \"SharedLib\", \"_EXPORT=EXPORT\", \"_EXPORT=\"))\n_p(3, '<PreprocessorDefinitions>%s;%%(PreprocessorDefinitions)</PreprocessorDefinitions>'\n, premake.esc(table.concat(defines, \";\"))\n)\nif cfg.flags.FatalWarnings then\n_p(3,'<TreatWarningsAsErrors>true</TreatWarningsAsErrors>')\nend\nif cfg.flags.MinimumWarnings then\n_p(3,'<WarningLevel>0</WarningLevel>')\nelse\n_p(3,'<WarningLevel>3</WarningLevel>')\nend\n_p(2, '</MASM>')\nend\nend\nlocal function additional_manifest(cfg)\nif(cfg.dpiawareness ~= nil) then\n_p(2,'<Manifest>')\nif(cfg.dpiawareness == \"None\") then\n_p(3, '<EnableDpiAwareness>false</EnableDpiAwareness>')\nend\nif(cfg.dpiawareness == \"High\") then\n_p(3, '<EnableDpiAwareness>true</EnableDpiAwareness>')\nend\nif(cfg.dpiawareness == \"HighPerMonitor\") then\n_p(3, '<EnableDpiAwareness>PerMonitorHighDPIAware</EnableDpiAwareness>')\nend\n_p(2,'</Manifest>')\nend\nend\nfunction vc2010.link(cfg)\nlocal vs2017OrLater = premake.action.current() == premake.ac"
	"tion.get(\"vs2017\") or\n    premake.action.current() == premake.action.get(\"vs2019\")\nlocal links  = getcfglinks(cfg)\n_p(2,'<Link>')\n_p(3,'<SubSystem>%s</SubSystem>', iif(cfg.kind == \"ConsoleApp\", \"Console\", \"Windows\"))\nif vs2017OrLater and cfg.flags.FullSymbols then\n_p(3,'<GenerateDebugInformation>DebugFull</GenerateDebugInformation>')\nelse\n_p(3,'<GenerateDebugInformation>%s</GenerateDebugInformation>', tostring(cfg.flags.Symbols ~= nil))\nend\nif cfg.flags.Symbols then\n_p(3, '<ProgramDatabaseFile>$(OutDir)%s.pdb</ProgramDatabaseFile>'\n, path.getbasename(cfg.buildtarget.name)\n)\nend\nif premake.config.islinkeroptimizedbuild(cfg.flags) then\nif cfg.platform == \"Orbis\" then\n_p(3,'<DataStripping>StripFuncsAndData</DataStripping>')\n_p(3,'<DuplicateStripping>true</DuplicateStripping>')\nelse\n_p(3,'<EnableCOMDATFolding>true</EnableCOMDATFolding>')\n_p(3,'<OptimizeReferences>true</OptimizeReferences>')\nend\nelseif cfg.platform == \"Orbis\" and premake.config.iseditandcontinue(cfg) then\n_p(3,"
	"'<EditAndContinue>true</EditAndContinue>')\nend\nif cfg.finalizemetasource ~= nil then\n_p(3,'<FinalizeMetaSource>%s</FinalizeMetaSource>', premake.esc(cfg.finalizemetasource))\nend\nif cfg.kind ~= 'StaticLib' then\nvc2010.additionalDependencies(3, cfg, links)\nvc2010.additionalLibraryDirectories(3, cfg, links)\n_p(3,'<OutputFile>$(OutDir)%s</OutputFile>', cfg.buildtarget.name)\nif vc2010.config_type(cfg) == 'Application' and not cfg.flags.WinMain and not cfg.flags.Managed then\nif cfg.flags.Unicode then\n_p(3,'<EntryPointSymbol>wmainCRTStartup</EntryPointSymbol>')\nelse\n_p(3,'<EntryPointSymbol>mainCRTStartup</EntryPointSymbol>')\nend\nend\nimport_lib(cfg)\nlocal deffile = premake.findfile(cfg, \".def\")\nif deffile then\n_p(3,'<ModuleDefinitionFile>%s</ModuleDefinitionFile>', deffile)\nend\nlink_target_machine(3,cfg)\nadditional_options(3,cfg)\nif cfg.flags.NoWinMD and vstudio.iswinrt() and prj.kind == \"WindowedApp\" then\n_p(3,'<GenerateWindowsMetadata>false</GenerateWindowsMetadata>' )\nend\nend\nif cfg.p"
	"latform == \"TegraAndroid\" then\nif cfg.androidlinker then\n_p(3,'<UseLinker>%s</UseLinker>',cfg.androidlinker)\nend\nend\nif cfg.flags.Hotpatchable then\n_p(3, '<CreateHotPatchableImage>Enabled</CreateHotPatchableImage>')\nend\nif cfg.flags.GenerateMapFiles then\n_p(3, '<GenerateMapFile>true</GenerateMapFile>')\nend\n_p(2,'</Link>')\nif #cfg.wholearchive > 0 then\n_p(2, '<ProjectReference>')\n_p(3, '<LinkLibraryDependencies>false</LinkLibraryDependencies>')\n_p(2, '</ProjectReference>')\nend\nend\nfunction vc2010.additionalLibraryDirectories(tab, cfg, links)\nlocal dirs = cfg.libdirs\nfor _, link in ipairs(links) do\nif link.directory and not table.icontains(dirs, link.directory) then\ntable.insert(dirs, link.directory)\nend\nend\n_p(tab, '<AdditionalLibraryDirectories>%s;%%(AdditionalLibraryDirectories)</AdditionalLibraryDirectories>'\n, premake.esc(path.translate(table.concat(dirs, ';'), '\\\\'))\n)\nend\nfunction vc2010.additionalDependencies(tab, cfg, links)\nif #links > 0 then\nlocal deps = \"\"\nif cfg"
	".platform == \"Orbis\" then\nlocal iswhole = false\nfor _, link in ipairs(links) do\nif link.wholearchive and not iswhole then\ndeps = deps .. \"--whole-archive;\"\niswhole = true\nelseif not link.wholearchive and iswhole then\ndeps = deps .. \"--no-whole-archive;\"\niswhole = false\nend\ndeps = deps .. \"-l\" .. link.name .. \";\"\nend\nelse\nfor _, link in ipairs(links) do\nif link.wholearchive then\ndeps = deps .. \"/WHOLEARCHIVE:\" .. link.name .. \";\"\nelse\ndeps = deps .. link.name .. \";\"\nend\nend\nend\nif cfg.platform == \"TegraAndroid\" then\ndeps = \"-Wl,--start-group;\" .. deps .. \";-Wl,--end-group\"\nend\nlocal adddeps =\n  iif(cfg.platform == \"Durango\",       '%(XboxExtensionsDependencies)'\n, iif(vstudio.isgdkconsole(cfg),       '$(Console_Libs);%(XboxExtensionsDependencies);%(AdditionalDependencies)'\n, iif(vstudio.isgdkdesktop(cfg),       '$(Console_Libs);%(AdditionalDependencies)'\n,                                      '%(AdditionalDependencies)')))\n_p(tab, '<AdditionalDependencies>%s;"
	"%s</AdditionalDependencies>', deps, adddeps)\nelseif cfg.platform == \"Durango\" then\n_p(tab, '<AdditionalDependencies>%%(XboxExtensionsDependencies)</AdditionalDependencies>')\nelseif vstudio.isgdkconsole(cfg) then\n_p(tab, '<AdditionalDependencies>$(Console_Libs);%%(XboxExtensionsDependencies);%%(AdditionalDependencies)</AdditionalDependencies>')\nelseif vstudio.isgdkdesktop(cfg) then\n_p(tab, '<AdditionalDependencies>$(Console_Libs);%%(AdditionalDependencies)</AdditionalDependencies>')\nend\nend\nfunction ant_build(prj, cfg)\nif cfg.platform == \"TegraAndroid\" then\nlocal files = vc2010.getfilegroup(prj, \"AndroidBuild\")\n_p(2,'<AntBuild>')\nif #files > 0 then\n_p(3,'<AndroidManifestLocation>%s</AndroidManifestLocation>',path.translate(files[1].name))\nend\nlocal isdebugbuild = premake.config.isdebugbuild(cfg)\n_p(3,'<AntBuildType>%s</AntBuildType>',iif(isdebugbuild, 'Debug','Release'))\n_p(3,'<Debuggable>%s</Debuggable>',tostring(cfg.flags.AntBuildDebuggable ~= nil))\nif #cfg.antbuildjavasourcedirs > 0 "
	"then\nlocal dirs = table.concat(cfg.antbuildjavasourcedirs,\";\")\n_p(3,'<JavaSourceDir>%s</JavaSourceDir>',dirs)\nend\nif #cfg.antbuildjardirs > 0 then\nlocal dirs = table.concat(cfg.antbuildjardirs,\";\")\n_p(3,'<JarDirectories>%s</JarDirectories>',dirs)\nend\nif #cfg.antbuildjardependencies > 0 then\nlocal dirs = table.concat(cfg.antbuildjardependencies,\";\")\n_p(3,'<JarDependencies>%s</JarDependencies>',dirs)\nend\nif #cfg.antbuildnativelibdirs > 0 then\nlocal dirs = table.concat(cfg.antbuildnativelibdirs,\";\")\n_p(3,'<NativeLibDirectories>%s</NativeLibDirectories>',dirs)\nend\nif #cfg.antbuildnativelibdependencies > 0 then\nlocal dirs = table.concat(cfg.antbuildnativelibdependencies,\";\")\n_p(3,'<NativeLibDependencies>%s</NativeLibDependencies>',dirs)\nend\nif #cfg.antbuildassetsdirs > 0 then\nlocal dirs = table.concat(cfg.antbuildassetsdirs,\";\")\n_p(3,'<AssetsDirectories>%s</AssetsDirectories>',dirs)\nend\n_p(2,'</AntBuild>')\nend\nend\nlocal function item_definitions(prj)\nfor _, cfginfo in ipairs("
	"prj.solution.vstudio_configs) do\nlocal cfg = premake.getconfig(prj, cfginfo.src_buildcfg, cfginfo.src_platform)\n_p(1,'<ItemDefinitionGroup ' ..if_config_and_platform() ..'>'\n,premake.esc(cfginfo.name))\nvs10_clcompile(cfg)\nresource_compile(cfg)\nitem_def_lib(cfg)\nvc2010.link(cfg)\nant_build(prj, cfg)\nevent_hooks(cfg)\nvs10_masm(prj, cfg)\nadditional_manifest(cfg)\n_p(1,'</ItemDefinitionGroup>')\nend\nend\nfunction vc2010.getfilegroup(prj, group)\nlocal sortedfiles = prj.vc2010sortedfiles\nif not sortedfiles then\nsortedfiles = {\nClCompile = {},\nClInclude = {},\nMASM = {},\nObject = {},\nNone = {},\nResourceCompile = {},\nAppxManifest = {},\nAndroidBuild = {},\nNatvis = {},\nImage = {},\nDeploymentContent = {}\n}\nlocal foundAppxManifest = false\nfor file in premake.project.eachfile(prj, true) do\nif path.issourcefilevs(file.name) then\ntable.insert(sortedfiles.ClCompile, file)\nelseif path.iscppheader(file.name) then\nif not table.icontains(prj.removefiles, file) then\ntable.insert(sortedfiles.ClInclud"
	"e, file)\nend\nelseif path.isobjectfile(file.name) then\ntable.insert(sortedfiles.Object, file)\nelseif path.isresourcefile(file.name) then\ntable.insert(sortedfiles.ResourceCompile, file)\nelseif path.isimagefile(file.name) then\ntable.insert(sortedfiles.Image, file)\nelseif path.isappxmanifest(file.name) then\nfoundAppxManifest = true\ntable.insert(sortedfiles.AppxManifest, file)\nelseif path.isandroidbuildfile(file.name) then\ntable.insert(sortedfiles.AndroidBuild, file)\nelseif path.isnatvis(file.name) then\ntable.insert(sortedfiles.Natvis, file)\nelseif path.isasmfile(file.name) then\ntable.insert(sortedfiles.MASM, file)\nelseif file.flags and table.icontains(file.flags, \"DeploymentContent\") then\ntable.insert(sortedfiles.DeploymentContent, file)\nelse\ntable.insert(sortedfiles.None, file)\nend\nend\nif vstudio.iswinrt() and prj.kind == \"WindowedApp\" and not foundAppxManifest then\nvstudio.needAppxManifest = true\nlocal fcfg = {}\nfcfg.name = prj.name .. \"/Package.appxmanifest\"\nfcfg.vpath = premake"
	".project.getvpath(prj, fcfg.name)\ntable.insert(sortedfiles.AppxManifest, fcfg)\nlocal logo = {}\nlogo.name  = prj.name .. \"/Logo.png\"\nlogo.vpath = logo.name\ntable.insert(sortedfiles.Image, logo)\nlocal smallLogo = {}\nsmallLogo.name  = prj.name .. \"/SmallLogo.png\"\nsmallLogo.vpath = smallLogo.name\ntable.insert(sortedfiles.Image, smallLogo)\nlocal storeLogo = {}\nstoreLogo.name  = prj.name .. \"/StoreLogo.png\"\nstoreLogo.vpath = storeLogo.name\ntable.insert(sortedfiles.Image, storeLogo)\nlocal splashScreen = {}\nsplashScreen.name  = prj.name .. \"/SplashScreen.png\"\nsplashScreen.vpath = splashScreen.name\ntable.insert(sortedfiles.Image, splashScreen)\nend\nprj.vc2010sortedfiles = sortedfiles\nend\nreturn sortedfiles[group]\nend\nfunction vc2010.files(prj)\nvc2010.simplefilesgroup(prj, \"ClInclude\")\nvc2010.compilerfilesgroup(prj)\nvc2010.simplefilesgroup(prj, \"Object\")\nvc2010.simplefilesgroup(prj, \"None\")\nvc2010.customtaskgroup(prj)\nvc2010.simplefilesgroup(prj, \"ResourceCompile\")\nvc2010.sim"
	"plefilesgroup(prj, \"AppxManifest\")\nvc2010.simplefilesgroup(prj, \"AndroidBuild\")\nvc2010.simplefilesgroup(prj, \"Natvis\")\nvc2010.deploymentcontentgroup(prj, \"Image\")\nvc2010.deploymentcontentgroup(prj, \"DeploymentContent\", \"None\")\nend\nfunction vc2010.customtaskgroup(prj)\nlocal files = { }\nfor _, custombuildtask in ipairs(prj.custombuildtask or {}) do\nfor _, buildtask in ipairs(custombuildtask or {}) do\nlocal fcfg = { }\nfcfg.name = path.getrelative(prj.location,buildtask[1])\nfcfg.vpath = path.trimdots(fcfg.name)\ntable.insert(files, fcfg)\nend\nend\nif #files > 0  then\n_p(1,'<ItemGroup>')\nlocal groupedBuildTasks = {}\nlocal buildTaskNames = {}\nfor _, custombuildtask in ipairs(prj.custombuildtask or {}) do\nfor _, buildtask in ipairs(custombuildtask or {}) do\nif (groupedBuildTasks[buildtask[1]] == nil) then\ngroupedBuildTasks[buildtask[1]] = {}\ntable.insert(buildTaskNames, buildtask[1])\nend\ntable.insert(groupedBuildTasks[buildtask[1]], buildtask)\nend\nend\nfor _, name in ipairs(buildT"
	"askNames) do\ncustombuildtask = groupedBuildTasks[name]\n_p(2,'<CustomBuild Include=\\\"%s\\\">', path.translate(path.getrelative(prj.location,name), \"\\\\\"))\n_p(3,'<FileType>Text</FileType>')\nlocal cmd = \"\"\nlocal outputs = \"\"\nfor _, buildtask in ipairs(custombuildtask or {}) do\nfor _, cmdline in ipairs(buildtask[4] or {}) do\ncmd = cmd .. cmdline\nlocal num = 1\nfor _, depdata in ipairs(buildtask[3] or {}) do\ncmd = string.gsub(cmd,\"%$%(\" .. num ..\"%)\", string.format(\"%s \",path.getrelative(prj.location,depdata)))\nnum = num + 1\nend\ncmd = string.gsub(cmd, \"%$%(<%)\", string.format(\"%s \",path.getrelative(prj.location,buildtask[1])))\ncmd = string.gsub(cmd, \"%$%(@%)\", string.format(\"%s \",path.getrelative(prj.location,buildtask[2])))\ncmd = cmd .. \"\\r\\n\"\nend\noutputs = outputs .. path.getrelative(prj.location,buildtask[2]) .. \";\"\nend\n_p(3,'<Command>%s</Command>',cmd)\n_p(3,'<Outputs>%s%%(Outputs)</Outputs>',outputs)\n_p(3,'<SubType>Designer</SubType>')\n_p(3,'<Message></Message>"
	"')\n_p(2,'</CustomBuild>')\nend\n_p(1,'</ItemGroup>')\nend\nend\nfunction vc2010.simplefilesgroup(prj, section, subtype)\nlocal configs = prj.solution.vstudio_configs\nlocal files = vc2010.getfilegroup(prj, section)\nif #files > 0  then\nlocal config_mappings = {}\nfor _, cfginfo in ipairs(configs) do\nlocal cfg = premake.getconfig(prj, cfginfo.src_buildcfg, cfginfo.src_platform)\nif cfg.pchheader and cfg.pchsource and not cfg.flags.NoPCH then\nconfig_mappings[cfginfo] = path.translate(cfg.pchsource, \"\\\\\")\nend\nend\n_p(1,'<ItemGroup>')\nfor _, file in ipairs(files) do\nlocal prjexcluded = table.icontains(prj.excludes, file.name)\nlocal excludedcfgs = {}\nif not prjexcluded then\nfor _, vsconfig in ipairs(configs) do\nlocal cfg = premake.getconfig(prj, vsconfig.src_buildcfg, vsconfig.src_platform)\nlocal fileincfg = table.icontains(cfg.files, file.name)\nlocal cfgexcluded = table.icontains(cfg.excludes, file.name)\nif not fileincfg or cfgexcluded then\ntable.insert(excludedcfgs, vsconfig.name)\nend\nend\ne"
	"nd\nif subtype or prjexcluded or #excludedcfgs > 0 then\n_p(2, '<%s Include=\\\"%s\\\">', section, path.translate(file.name, \"\\\\\"))\nif prjexcluded then\n_p(3, '<ExcludedFromBuild>true</ExcludedFromBuild>')\nelse\nfor _, cfgname in ipairs(excludedcfgs) do\n_p(3, '<ExcludedFromBuild '\n.. if_config_and_platform()\n.. '>true</ExcludedFromBuild>'\n, premake.esc(cfgname)\n)\nend\nend\nif subtype then\n_p(3, '<SubType>%s</SubType>', subtype)\nend\n_p(2,'</%s>', section)\nelse\n_p(2, '<%s Include=\\\"%s\\\" />', section, path.translate(file.name, \"\\\\\"))\nend\nend\n_p(1,'</ItemGroup>')\nend\nend\nfunction vc2010.deploymentcontentgroup(prj, section, filetype)\nif filetype == nil then\nfiletype = section\nend\nlocal files = vc2010.getfilegroup(prj, section)\nif #files > 0  then\n_p(1,'<ItemGroup>')\nfor _, file in ipairs(files) do\n_p(2,'<%s Include=\\\"%s\\\">', filetype, path.translate(file.name, \"\\\\\"))\n_p(3,'<DeploymentContent>true</DeploymentContent>')\n_p(3,'<Link>%s</Link>', path.translate(file.vpath"
	", \"\\\\\"))\n_p(2,'</%s>', filetype)\nend\n_p(1,'</ItemGroup>')\nend\nend\nfunction vc2010.compilerfilesgroup(prj)\nlocal configs = prj.solution.vstudio_configs\nlocal files = vc2010.getfilegroup(prj, \"ClCompile\")\nif #files > 0  then\nlocal config_mappings = {}\nfor _, cfginfo in ipairs(configs) do\nlocal cfg = premake.getconfig(prj, cfginfo.src_buildcfg, cfginfo.src_platform)\nif cfg.pchheader and cfg.pchsource and not cfg.flags.NoPCH then\nconfig_mappings[cfginfo] = path.translate(cfg.pchsource, \"\\\\\")\nend\nend\n_p(1,'<ItemGroup>')\nlocal existingBasenames = {};\nfor _, file in ipairs(files) do\nlocal filename = string.lower(path.getbasename(file.name))\nlocal disambiguation = existingBasenames[filename] or 0;\nexistingBasenames[filename] = disambiguation + 1\nlocal translatedpath = path.translate(file.name, \"\\\\\")\n_p(2, '<ClCompile Include=\\\"%s\\\">', translatedpath)\nfor _, vsconfig in ipairs(configs) do\nlocal cfg = premake.getconfig(prj, vsconfig.src_buildcfg, vsconfig.src_platform)\nlocal "
	"namestyle = premake.getnamestyle(cfg)\nif namestyle == \"TegraAndroid\" or namestyle == \"NX\" then\n_p(3, '<ObjectFileName '.. if_config_and_platform() .. '>$(IntDir)%s.o</ObjectFileName>', premake.esc(vsconfig.name), premake.esc(path.translate(path.trimdots(path.removeext(file.name)))) )\nelse\nif disambiguation > 0 then\n_p(3, '<ObjectFileName '.. if_config_and_platform() .. '>$(IntDir)%s\\\\</ObjectFileName>', premake.esc(vsconfig.name), tostring(disambiguation))\nend\nend\nend\nif path.iscxfile(file.name) then\n_p(3, '<CompileAsWinRT>true</CompileAsWinRT>')\n_p(3, '<RuntimeTypeInfo>true</RuntimeTypeInfo>')\n_p(3, '<PrecompiledHeader>NotUsing</PrecompiledHeader>')\nend\nif vstudio.iswinrt() and string.len(file.name) > 2 and string.sub(file.name, -2) == \".c\" then\n_p(3,'<CompileAsWinRT>FALSE</CompileAsWinRT>')\nend\nfor _, cfginfo in ipairs(configs) do\nif config_mappings[cfginfo] and translatedpath == config_mappings[cfginfo] then\n_p(3,'<PrecompiledHeader '.. if_config_and_platform() .. '>Create</Precom"
	"piledHeader>', premake.esc(cfginfo.name))\nconfig_mappings[cfginfo] = nil  --only one source file per pch\nend\nend\nlocal nopch = table.icontains(prj.nopch, file.name)\nfor _, vsconfig in ipairs(configs) do\nlocal cfg = premake.getconfig(prj, vsconfig.src_buildcfg, vsconfig.src_platform)\nif nopch or table.icontains(cfg.nopch, file.name) then\n_p(3,'<PrecompiledHeader '.. if_config_and_platform() .. '>NotUsing</PrecompiledHeader>', premake.esc(vsconfig.name))\nend\nend\nlocal excluded = table.icontains(prj.excludes, file.name)\nfor _, vsconfig in ipairs(configs) do\nlocal cfg = premake.getconfig(prj, vsconfig.src_buildcfg, vsconfig.src_platform)\nlocal fileincfg = table.icontains(cfg.files, file.name)\nlocal cfgexcluded = table.icontains(cfg.excludes, file.name)\nif excluded or not fileincfg or cfgexcluded then\n_p(3, '<ExcludedFromBuild '\n.. if_config_and_platform()\n.. '>true</ExcludedFromBuild>'\n, premake.esc(vsconfig.name)\n)\nend\nend\nif prj.flags and prj.flags.Managed then\nlocal prjforcenative = tab"
	"le.icontains(prj.forcenative, file.name)\nfor _,vsconfig in ipairs(configs) do\nlocal cfg = premake.getconfig(prj, vsconfig.src_buildcfg, vsconfig.src_platform)\nif prjforcenative or table.icontains(cfg.forcenative, file.name) then\n_p(3, '<CompileAsManaged ' .. if_config_and_platform() .. '>false</CompileAsManaged>', premake.esc(vsconfig.name))\nend\nend\nend\n_p(2,'</ClCompile>')\nend\n_p(1,'</ItemGroup>')\nend\nend\nfunction vc2010.masmfiles(prj)\nlocal configs = prj.solution.vstudio_configs\nlocal files = vc2010.getfilegroup(prj, \"MASM\")\nif #files > 0 then\n_p(1, '<ItemGroup>')\nfor _, file in ipairs(files) do\nlocal translatedpath = path.translate(file.name, \"\\\\\")\n_p(2, '<MASM Include=\"%s\">', translatedpath)\nlocal excluded = table.icontains(prj.excludes, file.name)\nfor _, vsconfig in ipairs(configs) do\nlocal cfg = premake.getconfig(prj, vsconfig.src_buildcfg, vsconfig.src_platform)\nlocal fileincfg = table.icontains(cfg.files, file.name)\nlocal cfgexcluded = table.icontains(cfg.excludes, file"
	".name)\nif excluded or not fileincfg or cfgexcluded then\n_p(3, '<ExcludedFromBuild '\n.. if_config_and_platform()\n.. '>true</ExcludedFromBuild>'\n, premake.esc(vsconfig.name)\n)\nend\nend\n_p(2, '</MASM>')\nend\n_p(1, '</ItemGroup>')\nend\nend\nfunction vc2010.header(targets)\nio.eol = \"\\r\\n\"\n_p('<?xml version=\"1.0\" encoding=\"utf-8\"?>')\nlocal t = \"\"\nif targets then\nt = ' DefaultTargets=\"' .. targets .. '\"'\nend\n_p('<Project%s ToolsVersion=\"%s\" xmlns=\"http://schemas.microsoft.com/developer/msbuild/2003\">', t, action.vstudio.toolsVersion)\nend\nfunction premake.vs2010_vcxproj(prj)\nlocal usemasm = hasmasmfiles(prj)\nio.indent = \"  \"\nvc2010.header(\"Build\")\nvs2010_config(prj)\nvs2010_globals(prj)\n_p(1,'<Import Project=\"$(VCTargetsPath)\\\\Microsoft.Cpp.Default.props\" />')\nfor _, cfginfo in ipairs(prj.solution.vstudio_configs) do\nlocal cfg = premake.getconfig(prj, cfginfo.src_buildcfg, cfginfo.src_platform)\nvc2010.configurationPropertyGroup(cfg, cfginfo)\nend\n_p(1,'<Import Projec"
	"t=\"$(VCTargetsPath)\\\\Microsoft.Cpp.props\" />')\n_p(1,'<ImportGroup Label=\"ExtensionSettings\">')\nif usemasm then\n_p(2, '<Import Project=\"$(VCTargetsPath)\\\\BuildCustomizations\\\\masm.props\" />')\nend\n_p(1,'</ImportGroup>')\nimport_props(prj)\n_p(1,'<PropertyGroup Label=\"UserMacros\" />')\nvc2010.outputProperties(prj)\nitem_definitions(prj)\nvc2010.files(prj)\nvc2010.clrReferences(prj)\nvc2010.projectReferences(prj)\nvc2010.sdkReferences(prj)\nvc2010.masmfiles(prj)\n_p(1,'<Import Project=\"$(VCTargetsPath)\\\\Microsoft.Cpp.targets\" />')\n_p(1,'<ImportGroup Label=\"ExtensionTargets\">')\nif usemasm then\n_p(2, '<Import Project=\"$(VCTargetsPath)\\\\BuildCustomizations\\\\masm.targets\" />')\nend\n_p(1,'</ImportGroup>')\n_p('</Project>')\nend\nfunction vc2010.clrReferences(prj)\nif #prj.clrreferences == 0 then\nreturn\nend\n_p(1,'<ItemGroup>')\nfor _, ref in ipairs(prj.clrreferences) do\nif os.isfile(ref) then\nlocal assembly = path.getbasename(ref)\n_p(2,'<Reference Include=\"%s\">', assembly)\n_p("
	"3,'<HintPath>%s</HintPath>', path.getrelative(prj.location, ref))\n_p(2,'</Reference>')\nelse\n_p(2,'<Reference Include=\"%s\" />', ref)\nend\nend\n_p(1,'</ItemGroup>')\nend\nfunction vc2010.projectReferences(prj)\nlocal deps = premake.getdependencies(prj)\nif #deps == 0 and #prj.vsimportreferences == 0 then\nreturn\nend\nlocal function compareuuid(a, b) return a.uuid < b.uuid end\ntable.sort(deps, compareuuid)\ntable.sort(table.join(prj.vsimportreferences), compareuuid)\n_p(1,'<ItemGroup>')\nfor _, dep in ipairs(deps) do\nlocal deppath = path.getrelative(prj.location, vstudio.projectfile(dep))\n_p(2,'<ProjectReference Include=\\\"%s\\\">', path.translate(deppath, \"\\\\\"))\n_p(3,'<Project>{%s}</Project>', dep.uuid)\nif vstudio.iswinrt() then\n_p(3,'<ReferenceOutputAssembly>false</ReferenceOutputAssembly>')\nend\n_p(2,'</ProjectReference>')\nend\nfor _, ref in ipairs(prj.vsimportreferences) do\nlocal slnrelpath = path.rebase(ref, prj.location, sln.location)\nlocal iprj = premake.vstudio.getimportprj(slnrelpat"
	"h, prj.solution)\n_p(2,'<ProjectReference Include=\\\"%s\\\">', ref)\n_p(3,'<Project>{%s}</Project>', iprj.uuid)\n_p(2,'</ProjectReference>')\nend\n_p(1,'</ItemGroup>')\nend\nfunction vc2010.sdkReferences(prj)\nlocal refs = prj.sdkreferences\nif #refs > 0 then\n_p(1,'<ItemGroup>')\nfor _, ref in ipairs(refs) do\n_p(2,'<SDKReference Include=\\\"%s\\\" />', ref)\nend\n_p(1,'</ItemGroup>')\nend\nend\nfunction vc2010.debugdir(cfg)\nlocal isnx = (cfg.platform == \"NX32\" or cfg.platform == \"NX64\")\nlocal debuggerFlavor =\n  iif(isnx,                           'OasisNXDebugger'\n, iif(cfg.platform == \"Orbis\",        'ORBISDebugger'\n, iif(cfg.platform == \"Durango\",      'XboxOneVCppDebugger'\n, iif(cfg.platform == \"TegraAndroid\", 'AndroidDebugger'\n, iif(vstudio.iswinrt(),              'AppHostLocalDebugger'\n,                                     'WindowsLocalDebugger'\n)))))\n_p(2, '<DebuggerFlavor>%s</DebuggerFlavor>', debuggerFlavor)\nif cfg.debugdir and not vstudio.iswinrt() then\n_p(2, '<LocalDebuggerWo"
	"rkingDirectory>%s</LocalDebuggerWorkingDirectory>'\n, path.translate(cfg.debugdir, '\\\\')\n)\nend\nif cfg.debugcmd then\n_p(2, '<LocalDebuggerCommand>%s</LocalDebuggerCommand>', cfg.debugcmd)\nend\nif cfg.debugargs then\n_p(2, '<LocalDebuggerCommandArguments>%s</LocalDebuggerCommandArguments>'\n, table.concat(cfg.debugargs, \" \")\n)\nend\nif cfg.debugenvs and #cfg.debugenvs > 0 then\n_p(2, '<LocalDebuggerEnvironment>%s%s</LocalDebuggerEnvironment>'\n, table.concat(cfg.debugenvs, \"\\n\")\n, iif(cfg.flags.DebugEnvsInherit,'\\n$(LocalDebuggerEnvironment)', '')\n)\nif cfg.flags.DebugEnvsDontMerge then\n_p(2, '<LocalDebuggerMergeEnvironment>false</LocalDebuggerMergeEnvironment>')\nend\nend\nif cfg.deploymode then\n_p(2, '<DeployMode>%s</DeployMode>', cfg.deploymode)\nend\nif cfg.platform == \"TegraAndroid\" then\nif cfg.androiddebugintentparams then\n_p(2, '<IntentParams>%s</IntentParams>'\n, table.concat(cfg.androiddebugintentparams, \" \")\n)\nend\nend\nend\nfunction premake.vs2010_vcxproj_user(prj)\nio.indent"
	" = \"  \"\nvc2010.header()\nfor _, cfginfo in ipairs(prj.solution.vstudio_configs) do\nlocal cfg = premake.getconfig(prj, cfginfo.src_buildcfg, cfginfo.src_platform)\n_p('  <PropertyGroup '.. if_config_and_platform() ..'>', premake.esc(cfginfo.name))\nvc2010.debugdir(cfg)\n_p('  </PropertyGroup>')\nend\n_p('</Project>')\nend\nlocal png1x1data = {\n0x89, 0x50, 0x4e, 0x47, 0x0d, 0x0a, 0x1a, 0x0a, 0x00, 0x00, 0x00, 0x0d, 0x49, 0x48, 0x44, 0x52, -- .PNG........IHDR\n0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x01, 0x01, 0x03, 0x00, 0x00, 0x00, 0x25, 0xdb, 0x56, -- .............%.V\n0xca, 0x00, 0x00, 0x00, 0x03, 0x50, 0x4c, 0x54, 0x45, 0x00, 0x00, 0x00, 0xa7, 0x7a, 0x3d, 0xda, -- .....PLTE....z=.\n0x00, 0x00, 0x00, 0x01, 0x74, 0x52, 0x4e, 0x53, 0x00, 0x40, 0xe6, 0xd8, 0x66, 0x00, 0x00, 0x00, -- ....tRNS.@..f...\n0x0a, 0x49, 0x44, 0x41, 0x54, 0x08, 0xd7, 0x63, 0x60, 0x00, 0x00, 0x00, 0x02, 0x00, 0x01, 0xe2, -- .IDAT..c`.......\n0x21, 0xbc, 0x33, 0x00, 0x00, 0x00, 0x00, 0x49, 0x45, 0x4e, 0x44, 0xae, 0x42, 0x60, 0x82, "
	"      -- !.3....IEND.B`.\n}\nfunction png1x1(obj, filename)\nfilename = premake.project.getfilename(obj, filename)\nlocal f, err = io.open(filename, \"wb\")\nif f then\nfor _, byte in ipairs(png1x1data) do\nf:write(string.char(byte))\nend\nf:close()\nend\nend\nfunction premake.vs2010_appxmanifest(prj)\nio.indent = \"  \"\nio.eol = \"\\r\\n\"\n_p('<?xml version=\"1.0\" encoding=\"utf-8\"?>')\nif vstudio.storeapp == \"10.0\" then\n_p('<Package')\n_p(1, 'xmlns=\"http://schemas.microsoft.com/appx/manifest/foundation/windows10\"')\n_p(1, 'xmlns:mp=\"http://schemas.microsoft.com/appx/2014/phone/manifest\"')\n_p(1, 'xmlns:uap=\"http://schemas.microsoft.com/appx/manifest/uap/windows10\"')\n_p(1, 'IgnorableNamespaces=\"uap mp\">')\nelseif vstudio.storeapp == \"durango\" then\n_p('<Package xmlns=\"http://schemas.microsoft.com/appx/2010/manifest\" xmlns:mx=\"http://schemas.microsoft.com/appx/2013/xbox/manifest\" IgnorableNamespaces=\"mx\">')\nend\n_p(1, '<Identity')\n_p(2, 'Name=\"' .. prj.uuid .. '\"')\n_p(2, 'Publisher"
	"=\"CN=Publisher\"')\n_p(2, 'Version=\"1.0.0.0\" />')\nif vstudio.storeapp == \"10.0\" then\n_p(1, '<mp:PhoneIdentity')\n_p(2, 'PhoneProductId=\"' .. prj.uuid .. '\"')\n_p(2, 'PhonePublisherId=\"00000000-0000-0000-0000-000000000000\"/>')\nend\n_p(1, '<Properties>')\n_p(2, '<DisplayName>' .. prj.name .. '</DisplayName>')\n_p(2, '<PublisherDisplayName>PublisherDisplayName</PublisherDisplayName>')\n_p(2, '<Logo>' .. prj.name .. '\\\\StoreLogo.png</Logo>')\npng1x1(prj, \"%%/StoreLogo.png\")\n_p(2, '<Description>' .. prj.name .. '</Description>')\n_p(1,'</Properties>')\nif vstudio.storeapp == \"10.0\" then\n_p(1, '<Dependencies>')\n_p(2, '<TargetDeviceFamily Name=\"Windows.Universal\" MinVersion=\"10.0.10069.0\" MaxVersionTested=\"10.0.10069.0\" />')\n_p(1, '</Dependencies>')\nelseif vstudio.storeapp == \"durango\" then\n_p(1, '<Prerequisites>')\n_p(2, '<OSMinVersion>6.2</OSMinVersion>')\n_p(2, '<OSMaxVersionTested>6.2</OSMaxVersionTested>')\n_p(1, '</Prerequisites>')\nend\n_p(1, '<Resources>')\n_p(2, '<Resource Lan"
	"guage=\"en-us\"/>')\n_p(1, '</Resources>')\n_p(1, '<Applications>')\n_p(2, '<Application Id=\"App\"')\n_p(3, 'Executable=\"$targetnametoken$.exe\"')\n_p(3, 'EntryPoint=\"' .. prj.name .. '.App\">')\nif vstudio.storeapp == \"10.0\" then\n_p(3, '<uap:VisualElements')\n_p(4, 'DisplayName=\"' .. prj.name .. '\"')\n_p(4, 'Square150x150Logo=\"' .. prj.name .. '\\\\Logo.png\"')\npng1x1(prj, \"%%/Logo.png\")\nif vstudio.storeapp == \"10.0\" then\n_p(4, 'Square44x44Logo=\"' .. prj.name .. '\\\\SmallLogo.png\"')\npng1x1(prj, \"%%/SmallLogo.png\")\nelse\n_p(4, 'Square30x30Logo=\"' .. prj.name .. '\\\\SmallLogo.png\"')\npng1x1(prj, \"%%/SmallLogo.png\")\nend\n_p(4, 'Description=\"' .. prj.name .. '\"')\n_p(4, 'BackgroundColor=\"transparent\">')\n_p(4, '<uap:SplashScreen Image=\"' .. prj.name .. '\\\\SplashScreen.png\" />')\npng1x1(prj, \"%%/SplashScreen.png\")\n_p(3, '</uap:VisualElements>')\nelseif vstudio.storeapp == \"durango\" then\n_p(3, '<VisualElements')\n_p(4, 'DisplayName=\"' .. prj.name .. '\"')\n_p(4, 'Logo=\"'"
	" .. prj.name .. '\\\\Logo.png\"')\npng1x1(prj, \"%%/Logo.png\")\n_p(4, 'SmallLogo=\"' .. prj.name .. '\\\\SmallLogo.png\"')\npng1x1(prj, \"%%/SmallLogo.png\")\n_p(4, 'Description=\"' .. prj.name .. '\"')\n_p(4, 'ForegroundText=\"light\"')\n_p(4, 'BackgroundColor=\"transparent\">')\n_p(5, '<SplashScreen Image=\"' .. prj.name .. '\\\\SplashScreen.png\" />')\npng1x1(prj, \"%%/SplashScreen.png\")\n_p(3, '</VisualElements>')\n_p(3, '<Extensions>')\n_p(4, '<mx:Extension Category=\"xbox.system.resources\">')\n_p(4, '<mx:XboxSystemResources />')\n_p(4, '</mx:Extension>')\n_p(3, '</Extensions>')\nend\n_p(2, '</Application>')\n_p(1, '</Applications>')\n_p('</Package>')\nend\n",

	/* actions/vstudio/vstudio_vcxproj_filters.lua */
	"local vc2010 = premake.vstudio.vc2010\nlocal project = premake.project\nfunction vc2010.filteridgroup(prj)\nlocal filters = { }\nlocal filterfound = false\nfor file in premake.project.eachfile(prj, true) do\nlocal folders = string.explode(file.vpath, \"/\", true)\nlocal path = \"\"\nfor i = 1, #folders - 1 do\nif not filterfound then\nfilterfound = true\n_p(1,'<ItemGroup>')\nend\npath = path .. folders[i]\nif not filters[path] then\nfilters[path] = true\n_p(2, '<Filter Include=\"%s\">', path)\n_p(3, '<UniqueIdentifier>{%s}</UniqueIdentifier>', os.uuid(path))\n_p(2, '</Filter>')\nend\npath = path .. \"\\\\\"\nend\nend\nfor _, custombuildtask in ipairs(prj.custombuildtask or {}) do\nfor _, buildtask in ipairs(custombuildtask or {}) do\nlocal folders = string.explode(path.trimdots(path.getrelative(prj.location,buildtask[1])), \"/\", true)\nlocal path = \"\"\nfor i = 1, #folders - 1 do\nif not filterfound then\nfilterfound = true\n_p(1,'<ItemGroup>')\nend\npath = path .. folders[i]\nif not filters[path] then\nfilt"
	"ers[path] = true\n_p(2, '<Filter Include=\"%s\">', path)\n_p(3, '<UniqueIdentifier>{%s}</UniqueIdentifier>', os.uuid(path))\n_p(2, '</Filter>')\nend\npath = path .. \"\\\\\"\nend\nend\nend\nif filterfound then\n_p(1,'</ItemGroup>')\nend\nend\nfunction vc2010.filefiltergroup(prj, section, kind)\nlocal files = vc2010.getfilegroup(prj, section) or {}\nif kind == nill then\nkind = section\nend\nif (section == \"CustomBuild\") then\nfor _, custombuildtask in ipairs(prj.custombuildtask or {}) do\nfor _, buildtask in ipairs(custombuildtask or {}) do\nlocal fcfg = { }\nfcfg.name = path.getrelative(prj.location,buildtask[1])\nfcfg.vpath = path.trimdots(fcfg.name)\ntable.insert(files, fcfg)\nend\nend\nend\nif #files > 0 then\n_p(1,'<ItemGroup>')\nfor _, file in ipairs(files) do\nlocal filter\nif file.name ~= file.vpath then\nfilter = path.getdirectory(file.vpath)\nelse\nfilter = path.getdirectory(file.name)\nend\nif filter ~= \".\" then\n_p(2,'<%s Include=\\\"%s\\\">', kind, path.translate(file.name, \"\\\\\"))\n_p(3,'<"
	"Filter>%s</Filter>', path.translate(filter, \"\\\\\"))\n_p(2,'</%s>', kind)\nelse\n_p(2,'<%s Include=\\\"%s\\\" />', kind, path.translate(file.name, \"\\\\\"))\nend\nend\n_p(1,'</ItemGroup>')\nend\nend\nfunction vc2010.generate_filters(prj)\nio.indent = \"  \"\nvc2010.header()\nvc2010.filteridgroup(prj)\nvc2010.filefiltergroup(prj, \"None\")\nvc2010.filefiltergroup(prj, \"ClInclude\")\nvc2010.filefiltergroup(prj, \"ClCompile\")\nvc2010.filefiltergroup(prj, \"Object\")\nvc2010.filefiltergroup(prj, \"ResourceCompile\")\nvc2010.filefiltergroup(prj, \"CustomBuild\")\nvc2010.filefiltergroup(prj, \"AppxManifest\")\nvc2010.filefiltergroup(prj, \"Natvis\")\nvc2010.filefiltergroup(prj, \"Image\")\nvc2010.filefiltergroup(prj, \"DeploymentContent\", \"None\")\nvc2010.filefiltergroup(prj, \"MASM\")\n_p('</Project>')\nend\n",

	/* actions/vstudio/vs2010.lua */
	"local vc2010 = premake.vstudio.vc2010\nlocal vstudio = premake.vstudio\nnewaction\n{\ntrigger         = \"vs2010\",\nshortname       = \"Visual Studio 2010\",\ndescription     = \"Generate Microsoft Visual Studio 2010 project files\",\nos              = \"windows\",\nvalid_kinds     = { \"ConsoleApp\", \"WindowedApp\", \"StaticLib\", \"SharedLib\", \"Bundle\" },\nvalid_languages = { \"C\", \"C++\", \"C#\"},\nvalid_tools     = {\ncc     = { \"msc\"   },\ndotnet = { \"msnet\" },\n},\nonsolution = function(sln)\npremake.generate(sln, \"%%.sln\", vstudio.sln2005.generate)\nend,\nonproject = function(prj)\nif premake.isdotnetproject(prj) then\npremake.generate(prj, \"%%.csproj\", vstudio.cs2005.generate)\npremake.generate(prj, \"%%.csproj.user\", vstudio.cs2005.generate_user)\nelse\npremake.generate(prj, \"%%.vcxproj\", premake.vs2010_vcxproj)\npremake.generate(prj, \"%%.vcxproj.user\", premake.vs2010_vcxproj_user)\npremake.generate(prj, \"%%.vcxproj.filters\", vstudio.vc2010.generate_filters)\nend\nend,\noncleanso"
	"lution = premake.vstudio.cleansolution,\noncleanproject  = premake.vstudio.cleanproject,\noncleantarget   = premake.vstudio.cleantarget,\nvstudio = {\nproductVersion  = \"8.0.30703\",\nsolutionVersion = \"11\",\ntargetFramework = \"4.0\",\ntoolsVersion    = \"4.0\",\nsupports64bitEditContinue = false,\nintDirAbsolute  = false,\n}\n}\n",

	/* actions/vstudio/vs2012.lua */
	"premake.vstudio.vc2012 = {}\nlocal vc2012 = premake.vstudio.vc2012\nlocal vstudio = premake.vstudio\nnewaction\n{\ntrigger         = \"vs2012\",\nshortname       = \"Visual Studio 2012\",\ndescription     = \"Generate Microsoft Visual Studio 2012 project files\",\nos              = \"windows\",\nvalid_kinds     = { \"ConsoleApp\", \"WindowedApp\", \"StaticLib\", \"SharedLib\", \"Bundle\" },\nvalid_languages = { \"C\", \"C++\", \"C#\"},\nvalid_tools     = {\ncc     = { \"msc\"   },\ndotnet = { \"msnet\" },\n},\nonsolution = function(sln)\npremake.generate(sln, \"%%.sln\", vstudio.sln2005.generate)\nend,\nonproject = function(prj)\nif premake.isdotnetproject(prj) then\npremake.generate(prj, \"%%.csproj\", vstudio.cs2005.generate)\npremake.generate(prj, \"%%.csproj.user\", vstudio.cs2005.generate_user)\nelse\npremake.generate(prj, \"%%.vcxproj\", premake.vs2010_vcxproj)\npremake.generate(prj, \"%%.vcxproj.user\", premake.vs2010_vcxproj_user)\npremake.generate(prj, \"%%.vcxproj.filters\", vstudio.vc2010.generate_f"
	"ilters)\nend\nend,\noncleansolution = premake.vstudio.cleansolution,\noncleanproject  = premake.vstudio.cleanproject,\noncleantarget   = premake.vstudio.cleantarget,\nvstudio = {\nsolutionVersion = \"12\",\ntargetFramework = \"4.5\",\ntoolsVersion    = \"4.0\",\nsupports64bitEditContinue = false,\nintDirAbsolute  = false,\n}\n}\n",

	/* actions/vstudio/vs2013.lua */
	"premake.vstudio.vc2013 = {}\nlocal vc2013 = premake.vstudio.vc2013\nlocal vstudio = premake.vstudio\nnewaction\n{\ntrigger         = \"vs2013\",\nshortname       = \"Visual Studio 2013\",\ndescription     = \"Generate Microsoft Visual Studio 2013 project files\",\nos              = \"windows\",\nvalid_kinds     = { \"ConsoleApp\", \"WindowedApp\", \"StaticLib\", \"SharedLib\", \"Bundle\" },\nvalid_languages = { \"C\", \"C++\", \"C#\"},\nvalid_tools     = {\ncc     = { \"msc\"   },\ndotnet = { \"msnet\" },\n},\nonsolution = function(sln)\npremake.generate(sln, \"%%.sln\", vstudio.sln2005.generate)\nend,\nonproject = function(prj)\nif premake.isdotnetproject(prj) then\npremake.generate(prj, \"%%.csproj\", vstudio.cs2005.generate)\npremake.generate(prj, \"%%.csproj.user\", vstudio.cs2005.generate_user)\nelse\npremake.vstudio.needAppxManifest = false\npremake.generate(prj, \"%%.vcxproj\", premake.vs2010_vcxproj)\npremake.generate(prj, \"%%.vcxproj.user\", premake.vs2010_vcxproj_user)\npremake.generate(prj, \"%%.vc"
	"xproj.filters\", vstudio.vc2010.generate_filters)\nif premake.vstudio.needAppxManifest then\npremake.generate(prj, \"%%/Package.appxmanifest\", premake.vs2010_appxmanifest)\nend\nend\nend,\noncleansolution = premake.vstudio.cleansolution,\noncleanproject  = premake.vstudio.cleanproject,\noncleantarget   = premake.vstudio.cleantarget,\nvstudio = {\nsolutionVersion = \"12\",\ntargetFramework = \"4.5\",\ntoolsVersion    = \"12.0\",\nsupports64bitEditContinue = false,\nintDirAbsolute  = false,\n}\n}\n",

	/* actions/vstudio/vs2015.lua */
	"premake.vstudio.vc2015 = {}\nlocal vc2015 = premake.vstudio.vc2015\nlocal vstudio = premake.vstudio\nnewaction\n{\ntrigger         = \"vs2015\",\nshortname       = \"Visual Studio 2015\",\ndescription     = \"Generate Microsoft Visual Studio 2015 project files\",\nos              = \"windows\",\nvalid_kinds     = { \"ConsoleApp\", \"WindowedApp\", \"StaticLib\", \"SharedLib\", \"Bundle\" },\nvalid_languages = { \"C\", \"C++\", \"C#\" },\nvalid_tools     = {\ncc     = { \"msc\"   },\ndotnet = { \"msnet\" },\n},\nonsolution = function(sln)\npremake.generate(sln, \"%%.sln\", vstudio.sln2005.generate)\nend,\nonproject = function(prj)\nif premake.isdotnetproject(prj) then\npremake.generate(prj, \"%%.csproj\", vstudio.cs2005.generate)\npremake.generate(prj, \"%%.csproj.user\", vstudio.cs2005.generate_user)\nelse\npremake.vstudio.needAppxManifest = false\npremake.generate(prj, \"%%.vcxproj\", premake.vs2010_vcxproj)\npremake.generate(prj, \"%%.vcxproj.user\", premake.vs2010_vcxproj_user)\npremake.generate(prj, \"%%.v"
	"cxproj.filters\", vstudio.vc2010.generate_filters)\nif premake.vstudio.needAppxManifest then\npremake.generate(prj, \"%%/Package.appxmanifest\", premake.vs2010_appxmanifest)\nend\nend\nend,\noncleansolution = premake.vstudio.cleansolution,\noncleanproject  = premake.vstudio.cleanproject,\noncleantarget   = premake.vstudio.cleantarget,\nvstudio = {\nsolutionVersion = \"12\",\ntargetFramework = \"4.5\",\ntoolsVersion    = \"14.0\",\nwindowsTargetPlatformVersion = \"8.1\",\nsupports64bitEditContinue    = true,\nintDirAbsolute  = false,\n}\n}\n",

	/* actions/vstudio/vs2017.lua */
	"premake.vstudio.vc2017 = {}\nlocal vc2017 = premake.vstudio.vc2017\nlocal vstudio = premake.vstudio\nnewaction\n{\ntrigger         = \"vs2017\",\nshortname       = \"Visual Studio 2017\",\ndescription     = \"Generate Microsoft Visual Studio 2017 project files\",\nos              = \"windows\",\nvalid_kinds     = { \"ConsoleApp\", \"WindowedApp\", \"StaticLib\", \"SharedLib\", \"Bundle\" },\nvalid_languages = { \"C\", \"C++\", \"C#\" },\nvalid_tools     = {\ncc     = { \"msc\"   },\ndotnet = { \"msnet\" },\n},\nonsolution = function(sln)\npremake.generate(sln, \"%%.sln\", vstudio.sln2005.generate)\nend,\nonproject = function(prj)\nif premake.isdotnetproject(prj) then\npremake.generate(prj, \"%%.csproj\", vstudio.cs2005.generate)\npremake.generate(prj, \"%%.csproj.user\", vstudio.cs2005.generate_user)\nelse\npremake.vstudio.needAppxManifest = false\npremake.generate(prj, \"%%.vcxproj\", premake.vs2010_vcxproj)\npremake.generate(prj, \"%%.vcxproj.user\", premake.vs2010_vcxproj_user)\npremake.generate(prj, \"%%.v"
	"cxproj.filters\", vstudio.vc2010.generate_filters)\nif premake.vstudio.needAppxManifest then\npremake.generate(prj, \"%%/Package.appxmanifest\", premake.vs2010_appxmanifest)\nend\nend\nend,\noncleansolution = premake.vstudio.cleansolution,\noncleanproject  = premake.vstudio.cleanproject,\noncleantarget   = premake.vstudio.cleantarget,\nvstudio = {\nsolutionVersion = \"12\",\ntargetFramework = \"4.5.2\",\ntoolsVersion    = \"15.0\",\nwindowsTargetPlatformVersion = \"8.1\",\nsupports64bitEditContinue    = true,\nintDirAbsolute  = false,\n}\n}\n",

	/* actions/vstudio/vs2019.lua */
	"premake.vstudio.vc2019 = {}\nlocal vc2019 = premake.vstudio.vc2019\nlocal vstudio = premake.vstudio\nnewaction\n{\ntrigger         = \"vs2019\",\nshortname       = \"Visual Studio 2019\",\ndescription     = \"Generate Microsoft Visual Studio 2019 project files\",\nos              = \"windows\",\nvalid_kinds     = { \"ConsoleApp\", \"WindowedApp\", \"StaticLib\", \"SharedLib\", \"Bundle\" },\nvalid_languages = { \"C\", \"C++\", \"C#\" },\nvalid_tools     = {\ncc     = { \"msc\"   },\ndotnet = { \"msnet\" },\n},\nonsolution = function(sln)\npremake.generate(sln, \"%%.sln\", vstudio.sln2005.generate)\nend,\nonproject = function(prj)\nif premake.isdotnetproject(prj) then\npremake.generate(prj, \"%%.csproj\", vstudio.cs2005.generate)\npremake.generate(prj, \"%%.csproj.user\", vstudio.cs2005.generate_user)\nelse\npremake.vstudio.needAppxManifest = false\npremake.generate(prj, \"%%.vcxproj\", premake.vs2010_vcxproj)\npremake.generate(prj, \"%%.vcxproj.user\", premake.vs2010_vcxproj_user)\npremake.generate(prj, \"%%.v"
	"cxproj.filters\", vstudio.vc2010.generate_filters)\nif premake.vstudio.needAppxManifest then\npremake.generate(prj, \"%%/Package.appxmanifest\", premake.vs2010_appxmanifest)\nend\nend\nend,\noncleansolution = premake.vstudio.cleansolution,\noncleanproject  = premake.vstudio.cleanproject,\noncleantarget   = premake.vstudio.cleantarget,\nvstudio = {\nsolutionVersion = \"12\",\ntargetFramework = \"4.7.2\",\ntoolsVersion    = \"16.0\",\nwindowsTargetPlatformVersion = \"10.0\",\nsupports64bitEditContinue    = true,\nintDirAbsolute  = false,\n}\n}\n",

	/* actions/vstudio/vs2022.lua */
	"premake.vstudio.vc2022 = {}\nlocal vc2022 = premake.vstudio.vc2022\nlocal vstudio = premake.vstudio\nnewaction\n{\ntrigger         = \"vs2022\",\nshortname       = \"Visual Studio 2022\",\ndescription     = \"Generate Microsoft Visual Studio 2022 project files\",\nos              = \"windows\",\nvalid_kinds     = { \"ConsoleApp\", \"WindowedApp\", \"StaticLib\", \"SharedLib\", \"Bundle\" },\nvalid_languages = { \"C\", \"C++\", \"C#\" },\nvalid_tools     = {\ncc     = { \"msc\"   },\ndotnet = { \"msnet\" },\n},\nonsolution = function(sln)\npremake.generate(sln, \"%%.sln\", vstudio.sln2005.generate)\nend,\nonproject = function(prj)\nif premake.isdotnetproject(prj) then\npremake.generate(prj, \"%%.csproj\", vstudio.cs2005.generate)\npremake.generate(prj, \"%%.csproj.user\", vstudio.cs2005.generate_user)\nelse\npremake.vstudio.needAppxManifest = false\npremake.generate(prj, \"%%.vcxproj\", premake.vs2010_vcxproj)\npremake.generate(prj, \"%%.vcxproj.user\", premake.vs2010_vcxproj_user)\npremake.generate(prj, \"%%.v"
	"cxproj.filters\", vstudio.vc2010.generate_filters)\nif premake.vstudio.needAppxManifest then\npremake.generate(prj, \"%%/Package.appxmanifest\", premake.vs2010_appxmanifest)\nend\nend\nend,\noncleansolution = premake.vstudio.cleansolution,\noncleanproject  = premake.vstudio.cleanproject,\noncleantarget   = premake.vstudio.cleantarget,\nvstudio = {\nsolutionVersion = \"12\",\ntargetFramework = \"4.7.2\",\ntoolsVersion    = \"16.0\",\nwindowsTargetPlatformVersion = \"10.0\",\nsupports64bitEditContinue    = true,\nintDirAbsolute  = false,\n}\n}\n",

	/* actions/xcode/_xcode.lua */
	"premake.xcode = { }\nfunction premake.xcode.checkproject(prj)\nlocal last\nfor cfg in premake.eachconfig(prj) do\nif last and last ~= cfg.kind then\nerror(\"Project '\" .. prj.name .. \"' uses more than one target kind; not supported by Xcode\", 0)\nend\nlast = cfg.kind\nend\nend\npremake.xcode.toolset = \"macosx\"\n",

	/* actions/xcode/xcode_common.lua */
	"premake.xcode.parameters = { }\nlocal xcode = premake.xcode\nlocal tree  = premake.tree\nfunction xcode.getbuildcategory(node)\nlocal categories = {\n[\".a\"] = \"Frameworks\",\n[\".h\"] = \"Headers\",\n[\".hh\"] = \"Headers\",\n[\".hpp\"] = \"Headers\",\n[\".hxx\"] = \"Headers\",\n[\".inl\"] = \"Headers\",\n[\".c\"] = \"Sources\",\n[\".cc\"] = \"Sources\",\n[\".cpp\"] = \"Sources\",\n[\".cxx\"] = \"Sources\",\n[\".c++\"] = \"Sources\",\n[\".dylib\"] = \"Frameworks\",\n[\".bundle\"] = \"Frameworks\",\n[\".framework\"] = \"Frameworks\",\n[\".tbd\"] = \"Frameworks\",\n[\".m\"] = \"Sources\",\n[\".mm\"] = \"Sources\",\n[\".S\"] = \"Sources\",\n[\".strings\"] = \"Resources\",\n[\".nib\"] = \"Resources\",\n[\".xib\"] = \"Resources\",\n[\".icns\"] = \"Resources\",\n[\".bmp\"] = \"Resources\",\n[\".wav\"] = \"Resources\",\n[\".xcassets\"]  = \"Resources\",\n[\".xcdatamodeld\"] = \"Sources\",\n[\".swift\"] = \"Sources\",\n}\nreturn categories[path.getextension(node.name)] or\ncategories[string.lower(path.getextension("
	"node.name))]\nend\nfunction xcode.getconfigname(cfg)\nlocal name = cfg.name\nif #cfg.project.solution.xcode.platforms > 1 then\nname = name .. \" \" .. premake.action.current().valid_platforms[cfg.platform]\nend\nreturn name\nend\nfunction xcode.getfiletype(node)\nlocal types = {\n[\".c\"]         = \"sourcecode.c.c\",\n[\".cc\"]        = \"sourcecode.cpp.cpp\",\n[\".cpp\"]       = \"sourcecode.cpp.cpp\",\n[\".css\"]       = \"text.css\",\n[\".cxx\"]       = \"sourcecode.cpp.cpp\",\n[\".c++\"]       = \"sourcecode.cpp.cpp\",\n[\".entitlements\"] = \"text.xml\",\n[\".bundle\"]    = \"wrapper.cfbundle\",\n[\".framework\"] = \"wrapper.framework\",\n[\".tbd\"]       = \"sourcecode.text-based-dylib-definition\",\n[\".gif\"]       = \"image.gif\",\n[\".h\"]         = \"sourcecode.c.h\",\n[\".hh\"]        = \"sourcecode.cpp.h\",\n[\".hpp\"]       = \"sourcecode.cpp.h\",\n[\".hxx\"]       = \"sourcecode.cpp.h\",\n[\".inl\"]       = \"sourcecode.cpp.h\",\n[\".html\"]      = \"text.html\",\n[\".lua\"]       = \"sourceco"
	"de.lua\",\n[\".m\"]         = \"sourcecode.c.objc\",\n[\".mm\"]        = \"sourcecode.cpp.objcpp\",\n[\".S\"]         = \"sourcecode.asm\",\n[\".nib\"]       = \"wrapper.nib\",\n[\".pch\"]       = \"sourcecode.c.h\",\n[\".plist\"]     = \"text.plist.xml\",\n[\".strings\"]   = \"text.plist.strings\",\n[\".xib\"]       = \"file.xib\",\n[\".icns\"]      = \"image.icns\",\n[\".bmp\"]       = \"image.bmp\",\n[\".wav\"]       = \"audio.wav\",\n[\".xcassets\"]  = \"folder.assetcatalog\",\n[\".xcdatamodeld\"] = \"wrapper.xcdatamodeld\",\n[\".swift\"]     = \"sourcecode.swift\",\n}\nreturn types[path.getextension(node.path)] or\n(types[string.lower(path.getextension(node.path))] or \"text\")\nend\nfunction xcode.getfiletypeForced(node)\nlocal types = {\n[\".c\"]         = \"sourcecode.cpp.cpp\",\n[\".cc\"]        = \"sourcecode.cpp.cpp\",\n[\".cpp\"]       = \"sourcecode.cpp.cpp\",\n[\".css\"]       = \"text.css\",\n[\".cxx\"]       = \"sourcecode.cpp.cpp\",\n[\".c++\"]       = \"sourcecode.cpp.cpp\",\n[\".entitlements"
	"\"] = \"text.xml\",\n[\".bundle\"]    = \"wrapper.cfbundle\",\n[\".framework\"] = \"wrapper.framework\",\n[\".tbd\"]       = \"wrapper.framework\",\n[\".gif\"]       = \"image.gif\",\n[\".h\"]         = \"sourcecode.cpp.h\",\n[\".hh\"]        = \"sourcecode.cpp.h\",\n[\".hpp\"]       = \"sourcecode.cpp.h\",\n[\".hxx\"]       = \"sourcecode.cpp.h\",\n[\".inl\"]       = \"sourcecode.cpp.h\",\n[\".html\"]      = \"text.html\",\n[\".lua\"]       = \"sourcecode.lua\",\n[\".m\"]         = \"sourcecode.cpp.objcpp\",\n[\".mm\"]        = \"sourcecode.cpp.objcpp\",\n[\".nib\"]       = \"wrapper.nib\",\n[\".pch\"]       = \"sourcecode.cpp.h\",\n[\".plist\"]     = \"text.plist.xml\",\n[\".strings\"]   = \"text.plist.strings\",\n[\".xib\"]       = \"file.xib\",\n[\".icns\"]      = \"image.icns\",\n[\".bmp\"]       = \"image.bmp\",\n[\".wav\"]       = \"audio.wav\",\n[\".xcassets\"]  = \"folder.assetcatalog\",\n[\".xcdatamodeld\"] = \"wrapper.xcdatamodeld\",\n[\".swift\"]     = \"sourcecode.swift\",\n}\nreturn types[path.ge"
	"textension(node.path)] or\n(types[string.lower(path.getextension(node.path))] or \"text\")\nend\nfunction xcode.getproducttype(node)\nlocal types = {\nConsoleApp  = \"com.apple.product-type.tool\",\nWindowedApp = node.cfg.options.SkipBundling and \"com.apple.product-type.tool\" or \"com.apple.product-type.application\",\nStaticLib   = \"com.apple.product-type.library.static\",\nSharedLib   = \"com.apple.product-type.library.dynamic\",\nBundle      = node.cfg.options.SkipBundling and \"com.apple.product-type.tool\" or \"com.apple.product-type.bundle\",\n}\nreturn types[node.cfg.kind]\nend\nfunction xcode.gettargettype(node)\nlocal types = {\nConsoleApp  = \"\\\"compiled.mach-o.executable\\\"\",\nWindowedApp = node.cfg.options.SkipBundling and \"\\\"compiled.mach-o.executable\\\"\" or \"wrapper.application\",\nStaticLib   = \"archive.ar\",\nSharedLib   = \"\\\"compiled.mach-o.dylib\\\"\",\nBundle      = node.cfg.options.SkipBundling and \"\\\"compiled.mach-o.bundle\\\"\" or \"wrapper.cfbundle\",\n}\nreturn types"
	"[node.cfg.kind]\nend\nfunction xcode.getxcodeprojname(prj)\nlocal fname = premake.project.getfilename(prj, \"%%.xcodeproj\")\nreturn fname\nend\nfunction xcode.isframework(fname)\nreturn (path.getextension(fname) == \".framework\" or path.getextension(fname) == \".tbd\")\nend\nfunction xcode.uuid(param)\nreturn os.uuid(param):upper():gsub('-',''):sub(0,24)\nend\nfunction xcode.newid(node, usage)\nlocal base = ''\nlocal prj = node.project\nif prj == nil then\nlocal parent = node.parent\nwhile parent ~= nil do\nif parent.project ~= nil then\nprj = parent.project\nbreak\nend\nparent = parent.parent\nend\nend\nif prj ~= nil then\nprj.uuidcounter = (prj.uuidcounter or 0) + 1\nbase = base .. prj.name .. \"$\" .. prj.uuidcounter .. \"$\"\nend\nbase = base .. \"$\" .. (node.path or node.name or \"\")\nbase = base .. \"$\" .. (usage or \"\")\nreturn xcode.uuid(base)\nend\nfunction xcode.getscriptphaselabel(cmd, count, cfg)\nreturn string.format(\"\\\"Script Phase %s [%s] (%s)\\\"\", count, cmd:match(\"(%w+)(.+)\"), iif"
	"(cfg, xcode.getconfigname(cfg), \"all\"))\nend\nfunction xcode.getcopyphaselabel(type, count, target)\nreturn string.format(\"\\\"Copy %s %s [%s]\\\"\", type, count, target)\nend\nfunction xcode.preparesolution(sln)\nsln.xcode = { }\nsln.xcode.platforms = premake.filterplatforms(sln, premake.action.current().valid_platforms, \"Universal\")\nfor prj in premake.solution.eachproject(sln) do\nlocal cfg = premake.getconfig(prj, prj.configurations[1], sln.xcode.platforms[1])\nlocal node = premake.tree.new(path.getname(cfg.buildtarget.bundlepath))\nnode.cfg = cfg\nnode.id = premake.xcode.newid(node, \"product\")\nnode.targetid = premake.xcode.newid(node, \"target\")\nprj.xcode = {}\nprj.xcode.projectnode = node\nend\nend\nfunction xcode.printlist(list, tag, sort)\nif #list > 0 then\nif sort ~= nil and sort == true then\ntable.sort(list)\nend\n_p(4,'%s = (', tag)\nfor _, item in ipairs(list) do\nlocal escaped_item = item:gsub(\"\\\"\", \"\\\\\\\\\\\\\\\"\"):gsub(\"'\", \"\\\\\\\\'\")\n_p(5, '\"%s\",', escaped_item)\ne"
	"nd\n_p(4,');')\nend\nend\nfunction xcode.quotestr(str)\nif str:match(\"[^a-zA-Z0-9$._/]\") == nil then\nreturn str\nend\nreturn \"\\\"\" .. str:gsub(\"[\\\"\\\\\\\"]\", \"\\\\%0\") .. \"\\\"\"\nend\nfunction xcode.setdeploymenttarget(cfg, def, opts)\nlocal get_opt = function(opt, def)\nreturn (opt and #opt > 0) and opt or def\nend\nlocal iosversion = get_opt(cfg.iostargetplatformversion, def.iOSTargetPlatformVersion)\nlocal macosversion = get_opt(cfg.macostargetplatformversion, def.macOSTargetPlatformVersion)\nlocal tvosversion = get_opt(cfg.tvostargetplatformversion, def.tvOSTargetPlatformVersion)\nlocal visionosversion = get_opt(cfg.visionostargetplatformversion, def.visionOSTargetPlatformVersion)\nif iosversion then\nopts.IPHONEOS_DEPLOYMENT_TARGET = iosversion\nelseif macosversion then\nopts.MACOSX_DEPLOYMENT_TARGET = macosversion\nelseif tvosversion then\nopts.TVOS_DEPLOYMENT_TARGET = tvosversion\nelseif visionosversion then\nopts.XROS_DEPLOYMENT_TARGET = tvosversion\nend\nend\nfunction xcode.Header(tr, o"
	"bjversion)\n_p('// !$*UTF8*$!')\n_p('{')\n_p(1,'archiveVersion = 1;')\n_p(1,'classes = {')\n_p(1,'};')\n_p(1,'objectVersion = %d;', objversion)\n_p(1,'objects = {')\n_p('')\nend\nfunction xcode.PBXBuildFile(tr)\nlocal function gatherCopyFiles(which)\nlocal copyfiles = {}\nlocal targets = tr.project[which]\nif #targets > 0 then\nfor _, t in ipairs(targets) do\nfor __, tt in ipairs(t) do\ntable.insertflat(copyfiles, tt[2])\nend\nend\nend\nreturn table.translate(copyfiles, path.getname)\nend\nlocal function gatherCopyFrameworks(which)\nlocal copyfiles = {}\nlocal targets = tr.project[which]\nif #targets > 0 then\ntable.insertflat(copyfiles, targets)\nend\nreturn table.translate(copyfiles, path.getname)\nend\nlocal copyfiles = table.flatten({\ngatherCopyFiles('xcodecopyresources'),\ngatherCopyFrameworks('xcodecopyframeworks')\n})\n_p('/* Begin PBXBuildFile section */')\ntree.traverse(tr, {\nonnode = function(node)\nif node.buildid then\n_p(2,'%s /* %s in %s */ = {isa = PBXBuildFile; fileRef = %s /* %s */; };',\nno"
	"de.buildid, node.name, xcode.getbuildcategory(node), node.id, node.name)\nend\nif table.icontains(copyfiles, node.name) then\n_p(2,'%s /* %s in %s */ = {isa = PBXBuildFile; fileRef = %s /* %s */; %s };',\nxcode.uuid(node.name .. 'in CopyFiles'), node.name, 'CopyFiles', node.id, node.name,\niif(xcode.isframework(node.name), \"settings = {ATTRIBUTES = (CodeSignOnCopy, ); };\", \"\")\n)\nend\nend\n})\n_p('/* End PBXBuildFile section */')\n_p('')\nend\nfunction xcode.PBXContainerItemProxy(tr)\nif #tr.projects.children > 0 then\n_p('/* Begin PBXContainerItemProxy section */')\nfor _, node in ipairs(tr.projects.children) do\n_p(2,'%s /* PBXContainerItemProxy */ = {', node.productproxyid)\n_p(3,'isa = PBXContainerItemProxy;')\n_p(3,'containerPortal = %s /* %s */;', node.id, path.getname(node.path))\n_p(3,'proxyType = 2;')\n_p(3,'remoteGlobalIDString = %s;', node.project.xcode.projectnode.id)\n_p(3,'remoteInfo = \"%s\";', node.project.xcode.projectnode.name)\n_p(2,'};')\n_p(2,'%s /* PBXContainerItemProxy */ = {', node"
	".targetproxyid)\n_p(3,'isa = PBXContainerItemProxy;')\n_p(3,'containerPortal = %s /* %s */;', node.id, path.getname(node.path))\n_p(3,'proxyType = 1;')\n_p(3,'remoteGlobalIDString = %s;', node.project.xcode.projectnode.targetid)\n_p(3,'remoteInfo = \"%s\";', node.project.xcode.projectnode.name)\n_p(2,'};')\nend\n_p('/* End PBXContainerItemProxy section */')\n_p('')\nend\nend\nfunction xcode.PBXFileReference(tr,prj)\n_p('/* Begin PBXFileReference section */')\ntree.traverse(tr, {\nonleaf = function(node)\nif not node.path then\nreturn\nend\nif node.kind == \"product\" then\n_p(2,'%s /* %s */ = {isa = PBXFileReference; explicitFileType = %s; includeInIndex = 0; name = \"%s\"; path = \"%s\"; sourceTree = BUILT_PRODUCTS_DIR; };',\nnode.id, node.name, xcode.gettargettype(node), node.name, path.getname(node.cfg.buildtarget.bundlepath))\nelseif node.parent.parent == tr.projects then\nlocal relpath = path.getrelative(tr.project.location, node.parent.project.location)\n_p(2,'%s /* %s */ = {isa = PBXFileReference; lastK"
	"nownFileType = \"wrapper.pb-project\"; name = \"%s\"; path = \"%s\"; sourceTree = SOURCE_ROOT; };',\nnode.parent.id, node.parent.name, node.parent.name, path.join(relpath, node.parent.name))\nelse\nlocal pth, src\nif xcode.isframework(node.path) then\nlocal nodePath = node.path\nlocal _, matchEnd, variable = string.find(nodePath, \"^%$%((.+)%)/\")\nif variable then\nnodePath = string.sub(nodePath, matchEnd + 1)\nend\nif string.find(nodePath,'/')  then\nif string.find(nodePath,'^%.')then\nnodePath = path.getabsolute(path.join(tr.project.location, nodePath))\nend\npth = nodePath\nelseif path.getextension(nodePath)=='.tbd' then\npth = \"/usr/lib/\" .. nodePath\nelse\npth = \"/System/Library/Frameworks/\" .. nodePath\nend\nif variable then\nsrc = variable\nif string.find(pth, '^/') then\npth = string.sub(pth, 2)\nend\nelse\nsrc = \"<absolute>\"\nend\nelse\nsrc = \"<group>\"\nif node.location then\npth = node.location\nelseif node.parent.isvpath then\npth = node.cfg.name\nelse\npth = tree.getlocalpath(node)\nend\ne"
	"nd\nif (not prj.options.ForceCPP) then\n_p(2,'%s /* %s */ = {isa = PBXFileReference; lastKnownFileType = %s; name = \"%s\"; path = \"%s\"; sourceTree = \"%s\"; };',\nnode.id, node.name, xcode.getfiletype(node), node.name, pth, src)\nelse\n_p(2,'%s /* %s */ = {isa = PBXFileReference; explicitFileType = %s; name = \"%s\"; path = \"%s\"; sourceTree = \"%s\"; };',\nnode.id, node.name, xcode.getfiletypeForced(node), node.name, pth, src)\nend\nend\nend\n})\n_p('/* End PBXFileReference section */')\n_p('')\nend\nfunction xcode.PBXFrameworksBuildPhase(tr)\n_p('/* Begin PBXFrameworksBuildPhase section */')\n_p(2,'%s /* Frameworks */ = {', tr.products.children[1].fxstageid)\n_p(3,'isa = PBXFrameworksBuildPhase;')\n_p(3,'buildActionMask = 2147483647;')\n_p(3,'files = (')\ntree.traverse(tr.frameworks, {\nonleaf = function(node)\n_p(4,'%s /* %s in Frameworks */,', node.buildid, node.name)\nend\n})\ntree.traverse(tr.projects, {\nonleaf = function(node)\n_p(4,'%s /* %s in Frameworks */,', node.buildid, node.name)\nend\n})\n_"
	"p(3,');')\n_p(3,'runOnlyForDeploymentPostprocessing = 0;')\n_p(2,'};')\n_p('/* End PBXFrameworksBuildPhase section */')\n_p('')\nend\nfunction xcode.PBXGroup(tr)\n_p('/* Begin PBXGroup section */')\ntree.traverse(tr, {\nonnode = function(node)\nif (node.path and #node.children == 0) or node.kind == \"vgroup\" then\nreturn\nend\nif node.parent == tr.projects then\n_p(2,'%s /* Products */ = {', node.productgroupid)\nelse\n_p(2,'%s /* %s */ = {', node.id, node.name)\nend\n_p(3,'isa = PBXGroup;')\n_p(3,'children = (')\nfor _, childnode in ipairs(node.children) do\n_p(4,'%s /* %s */,', childnode.id, childnode.name)\nend\n_p(3,');')\nif node.parent == tr.projects then\n_p(3,'name = Products;')\nelse\n_p(3,'name = \"%s\";', node.name)\nif node.location then\n_p(3,'path = \"%s\";', node.location)\nelseif node.path and not node.isvpath then\nlocal p = node.path\nif node.parent.path then\np = path.getrelative(node.parent.path, node.path)\nend\n_p(3,'path = \"%s\";', p)\nend\nend\n_p(3,'sourceTree = \"<group>\";')\n_p(2,"
	"'};')\nend\n}, true)\n_p('/* End PBXGroup section */')\n_p('')\nend\nfunction xcode.PBXNativeTarget(tr)\n_p('/* Begin PBXNativeTarget section */')\nfor _, node in ipairs(tr.products.children) do\nlocal name = tr.project.name\nlocal function hasBuildCommands(which)\nif #tr.project[which] > 0 then\nreturn true\nend\nfor _, cfg in ipairs(tr.configs) do\nif #cfg[which] > 0 then\nreturn true\nend\nend\nend\nlocal function dobuildblock(id, label, which, action)\nif hasBuildCommands(which) then\nlocal commandcount = 0\nfor _, cfg in ipairs(tr.configs) do\ncommandcount = commandcount + #cfg[which]\nend\nif commandcount > 0 then\naction(id, label)\nend\nend\nend\nlocal function doscriptphases(which, action)\nlocal i = 0\nfor _, cfg in ipairs(tr.configs) do\nlocal cfgcmds = cfg[which]\nif cfgcmds ~= nil then\nfor __, scripts in ipairs(cfgcmds) do\nfor ___, script in ipairs(scripts) do\nlocal cmd = script[1]\nlocal label = xcode.getscriptphaselabel(cmd, i, cfg)\nlocal id = xcode.uuid(label)\naction(id, label)\ni = i + 1"
	"\nend\nend\nend\nend\nend\nlocal function docopyresources(which, action)\nif hasBuildCommands(which) then\nlocal targets = tr.project[which]\nif #targets > 0 then\nlocal i = 0\nfor _, t in ipairs(targets) do\nfor __, tt in ipairs(t) do\nlocal label = xcode.getcopyphaselabel('Resources', i, tt[1])\nlocal id = xcode.uuid(label)\naction(id, label)\ni = i + 1\nend\nend\nend\nend\nend\nlocal function docopyframeworks(which, action)\nif hasBuildCommands(which) then\nlocal targets = tr.project[which]\nif #targets > 0 then\nlocal label = \"Copy Frameworks\"\nlocal id = xcode.uuid(label)\naction(id, label)\nend\nend\nend\nlocal function _p_label(id, label)\n_p(4, '%s /* %s */,', id, label)\nend\n_p(2,'%s /* %s */ = {', node.targetid, name)\n_p(3,'isa = PBXNativeTarget;')\n_p(3,'buildConfigurationList = %s /* Build configuration list for PBXNativeTarget \"%s\" */;', node.cfgsection, name)\n_p(3,'buildPhases = (')\ndobuildblock('9607AE1010C857E500CD1376', 'Prebuild', 'prebuildcommands', _p_label)\n_p(4,'%s /* Resources *"
	"/,', node.resstageid)\n_p(4,'%s /* Sources */,', node.sourcesid)\ndobuildblock('9607AE3510C85E7E00CD1376', 'Prelink', 'prelinkcommands', _p_label)\n_p(4,'%s /* Frameworks */,', node.fxstageid)\ndobuildblock('9607AE3710C85E8F00CD1376', 'Postbuild', 'postbuildcommands', _p_label)\ndoscriptphases(\"xcodescriptphases\", _p_label)\ndocopyresources(\"xcodecopyresources\", _p_label)\nif tr.project.kind == \"WindowedApp\" then\ndocopyframeworks(\"xcodecopyframeworks\", _p_label)\nend\n_p(3,');')\n_p(3,'buildRules = (')\n_p(3,');')\n_p(3,'dependencies = (')\nfor _, node in ipairs(tr.projects.children) do\n_p(4,'%s /* PBXTargetDependency */,', node.targetdependid)\nend\n_p(3,');')\n_p(3,'name = \"%s\";', name)\nlocal p\nif node.cfg.kind == \"ConsoleApp\" then\np = \"$(HOME)/bin\"\nelseif node.cfg.kind == \"WindowedApp\" then\np = \"$(HOME)/Applications\"\nend\nif p then\n_p(3,'productInstallPath = \"%s\";', p)\nend\n_p(3,'productName = \"%s\";', name)\n_p(3,'productReference = %s /* %s */;', node.id, node.name)\n_p(3,'p"
	"roductType = \"%s\";', xcode.getproducttype(node))\n_p(2,'};')\nend\n_p('/* End PBXNativeTarget section */')\n_p('')\nend\nfunction xcode.PBXProject(tr, compatVersion)\n_p('/* Begin PBXProject section */')\n_p(2,'__RootObject_ /* Project object */ = {')\n_p(3,'isa = PBXProject;')\n_p(3,'buildConfigurationList = 1DEB928908733DD80010E9CD /* Build configuration list for PBXProject \"%s\" */;', tr.name)\n_p(3,'compatibilityVersion = \"Xcode %s\";', compatVersion)\n_p(3,'hasScannedForEncodings = 1;')\n_p(3,'mainGroup = %s /* %s */;', tr.id, tr.name)\n_p(3,'projectDirPath = \"\";')\nif #tr.projects.children > 0 then\n_p(3,'projectReferences = (')\nfor _, node in ipairs(tr.projects.children) do\n_p(4,'{')\n_p(5,'ProductGroup = %s /* Products */;', node.productgroupid)\n_p(5,'ProjectRef = %s /* %s */;', node.id, path.getname(node.path))\n_p(4,'},')\nend\n_p(3,');')\nend\n_p(3,'projectRoot = \"\";')\n_p(3,'targets = (')\nfor _, node in ipairs(tr.products.children) do\n_p(4,'%s /* %s */,', node.targetid, node.name)\nend"
	"\n_p(3,');')\n_p(2,'};')\n_p('/* End PBXProject section */')\n_p('')\nend\nfunction xcode.PBXReferenceProxy(tr)\nif #tr.projects.children > 0 then\n_p('/* Begin PBXReferenceProxy section */')\ntree.traverse(tr.projects, {\nonleaf = function(node)\n_p(2,'%s /* %s */ = {', node.id, node.name)\n_p(3,'isa = PBXReferenceProxy;')\n_p(3,'fileType = %s;', xcode.gettargettype(node))\n_p(3,'path = \"%s\";', node.path)\n_p(3,'remoteRef = %s /* PBXContainerItemProxy */;', node.parent.productproxyid)\n_p(3,'sourceTree = BUILT_PRODUCTS_DIR;')\n_p(2,'};')\nend\n})\n_p('/* End PBXReferenceProxy section */')\n_p('')\nend\nend\nfunction xcode.PBXResourcesBuildPhase(tr)\n_p('/* Begin PBXResourcesBuildPhase section */')\nfor _, target in ipairs(tr.products.children) do\n_p(2,'%s /* Resources */ = {', target.resstageid)\n_p(3,'isa = PBXResourcesBuildPhase;')\n_p(3,'buildActionMask = 2147483647;')\n_p(3,'files = (')\ntree.traverse(tr, {\nonnode = function(node)\nif xcode.getbuildcategory(node) == \"Resources\" then\n_p(4,'%s /* %s "
	"in Resources */,', node.buildid, node.name)\nend\nend\n})\n_p(3,');')\n_p(3,'runOnlyForDeploymentPostprocessing = 0;')\n_p(2,'};')\nend\n_p('/* End PBXResourcesBuildPhase section */')\n_p('')\nend\nfunction xcode.PBXShellScriptBuildPhase(tr)\nlocal wrapperWritten = false\nlocal function doblock(id, name, commands, files)\nif commands ~= nil then\ncommands = table.flatten(commands)\nend\nif #commands > 0 then\nif not wrapperWritten then\n_p('/* Begin PBXShellScriptBuildPhase section */')\nwrapperWritten = true\nend\n_p(2,'%s /* %s */ = {', id, name)\n_p(3,'isa = PBXShellScriptBuildPhase;')\n_p(3,'buildActionMask = 2147483647;')\n_p(3,'files = (')\n_p(3,');')\n_p(3,'inputPaths = (');\nif files ~= nil then\nfiles = table.flatten(files)\nif #files > 0 then\nfor _, file in ipairs(files) do\n_p(4, '\"%s\",', file)\nend\nend\nend\n_p(3,');');\n_p(3,'name = %s;', name);\n_p(3,'outputPaths = (');\n_p(3,');');\n_p(3,'runOnlyForDeploymentPostprocessing = 0;');\n_p(3,'shellPath = /bin/sh;');\n_p(3,'shellScript = \"%s\";',"
	" table.concat(commands, \"\\\\n\"):gsub('\"', '\\\\\"'))\n_p(2,'};')\nend\nend\nlocal function wrapcommands(cmds, cfg)\nlocal commands = {}\nif #cmds > 0 then\ntable.insert(commands, 'if [ \"${CONFIGURATION}\" = \"' .. xcode.getconfigname(cfg) .. '\" ]; then')\nfor i = 1, #cmds do\nlocal cmd = cmds[i]\ncmd = cmd:gsub('\\\\','\\\\\\\\')\ntable.insert(commands, cmd)\nend\ntable.insert(commands, 'fi')\nend\nreturn commands\nend\nlocal function dobuildblock(id, name, which)\nlocal commands = {}\nfor _, cfg in ipairs(tr.configs) do\nlocal cfgcmds = wrapcommands(cfg[which], cfg)\nif #cfgcmds > 0 then\nfor i, cmd in ipairs(cfgcmds) do\ntable.insert(commands, cmd)\nend\nend\nend\ndoblock(id, name, commands)\nend\nlocal function doscriptphases(which)\nlocal i = 0\nfor _, cfg in ipairs(tr.configs) do\nlocal cfgcmds = cfg[which]\nif cfgcmds ~= nil then\nfor __, scripts in ipairs(cfgcmds) do\nfor ___, script in ipairs(scripts) do\nlocal cmd = script[1]\nlocal files = script[2]\nlocal label = xcode.getscriptphaselabel(cmd,"
	" i, cfg)\nlocal id = xcode.uuid(label)\ndoblock(id, label, wrapcommands({cmd}, cfg), files)\ni = i + 1\nend\nend\nend\nend\nend\ndobuildblock(\"9607AE1010C857E500CD1376\", \"Prebuild\", \"prebuildcommands\")\ndobuildblock(\"9607AE3510C85E7E00CD1376\", \"Prelink\", \"prelinkcommands\")\ndobuildblock(\"9607AE3710C85E8F00CD1376\", \"Postbuild\", \"postbuildcommands\")\ndoscriptphases(\"xcodescriptphases\")\nif wrapperWritten then\n_p('/* End PBXShellScriptBuildPhase section */')\nend\nend\nfunction xcode.PBXSourcesBuildPhase(tr,prj)\n_p('/* Begin PBXSourcesBuildPhase section */')\nfor _, target in ipairs(tr.products.children) do\n_p(2,'%s /* Sources */ = {', target.sourcesid)\n_p(3,'isa = PBXSourcesBuildPhase;')\n_p(3,'buildActionMask = 2147483647;')\n_p(3,'files = (')\ntree.traverse(tr, {\nonleaf = function(node)\nif xcode.getbuildcategory(node) == \"Sources\" then\nif not table.icontains(prj.excludes, node.cfg.name) then -- if not excluded\n_p(4,'%s /* %s in Sources */,', node.buildid, node.name)\nend\nend\nend"
	"\n})\n_p(3,');')\n_p(3,'runOnlyForDeploymentPostprocessing = 0;')\n_p(2,'};')\nend\n_p('/* End PBXSourcesBuildPhase section */')\n_p('')\nend\nfunction xcode.PBXCopyFilesBuildPhase(tr)\nlocal wrapperWritten = false\nlocal function doblock(id, name, folderSpec, path, files)\nif #files > 0 then\nif not wrapperWritten then\n_p('/* Begin PBXCopyFilesBuildPhase section */')\nwrapperWritten = true\nend\n_p(2,'%s /* %s */ = {', id, name)\n_p(3,'isa = PBXCopyFilesBuildPhase;')\n_p(3,'buildActionMask = 2147483647;')\n_p(3,'dstPath = \\\"%s\\\";', path)\n_p(3,'dstSubfolderSpec = \\\"%s\\\";', folderSpec)\n_p(3,'files = (')\ntree.traverse(tr, {\nonleaf = function(node)\nif table.icontains(files, node.name) then\n_p(4,'%s /* %s in %s */,',\nxcode.uuid(node.name .. 'in CopyFiles'), node.name, 'CopyFiles')\nend\nend\n})\n_p(3,');')\n_p(3,'runOnlyForDeploymentPostprocessing = 0;');\n_p(2,'};')\nend\nend\nlocal function docopyresources(which)\nlocal targets = tr.project[which]\nif #targets > 0 then\nlocal i = 0\nfor _, t in i"
	"pairs(targets) do\nfor __, tt in ipairs(t) do\nlocal label = xcode.getcopyphaselabel('Resources', i, tt[1])\nlocal id = xcode.uuid(label)\nlocal files = table.translate(table.flatten(tt[2]), path.getname)\ndoblock(id, label, 7, tt[1], files)\ni = i + 1\nend\nend\nend\nend\nlocal function docopyframeworks(which)\nlocal targets = tr.project[which]\nif #targets > 0 then\nlocal label = \"Copy Frameworks\"\nlocal id = xcode.uuid(label)\nlocal files = table.translate(table.flatten(targets), path.getname)\ndoblock(id, label, 10, \"\", files)\nend\nend\ndocopyresources(\"xcodecopyresources\")\nif tr.project.kind == \"WindowedApp\" then\ndocopyframeworks(\"xcodecopyframeworks\")\nend\nif wrapperWritten then\n_p('/* End PBXCopyFilesBuildPhase section */')\nend\nend\nfunction xcode.PBXVariantGroup(tr)\n_p('/* Begin PBXVariantGroup section */')\ntree.traverse(tr, {\nonbranch = function(node)\nif node.kind == \"vgroup\" then\n_p(2,'%s /* %s */ = {', node.id, node.name)\n_p(3,'isa = PBXVariantGroup;')\n_p(3,'children = (')"
	"\nfor _, lang in ipairs(node.children) do\n_p(4,'%s /* %s */,', lang.id, lang.name)\nend\n_p(3,');')\n_p(3,'name = %s;', node.name)\n_p(3,'sourceTree = \"<group>\";')\n_p(2,'};')\nend\nend\n})\n_p('/* End PBXVariantGroup section */')\n_p('')\nend\nfunction xcode.PBXTargetDependency(tr)\nif #tr.projects.children > 0 then\n_p('/* Begin PBXTargetDependency section */')\ntree.traverse(tr.projects, {\nonleaf = function(node)\n_p(2,'%s /* PBXTargetDependency */ = {', node.parent.targetdependid)\n_p(3,'isa = PBXTargetDependency;')\n_p(3,'name = \"%s\";', node.name)\n_p(3,'targetProxy = %s /* PBXContainerItemProxy */;', node.parent.targetproxyid)\n_p(2,'};')\nend\n})\n_p('/* End PBXTargetDependency section */')\n_p('')\nend\nend\nfunction xcode.cfg_excluded_files(prj, cfg)\nlocal excluded = {}\nlocal function exclude_pattern(file)\nif path.isabsolute(file) then\nreturn file\nend\nlocal start, term = file:findlast(\"/%.%./\")\nif term then\nreturn path.join(\"*\", file:sub(term + 1))\nend\nstart, term = file:find(\"%.%"
	"./\")\nif start == 1 then\nreturn path.join(\"*\", file:sub(term + 1))\nend\nreturn path.join(\"*\", file)\nend\nlocal function add_file(file)\nlocal name = exclude_pattern(file)\nif not table.icontains(excluded, name) then\ntable.insert(excluded, name)\nend\nend\nlocal function verify_file(file)\nlocal name = exclude_pattern(file)\nif table.icontains(excluded, name) then\nerror(\"'\" .. file .. \"' would be excluded by the rule to exclude '\" .. name .. \"'\")\nend\nend\nfor _, file in ipairs(cfg.excludes) do\nadd_file(file)\nend\nfor _, file in ipairs(prj.allfiles) do\nif not table.icontains(prj.excludes, file) and not table.icontains(cfg.excludes, file) then\nif not table.icontains(cfg.files, file) then\nadd_file(file)\nelse\nverify_file(file)\nend\nend\nend\ntable.sort(excluded)\nreturn excluded\nend\nfunction xcode.XCBuildConfiguration_Impl(tr, id, opts, cfg)\nlocal cfgname = xcode.getconfigname(cfg)\n_p(2,'%s /* %s */ = {', id, cfgname)\n_p(3,'isa = XCBuildConfiguration;')\n_p(3,'buildSettings = {')\nfor"
	" k, v in table.sortedpairs(opts) do\nif type(v) == \"table\" then\nif #v > 0 then\n_p(4,'%s = (', k)\nfor i, v2 in ipairs(v) do\n_p(5,'%s,', xcode.quotestr(tostring(v2)))\nend\n_p(4,');')\nend\nelse\n_p(4,'%s = %s;', k, xcode.quotestr(tostring(v)))\nend\nend\n_p(3,'};')\n_p(3,'name = %s;', xcode.quotestr(cfgname))\n_p(2,'};')\nend\nlocal function add_options(options, extras)\nfor _, tbl in ipairs(extras) do\nfor tkey, tval in pairs(tbl) do\noptions[tkey] = tval\nend\nend\nend\nlocal function add_wholearchive_links(opts, cfg)\nif #cfg.wholearchive > 0 then\nlocal linkopts = {}\nfor _, depcfg in ipairs(premake.getlinks(cfg, \"siblings\", \"object\")) do\nif table.icontains(cfg.wholearchive, depcfg.project.name) then\nlocal linkpath = path.rebase(depcfg.linktarget.fullpath, depcfg.location, cfg.location)\ntable.insert(linkopts, \"-force_load\")\ntable.insert(linkopts, linkpath)\nend\nend\nif opts.OTHER_LDFLAGS then\nlinkopts = table.join(linkopts, opts.OTHER_LDFLAGS)\nend\nopts.OTHER_LDFLAGS = linkopts\nend\nend"
	"\nfunction xcode.XCBuildConfiguration(tr, prj, opts)\n_p('/* Begin XCBuildConfiguration section */')\nfor _, target in ipairs(tr.products.children) do\nfor _, cfg in ipairs(tr.configs) do\nlocal values = opts.ontarget(tr, target, cfg)\nadd_options(values, cfg.xcodetargetopts)\nxcode.XCBuildConfiguration_Impl(tr, cfg.xcode.targetid, values, cfg)\nend\nend\nfor _, cfg in ipairs(tr.configs) do\nlocal values = opts.onproject(tr, prj, cfg)\nadd_options(values, cfg.xcodeprojectopts)\nadd_wholearchive_links(values, cfg)\nxcode.XCBuildConfiguration_Impl(tr, cfg.xcode.projectid, values, cfg)\nend\n_p('/* End XCBuildConfiguration section */')\n_p('')\nend\nfunction xcode.XCBuildConfigurationList(tr)\nlocal sln = tr.project.solution\n_p('/* Begin XCConfigurationList section */')\nfor _, target in ipairs(tr.products.children) do\n_p(2,'%s /* Build configuration list for PBXNativeTarget \"%s\" */ = {', target.cfgsection, target.name)\n_p(3,'isa = XCConfigurationList;')\n_p(3,'buildConfigurations = (')\nfor _, cfg in ipairs"
	"(tr.configs) do\n_p(4,'%s /* %s */,', cfg.xcode.targetid, xcode.getconfigname(cfg))\nend\n_p(3,');')\n_p(3,'defaultConfigurationIsVisible = 0;')\n_p(3,'defaultConfigurationName = \"%s\";', xcode.getconfigname(tr.configs[1]))\n_p(2,'};')\nend\n_p(2,'1DEB928908733DD80010E9CD /* Build configuration list for PBXProject \"%s\" */ = {', tr.name)\n_p(3,'isa = XCConfigurationList;')\n_p(3,'buildConfigurations = (')\nfor _, cfg in ipairs(tr.configs) do\n_p(4,'%s /* %s */,', cfg.xcode.projectid, xcode.getconfigname(cfg))\nend\n_p(3,');')\n_p(3,'defaultConfigurationIsVisible = 0;')\n_p(3,'defaultConfigurationName = \"%s\";', xcode.getconfigname(tr.configs[1]))\n_p(2,'};')\n_p('/* End XCConfigurationList section */')\n_p('')\nend\nfunction xcode.versionge(version, reference)\nlocal vparts = string.explode(version, \".\", true)\nlocal rparts = string.explode(reference, \".\", true)\nfor i=1,#rparts do\nlocal rnum = tonumber(rparts[i]) or 0\nlocal vnum = tonumber(vparts[i]) or 0\nif vnum < rnum then\nreturn false\nend\nend"
	"\nreturn true\nend\nfunction xcode.Footer()\n_p(1,'};')\n_p('\\trootObject = __RootObject_ /* Project object */;')\n_p('}')\nend\n",

	/* actions/xcode/xcode_project.lua */
	"local xcode = premake.xcode\nlocal tree = premake.tree\nfunction xcode.buildprjtree(prj)\nlocal tr = premake.project.buildsourcetree(prj, true)\ntr.configs = {}\nfor _, cfgname in ipairs(prj.solution.configurations) do\nfor _, platform in ipairs(prj.solution.xcode.platforms) do\nlocal cfg = premake.getconfig(prj, cfgname, platform)\ncfg.xcode = {}\ncfg.xcode.targetid = xcode.newid(prj.xcode.projectnode, \"tgt:\"..platform..cfgname)\ncfg.xcode.projectid = xcode.newid(tr, \"prj:\"..platform..cfgname)\ntable.insert(tr.configs, cfg)\nend\nend\ntree.traverse(tr, {\nonbranch = function(node)\nif path.getextension(node.name) == \".lproj\" then\nlocal lang = path.getbasename(node.name)  -- \"English\", \"French\", etc.\nfor _, filenode in ipairs(node.children) do\nlocal grpnode = node.parent.children[filenode.name]\nif not grpnode then\ngrpnode = tree.insert(node.parent, tree.new(filenode.name))\ngrpnode.kind = \"vgroup\"\nend\nfilenode.name = path.getbasename(lang)\ntree.insert(grpnode, filenode)\nend\ntree.remove(no"
	"de)\nend\nend\n})\ntree.traverse(tr, {\nonbranch = function(node)\nif path.getextension(node.name) == \".xcassets\" then\nnode.children = {}\nend\nend\n})\ntr.frameworks = tree.new(\"Frameworks\")\nfor cfg in premake.eachconfig(prj) do\nfor _, link in ipairs(premake.getlinks(cfg, \"system\", \"fullpath\")) do\nlocal name = path.getname(link)\nif xcode.isframework(name) and not tr.frameworks.children[name] then\nnode = tree.insert(tr.frameworks, tree.new(name))\nnode.path = link\nend\nend\nend\nif #tr.frameworks.children > 0 then\ntree.insert(tr, tr.frameworks)\nend\ntr.products = tree.insert(tr, tree.new(\"Products\"))\ntr.projects = tree.new(\"Projects\")\nfor _, dep in ipairs(premake.getdependencies(prj, \"sibling\", \"object\")) do\nlocal xcpath = xcode.getxcodeprojname(dep)\nlocal xcnode = tree.insert(tr.projects, tree.new(path.getname(xcpath)))\nxcnode.path = xcpath\nxcnode.project = dep\nxcnode.productgroupid = xcode.newid(xcnode, \"prodgrp\")\nxcnode.productproxyid = xcode.newid(xcnode, \"prodprox\")\nx"
	"cnode.targetproxyid  = xcode.newid(xcnode, \"targprox\")\nxcnode.targetdependid = xcode.newid(xcnode, \"targdep\")\nlocal cfg = premake.getconfig(dep, prj.configurations[1])\nnode = tree.insert(xcnode, tree.new(cfg.linktarget.name))\nnode.path = cfg.linktarget.fullpath\nnode.cfg = cfg\nend\nif #tr.projects.children > 0 then\ntree.insert(tr, tr.projects)\nend\ntree.traverse(tr, {\nonbranchexit = function(node)\nfor _, child in ipairs(node.children) do\nif (child.location) then\nif (node.location) then\nwhile (not string.startswith(child.location, node.location)) do\nnode.location = path.getdirectory(node.location)\nend\nelse\nnode.location = path.getdirectory(child.location)\nend\nend\nend\nend,\nonleaf = function(node)\nif (node.cfg) then\nnode.location = node.cfg.name\nend\nend\n}, true)\ntree.traverse(tr, {\nonbranchexit = function(node, depth)\nif (node.location and node.parent and node.parent.location) then\nnode.location = path.getrelative(node.parent.location, node.location)\nend\nend,\nonleaf = function"
	"(node, depth)\nif (node.location and node.parent and node.parent.location) then\nnode.location = path.getrelative(node.parent.location, node.location)\nend\nend\n}, true)\ntree.traverse(tr, {\nonnode = function(node)\nnode.id = xcode.newid(node)\nif xcode.getbuildcategory(node) then\nnode.buildid = xcode.newid(node, \"build\")\nend\nif string.endswith(node.name, \"Info.plist\") then\ntr.infoplist = node\nend\nif string.endswith(node.name, \".entitlements\") then\ntr.entitlements = node\nend\nend\n}, true)\nnode = tree.insert(tr.products, prj.xcode.projectnode)\nnode.kind = \"product\"\nnode.path = node.cfg.buildtarget.fullpath\nnode.cfgsection = xcode.newid(node, \"cfg\")\nnode.resstageid = xcode.newid(node, \"rez\")\nnode.sourcesid  = xcode.newid(node, \"src\")\nnode.fxstageid  = xcode.newid(node, \"fxs\")\nreturn tr\nend\n",

	/* actions/xcode/xcode_scheme.lua */
	"local premake = premake\nlocal xcode   = premake.xcode\nlocal function buildableref(indent, prj, cfg)\ncfg = cfg or premake.eachconfig(prj)()\n_p(indent + 0, '<BuildableReference')\n_p(indent + 1, 'BuildableIdentifier = \"primary\"')\n_p(indent + 1, 'BlueprintIdentifier = \"%s\"', prj.xcode.projectnode.targetid)\n_p(indent + 1, 'BuildableName = \"%s\"', cfg.buildtarget.name)\n_p(indent + 1, 'BlueprintName = \"%s\"', prj.name)\n_p(indent + 1, 'ReferencedContainer = \"container:%s.xcodeproj\">', prj.name)\n_p(indent + 0, '</BuildableReference>')\nend\nlocal function cmdlineargs(indent, cfg)\nif #cfg.debugargs > 0 then\n_p(indent, '<CommandLineArguments>')\nfor _, arg in ipairs(cfg.debugargs) do\n_p(indent + 1, '<CommandLineArgument')\n_p(indent + 2, 'argument = \"%s\"', arg)\n_p(indent + 2, 'isEnabled = \"YES\">')\n_p(indent + 1, '</CommandLineArgument>')\nend\n_p(indent, '</CommandLineArguments>')\nend\nend\nlocal function envvars(indent, cfg)\nif #cfg.debugenvs > 0 then\n_p(indent, '<EnvironmentVariables>')\nf"
	"or _, arg in ipairs(cfg.debugenvs) do\nlocal eq = arg:find(\"=\")\nlocal k = arg:sub(1, eq)\nlocal v = arg:sub(eq + 1)\n_p(indent + 1, '<EnvironmentVariable')\n_p(indent + 2, 'key = \"%s\"', arg:sub(1, eq))\n_p(indent + 2, 'value = \"%s\"', arg:sub(eq))\n_p(indent + 2, 'isEnabled = \"YES\">')\n_p(indent + 1, '</EnvironmentVariable>')\nend\n_p(indent, '</EnvironmentVariables>')\nend\nend\nlocal function workingdir(dir)\nif not path.isabsolute(dir) then\ndir = \"$PROJECT_DIR/\" .. dir\nend\nreturn dir\nend\nlocal function bestconfig(prj, fordebug)\nlocal bestcfg = nil\nlocal bestscore = -1\nfor cfg in premake.eachconfig(prj) do\nlocal score = 0\nif cfg.platform == \"Native\" then\nscore = score + 10\nend\nif fordebug and cfg.name == \"Debug\" then\nscore = score + 1\nend\nif not fordebug and cfg.name == \"Release\" then\nscore = score + 1\nend\nif score > bestscore then\nbestcfg = cfg\nbestscore = score\nend\nend\nreturn bestcfg\nend\nfunction xcode.scheme(tobuild, primary, schemecfg)\n_p('<?xml version=\"1.0\" "
	"encoding=\"UTF-8\"?>')\n_p('<Scheme')\n_p(1, 'LastUpgradeVersion = \"0940\"')\n_p(1, 'version = \"1.3\">')\n_p(1, '<BuildAction')\n_p(2, 'parallelizeBuildables = \"YES\"')\n_p(2, 'buildImplicitDependencies = \"YES\">')\n_p(2, '<BuildActionEntries>')\nfor _, prj in ipairs(tobuild) do\n_p(3, '<BuildActionEntry')\n_p(4, 'buildForTesting = \"YES\"')\n_p(4, 'buildForRunning = \"YES\"')\n_p(4, 'buildForProfiling = \"YES\"')\n_p(4, 'buildForArchiving = \"YES\"')\n_p(4, 'buildForAnalyzing = \"YES\">')\nbuildableref(4, prj)\n_p(3, '</BuildActionEntry>')\nend\nlocal debugcfg    = schemecfg or bestconfig(primary, true)\nlocal releasecfg  = schemecfg or bestconfig(primary, false)\nlocal debugname   = xcode.getconfigname(debugcfg)\nlocal releasename = xcode.getconfigname(releasecfg)\n_p(2, '</BuildActionEntries>')\n_p(1, '</BuildAction>')\n_p(1, '<TestAction')\n_p(2, 'buildConfiguration = \"%s\"', debugname)\n_p(2, 'selectedDebuggerIdentifier = \"Xcode.DebuggerFoundation.Debugger.LLDB\"')\n_p(2, 'selectedLauncherIdentifier"
	" = \"Xcode.DebuggerFoundation.Launcher.LLDB\"')\n_p(2, 'shouldUseLaunchSchemeArgsEnv = \"YES\">')\n_p(2, '<Testables>')\n_p(2, '</Testables>')\n_p(2, '<MacroExpansion>')\nbuildableref(3, primary, debugcfg)\n_p(2, '</MacroExpansion>')\n_p(2, '<AdditionalOptions>')\n_p(2, '</AdditionalOptions>')\n_p(1, '</TestAction>')\n_p(1, '<LaunchAction')\n_p(2, 'buildConfiguration = \"%s\"', debugname)\n_p(2, 'selectedDebuggerIdentifier = \"Xcode.DebuggerFoundation.Debugger.LLDB\"')\n_p(2, 'selectedLauncherIdentifier = \"Xcode.DebuggerFoundation.Launcher.LLDB\"')\n_p(2, 'launchStyle = \"0\"')\nif debugcfg.debugdir then\n_p(2, 'useCustomWorkingDirectory = \"YES\"')\n_p(2, 'customWorkingDirectory = \"%s\"', workingdir(debugcfg.debugdir))\nelse\n_p(2, 'useCustomWorkingDirectory = \"NO\"')\nend\n_p(2, 'ignoresPersistentStateOnLaunch = \"NO\"')\n_p(2, 'debugDocumentVersioning = \"YES\"')\n_p(2, 'debugServiceExtension = \"internal\"')\n_p(2, 'allowLocationSimulation = \"YES\">')\nif debugcfg.debugcmd then\n_p(2, '<PathRunnable')"
	"\n_p(3, 'runnableDebuggingMode = \"0\"')\n_p(3, 'FilePath = \"%s\">', debugcfg.debugcmd)\n_p(2, '</PathRunnable>')\nelse\n_p(2, '<BuildableProductRunnable')\n_p(3, 'runnableDebuggingMode = \"0\">')\nbuildableref(3, primary, debugcfg)\n_p(2, '</BuildableProductRunnable>')\nend\ncmdlineargs(2, debugcfg)\nenvvars(2, debugcfg)\n_p(2, '<AdditionalOptions>')\n_p(2, '</AdditionalOptions>')\n_p(1, '</LaunchAction>')\n_p(1, '<ProfileAction')\n_p(2, 'buildConfiguration = \"%s\"', releasename)\n_p(2, 'shouldUseLaunchSchemeArgsEnv = \"YES\"')\n_p(2, 'savedToolIdentifier = \"\"')\nif releasecfg.debugdir then\n_p(2, 'useCustomWorkingDirectory = \"YES\"')\n_p(2, 'customWorkingDirectory = \"%s\"', workingdir(releasecfg.debugdir))\nelse\n_p(2, 'useCustomWorkingDirectory = \"NO\"')\nend\n_p(2, 'debugDocumentVersioning = \"YES\">')\n_p(2, '<BuildableProductRunnable')\n_p(3, 'runnableDebuggingMode = \"0\">')\nbuildableref(3, primary, releasecfg)\n_p(2, '</BuildableProductRunnable>')\ncmdlineargs(2, releasecfg)\nenvvars(2, release"
	"cfg)\n_p(1, '</ProfileAction>')\n_p(1, '<AnalyzeAction')\n_p(2, 'buildConfiguration = \"%s\">', debugname)\n_p(1, '</AnalyzeAction>')\n_p(1, '<ArchiveAction')\n_p(2, 'buildConfiguration = \"%s\"', releasename)\n_p(2, 'revealArchiveInOrganizer = \"YES\">')\n_p(1, '</ArchiveAction>')\n_p('</Scheme>')\nend\nfunction xcode.generate_schemes(prj, base_path)\nif (prj.kind == \"ConsoleApp\" or prj.kind == \"WindowedApp\") or (prj.options and prj.options.XcodeLibrarySchemes) then\nif prj.options and prj.options.XcodeSchemeNoConfigs then\npremake.generate(prj, path.join(base_path, \"%%.xcscheme\"),\nfunction(prj) xcode.scheme({prj}, prj) end)\nelse\nfor cfg in premake.eachconfig(prj) do\npremake.generate(prj, path.join(base_path, \"%% \" .. cfg.name .. \".xcscheme\"),\nfunction(prj) xcode.scheme({prj}, prj, cfg) end)\nend\nend\nend\nend\n",

	/* actions/xcode/xcode_workspace.lua */
	"local premake = premake\nlocal xcode = premake.xcode\nxcode.allscheme = false\nfunction xcode.workspace_head()\n_p('<?xml version=\"1.0\" encoding=\"UTF-8\"?>')\n_p('<Workspace')\n_p(1,'version = \"1.0\">')\nend\nfunction xcode.workspace_tail()\n_p('</Workspace>')\nend\nfunction xcode.workspace_file_ref(prj, indent)\nlocal projpath = path.getrelative(prj.solution.location, prj.location)\nif projpath == '.' then projpath = ''\nelse projpath = projpath ..'/'\nend\n_p(indent, '<FileRef')\n_p(indent + 1, 'location = \"group:%s\">', projpath .. prj.name .. '.xcodeproj')\n_p(indent, '</FileRef>')\nend\nfunction xcode.workspace_group(grp, indent)\n_p(indent, '<Group')\n_p(indent + 1, 'location = \"container:\"')\n_p(indent + 1, 'name = \"%s\">', grp.name)\nlocal function comparenames(a, b)\nreturn a.name < b.name\nend\nlocal groups = table.join(grp.groups)\nlocal projects = table.join(grp.projects)\ntable.sort(groups, comparenames)\ntable.sort(projects, comparenames)\nfor _, child in ipairs(groups) do\nxcode.workspac"
	"e_group(child, indent + 1)\nend\nfor _, prj in ipairs(projects) do\nxcode.workspace_file_ref(prj, indent + 1)\nend\n_p(indent, '</Group>')\nend\nfunction xcode.workspace_generate(sln)\nxcode.preparesolution(sln)\nxcode.workspace_head()\nxcode.reorderProjects(sln)\nfor grp in premake.solution.eachgroup(sln) do\nif grp.parent == nil then\nxcode.workspace_group(grp, 1)\nend\nend\nfor prj in premake.solution.eachproject(sln) do\nif prj.group == nil then\nxcode.workspace_file_ref(prj, 1)\nend\nend\nxcode.workspace_tail()\nend\nfunction xcode.workspace_scheme(sln)\nif not xcode.allscheme then\nreturn false\nend\nlocal projects = {}\nlocal primary = nil\nfor prj in premake.solution.eachproject(sln) do\nif not primary or (sln.startproject == prj.name) then\nprimary = prj\nend\ntable.insert(projects, prj)\nend\nxcode.scheme(projects, primary)\nend\nfunction xcode.workspace_settings(sln)\n_p('<?xml version=\"1.0\" encoding=\"UTF-8\"?>')\n_p('<!DOCTYPE plist PUBLIC \"-//Apple//DTD PLIST 1.0//EN\" \"http://www.apple.com/D"
	"TDs/PropertyList-1.0.dtd\">')\n_p('<plist version=\"1.0\">')\n_p('<dict>')\n_p(1, '<key>IDEWorkspaceSharedSettings_AutocreateContextsIfNeeded</key>')\n_p(1, '<false/>')\n_p('</dict>')\n_p('</plist>')\nend\nfunction xcode.reorderProjects(sln)\nif sln.startproject then\nfor i, prj in ipairs(sln.projects) do\nif sln.startproject == prj.name then\nlocal cur = prj.group\nwhile cur ~= nil do\nfor j, group in ipairs(sln.groups) do\nif group == cur then\ntable.remove(sln.groups, j)\nbreak\nend\nend\ntable.insert(sln.groups, 1, cur)\ncur = cur.parent\nend\ntable.remove(sln.projects, i)\ntable.insert(sln.projects, 1, prj)\nbreak\nend\nend\nend\nend\n",

	/* actions/xcode/xcode8.lua */
	"local premake = premake\npremake.xcode8 = { }\nlocal xcode  = premake.xcode\nlocal xcode8 = premake.xcode8\nfunction xcode8.XCBuildConfiguration_Target(tr, target, cfg)\nlocal cfgname = xcode.getconfigname(cfg)\nlocal installpaths = {\nConsoleApp = \"/usr/local/bin\",\nWindowedApp = \"$(HOME)/Applications\",\nSharedLib = \"/usr/local/lib\",\nStaticLib = \"/usr/local/lib\",\nBundle    = \"$(LOCAL_LIBRARY_DIR)/Bundles\",\n}\nlocal options = {\nALWAYS_SEARCH_USER_PATHS = \"NO\",\nGCC_DYNAMIC_NO_PIC = \"NO\",\nGCC_MODEL_TUNING = \"G5\",\nINSTALL_PATH = installpaths[cfg.kind],\nPRODUCT_NAME = cfg.buildtarget.basename,\n}\nif not cfg.flags.Symbols then\noptions.DEBUG_INFORMATION_FORMAT = \"dwarf-with-dsym\"\nend\nif cfg.kind ~= \"StaticLib\" and cfg.buildtarget.prefix ~= \"\" then\noptions.EXECUTABLE_PREFIX = cfg.buildtarget.prefix\nend\nif cfg.targetextension then\nlocal ext = cfg.targetextension\noptions.EXECUTABLE_EXTENSION = iif(ext:startswith(\".\"), ext:sub(2), ext)\nend\nif cfg.flags.ObjcARC then\noptions.CLA"
	"NG_ENABLE_OBJC_ARC = \"YES\"\nend\nlocal outdir = path.getdirectory(cfg.buildtarget.bundlepath)\nif outdir ~= \".\" then\noptions.CONFIGURATION_BUILD_DIR = outdir\nend\nif tr.infoplist then\noptions.INFOPLIST_FILE = tr.infoplist.cfg.name\nend\nlocal infoplist_file = nil\nfor _, v in ipairs(cfg.files) do\nif (string.find (string.lower (v), 'info.plist') ~= nil) then\ninfoplist_file = string.format('$(SRCROOT)/%s', v)\nend\nend\nif infoplist_file ~= nil then\noptions.INFOPLIST_FILE = infoplist_file\nend\nlocal action = premake.action.current()\nxcode.setdeploymenttarget(cfg, action.xcode, options)\nif cfg.kind == \"Bundle\" and not cfg.options.SkipBundling then\noptions.PRODUCT_BUNDLE_IDENTIFIER = \"genie.\" .. cfg.buildtarget.basename:gsub(\"%s+\", \".\") --replace spaces with .\nlocal ext = cfg.targetextension\nif ext then\noptions.WRAPPER_EXTENSION = iif(ext:startswith(\".\"), ext:sub(2), ext)\nelse\noptions.WRAPPER_EXTENSION = \"bundle\"\nend\nend\nreturn options\nend\nfunction xcode8.XCBuildConfiguration_Pr"
	"oject(tr, prj, cfg)\nlocal cfgname = xcode.getconfigname(cfg)\nlocal archs = {\nNative      = nil,\nx32         = \"i386\",\nx64         = \"x86_64\",\nUniversal32 = \"$(ARCHS_STANDARD_32_BIT)\",\nUniversal64 = \"$(ARCHS_STANDARD_64_BIT)\",\nUniversal   = \"$(ARCHS_STANDARD_32_64_BIT)\",\n}\nlocal checks = {\n[\"-ffast-math\"]          = cfg.flags.FloatFast,\n[\"-ffloat-store\"]        = cfg.flags.FloatStrict,\n[\"-fomit-frame-pointer\"] = cfg.flags.NoFramePointer,\n}\nlocal cflags = { }\nfor flag, check in pairs(checks) do\nif check then\ntable.insert(cflags, flag)\nend\nend\nlocal ldflags = { }\nfor _, lib in ipairs(premake.getlinks(cfg, \"system\")) do\nif not xcode.isframework(lib) then\ntable.insert(ldflags, \"-l\" .. lib)\nend\nend\nlocal options = {\nARCHS                              = archs[cfg.platform],\nCLANG_WARN__DUPLICATE_METHOD_MATCH = \"YES\",\nCLANG_WARN_BOOL_CONVERSION         = \"YES\",\nCLANG_WARN_CONSTANT_CONVERSION     = \"YES\",\nCLANG_WARN_EMPTY_BODY              = \"YES\",\nCLANG_WARN"
	"_ENUM_CONVERSION         = \"YES\",\nCLANG_WARN_INFINITE_RECURSION      = \"YES\",\nCLANG_WARN_INT_CONVERSION          = \"YES\",\nCLANG_WARN_SUSPICIOUS_MOVE         = \"YES\",\nCLANG_WARN_UNREACHABLE_CODE        = \"YES\",\nCONFIGURATION_TEMP_DIR             = \"$(OBJROOT)\",\nENABLE_STRICT_OBJC_MSGSEND         = \"YES\",\nENABLE_TESTABILITY                 = \"YES\",\nGCC_C_LANGUAGE_STANDARD            = \"gnu99\",\nGCC_NO_COMMON_BLOCKS               = \"YES\",\nGCC_PREPROCESSOR_DEFINITIONS       = cfg.defines,\nGCC_SYMBOLS_PRIVATE_EXTERN         = \"NO\",\nGCC_WARN_64_TO_32_BIT_CONVERSION   = \"YES\",\nGCC_WARN_ABOUT_RETURN_TYPE         = \"YES\",\nGCC_WARN_UNDECLARED_SELECTOR       = \"YES\",\nGCC_WARN_UNINITIALIZED_AUTOS       = \"YES\",\nGCC_WARN_UNUSED_FUNCTION           = \"YES\",\nGCC_WARN_UNUSED_VARIABLE           = \"YES\",\nHEADER_SEARCH_PATHS                = table.join(cfg.includedirs, cfg.systemincludedirs),\nLIBRARY_SEARCH_PATHS               = cfg.libdirs,\nOBJROOT                            ="
	" cfg.objectsdir,\nONLY_ACTIVE_ARCH                   = \"YES\",\nOTHER_CFLAGS                       = table.join(cflags, cfg.buildoptions, cfg.buildoptions_c),\nOTHER_CPLUSPLUSFLAGS               = table.join(cflags, cfg.buildoptions, cfg.buildoptions_cpp),\nOTHER_LDFLAGS                      = table.join(ldflags, cfg.linkoptions),\nSDKROOT                            = xcode.toolset,\nUSER_HEADER_SEARCH_PATHS           = cfg.userincludedirs,\n}\nif tr.entitlements then\noptions.CODE_SIGN_ENTITLEMENTS = tr.entitlements.cfg.name\nend\nlocal targetdir = path.getdirectory(cfg.buildtarget.bundlepath)\nif targetdir ~= \".\" then\noptions.CONFIGURATION_BUILD_DIR = \"$(SYMROOT)\"\noptions.SYMROOT = targetdir\nend\nif cfg.flags.Symbols then\noptions.COPY_PHASE_STRIP = \"NO\"\nend\nlocal excluded = xcode.cfg_excluded_files(prj, cfg)\nif #excluded > 0 then\noptions.EXCLUDED_SOURCE_FILE_NAMES = excluded\nend\nif cfg.flags.NoExceptions then\noptions.GCC_ENABLE_CPP_EXCEPTIONS = \"NO\"\nend\nif cfg.flags.NoRTTI then\noptions"
	".GCC_ENABLE_CPP_RTTI = \"NO\"\nend\nif cfg.flags.Symbols and not cfg.flags.NoEditAndContinue then\noptions.GCC_ENABLE_FIX_AND_CONTINUE = \"YES\"\nend\nif cfg.flags.NoExceptions then\noptions.GCC_ENABLE_OBJC_EXCEPTIONS = \"NO\"\nend\nif cfg.flags.Optimize or cfg.flags.OptimizeSize then\noptions.GCC_OPTIMIZATION_LEVEL = \"s\"\nelseif cfg.flags.OptimizeSpeed then\noptions.GCC_OPTIMIZATION_LEVEL = 3\nelse\noptions.GCC_OPTIMIZATION_LEVEL = 0\nend\nif cfg.pchheader and not cfg.flags.NoPCH then\noptions.GCC_PRECOMPILE_PREFIX_HEADER = \"YES\"\nlocal pch = cfg.pchheader\nfor _, incdir in ipairs(cfg.includedirs) do\nlocal abspath = path.getabsolute(path.join(cfg.project.location, incdir))\nlocal testname = path.join(abspath, pch)\nif os.isfile(testname) then\npch = path.getrelative(cfg.location, testname)\nbreak\nend\nend\noptions.GCC_PREFIX_HEADER = pch\nend\nif cfg.flags.FatalWarnings then\noptions.GCC_TREAT_WARNINGS_AS_ERRORS = \"YES\"\nend\nif cfg.kind == \"Bundle\" then\noptions.MACH_O_TYPE = \"mh_bundle\"\nend\nif"
	" cfg.flags.StaticRuntime then\noptions.STANDARD_C_PLUS_PLUS_LIBRARY_TYPE = \"static\"\nend\nif cfg.flags.PedanticWarnings or cfg.flags.ExtraWarnings then\noptions.WARNING_CFLAGS = \"-Wall\"\nend\nif cfg.flags.Cpp11 then\noptions.CLANG_CXX_LANGUAGE_STANDARD = \"c++11\"\nelseif cfg.flags.Cpp14 or cfg.flags.CppLatest then\noptions.CLANG_CXX_LANGUAGE_STANDARD = \"c++14\"\nelseif cfg.flags.Cpp17 then\nif premake.action.current() == premake.action.get(\"xcode8\") then\nerror(\"XCode8 does not support C++17.\")\nend\nend\nfor _, val in ipairs(premake.xcode.parameters) do\nlocal eqpos = string.find(val, \"=\")\nif eqpos ~= nil then\nlocal key = string.trim(string.sub(val, 1, eqpos - 1))\nlocal value = string.trim(string.sub(val, eqpos + 1))\noptions[key] = value\nend\nend\nreturn options\nend\nfunction xcode8.project(prj)\nlocal tr = xcode.buildprjtree(prj)\nxcode.Header(tr, 48)\nxcode.PBXBuildFile(tr)\nxcode.PBXContainerItemProxy(tr)\nxcode.PBXFileReference(tr,prj)\nxcode.PBXFrameworksBuildPhase(tr)\nxcode.PBXGroup(t"
	"r)\nxcode.PBXNativeTarget(tr)\nxcode.PBXProject(tr, \"8.0\")\nxcode.PBXReferenceProxy(tr)\nxcode.PBXResourcesBuildPhase(tr)\nxcode.PBXShellScriptBuildPhase(tr)\nxcode.PBXCopyFilesBuildPhase(tr)\nxcode.PBXSourcesBuildPhase(tr,prj)\nxcode.PBXVariantGroup(tr)\nxcode.PBXTargetDependency(tr)\nxcode.XCBuildConfiguration(tr, prj, {\nontarget = xcode8.XCBuildConfiguration_Target,\nonproject = xcode8.XCBuildConfiguration_Project,\n})\nxcode.XCBuildConfigurationList(tr)\nxcode.Footer(tr)\nend\nnewaction\n{\ntrigger         = \"xcode8\",\nshortname       = \"Xcode 8\",\ndescription     = \"Generate Apple Xcode 8 project files\",\nos              = \"macosx\",\nvalid_kinds     = { \"ConsoleApp\", \"WindowedApp\", \"StaticLib\", \"SharedLib\", \"Bundle\" },\nvalid_languages = { \"C\", \"C++\" },\nvalid_tools     = {\ncc     = { \"gcc\" },\n},\nvalid_platforms = {\nNative = \"Native\",\nx32 = \"Native 32-bit\",\nx64 = \"Native 64-bit\",\nUniversal = \"Universal\",\n},\ndefault_platform = \"Native\",\nonsolution = function(s"
	"ln)\npremake.generate(sln, \"%%.xcworkspace/contents.xcworkspacedata\", xcode.workspace_generate)\npremake.generate(sln, \"%%.xcworkspace/xcshareddata/WorkspaceSettings.xcsettings\", xcode.workspace_settings)\npremake.generate(sln, \"%%.xcworkspace/xcshareddata/xcschemes/-ALL-.xcscheme\", xcode.workspace_scheme)\nend,\nonproject = function(prj)\npremake.generate(prj, \"%%.xcodeproj/project.pbxproj\", xcode8.project)\nxcode.generate_schemes(prj, \"%%.xcodeproj/xcshareddata/xcschemes\")\nend,\noncleanproject = function(prj)\npremake.clean.directory(prj, \"%%.xcodeproj\")\npremake.clean.directory(prj, \"%%.xcworkspace\")\nend,\noncheckproject = xcode.checkproject,\nxcode = {\niOSTargetPlatformVersion = nil,\nmacOSTargetPlatformVersion = nil,\ntvOSTargetPlatformVersion = nil,\n},\n}\n",

	/* actions/xcode/xcode9.lua */
	"local premake = premake\npremake.xcode9 = { }\nlocal xcode  = premake.xcode\nlocal xcode8 = premake.xcode8\nlocal xcode9 = premake.xcode9\nfunction xcode9.XCBuildConfiguration_Project(tr, prj, cfg)\nlocal options = xcode8.XCBuildConfiguration_Project(tr, prj, cfg)\nif cfg.flags.Cpp17 then\noptions.CLANG_CXX_LANGUAGE_STANDARD = \"c++17\"\nelseif cfg.flags.Cpp20 or cfg.flags.CppLatest then\noptions.CLANG_CXX_LANGUAGE_STANDARD = \"c++20\"\nend\nreturn table.merge(options, {\nCLANG_WARN_BLOCK_CAPTURE_AUTORELEASING = \"YES\",\nCLANG_WARN_COMMA = \"YES\",\nCLANG_WARN_NON_LITERAL_NULL_CONVERSION = \"YES\",\nCLANG_WARN_OBJC_LITERAL_CONVERSION = \"YES\",\nCLANG_WARN_RANGE_LOOP_ANALYSIS = \"YES\",\nCLANG_WARN_STRICT_PROTOTYPES = \"YES\",\n})\nend\nfunction xcode9.project(prj)\nlocal tr = xcode.buildprjtree(prj)\nxcode.Header(tr, 48)\nxcode.PBXBuildFile(tr)\nxcode.PBXContainerItemProxy(tr)\nxcode.PBXFileReference(tr,prj)\nxcode.PBXFrameworksBuildPhase(tr)\nxcode.PBXGroup(tr)\nxcode.PBXNativeTarget(tr)\nxcode.PBXProject(t"
	"r, \"8.0\")\nxcode.PBXReferenceProxy(tr)\nxcode.PBXResourcesBuildPhase(tr)\nxcode.PBXShellScriptBuildPhase(tr)\nxcode.PBXCopyFilesBuildPhase(tr)\nxcode.PBXSourcesBuildPhase(tr,prj)\nxcode.PBXVariantGroup(tr)\nxcode.PBXTargetDependency(tr)\nxcode.XCBuildConfiguration(tr, prj, {\nontarget = xcode8.XCBuildConfiguration_Target,\nonproject = xcode9.XCBuildConfiguration_Project,\n})\nxcode.XCBuildConfigurationList(tr)\nxcode.Footer(tr)\nend\nnewaction\n{\ntrigger         = \"xcode9\",\nshortname       = \"Xcode 9\",\ndescription     = \"Generate Apple Xcode 9 project files\",\nos              = \"macosx\",\nvalid_kinds     = { \"ConsoleApp\", \"WindowedApp\", \"StaticLib\", \"SharedLib\", \"Bundle\" },\nvalid_languages = { \"C\", \"C++\" },\nvalid_tools     = {\ncc     = { \"gcc\" },\n},\nvalid_platforms = {\nNative = \"Native\",\nx32 = \"Native 32-bit\",\nx64 = \"Native 64-bit\",\nUniversal = \"Universal\",\n},\ndefault_platform = \"Native\",\nonsolution = function(sln)\npremake.generate(sln, \"%%.xcworkspace/conte"
	"nts.xcworkspacedata\", xcode.workspace_generate)\npremake.generate(sln, \"%%.xcworkspace/xcshareddata/WorkspaceSettings.xcsettings\", xcode.workspace_settings)\npremake.generate(sln, \"%%.xcworkspace/xcshareddata/xcschemes/-ALL-.xcscheme\", xcode.workspace_scheme)\nend,\nonproject = function(prj)\npremake.generate(prj, \"%%.xcodeproj/project.pbxproj\", xcode9.project)\nxcode.generate_schemes(prj, \"%%.xcodeproj/xcshareddata/xcschemes\")\nend,\noncleanproject = function(prj)\npremake.clean.directory(prj, \"%%.xcodeproj\")\npremake.clean.directory(prj, \"%%.xcworkspace\")\nend,\noncheckproject = xcode.checkproject,\nxcode = {\niOSTargetPlatformVersion = nil,\nmacOSTargetPlatformVersion = nil,\ntvOSTargetPlatformVersion = nil,\n},\n}\n",

	/* actions/xcode/xcode10.lua */
	"local premake = premake\npremake.xcode10 = { }\nlocal xcode  = premake.xcode\nlocal xcode8 = premake.xcode8\nlocal xcode9 = premake.xcode9\nlocal xcode10 = premake.xcode10\nfunction xcode10.XCBuildConfiguration_Project(tr, prj, cfg)\nlocal options = xcode9.XCBuildConfiguration_Project(tr, prj, cfg)\nreturn table.merge(options, {\nCLANG_WARN_DEPRECATED_OBJC_IMPLEMENTATIONS = \"YES\",\nCLANG_WARN_OBJC_IMPLICIT_RETAIN_SELF = \"YES\",\nCLANG_WARN_BLOCK_CAPTURE_AUTORELEASING = \"YES\",\nCLANG_WARN_COMMA = \"YES\",\nCLANG_WARN_NON_LITERAL_NULL_CONVERSION = \"YES\",\nCLANG_WARN_OBJC_LITERAL_CONVERSION = \"YES\",\nCLANG_WARN_RANGE_LOOP_ANALYSIS = \"YES\",\nCLANG_WARN_STRICT_PROTOTYPES = \"YES\",\n})\nend\nfunction xcode10.XCBuildConfiguration_Target(tr, target, cfg)\nlocal options = xcode8.XCBuildConfiguration_Target(tr, target, cfg)\nif not cfg.flags.ObjcARC then\noptions.CLANG_ENABLE_OBJC_WEAK = \"YES\"\nend\nreturn options\nend\nfunction xcode10.project(prj)\nlocal tr = xcode.buildprjtree(prj)\nxcode.Header(tr, 48)"
	"\nxcode.PBXBuildFile(tr)\nxcode.PBXContainerItemProxy(tr)\nxcode.PBXFileReference(tr,prj)\nxcode.PBXFrameworksBuildPhase(tr)\nxcode.PBXGroup(tr)\nxcode.PBXNativeTarget(tr)\nxcode.PBXProject(tr, \"8.0\")\nxcode.PBXReferenceProxy(tr)\nxcode.PBXResourcesBuildPhase(tr)\nxcode.PBXShellScriptBuildPhase(tr)\nxcode.PBXCopyFilesBuildPhase(tr)\nxcode.PBXSourcesBuildPhase(tr,prj)\nxcode.PBXVariantGroup(tr)\nxcode.PBXTargetDependency(tr)\nxcode.XCBuildConfiguration(tr, prj, {\nontarget = xcode10.XCBuildConfiguration_Target,\nonproject = xcode10.XCBuildConfiguration_Project,\n})\nxcode.XCBuildConfigurationList(tr)\nxcode.Footer(tr)\nend\nnewaction\n{\ntrigger         = \"xcode10\",\nshortname       = \"Xcode 10\",\ndescription     = \"Generate Apple Xcode 10 project files\",\nos              = \"macosx\",\nvalid_kinds     = { \"ConsoleApp\", \"WindowedApp\", \"StaticLib\", \"SharedLib\", \"Bundle\" },\nvalid_languages = { \"C\", \"C++\" },\nvalid_tools     = {\ncc     = { \"gcc\" },\n},\nvalid_platforms = {\nNative = \"Nat"
	"ive\",\nx32 = \"Native 32-bit\",\nx64 = \"Native 64-bit\",\nUniversal = \"Universal\",\n},\ndefault_platform = \"Native\",\nonsolution = function(sln)\npremake.generate(sln, \"%%.xcworkspace/contents.xcworkspacedata\", xcode.workspace_generate)\npremake.generate(sln, \"%%.xcworkspace/xcshareddata/WorkspaceSettings.xcsettings\", xcode.workspace_settings)\npremake.generate(sln, \"%%.xcworkspace/xcshareddata/xcschemes/-ALL-.xcscheme\", xcode.workspace_scheme)\nend,\nonproject = function(prj)\npremake.generate(prj, \"%%.xcodeproj/project.pbxproj\", xcode10.project)\nxcode.generate_schemes(prj, \"%%.xcodeproj/xcshareddata/xcschemes\")\nend,\noncleanproject = function(prj)\npremake.clean.directory(prj, \"%%.xcodeproj\")\npremake.clean.directory(prj, \"%%.xcworkspace\")\nend,\noncheckproject = xcode.checkproject,\nxcode = {\niOSTargetPlatformVersion = nil,\nmacOSTargetPlatformVersion = nil,\ntvOSTargetPlatformVersion = nil,\n},\n}\n",

	/* actions/xcode/xcode11.lua */
	"local premake = premake\npremake.xcode11 = { }\nlocal xcode  = premake.xcode\nlocal xcode10 = premake.xcode10\nlocal xcode11 = premake.xcode11\nfunction xcode11.XCBuildConfiguration_Target(tr, target, cfg)\nlocal options = xcode10.XCBuildConfiguration_Target(tr, target, cfg)\noptions.CODE_SIGN_IDENTITY = \"-\"\nreturn options\nend\nfunction xcode11.project(prj)\nlocal tr = xcode.buildprjtree(prj)\nxcode.Header(tr, 48)\nxcode.PBXBuildFile(tr)\nxcode.PBXContainerItemProxy(tr)\nxcode.PBXFileReference(tr,prj)\nxcode.PBXFrameworksBuildPhase(tr)\nxcode.PBXGroup(tr)\nxcode.PBXNativeTarget(tr)\nxcode.PBXProject(tr, \"8.0\")\nxcode.PBXReferenceProxy(tr)\nxcode.PBXResourcesBuildPhase(tr)\nxcode.PBXShellScriptBuildPhase(tr)\nxcode.PBXCopyFilesBuildPhase(tr)\nxcode.PBXSourcesBuildPhase(tr,prj)\nxcode.PBXVariantGroup(tr)\nxcode.PBXTargetDependency(tr)\nxcode.XCBuildConfiguration(tr, prj, {\nontarget = xcode11.XCBuildConfiguration_Target,\nonproject = xcode10.XCBuildConfiguration_Project,\n})\nxcode.XCBuildConfigurationList"
	"(tr)\nxcode.Footer(tr)\nend\nnewaction\n{\ntrigger         = \"xcode11\",\nshortname       = \"Xcode 11\",\ndescription     = \"Generate Apple Xcode 11 project files\",\nos              = \"macosx\",\nvalid_kinds     = { \"ConsoleApp\", \"WindowedApp\", \"StaticLib\", \"SharedLib\", \"Bundle\" },\nvalid_languages = { \"C\", \"C++\" },\nvalid_tools     = {\ncc     = { \"gcc\" },\n},\nvalid_platforms = { Native = \"Native\" },\ndefault_platform = \"Native\",\nonsolution = function(sln)\npremake.generate(sln, \"%%.xcworkspace/contents.xcworkspacedata\", xcode.workspace_generate)\npremake.generate(sln, \"%%.xcworkspace/xcshareddata/WorkspaceSettings.xcsettings\", xcode.workspace_settings)\npremake.generate(sln, \"%%.xcworkspace/xcshareddata/xcschemes/-ALL-.xcscheme\", xcode.workspace_scheme)\nend,\nonproject = function(prj)\npremake.generate(prj, \"%%.xcodeproj/project.pbxproj\", xcode11.project)\nxcode.generate_schemes(prj, \"%%.xcodeproj/xcshareddata/xcschemes\")\nend,\noncleanproject = function(prj)\npremake.cl"
	"ean.directory(prj, \"%%.xcodeproj\")\npremake.clean.directory(prj, \"%%.xcworkspace\")\nend,\noncheckproject = xcode.checkproject,\nxcode = {\niOSTargetPlatformVersion = nil,\nmacOSTargetPlatformVersion = nil,\ntvOSTargetPlatformVersion = nil,\n},\n}\n",

	/* actions/xcode/xcode14.lua */
	"local premake = premake\npremake.xcode14 = { }\nlocal xcode  = premake.xcode\nlocal xcode10 = premake.xcode10\nlocal xcode11 = premake.xcode11\nlocal xcode14 = premake.xcode14\nfunction xcode14.XCBuildConfiguration_Target(tr, target, cfg)\nlocal options = xcode11.XCBuildConfiguration_Target(tr, target, cfg)\noptions.CODE_SIGN_IDENTITY = \"-\"\nlocal action = premake.action.current()\nxcode.setdeploymenttarget(cfg, action.xcode, options)\nlocal iosversion = options.IPHONEOS_DEPLOYMENT_TARGET\nlocal macosversion = options.MACOSX_DEPLOYMENT_TARGET\nlocal tvosversion = options.TVOS_DEPLOYMENT_TARGET\nif iosversion and not xcode.versionge(iosversion, \"11\") then\n   error(\"XCode14 does not support deployment for iOS older than 11\")\nelseif macosversion and not xcode.versionge(macosversion, \"10.13\") then\n   error(\"XCode14 does not support deployment for macOS older than 10.13\")\nelseif tvosversion and not xcode.versionge(tvosversion, \"11\") then\n   error(\"XCode14 does not support deployment for tvOS older"
	" than 11\")\nend\nreturn options\nend\nfunction xcode14.XCBuildConfiguration_Project(tr, prj, cfg)\nlocal options = xcode10.XCBuildConfiguration_Project(tr, prj, cfg)\noptions.ENABLE_BITCODE = \"NO\" -- Bitcode is now deprecated.\nlocal action = premake.action.current()\nxcode.setdeploymenttarget(cfg, action.xcode, options)\nreturn options\nend\nfunction xcode14.project(prj)\nlocal tr = xcode.buildprjtree(prj)\nxcode.Header(tr, 48)\nxcode.PBXBuildFile(tr)\nxcode.PBXContainerItemProxy(tr)\nxcode.PBXFileReference(tr,prj)\nxcode.PBXFrameworksBuildPhase(tr)\nxcode.PBXGroup(tr)\nxcode.PBXNativeTarget(tr)\nxcode.PBXProject(tr, \"8.0\")\nxcode.PBXReferenceProxy(tr)\nxcode.PBXResourcesBuildPhase(tr)\nxcode.PBXShellScriptBuildPhase(tr)\nxcode.PBXCopyFilesBuildPhase(tr)\nxcode.PBXSourcesBuildPhase(tr,prj)\nxcode.PBXVariantGroup(tr)\nxcode.PBXTargetDependency(tr)\nxcode.XCBuildConfiguration(tr, prj, {\nontarget = xcode14.XCBuildConfiguration_Target,\nonproject = xcode14.XCBuildConfiguration_Project,\n})\nxcode.XCBuildCon"
	"figurationList(tr)\nxcode.Footer(tr)\nend\nnewaction\n{\ntrigger         = \"xcode14\",\nshortname       = \"Xcode 14\",\ndescription     = \"Generate Apple Xcode 14 project files\",\nos              = \"macosx\",\nvalid_kinds     = { \"ConsoleApp\", \"WindowedApp\", \"StaticLib\", \"SharedLib\", \"Bundle\" },\nvalid_languages = { \"C\", \"C++\" },\nvalid_tools     = {\ncc     = { \"gcc\" },\n},\nvalid_platforms = { Native = \"Native\" },\ndefault_platform = \"Native\",\nonsolution = function(sln)\npremake.generate(sln, \"%%.xcworkspace/contents.xcworkspacedata\", xcode.workspace_generate)\npremake.generate(sln, \"%%.xcworkspace/xcshareddata/WorkspaceSettings.xcsettings\", xcode.workspace_settings)\npremake.generate(sln, \"%%.xcworkspace/xcshareddata/xcschemes/-ALL-.xcscheme\", xcode.workspace_scheme)\nend,\nonproject = function(prj)\npremake.generate(prj, \"%%.xcodeproj/project.pbxproj\", xcode14.project)\nxcode.generate_schemes(prj, \"%%.xcodeproj/xcshareddata/xcschemes\")\nend,\noncleanproject = function(pr"
	"j)\npremake.clean.directory(prj, \"%%.xcodeproj\")\npremake.clean.directory(prj, \"%%.xcworkspace\")\nend,\noncheckproject = xcode.checkproject,\nxcode = {\niOSTargetPlatformVersion = nil,\nmacOSTargetPlatformVersion = nil,\ntvOSTargetPlatformVersion = nil,\n},\n}\n",

	/* actions/xcode/xcode15.lua */
	"local premake = premake\npremake.xcode15 = { }\nlocal xcode  = premake.xcode\nlocal xcode10 = premake.xcode10\nlocal xcode11 = premake.xcode11\nlocal xcode14 = premake.xcode14\nlocal xcode15 = premake.xcode15\nfunction xcode15.XCBuildConfiguration_Target(tr, target, cfg)\nlocal options = xcode11.XCBuildConfiguration_Target(tr, target, cfg)\noptions.CODE_SIGN_IDENTITY = \"-\"\nlocal action = premake.action.current()\nxcode.setdeploymenttarget(cfg, action.xcode, options)\nlocal iosversion = options.IPHONEOS_DEPLOYMENT_TARGET\nlocal macosversion = options.MACOSX_DEPLOYMENT_TARGET\nlocal tvosversion = options.TVOS_DEPLOYMENT_TARGET\nlocal xrosversion = options.XROS_DEPLOYMENT_TARGET\nif iosversion and not xcode.versionge(iosversion, \"12\") then\n   error(\"XCode15 does not support deployment for iOS older than 12\")\nelseif macosversion and not xcode.versionge(macosversion, \"13.5\") then\n   error(\"XCode15 does not support deployment for macOS older than 13.5\")\nelseif tvosversion and not xcode.versionge(tvosv"
	"ersion, \"12\") then\n   error(\"XCode15 does not support deployment for tvOS older than 12\")\nelseif xrosversion and not xcode.versionge(xrosversion, \"1.0\") then\n   error(\"XCode15 does not support deployment for visionOS older than 1.0\")\nend\nreturn options\nend\nfunction xcode15.XCBuildConfiguration_Project(tr, prj, cfg)\nlocal options = xcode10.XCBuildConfiguration_Project(tr, prj, cfg)\nlocal action = premake.action.current()\nxcode.setdeploymenttarget(cfg, action.xcode, options)\nreturn options\nend\nfunction xcode15.project(prj)\nlocal tr = xcode.buildprjtree(prj)\nxcode.Header(tr, 48)\nxcode.PBXBuildFile(tr)\nxcode.PBXContainerItemProxy(tr)\nxcode.PBXFileReference(tr,prj)\nxcode.PBXFrameworksBuildPhase(tr)\nxcode.PBXGroup(tr)\nxcode.PBXNativeTarget(tr)\nxcode.PBXProject(tr, \"8.0\")\nxcode.PBXReferenceProxy(tr)\nxcode.PBXResourcesBuildPhase(tr)\nxcode.PBXShellScriptBuildPhase(tr)\nxcode.PBXCopyFilesBuildPhase(tr)\nxcode.PBXSourcesBuildPhase(tr,prj)\nxcode.PBXVariantGroup(tr)\nxcode.PBXTargetDepen"
	"dency(tr)\nxcode.XCBuildConfiguration(tr, prj, {\nontarget = xcode15.XCBuildConfiguration_Target,\nonproject = xcode15.XCBuildConfiguration_Project,\n})\nxcode.XCBuildConfigurationList(tr)\nxcode.Footer(tr)\nend\nnewaction\n{\ntrigger         = \"xcode15\",\nshortname       = \"Xcode 15\",\ndescription     = \"Generate Apple Xcode 15 project files\",\nos              = \"macosx\",\nvalid_kinds     = { \"ConsoleApp\", \"WindowedApp\", \"StaticLib\", \"SharedLib\", \"Bundle\" },\nvalid_languages = { \"C\", \"C++\" },\nvalid_tools     = {\ncc     = { \"gcc\" },\n},\nvalid_platforms = { Native = \"Native\" },\ndefault_platform = \"Native\",\nonsolution = function(sln)\npremake.generate(sln, \"%%.xcworkspace/contents.xcworkspacedata\", xcode.workspace_generate)\npremake.generate(sln, \"%%.xcworkspace/xcshareddata/WorkspaceSettings.xcsettings\", xcode.workspace_settings)\npremake.generate(sln, \"%%.xcworkspace/xcshareddata/xcschemes/-ALL-.xcscheme\", xcode.workspace_scheme)\nend,\nonproject = function(prj)\npremake."
	"generate(prj, \"%%.xcodeproj/project.pbxproj\", xcode14.project)\nxcode.generate_schemes(prj, \"%%.xcodeproj/xcshareddata/xcschemes\")\nend,\noncleanproject = function(prj)\npremake.clean.directory(prj, \"%%.xcodeproj\")\npremake.clean.directory(prj, \"%%.xcworkspace\")\nend,\noncheckproject = xcode.checkproject,\nxcode = {\niOSTargetPlatformVersion = nil,\nmacOSTargetPlatformVersion = nil,\ntvOSTargetPlatformVersion = nil,\nvisionOSTargetPlatformVersion = nil,\n},\n}\n",

	/* actions/ninja/_ninja.lua */
	"premake.ninja = { }\nlocal p = premake\nnewaction\n{\ntrigger     = \"ninja\",\nshortname   = \"ninja\",\ndescription = \"Generate Ninja build files\",\nmodule      = \"ninja\",\nvalid_kinds     = {\"ConsoleApp\", \"WindowedApp\", \"StaticLib\", \"SharedLib\", \"Bundle\"},\nvalid_languages = {\"C\", \"C++\", \"Swift\"},\nvalid_tools     = {\ncc    = { \"gcc\" },\nswift = { \"swift\" },\n},\nonsolution = function(sln)\nio.eol    = \"\\r\\n\"\nio.indent = \"\\t\"\nio.escaper(p.ninja.esc)\np.generate(sln, \"Makefile\", p.ninja.generate_solution)\nio.indent = \"  \"\np.ninja.generate_ninja_builds(sln)\nend,\nonproject = function(prj)\nio.eol    = \"\\r\\n\"\nio.indent = \"  \"\nio.escaper(p.ninja.esc)\np.ninja.generate_project(prj)\nend,\noncleansolution = function(sln)\nfor _,name in ipairs(sln.configurations) do\npremake.clean.file(sln, p.ninja.get_solution_name(sln, name))\nend\nend,\noncleanproject = function(prj)\nend,\noncleantarget = function(prj)\nend,\n}\n",

	/* actions/ninja/ninja_base.lua */
	"local ninja = premake.ninja\nfunction ninja.esc(value)\nif value then\nvalue = string.gsub(value, \"%$\", \"$$\") -- TODO maybe there is better way\nvalue = string.gsub(value, \":\", \"$:\")\nvalue = string.gsub(value, \"\\n\", \"$\\n\")\nvalue = string.gsub(value, \" \", \"$ \")\nend\nreturn value\nend\nfunction ninja.shesc(value)\nif type(value) == \"table\" then\nlocal result = {}\nlocal n = #value\nfor i = 1, n do\ntable.insert(result, ninja.shesc(value[i]))\nend\nreturn result\nend\nif value:find(\" \") then\nreturn \"\\\"\" .. value .. \"\\\"\"\nend\nreturn value\nend\nfunction ninja.list(value)\nif #value > 0 then\nreturn \" \" .. table.concat(value, \" \")\nelse\nreturn \"\"\nend\nend\nfunction ninja.arglist(arg, value)\nif #value > 0 then\nlocal args = {}\nfor _, val in ipairs(value) do\ntable.insert(args, string.format(\"%s %s\", arg, val))\nend\nreturn table.concat(args, \" \")\nelse\nreturn \"\"\nend\nend\nfunction ninja.generate_project(prj)\nif prj.language == \"Swift\" then\nninja.generate_swift"
	"(prj)\nelse\nninja.generate_cpp(prj)\nend\nend\nlocal function innerget(self, key)\nreturn rawget(getmetatable(self), key) or self.__inner[key]\nend\nlocal prj_proxy = { __index = innerget }\nlocal cfg_proxy = { __index = innerget }\nfunction new_prj_proxy(prj)\nprj = prj.project or prj\nlocal v = { __inner = prj }\nlocal __configs = {}\nfor key, cfg in pairs(prj.__configs) do\nif key ~= \"\" then\n__configs[key] = ninja.get_proxy(\"cfg\", cfg)\nelse\n__configs[key] = cfg\nend\nend\nv.__configs = __configs\nreturn setmetatable(v, prj_proxy)\nend\nlocal function rebasekeys(t, keys, old, new)\nfor _,key in ipairs(keys) do\nt[key] = path.rebase(t[key], old, new)\nend\nreturn t\nend\nlocal function rebasearray(t, old, new)\nlocal res = { }\nfor _,f in ipairs(t) do\ntable.insert(res, path.rebase(f, old, new))\nend\nreturn res\nend\nfunction new_cfg_proxy(cfg)\nlocal keys = { \"directory\", \"fullpath\", \"bundlepath\" }\nlocal old = cfg.location\nlocal new = path.join(cfg.location, cfg.shortname)\nlocal v = {\n__in"
	"ner     = cfg,\nlocation    = new,\nobjectsdir  = path.rebase(cfg.objectsdir, old, new),\nbuildtarget = rebasekeys(table.deepcopy(cfg.buildtarget), keys, old, new),\nlinktarget  = rebasekeys(table.deepcopy(cfg.linktarget), keys, old, new),\n}\nv.files             = rebasearray(cfg.files, old, new)\nv.includedirs       = rebasearray(cfg.includedirs, old, new)\nv.libdirs       = rebasearray(cfg.libdirs, old, new)\nv.userincludedirs   = rebasearray(cfg.userincludedirs, old, new)\nv.systemincludedirs = rebasearray(cfg.systemincludedirs, old, new)\nv.swiftmodulemaps   = rebasearray(cfg.swiftmodulemaps, old, new)\nreturn setmetatable(v, cfg_proxy)\nend\nfunction cfg_proxy:getprojectfilename(fullpath)\nlocal name = self.project.name .. \".ninja\"\nif fullpath ~= nil then\nreturn path.join(self.location, name)\nend\nreturn name\nend\nfunction cfg_proxy:getoutputfilename()\nreturn path.join(self.buildtarget.directory, self.buildtarget.name)\nend\nlocal proxy_cache = { \nprj = { new = new_prj_proxy }, \ncfg = { new = ne"
	"w_cfg_proxy },\n}\nfunction get_proxy(cache, obj)\nif not cache[obj] then\ncache[obj] = cache.new(obj)\nend\nreturn cache[obj]\nend\nfunction ninja.get_proxy(typ, obj)\nif not proxy_cache[typ] then\nerror(\"invalid proxy type\")\nend\nreturn get_proxy(proxy_cache[typ], obj)\nend\n",

	/* actions/ninja/ninja_solution.lua */
	"local ninja = premake.ninja\nlocal p = premake\nlocal solution = p.solution\nfunction ninja.generate_solution(sln)\nlocal cc = premake[_OPTIONS.cc]\nlocal platforms = premake.filterplatforms(sln, cc.platforms, \"Native\")\n_p('# %s solution makefile autogenerated by GENie', premake.action.current().shortname)\n_p('# Type \"make help\" for usage help')\n_p('')\n_p('NINJA=ninja')\n_p('ifndef config')\n_p('  config=%s', _MAKE.esc(premake.getconfigname(sln.configurations[1], platforms[1], true)))\n_p('endif')\n_p('')\nlocal projects = table.extract(sln.projects, \"name\")\ntable.sort(projects)\n_p('')\n_p('.PHONY: all clean help $(PROJECTS)')\n_p('')\n_p('all:')\nif (not sln.messageskip) or (not table.contains(sln.messageskip, \"SkipBuildingMessage\")) then\n_p(1, '@echo \"==== Building all ($(config)) ====\"')\nend\n_p(1, '@${NINJA} -C ${config} all')\n_p('')\nfor _, prj in ipairs(sln.projects) do\nlocal prjx = ninja.get_proxy(\"prj\", prj)\n_p('%s:', _MAKE.esc(prj.name))\nif (not sln.messageskip) or (not table.c"
	"ontains(sln.messageskip, \"SkipBuildingMessage\")) then\n_p(1, '@echo \"==== Building %s ($(config)) ====\"', prj.name)\nend\n_p(1, '@${NINJA} -C ${config} %s', prj.name)\n_p('')\nend\n_p('clean:')\n_p(1, '@${NINJA} -C ${config} -t clean')\n_p('')\n_p('help:')\n_p(1,'@echo \"Usage: make [config=name] [target]\"')\n_p(1,'@echo \"\"')\n_p(1,'@echo \"CONFIGURATIONS:\"')\nlocal cfgpairs = { }\nfor _, platform in ipairs(platforms) do\nfor _, cfgname in ipairs(sln.configurations) do\n_p(1,'@echo \"   %s\"', premake.getconfigname(cfgname, platform, true))\nend\nend\n_p(1,'@echo \"\"')\n_p(1,'@echo \"TARGETS:\"')\n_p(1,'@echo \"   all (default)\"')\n_p(1,'@echo \"   clean\"')\nfor _, prj in ipairs(sln.projects) do\n_p(1,'@echo \"   %s\"', prj.name)\nend\n_p(1,'@echo \"\"')\n_p(1,'@echo \"For more information, see https://github.com/bkaradzic/genie\"')\nend\nlocal generate\nlocal function getconfigs(sln, name, plat)\nlocal cfgs = {}\nfor prj in solution.eachproject(sln) do\nprj = ninja.get_proxy(\"prj\", prj)\nfor cfg "
	"in p.eachconfig(prj, plat) do\nif cfg.name == name then\ntable.insert(cfgs, cfg)\nend\nend\nend\nreturn cfgs\nend\nfunction ninja.generate_ninja_builds(sln)\nlocal cc = premake[_OPTIONS.cc]\nsln.getlocation = function(cfg, plat)\nreturn path.join(sln.location, premake.getconfigname(cfg, plat, true))\nend\nlocal platforms = premake.filterplatforms(sln, cc.platforms, \"Native\")\nfor _,plat in ipairs(platforms) do\nfor _,name in ipairs(sln.configurations) do\np.generate(sln, ninja.get_solution_name(sln, name, plat), function(sln)\ngenerate(getconfigs(sln, name, plat))\nend)\nend\nend\nend\nfunction ninja.get_solution_name(sln, cfg, plat)\nreturn path.join(sln.getlocation(cfg, plat), \"build.ninja\")\nend\nfunction generate(prjcfgs)\nlocal cfgs          = {}\nlocal cfg_start     = nil\nlocal cfg_first     = nil\nlocal cfg_first_lib = nil\n_p(\"# solution build file\")\n_p(\"# generated with GENie ninja\")\n_p(\"\")\n_p(\"# build projects\")\nfor _,cfg in ipairs(prjcfgs) do\nlocal key  = cfg.project.name\nif not c"
	"fgs[key] then cfgs[key] = \"\" end\ncfgs[key] = cfg:getoutputfilename() .. \" \"\nif not cfgs[\"all\"] then cfgs[\"all\"] = \"\" end\ncfgs[\"all\"] = cfgs[\"all\"] .. cfg:getoutputfilename() .. \" \"\nif (cfg_start == nil) and (cfg.solution.startproject == key) then\ncfg_start = key\nend\nif (cfg_first == nil) and (cfg.kind == \"ConsoleApp\" or cfg.kind == \"WindowedApp\") then\ncfg_first = key\nend\nif (cfg_first_lib == nil) and (cfg.kind == \"StaticLib\" or cfg.kind == \"SharedLib\") then\ncfg_first_lib = key\nend\n_p(\"subninja \" .. cfg:getprojectfilename())\nend\n_p(\"\")\n_p(\"# targets\")\nfor cfg, outputs in iter.sortByKeys(cfgs) do\n_p(\"build \" .. cfg .. \": phony \" .. outputs)\nend\n_p(\"\")\n_p(\"# default target\")\n_p(\"default \" .. (cfg_start or cfg_first or cfg_first_lib))\n_p(\"\")\nend\n",

	/* actions/ninja/ninja_cpp.lua */
	"premake.ninja.cpp = { }\nlocal ninja = premake.ninja\nlocal cpp   = premake.ninja.cpp\nlocal p     = premake\nlocal function wrap_ninja_cmd(c)\nif os.is(\"windows\") then\nreturn 'cmd /c \"' .. c .. '\"'\nelse\nreturn c\nend\nend\nfunction ninja.generate_cpp(prj)\nlocal pxy = ninja.get_proxy(\"prj\", prj)\nlocal tool = premake.gettool(prj)\nlocal platforms = premake.filterplatforms(prj.solution, tool.platforms, \"Native\")\nfor _, platform in ipairs(platforms) do\nfor cfg in p.eachconfig(pxy, platform) do\np.generate(cfg, cfg:getprojectfilename(), function() cpp.generate_config(prj, cfg) end)\nend\nend\nend\nfunction cpp.generate_config(prj, cfg)\nlocal tool = premake.gettool(prj)\n_p('# Ninja build project file autogenerated by GENie')\n_p('# https://github.com/bkaradzic/GENie')\n_p(\"\")\n_p(\"ninja_required_version = 1.7\")\n_p(\"\")\nlocal flags = {\ndefines   = ninja.list(tool.getdefines(cfg.defines)),\nincludes  = ninja.list(table.join(tool.getincludedirs(cfg.includedirs), tool.getquoteincludedirs(cfg.us"
	"erincludedirs), tool.getsystemincludedirs(cfg.systemincludedirs))),\ncppflags  = ninja.list(tool.getcppflags(cfg)),\nasmflags  = ninja.list(table.join(tool.getcflags(cfg), cfg.buildoptions, cfg.buildoptions_asm)),\ncflags    = ninja.list(table.join(tool.getcflags(cfg), cfg.buildoptions, cfg.buildoptions_c)),\ncxxflags  = ninja.list(table.join(tool.getcflags(cfg), tool.getcxxflags(cfg), cfg.buildoptions, cfg.buildoptions_cpp)),\nobjcflags = ninja.list(table.join(tool.getcflags(cfg), tool.getcxxflags(cfg), cfg.buildoptions, cfg.buildoptions_objc)),\n}\n_p(\"\")\n_p(\"# core rules for \" .. cfg.name)\n_p(\"rule cc\")\n_p(\"  command     = \" .. wrap_ninja_cmd(tool.cc .. \" $defines $includes $flags -MMD -MF $out.d -c -o $out $in\"))\n_p(\"  description = cc $out\")\n_p(\"  depfile     = $out.d\")\n_p(\"  deps        = gcc\")\n_p(\"\")\n_p(\"rule cxx\")\n_p(\"  command     = \" .. wrap_ninja_cmd(tool.cxx .. \" $defines $includes $flags -MMD -MF $out.d -c -o $out $in\"))\n_p(\"  description = cxx $out\")\n_p(\"  de"
	"pfile     = $out.d\")\n_p(\"  deps        = gcc\")\n_p(\"\")\nif cfg.flags.UseObjectResponseFile then\n_p(\"rule ar\")\n_p(\"  command         = \" .. wrap_ninja_cmd(tool.ar .. \" $flags $out @$out.rsp \" .. (os.is(\"MacOSX\") and \" 2>&1 > /dev/null | sed -e '/.o) has no symbols$$/d'\" or \"\")))\n_p(\"  description     = ar $out\")\n_p(\"  rspfile         = $out.rsp\")\n_p(\"  rspfile_content = $in $libs\")\n_p(\"\")\nelse\n_p(\"rule ar\")\n_p(\"  command         = \" .. wrap_ninja_cmd(tool.ar .. \" $flags $out $in $libs\" .. (os.is(\"MacOSX\") and \" 2>&1 > /dev/null | sed -e '/.o) has no symbols$$/d'\" or \"\")))\n_p(\"  description     = ar $out\")\n_p(\"\")\nend\nlocal link = iif(cfg.language == \"C\", tool.cc, tool.cxx)\n_p(\"rule link\")\nlocal startgroup = ''\nlocal endgroup = ''\nif (cfg.flags.LinkSupportCircularDependencies) then\nstartgroup = '-Wl,--start-group'\nendgroup = '-Wl,--end-group'\nend\nlocal rspfile_content = \"$all_outputfiles $walibs \" .. string.format(\"%s $libs %s\", startgroup, en"
	"dgroup)\nif cfg.flags.UseLDResponseFile then\n_p(\"  command         = \" .. wrap_ninja_cmd(\"$pre_link \" .. link .. \" -o $out @$out.rsp $all_ldflags $post_build\"))\n_p(\"  description     = link $out\")\n_p(\"  rspfile         = $out.rsp\")\n_p(\"  rspfile_content = %s\", rspfile_content)\n_p(\"\")\nelse\n_p(\"  command         = \" .. wrap_ninja_cmd(\"$pre_link \" .. link .. \" -o $out \" .. rspfile_content .. \" $all_ldflags $post_build\"))\n_p(\"  description     = link $out\")\n_p(\"\")\nend\n_p(\"rule exec\")\n_p(\"  command     = \" .. wrap_ninja_cmd(\"$command\"))\n_p(\"  description = Run $type commands\")\n_p(\"\")\nif #cfg.prebuildcommands > 0 then\n_p(\"build __prebuildcommands_\" .. premake.esc(prj.name) .. \": exec\")\n_p(1, \"command = \" .. wrap_ninja_cmd(\"echo Running pre-build commands && \" .. table.implode(cfg.prebuildcommands, \"\", \"\", \" && \")))\n_p(1, \"type    = pre-build\")\n_p(\"\")\nend\ncfg.pchheader_full = cfg.pchheader\nfor _, incdir in ipairs(cfg.includedirs) do\nlocal ab"
	"spath = path.getabsolute(path.join(cfg.project.location, cfg.shortname, incdir))\nlocal testname = path.join(abspath, cfg.pchheader_full)\nif os.isfile(testname) then\ncfg.pchheader_full = path.getrelative(cfg.location, testname)\nbreak\nend\nend\ncpp.custombuildtask(prj, cfg)\ncpp.dependencyRules(prj, cfg)\ncpp.file_rules(prj, cfg, flags)\nlocal objfiles = {}\nfor _, file in ipairs(cfg.files) do\nif path.issourcefile(file) then\ntable.insert(objfiles, cpp.objectname(cfg, file))\nend\nend\n_p('')\ncpp.linker(prj, cfg, objfiles, tool, flags)\n_p(\"\")\nend\nfunction cpp.custombuildtask(prj, cfg)\nlocal cmd_index = 1\nlocal ninja_rules = {}\nlocal ninja_builds = {}\nlocal prebuildsuffix = #cfg.prebuildcommands > 0 and \"||__prebuildcommands_\" .. premake.esc(prj.name) or \"\"\nfor _, custombuildtask in ipairs(prj.custombuildtask or {}) do\nfor _, buildtask in ipairs(custombuildtask or {}) do\nlocal commands = {}\nfor _, cmd in ipairs(buildtask[4] or {}) do\nlocal num = 1\nfor _, depdata in ipairs(buildtask[3] or"
	" {}) do\ncmd = string.gsub(cmd,\"%$%(\" .. num ..\"%)\", string.format(\"%s \", path.getrelative(cfg.location, depdata)))\nnum = num + 1\nend\ncmd = string.gsub(cmd, '%$%(<%)', '$in')\ncmd = string.gsub(cmd, '%$%(@%)', '$out')\ntable.insert(commands, cmd)\nend\nninja_rules[\"cmd_\" .. cmd_index] = commands\ntable.insert(ninja_builds, {\nfile_in = buildtask[1],\nfile_out = buildtask[2],\nrule = \"cmd_\" .. cmd_index,\ndeps = buildtask[3]\n})\ncmd_index = cmd_index + 1\nend\nend\n_p(\"# custom build rules\")\nfor rule, commands in pairs(ninja_rules) do\n_p(\"rule \" .. rule)\n_p(1, \"command = \" .. wrap_ninja_cmd(table.concat(commands, \" && \")))\nend\nfor i = 1,#ninja_builds do\nlocal build = ninja_builds[i]\nlocal deps = ''\nfor i, dep in ipairs(build.deps) do\ndeps = deps .. path.getrelative(cfg.location, dep) .. ' '\nend\n_p(\"build \" .. path.getrelative(cfg.location, build.file_out) .. ': ' .. build.rule .. ' ' .. path.getrelative(cfg.location, build.file_in) .. ' | ' .. deps .. prebuildsuffix)\n_p(\"\")"
	"\nend\nend\nfunction cpp.dependencyRules(prj, cfg)\nlocal extra_deps = {}\nlocal order_deps = {}\nlocal extra_flags = {}\nfor _, dependency in ipairs(prj.dependency or {}) do\nfor _, dep in ipairs(dependency or {}) do\nlocal objfilename = cpp.objectname(cfg, path.getrelative(prj.location, dep[1]))\nlocal dependency = path.getrelative(cfg.location, dep[2])\nif extra_deps[objfilename] == nil then\nextra_deps[objfilename] = {}\nend\ntable.insert(extra_deps[objfilename], dependency)\nend\nend\nlocal pchfilename = cfg.pchheader_full and cpp.pchname(cfg, cfg.pchheader_full) or ''\nfor _, file in ipairs(cfg.files) do\nlocal objfilename = file == cfg.pchheader and cpp.pchname(cfg, file) or cpp.objectname(cfg, file)\nif path.issourcefile(file) or file == cfg.pchheader then\nif #cfg.prebuildcommands > 0 then\nif order_deps[objfilename] == nil then\norder_deps[objfilename] = {}\nend\ntable.insert(order_deps[objfilename], '__prebuildcommands_' .. premake.esc(prj.name))\nend\nend\nif path.issourcefile(file) then\nif cfg.pc"
	"hheader_full and not cfg.flags.NoPCH then\nlocal nopch = table.icontains(prj.nopch, file)\nif not nopch then\nlocal suffix = path.isobjcfile(file) and '_objc' or ''\nif extra_deps[objfilename] == nil then\nextra_deps[objfilename] = {}\nend\ntable.insert(extra_deps[objfilename], pchfilename .. suffix .. \".gch\")\nif extra_flags[objfilename] == nil then\nextra_flags[objfilename] = {}\nend\ntable.insert(extra_flags[objfilename], '-include ' .. pchfilename .. suffix)\nend\nend\nend\nend\ncfg.extra_deps = extra_deps\ncfg.order_deps = order_deps\ncfg.extra_flags = extra_flags\nend\nfunction cpp.objectname(cfg, file)\nreturn path.join(cfg.objectsdir, path.trimdots(path.removeext(file)) .. \".o\")\nend\nfunction cpp.pchname(cfg, file)\nreturn path.join(cfg.objectsdir, path.trimdots(file))\nend\nfunction cpp.file_rules(prj,cfg, flags)\n_p(\"# build files\")\nfor _, file in ipairs(cfg.files) do\n_p(\"# FILE: \" .. file)\nif cfg.pchheader_full == file then\nlocal pchfilename = cpp.pchname(cfg, file)\nlocal extra_deps = "
	"#cfg.extra_deps and '| ' .. table.concat(cfg.extra_deps[pchfilename] or {}, ' ') or ''\nlocal order_deps = #cfg.order_deps and '|| ' .. table.concat(cfg.order_deps[pchfilename] or {}, ' ') or ''\nlocal extra_flags = #cfg.extra_flags and ' ' .. table.concat(cfg.extra_flags[pchfilename] or {}, ' ') or ''\n_p(\"build \" .. pchfilename .. \".gch : cxx \" .. file .. extra_deps .. order_deps)\n_p(1, \"flags    = \" .. flags['cxxflags'] .. extra_flags .. iif(prj.language == \"C\", \"-x c-header\", \"-x c++-header\"))\n_p(1, \"includes = \" .. flags.includes)\n_p(1, \"defines  = \" .. flags.defines)\n_p(\"build \" .. pchfilename .. \"_objc.gch : cxx \" .. file .. extra_deps .. order_deps)\n_p(1, \"flags    = \" .. flags['objcflags'] .. extra_flags .. iif(prj.language == \"C\", \"-x objective-c-header\", \"-x objective-c++-header\"))\n_p(1, \"includes = \" .. flags.includes)\n_p(1, \"defines  = \" .. flags.defines)\nelseif path.issourcefile(file) then\nlocal objfilename = cpp.objectname(cfg, file)\nlocal extra_deps = #"
	"cfg.extra_deps and '| ' .. table.concat(cfg.extra_deps[objfilename] or {}, ' ') or ''\nlocal order_deps = #cfg.order_deps and '|| ' .. table.concat(cfg.order_deps[objfilename] or {}, ' ') or ''\nlocal extra_flags = #cfg.extra_flags and ' ' .. table.concat(cfg.extra_flags[objfilename] or {}, ' ') or ''\nlocal cflags = \"cflags\"\nif path.isobjcfile(file) then\n_p(\"build \" .. objfilename .. \": cxx \" .. file .. extra_deps .. order_deps)\ncflags = \"objcflags\"\nelseif path.isasmfile(file) then\n_p(\"build \" .. objfilename .. \": cc \" .. file .. extra_deps .. order_deps)\ncflags = \"asmflags\"\nelseif path.iscfile(file) and not cfg.options.ForceCPP then\n_p(\"build \" .. objfilename .. \": cc \" .. file .. extra_deps .. order_deps)\nelse\n_p(\"build \" .. objfilename .. \": cxx \" .. file .. extra_deps .. order_deps)\ncflags = \"cxxflags\"\nend\n_p(1, \"flags    = \" .. flags[cflags] .. extra_flags)\n_p(1, \"includes = \" .. flags.includes)\n_p(1, \"defines  = \" .. flags.defines)\nelseif path.isresourcefile"
	"(file) then\nend\nend\n_p(\"\")\nend\nfunction cpp.linker(prj, cfg, objfiles, tool)\nlocal all_ldflags    = ninja.list(table.join(tool.getlibdirflags(cfg), tool.getldflags(cfg), cfg.linkoptions))\nlocal prebuildsuffix = #cfg.prebuildcommands > 0 and (\"||__prebuildcommands_\" .. premake.esc(prj.name)) or \"\"\nlocal libs           = {}\nlocal walibs         = {}\nlocal lddeps         = {}\nif #cfg.wholearchive > 0 then\nfor _, linkcfg in ipairs(premake.getlinks(cfg, \"siblings\", \"object\")) do\nlocal linkpath = path.rebase(linkcfg.linktarget.fullpath, linkcfg.location, cfg.location)\ntable.insert(lddeps, linkpath)\nif table.icontains(cfg.wholearchive, linkcfg.project.name) then\ntable.insert(walibs, table.concat(tool.wholearchive(linkpath), ' '))\nelse\ntable.insert(libs, linkpath)\nend\nend\nelse\nlddeps = premake.getlinks(cfg, \"siblings\", \"fullpath\")\nlibs   = lddeps\nend\nlddeps               = ninja.list(lddeps)\nlibs                 = ninja.list(libs) .. \" \" .. ninja.list(tool.getlinkflags(cfg))\n"
	"walibs               = ninja.list(walibs)\nlocal function writevars()\n_p(1, \"all_ldflags     = \" .. all_ldflags)\n_p(1, \"libs            = \" .. libs)\n_p(1, \"walibs          = \" .. walibs)\n_p(1, \"all_outputfiles = \" .. table.concat(objfiles, \" \"))\nif #cfg.prelinkcommands > 0 then\n_p(1, 'pre_link        = echo Running pre-link commands && ' .. table.implode(cfg.prelinkcommands, \"\", \"\", \" && \") .. \" && \")\nend\nif #cfg.postbuildcommands > 0 then\n_p(1, 'post_build      = && echo Running post-build commands && ' .. table.implode(cfg.postbuildcommands, \"\", \"\", \" && \"))\nend\nend\nif cfg.kind == \"StaticLib\" then\nlocal ar_flags = ninja.list(tool.getarchiveflags(cfg, cfg, false))\n_p(\"# link static lib\")\n_p(\"build \" .. cfg:getoutputfilename() .. \": ar \" .. table.concat(objfiles, \" \") .. \" | \" .. lddeps .. prebuildsuffix)\n_p(1, \"flags = \" .. ninja.list(tool.getarchiveflags(cfg, cfg, false)))\n_p(1, \"all_outputfiles = \" .. table.concat(objfiles, \" \"))\nelseif cfg.kind =="
	" \"SharedLib\" or cfg.kind == \"Bundle\" then\nlocal output = cfg:getoutputfilename()\n_p(\"# link shared lib\")\n_p(\"build \" .. output .. \": link \" .. table.concat(objfiles, \" \") .. \" | \" .. lddeps .. prebuildsuffix)\nwritevars()\nelseif (cfg.kind == \"ConsoleApp\") or (cfg.kind == \"WindowedApp\") then\n_p(\"# link executable\")\n_p(\"build \" .. cfg:getoutputfilename() .. \": link \" .. table.concat(objfiles, \" \") .. \" | \" .. lddeps .. prebuildsuffix)\nwritevars()\nelse\np.error(\"ninja action doesn't support this kind of target \" .. cfg.kind)\nend\nend\n",

	/* actions/ninja/ninja_swift.lua */
	"local ninja = premake.ninja\nlocal swift = {}\nlocal p     = premake\nfunction ninja.generate_swift(prj)\nlocal pxy = ninja.get_proxy(\"prj\", prj)\nlocal tool = premake.gettool(prj)\nlocal platforms = premake.filterplatforms(prj.solution, tool.platforms, \"Native\")\nfor _, platform in ipairs(platforms) do\nfor cfg in p.eachconfig(pxy, platform) do\np.generate(cfg, cfg:getprojectfilename(), function() swift.generate_config(prj, cfg) end)\nend\nend\nend\nfunction swift.generate_config(prj, cfg)\nlocal tool = premake.gettool(prj)\nlocal flags = {\nswiftcflags    = ninja.list(tool.getswiftcflags(cfg)),\nswiftlinkflags = ninja.list(tool.getswiftlinkflags(cfg)),\n}\n_p(\"# Swift project build file\")\n_p(\"# generated with GENie ninja\")\n_p(\"\")\n_p(\"ninja_required_version = 1.7\")\n_p(\"\")\n_p(\"out_dir = %s\", cfg.buildtarget.directory)\n_p(\"obj_dir = %s\", path.join(cfg.objectsdir, prj.name .. \".build\"))\n_p(\"target = $out_dir/%s\", cfg.buildtarget.name)\n_p(\"module_name = %s\", prj.name)\n_p(\"module_"
	"maps = %s\", ninja.list(tool.getmodulemaps(cfg)))\n_p(\"swiftc_flags = %s\", flags.swiftcflags)\n_p(\"swiftlink_flags = %s\", flags.swiftlinkflags)\n_p(\"ar_flags = %s\", ninja.list(tool.getarchiveflags(cfg, cfg, false)))\n_p(\"ld_flags = %s\", ninja.list(tool.getldflags(cfg)))\nif cfg.flags.Symbols then\n_p(\"symbols = $target.dSYM\")\nsymbols_command = string.format(\"&& %s $target -o $symbols\", tool.dsymutil)\nelse\n_p(\"symbols = \")\nsymbols_command = \"\"\nend\nlocal sdk = tool.get_sdk_path(cfg)\nif sdk then\n_p(\"toolchain_path = %s\", tool.get_toolchain_path(cfg))\n_p(\"sdk_path = %s\", sdk)\n_p(\"platform_path = %s\", tool.get_sdk_platform_path(cfg))\n_p(\"sdk = -sdk $sdk_path\")\nelse\n_p(\"sdk_path =\")\n_p(\"sdk =\")\nend\n_p(\"\")\n_p(\"# core rules for %s\", cfg.name)\n_p(\"rule swiftc\")\n_p(1, \"command = %s -frontend -c $in -enable-objc-interop $sdk -I $out_dir $swiftc_flags -module-cache-path $out_dir/ModuleCache -D SWIFT_PACKAGE $module_maps -emit-module-doc-path $out_dir/$module_name.swift"
	"doc -module-name $module_name -emit-module-path $out_dir/$module_name.swiftmodule -num-threads 8 $obj_files\", tool.swift)\n_p(1, \"description = compile $out\")\n_p(\"\")\n_p(\"rule swiftlink\")\n_p(1, \"command = %s $sdk -L $out_dir -o $out $swiftlink_flags $ld_flags $in %s\", tool.swiftc, symbols_command)\n_p(1, \"description = create executable\")\n_p(\"\")\n_p(\"rule ar\")\n_p(1, \"command = %s cr $ar_flags $out $in %s\", tool.ar, (os.is(\"MacOSX\") and \" 2>&1 > /dev/null | sed -e '/.o) has no symbols$$/d'\" or \"\"))\n_p(1, \"description = ar $out\")\n_p(\"\")\nlocal objfiles = {}\nfor _, file in ipairs(cfg.files) do\nif path.isswiftfile(file) then\ntable.insert(objfiles, swift.objectname(cfg, file))\nend\nend\nswift.file_rules(cfg, objfiles)\n_p(\"\")\nswift.linker(prj, cfg, objfiles, tool)\nend\nfunction swift.objectname(cfg, file)\nreturn path.join(\"$obj_dir\", path.getname(file)..\".o\")\nend\nfunction swift.file_rules(cfg, objfiles)\n_p(\"build %s: swiftc %s\", ninja.list(objfiles), ninja.list(cfg"
	".files))\n_p(1, \"obj_files = %s\", ninja.arglist(\"-o\", objfiles))\nend\nfunction swift.linker(prj, cfg, objfiles, tool)\nlocal lddeps = ninja.list(premake.getlinks(cfg, \"siblings\", \"fullpath\")) \nif cfg.kind == \"StaticLib\" then\n_p(\"build $target: ar %s | %s \", ninja.list(objfiles), lddeps)\nelse\nlocal lddeps = ninja.list(premake.getlinks(cfg, \"siblings\", \"fullpath\"))\n_p(\"build $target: swiftlink %s | %s\", ninja.list(objfiles), lddeps)\nend\nend\n",

	/* actions/ninja/ninja_swift_incremental.lua */
	"local ninja = premake.ninja\nlocal swift = { }\nlocal p     = premake\nfunction ninja.generate_swift_incremental(prj)\nlocal pxy = ninja.get_proxy(\"prj\", prj)\nlocal tool = premake.gettool(prj)\nlocal platforms = premake.filterplatforms(prj.solution, tool.platforms, \"Native\")\nfor _, platform in ipairs(platforms) do\nfor cfg in p.eachconfig(pxy, platform) do\np.generate(cfg, cfg:getprojectfilename(), function() swift.generate_config(prj, cfg) end)\nend\nend\nend\nfunction swift.generate_config(prj, cfg)\nlocal tool = premake.gettool(prj)\nlocal flags = {\nswiftcflags = ninja.list(table.join(tool.getswiftcflags(cfg), cfg.buildoptions_swiftc)),\n}\n_p(\"# Swift project build file\")\n_p(\"# generated with GENie ninja\")\n_p(\"\")\n_p(\"ninja_required_version = 1.7\")\n_p(\"\")\n_p(\"out_dir = %s\", cfg.buildtarget.directory)\n_p(\"obj_dir = %s\", path.join(cfg.objectsdir, prj.name .. \".build\"))\n_p(\"module_name = %s\", prj.name)\n_p(\"module_maps = %s\", ninja.list(tool.getmodulemaps(cfg)))\n_p(\"swiftc_f"
	"lags = %s\", flags.swiftcflags)\n_p(\"swiftlink_flags = %s\", flags.swiftlinkflags)\n_p(\"ar_flags = %s\", ninja.list(tool.getarchiveflags(cfg, cfg, false)))\nlocal sdk = tool.get_sdk_path(cfg)\nif sdk then\n_p(\"toolchain_path = %s\", tool.get_toolchain_path(cfg))\n_p(\"sdk_path = %s\", sdk)\n_p(\"platform_path = %s\", tool.get_sdk_platform_path(cfg))\n_p(\"sdk = -sdk $sdk_path\")\n_p(\"ld_baseflags = -force_load $toolchain_path/usr/lib/arc/libarclite_macosx.a -L $out_dir -F $platform_path/Developer/Library/Frameworks -syslibroot $sdk_path -lobjc -lSystem -L $toolchain_path/usr/lib/swift/macosx -rpath $toolchain_path/usr/lib/swift/macosx -macosx_version_min 10.10.0 -no_objc_category_merging\")\nelse\n_p(\"sdk_path =\")\n_p(\"sdk =\")\n_p(\"ld_baseflags =\")\nend\n_p(\"\")\n_p(\"# core rules for %s\", cfg.name)\n_p(\"rule swiftc\")\n_p(1, \"command = %s -frontend -c -primary-file $in $files $target -enable-objc-interop $sdk -I $out_dir -enable-testing -module-cache-path $out_dir/ModuleCache -D SWIFT_PACKAGE $m"
	"odule_maps -emit-module-doc-path $out_doc_name swiftc_flags -module-name $module_name -emit-module-path $out_module_name -emit-dependencies-path $out.d -emit-reference-dependencies-path $obj_dir/$basename.swiftdeps -o $out\", tool.swiftc)\n_p(1, \"description = compile $out\")\n_p(\"\")\n_p(\"rule swiftm\")\n_p(1, \"command = %s -frontend -emit-module $in $parse_as_library swiftc_flags $target -enable-objc-interop $sdk -I $out_dir -F $platform_path/Developer/Library/Frameworks -enable-testing -module-cache-path $out_dir/ModuleCache -D SWIFT_PACKAGE $module_maps -emit-module-doc-path $out_dir/$module_name.swiftdoc -module-name $module_name -o $out\", tool.swift)\n_p(1, \"description = generate module\")\n_p(\"\")\n_p(\"rule swiftlink\")\n_p(1, \"command = %s $target $sdk $swiftlink_flags -L $out_dir -o $out_dir/$module_name -F $platform_path/Developer/Library/Frameworks $in\", tool.swiftc)\n_p(1, \"description = linking $target\")\n_p(\"\")\n_p(\"rule ar\")\n_p(1, \"command = %s cr $ar_flags $out $in $libs %s\""
	", tool.ar, (os.is(\"MacOSX\") and \" 2>&1 > /dev/null | sed -e '/.o) has no symbols$$/d'\" or \"\"))\n_p(1, \"description = ar $out\")\n_p(\"\")\n_p(\"rule link\")\n_p(\"  command = %s $in $ld_baseflags $all_ldflags $libs -o $out\", tool.ld)\n_p(\"  description = link $out\")\n_p(\"\")\nswift.file_rules(cfg, flags)\nlocal objfiles = {}\nlocal modfiles = {}\nlocal docfiles = {}\nfor _, file in ipairs(cfg.files) do\nif path.issourcefile(file) then\ntable.insert(objfiles, swift.objectname(cfg, file))\ntable.insert(modfiles, swift.modulename(cfg, file))\ntable.insert(docfiles, swift.docname(cfg, file))\nend\nend\n_p(\"\")\nswift.linker(prj, cfg, {objfiles, modfiles, docfiles}, tool, flags)\n_p(\"\")\nend\nfunction swift.objectname(cfg, file)\nreturn path.join(\"$obj_dir\", path.getname(file)..\".o\")\nend\nfunction swift.modulename(cfg, file)\nreturn path.join(\"$obj_dir\", path.getname(file)..\".o.swiftmodule\")\nend\nfunction swift.docname(cfg, file)\nreturn path.join(\"$obj_dir\", path.getname(file)..\".o.swift"
	"doc\")\nend\nfunction swift.file_rules(cfg, flags)\n_p(\"# build files\")\nlocal sfiles = Set(cfg.files)\nfor _, file in ipairs(cfg.files) do\nif path.issourcefile(file) then\nif path.isswiftfile(file) then\nlocal objn = swift.objectname(cfg, file)\nlocal modn = swift.modulename(cfg, file)\nlocal docn = swift.docname(cfg, file)\n_p(\"build %s | %s %s: swiftc %s\", objn, modn, docn, file)\n_p(1, \"out_module_name = %s\", modn)\n_p(1, \"out_doc_name = %s\", docn)\n_p(1, \"files = \".. ninja.list(sfiles - {file}))\nbuild_flags = \"swiftcflags\"\nend\n_p(1, \"flags    = \" .. flags[build_flags])\nelseif path.isresourcefile(file) then\nend\nend\n_p(\"\")\nend\nfunction swift.linker(prj, cfg, depfiles, tool)\nlocal all_ldflags = ninja.list(table.join(tool.getlibdirflags(cfg), tool.getldflags(cfg), cfg.linkoptions))\nlocal lddeps      = ninja.list(premake.getlinks(cfg, \"siblings\", \"fullpath\")) \nlocal libs        = lddeps .. \" \" .. ninja.list(tool.getlinkflags(cfg))\nlocal function writevars()\n_p(1, \"all_ldfl"
	"ags = \" .. all_ldflags)\n_p(1, \"libs        = \" .. libs)\nend\nlocal objfiles, modfiles, docfiles = table.unpack(depfiles)\n_p(\"build $out_dir/$module_name.swiftmodule | $out_dir/$module_name.swiftdoc: swiftm %s | %s\", table.concat(modfiles, \" \"), table.concat(docfiles, \" \"))\n_p(\"\")\nlocal output = cfg:getoutputfilename()\nif cfg.kind == \"StaticLib\" then\nlocal ar_flags = ninja.list(tool.getarchiveflags(cfg, cfg, false))\n_p(\"build %s: ar %s | %s $out_dir/$module_name.swiftmodule $out_dir/$module_name.swiftdoc\", output, table.concat(objfiles, \" \"), lddeps)\n_p(1, \"flags = %s\", ninja.list(tool.getarchiveflags(cfg, cfg, false)))\nelseif cfg.kind == \"SharedLib\" then\n_p(\"build %s : swiftlink %s | %s $out_dir/$module_name.swiftmodule $out_dir/$module_name.swiftdoc\", output, table.concat(objfiles, \" \"), libs)\nwritevars()\nelseif (cfg.kind == \"ConsoleApp\") or (cfg.kind == \"WindowedApp\") then\n_p(\"build %s: swiftlink %s | %s $out_dir/$module_name.swiftmodule $out_dir/$module_name.swift"
	"doc\", output, table.concat(objfiles, \" \"), lddeps)\nelse\np.error(\"ninja action doesn't support this kind of target \" .. cfg.kind)\nend\nend\n",

	/* actions/jcdb/_jcdb.lua */
	"newaction {\ntrigger = \"jcdb\",\nshortname = \"compile_commands.json\",\ndescription = \"Generate a compile_commands.json file.\",\nvalid_kinds = { \"ConsoleApp\", \"WindowedApp\", \"StaticLib\", \"SharedLib\", \"Bundle\" },\nvalid_languages = { \"C\", \"C++\" },\nvalid_tools = { cc = { \"gcc\" } },\nonsolution = function(sln)\nlocal jsonpath = path.join(sln.location, \"compile_commands.json\")\npremake.generate(sln, jsonpath, premake.jcdb.generate)\nend,\n}\n",

	/* actions/jcdb/jcdb_solution.lua */
	"premake.jcdb = {}\nlocal premake = premake\nlocal jcdb = premake.jcdb\nlocal encode_chars = {\n[0x22] = '\\\\\"',\n[0x5c] = \"\\\\\\\\\",\n[0x08] = \"\\\\b\",\n[0x0c] = \"\\\\f\",\n[0x0a] = \"\\\\n\",\n[0x0d] = \"\\\\r\",\n[0x09] = \"\\\\t\",\n}\nlocal function encode_string(s)\nlocal res = '\"'\nfor _, cp in utf8.codes(s) do\nif encode_chars[cp] then\nres = res..encode_chars[cp]\nelseif cp < 32 then\nres = res..string.format(\"\\\\u%04x\", cp)\nelse\nres = res..utf8.char(cp)\nend\nend\nreturn res..'\"'\nend\nlocal function escape_cmdline_arg(s)\nif s:find(\"%s\") then\ns = s:gsub(\"\\\\\", \"\\\\\\\\\")\ns = s:gsub('\"', '\\\\\"')\ns = '\"'..s..'\"'\nend\nreturn s\nend\nlocal function list(tbl)\nreturn iif(#tbl > 0, \" \"..table.concat(tbl, \" \"), \"\")\nend\nlocal function build_command(cfg, cc, file)\nlocal cmdline = \"\"\nlocal function app(s) cmdline = cmdline..s end\nif path.iscfile(file) or path.isasmfile(file) then\napp(cc.cc)\nelse\napp(cc.cxx)\nend\napp(list(cc.getcppflags(cfg)))\napp(list(cc.getdef"
	"ines(cfg.defines)))\napp(list(cc.getincludedirs(cfg.includedirs)))\napp(list(cc.getquoteincludedirs(cfg.userincludedirs)))\napp(list(cc.getsystemincludedirs(cfg.systemincludedirs)))\napp(list(cc.getcflags(cfg)))\nif path.iscppfile(file) then\napp(list(cc.getcxxflags(cfg)))\nend\nif path.isasmfile(file) then\napp(list(cfg.buildoptions))\napp(list(cfg.buildoptions_asm))\nelseif path.isobjcfile(file) then\nlocal opts = iif(path.iscfile(file), cfg.buildoptions_objc, cfg.buildoptions_objcpp)\napp(list(cc.getobjcflags(cfg)))\napp(list(cfg.buildoptions))\napp(list(opts))\nelseif path.iscfile(file) then\napp(list(cfg.buildoptions))\napp(list(cfg.buildoptions_c))\nelse\napp(list(cfg.buildoptions))\napp(list(cfg.buildoptions_cpp))\nend\nif cfg.pchheader and not cfg.flags.NoPCH then\napp(\" -include \")\napp(escape_cmdline_arg(cfg.pchheader))\nend\nfor _, i in ipairs(cfg.forcedincludes) do\napp(\" -include \")\napp(escape_cmdline_arg(i))\nend\nlocal base = path.trimdots(path.removeext(file))..\".o\"\nlocal output = path."
	"join(cfg.objectsdir, base)\napp(\" -o \")\napp(escape_cmdline_arg(output))\napp(\" -c \")\napp(escape_cmdline_arg(file))\nreturn cmdline\nend\nfunction jcdb.generate_config(prj, cfg, cc)\ntable.sort(cfg.files)\nlocal directory = path.getabsolute(prj.location)\nfor _, file in ipairs(cfg.files) do\nif path.iscppfile(file) or path.isasmfile(file) then\n_p('  { \"directory\": %s,', encode_string(directory))\n_p('    \"command\": %s,', encode_string(build_command(cfg, cc, file)))\n_p('    \"file\": %s },', encode_string(file))\nend\nend\nend\nfunction jcdb.generate_project(prj)\nlocal cc = premake.gettool(prj)\nlocal platforms = premake.filterplatforms(prj.solution, cc.platforms, \"Native\")\nfor _, platform in ipairs(platforms) do\nfor cfg in premake.eachconfig(prj, platform) do\njcdb.generate_config(prj, cfg, cc)\nend\nend\nend\nfunction jcdb.generate(sln)\nfor _, prj in ipairs(sln.projects) do\njcdb.generate_project(prj)\nend\nio.captured = io.captured:gsub(\",%s$\", \"\")\nio.captured = \"[\"..io.eol..io.captur"
	"ed..io.eol..\"]\"\nend\n",

	/* _premake_main.lua */
	"_WORKING_DIR        = os.getcwd()\nlocal function injectplatform(platform)\nif not platform then return true end\nplatform = premake.checkvalue(platform, premake.fields.platforms.allowed)\nfor sln in premake.solution.each() do\nlocal platforms = sln.platforms or { }\nif #platforms == 0 then\ntable.insert(platforms, \"Native\")\nend\nif not table.contains(platforms, \"Native\") then\nreturn false, sln.name .. \" does not target native platform\\nNative platform settings are required for the --platform feature.\"\nend\nif not table.contains(platforms, platform) then\ntable.insert(platforms, platform)\nend\nsln.platforms = platforms\nend\nreturn true\nend\nfunction _premake_main(scriptpath)\nif (scriptpath) then\nlocal scripts  = dofile(scriptpath .. \"/_manifest.lua\")\nfor _,v in ipairs(scripts) do\ndofile(scriptpath .. \"/\" .. v)\nend\nend\nlocal profiler = newProfiler()\nif (nil ~= _OPTIONS[\"debug-profiler\"]) then\nprofiler:start()\nend\n_PREMAKE_COMMAND = path.getabsolute(_PREMAKE_COMMAND)\npremake.action"
	".set(_ACTION)\nmath.randomseed(os.time())\nif (nil ~= _OPTIONS[\"file\"]) then\nlocal fname = _OPTIONS[\"file\"]\nif (os.isfile(fname)) then\ndofile(fname)\nelse\nerror(\"No genie script '\" .. fname .. \"' found!\", 2)\nend\nelse\nlocal dir, name = premake.findDefaultScript(path.getabsolute(\"./\"))\nif dir ~= nil then\nlocal cwd = os.getcwd()\nos.chdir(dir)\ndofile(name)\nos.chdir(cwd)\nend\nend\nif (_OPTIONS[\"version\"] or _OPTIONS[\"help\"] or not _ACTION) then\nprintf(\"GENie - Project generator tool %s\", _GENIE_VERSION_STR)\nprintf(\"https://github.com/bkaradzic/GENie\")\nif (not _OPTIONS[\"version\"]) then\npremake.showhelp()\nend\nreturn 1\nend\naction = premake.action.current()\nif (not action) then\nerror(\"Error: no such action '\" .. _ACTION .. \"'\", 0)\nend\nok, err = premake.option.validate(_OPTIONS)\nif (not ok) then error(\"Error: \" .. err, 0) end\nok, err = premake.checktools()\nif (not ok) then error(\"Error: \" .. err, 0) end\nok, err = injectplatform(_OPTIONS[\"platform\"])\nif (not ok)"
	" then error(\"Error: \" .. err, 0) end\nprint(\"Building configurations...\")\npremake.bake.buildconfigs()\nok, err = premake.checkprojects()\nif (not ok) then error(\"Error: \" .. err, 0) end\npremake.stats = { }\npremake.stats.num_generated = 0\npremake.stats.num_skipped   = 0\nprintf(\"Running action '%s'...\", action.trigger)\npremake.action.call(action.trigger)\nif (nil ~= _OPTIONS[\"debug-profiler\"]) then\nprofiler:stop()\nlocal filePath = path.getabsolute(\"GENie-profile.txt\")\nprint(\"Writing debug-profile report to ''\" .. filePath .. \"'.\")\nlocal outfile = io.open(filePath, \"w+\")\nprofiler:report(outfile, true)\noutfile:close()\nend\nprintf(\"Done. Generated %d/%d projects.\"\n, premake.stats.num_generated\n, premake.stats.num_generated+premake.stats.num_skipped\n)\nreturn 0\nend\n",

	0
};
