/*
 * Decompiled with CFR 0.152.
 */
package com.ing.data.cassandra.jdbc.types;

import com.ing.data.cassandra.jdbc.types.AbstractJdbcType;
import java.math.BigDecimal;
import java.nio.ByteBuffer;

public class JdbcDecimal
extends AbstractJdbcType<BigDecimal> {
    public static final JdbcDecimal INSTANCE = new JdbcDecimal();
    private static final int DEFAULT_DECIMAL_PRECISION = 0;

    JdbcDecimal() {
    }

    @Override
    public boolean isCaseSensitive() {
        return false;
    }

    @Override
    public int getScale(BigDecimal obj) {
        if (obj != null) {
            return obj.scale();
        }
        return 0;
    }

    @Override
    public int getPrecision(BigDecimal obj) {
        if (obj != null) {
            return obj.precision();
        }
        return 0;
    }

    @Override
    public boolean isCurrency() {
        return false;
    }

    @Override
    public boolean isSigned() {
        return true;
    }

    @Override
    public String toString(BigDecimal obj) {
        if (obj != null) {
            return obj.toPlainString();
        }
        return null;
    }

    @Override
    public boolean needsQuotes() {
        return false;
    }

    public String getString(ByteBuffer bytes) {
        if (bytes == null) {
            return "NULL";
        }
        if (bytes.remaining() == 0) {
            return "empty";
        }
        return this.compose(bytes).toPlainString();
    }

    @Override
    public Class<BigDecimal> getType() {
        return BigDecimal.class;
    }

    @Override
    public int getJdbcType() {
        return 3;
    }

    @Override
    public BigDecimal compose(Object value) {
        return (BigDecimal)value;
    }

    @Override
    public Object decompose(BigDecimal value) {
        return value;
    }
}

