//    SPDX-License-Identifier: LGPL-3.0-or-later
/*
   This file is part of FlexiBLAS, a BLAS/LAPACK interface wrapper library.
   Copyright (C) 2013-2025 Martin Koehler

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License as published by the Free Software Foundation; either
   version 3 of the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public License
   along with this program; if not, write to the Free Software Foundation,
   Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
   */



#ifndef FLEXIBLAS_STRUCTURES_H
#define FLEXIBLAS_STRUCTURES_H

#include <stdint.h>
#include <complex.h>
#include <pthread.h>

#ifdef __cplusplus
extern "C" {
#endif

#include "flexiblas_backend.h"

#define POS_FBLAS 0
#define POS_CBLAS 1
#define FLEXIBLAS_MAX_HOOKS 256

    struct flexiblas_blasfn {
        void *f77_blas_function;
        void *cblas_function;
        void *cblas_real;
        void *fblas_real;
        void *call_fblas;

        double timings[2];
        unsigned long calls[2];
    };

    struct flexiblas_hook_fn {
        void *f77_hook_function[256];
        uint16_t nhook;
        void *cblas_hook_function[256];
        uint16_t cblas_nhook;
    };



    typedef void (*flexiblas_info_function_t)(flexiblas_info_t *);
    typedef int (*flexiblas_init_function_t)(void);
    typedef void (*flexiblas_exit_function_t)(void);
    typedef void (*flexiblas_set_num_threads_function_t)(int threads);
    typedef int (*flexiblas_get_num_threads_function_t)(void);
    typedef int (*flexiblas_get_num_procs_function_t)(void);			// TODO is this procedure implemented yet, if so where and what EXACTLY does it return?

#ifdef FLEXIBLAS_LAPACK

#ifdef FLEXIBLAS_LAPACK_3_12_0
#include "lapack_interface/structures_lapack_3_12_0.h"
#endif
#ifdef FLEXIBLAS_LAPACK_3_12_0_WODPRC
#include "lapack_interface/structures_lapack_3_12_0-wodprc.h"
#endif


#ifdef FLEXIBLAS_LAPACK_3_11_0
#include "lapack_interface/structures_lapack_3_11_0.h"
#endif
#ifdef FLEXIBLAS_LAPACK_3_11_0_WODPRC
#include "lapack_interface/structures_lapack_3_11_0-wodprc.h"
#endif


#ifdef FLEXIBLAS_LAPACK_3_10_1
#include "lapack_interface/structures_lapack_3_10_1.h"
#endif
#ifdef FLEXIBLAS_LAPACK_3_10_1_WODPRC
#include "lapack_interface/structures_lapack_3_10_1-wodprc.h"
#endif


#ifdef FLEXIBLAS_LAPACK_3_10_0
#include "lapack_interface/structures_lapack_3_10_0.h"
#endif
#ifdef FLEXIBLAS_LAPACK_3_10_0_WODPRC
#include "lapack_interface/structures_lapack_3_10_0-wodprc.h"
#endif

#ifdef FLEXIBLAS_LAPACK_3_9_1
#include "lapack_interface/structures_lapack_3_9_1.h"
#endif
#ifdef FLEXIBLAS_LAPACK_3_9_1_WODPRC
#include "lapack_interface/structures_lapack_3_9_1-wodprc.h"
#endif

#ifdef FLEXIBLAS_LAPACK_3_9_0
#include "lapack_interface/structures_lapack_3_9_0.h"
#endif
#ifdef FLEXIBLAS_LAPACK_3_9_0_WODPRC
#include "lapack_interface/structures_lapack_3_9_0-wodprc.h"
#endif

#ifdef FLEXIBLAS_LAPACK_3_8_0
#include "lapack_interface/structures_lapack_3_8_0.h"
#endif
#ifdef FLEXIBLAS_LAPACK_3_8_0_WODPRC
#include "lapack_interface/structures_lapack_3_8_0-wodprc.h"
#endif

#ifdef FLEXIBLAS_LAPACK_3_7_0
#include "lapack_interface/structures_lapack_3_7_0.h"
#endif
#ifdef FLEXIBLAS_LAPACK_3_7_0_WODPRC
#include "lapack_interface/structures_lapack_3_7_0-wodprc.h"
#endif

#ifdef FLEXIBLAS_LAPACK_3_6_1
#include "lapack_interface/structures_lapack_3_6_1.h"
#endif
#ifdef FLEXIBLAS_LAPACK_3_6_1_WODPRC
#include "lapack_interface/structures_lapack_3_6_1-wodprc.h"
#endif
#ifdef FLEXIBLAS_LAPACK_3_6_0
#include "lapack_interface/structures_lapack_3_6_0.h"
#endif
#ifdef FLEXIBLAS_LAPACK_3_6_0_WODPRC
#include "lapack_interface/structures_lapack_3_6_0-wodprc.h"
#endif
#ifdef FLEXIBLAS_LAPACK_3_5_0
#include "lapack_interface/structures_lapack_3_5_0.h"
#endif
#ifdef FLEXIBLAS_LAPACK_3_4_2
#include "lapack_interface/structures_lapack_3_4_2.h"
#endif
#ifdef FLEXIBLAS_LAPACK_3_4_1
#include "lapack_interface/structures_lapack_3_4_1.h"
#endif
#ifdef FLEXIBLAS_LAPACK_3_4_0
#include "lapack_interface/structures_lapack_3_4_0.h"
#endif
#ifdef FLEXIBLAS_LAPACK_3_3_1
#include "lapack_interface/structures_lapack_3_3_1.h"
#endif
#ifdef FLEXIBLAS_LAPACK_3_3_0
#include "lapack_interface/structures_lapack_3_3_0.h"
#endif


#endif

    typedef struct _flexiblas_blas_backend {
        struct flexiblas_blasfn caxpy;
        struct flexiblas_blasfn ccopy;
        struct flexiblas_blasfn cdotc;
        struct flexiblas_blasfn cdotu;
        struct flexiblas_blasfn cgbmv;
        struct flexiblas_blasfn cgemm;
        struct flexiblas_blasfn cgemmt;
        struct flexiblas_blasfn cgemmtr;
        struct flexiblas_blasfn cgemv;
        struct flexiblas_blasfn cgerc;
        struct flexiblas_blasfn cgeru;
        struct flexiblas_blasfn chbmv;
        struct flexiblas_blasfn chemm;
        struct flexiblas_blasfn chemv;
        struct flexiblas_blasfn cher;
        struct flexiblas_blasfn cher2;
        struct flexiblas_blasfn cher2k;
        struct flexiblas_blasfn cherk;
        struct flexiblas_blasfn chpmv;
        struct flexiblas_blasfn chpr;
        struct flexiblas_blasfn chpr2;
        struct flexiblas_blasfn crotg;
        struct flexiblas_blasfn cscal;
        struct flexiblas_blasfn csrot;
        struct flexiblas_blasfn csscal;
        struct flexiblas_blasfn cswap;
        struct flexiblas_blasfn csymm;
        struct flexiblas_blasfn csyr2k;
        struct flexiblas_blasfn csyrk;
        struct flexiblas_blasfn ctbmv;
        struct flexiblas_blasfn ctbsv;
        struct flexiblas_blasfn ctpmv;
        struct flexiblas_blasfn ctpsv;
        struct flexiblas_blasfn ctrmm;
        struct flexiblas_blasfn ctrmv;
        struct flexiblas_blasfn ctrsm;
        struct flexiblas_blasfn ctrsv;
        struct flexiblas_blasfn dasum;
        struct flexiblas_blasfn daxpy;
        struct flexiblas_blasfn dcopy;
        struct flexiblas_blasfn ddot;
        struct flexiblas_blasfn dgbmv;
        struct flexiblas_blasfn dgemm;
        struct flexiblas_blasfn dgemmt;
        struct flexiblas_blasfn dgemmtr;
        struct flexiblas_blasfn dgemv;
        struct flexiblas_blasfn dger;
        struct flexiblas_blasfn dnrm2;
        struct flexiblas_blasfn drot;
        struct flexiblas_blasfn drotg;
        struct flexiblas_blasfn drotm;
        struct flexiblas_blasfn drotmg;
        struct flexiblas_blasfn dsbmv;
        struct flexiblas_blasfn dscal;
        struct flexiblas_blasfn dsdot;
        struct flexiblas_blasfn dspmv;
        struct flexiblas_blasfn dspr;
        struct flexiblas_blasfn dspr2;
        struct flexiblas_blasfn dswap;
        struct flexiblas_blasfn dsymm;
        struct flexiblas_blasfn dsymv;
        struct flexiblas_blasfn dsyr;
        struct flexiblas_blasfn dsyr2;
        struct flexiblas_blasfn dsyr2k;
        struct flexiblas_blasfn dsyrk;
        struct flexiblas_blasfn dtbmv;
        struct flexiblas_blasfn dtbsv;
        struct flexiblas_blasfn dtpmv;
        struct flexiblas_blasfn dtpsv;
        struct flexiblas_blasfn dtrmm;
        struct flexiblas_blasfn dtrmv;
        struct flexiblas_blasfn dtrsm;
        struct flexiblas_blasfn dtrsv;
        struct flexiblas_blasfn dzasum;
        struct flexiblas_blasfn dznrm2;
        struct flexiblas_blasfn icamax;
        struct flexiblas_blasfn idamax;
        struct flexiblas_blasfn isamax;
        struct flexiblas_blasfn izamax;
        struct flexiblas_blasfn sasum;
        struct flexiblas_blasfn saxpy;
        struct flexiblas_blasfn scasum;
        struct flexiblas_blasfn scnrm2;
        struct flexiblas_blasfn scopy;
        struct flexiblas_blasfn sdot;
        struct flexiblas_blasfn sdsdot;
        struct flexiblas_blasfn sgbmv;
        struct flexiblas_blasfn sgemm;
        struct flexiblas_blasfn sgemmt;
        struct flexiblas_blasfn sgemmtr;
        struct flexiblas_blasfn sgemv;
        struct flexiblas_blasfn sger;
        struct flexiblas_blasfn snrm2;
        struct flexiblas_blasfn srot;
        struct flexiblas_blasfn srotg;
        struct flexiblas_blasfn srotm;
        struct flexiblas_blasfn srotmg;
        struct flexiblas_blasfn ssbmv;
        struct flexiblas_blasfn sscal;
        struct flexiblas_blasfn sspmv;
        struct flexiblas_blasfn sspr;
        struct flexiblas_blasfn sspr2;
        struct flexiblas_blasfn sswap;
        struct flexiblas_blasfn ssymm;
        struct flexiblas_blasfn ssymv;
        struct flexiblas_blasfn ssyr;
        struct flexiblas_blasfn ssyr2;
        struct flexiblas_blasfn ssyr2k;
        struct flexiblas_blasfn ssyrk;
        struct flexiblas_blasfn stbmv;
        struct flexiblas_blasfn stbsv;
        struct flexiblas_blasfn stpmv;
        struct flexiblas_blasfn stpsv;
        struct flexiblas_blasfn strmm;
        struct flexiblas_blasfn strmv;
        struct flexiblas_blasfn strsm;
        struct flexiblas_blasfn strsv;
        struct flexiblas_blasfn zaxpy;
        struct flexiblas_blasfn zcopy;
        struct flexiblas_blasfn zdotc;
        struct flexiblas_blasfn zdotu;
        struct flexiblas_blasfn zdrot;
        struct flexiblas_blasfn zdscal;
        struct flexiblas_blasfn zgbmv;
        struct flexiblas_blasfn zgemm;
        struct flexiblas_blasfn zgemmt;
        struct flexiblas_blasfn zgemmtr;
        struct flexiblas_blasfn zgemv;
        struct flexiblas_blasfn zgerc;
        struct flexiblas_blasfn zgeru;
        struct flexiblas_blasfn zhbmv;
        struct flexiblas_blasfn zhemm;
        struct flexiblas_blasfn zhemv;
        struct flexiblas_blasfn zher;
        struct flexiblas_blasfn zher2;
        struct flexiblas_blasfn zher2k;
        struct flexiblas_blasfn zherk;
        struct flexiblas_blasfn zhpmv;
        struct flexiblas_blasfn zhpr;
        struct flexiblas_blasfn zhpr2;
        struct flexiblas_blasfn zrotg;
        struct flexiblas_blasfn zscal;
        struct flexiblas_blasfn zswap;
        struct flexiblas_blasfn zsymm;
        struct flexiblas_blasfn zsyr2k;
        struct flexiblas_blasfn zsyrk;
        struct flexiblas_blasfn ztbmv;
        struct flexiblas_blasfn ztbsv;
        struct flexiblas_blasfn ztpmv;
        struct flexiblas_blasfn ztpsv;
        struct flexiblas_blasfn ztrmm;
        struct flexiblas_blasfn ztrmv;
        struct flexiblas_blasfn ztrsm;
        struct flexiblas_blasfn ztrsv;
        struct flexiblas_blasfn dcabs1;
        struct flexiblas_blasfn scabs1;
        struct flexiblas_blasfn cdotc_sub;
        struct flexiblas_blasfn cdotu_sub;
        struct flexiblas_blasfn zdotc_sub;
        struct flexiblas_blasfn zdotu_sub;
        struct flexiblas_blasfn caxpby;
        struct flexiblas_blasfn daxpby;
        struct flexiblas_blasfn zaxpby;
        struct flexiblas_blasfn saxpby;
        struct flexiblas_blasfn comatcopy;
        struct flexiblas_blasfn zomatcopy;
        struct flexiblas_blasfn domatcopy;
        struct flexiblas_blasfn somatcopy;
        struct flexiblas_blasfn cimatcopy;
        struct flexiblas_blasfn zimatcopy;
        struct flexiblas_blasfn dimatcopy;
        struct flexiblas_blasfn simatcopy;
        struct flexiblas_blasfn cgeadd;
        struct flexiblas_blasfn dgeadd;
        struct flexiblas_blasfn sgeadd;
        struct flexiblas_blasfn zgeadd;
    } flexiblas_blas_backend_t;


    typedef struct _flexiblas_hook_backend {
        void *handles[FLEXIBLAS_MAX_HOOKS];
        int  hooks_loaded;
        int  initialized;
        flexiblas_init_function_t hook_init[FLEXIBLAS_MAX_HOOKS];
        flexiblas_exit_function_t hook_exit[FLEXIBLAS_MAX_HOOKS];

        struct flexiblas_hook_fn caxpy;
        struct flexiblas_hook_fn ccopy;
        struct flexiblas_hook_fn cdotc;
        struct flexiblas_hook_fn cdotu;
        struct flexiblas_hook_fn cgbmv;
        struct flexiblas_hook_fn cgemm;
        struct flexiblas_hook_fn cgemmt;
        struct flexiblas_hook_fn cgemmtr;
        struct flexiblas_hook_fn cgemv;
        struct flexiblas_hook_fn cgerc;
        struct flexiblas_hook_fn cgeru;
        struct flexiblas_hook_fn chbmv;
        struct flexiblas_hook_fn chemm;
        struct flexiblas_hook_fn chemv;
        struct flexiblas_hook_fn cher;
        struct flexiblas_hook_fn cher2;
        struct flexiblas_hook_fn cher2k;
        struct flexiblas_hook_fn cherk;
        struct flexiblas_hook_fn chpmv;
        struct flexiblas_hook_fn chpr;
        struct flexiblas_hook_fn chpr2;
        struct flexiblas_hook_fn crotg;
        struct flexiblas_hook_fn cscal;
        struct flexiblas_hook_fn csrot;
        struct flexiblas_hook_fn csscal;
        struct flexiblas_hook_fn cswap;
        struct flexiblas_hook_fn csymm;
        struct flexiblas_hook_fn csyr2k;
        struct flexiblas_hook_fn csyrk;
        struct flexiblas_hook_fn ctbmv;
        struct flexiblas_hook_fn ctbsv;
        struct flexiblas_hook_fn ctpmv;
        struct flexiblas_hook_fn ctpsv;
        struct flexiblas_hook_fn ctrmm;
        struct flexiblas_hook_fn ctrmv;
        struct flexiblas_hook_fn ctrsm;
        struct flexiblas_hook_fn ctrsv;
        struct flexiblas_hook_fn dasum;
        struct flexiblas_hook_fn daxpy;
        struct flexiblas_hook_fn dcopy;
        struct flexiblas_hook_fn ddot;
        struct flexiblas_hook_fn dgbmv;
        struct flexiblas_hook_fn dgemm;
        struct flexiblas_hook_fn dgemmt;
        struct flexiblas_hook_fn dgemmtr;
        struct flexiblas_hook_fn dgemv;
        struct flexiblas_hook_fn dger;
        struct flexiblas_hook_fn dnrm2;
        struct flexiblas_hook_fn drot;
        struct flexiblas_hook_fn drotg;
        struct flexiblas_hook_fn drotm;
        struct flexiblas_hook_fn drotmg;
        struct flexiblas_hook_fn dsbmv;
        struct flexiblas_hook_fn dscal;
        struct flexiblas_hook_fn dsdot;
        struct flexiblas_hook_fn dspmv;
        struct flexiblas_hook_fn dspr;
        struct flexiblas_hook_fn dspr2;
        struct flexiblas_hook_fn dswap;
        struct flexiblas_hook_fn dsymm;
        struct flexiblas_hook_fn dsymv;
        struct flexiblas_hook_fn dsyr;
        struct flexiblas_hook_fn dsyr2;
        struct flexiblas_hook_fn dsyr2k;
        struct flexiblas_hook_fn dsyrk;
        struct flexiblas_hook_fn dtbmv;
        struct flexiblas_hook_fn dtbsv;
        struct flexiblas_hook_fn dtpmv;
        struct flexiblas_hook_fn dtpsv;
        struct flexiblas_hook_fn dtrmm;
        struct flexiblas_hook_fn dtrmv;
        struct flexiblas_hook_fn dtrsm;
        struct flexiblas_hook_fn dtrsv;
        struct flexiblas_hook_fn dzasum;
        struct flexiblas_hook_fn dznrm2;
        struct flexiblas_hook_fn icamax;
        struct flexiblas_hook_fn idamax;
        struct flexiblas_hook_fn isamax;
        struct flexiblas_hook_fn izamax;
        struct flexiblas_hook_fn sasum;
        struct flexiblas_hook_fn saxpy;
        struct flexiblas_hook_fn scasum;
        struct flexiblas_hook_fn scnrm2;
        struct flexiblas_hook_fn scopy;
        struct flexiblas_hook_fn sdot;
        struct flexiblas_hook_fn sdsdot;
        struct flexiblas_hook_fn sgbmv;
        struct flexiblas_hook_fn sgemm;
        struct flexiblas_hook_fn sgemmt;
        struct flexiblas_hook_fn sgemmtr;
        struct flexiblas_hook_fn sgemv;
        struct flexiblas_hook_fn sger;
        struct flexiblas_hook_fn snrm2;
        struct flexiblas_hook_fn srot;
        struct flexiblas_hook_fn srotg;
        struct flexiblas_hook_fn srotm;
        struct flexiblas_hook_fn srotmg;
        struct flexiblas_hook_fn ssbmv;
        struct flexiblas_hook_fn sscal;
        struct flexiblas_hook_fn sspmv;
        struct flexiblas_hook_fn sspr;
        struct flexiblas_hook_fn sspr2;
        struct flexiblas_hook_fn sswap;
        struct flexiblas_hook_fn ssymm;
        struct flexiblas_hook_fn ssymv;
        struct flexiblas_hook_fn ssyr;
        struct flexiblas_hook_fn ssyr2;
        struct flexiblas_hook_fn ssyr2k;
        struct flexiblas_hook_fn ssyrk;
        struct flexiblas_hook_fn stbmv;
        struct flexiblas_hook_fn stbsv;
        struct flexiblas_hook_fn stpmv;
        struct flexiblas_hook_fn stpsv;
        struct flexiblas_hook_fn strmm;
        struct flexiblas_hook_fn strmv;
        struct flexiblas_hook_fn strsm;
        struct flexiblas_hook_fn strsv;
        struct flexiblas_hook_fn zaxpy;
        struct flexiblas_hook_fn zcopy;
        struct flexiblas_hook_fn zdotc;
        struct flexiblas_hook_fn zdotu;
        struct flexiblas_hook_fn zdrot;
        struct flexiblas_hook_fn zdscal;
        struct flexiblas_hook_fn zgbmv;
        struct flexiblas_hook_fn zgemm;
        struct flexiblas_hook_fn zgemmt;
        struct flexiblas_hook_fn zgemmtr;
        struct flexiblas_hook_fn zgemv;
        struct flexiblas_hook_fn zgerc;
        struct flexiblas_hook_fn zgeru;
        struct flexiblas_hook_fn zhbmv;
        struct flexiblas_hook_fn zhemm;
        struct flexiblas_hook_fn zhemv;
        struct flexiblas_hook_fn zher;
        struct flexiblas_hook_fn zher2;
        struct flexiblas_hook_fn zher2k;
        struct flexiblas_hook_fn zherk;
        struct flexiblas_hook_fn zhpmv;
        struct flexiblas_hook_fn zhpr;
        struct flexiblas_hook_fn zhpr2;
        struct flexiblas_hook_fn zrotg;
        struct flexiblas_hook_fn zscal;
        struct flexiblas_hook_fn zswap;
        struct flexiblas_hook_fn zsymm;
        struct flexiblas_hook_fn zsyr2k;
        struct flexiblas_hook_fn zsyrk;
        struct flexiblas_hook_fn ztbmv;
        struct flexiblas_hook_fn ztbsv;
        struct flexiblas_hook_fn ztpmv;
        struct flexiblas_hook_fn ztpsv;
        struct flexiblas_hook_fn ztrmm;
        struct flexiblas_hook_fn ztrmv;
        struct flexiblas_hook_fn ztrsm;
        struct flexiblas_hook_fn ztrsv;
        struct flexiblas_hook_fn dcabs1;
        struct flexiblas_hook_fn scabs1;
        struct flexiblas_hook_fn cdotc_sub;
        struct flexiblas_hook_fn cdotu_sub;
        struct flexiblas_hook_fn zdotc_sub;
        struct flexiblas_hook_fn zdotu_sub;
        struct flexiblas_hook_fn caxpby;
        struct flexiblas_hook_fn daxpby;
        struct flexiblas_hook_fn zaxpby;
        struct flexiblas_hook_fn saxpby;
        struct flexiblas_hook_fn comatcopy;
        struct flexiblas_hook_fn zomatcopy;
        struct flexiblas_hook_fn domatcopy;
        struct flexiblas_hook_fn somatcopy;
        struct flexiblas_hook_fn cimatcopy;
        struct flexiblas_hook_fn zimatcopy;
        struct flexiblas_hook_fn dimatcopy;
        struct flexiblas_hook_fn simatcopy;
        struct flexiblas_hook_fn cgeadd;
        struct flexiblas_hook_fn dgeadd;
        struct flexiblas_hook_fn sgeadd;
        struct flexiblas_hook_fn zgeadd;

        struct flexiblas_hook_fn slamch;
        struct flexiblas_hook_fn dlamch;
        struct flexiblas_hook_fn dlamc3;
        struct flexiblas_hook_fn slamc3;
        struct flexiblas_hook_fn dsecnd;
        struct flexiblas_hook_fn second;
        struct flexiblas_hook_fn xerbla;

        /*  LAPACK  */

        struct flexiblas_hook_fn cbbcsd;
        struct flexiblas_hook_fn cbdsqr;
        struct flexiblas_hook_fn cgbbrd;
        struct flexiblas_hook_fn cgbcon;
        struct flexiblas_hook_fn cgbequ;
        struct flexiblas_hook_fn cgbequb;
        struct flexiblas_hook_fn cgbrfs;
        struct flexiblas_hook_fn cgbsv;
        struct flexiblas_hook_fn cgbsvx;
        struct flexiblas_hook_fn cgbtf2;
        struct flexiblas_hook_fn cgbtrf;
        struct flexiblas_hook_fn cgbtrs;
        struct flexiblas_hook_fn cgebak;
        struct flexiblas_hook_fn cgebal;
        struct flexiblas_hook_fn cgebd2;
        struct flexiblas_hook_fn cgebrd;
        struct flexiblas_hook_fn cgecon;
        struct flexiblas_hook_fn cgeequ;
        struct flexiblas_hook_fn cgeequb;
        struct flexiblas_hook_fn cgees;
        struct flexiblas_hook_fn cgeesx;
        struct flexiblas_hook_fn cgeev;
        struct flexiblas_hook_fn cgeevx;
        struct flexiblas_hook_fn cgegs;
        struct flexiblas_hook_fn cgegv;
        struct flexiblas_hook_fn cgehd2;
        struct flexiblas_hook_fn cgehrd;
        struct flexiblas_hook_fn cgejsv;
        struct flexiblas_hook_fn cgelq;
        struct flexiblas_hook_fn cgelq2;
        struct flexiblas_hook_fn cgelqf;
        struct flexiblas_hook_fn cgelqt;
        struct flexiblas_hook_fn cgelqt3;
        struct flexiblas_hook_fn cgels;
        struct flexiblas_hook_fn cgelsd;
        struct flexiblas_hook_fn cgelss;
        struct flexiblas_hook_fn cgelsx;
        struct flexiblas_hook_fn cgelsy;
        struct flexiblas_hook_fn cgemlq;
        struct flexiblas_hook_fn cgemlqt;
        struct flexiblas_hook_fn cgemqr;
        struct flexiblas_hook_fn cgemqrt;
        struct flexiblas_hook_fn cgeql2;
        struct flexiblas_hook_fn cgeqlf;
        struct flexiblas_hook_fn cgeqp3;
        struct flexiblas_hook_fn cgeqpf;
        struct flexiblas_hook_fn cgeqr;
        struct flexiblas_hook_fn cgeqr2;
        struct flexiblas_hook_fn cgeqr2p;
        struct flexiblas_hook_fn cgeqrf;
        struct flexiblas_hook_fn cgeqrfp;
        struct flexiblas_hook_fn cgeqrt;
        struct flexiblas_hook_fn cgeqrt2;
        struct flexiblas_hook_fn cgeqrt3;
        struct flexiblas_hook_fn cgerfs;
        struct flexiblas_hook_fn cgerq2;
        struct flexiblas_hook_fn cgerqf;
        struct flexiblas_hook_fn cgesc2;
        struct flexiblas_hook_fn cgesdd;
        struct flexiblas_hook_fn cgesv;
        struct flexiblas_hook_fn cgesvd;
        struct flexiblas_hook_fn cgesvdq;
        struct flexiblas_hook_fn cgesvdx;
        struct flexiblas_hook_fn cgesvj;
        struct flexiblas_hook_fn cgesvx;
        struct flexiblas_hook_fn cgetc2;
        struct flexiblas_hook_fn cgetf2;
        struct flexiblas_hook_fn cgetrf;
        struct flexiblas_hook_fn cgetrf2;
        struct flexiblas_hook_fn cgetri;
        struct flexiblas_hook_fn cgetrs;
        struct flexiblas_hook_fn cgetsls;
        struct flexiblas_hook_fn cggbak;
        struct flexiblas_hook_fn cggbal;
        struct flexiblas_hook_fn cgges;
        struct flexiblas_hook_fn cgges3;
        struct flexiblas_hook_fn cggesx;
        struct flexiblas_hook_fn cggev;
        struct flexiblas_hook_fn cggev3;
        struct flexiblas_hook_fn cggevx;
        struct flexiblas_hook_fn cggglm;
        struct flexiblas_hook_fn cgghd3;
        struct flexiblas_hook_fn cgghrd;
        struct flexiblas_hook_fn cgglse;
        struct flexiblas_hook_fn cggqrf;
        struct flexiblas_hook_fn cggrqf;
        struct flexiblas_hook_fn cggsvd;
        struct flexiblas_hook_fn cggsvd3;
        struct flexiblas_hook_fn cggsvp;
        struct flexiblas_hook_fn cggsvp3;
        struct flexiblas_hook_fn cgsvj0;
        struct flexiblas_hook_fn cgsvj1;
        struct flexiblas_hook_fn cgtcon;
        struct flexiblas_hook_fn cgtrfs;
        struct flexiblas_hook_fn cgtsv;
        struct flexiblas_hook_fn cgtsvx;
        struct flexiblas_hook_fn cgttrf;
        struct flexiblas_hook_fn cgttrs;
        struct flexiblas_hook_fn cgtts2;
        struct flexiblas_hook_fn chb2st_kernels;
        struct flexiblas_hook_fn chbev;
        struct flexiblas_hook_fn chbev_2stage;
        struct flexiblas_hook_fn chbevd;
        struct flexiblas_hook_fn chbevd_2stage;
        struct flexiblas_hook_fn chbevx;
        struct flexiblas_hook_fn chbevx_2stage;
        struct flexiblas_hook_fn chbgst;
        struct flexiblas_hook_fn chbgv;
        struct flexiblas_hook_fn chbgvd;
        struct flexiblas_hook_fn chbgvx;
        struct flexiblas_hook_fn chbtrd;
        struct flexiblas_hook_fn checon;
        struct flexiblas_hook_fn checon_3;
        struct flexiblas_hook_fn checon_rook;
        struct flexiblas_hook_fn cheequb;
        struct flexiblas_hook_fn cheev;
        struct flexiblas_hook_fn cheev_2stage;
        struct flexiblas_hook_fn cheevd;
        struct flexiblas_hook_fn cheevd_2stage;
        struct flexiblas_hook_fn cheevr;
        struct flexiblas_hook_fn cheevr_2stage;
        struct flexiblas_hook_fn cheevx;
        struct flexiblas_hook_fn cheevx_2stage;
        struct flexiblas_hook_fn chegs2;
        struct flexiblas_hook_fn chegst;
        struct flexiblas_hook_fn chegv;
        struct flexiblas_hook_fn chegv_2stage;
        struct flexiblas_hook_fn chegvd;
        struct flexiblas_hook_fn chegvx;
        struct flexiblas_hook_fn cherfs;
        struct flexiblas_hook_fn chesv;
        struct flexiblas_hook_fn chesv_aa;
        struct flexiblas_hook_fn chesv_aa_2stage;
        struct flexiblas_hook_fn chesv_rk;
        struct flexiblas_hook_fn chesv_rook;
        struct flexiblas_hook_fn chesvx;
        struct flexiblas_hook_fn cheswapr;
        struct flexiblas_hook_fn chetd2;
        struct flexiblas_hook_fn chetf2;
        struct flexiblas_hook_fn chetf2_rk;
        struct flexiblas_hook_fn chetf2_rook;
        struct flexiblas_hook_fn chetrd;
        struct flexiblas_hook_fn chetrd_2stage;
        struct flexiblas_hook_fn chetrd_hb2st;
        struct flexiblas_hook_fn chetrd_he2hb;
        struct flexiblas_hook_fn chetrf;
        struct flexiblas_hook_fn chetrf_aa;
        struct flexiblas_hook_fn chetrf_aa_2stage;
        struct flexiblas_hook_fn chetrf_rk;
        struct flexiblas_hook_fn chetrf_rook;
        struct flexiblas_hook_fn chetri;
        struct flexiblas_hook_fn chetri2;
        struct flexiblas_hook_fn chetri2x;
        struct flexiblas_hook_fn chetri_3;
        struct flexiblas_hook_fn chetri_3x;
        struct flexiblas_hook_fn chetri_rook;
        struct flexiblas_hook_fn chetrs;
        struct flexiblas_hook_fn chetrs2;
        struct flexiblas_hook_fn chetrs_3;
        struct flexiblas_hook_fn chetrs_aa;
        struct flexiblas_hook_fn chetrs_aa_2stage;
        struct flexiblas_hook_fn chetrs_rook;
        struct flexiblas_hook_fn chfrk;
        struct flexiblas_hook_fn chgeqz;
        struct flexiblas_hook_fn chla_transtype;
        struct flexiblas_hook_fn chpcon;
        struct flexiblas_hook_fn chpev;
        struct flexiblas_hook_fn chpevd;
        struct flexiblas_hook_fn chpevx;
        struct flexiblas_hook_fn chpgst;
        struct flexiblas_hook_fn chpgv;
        struct flexiblas_hook_fn chpgvd;
        struct flexiblas_hook_fn chpgvx;
        struct flexiblas_hook_fn chprfs;
        struct flexiblas_hook_fn chpsv;
        struct flexiblas_hook_fn chpsvx;
        struct flexiblas_hook_fn chptrd;
        struct flexiblas_hook_fn chptrf;
        struct flexiblas_hook_fn chptri;
        struct flexiblas_hook_fn chptrs;
        struct flexiblas_hook_fn chsein;
        struct flexiblas_hook_fn chseqr;
        struct flexiblas_hook_fn clabrd;
        struct flexiblas_hook_fn clacgv;
        struct flexiblas_hook_fn clacn2;
        struct flexiblas_hook_fn clacon;
        struct flexiblas_hook_fn clacp2;
        struct flexiblas_hook_fn clacpy;
        struct flexiblas_hook_fn clacrm;
        struct flexiblas_hook_fn clacrt;
        struct flexiblas_hook_fn cladiv;
        struct flexiblas_hook_fn claed0;
        struct flexiblas_hook_fn claed7;
        struct flexiblas_hook_fn claed8;
        struct flexiblas_hook_fn claein;
        struct flexiblas_hook_fn claesy;
        struct flexiblas_hook_fn claev2;
        struct flexiblas_hook_fn clag2z;
        struct flexiblas_hook_fn clags2;
        struct flexiblas_hook_fn clagtm;
        struct flexiblas_hook_fn clahef;
        struct flexiblas_hook_fn clahef_aa;
        struct flexiblas_hook_fn clahef_rk;
        struct flexiblas_hook_fn clahef_rook;
        struct flexiblas_hook_fn clahqr;
        struct flexiblas_hook_fn clahr2;
        struct flexiblas_hook_fn clahrd;
        struct flexiblas_hook_fn claic1;
        struct flexiblas_hook_fn clals0;
        struct flexiblas_hook_fn clalsa;
        struct flexiblas_hook_fn clalsd;
        struct flexiblas_hook_fn clamswlq;
        struct flexiblas_hook_fn clamtsqr;
        struct flexiblas_hook_fn clangb;
        struct flexiblas_hook_fn clange;
        struct flexiblas_hook_fn clangt;
        struct flexiblas_hook_fn clanhb;
        struct flexiblas_hook_fn clanhe;
        struct flexiblas_hook_fn clanhf;
        struct flexiblas_hook_fn clanhp;
        struct flexiblas_hook_fn clanhs;
        struct flexiblas_hook_fn clanht;
        struct flexiblas_hook_fn clansb;
        struct flexiblas_hook_fn clansp;
        struct flexiblas_hook_fn clansy;
        struct flexiblas_hook_fn clantb;
        struct flexiblas_hook_fn clantp;
        struct flexiblas_hook_fn clantr;
        struct flexiblas_hook_fn clapll;
        struct flexiblas_hook_fn clapmr;
        struct flexiblas_hook_fn clapmt;
        struct flexiblas_hook_fn claqgb;
        struct flexiblas_hook_fn claqge;
        struct flexiblas_hook_fn claqhb;
        struct flexiblas_hook_fn claqhe;
        struct flexiblas_hook_fn claqhp;
        struct flexiblas_hook_fn claqp2;
        struct flexiblas_hook_fn claqps;
        struct flexiblas_hook_fn claqr0;
        struct flexiblas_hook_fn claqr1;
        struct flexiblas_hook_fn claqr2;
        struct flexiblas_hook_fn claqr3;
        struct flexiblas_hook_fn claqr4;
        struct flexiblas_hook_fn claqr5;
        struct flexiblas_hook_fn claqsb;
        struct flexiblas_hook_fn claqsp;
        struct flexiblas_hook_fn claqsy;
        struct flexiblas_hook_fn clar1v;
        struct flexiblas_hook_fn clar2v;
        struct flexiblas_hook_fn clarcm;
        struct flexiblas_hook_fn clarf;
        struct flexiblas_hook_fn clarfb;
        struct flexiblas_hook_fn clarfg;
        struct flexiblas_hook_fn clarfgp;
        struct flexiblas_hook_fn clarft;
        struct flexiblas_hook_fn clarfx;
        struct flexiblas_hook_fn clarfy;
        struct flexiblas_hook_fn clargv;
        struct flexiblas_hook_fn clarnv;
        struct flexiblas_hook_fn clarrv;
        struct flexiblas_hook_fn clartg;
        struct flexiblas_hook_fn clartv;
        struct flexiblas_hook_fn clarz;
        struct flexiblas_hook_fn clarzb;
        struct flexiblas_hook_fn clarzt;
        struct flexiblas_hook_fn clascl;
        struct flexiblas_hook_fn claset;
        struct flexiblas_hook_fn clasr;
        struct flexiblas_hook_fn classq;
        struct flexiblas_hook_fn claswlq;
        struct flexiblas_hook_fn claswp;
        struct flexiblas_hook_fn clasyf;
        struct flexiblas_hook_fn clasyf_aa;
        struct flexiblas_hook_fn clasyf_rk;
        struct flexiblas_hook_fn clasyf_rook;
        struct flexiblas_hook_fn clatbs;
        struct flexiblas_hook_fn clatdf;
        struct flexiblas_hook_fn clatps;
        struct flexiblas_hook_fn clatrd;
        struct flexiblas_hook_fn clatrs;
        struct flexiblas_hook_fn clatrz;
        struct flexiblas_hook_fn clatsqr;
        struct flexiblas_hook_fn clatzm;
        struct flexiblas_hook_fn claunhr_col_getrfnp;
        struct flexiblas_hook_fn claunhr_col_getrfnp2;
        struct flexiblas_hook_fn clauu2;
        struct flexiblas_hook_fn clauum;
        struct flexiblas_hook_fn cpbcon;
        struct flexiblas_hook_fn cpbequ;
        struct flexiblas_hook_fn cpbrfs;
        struct flexiblas_hook_fn cpbstf;
        struct flexiblas_hook_fn cpbsv;
        struct flexiblas_hook_fn cpbsvx;
        struct flexiblas_hook_fn cpbtf2;
        struct flexiblas_hook_fn cpbtrf;
        struct flexiblas_hook_fn cpbtrs;
        struct flexiblas_hook_fn cpftrf;
        struct flexiblas_hook_fn cpftri;
        struct flexiblas_hook_fn cpftrs;
        struct flexiblas_hook_fn cpocon;
        struct flexiblas_hook_fn cpoequ;
        struct flexiblas_hook_fn cpoequb;
        struct flexiblas_hook_fn cporfs;
        struct flexiblas_hook_fn cposv;
        struct flexiblas_hook_fn cposvx;
        struct flexiblas_hook_fn cpotf2;
        struct flexiblas_hook_fn cpotrf;
        struct flexiblas_hook_fn cpotrf2;
        struct flexiblas_hook_fn cpotri;
        struct flexiblas_hook_fn cpotrs;
        struct flexiblas_hook_fn cppcon;
        struct flexiblas_hook_fn cppequ;
        struct flexiblas_hook_fn cpprfs;
        struct flexiblas_hook_fn cppsv;
        struct flexiblas_hook_fn cppsvx;
        struct flexiblas_hook_fn cpptrf;
        struct flexiblas_hook_fn cpptri;
        struct flexiblas_hook_fn cpptrs;
        struct flexiblas_hook_fn cpstf2;
        struct flexiblas_hook_fn cpstrf;
        struct flexiblas_hook_fn cptcon;
        struct flexiblas_hook_fn cpteqr;
        struct flexiblas_hook_fn cptrfs;
        struct flexiblas_hook_fn cptsv;
        struct flexiblas_hook_fn cptsvx;
        struct flexiblas_hook_fn cpttrf;
        struct flexiblas_hook_fn cpttrs;
        struct flexiblas_hook_fn cptts2;
        struct flexiblas_hook_fn crot;
        struct flexiblas_hook_fn cspcon;
        struct flexiblas_hook_fn cspmv;
        struct flexiblas_hook_fn cspr;
        struct flexiblas_hook_fn csprfs;
        struct flexiblas_hook_fn cspsv;
        struct flexiblas_hook_fn cspsvx;
        struct flexiblas_hook_fn csptrf;
        struct flexiblas_hook_fn csptri;
        struct flexiblas_hook_fn csptrs;
        struct flexiblas_hook_fn csrscl;
        struct flexiblas_hook_fn cstedc;
        struct flexiblas_hook_fn cstegr;
        struct flexiblas_hook_fn cstein;
        struct flexiblas_hook_fn cstemr;
        struct flexiblas_hook_fn csteqr;
        struct flexiblas_hook_fn csycon;
        struct flexiblas_hook_fn csycon_3;
        struct flexiblas_hook_fn csycon_rook;
        struct flexiblas_hook_fn csyconv;
        struct flexiblas_hook_fn csyconvf;
        struct flexiblas_hook_fn csyconvf_rook;
        struct flexiblas_hook_fn csyequb;
        struct flexiblas_hook_fn csymv;
        struct flexiblas_hook_fn csyr;
        struct flexiblas_hook_fn csyrfs;
        struct flexiblas_hook_fn csysv;
        struct flexiblas_hook_fn csysv_aa;
        struct flexiblas_hook_fn csysv_aa_2stage;
        struct flexiblas_hook_fn csysv_rk;
        struct flexiblas_hook_fn csysv_rook;
        struct flexiblas_hook_fn csysvx;
        struct flexiblas_hook_fn csyswapr;
        struct flexiblas_hook_fn csytf2;
        struct flexiblas_hook_fn csytf2_rk;
        struct flexiblas_hook_fn csytf2_rook;
        struct flexiblas_hook_fn csytrf;
        struct flexiblas_hook_fn csytrf_aa;
        struct flexiblas_hook_fn csytrf_aa_2stage;
        struct flexiblas_hook_fn csytrf_rk;
        struct flexiblas_hook_fn csytrf_rook;
        struct flexiblas_hook_fn csytri;
        struct flexiblas_hook_fn csytri2;
        struct flexiblas_hook_fn csytri2x;
        struct flexiblas_hook_fn csytri_3;
        struct flexiblas_hook_fn csytri_3x;
        struct flexiblas_hook_fn csytri_rook;
        struct flexiblas_hook_fn csytrs;
        struct flexiblas_hook_fn csytrs2;
        struct flexiblas_hook_fn csytrs_3;
        struct flexiblas_hook_fn csytrs_aa;
        struct flexiblas_hook_fn csytrs_aa_2stage;
        struct flexiblas_hook_fn csytrs_rook;
        struct flexiblas_hook_fn ctbcon;
        struct flexiblas_hook_fn ctbrfs;
        struct flexiblas_hook_fn ctbtrs;
        struct flexiblas_hook_fn ctfsm;
        struct flexiblas_hook_fn ctftri;
        struct flexiblas_hook_fn ctfttp;
        struct flexiblas_hook_fn ctfttr;
        struct flexiblas_hook_fn ctgevc;
        struct flexiblas_hook_fn ctgex2;
        struct flexiblas_hook_fn ctgexc;
        struct flexiblas_hook_fn ctgsen;
        struct flexiblas_hook_fn ctgsja;
        struct flexiblas_hook_fn ctgsna;
        struct flexiblas_hook_fn ctgsy2;
        struct flexiblas_hook_fn ctgsyl;
        struct flexiblas_hook_fn ctpcon;
        struct flexiblas_hook_fn ctplqt;
        struct flexiblas_hook_fn ctplqt2;
        struct flexiblas_hook_fn ctpmlqt;
        struct flexiblas_hook_fn ctpmqrt;
        struct flexiblas_hook_fn ctpqrt;
        struct flexiblas_hook_fn ctpqrt2;
        struct flexiblas_hook_fn ctprfb;
        struct flexiblas_hook_fn ctprfs;
        struct flexiblas_hook_fn ctptri;
        struct flexiblas_hook_fn ctptrs;
        struct flexiblas_hook_fn ctpttf;
        struct flexiblas_hook_fn ctpttr;
        struct flexiblas_hook_fn ctrcon;
        struct flexiblas_hook_fn ctrevc;
        struct flexiblas_hook_fn ctrevc3;
        struct flexiblas_hook_fn ctrexc;
        struct flexiblas_hook_fn ctrrfs;
        struct flexiblas_hook_fn ctrsen;
        struct flexiblas_hook_fn ctrsna;
        struct flexiblas_hook_fn ctrsyl;
        struct flexiblas_hook_fn ctrti2;
        struct flexiblas_hook_fn ctrtri;
        struct flexiblas_hook_fn ctrtrs;
        struct flexiblas_hook_fn ctrttf;
        struct flexiblas_hook_fn ctrttp;
        struct flexiblas_hook_fn ctzrqf;
        struct flexiblas_hook_fn ctzrzf;
        struct flexiblas_hook_fn cunbdb;
        struct flexiblas_hook_fn cunbdb1;
        struct flexiblas_hook_fn cunbdb2;
        struct flexiblas_hook_fn cunbdb3;
        struct flexiblas_hook_fn cunbdb4;
        struct flexiblas_hook_fn cunbdb5;
        struct flexiblas_hook_fn cunbdb6;
        struct flexiblas_hook_fn cuncsd;
        struct flexiblas_hook_fn cuncsd2by1;
        struct flexiblas_hook_fn cung2l;
        struct flexiblas_hook_fn cung2r;
        struct flexiblas_hook_fn cungbr;
        struct flexiblas_hook_fn cunghr;
        struct flexiblas_hook_fn cungl2;
        struct flexiblas_hook_fn cunglq;
        struct flexiblas_hook_fn cungql;
        struct flexiblas_hook_fn cungqr;
        struct flexiblas_hook_fn cungr2;
        struct flexiblas_hook_fn cungrq;
        struct flexiblas_hook_fn cungtr;
        struct flexiblas_hook_fn cungtsqr;
        struct flexiblas_hook_fn cunhr_col;
        struct flexiblas_hook_fn cunm22;
        struct flexiblas_hook_fn cunm2l;
        struct flexiblas_hook_fn cunm2r;
        struct flexiblas_hook_fn cunmbr;
        struct flexiblas_hook_fn cunmhr;
        struct flexiblas_hook_fn cunml2;
        struct flexiblas_hook_fn cunmlq;
        struct flexiblas_hook_fn cunmql;
        struct flexiblas_hook_fn cunmqr;
        struct flexiblas_hook_fn cunmr2;
        struct flexiblas_hook_fn cunmr3;
        struct flexiblas_hook_fn cunmrq;
        struct flexiblas_hook_fn cunmrz;
        struct flexiblas_hook_fn cunmtr;
        struct flexiblas_hook_fn cupgtr;
        struct flexiblas_hook_fn cupmtr;
        struct flexiblas_hook_fn dbbcsd;
        struct flexiblas_hook_fn dbdsdc;
        struct flexiblas_hook_fn dbdsqr;
        struct flexiblas_hook_fn dbdsvdx;
        struct flexiblas_hook_fn dcombssq;
        struct flexiblas_hook_fn ddisna;
        struct flexiblas_hook_fn dgbbrd;
        struct flexiblas_hook_fn dgbcon;
        struct flexiblas_hook_fn dgbequ;
        struct flexiblas_hook_fn dgbequb;
        struct flexiblas_hook_fn dgbrfs;
        struct flexiblas_hook_fn dgbsv;
        struct flexiblas_hook_fn dgbsvx;
        struct flexiblas_hook_fn dgbtf2;
        struct flexiblas_hook_fn dgbtrf;
        struct flexiblas_hook_fn dgbtrs;
        struct flexiblas_hook_fn dgebak;
        struct flexiblas_hook_fn dgebal;
        struct flexiblas_hook_fn dgebd2;
        struct flexiblas_hook_fn dgebrd;
        struct flexiblas_hook_fn dgecon;
        struct flexiblas_hook_fn dgeequ;
        struct flexiblas_hook_fn dgeequb;
        struct flexiblas_hook_fn dgees;
        struct flexiblas_hook_fn dgeesx;
        struct flexiblas_hook_fn dgeev;
        struct flexiblas_hook_fn dgeevx;
        struct flexiblas_hook_fn dgegs;
        struct flexiblas_hook_fn dgegv;
        struct flexiblas_hook_fn dgehd2;
        struct flexiblas_hook_fn dgehrd;
        struct flexiblas_hook_fn dgejsv;
        struct flexiblas_hook_fn dgelq;
        struct flexiblas_hook_fn dgelq2;
        struct flexiblas_hook_fn dgelqf;
        struct flexiblas_hook_fn dgelqt;
        struct flexiblas_hook_fn dgelqt3;
        struct flexiblas_hook_fn dgels;
        struct flexiblas_hook_fn dgelsd;
        struct flexiblas_hook_fn dgelss;
        struct flexiblas_hook_fn dgelsx;
        struct flexiblas_hook_fn dgelsy;
        struct flexiblas_hook_fn dgemlq;
        struct flexiblas_hook_fn dgemlqt;
        struct flexiblas_hook_fn dgemqr;
        struct flexiblas_hook_fn dgemqrt;
        struct flexiblas_hook_fn dgeql2;
        struct flexiblas_hook_fn dgeqlf;
        struct flexiblas_hook_fn dgeqp3;
        struct flexiblas_hook_fn dgeqpf;
        struct flexiblas_hook_fn dgeqr;
        struct flexiblas_hook_fn dgeqr2;
        struct flexiblas_hook_fn dgeqr2p;
        struct flexiblas_hook_fn dgeqrf;
        struct flexiblas_hook_fn dgeqrfp;
        struct flexiblas_hook_fn dgeqrt;
        struct flexiblas_hook_fn dgeqrt2;
        struct flexiblas_hook_fn dgeqrt3;
        struct flexiblas_hook_fn dgerfs;
        struct flexiblas_hook_fn dgerq2;
        struct flexiblas_hook_fn dgerqf;
        struct flexiblas_hook_fn dgesc2;
        struct flexiblas_hook_fn dgesdd;
        struct flexiblas_hook_fn dgesv;
        struct flexiblas_hook_fn dgesvd;
        struct flexiblas_hook_fn dgesvdq;
        struct flexiblas_hook_fn dgesvdx;
        struct flexiblas_hook_fn dgesvj;
        struct flexiblas_hook_fn dgesvx;
        struct flexiblas_hook_fn dgetc2;
        struct flexiblas_hook_fn dgetf2;
        struct flexiblas_hook_fn dgetrf;
        struct flexiblas_hook_fn dgetrf2;
        struct flexiblas_hook_fn dgetri;
        struct flexiblas_hook_fn dgetrs;
        struct flexiblas_hook_fn dgetsls;
        struct flexiblas_hook_fn dggbak;
        struct flexiblas_hook_fn dggbal;
        struct flexiblas_hook_fn dgges;
        struct flexiblas_hook_fn dgges3;
        struct flexiblas_hook_fn dggesx;
        struct flexiblas_hook_fn dggev;
        struct flexiblas_hook_fn dggev3;
        struct flexiblas_hook_fn dggevx;
        struct flexiblas_hook_fn dggglm;
        struct flexiblas_hook_fn dgghd3;
        struct flexiblas_hook_fn dgghrd;
        struct flexiblas_hook_fn dgglse;
        struct flexiblas_hook_fn dggqrf;
        struct flexiblas_hook_fn dggrqf;
        struct flexiblas_hook_fn dggsvd;
        struct flexiblas_hook_fn dggsvd3;
        struct flexiblas_hook_fn dggsvp;
        struct flexiblas_hook_fn dggsvp3;
        struct flexiblas_hook_fn dgsvj0;
        struct flexiblas_hook_fn dgsvj1;
        struct flexiblas_hook_fn dgtcon;
        struct flexiblas_hook_fn dgtrfs;
        struct flexiblas_hook_fn dgtsv;
        struct flexiblas_hook_fn dgtsvx;
        struct flexiblas_hook_fn dgttrf;
        struct flexiblas_hook_fn dgttrs;
        struct flexiblas_hook_fn dgtts2;
        struct flexiblas_hook_fn dhgeqz;
        struct flexiblas_hook_fn dhsein;
        struct flexiblas_hook_fn dhseqr;
        struct flexiblas_hook_fn disnan;
        struct flexiblas_hook_fn dlabad;
        struct flexiblas_hook_fn dlabrd;
        struct flexiblas_hook_fn dlacn2;
        struct flexiblas_hook_fn dlacon;
        struct flexiblas_hook_fn dlacpy;
        struct flexiblas_hook_fn dladiv;
        struct flexiblas_hook_fn dladiv1;
        struct flexiblas_hook_fn dladiv2;
        struct flexiblas_hook_fn dlae2;
        struct flexiblas_hook_fn dlaebz;
        struct flexiblas_hook_fn dlaed0;
        struct flexiblas_hook_fn dlaed1;
        struct flexiblas_hook_fn dlaed2;
        struct flexiblas_hook_fn dlaed3;
        struct flexiblas_hook_fn dlaed4;
        struct flexiblas_hook_fn dlaed5;
        struct flexiblas_hook_fn dlaed6;
        struct flexiblas_hook_fn dlaed7;
        struct flexiblas_hook_fn dlaed8;
        struct flexiblas_hook_fn dlaed9;
        struct flexiblas_hook_fn dlaeda;
        struct flexiblas_hook_fn dlaein;
        struct flexiblas_hook_fn dlaev2;
        struct flexiblas_hook_fn dlaexc;
        struct flexiblas_hook_fn dlag2;
        struct flexiblas_hook_fn dlag2s;
        struct flexiblas_hook_fn dlags2;
        struct flexiblas_hook_fn dlagtf;
        struct flexiblas_hook_fn dlagtm;
        struct flexiblas_hook_fn dlagts;
        struct flexiblas_hook_fn dlagv2;
        struct flexiblas_hook_fn dlahqr;
        struct flexiblas_hook_fn dlahr2;
        struct flexiblas_hook_fn dlahrd;
        struct flexiblas_hook_fn dlaic1;
        struct flexiblas_hook_fn dlaisnan;
        struct flexiblas_hook_fn dlaln2;
        struct flexiblas_hook_fn dlals0;
        struct flexiblas_hook_fn dlalsa;
        struct flexiblas_hook_fn dlalsd;
        struct flexiblas_hook_fn dlamrg;
        struct flexiblas_hook_fn dlamswlq;
        struct flexiblas_hook_fn dlamtsqr;
        struct flexiblas_hook_fn dlaneg;
        struct flexiblas_hook_fn dlangb;
        struct flexiblas_hook_fn dlange;
        struct flexiblas_hook_fn dlangt;
        struct flexiblas_hook_fn dlanhs;
        struct flexiblas_hook_fn dlansb;
        struct flexiblas_hook_fn dlansf;
        struct flexiblas_hook_fn dlansp;
        struct flexiblas_hook_fn dlanst;
        struct flexiblas_hook_fn dlansy;
        struct flexiblas_hook_fn dlantb;
        struct flexiblas_hook_fn dlantp;
        struct flexiblas_hook_fn dlantr;
        struct flexiblas_hook_fn dlanv2;
        struct flexiblas_hook_fn dlaorhr_col_getrfnp;
        struct flexiblas_hook_fn dlaorhr_col_getrfnp2;
        struct flexiblas_hook_fn dlapll;
        struct flexiblas_hook_fn dlapmr;
        struct flexiblas_hook_fn dlapmt;
        struct flexiblas_hook_fn dlapy2;
        struct flexiblas_hook_fn dlapy3;
        struct flexiblas_hook_fn dlaqgb;
        struct flexiblas_hook_fn dlaqge;
        struct flexiblas_hook_fn dlaqp2;
        struct flexiblas_hook_fn dlaqps;
        struct flexiblas_hook_fn dlaqr0;
        struct flexiblas_hook_fn dlaqr1;
        struct flexiblas_hook_fn dlaqr2;
        struct flexiblas_hook_fn dlaqr3;
        struct flexiblas_hook_fn dlaqr4;
        struct flexiblas_hook_fn dlaqr5;
        struct flexiblas_hook_fn dlaqsb;
        struct flexiblas_hook_fn dlaqsp;
        struct flexiblas_hook_fn dlaqsy;
        struct flexiblas_hook_fn dlaqtr;
        struct flexiblas_hook_fn dlar1v;
        struct flexiblas_hook_fn dlar2v;
        struct flexiblas_hook_fn dlarf;
        struct flexiblas_hook_fn dlarfb;
        struct flexiblas_hook_fn dlarfg;
        struct flexiblas_hook_fn dlarfgp;
        struct flexiblas_hook_fn dlarft;
        struct flexiblas_hook_fn dlarfx;
        struct flexiblas_hook_fn dlarfy;
        struct flexiblas_hook_fn dlargv;
        struct flexiblas_hook_fn dlarnv;
        struct flexiblas_hook_fn dlarra;
        struct flexiblas_hook_fn dlarrb;
        struct flexiblas_hook_fn dlarrc;
        struct flexiblas_hook_fn dlarrd;
        struct flexiblas_hook_fn dlarre;
        struct flexiblas_hook_fn dlarrf;
        struct flexiblas_hook_fn dlarrj;
        struct flexiblas_hook_fn dlarrk;
        struct flexiblas_hook_fn dlarrr;
        struct flexiblas_hook_fn dlarrv;
        struct flexiblas_hook_fn dlartg;
        struct flexiblas_hook_fn dlartgp;
        struct flexiblas_hook_fn dlartgs;
        struct flexiblas_hook_fn dlartv;
        struct flexiblas_hook_fn dlaruv;
        struct flexiblas_hook_fn dlarz;
        struct flexiblas_hook_fn dlarzb;
        struct flexiblas_hook_fn dlarzt;
        struct flexiblas_hook_fn dlas2;
        struct flexiblas_hook_fn dlascl;
        struct flexiblas_hook_fn dlasd0;
        struct flexiblas_hook_fn dlasd1;
        struct flexiblas_hook_fn dlasd2;
        struct flexiblas_hook_fn dlasd3;
        struct flexiblas_hook_fn dlasd4;
        struct flexiblas_hook_fn dlasd5;
        struct flexiblas_hook_fn dlasd6;
        struct flexiblas_hook_fn dlasd7;
        struct flexiblas_hook_fn dlasd8;
        struct flexiblas_hook_fn dlasda;
        struct flexiblas_hook_fn dlasdq;
        struct flexiblas_hook_fn dlasdt;
        struct flexiblas_hook_fn dlaset;
        struct flexiblas_hook_fn dlasq1;
        struct flexiblas_hook_fn dlasq2;
        struct flexiblas_hook_fn dlasq3;
        struct flexiblas_hook_fn dlasq4;
        struct flexiblas_hook_fn dlasq5;
        struct flexiblas_hook_fn dlasq6;
        struct flexiblas_hook_fn dlasr;
        struct flexiblas_hook_fn dlasrt;
        struct flexiblas_hook_fn dlassq;
        struct flexiblas_hook_fn dlasv2;
        struct flexiblas_hook_fn dlaswlq;
        struct flexiblas_hook_fn dlaswp;
        struct flexiblas_hook_fn dlasy2;
        struct flexiblas_hook_fn dlasyf;
        struct flexiblas_hook_fn dlasyf_aa;
        struct flexiblas_hook_fn dlasyf_rk;
        struct flexiblas_hook_fn dlasyf_rook;
        struct flexiblas_hook_fn dlat2s;
        struct flexiblas_hook_fn dlatbs;
        struct flexiblas_hook_fn dlatdf;
        struct flexiblas_hook_fn dlatps;
        struct flexiblas_hook_fn dlatrd;
        struct flexiblas_hook_fn dlatrs;
        struct flexiblas_hook_fn dlatrz;
        struct flexiblas_hook_fn dlatsqr;
        struct flexiblas_hook_fn dlatzm;
        struct flexiblas_hook_fn dlauu2;
        struct flexiblas_hook_fn dlauum;
        struct flexiblas_hook_fn dopgtr;
        struct flexiblas_hook_fn dopmtr;
        struct flexiblas_hook_fn dorbdb;
        struct flexiblas_hook_fn dorbdb1;
        struct flexiblas_hook_fn dorbdb2;
        struct flexiblas_hook_fn dorbdb3;
        struct flexiblas_hook_fn dorbdb4;
        struct flexiblas_hook_fn dorbdb5;
        struct flexiblas_hook_fn dorbdb6;
        struct flexiblas_hook_fn dorcsd;
        struct flexiblas_hook_fn dorcsd2by1;
        struct flexiblas_hook_fn dorg2l;
        struct flexiblas_hook_fn dorg2r;
        struct flexiblas_hook_fn dorgbr;
        struct flexiblas_hook_fn dorghr;
        struct flexiblas_hook_fn dorgl2;
        struct flexiblas_hook_fn dorglq;
        struct flexiblas_hook_fn dorgql;
        struct flexiblas_hook_fn dorgqr;
        struct flexiblas_hook_fn dorgr2;
        struct flexiblas_hook_fn dorgrq;
        struct flexiblas_hook_fn dorgtr;
        struct flexiblas_hook_fn dorgtsqr;
        struct flexiblas_hook_fn dorhr_col;
        struct flexiblas_hook_fn dorm22;
        struct flexiblas_hook_fn dorm2l;
        struct flexiblas_hook_fn dorm2r;
        struct flexiblas_hook_fn dormbr;
        struct flexiblas_hook_fn dormhr;
        struct flexiblas_hook_fn dorml2;
        struct flexiblas_hook_fn dormlq;
        struct flexiblas_hook_fn dormql;
        struct flexiblas_hook_fn dormqr;
        struct flexiblas_hook_fn dormr2;
        struct flexiblas_hook_fn dormr3;
        struct flexiblas_hook_fn dormrq;
        struct flexiblas_hook_fn dormrz;
        struct flexiblas_hook_fn dormtr;
        struct flexiblas_hook_fn dpbcon;
        struct flexiblas_hook_fn dpbequ;
        struct flexiblas_hook_fn dpbrfs;
        struct flexiblas_hook_fn dpbstf;
        struct flexiblas_hook_fn dpbsv;
        struct flexiblas_hook_fn dpbsvx;
        struct flexiblas_hook_fn dpbtf2;
        struct flexiblas_hook_fn dpbtrf;
        struct flexiblas_hook_fn dpbtrs;
        struct flexiblas_hook_fn dpftrf;
        struct flexiblas_hook_fn dpftri;
        struct flexiblas_hook_fn dpftrs;
        struct flexiblas_hook_fn dpocon;
        struct flexiblas_hook_fn dpoequ;
        struct flexiblas_hook_fn dpoequb;
        struct flexiblas_hook_fn dporfs;
        struct flexiblas_hook_fn dposv;
        struct flexiblas_hook_fn dposvx;
        struct flexiblas_hook_fn dpotf2;
        struct flexiblas_hook_fn dpotrf;
        struct flexiblas_hook_fn dpotrf2;
        struct flexiblas_hook_fn dpotri;
        struct flexiblas_hook_fn dpotrs;
        struct flexiblas_hook_fn dppcon;
        struct flexiblas_hook_fn dppequ;
        struct flexiblas_hook_fn dpprfs;
        struct flexiblas_hook_fn dppsv;
        struct flexiblas_hook_fn dppsvx;
        struct flexiblas_hook_fn dpptrf;
        struct flexiblas_hook_fn dpptri;
        struct flexiblas_hook_fn dpptrs;
        struct flexiblas_hook_fn dpstf2;
        struct flexiblas_hook_fn dpstrf;
        struct flexiblas_hook_fn dptcon;
        struct flexiblas_hook_fn dpteqr;
        struct flexiblas_hook_fn dptrfs;
        struct flexiblas_hook_fn dptsv;
        struct flexiblas_hook_fn dptsvx;
        struct flexiblas_hook_fn dpttrf;
        struct flexiblas_hook_fn dpttrs;
        struct flexiblas_hook_fn dptts2;
        struct flexiblas_hook_fn drscl;
        struct flexiblas_hook_fn dsb2st_kernels;
        struct flexiblas_hook_fn dsbev;
        struct flexiblas_hook_fn dsbev_2stage;
        struct flexiblas_hook_fn dsbevd;
        struct flexiblas_hook_fn dsbevd_2stage;
        struct flexiblas_hook_fn dsbevx;
        struct flexiblas_hook_fn dsbevx_2stage;
        struct flexiblas_hook_fn dsbgst;
        struct flexiblas_hook_fn dsbgv;
        struct flexiblas_hook_fn dsbgvd;
        struct flexiblas_hook_fn dsbgvx;
        struct flexiblas_hook_fn dsbtrd;
        struct flexiblas_hook_fn dsfrk;
        struct flexiblas_hook_fn dsgesv;
        struct flexiblas_hook_fn dspcon;
        struct flexiblas_hook_fn dspev;
        struct flexiblas_hook_fn dspevd;
        struct flexiblas_hook_fn dspevx;
        struct flexiblas_hook_fn dspgst;
        struct flexiblas_hook_fn dspgv;
        struct flexiblas_hook_fn dspgvd;
        struct flexiblas_hook_fn dspgvx;
        struct flexiblas_hook_fn dsposv;
        struct flexiblas_hook_fn dsprfs;
        struct flexiblas_hook_fn dspsv;
        struct flexiblas_hook_fn dspsvx;
        struct flexiblas_hook_fn dsptrd;
        struct flexiblas_hook_fn dsptrf;
        struct flexiblas_hook_fn dsptri;
        struct flexiblas_hook_fn dsptrs;
        struct flexiblas_hook_fn dstebz;
        struct flexiblas_hook_fn dstedc;
        struct flexiblas_hook_fn dstegr;
        struct flexiblas_hook_fn dstein;
        struct flexiblas_hook_fn dstemr;
        struct flexiblas_hook_fn dsteqr;
        struct flexiblas_hook_fn dsterf;
        struct flexiblas_hook_fn dstev;
        struct flexiblas_hook_fn dstevd;
        struct flexiblas_hook_fn dstevr;
        struct flexiblas_hook_fn dstevx;
        struct flexiblas_hook_fn dsycon;
        struct flexiblas_hook_fn dsycon_3;
        struct flexiblas_hook_fn dsycon_rook;
        struct flexiblas_hook_fn dsyconv;
        struct flexiblas_hook_fn dsyconvf;
        struct flexiblas_hook_fn dsyconvf_rook;
        struct flexiblas_hook_fn dsyequb;
        struct flexiblas_hook_fn dsyev;
        struct flexiblas_hook_fn dsyev_2stage;
        struct flexiblas_hook_fn dsyevd;
        struct flexiblas_hook_fn dsyevd_2stage;
        struct flexiblas_hook_fn dsyevr;
        struct flexiblas_hook_fn dsyevr_2stage;
        struct flexiblas_hook_fn dsyevx;
        struct flexiblas_hook_fn dsyevx_2stage;
        struct flexiblas_hook_fn dsygs2;
        struct flexiblas_hook_fn dsygst;
        struct flexiblas_hook_fn dsygv;
        struct flexiblas_hook_fn dsygv_2stage;
        struct flexiblas_hook_fn dsygvd;
        struct flexiblas_hook_fn dsygvx;
        struct flexiblas_hook_fn dsyrfs;
        struct flexiblas_hook_fn dsysv;
        struct flexiblas_hook_fn dsysv_aa;
        struct flexiblas_hook_fn dsysv_aa_2stage;
        struct flexiblas_hook_fn dsysv_rk;
        struct flexiblas_hook_fn dsysv_rook;
        struct flexiblas_hook_fn dsysvx;
        struct flexiblas_hook_fn dsyswapr;
        struct flexiblas_hook_fn dsytd2;
        struct flexiblas_hook_fn dsytf2;
        struct flexiblas_hook_fn dsytf2_rk;
        struct flexiblas_hook_fn dsytf2_rook;
        struct flexiblas_hook_fn dsytrd;
        struct flexiblas_hook_fn dsytrd_2stage;
        struct flexiblas_hook_fn dsytrd_sb2st;
        struct flexiblas_hook_fn dsytrd_sy2sb;
        struct flexiblas_hook_fn dsytrf;
        struct flexiblas_hook_fn dsytrf_aa;
        struct flexiblas_hook_fn dsytrf_aa_2stage;
        struct flexiblas_hook_fn dsytrf_rk;
        struct flexiblas_hook_fn dsytrf_rook;
        struct flexiblas_hook_fn dsytri;
        struct flexiblas_hook_fn dsytri2;
        struct flexiblas_hook_fn dsytri2x;
        struct flexiblas_hook_fn dsytri_3;
        struct flexiblas_hook_fn dsytri_3x;
        struct flexiblas_hook_fn dsytri_rook;
        struct flexiblas_hook_fn dsytrs;
        struct flexiblas_hook_fn dsytrs2;
        struct flexiblas_hook_fn dsytrs_3;
        struct flexiblas_hook_fn dsytrs_aa;
        struct flexiblas_hook_fn dsytrs_aa_2stage;
        struct flexiblas_hook_fn dsytrs_rook;
        struct flexiblas_hook_fn dtbcon;
        struct flexiblas_hook_fn dtbrfs;
        struct flexiblas_hook_fn dtbtrs;
        struct flexiblas_hook_fn dtfsm;
        struct flexiblas_hook_fn dtftri;
        struct flexiblas_hook_fn dtfttp;
        struct flexiblas_hook_fn dtfttr;
        struct flexiblas_hook_fn dtgevc;
        struct flexiblas_hook_fn dtgex2;
        struct flexiblas_hook_fn dtgexc;
        struct flexiblas_hook_fn dtgsen;
        struct flexiblas_hook_fn dtgsja;
        struct flexiblas_hook_fn dtgsna;
        struct flexiblas_hook_fn dtgsy2;
        struct flexiblas_hook_fn dtgsyl;
        struct flexiblas_hook_fn dtpcon;
        struct flexiblas_hook_fn dtplqt;
        struct flexiblas_hook_fn dtplqt2;
        struct flexiblas_hook_fn dtpmlqt;
        struct flexiblas_hook_fn dtpmqrt;
        struct flexiblas_hook_fn dtpqrt;
        struct flexiblas_hook_fn dtpqrt2;
        struct flexiblas_hook_fn dtprfb;
        struct flexiblas_hook_fn dtprfs;
        struct flexiblas_hook_fn dtptri;
        struct flexiblas_hook_fn dtptrs;
        struct flexiblas_hook_fn dtpttf;
        struct flexiblas_hook_fn dtpttr;
        struct flexiblas_hook_fn dtrcon;
        struct flexiblas_hook_fn dtrevc;
        struct flexiblas_hook_fn dtrevc3;
        struct flexiblas_hook_fn dtrexc;
        struct flexiblas_hook_fn dtrrfs;
        struct flexiblas_hook_fn dtrsen;
        struct flexiblas_hook_fn dtrsna;
        struct flexiblas_hook_fn dtrsyl;
        struct flexiblas_hook_fn dtrti2;
        struct flexiblas_hook_fn dtrtri;
        struct flexiblas_hook_fn dtrtrs;
        struct flexiblas_hook_fn dtrttf;
        struct flexiblas_hook_fn dtrttp;
        struct flexiblas_hook_fn dtzrqf;
        struct flexiblas_hook_fn dtzrzf;
        struct flexiblas_hook_fn dzsum1;
        struct flexiblas_hook_fn icmax1;
        struct flexiblas_hook_fn ieeeck;
        struct flexiblas_hook_fn ilaclc;
        struct flexiblas_hook_fn ilaclr;
        struct flexiblas_hook_fn iladiag;
        struct flexiblas_hook_fn iladlc;
        struct flexiblas_hook_fn iladlr;
        struct flexiblas_hook_fn ilaenv;
        struct flexiblas_hook_fn ilaenv2stage;
        struct flexiblas_hook_fn ilaprec;
        struct flexiblas_hook_fn ilaslc;
        struct flexiblas_hook_fn ilaslr;
        struct flexiblas_hook_fn ilatrans;
        struct flexiblas_hook_fn ilauplo;
        struct flexiblas_hook_fn ilazlc;
        struct flexiblas_hook_fn ilazlr;
        struct flexiblas_hook_fn iparam2stage;
        struct flexiblas_hook_fn iparmq;
        struct flexiblas_hook_fn izmax1;
        struct flexiblas_hook_fn lsamen;
        struct flexiblas_hook_fn sbbcsd;
        struct flexiblas_hook_fn sbdsdc;
        struct flexiblas_hook_fn sbdsqr;
        struct flexiblas_hook_fn sbdsvdx;
        struct flexiblas_hook_fn scombssq;
        struct flexiblas_hook_fn scsum1;
        struct flexiblas_hook_fn sdisna;
        struct flexiblas_hook_fn sgbbrd;
        struct flexiblas_hook_fn sgbcon;
        struct flexiblas_hook_fn sgbequ;
        struct flexiblas_hook_fn sgbequb;
        struct flexiblas_hook_fn sgbrfs;
        struct flexiblas_hook_fn sgbsv;
        struct flexiblas_hook_fn sgbsvx;
        struct flexiblas_hook_fn sgbtf2;
        struct flexiblas_hook_fn sgbtrf;
        struct flexiblas_hook_fn sgbtrs;
        struct flexiblas_hook_fn sgebak;
        struct flexiblas_hook_fn sgebal;
        struct flexiblas_hook_fn sgebd2;
        struct flexiblas_hook_fn sgebrd;
        struct flexiblas_hook_fn sgecon;
        struct flexiblas_hook_fn sgeequ;
        struct flexiblas_hook_fn sgeequb;
        struct flexiblas_hook_fn sgees;
        struct flexiblas_hook_fn sgeesx;
        struct flexiblas_hook_fn sgeev;
        struct flexiblas_hook_fn sgeevx;
        struct flexiblas_hook_fn sgegs;
        struct flexiblas_hook_fn sgegv;
        struct flexiblas_hook_fn sgehd2;
        struct flexiblas_hook_fn sgehrd;
        struct flexiblas_hook_fn sgejsv;
        struct flexiblas_hook_fn sgelq;
        struct flexiblas_hook_fn sgelq2;
        struct flexiblas_hook_fn sgelqf;
        struct flexiblas_hook_fn sgelqt;
        struct flexiblas_hook_fn sgelqt3;
        struct flexiblas_hook_fn sgels;
        struct flexiblas_hook_fn sgelsd;
        struct flexiblas_hook_fn sgelss;
        struct flexiblas_hook_fn sgelsx;
        struct flexiblas_hook_fn sgelsy;
        struct flexiblas_hook_fn sgemlq;
        struct flexiblas_hook_fn sgemlqt;
        struct flexiblas_hook_fn sgemqr;
        struct flexiblas_hook_fn sgemqrt;
        struct flexiblas_hook_fn sgeql2;
        struct flexiblas_hook_fn sgeqlf;
        struct flexiblas_hook_fn sgeqp3;
        struct flexiblas_hook_fn sgeqpf;
        struct flexiblas_hook_fn sgeqr;
        struct flexiblas_hook_fn sgeqr2;
        struct flexiblas_hook_fn sgeqr2p;
        struct flexiblas_hook_fn sgeqrf;
        struct flexiblas_hook_fn sgeqrfp;
        struct flexiblas_hook_fn sgeqrt;
        struct flexiblas_hook_fn sgeqrt2;
        struct flexiblas_hook_fn sgeqrt3;
        struct flexiblas_hook_fn sgerfs;
        struct flexiblas_hook_fn sgerq2;
        struct flexiblas_hook_fn sgerqf;
        struct flexiblas_hook_fn sgesc2;
        struct flexiblas_hook_fn sgesdd;
        struct flexiblas_hook_fn sgesv;
        struct flexiblas_hook_fn sgesvd;
        struct flexiblas_hook_fn sgesvdq;
        struct flexiblas_hook_fn sgesvdx;
        struct flexiblas_hook_fn sgesvj;
        struct flexiblas_hook_fn sgesvx;
        struct flexiblas_hook_fn sgetc2;
        struct flexiblas_hook_fn sgetf2;
        struct flexiblas_hook_fn sgetrf;
        struct flexiblas_hook_fn sgetrf2;
        struct flexiblas_hook_fn sgetri;
        struct flexiblas_hook_fn sgetrs;
        struct flexiblas_hook_fn sgetsls;
        struct flexiblas_hook_fn sggbak;
        struct flexiblas_hook_fn sggbal;
        struct flexiblas_hook_fn sgges;
        struct flexiblas_hook_fn sgges3;
        struct flexiblas_hook_fn sggesx;
        struct flexiblas_hook_fn sggev;
        struct flexiblas_hook_fn sggev3;
        struct flexiblas_hook_fn sggevx;
        struct flexiblas_hook_fn sggglm;
        struct flexiblas_hook_fn sgghd3;
        struct flexiblas_hook_fn sgghrd;
        struct flexiblas_hook_fn sgglse;
        struct flexiblas_hook_fn sggqrf;
        struct flexiblas_hook_fn sggrqf;
        struct flexiblas_hook_fn sggsvd;
        struct flexiblas_hook_fn sggsvd3;
        struct flexiblas_hook_fn sggsvp;
        struct flexiblas_hook_fn sggsvp3;
        struct flexiblas_hook_fn sgsvj0;
        struct flexiblas_hook_fn sgsvj1;
        struct flexiblas_hook_fn sgtcon;
        struct flexiblas_hook_fn sgtrfs;
        struct flexiblas_hook_fn sgtsv;
        struct flexiblas_hook_fn sgtsvx;
        struct flexiblas_hook_fn sgttrf;
        struct flexiblas_hook_fn sgttrs;
        struct flexiblas_hook_fn sgtts2;
        struct flexiblas_hook_fn shgeqz;
        struct flexiblas_hook_fn shsein;
        struct flexiblas_hook_fn shseqr;
        struct flexiblas_hook_fn sisnan;
        struct flexiblas_hook_fn slabad;
        struct flexiblas_hook_fn slabrd;
        struct flexiblas_hook_fn slacn2;
        struct flexiblas_hook_fn slacon;
        struct flexiblas_hook_fn slacpy;
        struct flexiblas_hook_fn sladiv;
        struct flexiblas_hook_fn sladiv1;
        struct flexiblas_hook_fn sladiv2;
        struct flexiblas_hook_fn slae2;
        struct flexiblas_hook_fn slaebz;
        struct flexiblas_hook_fn slaed0;
        struct flexiblas_hook_fn slaed1;
        struct flexiblas_hook_fn slaed2;
        struct flexiblas_hook_fn slaed3;
        struct flexiblas_hook_fn slaed4;
        struct flexiblas_hook_fn slaed5;
        struct flexiblas_hook_fn slaed6;
        struct flexiblas_hook_fn slaed7;
        struct flexiblas_hook_fn slaed8;
        struct flexiblas_hook_fn slaed9;
        struct flexiblas_hook_fn slaeda;
        struct flexiblas_hook_fn slaein;
        struct flexiblas_hook_fn slaev2;
        struct flexiblas_hook_fn slaexc;
        struct flexiblas_hook_fn slag2;
        struct flexiblas_hook_fn slag2d;
        struct flexiblas_hook_fn slags2;
        struct flexiblas_hook_fn slagtf;
        struct flexiblas_hook_fn slagtm;
        struct flexiblas_hook_fn slagts;
        struct flexiblas_hook_fn slagv2;
        struct flexiblas_hook_fn slahqr;
        struct flexiblas_hook_fn slahr2;
        struct flexiblas_hook_fn slahrd;
        struct flexiblas_hook_fn slaic1;
        struct flexiblas_hook_fn slaisnan;
        struct flexiblas_hook_fn slaln2;
        struct flexiblas_hook_fn slals0;
        struct flexiblas_hook_fn slalsa;
        struct flexiblas_hook_fn slalsd;
        struct flexiblas_hook_fn slamrg;
        struct flexiblas_hook_fn slamswlq;
        struct flexiblas_hook_fn slamtsqr;
        struct flexiblas_hook_fn slaneg;
        struct flexiblas_hook_fn slangb;
        struct flexiblas_hook_fn slange;
        struct flexiblas_hook_fn slangt;
        struct flexiblas_hook_fn slanhs;
        struct flexiblas_hook_fn slansb;
        struct flexiblas_hook_fn slansf;
        struct flexiblas_hook_fn slansp;
        struct flexiblas_hook_fn slanst;
        struct flexiblas_hook_fn slansy;
        struct flexiblas_hook_fn slantb;
        struct flexiblas_hook_fn slantp;
        struct flexiblas_hook_fn slantr;
        struct flexiblas_hook_fn slanv2;
        struct flexiblas_hook_fn slaorhr_col_getrfnp;
        struct flexiblas_hook_fn slaorhr_col_getrfnp2;
        struct flexiblas_hook_fn slapll;
        struct flexiblas_hook_fn slapmr;
        struct flexiblas_hook_fn slapmt;
        struct flexiblas_hook_fn slapy2;
        struct flexiblas_hook_fn slapy3;
        struct flexiblas_hook_fn slaqgb;
        struct flexiblas_hook_fn slaqge;
        struct flexiblas_hook_fn slaqp2;
        struct flexiblas_hook_fn slaqps;
        struct flexiblas_hook_fn slaqr0;
        struct flexiblas_hook_fn slaqr1;
        struct flexiblas_hook_fn slaqr2;
        struct flexiblas_hook_fn slaqr3;
        struct flexiblas_hook_fn slaqr4;
        struct flexiblas_hook_fn slaqr5;
        struct flexiblas_hook_fn slaqsb;
        struct flexiblas_hook_fn slaqsp;
        struct flexiblas_hook_fn slaqsy;
        struct flexiblas_hook_fn slaqtr;
        struct flexiblas_hook_fn slar1v;
        struct flexiblas_hook_fn slar2v;
        struct flexiblas_hook_fn slarf;
        struct flexiblas_hook_fn slarfb;
        struct flexiblas_hook_fn slarfg;
        struct flexiblas_hook_fn slarfgp;
        struct flexiblas_hook_fn slarft;
        struct flexiblas_hook_fn slarfx;
        struct flexiblas_hook_fn slarfy;
        struct flexiblas_hook_fn slargv;
        struct flexiblas_hook_fn slarnv;
        struct flexiblas_hook_fn slarra;
        struct flexiblas_hook_fn slarrb;
        struct flexiblas_hook_fn slarrc;
        struct flexiblas_hook_fn slarrd;
        struct flexiblas_hook_fn slarre;
        struct flexiblas_hook_fn slarrf;
        struct flexiblas_hook_fn slarrj;
        struct flexiblas_hook_fn slarrk;
        struct flexiblas_hook_fn slarrr;
        struct flexiblas_hook_fn slarrv;
        struct flexiblas_hook_fn slartg;
        struct flexiblas_hook_fn slartgp;
        struct flexiblas_hook_fn slartgs;
        struct flexiblas_hook_fn slartv;
        struct flexiblas_hook_fn slaruv;
        struct flexiblas_hook_fn slarz;
        struct flexiblas_hook_fn slarzb;
        struct flexiblas_hook_fn slarzt;
        struct flexiblas_hook_fn slas2;
        struct flexiblas_hook_fn slascl;
        struct flexiblas_hook_fn slasd0;
        struct flexiblas_hook_fn slasd1;
        struct flexiblas_hook_fn slasd2;
        struct flexiblas_hook_fn slasd3;
        struct flexiblas_hook_fn slasd4;
        struct flexiblas_hook_fn slasd5;
        struct flexiblas_hook_fn slasd6;
        struct flexiblas_hook_fn slasd7;
        struct flexiblas_hook_fn slasd8;
        struct flexiblas_hook_fn slasda;
        struct flexiblas_hook_fn slasdq;
        struct flexiblas_hook_fn slasdt;
        struct flexiblas_hook_fn slaset;
        struct flexiblas_hook_fn slasq1;
        struct flexiblas_hook_fn slasq2;
        struct flexiblas_hook_fn slasq3;
        struct flexiblas_hook_fn slasq4;
        struct flexiblas_hook_fn slasq5;
        struct flexiblas_hook_fn slasq6;
        struct flexiblas_hook_fn slasr;
        struct flexiblas_hook_fn slasrt;
        struct flexiblas_hook_fn slassq;
        struct flexiblas_hook_fn slasv2;
        struct flexiblas_hook_fn slaswlq;
        struct flexiblas_hook_fn slaswp;
        struct flexiblas_hook_fn slasy2;
        struct flexiblas_hook_fn slasyf;
        struct flexiblas_hook_fn slasyf_aa;
        struct flexiblas_hook_fn slasyf_rk;
        struct flexiblas_hook_fn slasyf_rook;
        struct flexiblas_hook_fn slatbs;
        struct flexiblas_hook_fn slatdf;
        struct flexiblas_hook_fn slatps;
        struct flexiblas_hook_fn slatrd;
        struct flexiblas_hook_fn slatrs;
        struct flexiblas_hook_fn slatrz;
        struct flexiblas_hook_fn slatsqr;
        struct flexiblas_hook_fn slatzm;
        struct flexiblas_hook_fn slauu2;
        struct flexiblas_hook_fn slauum;
        struct flexiblas_hook_fn sopgtr;
        struct flexiblas_hook_fn sopmtr;
        struct flexiblas_hook_fn sorbdb;
        struct flexiblas_hook_fn sorbdb1;
        struct flexiblas_hook_fn sorbdb2;
        struct flexiblas_hook_fn sorbdb3;
        struct flexiblas_hook_fn sorbdb4;
        struct flexiblas_hook_fn sorbdb5;
        struct flexiblas_hook_fn sorbdb6;
        struct flexiblas_hook_fn sorcsd;
        struct flexiblas_hook_fn sorcsd2by1;
        struct flexiblas_hook_fn sorg2l;
        struct flexiblas_hook_fn sorg2r;
        struct flexiblas_hook_fn sorgbr;
        struct flexiblas_hook_fn sorghr;
        struct flexiblas_hook_fn sorgl2;
        struct flexiblas_hook_fn sorglq;
        struct flexiblas_hook_fn sorgql;
        struct flexiblas_hook_fn sorgqr;
        struct flexiblas_hook_fn sorgr2;
        struct flexiblas_hook_fn sorgrq;
        struct flexiblas_hook_fn sorgtr;
        struct flexiblas_hook_fn sorgtsqr;
        struct flexiblas_hook_fn sorhr_col;
        struct flexiblas_hook_fn sorm22;
        struct flexiblas_hook_fn sorm2l;
        struct flexiblas_hook_fn sorm2r;
        struct flexiblas_hook_fn sormbr;
        struct flexiblas_hook_fn sormhr;
        struct flexiblas_hook_fn sorml2;
        struct flexiblas_hook_fn sormlq;
        struct flexiblas_hook_fn sormql;
        struct flexiblas_hook_fn sormqr;
        struct flexiblas_hook_fn sormr2;
        struct flexiblas_hook_fn sormr3;
        struct flexiblas_hook_fn sormrq;
        struct flexiblas_hook_fn sormrz;
        struct flexiblas_hook_fn sormtr;
        struct flexiblas_hook_fn spbcon;
        struct flexiblas_hook_fn spbequ;
        struct flexiblas_hook_fn spbrfs;
        struct flexiblas_hook_fn spbstf;
        struct flexiblas_hook_fn spbsv;
        struct flexiblas_hook_fn spbsvx;
        struct flexiblas_hook_fn spbtf2;
        struct flexiblas_hook_fn spbtrf;
        struct flexiblas_hook_fn spbtrs;
        struct flexiblas_hook_fn spftrf;
        struct flexiblas_hook_fn spftri;
        struct flexiblas_hook_fn spftrs;
        struct flexiblas_hook_fn spocon;
        struct flexiblas_hook_fn spoequ;
        struct flexiblas_hook_fn spoequb;
        struct flexiblas_hook_fn sporfs;
        struct flexiblas_hook_fn sposv;
        struct flexiblas_hook_fn sposvx;
        struct flexiblas_hook_fn spotf2;
        struct flexiblas_hook_fn spotrf;
        struct flexiblas_hook_fn spotrf2;
        struct flexiblas_hook_fn spotri;
        struct flexiblas_hook_fn spotrs;
        struct flexiblas_hook_fn sppcon;
        struct flexiblas_hook_fn sppequ;
        struct flexiblas_hook_fn spprfs;
        struct flexiblas_hook_fn sppsv;
        struct flexiblas_hook_fn sppsvx;
        struct flexiblas_hook_fn spptrf;
        struct flexiblas_hook_fn spptri;
        struct flexiblas_hook_fn spptrs;
        struct flexiblas_hook_fn spstf2;
        struct flexiblas_hook_fn spstrf;
        struct flexiblas_hook_fn sptcon;
        struct flexiblas_hook_fn spteqr;
        struct flexiblas_hook_fn sptrfs;
        struct flexiblas_hook_fn sptsv;
        struct flexiblas_hook_fn sptsvx;
        struct flexiblas_hook_fn spttrf;
        struct flexiblas_hook_fn spttrs;
        struct flexiblas_hook_fn sptts2;
        struct flexiblas_hook_fn srscl;
        struct flexiblas_hook_fn ssb2st_kernels;
        struct flexiblas_hook_fn ssbev;
        struct flexiblas_hook_fn ssbev_2stage;
        struct flexiblas_hook_fn ssbevd;
        struct flexiblas_hook_fn ssbevd_2stage;
        struct flexiblas_hook_fn ssbevx;
        struct flexiblas_hook_fn ssbevx_2stage;
        struct flexiblas_hook_fn ssbgst;
        struct flexiblas_hook_fn ssbgv;
        struct flexiblas_hook_fn ssbgvd;
        struct flexiblas_hook_fn ssbgvx;
        struct flexiblas_hook_fn ssbtrd;
        struct flexiblas_hook_fn ssfrk;
        struct flexiblas_hook_fn sspcon;
        struct flexiblas_hook_fn sspev;
        struct flexiblas_hook_fn sspevd;
        struct flexiblas_hook_fn sspevx;
        struct flexiblas_hook_fn sspgst;
        struct flexiblas_hook_fn sspgv;
        struct flexiblas_hook_fn sspgvd;
        struct flexiblas_hook_fn sspgvx;
        struct flexiblas_hook_fn ssprfs;
        struct flexiblas_hook_fn sspsv;
        struct flexiblas_hook_fn sspsvx;
        struct flexiblas_hook_fn ssptrd;
        struct flexiblas_hook_fn ssptrf;
        struct flexiblas_hook_fn ssptri;
        struct flexiblas_hook_fn ssptrs;
        struct flexiblas_hook_fn sstebz;
        struct flexiblas_hook_fn sstedc;
        struct flexiblas_hook_fn sstegr;
        struct flexiblas_hook_fn sstein;
        struct flexiblas_hook_fn sstemr;
        struct flexiblas_hook_fn ssteqr;
        struct flexiblas_hook_fn ssterf;
        struct flexiblas_hook_fn sstev;
        struct flexiblas_hook_fn sstevd;
        struct flexiblas_hook_fn sstevr;
        struct flexiblas_hook_fn sstevx;
        struct flexiblas_hook_fn ssycon;
        struct flexiblas_hook_fn ssycon_3;
        struct flexiblas_hook_fn ssycon_rook;
        struct flexiblas_hook_fn ssyconv;
        struct flexiblas_hook_fn ssyconvf;
        struct flexiblas_hook_fn ssyconvf_rook;
        struct flexiblas_hook_fn ssyequb;
        struct flexiblas_hook_fn ssyev;
        struct flexiblas_hook_fn ssyev_2stage;
        struct flexiblas_hook_fn ssyevd;
        struct flexiblas_hook_fn ssyevd_2stage;
        struct flexiblas_hook_fn ssyevr;
        struct flexiblas_hook_fn ssyevr_2stage;
        struct flexiblas_hook_fn ssyevx;
        struct flexiblas_hook_fn ssyevx_2stage;
        struct flexiblas_hook_fn ssygs2;
        struct flexiblas_hook_fn ssygst;
        struct flexiblas_hook_fn ssygv;
        struct flexiblas_hook_fn ssygv_2stage;
        struct flexiblas_hook_fn ssygvd;
        struct flexiblas_hook_fn ssygvx;
        struct flexiblas_hook_fn ssyrfs;
        struct flexiblas_hook_fn ssysv;
        struct flexiblas_hook_fn ssysv_aa;
        struct flexiblas_hook_fn ssysv_aa_2stage;
        struct flexiblas_hook_fn ssysv_rk;
        struct flexiblas_hook_fn ssysv_rook;
        struct flexiblas_hook_fn ssysvx;
        struct flexiblas_hook_fn ssyswapr;
        struct flexiblas_hook_fn ssytd2;
        struct flexiblas_hook_fn ssytf2;
        struct flexiblas_hook_fn ssytf2_rk;
        struct flexiblas_hook_fn ssytf2_rook;
        struct flexiblas_hook_fn ssytrd;
        struct flexiblas_hook_fn ssytrd_2stage;
        struct flexiblas_hook_fn ssytrd_sb2st;
        struct flexiblas_hook_fn ssytrd_sy2sb;
        struct flexiblas_hook_fn ssytrf;
        struct flexiblas_hook_fn ssytrf_aa;
        struct flexiblas_hook_fn ssytrf_aa_2stage;
        struct flexiblas_hook_fn ssytrf_rk;
        struct flexiblas_hook_fn ssytrf_rook;
        struct flexiblas_hook_fn ssytri;
        struct flexiblas_hook_fn ssytri2;
        struct flexiblas_hook_fn ssytri2x;
        struct flexiblas_hook_fn ssytri_3;
        struct flexiblas_hook_fn ssytri_3x;
        struct flexiblas_hook_fn ssytri_rook;
        struct flexiblas_hook_fn ssytrs;
        struct flexiblas_hook_fn ssytrs2;
        struct flexiblas_hook_fn ssytrs_3;
        struct flexiblas_hook_fn ssytrs_aa;
        struct flexiblas_hook_fn ssytrs_aa_2stage;
        struct flexiblas_hook_fn ssytrs_rook;
        struct flexiblas_hook_fn stbcon;
        struct flexiblas_hook_fn stbrfs;
        struct flexiblas_hook_fn stbtrs;
        struct flexiblas_hook_fn stfsm;
        struct flexiblas_hook_fn stftri;
        struct flexiblas_hook_fn stfttp;
        struct flexiblas_hook_fn stfttr;
        struct flexiblas_hook_fn stgevc;
        struct flexiblas_hook_fn stgex2;
        struct flexiblas_hook_fn stgexc;
        struct flexiblas_hook_fn stgsen;
        struct flexiblas_hook_fn stgsja;
        struct flexiblas_hook_fn stgsna;
        struct flexiblas_hook_fn stgsy2;
        struct flexiblas_hook_fn stgsyl;
        struct flexiblas_hook_fn stpcon;
        struct flexiblas_hook_fn stplqt;
        struct flexiblas_hook_fn stplqt2;
        struct flexiblas_hook_fn stpmlqt;
        struct flexiblas_hook_fn stpmqrt;
        struct flexiblas_hook_fn stpqrt;
        struct flexiblas_hook_fn stpqrt2;
        struct flexiblas_hook_fn stprfb;
        struct flexiblas_hook_fn stprfs;
        struct flexiblas_hook_fn stptri;
        struct flexiblas_hook_fn stptrs;
        struct flexiblas_hook_fn stpttf;
        struct flexiblas_hook_fn stpttr;
        struct flexiblas_hook_fn strcon;
        struct flexiblas_hook_fn strevc;
        struct flexiblas_hook_fn strevc3;
        struct flexiblas_hook_fn strexc;
        struct flexiblas_hook_fn strrfs;
        struct flexiblas_hook_fn strsen;
        struct flexiblas_hook_fn strsna;
        struct flexiblas_hook_fn strsyl;
        struct flexiblas_hook_fn strti2;
        struct flexiblas_hook_fn strtri;
        struct flexiblas_hook_fn strtrs;
        struct flexiblas_hook_fn strttf;
        struct flexiblas_hook_fn strttp;
        struct flexiblas_hook_fn stzrqf;
        struct flexiblas_hook_fn stzrzf;
        struct flexiblas_hook_fn xerbla_array;
        struct flexiblas_hook_fn zbbcsd;
        struct flexiblas_hook_fn zbdsqr;
        struct flexiblas_hook_fn zcgesv;
        struct flexiblas_hook_fn zcposv;
        struct flexiblas_hook_fn zdrscl;
        struct flexiblas_hook_fn zgbbrd;
        struct flexiblas_hook_fn zgbcon;
        struct flexiblas_hook_fn zgbequ;
        struct flexiblas_hook_fn zgbequb;
        struct flexiblas_hook_fn zgbrfs;
        struct flexiblas_hook_fn zgbsv;
        struct flexiblas_hook_fn zgbsvx;
        struct flexiblas_hook_fn zgbtf2;
        struct flexiblas_hook_fn zgbtrf;
        struct flexiblas_hook_fn zgbtrs;
        struct flexiblas_hook_fn zgebak;
        struct flexiblas_hook_fn zgebal;
        struct flexiblas_hook_fn zgebd2;
        struct flexiblas_hook_fn zgebrd;
        struct flexiblas_hook_fn zgecon;
        struct flexiblas_hook_fn zgeequ;
        struct flexiblas_hook_fn zgeequb;
        struct flexiblas_hook_fn zgees;
        struct flexiblas_hook_fn zgeesx;
        struct flexiblas_hook_fn zgeev;
        struct flexiblas_hook_fn zgeevx;
        struct flexiblas_hook_fn zgegs;
        struct flexiblas_hook_fn zgegv;
        struct flexiblas_hook_fn zgehd2;
        struct flexiblas_hook_fn zgehrd;
        struct flexiblas_hook_fn zgejsv;
        struct flexiblas_hook_fn zgelq;
        struct flexiblas_hook_fn zgelq2;
        struct flexiblas_hook_fn zgelqf;
        struct flexiblas_hook_fn zgelqt;
        struct flexiblas_hook_fn zgelqt3;
        struct flexiblas_hook_fn zgels;
        struct flexiblas_hook_fn zgelsd;
        struct flexiblas_hook_fn zgelss;
        struct flexiblas_hook_fn zgelsx;
        struct flexiblas_hook_fn zgelsy;
        struct flexiblas_hook_fn zgemlq;
        struct flexiblas_hook_fn zgemlqt;
        struct flexiblas_hook_fn zgemqr;
        struct flexiblas_hook_fn zgemqrt;
        struct flexiblas_hook_fn zgeql2;
        struct flexiblas_hook_fn zgeqlf;
        struct flexiblas_hook_fn zgeqp3;
        struct flexiblas_hook_fn zgeqpf;
        struct flexiblas_hook_fn zgeqr;
        struct flexiblas_hook_fn zgeqr2;
        struct flexiblas_hook_fn zgeqr2p;
        struct flexiblas_hook_fn zgeqrf;
        struct flexiblas_hook_fn zgeqrfp;
        struct flexiblas_hook_fn zgeqrt;
        struct flexiblas_hook_fn zgeqrt2;
        struct flexiblas_hook_fn zgeqrt3;
        struct flexiblas_hook_fn zgerfs;
        struct flexiblas_hook_fn zgerq2;
        struct flexiblas_hook_fn zgerqf;
        struct flexiblas_hook_fn zgesc2;
        struct flexiblas_hook_fn zgesdd;
        struct flexiblas_hook_fn zgesv;
        struct flexiblas_hook_fn zgesvd;
        struct flexiblas_hook_fn zgesvdq;
        struct flexiblas_hook_fn zgesvdx;
        struct flexiblas_hook_fn zgesvj;
        struct flexiblas_hook_fn zgesvx;
        struct flexiblas_hook_fn zgetc2;
        struct flexiblas_hook_fn zgetf2;
        struct flexiblas_hook_fn zgetrf;
        struct flexiblas_hook_fn zgetrf2;
        struct flexiblas_hook_fn zgetri;
        struct flexiblas_hook_fn zgetrs;
        struct flexiblas_hook_fn zgetsls;
        struct flexiblas_hook_fn zggbak;
        struct flexiblas_hook_fn zggbal;
        struct flexiblas_hook_fn zgges;
        struct flexiblas_hook_fn zgges3;
        struct flexiblas_hook_fn zggesx;
        struct flexiblas_hook_fn zggev;
        struct flexiblas_hook_fn zggev3;
        struct flexiblas_hook_fn zggevx;
        struct flexiblas_hook_fn zggglm;
        struct flexiblas_hook_fn zgghd3;
        struct flexiblas_hook_fn zgghrd;
        struct flexiblas_hook_fn zgglse;
        struct flexiblas_hook_fn zggqrf;
        struct flexiblas_hook_fn zggrqf;
        struct flexiblas_hook_fn zggsvd;
        struct flexiblas_hook_fn zggsvd3;
        struct flexiblas_hook_fn zggsvp;
        struct flexiblas_hook_fn zggsvp3;
        struct flexiblas_hook_fn zgsvj0;
        struct flexiblas_hook_fn zgsvj1;
        struct flexiblas_hook_fn zgtcon;
        struct flexiblas_hook_fn zgtrfs;
        struct flexiblas_hook_fn zgtsv;
        struct flexiblas_hook_fn zgtsvx;
        struct flexiblas_hook_fn zgttrf;
        struct flexiblas_hook_fn zgttrs;
        struct flexiblas_hook_fn zgtts2;
        struct flexiblas_hook_fn zhb2st_kernels;
        struct flexiblas_hook_fn zhbev;
        struct flexiblas_hook_fn zhbev_2stage;
        struct flexiblas_hook_fn zhbevd;
        struct flexiblas_hook_fn zhbevd_2stage;
        struct flexiblas_hook_fn zhbevx;
        struct flexiblas_hook_fn zhbevx_2stage;
        struct flexiblas_hook_fn zhbgst;
        struct flexiblas_hook_fn zhbgv;
        struct flexiblas_hook_fn zhbgvd;
        struct flexiblas_hook_fn zhbgvx;
        struct flexiblas_hook_fn zhbtrd;
        struct flexiblas_hook_fn zhecon;
        struct flexiblas_hook_fn zhecon_3;
        struct flexiblas_hook_fn zhecon_rook;
        struct flexiblas_hook_fn zheequb;
        struct flexiblas_hook_fn zheev;
        struct flexiblas_hook_fn zheev_2stage;
        struct flexiblas_hook_fn zheevd;
        struct flexiblas_hook_fn zheevd_2stage;
        struct flexiblas_hook_fn zheevr;
        struct flexiblas_hook_fn zheevr_2stage;
        struct flexiblas_hook_fn zheevx;
        struct flexiblas_hook_fn zheevx_2stage;
        struct flexiblas_hook_fn zhegs2;
        struct flexiblas_hook_fn zhegst;
        struct flexiblas_hook_fn zhegv;
        struct flexiblas_hook_fn zhegv_2stage;
        struct flexiblas_hook_fn zhegvd;
        struct flexiblas_hook_fn zhegvx;
        struct flexiblas_hook_fn zherfs;
        struct flexiblas_hook_fn zhesv;
        struct flexiblas_hook_fn zhesv_aa;
        struct flexiblas_hook_fn zhesv_aa_2stage;
        struct flexiblas_hook_fn zhesv_rk;
        struct flexiblas_hook_fn zhesv_rook;
        struct flexiblas_hook_fn zhesvx;
        struct flexiblas_hook_fn zheswapr;
        struct flexiblas_hook_fn zhetd2;
        struct flexiblas_hook_fn zhetf2;
        struct flexiblas_hook_fn zhetf2_rk;
        struct flexiblas_hook_fn zhetf2_rook;
        struct flexiblas_hook_fn zhetrd;
        struct flexiblas_hook_fn zhetrd_2stage;
        struct flexiblas_hook_fn zhetrd_hb2st;
        struct flexiblas_hook_fn zhetrd_he2hb;
        struct flexiblas_hook_fn zhetrf;
        struct flexiblas_hook_fn zhetrf_aa;
        struct flexiblas_hook_fn zhetrf_aa_2stage;
        struct flexiblas_hook_fn zhetrf_rk;
        struct flexiblas_hook_fn zhetrf_rook;
        struct flexiblas_hook_fn zhetri;
        struct flexiblas_hook_fn zhetri2;
        struct flexiblas_hook_fn zhetri2x;
        struct flexiblas_hook_fn zhetri_3;
        struct flexiblas_hook_fn zhetri_3x;
        struct flexiblas_hook_fn zhetri_rook;
        struct flexiblas_hook_fn zhetrs;
        struct flexiblas_hook_fn zhetrs2;
        struct flexiblas_hook_fn zhetrs_3;
        struct flexiblas_hook_fn zhetrs_aa;
        struct flexiblas_hook_fn zhetrs_aa_2stage;
        struct flexiblas_hook_fn zhetrs_rook;
        struct flexiblas_hook_fn zhfrk;
        struct flexiblas_hook_fn zhgeqz;
        struct flexiblas_hook_fn zhpcon;
        struct flexiblas_hook_fn zhpev;
        struct flexiblas_hook_fn zhpevd;
        struct flexiblas_hook_fn zhpevx;
        struct flexiblas_hook_fn zhpgst;
        struct flexiblas_hook_fn zhpgv;
        struct flexiblas_hook_fn zhpgvd;
        struct flexiblas_hook_fn zhpgvx;
        struct flexiblas_hook_fn zhprfs;
        struct flexiblas_hook_fn zhpsv;
        struct flexiblas_hook_fn zhpsvx;
        struct flexiblas_hook_fn zhptrd;
        struct flexiblas_hook_fn zhptrf;
        struct flexiblas_hook_fn zhptri;
        struct flexiblas_hook_fn zhptrs;
        struct flexiblas_hook_fn zhsein;
        struct flexiblas_hook_fn zhseqr;
        struct flexiblas_hook_fn zlabrd;
        struct flexiblas_hook_fn zlacgv;
        struct flexiblas_hook_fn zlacn2;
        struct flexiblas_hook_fn zlacon;
        struct flexiblas_hook_fn zlacp2;
        struct flexiblas_hook_fn zlacpy;
        struct flexiblas_hook_fn zlacrm;
        struct flexiblas_hook_fn zlacrt;
        struct flexiblas_hook_fn zladiv;
        struct flexiblas_hook_fn zlaed0;
        struct flexiblas_hook_fn zlaed7;
        struct flexiblas_hook_fn zlaed8;
        struct flexiblas_hook_fn zlaein;
        struct flexiblas_hook_fn zlaesy;
        struct flexiblas_hook_fn zlaev2;
        struct flexiblas_hook_fn zlag2c;
        struct flexiblas_hook_fn zlags2;
        struct flexiblas_hook_fn zlagtm;
        struct flexiblas_hook_fn zlahef;
        struct flexiblas_hook_fn zlahef_aa;
        struct flexiblas_hook_fn zlahef_rk;
        struct flexiblas_hook_fn zlahef_rook;
        struct flexiblas_hook_fn zlahqr;
        struct flexiblas_hook_fn zlahr2;
        struct flexiblas_hook_fn zlahrd;
        struct flexiblas_hook_fn zlaic1;
        struct flexiblas_hook_fn zlals0;
        struct flexiblas_hook_fn zlalsa;
        struct flexiblas_hook_fn zlalsd;
        struct flexiblas_hook_fn zlamswlq;
        struct flexiblas_hook_fn zlamtsqr;
        struct flexiblas_hook_fn zlangb;
        struct flexiblas_hook_fn zlange;
        struct flexiblas_hook_fn zlangt;
        struct flexiblas_hook_fn zlanhb;
        struct flexiblas_hook_fn zlanhe;
        struct flexiblas_hook_fn zlanhf;
        struct flexiblas_hook_fn zlanhp;
        struct flexiblas_hook_fn zlanhs;
        struct flexiblas_hook_fn zlanht;
        struct flexiblas_hook_fn zlansb;
        struct flexiblas_hook_fn zlansp;
        struct flexiblas_hook_fn zlansy;
        struct flexiblas_hook_fn zlantb;
        struct flexiblas_hook_fn zlantp;
        struct flexiblas_hook_fn zlantr;
        struct flexiblas_hook_fn zlapll;
        struct flexiblas_hook_fn zlapmr;
        struct flexiblas_hook_fn zlapmt;
        struct flexiblas_hook_fn zlaqgb;
        struct flexiblas_hook_fn zlaqge;
        struct flexiblas_hook_fn zlaqhb;
        struct flexiblas_hook_fn zlaqhe;
        struct flexiblas_hook_fn zlaqhp;
        struct flexiblas_hook_fn zlaqp2;
        struct flexiblas_hook_fn zlaqps;
        struct flexiblas_hook_fn zlaqr0;
        struct flexiblas_hook_fn zlaqr1;
        struct flexiblas_hook_fn zlaqr2;
        struct flexiblas_hook_fn zlaqr3;
        struct flexiblas_hook_fn zlaqr4;
        struct flexiblas_hook_fn zlaqr5;
        struct flexiblas_hook_fn zlaqsb;
        struct flexiblas_hook_fn zlaqsp;
        struct flexiblas_hook_fn zlaqsy;
        struct flexiblas_hook_fn zlar1v;
        struct flexiblas_hook_fn zlar2v;
        struct flexiblas_hook_fn zlarcm;
        struct flexiblas_hook_fn zlarf;
        struct flexiblas_hook_fn zlarfb;
        struct flexiblas_hook_fn zlarfg;
        struct flexiblas_hook_fn zlarfgp;
        struct flexiblas_hook_fn zlarft;
        struct flexiblas_hook_fn zlarfx;
        struct flexiblas_hook_fn zlarfy;
        struct flexiblas_hook_fn zlargv;
        struct flexiblas_hook_fn zlarnv;
        struct flexiblas_hook_fn zlarrv;
        struct flexiblas_hook_fn zlartg;
        struct flexiblas_hook_fn zlartv;
        struct flexiblas_hook_fn zlarz;
        struct flexiblas_hook_fn zlarzb;
        struct flexiblas_hook_fn zlarzt;
        struct flexiblas_hook_fn zlascl;
        struct flexiblas_hook_fn zlaset;
        struct flexiblas_hook_fn zlasr;
        struct flexiblas_hook_fn zlassq;
        struct flexiblas_hook_fn zlaswlq;
        struct flexiblas_hook_fn zlaswp;
        struct flexiblas_hook_fn zlasyf;
        struct flexiblas_hook_fn zlasyf_aa;
        struct flexiblas_hook_fn zlasyf_rk;
        struct flexiblas_hook_fn zlasyf_rook;
        struct flexiblas_hook_fn zlat2c;
        struct flexiblas_hook_fn zlatbs;
        struct flexiblas_hook_fn zlatdf;
        struct flexiblas_hook_fn zlatps;
        struct flexiblas_hook_fn zlatrd;
        struct flexiblas_hook_fn zlatrs;
        struct flexiblas_hook_fn zlatrz;
        struct flexiblas_hook_fn zlatsqr;
        struct flexiblas_hook_fn zlatzm;
        struct flexiblas_hook_fn zlaunhr_col_getrfnp;
        struct flexiblas_hook_fn zlaunhr_col_getrfnp2;
        struct flexiblas_hook_fn zlauu2;
        struct flexiblas_hook_fn zlauum;
        struct flexiblas_hook_fn zpbcon;
        struct flexiblas_hook_fn zpbequ;
        struct flexiblas_hook_fn zpbrfs;
        struct flexiblas_hook_fn zpbstf;
        struct flexiblas_hook_fn zpbsv;
        struct flexiblas_hook_fn zpbsvx;
        struct flexiblas_hook_fn zpbtf2;
        struct flexiblas_hook_fn zpbtrf;
        struct flexiblas_hook_fn zpbtrs;
        struct flexiblas_hook_fn zpftrf;
        struct flexiblas_hook_fn zpftri;
        struct flexiblas_hook_fn zpftrs;
        struct flexiblas_hook_fn zpocon;
        struct flexiblas_hook_fn zpoequ;
        struct flexiblas_hook_fn zpoequb;
        struct flexiblas_hook_fn zporfs;
        struct flexiblas_hook_fn zposv;
        struct flexiblas_hook_fn zposvx;
        struct flexiblas_hook_fn zpotf2;
        struct flexiblas_hook_fn zpotrf;
        struct flexiblas_hook_fn zpotrf2;
        struct flexiblas_hook_fn zpotri;
        struct flexiblas_hook_fn zpotrs;
        struct flexiblas_hook_fn zppcon;
        struct flexiblas_hook_fn zppequ;
        struct flexiblas_hook_fn zpprfs;
        struct flexiblas_hook_fn zppsv;
        struct flexiblas_hook_fn zppsvx;
        struct flexiblas_hook_fn zpptrf;
        struct flexiblas_hook_fn zpptri;
        struct flexiblas_hook_fn zpptrs;
        struct flexiblas_hook_fn zpstf2;
        struct flexiblas_hook_fn zpstrf;
        struct flexiblas_hook_fn zptcon;
        struct flexiblas_hook_fn zpteqr;
        struct flexiblas_hook_fn zptrfs;
        struct flexiblas_hook_fn zptsv;
        struct flexiblas_hook_fn zptsvx;
        struct flexiblas_hook_fn zpttrf;
        struct flexiblas_hook_fn zpttrs;
        struct flexiblas_hook_fn zptts2;
        struct flexiblas_hook_fn zrot;
        struct flexiblas_hook_fn zspcon;
        struct flexiblas_hook_fn zspmv;
        struct flexiblas_hook_fn zspr;
        struct flexiblas_hook_fn zsprfs;
        struct flexiblas_hook_fn zspsv;
        struct flexiblas_hook_fn zspsvx;
        struct flexiblas_hook_fn zsptrf;
        struct flexiblas_hook_fn zsptri;
        struct flexiblas_hook_fn zsptrs;
        struct flexiblas_hook_fn zstedc;
        struct flexiblas_hook_fn zstegr;
        struct flexiblas_hook_fn zstein;
        struct flexiblas_hook_fn zstemr;
        struct flexiblas_hook_fn zsteqr;
        struct flexiblas_hook_fn zsycon;
        struct flexiblas_hook_fn zsycon_3;
        struct flexiblas_hook_fn zsycon_rook;
        struct flexiblas_hook_fn zsyconv;
        struct flexiblas_hook_fn zsyconvf;
        struct flexiblas_hook_fn zsyconvf_rook;
        struct flexiblas_hook_fn zsyequb;
        struct flexiblas_hook_fn zsymv;
        struct flexiblas_hook_fn zsyr;
        struct flexiblas_hook_fn zsyrfs;
        struct flexiblas_hook_fn zsysv;
        struct flexiblas_hook_fn zsysv_aa;
        struct flexiblas_hook_fn zsysv_aa_2stage;
        struct flexiblas_hook_fn zsysv_rk;
        struct flexiblas_hook_fn zsysv_rook;
        struct flexiblas_hook_fn zsysvx;
        struct flexiblas_hook_fn zsyswapr;
        struct flexiblas_hook_fn zsytf2;
        struct flexiblas_hook_fn zsytf2_rk;
        struct flexiblas_hook_fn zsytf2_rook;
        struct flexiblas_hook_fn zsytrf;
        struct flexiblas_hook_fn zsytrf_aa;
        struct flexiblas_hook_fn zsytrf_aa_2stage;
        struct flexiblas_hook_fn zsytrf_rk;
        struct flexiblas_hook_fn zsytrf_rook;
        struct flexiblas_hook_fn zsytri;
        struct flexiblas_hook_fn zsytri2;
        struct flexiblas_hook_fn zsytri2x;
        struct flexiblas_hook_fn zsytri_3;
        struct flexiblas_hook_fn zsytri_3x;
        struct flexiblas_hook_fn zsytri_rook;
        struct flexiblas_hook_fn zsytrs;
        struct flexiblas_hook_fn zsytrs2;
        struct flexiblas_hook_fn zsytrs_3;
        struct flexiblas_hook_fn zsytrs_aa;
        struct flexiblas_hook_fn zsytrs_aa_2stage;
        struct flexiblas_hook_fn zsytrs_rook;
        struct flexiblas_hook_fn ztbcon;
        struct flexiblas_hook_fn ztbrfs;
        struct flexiblas_hook_fn ztbtrs;
        struct flexiblas_hook_fn ztfsm;
        struct flexiblas_hook_fn ztftri;
        struct flexiblas_hook_fn ztfttp;
        struct flexiblas_hook_fn ztfttr;
        struct flexiblas_hook_fn ztgevc;
        struct flexiblas_hook_fn ztgex2;
        struct flexiblas_hook_fn ztgexc;
        struct flexiblas_hook_fn ztgsen;
        struct flexiblas_hook_fn ztgsja;
        struct flexiblas_hook_fn ztgsna;
        struct flexiblas_hook_fn ztgsy2;
        struct flexiblas_hook_fn ztgsyl;
        struct flexiblas_hook_fn ztpcon;
        struct flexiblas_hook_fn ztplqt;
        struct flexiblas_hook_fn ztplqt2;
        struct flexiblas_hook_fn ztpmlqt;
        struct flexiblas_hook_fn ztpmqrt;
        struct flexiblas_hook_fn ztpqrt;
        struct flexiblas_hook_fn ztpqrt2;
        struct flexiblas_hook_fn ztprfb;
        struct flexiblas_hook_fn ztprfs;
        struct flexiblas_hook_fn ztptri;
        struct flexiblas_hook_fn ztptrs;
        struct flexiblas_hook_fn ztpttf;
        struct flexiblas_hook_fn ztpttr;
        struct flexiblas_hook_fn ztrcon;
        struct flexiblas_hook_fn ztrevc;
        struct flexiblas_hook_fn ztrevc3;
        struct flexiblas_hook_fn ztrexc;
        struct flexiblas_hook_fn ztrrfs;
        struct flexiblas_hook_fn ztrsen;
        struct flexiblas_hook_fn ztrsna;
        struct flexiblas_hook_fn ztrsyl;
        struct flexiblas_hook_fn ztrti2;
        struct flexiblas_hook_fn ztrtri;
        struct flexiblas_hook_fn ztrtrs;
        struct flexiblas_hook_fn ztrttf;
        struct flexiblas_hook_fn ztrttp;
        struct flexiblas_hook_fn ztzrqf;
        struct flexiblas_hook_fn ztzrzf;
        struct flexiblas_hook_fn zunbdb;
        struct flexiblas_hook_fn zunbdb1;
        struct flexiblas_hook_fn zunbdb2;
        struct flexiblas_hook_fn zunbdb3;
        struct flexiblas_hook_fn zunbdb4;
        struct flexiblas_hook_fn zunbdb5;
        struct flexiblas_hook_fn zunbdb6;
        struct flexiblas_hook_fn zuncsd;
        struct flexiblas_hook_fn zuncsd2by1;
        struct flexiblas_hook_fn zung2l;
        struct flexiblas_hook_fn zung2r;
        struct flexiblas_hook_fn zungbr;
        struct flexiblas_hook_fn zunghr;
        struct flexiblas_hook_fn zungl2;
        struct flexiblas_hook_fn zunglq;
        struct flexiblas_hook_fn zungql;
        struct flexiblas_hook_fn zungqr;
        struct flexiblas_hook_fn zungr2;
        struct flexiblas_hook_fn zungrq;
        struct flexiblas_hook_fn zungtr;
        struct flexiblas_hook_fn zungtsqr;
        struct flexiblas_hook_fn zunhr_col;
        struct flexiblas_hook_fn zunm22;
        struct flexiblas_hook_fn zunm2l;
        struct flexiblas_hook_fn zunm2r;
        struct flexiblas_hook_fn zunmbr;
        struct flexiblas_hook_fn zunmhr;
        struct flexiblas_hook_fn zunml2;
        struct flexiblas_hook_fn zunmlq;
        struct flexiblas_hook_fn zunmql;
        struct flexiblas_hook_fn zunmqr;
        struct flexiblas_hook_fn zunmr2;
        struct flexiblas_hook_fn zunmr3;
        struct flexiblas_hook_fn zunmrq;
        struct flexiblas_hook_fn zunmrz;
        struct flexiblas_hook_fn zunmtr;
        struct flexiblas_hook_fn zupgtr;
        struct flexiblas_hook_fn zupmtr;

        /* LAPACK 3.9.1 */

        struct flexiblas_hook_fn cgetsqrhrt;
        struct flexiblas_hook_fn clarfb_gett;
        struct flexiblas_hook_fn cungtsqr_row;
        struct flexiblas_hook_fn dgetsqrhrt;
        struct flexiblas_hook_fn dlarfb_gett;
        struct flexiblas_hook_fn dorgtsqr_row;
        struct flexiblas_hook_fn sgetsqrhrt;
        struct flexiblas_hook_fn slarfb_gett;
        struct flexiblas_hook_fn sorgtsqr_row;
        struct flexiblas_hook_fn zgetsqrhrt;
        struct flexiblas_hook_fn zlarfb_gett;
        struct flexiblas_hook_fn zungtsqr_row;

        /* LAPACK 3.10.0 */
        struct flexiblas_hook_fn claqz0;
        struct flexiblas_hook_fn claqz1;
        struct flexiblas_hook_fn claqz2;
        struct flexiblas_hook_fn claqz3;
        struct flexiblas_hook_fn zlaqz0;
        struct flexiblas_hook_fn zlaqz1;
        struct flexiblas_hook_fn zlaqz2;
        struct flexiblas_hook_fn zlaqz3;
        struct flexiblas_hook_fn dlaqz0;
        struct flexiblas_hook_fn dlaqz1;
        struct flexiblas_hook_fn dlaqz2;
        struct flexiblas_hook_fn dlaqz3;
        struct flexiblas_hook_fn dlaqz4;
        struct flexiblas_hook_fn slaqz0;
        struct flexiblas_hook_fn slaqz1;
        struct flexiblas_hook_fn slaqz2;
        struct flexiblas_hook_fn slaqz3;
        struct flexiblas_hook_fn slaqz4;

        /* LAPACK 3.10.1 */
        struct flexiblas_hook_fn droundup_lwork;
        struct flexiblas_hook_fn sroundup_lwork;

        /* LAPACK 3.11.0 */
        struct flexiblas_hook_fn cgelst;
        struct flexiblas_hook_fn dgelst;
        struct flexiblas_hook_fn sgelst;
        struct flexiblas_hook_fn zgelst;
        struct flexiblas_hook_fn ctrsyl3;
        struct flexiblas_hook_fn dtrsyl3;
        struct flexiblas_hook_fn strsyl3;
        struct flexiblas_hook_fn ztrsyl3;
        struct flexiblas_hook_fn clatrs3;
        struct flexiblas_hook_fn dlatrs3;
        struct flexiblas_hook_fn slatrs3;
        struct flexiblas_hook_fn zlatrs3;
        struct flexiblas_hook_fn dlarmm;
        struct flexiblas_hook_fn slarmm;
        struct flexiblas_hook_fn clarmm;
        struct flexiblas_hook_fn zlarmm;

        /* LAPACK 3.12.0 */
        struct flexiblas_hook_fn cgedmd;
        struct flexiblas_hook_fn cgedmdq;
        struct flexiblas_hook_fn cgelqs;
        struct flexiblas_hook_fn cgeqp3rk;
        struct flexiblas_hook_fn cgeqrs;
        struct flexiblas_hook_fn claqp2rk;
        struct flexiblas_hook_fn claqp3rk;
        struct flexiblas_hook_fn crscl;
        struct flexiblas_hook_fn dgedmd;
        struct flexiblas_hook_fn dgedmdq;
        struct flexiblas_hook_fn dgelqs;
        struct flexiblas_hook_fn dgeqp3rk;
        struct flexiblas_hook_fn dgeqrs;
        struct flexiblas_hook_fn dlaqp2rk;
        struct flexiblas_hook_fn dlaqp3rk;
        struct flexiblas_hook_fn sgedmd;
        struct flexiblas_hook_fn sgedmdq;
        struct flexiblas_hook_fn sgelqs;
        struct flexiblas_hook_fn sgeqp3rk;
        struct flexiblas_hook_fn sgeqrs;
        struct flexiblas_hook_fn slaqp2rk;
        struct flexiblas_hook_fn slaqp3rk;
        struct flexiblas_hook_fn zgedmd;
        struct flexiblas_hook_fn zgedmdq;
        struct flexiblas_hook_fn zgelqs;
        struct flexiblas_hook_fn zgeqp3rk;
        struct flexiblas_hook_fn zgeqrs;
        struct flexiblas_hook_fn zlaqp2rk;
        struct flexiblas_hook_fn zlaqp3rk;
        struct flexiblas_hook_fn zrscl;

    } flexiblas_hook_t;


    typedef struct _flexiblas_backend_t {
        char* name;
        void* library_handle;
        int post_init;
        int hook_init;
        pthread_mutex_t post_init_mutex;
        flexiblas_info_t info;
        flexiblas_init_function_t init_function;
        flexiblas_exit_function_t exit_function;
        flexiblas_info_function_t info_function;
        flexiblas_set_num_threads_function_t set_num_threads_function[2];
        flexiblas_get_num_threads_function_t get_num_threads_function[2];
        flexiblas_get_num_procs_function_t   get_num_procs_function[2];
        flexiblas_blas_backend_t    blas;
        struct flexiblas_blasfn xerbla;
#ifdef FLEXIBLAS_LAPACK
        flexiblas_lapack_backend_t  lapack;
#endif
    } flexiblas_backend_t;

    // extern flexiblas_backend_t *current_backend;
#ifdef __cplusplus
}
#endif
#endif
