//    SPDX-License-Identifier: LGPL-3.0-or-later
/*
    This file is part of FlexiBLAS, a BLAS/LAPACK interface wrapper library.
    Copyright (C) 2013-2025 Martin Koehler

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU Lesser General Public
    License as published by the Free Software Foundation; either
    version 3 of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public License
    along with this program; if not, write to the Free Software Foundation,
    Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
*/






#include "cblas.h"
#include "cblas_f77.h"
#include "../flexiblas.h"
#include "cblas_flexiblas.h"

static TLS_STORE uint8_t hook_cblas_zscal_pos = 0;

void cblas_zscal( const CBLAS_INT N, const void *alpha, void *X,
        const CBLAS_INT incX)
{
    void (*fn)  ( const CBLAS_INT N, const void *alpha, void *X, const CBLAS_INT incX);

    CBLAS_BACKEND_INIT();
    CBLAS_HOOK_SELECT(zscal);

    fn(N,alpha,X,incX);


}

void flexiblas_chain_cblas_zscal( const CBLAS_INT N, const void *alpha, void *X,
        const CBLAS_INT incX)
{
    void (*fn)  ( const CBLAS_INT N, const void *alpha, void *X, const CBLAS_INT incX);

    CBLAS_HOOK_ADVANCE(zscal);

    fn(N,alpha,X,incX);



}

void flexiblas_real_cblas_zscal( const CBLAS_INT N, const void *alpha, void *X,
        const CBLAS_INT incX)
{
#ifdef F77_INT
    F77_INT F77_N=N, F77_incX=incX;
#else
#define F77_N N
#define F77_incX incX
#endif
    current_backend->blas.zscal.calls[POS_CBLAS] ++;

    if ( current_backend->blas.zscal.cblas_function != NULL ) {

        void (*fn)
            ( const CBLAS_INT N, const void *alpha, void *X,
              const CBLAS_INT incX);
        *(void **) &fn = current_backend->blas.zscal.cblas_function;
        fn(N,alpha,X,incX);
    } else {
        FC_GLOBAL(zscal,ZSCAL)( (blasint *)(uintptr_t)&F77_N, (void *)(uintptr_t) alpha, X, (blasint *)(uintptr_t)&F77_incX);
    }
}

