#ifndef _FPCOL_BASE_H
#define _FPCOL_BASE_H
/*******************************************************************************
* E.S.O. - VLT project
*
* "@(#) $Id: fpcolBase.h 75771 2002-12-21 21:55:25Z flamemgr $"
*
* who       when      what
* --------  --------  ----------------------------------------------
* tjf       98/06/00  created
* tjf       03/11/00  Allow for inclusion in a C++ file.
*/

/************************************************************************
 *
 * OzPoz Basic collision detection module header.
 *
 * NOTE: This include file is used by both the instrument software and
 * the configure software.  The Instrument software is written to VLT
 * software specifications.  The configure software is a standalone program
 * written using the AAO's DRAMA style.  This include file must be
 * compatible with both systems.
 *----------------------------------------------------------------------
 */
#ifdef __cplusplus
extern "C" {
#endif


extern int  fpcolBaseColButFib (
        void * clientData,
        double    butX,
        double    butY,
        double    theta ,
        double    fvpX,
        double    fvpY,
        double    pivX,
        double    pivY,
        long int  fibreClear,
        double    fibreClearSqrd);

extern int  fpcolBaseColButBut (
        void * clientData ,
        double    butXa,
        double    butYa,
        double    thetaa,
        double    butXb,
        double    butYb,
        double    thetab,
        long int  buttClear,
        double    buttClearSqrd);

extern int  fpcolBaseColFidBut (
        void * clientData ,
        long int  butx,
        long int  buty,
        double    theta,
        long int  markx,
        long int  marky,
        long int  fidClear,
        double    fidClearSqrd);

extern int  fpcolBaseColInvPos (
        void * clientData ,
        unsigned plate ,
	int       fibreType,
        long int  butx,
        long int  buty,
        double    theta,
        long int  tolerance,
        double    tolSqrd);

#ifdef __cplusplus
}
#endif

#endif /*!_H*/
