searchData={"items":[{"type":"module","title":"public_key","doc":"API module for public-key infrastructure.\n\nProvides functions to handle public-key infrastructure, for details see\n[public_key application](public_key_app.md).\n\n> #### Note {: .info }\n>\n> All records used in this Reference Manual are generated from ASN.1\n> specifications and are documented in the User's Guide. See\n> [Public-key Records](public_key_records.md).\n\nUse the following include directive to get access to the records and constant\nmacros described here and in the User's Guide:\n\n```text\n -include_lib(\"public_key/include/public_key.hrl\").\n```","ref":"public_key.html"},{"type":"function","title":"public_key.cacerts_clear/0","doc":"Clears any loaded CA certificates, returns true if any was loaded.","ref":"public_key.html#cacerts_clear/0"},{"type":"function","title":"public_key.cacerts_get/0","doc":"Returns the trusted CA certificates if any are loaded, otherwise uses\n`cacerts_load/0` to load them. The function fails if no `cacerts` could be\nloaded.","ref":"public_key.html#cacerts_get/0"},{"type":"function","title":"public_key.cacerts_load/0","doc":"Loads the OS supplied trusted CA certificates.\n\nThis can be overridden by setting the `cacerts_path`\nenvironment key of the `public_key` application with\nthe location of an alternative certificate.\nYou can set it via the command line as:\n\n    erl -public_key cacerts_path '\"/path/to/certs.pem\"'\n\nUse it with care. It is your responsibility to ensure\nthat the certificates found in this alternative path\ncan be trusted by the running system.","ref":"public_key.html#cacerts_load/0"},{"type":"function","title":"public_key.cacerts_load/1","doc":"Loads the trusted CA certificates from a file.","ref":"public_key.html#cacerts_load/1"},{"type":"function","title":"public_key.compute_key/2","doc":"Computes shared secret.","ref":"public_key.html#compute_key/2"},{"type":"function","title":"public_key.compute_key/3","doc":"Computes shared secret.","ref":"public_key.html#compute_key/3"},{"type":"function","title":"public_key.decrypt_private/2","doc":"","ref":"public_key.html#decrypt_private/2"},{"type":"function","title":"public_key.decrypt_private/3","doc":"Public-key decryption using the private key. See also `crypto:private_decrypt/4`\n\n> #### Warning {: .warning }\n>\n> This is a legacy function, for security reasons do not use with rsa_pkcs1_padding.","ref":"public_key.html#decrypt_private/3"},{"type":"function","title":"public_key.decrypt_public/2","doc":"","ref":"public_key.html#decrypt_public/2"},{"type":"function","title":"public_key.decrypt_public/3","doc":"Public-key decryption using the public key. See also `crypto:public_decrypt/4`\n\n> #### Warning {: .warning }\n>\n> This is a legacy function, for security reasons do not use  with rsa_pkcs1_padding.\n> For digital signatures the use of [`verify/4`](`verify/4`) together\n> with [`sign/3`](`sign/3`) is a prefered solution.","ref":"public_key.html#decrypt_public/3"},{"type":"function","title":"public_key.der_decode/2","doc":"Decodes a public-key ASN.1 DER encoded entity.","ref":"public_key.html#der_decode/2"},{"type":"function","title":"public_key.der_encode/2","doc":"Encodes a public-key entity with ASN.1 DER encoding.","ref":"public_key.html#der_encode/2"},{"type":"function","title":"public_key.dh_gex_group/4","doc":"Selects a group for Diffie-Hellman key exchange with the key size in the range\n`MinSize...MaxSize` and as close to `SuggestedSize` as possible. If\n`Groups == undefined` a default set will be used, otherwise the group is\nselected from `Groups`.\n\nFirst a size, as close as possible to SuggestedSize, is selected. Then one group\nwith that key size is randomly selected from the specified set of groups. If no\nsize within the limits of `MinSize` and `MaxSize` is available,\n`{error,no_group_found}` is returned.\n\nThe default set of groups is listed in `lib/public_key/priv/moduli`. This file\nmay be regenerated like this:\n\n```text\n\t$> cd $ERL_TOP/lib/public_key/priv/\n\t$> generate\n         ---- wait until all background jobs has finished. It may take several days !\n\t$> cat moduli-* > moduli\n\t$> cd ..; make\n```","ref":"public_key.html#dh_gex_group/4"},{"type":"function","title":"public_key.encrypt_private/2","doc":"","ref":"public_key.html#encrypt_private/2"},{"type":"function","title":"public_key.encrypt_private/3","doc":"Public-key encryption using the private key.\n\nSee also `crypto:private_encrypt/4`. The key, can besides a standard\nRSA key, be a map specifing the key algorithm `rsa` and a fun to\nhandle the encryption operation.  This may be used for customized the\nencryption operation with for instance hardware security modules (HSM)\nor trusted platform modules (TPM).\n\n> #### Warning {: .warning }\n>\n> This is a legacy function, for security reasons do not use with rsa_pkcs1_padding.\n> For digital signatures use of [`sign/3`](`sign/3`) together with [`verify/4`](`verify/4`)  is\n> the prefered solution.","ref":"public_key.html#encrypt_private/3"},{"type":"function","title":"public_key.encrypt_public/2","doc":"","ref":"public_key.html#encrypt_public/2"},{"type":"function","title":"public_key.encrypt_public/3","doc":"Public-key encryption using the public key. See also `crypto:public_encrypt/4`.\n\n> #### Warning {: .warning }\n>\n> This is a legacy function, for security reasons do not use with rsa_pkcs1_padding.","ref":"public_key.html#encrypt_public/3"},{"type":"function","title":"public_key.generate_key/1","doc":"Generates a new key pair. Note that except for Diffie-Hellman the public key is\nincluded in the private key structure. See also `crypto:generate_key/2`","ref":"public_key.html#generate_key/1"},{"type":"function","title":"public_key.pem_decode/1","doc":"Decodes PEM binary data and returns entries as ASN.1 DER encoded entities.\n\nExample\n`{ok, PemBin} = file:read_file(\"cert.pem\"). PemEntries = public_key:pem_decode(PemBin).`","ref":"public_key.html#pem_decode/1"},{"type":"function","title":"public_key.pem_encode/1","doc":"Creates a PEM binary.","ref":"public_key.html#pem_encode/1"},{"type":"function","title":"public_key.pem_entry_decode/1","doc":"","ref":"public_key.html#pem_entry_decode/1"},{"type":"function","title":"public_key.pem_entry_decode/2","doc":"Decodes a PEM entry. [`pem_decode/1`](`pem_decode/1`) returns a list of PEM\nentries. Notice that if the PEM entry is of type 'SubjectPublickeyInfo', it is\nfurther decoded to an `t:rsa_public_key/0` or `t:dsa_public_key/0`.\n\nPassword can be either an octet string or function which returns same type.","ref":"public_key.html#pem_entry_decode/2"},{"type":"function","title":"public_key.pem_entry_encode/2","doc":"","ref":"public_key.html#pem_entry_encode/2"},{"type":"function","title":"public_key.pem_entry_encode/3","doc":"Creates a PEM entry that can be feed to [`pem_encode/1`](`pem_encode/1`).\n\nIf `Asn1Type` is `'SubjectPublicKeyInfo'`, `Entity` must be either an\n`t:rsa_public_key/0`, `t:dsa_public_key/0` or an `t:ecdsa_public_key/0` and this\nfunction creates the appropriate `'SubjectPublicKeyInfo'` entry.","ref":"public_key.html#pem_entry_encode/3"},{"type":"function","title":"public_key.pkix_crl_issuer/1","doc":"Returns the issuer of the `CRL`.","ref":"public_key.html#pkix_crl_issuer/1"},{"type":"function","title":"public_key.pkix_crl_verify/2","doc":"Verify that `Cert` is the `CRL` signer.","ref":"public_key.html#pkix_crl_verify/2"},{"type":"function","title":"public_key.pkix_crls_validate/3","doc":"Performs CRL validation. It is intended to be called from the verify fun of\n[pkix_path_validation/3 ](`pkix_path_validation/3`).\n\nAvailable options:\n\n- **\\{update_crl, fun()\\}** - The fun has the following type specification:\n\n  ```erlang\n   fun(#'DistributionPoint'{}, #'CertificateList'{}) ->\n          #'CertificateList'{}\n  ```\n\n  The fun uses the information in the distribution point to access the latest\n  possible version of the CRL. If this fun is not specified, Public Key uses the\n  default implementation:\n\n  ```text\n   fun(_DP, CRL) -> CRL end\n  ```\n\n- **\\{issuer_fun, \\{fun(), UserState::term()\\}\\}** - The fun has the following type\n  specification:\n\n  ```erlang\n  fun(#'DistributionPoint'{}, #'CertificateList'{},\n      {rdnSequence,[#'AttributeTypeAndValue'{}]}, UserState::term()) ->\n  \t{ok, #'OTPCertificate'{}, [der_encoded]}\n  ```\n\n  The fun returns the root certificate and certificate chain that has signed the\n  CRL.\n\n  ```erlang\n   fun(DP, CRL, Issuer, UserState) -> {ok, RootCert, CertChain}\n  ```\n\n- **\\{undetermined_details, boolean()\\}** - Defaults to false. When revocation\n  status cannot be determined, and this option is set to true, details of why no\n  CRLs where accepted are included in the return value.","ref":"public_key.html#pkix_crls_validate/3"},{"type":"function","title":"public_key.pkix_decode_cert/2","doc":"Decodes an ASN.1 DER-encoded PKIX certificate.\n\nOption `otp` uses the customized ASN.1 specification OTP-PKIX.asn1 for\ndecoding and also recursively decode most of the standard parts.","ref":"public_key.html#pkix_decode_cert/2"},{"type":"function","title":"public_key.pkix_dist_point/1","doc":"Creates a distribution point for CRLs issued by the same issuer as `Cert`. Can\nbe used as input to `pkix_crls_validate/3`","ref":"public_key.html#pkix_dist_point/1"},{"type":"function","title":"public_key.pkix_dist_points/1","doc":"Extracts distribution points from the certificates extensions.","ref":"public_key.html#pkix_dist_points/1"},{"type":"function","title":"public_key.pkix_encode/3","doc":"DER encodes a PKIX x509 certificate or part of such a certificate.\n\nThis function must be used for encoding certificates or parts of\ncertificates that are decoded/created in the `otp` format, whereas for\nthe plain format this function directly calls\n[`der_encode/2`](`der_encode/2`).\n\n> #### Note {: .info }\n>\n> Subtle ASN-1 encoding errors in certificates may be worked around when\n> decoding, this may have the affect that the encoding a certificate back to DER\n> may generate different bytes then the supplied original.","ref":"public_key.html#pkix_encode/3"},{"type":"function","title":"public_key.pkix_hash_type/1","doc":"Translates OID to Erlang digest type","ref":"public_key.html#pkix_hash_type/1"},{"type":"function","title":"public_key.pkix_is_fixed_dh_cert/1","doc":"Checks if a certificate is a fixed Diffie-Hellman certificate.","ref":"public_key.html#pkix_is_fixed_dh_cert/1"},{"type":"function","title":"public_key.pkix_is_issuer/2","doc":"Checks if `IssuerCert` issued `Cert`.","ref":"public_key.html#pkix_is_issuer/2"},{"type":"function","title":"public_key.pkix_is_self_signed/1","doc":"Checks if a certificate is self-signed.","ref":"public_key.html#pkix_is_self_signed/1"},{"type":"function","title":"public_key.pkix_issuer_id/2","doc":"Returns the x509 certificate issuer id, if it can be determined.","ref":"public_key.html#pkix_issuer_id/2"},{"type":"function","title":"public_key.pkix_match_dist_point/2","doc":"Checks whether the given distribution point matches the Issuing Distribution\nPoint of the CRL, as described in RFC 5280.\n\nIf the CRL doesn't have an Issuing\nDistribution Point extension, the distribution point always matches.","ref":"public_key.html#pkix_match_dist_point/2"},{"type":"function","title":"public_key.pkix_normalize_name/1","doc":"Normalizes an issuer name so that it can be easily compared to another issuer\nname.","ref":"public_key.html#pkix_normalize_name/1"},{"type":"function","title":"public_key.pkix_ocsp_validate/5","doc":"Perform OCSP response validation according to RFC 6960. Returns {'ok', Details} when OCSP\nresponse is successfully validated and \\{error, \\{bad_cert, Reason\\}\\}\notherwise.\n\nAvailable options:\n\n- **\\{is_trusted_responder_fun, fun()\\}** - The fun has the following type\n  specification:\n\n  ```text\n   fun(#cert{}) ->\n  \t  boolean()\n  ```\n\n  The fun returns the `true` if certificate in the argument is trusted. If this\n  fun is not specified, Public Key uses the default implementation:\n\n  ```text\n   fun(_) -> false end\n  ```\n\n> #### Note {: .info }\n>\n> OCSP response can be provided without a nonce value - even if it was requested\n> by the client. In such cases {missing, ocsp_nonce} will be returned\n> in Details list.","ref":"public_key.html#pkix_ocsp_validate/5"},{"type":"function","title":"public_key.pkix_path_validation/3","doc":"Performs a basic path validation according to\n[RFC 5280.](http://www.ietf.org/rfc/rfc5280.txt)\n\nHowever, CRL validation is done separately by [pkix_crls_validate/3\n](`pkix_crls_validate/3`)and is to be called from the supplied\n`verify_fun`. The policy tree check was added in OTP-26.2 and if the\ncertificates include policies the constrained policy set with\npotential qualifiers will be returned, these values are derived from\nthe policy tree created as part of the path validation algorithm. The\nconstrained set can be constrained only by the Certificate Authorities\nor also by the user when the option `policy_set` is provided to this\nfunction. The qualifiers convey information about the valid policy and\nis intended as information to end users.\n\nAvailable options:\n\n- **\\{verify_fun, \\{fun(), UserState::term()\\}** - The fun must be\n  defined as:\n\n  ```erlang\n  fun(OtpCert :: #'OTPCertificate'{},\n      Event :: {bad_cert, Reason :: bad_cert_reason() | {revoked, atom()}} |\n               {extension, #'Extension'{}},\n      UserState :: term()) ->\n  \t{valid, UserState :: term()} |\n  \t{valid_peer, UserState :: term()} |\n  \t{fail, Reason :: term()} |\n  \t{unknown, UserState :: term()}.\n  ```\n\n  or as:\n\n  ```erlang\n  fun(OtpCert :: #'OTPCertificate'{},\n      DerCert :: der_encoded(),\n      Event :: {bad_cert, Reason :: bad_cert_reason() | {revoked, atom()}} |\n               {extension, #'Extension'{}},\n      UserState :: term()) ->\n\t{valid, UserState :: term()} |\n\t{valid_peer, UserState :: term()} |\n\t{fail, Reason :: term()} |\n\t{unknown, UserState :: term()}.\n  ```\n\n  The verify callback can have 3 or 4 arguments in case the DER encoded\n  version is needed by the callback.\n\n  If the verify callback fun returns `{fail, Reason}`, the verification process\n  is immediately stopped. If the verify callback fun returns\n  `{valid, UserState}`, the verification process is continued. This can be used\n  to accept specific path validation errors, such as `selfsigned_peer`, as well\n  as verifying application-specific extensions. If called with an extension\n  unknown to the user application, the return value `{unknown, UserState}` is to\n  be used.\n\n  > #### Note {: .note }\n  > If you need the DER encoded version of the certificate and have\n  > the OTP decoded version encoding it back can fail to give the correct result,\n  > due to work arounds for common misbehaving encoders. So it is recommended\n  > to call `pkix_path_validation` with `Cert` and `CertChain` arguments as\n  >  `der_encoded() | #cert{}` and `[der_encoded() | #cert{}]`. Also note\n  > that the path validation itself needs both the encoded and the\n  > decoded version of the certificate.\n\n  > #### Warning {: .warning }\n  >\n  > Note that user defined custom `verify_fun` may alter original path\n  > validation error (e.g `selfsigned_peer`). Use with caution.\n\n- **\\{max_path_length, integer()\\}** - The `max_path_length` is the maximum\n  number of non-self-issued intermediate certificates that can follow the peer\n  certificate in a valid certification path. So, if `max_path_length` is 0, the\n  PEER must be signed by the trusted ROOT-CA directly, if it is 1, the path can\n  be PEER, CA, ROOT-CA, if it is 2, the path can be PEER, CA, CA, ROOT-CA, and\n  so on.\n\n- **\\{policy_set, \\[oid()]\\}**(Since OTP 26.2)  \n  The set of policies that will be accepted, defaults to the special value\n  `[?anyPolicy]` that will accept all policies.\n\n- **\\{explicit_policy, boolean()\\}**(Since OTP 26.2)  \n  Explicitly require that each certificate in the path must include at least one\n  of the certificate policies in the `policy_set`.\n\n- **\\{inhibit_policy_mapping, boolean()\\}**(Since OTP 26.2)  \n  Prevent policies to be mapped to other policies.\n\n- **\\{inhibit_any_policy, boolean()\\}**(Since OTP 26.2)  \n  Prevent the special policy `?anyPolicy` from being accepted.\n\nExplanations of reasons for a bad certificate:\n\n- **cert_expired** - Certificate is no longer valid as its expiration date has\n  passed.\n\n- **invalid_issuer** - Certificate issuer name does not match the name of the\n  issuer certificate in the chain.\n\n- **invalid_signature** - Certificate was not signed by its issuer certificate\n  in the chain.\n\n- **name_not_permitted** - Invalid Subject Alternative Name extension.\n\n- **missing_basic_constraint** - Certificate, required to have the basic\n  constraints extension, does not have a basic constraints extension.\n\n- **invalid_key_usage** - Certificate key is used in an invalid way according to\n  the key-usage extension.\n\n- **\\{revoked, crl_reason()\\}** - Certificate has been revoked.\n\n- **invalid_validity_dates** - The validity section of the X.509 certificate(s)\n  contains invalid date formats not matching the RFC.\n\n- **atom()** - Application-specific error reason that is to be checked by the\n  `verify_fun`.","ref":"public_key.html#pkix_path_validation/3"},{"type":"function","title":"public_key.pkix_sign/2","doc":"Signs an 'OTPTBSCertificate'. Returns the corresponding DER-encoded certificate.","ref":"public_key.html#pkix_sign/2"},{"type":"function","title":"public_key.pkix_sign_types/1","doc":"Translates signature algorithm OID to Erlang digest and signature types.\n\nThe `AlgorithmId` is the signature OID from a certificate or a certificate\nrevocation list.","ref":"public_key.html#pkix_sign_types/1"},{"type":"function","title":"public_key.pkix_subject_id/1","doc":"Returns the X509 certificate subject id.","ref":"public_key.html#pkix_subject_id/1"},{"type":"function","title":"public_key.pkix_test_data/1","doc":"Creates certificate configuration(s) consisting of certificate and its private\nkey plus CA certificate bundle, for a client and a server, intended to\nfacilitate automated testing of applications using X509-certificates, often\nthrough SSL/TLS. The test data can be used when you have control over both the\nclient and the server in a test scenario.\n\nWhen this function is called with a map containing client and server chain\nspecifications; it generates both a client and a server certificate chain where\nthe `cacerts` returned for the server contains the root cert the server should\ntrust and the intermediate certificates the server should present to connecting\nclients. The root cert the server should trust is the one used as root of the\nclient certificate chain. Vice versa applies to the `cacerts` returned for the\nclient. The root cert(s) can either be pre-generated with\n[pkix_test_root_cert/2 ](`pkix_test_root_cert/2`), or if options are specified;\nit is (they are) generated.\n\nWhen this function is called with a list of certificate options; it generates a\nconfiguration with just one node certificate where `cacerts` contains the root\ncert and the intermediate certs that should be presented to a peer. In this case\nthe same root cert must be used for all peers. This is useful in for example an\nErlang distributed cluster where any node, towards another node, acts either as\na server or as a client depending on who connects to whom. The generated\ncertificate contains a subject altname, which is not needed in a client\ncertificate, but makes the certificate useful for both roles.\n\nExplanation of the options used to customize certificates in the generated\nchains:\n\n- **\\{digest, digest_type()\\}** - Hash algorithm to be used for signing the\n  certificate together with the key option. Defaults to sha that is sha1.\n\n- **\\{key,  ec_params()| {rsa, Size:pos_integer(), Prime::pos_integer()} | private_key()\\}** - Parameters to be used to call\n  public_key:generate_key/1, to generate a key, or an existing key. Defaults to\n  generating an ECDSA key. Note this could fail if Erlang/OTP is compiled with a\n  very old cryptolib.\n\n- **\\{validity, \\{From::erlang:timestamp(), To::erlang:timestamp()\\}\\}** - The\n  validity period of the certificate.\n\n- **\\{extensions, \\[#'Extension'\\{\\}]\\}** - Extensions to include in the\n  certificate.\n\n  Default extensions included in CA certificates if not otherwise specified are:\n\n  ```erlang\n  [#'Extension'{extnID = ?'id-ce-keyUsage',\n                extnValue = [keyCertSign, cRLSign],\n                critical = false},\n  #'Extension'{extnID = ?'id-ce-basicConstraints',\n               extnValue = #'BasicConstraints'{cA = true},\n               critical = true}]\n  ```\n\n  Default extensions included in the server peer cert if not otherwise specified\n  are:\n\n  ```erlang\n  [#'Extension'{extnID = ?'id-ce-keyUsage',\n                extnValue = [digitalSignature, keyAgreement],\n                critical = false},\n  #'Extension'{extnID = ?'id-ce-subjectAltName',\n               extnValue = [{dNSName, Hostname}],\n               critical = false}]\n  ```\n\n  Hostname is the result of calling net_adm:localhost() in the Erlang node where\n  this function is called.\n\n> #### Note {: .info }\n>\n> Note that the generated certificates and keys does not provide a formally\n> correct PKIX-trust-chain and they cannot be used to achieve real security.\n> This function is provided for testing purposes only.","ref":"public_key.html#pkix_test_data/1"},{"type":"function","title":"public_key.pkix_test_root_cert/2","doc":"Generates a root certificate that can be used in multiple calls to\n`pkix_test_data/1` when you want the same root certificate for several generated\ncertificates.","ref":"public_key.html#pkix_test_root_cert/2"},{"type":"function","title":"public_key.pkix_verify/2","doc":"Verifies PKIX x.509 certificate signature.","ref":"public_key.html#pkix_verify/2"},{"type":"function","title":"public_key.pkix_verify_hostname/2","doc":"","ref":"public_key.html#pkix_verify_hostname/2"},{"type":"function","title":"public_key.pkix_verify_hostname/3","doc":"This function checks that the _Presented Identifier_ (e.g hostname) in a peer\ncertificate is in agreement with at least one of the _Reference Identifier_ that\nthe client expects to be connected to.\n\nThe function is intended to be added as an extra client check of the\npeer certificate when performing\n[public_key:pkix_path_validation/3](`pkix_path_validation/3`)\n\nSee [RFC 6125](https://tools.ietf.org/html/rfc6125) for detailed information\nabout hostname verification. The\n[User's Guide](using_public_key.md#verify_hostname) and\n[code examples](using_public_key.md#verify_hostname_examples) describes this\nfunction more detailed.\n\nThe option funs are described here:\n\n- **`match_fun`**\n\n  ```erlang\n  fun(ReferenceId::ReferenceId() | FQDN::string(),\n      PresentedId::{dNSName,string()} | {uniformResourceIdentifier,string() |\n                   {iPAddress,list(byte())} | {OtherId::atom()|oid(),term()}})\n  ```\n\n  This function replaces the default host name matching rules. The fun should\n  return a boolean to tell if the Reference ID and Presented ID matches or not.\n  The match fun can also return a third value, value, the atom `default`, if the\n  default matching rules shall apply. This makes it possible to augment the\n  tests with a special case:\n\n  ```text\n  fun(....) -> true;   % My special case\n     (_, _) -> default % all others falls back to the inherit tests\n  end\n  ```\n\n  See `pkix_verify_hostname_match_fun/1` for a function that takes a protocol\n  name as argument and returns a `fun/2` suitable for this option and\n  [Re-defining the match operation](using_public_key.md#redefining_match_op) in\n  the User's Guide for an example.\n\n  > #### Note {: .info }\n  >\n  > Reference Id values given as binaries will be converted to strings, and ip\n  > references may be given in string format that is \"10.0.1.1\" or\n  > \"1234::5678:9012\" as well as on the format `t:inet:ip_address/0`\n\n- **`fail_callback`** - If a matching fails, there could be circumstances when\n  the certificate should be accepted anyway. Think for example of a web browser\n  where you choose to accept an outdated certificate. This option enables\n  implementation of such an exception but for hostnames. This `fun/1` is called\n  when no `ReferenceID` matches. The return value of the fun (a `t:boolean/0`)\n  decides the outcome. If `true` the the certificate is accepted otherwise it is\n  rejected. See\n  [\"Pinning\" a Certificate](using_public_key.md#pinning-a-certificate) in the\n  User's Guide.\n\n- **`fqdn_fun`** - This option augments the host name extraction from URIs and\n  other Reference IDs. It could for example be a very special URI that is not\n  standardised. The fun takes a Reference ID as argument and returns one of:\n\n  - the hostname\n  - the atom `default`: the default host name extract function will be used\n  - the atom `undefined`: a host name could not be extracted. The\n    pkix_verify_hostname/3 will return `false`.\n\n  For an example, see\n  [Hostname extraction](using_public_key.md#hostname_extraction) in the User's\n  Guide.","ref":"public_key.html#pkix_verify_hostname/3"},{"type":"function","title":"public_key.pkix_verify_hostname_match_fun/1","doc":"The return value of calling this function is intended to be used in the\n`match_fun` option in `pkix_verify_hostname/3`.\n\nThe returned fun augments the verify hostname matching according to the specific\nrules for the protocol in the argument.\n\n> #### Note {: .info }\n>\n> Currently supported https fun will allow wildcard certificate matching as\n> specified by the HTTP standard. Note that for instance LDAP have a different\n> set of wildcard matching rules. If you do not want to allow wildcard\n> certificates (recommended from a security perspective) or otherwise customize\n> the hostname match the default match function used by ssl application will be\n> sufficient.","ref":"public_key.html#pkix_verify_hostname_match_fun/1"},{"type":"function","title":"public_key.short_name_hash/1","doc":"Generates a short hash of an issuer name. The hash is returned as a string\ncontaining eight hexadecimal digits.\n\nThe return value of this function is the same as the result of the commands\n`openssl crl -hash` and `openssl x509 -issuer_hash`, when passed the issuer name\nof a CRL or a certificate, respectively. This hash is used by the `c_rehash`\ntool to maintain a directory of symlinks to CRL files, in order to facilitate\nlooking up a CRL by its issuer name.","ref":"public_key.html#short_name_hash/1"},{"type":"function","title":"public_key.sign/3","doc":"","ref":"public_key.html#sign/3"},{"type":"function","title":"public_key.sign/4","doc":"Creates a digital signature.\n\nThe `Msg` is either the binary \"plain text\" data to be signed or it is the\nhashed value of \"plain text\", that is, the digest. The key, can besides a\nstandard key, be a map specifing a key algorithm and a fun that should handle\nthe signing. This may be used for customized signing with for instance hardware\nsecurity modules (HSM) or trusted platform modules (TPM).","ref":"public_key.html#sign/4"},{"type":"function","title":"public_key.verify/4","doc":"","ref":"public_key.html#verify/4"},{"type":"function","title":"public_key.verify/5","doc":"Verifies a digital signature.\n\nThe `Msg` is either the binary \"plain text\" data or it is the hashed value of\n\"plain text\", that is, the digest.","ref":"public_key.html#verify/5"},{"type":"type","title":"public_key.asn1_type/0","doc":"ASN.1 type present in the Public Key applications ASN.1 specifications.","ref":"public_key.html#t:asn1_type/0"},{"type":"type","title":"public_key.bad_cert_reason/0","doc":"The reason that a certifcate gets rejected by the certificate path validation.","ref":"public_key.html#t:bad_cert_reason/0"},{"type":"type","title":"public_key.cert/0","doc":"An encoded or decode certificate.","ref":"public_key.html#t:cert/0"},{"type":"type","title":"public_key.cert_id/0","doc":"A certificate is identified by its serial-number and Issuer Name.","ref":"public_key.html#t:cert_id/0"},{"type":"type","title":"public_key.cert_opt/0","doc":"Options to customize generated test certificates","ref":"public_key.html#t:cert_opt/0"},{"type":"type","title":"public_key.chain_opts/0","doc":"Certificate customize options for diffrent parts of the certificate test chain.","ref":"public_key.html#t:chain_opts/0"},{"type":"type","title":"public_key.combined_cert/0","doc":"A record that can be used to provide the certificate on both the DER encoded and the OTP decode format.\n\nSuch a construct can be useful to avoid conversions and problems that can arise due to relaxed decoding rules.","ref":"public_key.html#t:combined_cert/0"},{"type":"type","title":"public_key.conf_opt/0","doc":"Configuration options for the generated certificate test chain.","ref":"public_key.html#t:conf_opt/0"},{"type":"type","title":"public_key.crl_reason/0","doc":"The reason that a certifcate has been revoked as define by RFC 5280.","ref":"public_key.html#t:crl_reason/0"},{"type":"type","title":"public_key.custom_key_opts/0","doc":"Can be provided together with a custom private key, that specifies a key fun, to\nprovide additional options understood by the fun.","ref":"public_key.html#t:custom_key_opts/0"},{"type":"type","title":"public_key.der_encoded/0","doc":"ASN.1 DER encoded entity.","ref":"public_key.html#t:der_encoded/0"},{"type":"type","title":"public_key.digest_type/0","doc":"Hash function used to create a message digest","ref":"public_key.html#t:digest_type/0"},{"type":"type","title":"public_key.dsa_private_key/0","doc":"ASN.1 defined private key format for the DSA algorithm.","ref":"public_key.html#t:dsa_private_key/0"},{"type":"type","title":"public_key.dsa_public_key/0","doc":"ASN.1 defined public key format for the DSA algorithm.","ref":"public_key.html#t:dsa_public_key/0"},{"type":"type","title":"public_key.dss_public_key/0","doc":"ASN.1 defined public key format for the DSS algorithm (part of DSA key).","ref":"public_key.html#t:dss_public_key/0"},{"type":"type","title":"public_key.ecdsa_private_key/0","doc":"ASN.1 defined private key format for the ECDSA algorithm.","ref":"public_key.html#t:ecdsa_private_key/0"},{"type":"type","title":"public_key.ecdsa_public_key/0","doc":"ASN.1 defined public key format for the ECDSA algorithm.","ref":"public_key.html#t:ecdsa_public_key/0"},{"type":"type","title":"public_key.eddsa_private_key/0","doc":"ASN.1 defined private key format for the EDDSA algorithm, possible oids: ?'id-Ed25519' | ?'id-Ed448'","ref":"public_key.html#t:eddsa_private_key/0"},{"type":"type","title":"public_key.eddsa_public_key/0","doc":"ASN.1 defined public key format for the EDDSA algorithm, possible oids: ?'id-Ed25519' | ?'id-Ed448'","ref":"public_key.html#t:eddsa_public_key/0"},{"type":"type","title":"public_key.issuer_name/0","doc":"The value of the issuer part of a certificate.","ref":"public_key.html#t:issuer_name/0"},{"type":"type","title":"public_key.key_params/0","doc":"ASN.1 defined parameters for public key algorithms.","ref":"public_key.html#t:key_params/0"},{"type":"type","title":"public_key.oid/0","doc":"Object identifier, a tuple of integers as generated by the `ASN.1` compiler.","ref":"public_key.html#t:oid/0"},{"type":"type","title":"public_key.pem_entry/0","doc":"Possible `Ciphers` are \"RC2-CBC\" | \"DES-CBC\" | \"DES-EDE3-CBC\" `Salt` could be generated with\n[`crypto:strong_rand_bytes(8)`](`crypto:strong_rand_bytes/1`).","ref":"public_key.html#t:pem_entry/0"},{"type":"type","title":"public_key.pki_asn1_type/0","doc":"ASN.1 type that can be found in PEM files that can be decode by the public_key application.","ref":"public_key.html#t:pki_asn1_type/0"},{"type":"type","title":"public_key.policy_node/0","doc":"Certificate policy information.","ref":"public_key.html#t:policy_node/0"},{"type":"type","title":"public_key.private_key/0","doc":"Supported private keys","ref":"public_key.html#t:private_key/0"},{"type":"type","title":"public_key.public_key/0","doc":"Supported public keys","ref":"public_key.html#t:public_key/0"},{"type":"type","title":"public_key.public_key_info/0","doc":"Information a certificates public key.\n\nPossible oids: ?'rsaEncryption' | ?'id-RSASSA-PSS' | ?'id-ecPublicKey' | ?'id-Ed25519' | ?'id-Ed448' | ?'id-dsa'","ref":"public_key.html#t:public_key_info/0"},{"type":"type","title":"public_key.rsa_private_key/0","doc":"ASN.1 defined private key format plain RSA algorithm or customization fun.","ref":"public_key.html#t:rsa_private_key/0"},{"type":"type","title":"public_key.rsa_pss_private_key/0","doc":"ASN.1 defined private key format the RSSASSA-PSS algorithm or customization fun.","ref":"public_key.html#t:rsa_pss_private_key/0"},{"type":"type","title":"public_key.rsa_pss_public_key/0","doc":"ASN.1 defined public key format for the RSSASSA-PSS algorithm.","ref":"public_key.html#t:rsa_pss_public_key/0"},{"type":"type","title":"public_key.rsa_public_key/0","doc":"ASN.1 defined public key format for plain RSA algorithm.","ref":"public_key.html#t:rsa_public_key/0"},{"type":"extras","title":"Public_Key Application","doc":"<!--\n%CopyrightBegin%\n\nCopyright Ericsson AB 2023-2024. All Rights Reserved.\n\nLicensed under the Apache License, Version 2.0 (the \"License\");\nyou may not use this file except in compliance with the License.\nYou may obtain a copy of the License at\n\n    http://www.apache.org/licenses/LICENSE-2.0\n\nUnless required by applicable law or agreed to in writing, software\ndistributed under the License is distributed on an \"AS IS\" BASIS,\nWITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\nSee the License for the specific language governing permissions and\nlimitations under the License.\n\n%CopyrightEnd%\n-->\n# Public_Key Application\n\nThe Public Key application deals with public-key related file formats,\ndigital signatures, and [X-509\ncertificates](http://www.ietf.org/rfc/rfc5280.txt).  It handles\nvalidation of certificate paths and certificate revocation lists\n(CRLs) and other functions for handling of certificates, keys and\nCRLs. It is a library application that does not read or write files,\nit expects or returns file contents or partial file contents as\nbinaries. Except for the functions `public-key:cacerts_load/0`,\n`public-key:cacerts_load/1`, and `public-key:cacerts_get/0`\nthat reads files.","ref":"public_key_app.html"},{"type":"extras","title":"Supported PKIX functionality - Public_Key Application","doc":"- Supports [RFC 5280 ](http://www.ietf.org/rfc/rfc5280.txt)\\- Internet X.509\n  Public-Key Infrastructure Certificate and Certificate Revocation List (CRL)\n  Profile. Certificate policies supported since OTP-26.2\n- Supports [PKCS-1 ](http://www.ietf.org/rfc/rfc3447.txt)\\- RSA Cryptography\n  Standard\n- Supports\n  [DSS](http://csrc.nist.gov/publications/fips/fips186-3/fips_186-3.pdf) \\-\n  Digital Signature Standard (DSA - Digital Signature Algorithm)\n- Supports\n  [PKCS-3 ](https://web.archive.org/web/20170417091930/https://www.emc.com/emc-plus/rsa-labs/standards-initiatives/pkcs-3-diffie-hellman-key-agreement-standar.htm)\\-\n  Diffie-Hellman Key Agreement Standard\n- Supports [PKCS-5](http://www.ietf.org/rfc/rfc2898.txt) \\- Password-Based\n  Cryptography Standard\n- Supports [AES ](http://www.ietf.org/rfc/fc3565.txt)\\- Use of the Advanced\n  Encryption Standard (AES) Algorithm in Cryptographic Message Syntax (CMS)\n- Supports [PKCS-8](http://www.ietf.org/rfc/rfc5208.txt) \\- Private-Key\n  Information Syntax Standard\n- Supports [PKCS-10](http://www.ietf.org/rfc/rfc5967.txt) \\- Certification\n  Request Syntax Standard","ref":"public_key_app.html#supported-pkix-functionality"},{"type":"extras","title":"Dependencies - Public_Key Application","doc":"The `public_key` application uses the Crypto application to perform\ncryptographic operations and the ASN-1 application to handle PKIX-ASN-1\nspecifications, hence these applications must be loaded for the `public_key`\napplication to work. In an embedded environment this means they must be started\nwith `application:start/[1,2]` before the `public_key` application is started.","ref":"public_key_app.html#dependencies"},{"type":"extras","title":"Error Logger and Event Handlers - Public_Key Application","doc":"The `public_key` application is a library application and does not use the error\nlogger. The functions will either succeed or fail with a runtime error.","ref":"public_key_app.html#error-logger-and-event-handlers"},{"type":"extras","title":"See Also - Public_Key Application","doc":"`m:application`","ref":"public_key_app.html#see-also"},{"type":"extras","title":"Public_Key Release Notes","doc":"<!--\n%CopyrightBegin%\n\nCopyright Ericsson AB 2023-2024. All Rights Reserved.\n\nLicensed under the Apache License, Version 2.0 (the \"License\");\nyou may not use this file except in compliance with the License.\nYou may obtain a copy of the License at\n\n    http://www.apache.org/licenses/LICENSE-2.0\n\nUnless required by applicable law or agreed to in writing, software\ndistributed under the License is distributed on an \"AS IS\" BASIS,\nWITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\nSee the License for the specific language governing permissions and\nlimitations under the License.\n\n%CopyrightEnd%\n-->\n# Public_Key Release Notes","ref":"notes.html"},{"type":"extras","title":"Public_Key 1.17 - Public_Key Release Notes","doc":"","ref":"notes.html#public_key-1-17"},{"type":"extras","title":"Improvements and New Features - Public_Key Release Notes","doc":"- `public_key:cacerts_load/1` can now be configured via the application environment.\n\n  Own Id: OTP-19321 Aux Id: [PR-8920]\n\n- On MacOS, CA certificates are now also loaded from the system keychain.\n\n  Own Id: OTP-19375 Aux Id: [PR-8844]\n\n[PR-8920]: https://github.com/erlang/otp/pull/8920\n[PR-8844]: https://github.com/erlang/otp/pull/8844","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Public_Key 1.16.4 - Public_Key Release Notes","doc":"","ref":"notes.html#public_key-1-16-4"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Public_Key Release Notes","doc":"- If both `ext-key-usage` and `key-usage` are defined for a certificate it should be checked that these usages are consistent with each other. This will have the affect that such certificates where the `ext-key-usages` is marked as critical and the usages is consistent with the `key-use` it can be considered valid without mandatory application specific checks for the `ext-key-useage` extension.\n\n  Own Id: OTP-19240 Aux Id: [PR-8840], OTP-19532\n\n- Handle decoding of EDDSA key properly, when decoding a PEM file that contains only the public EDDSA key.\n\n  Own Id: OTP-19350 Aux Id: [GH-9009], [PR-9053]\n\n[PR-8840]: https://github.com/erlang/otp/pull/8840\n[GH-9009]: https://github.com/erlang/otp/issues/9009\n[PR-9053]: https://github.com/erlang/otp/pull/9053","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Public_Key 1.16.3 - Public_Key Release Notes","doc":"","ref":"notes.html#public_key-1-16-3"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Public_Key Release Notes","doc":"- Introduction of verify_fun/4 unfortunately introduced an argument switch for some specific path validation errors so that verify_fun/3 could under these circumstances be called with a DER cert instead of a decod cert, also in this situation the verify_fun/4 would have the certificates in reverse order.\n\n  Own Id: OTP-19245 Aux Id: Gh-8832","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Improvements and New Features - Public_Key Release Notes","doc":"- Do not hide crypto badarg reason, this error handling enhancement facilitates debugging. These kind of runtime errors are not documented and should never be relied on for matching, they are intended for catching input errors early.\n\n  Own Id: OTP-19238","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Public_Key 1.16.2 - Public_Key Release Notes","doc":"","ref":"notes.html#public_key-1-16-2"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Public_Key Release Notes","doc":"- For completeness handle rsa_pss implicit default value, although this will probably not be commonly used as it provides very weak security.\n\n  Own Id: OTP-19179\n\n- The `public_key:cacerts_load()` function could in some error cases return `undefined` instead of `{error, Reason}`.\n\n  Own Id: OTP-19183 Aux Id: [GH-8604]\n\n- Added support for DragonFly.\n\n  Own Id: OTP-19191 Aux Id: [PR-8703]\n\n[GH-8604]: https://github.com/erlang/otp/issues/8604\n[PR-8703]: https://github.com/erlang/otp/pull/8703","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Improvements and New Features - Public_Key Release Notes","doc":"- Deprecation of RSA encryption functions has been reverted, as there still exists legitimate use cases with other padding modes than PKCS-1.\n  \n  While use PCKS-1 padding with some versions of cryptolib could be considered secure, we still recommend using other algorithms that are less sensitive to oracle attacks.\n\n  Own Id: OTP-19163\n\n- It is now possible to use a verification fun of arity 4, giving the user fun access to both encoded and decoded versions of the certificate. This is desirable as a workaround for encoding errors preventing re-encoding from being reliable. This also saves some work load if the encoded version is needed.\n  \n  Note that calling `public_key:pkix_path_validation/3` with only decoded certs is not recommended, due to the decoding workarounds, although it will work as long as the workarounds are not needed.\n  \n  If the decoded version is needed before thecall to `m:public_key` it is recommend to use the combined_cert- type to avoid double decoding.  Note that the path validation algorithm itself always needs both the encoded and decoded versions of the certs.\n  \n  The ssl implementation will now benefit from using this function instead of emulating the verify_fun/4.\n\n  Own Id: OTP-19169","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Public_Key 1.16.1 - Public_Key Release Notes","doc":"","ref":"notes.html#public_key-1-16-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Public_Key Release Notes","doc":"- Fix bug in dnsName constraint check, could cause valid cert to be considered bad\n  during path validation.\n\n  Own Id: OTP-19100 Aux Id: [GH-8482], [PR-8508]\n\n[GH-8482]: https://github.com/erlang/otp/issues/8482\n[PR-8508]: https://github.com/erlang/otp/pull/8508","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Public_Key 1.16 - Public_Key Release Notes","doc":"","ref":"notes.html#public_key-1-16"},{"type":"extras","title":"Improvements and New Features - Public_Key Release Notes","doc":"- The `ssl` client can negotiate and handle certificate status request (OCSP stapling support on the client side).\n  \n  Thanks to voltone for interop testing and related discussions.\n\n  Own Id: OTP-18606 Aux Id: OTP-16875,OTP-16448\n\n- The exception reason when `public_key:cacerts_get/0` failed has been improved.\n\n  Own Id: OTP-18609 Aux Id: [GH-7295], [PR-7302]\n\n- Key customization support has been extended to allow flexibility for implementers of  for instance hardware security modules (HSM) or trusted platform modules (TPM).\n\n  Own Id: OTP-18876 Aux Id: [PR-7898], [PR-7475]\n\n- The documentation has been migrated to use Markdown and ExDoc.\n\n  Own Id: OTP-18955 Aux Id: [PR-8026]\n\n- The existing function `ssl:key_exporter_materials/4` is now documented and supported.\n\n  *** POTENTIAL INCOMPATIBILITY ***\n\n  Own Id: OTP-19016 Aux Id: [PR-8233]\n\n- Due to another attack on PKCS #1 v1.5 padding, known as the Marvin attack, about which we were alerted by Hubert Kario from Red Hat. You can find more details about the attack at\n  https://people.redhat.com/~hkario/marvin/\n  Functions that may be vulnerable are now deprecated. \n  \n  Note that you might mitigate the problem \n  by using appropriate versions of OpenSSL together with our software, but we recommend not using them at all. \n  \n  Also avoid using TLS versions prior to TLS-1.2 (not supported by default) and\n  do not enable RSA-key exchange cipher suites (not supported by default).\n\n  *** POTENTIAL INCOMPATIBILITY ***\n\n  Own Id: OTP-19075\n\n[GH-7295]: https://github.com/erlang/otp/issues/7295\n[PR-7302]: https://github.com/erlang/otp/pull/7302\n[PR-7898]: https://github.com/erlang/otp/pull/7898\n[PR-7475]: https://github.com/erlang/otp/pull/7475\n[PR-8026]: https://github.com/erlang/otp/pull/8026\n[PR-8233]: https://github.com/erlang/otp/pull/8233","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Public_Key 1.15.1.4 - Public_Key Release Notes","doc":"","ref":"notes.html#public_key-1-15-1-4"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Public_Key Release Notes","doc":"* If both `ext-key-usage` and `key-usage` are defined for a certificate it should be checked that these usages are consistent with each other. This will have the affect that such certificates where the `ext-key-usages` is marked as critical and the usages is consistent with the `key-use` it can be considered valid without mandatory application specific checks for the `ext-key-useage` extension.\n\n  Own Id: OTP-19240 Aux Id: PR-8840, OTP-19532\n* Handle decoding of EDDSA key properly, when decoding a PEM file that contains only the public EDDSA key.\n\n  Own Id: OTP-19350 Aux Id: GH-9009, PR-9053","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Public_Key 1.15.1.3 - Public_Key Release Notes","doc":"","ref":"notes.html#public_key-1-15-1-3"},{"type":"extras","title":"Improvements and New Features - Public_Key Release Notes","doc":"* Do not hide crypto badarg reason, this error handling enhancement facilitates debugging. These kind of runtime errors are not documented and should never be relied on for matching, they are intended for catching input errors early.\n\n  Own Id: OTP-19238 Aux Id: PR-8831","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Public_Key 1.15.1.2 - Public_Key Release Notes","doc":"","ref":"notes.html#public_key-1-15-1-2"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Public_Key Release Notes","doc":"* For completeness handle rsa_pss implicit default value, although this will probably not be commonly used as it provides very weak security.\n\n  Own Id: OTP-19179","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Public_Key 1.15.1.1 - Public_Key Release Notes","doc":"","ref":"notes.html#public_key-1-15-1-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Public_Key Release Notes","doc":"* Fix bug in dnsName constraint check, could cause valid cert to be considered bad during path validation.\n\n  Own Id: OTP-19100 Aux Id: GH-8482, PR-8508","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Public_Key 1.15.1 - Public_Key Release Notes","doc":"","ref":"notes.html#public_key-1-15-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Public_Key Release Notes","doc":"* Hostname prefix with X number of dots should not be accepted.\n\n  Own Id: OTP-18935 Aux Id: GH-8021","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Public_Key 1.15 - Public_Key Release Notes","doc":"","ref":"notes.html#public_key-1-15"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Public_Key Release Notes","doc":"- ssl application will validate id-kp-serverAuth and id-kp-clientAuth extended\n  key usage only in end entity certificates. public_key application will\n  disallow \"anyExtendedKeyUsage\" for CA certificates that includes the extended\n  key usage extension and marks it critical.\n\n  Own Id: OTP-18739\n\n- Modernize ECC handling so that crypto FIPS support works as expected.\n\n  Own Id: OTP-18854","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Improvements and New Features - Public_Key Release Notes","doc":"- Support certificate policies in path_validation - as described by RFC 5280.\n\n  Own Id: OTP-17844 Aux Id: ERIERL-738\n\n- Add more search paths for cacerts on Illumos.\n\n  Own Id: OTP-18814 Aux Id: PR-7435\n\n- Make it possible to handle invalid date formats in the verify_fun for\n  pkix_path_validation/3\n\n  Own Id: OTP-18867 Aux Id: GH-7515","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Public_Key 1.14.1 - Public_Key Release Notes","doc":"","ref":"notes.html#public_key-1-14-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Public_Key Release Notes","doc":"- Country name comparison shall be case insensitive\n\n  Own Id: OTP-18718 Aux Id: GH-7546\n\n- Add check to disallow duplicate certs in a path\n\n  Own Id: OTP-18723 Aux Id: GH-6394","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Public_Key 1.14 - Public_Key Release Notes","doc":"","ref":"notes.html#public_key-1-14"},{"type":"extras","title":"Improvements and New Features - Public_Key Release Notes","doc":"- Handling of `on_load` modules during boot has been improved by adding an extra\n  step in the boot order for embedded mode that runs all `on_load` handlers,\n  instead of relying on explicit invocation of them, later, when the kernel\n  supervision tree starts.\n\n  This is mostly a code improvement and OTP internal simplification to avoid\n  future bugs and to simplify code maintenance.\n\n  Own Id: OTP-18447","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Public_Key 1.13.3.5 - Public_Key Release Notes","doc":"","ref":"notes.html#public_key-1-13-3-5"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Public_Key Release Notes","doc":"* If both `ext-key-usage` and `key-usage` are defined for a certificate it should be checked that these usages are consistent with each other. This will have the affect that such certificates where the `ext-key-usages` is marked as critical and the usages is consistent with the `key-use` it can be considered valid without mandatory application specific checks for the `ext-key-useage` extension.\n\n  Own Id: OTP-19240 Aux Id: PR-8840, OTP-19532\n* Handle decoding of EDDSA key properly, when decoding a PEM file that contains only the public EDDSA key.\n\n  Own Id: OTP-19350 Aux Id: GH-9009, PR-9053","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Public_Key 1.13.3.4 - Public_Key Release Notes","doc":"","ref":"notes.html#public_key-1-13-3-4"},{"type":"extras","title":"Improvements and New Features - Public_Key Release Notes","doc":"* Do not hide crypto badarg reason, this error handling enhancement facilitates debugging. These kind of runtime errors are not documented and should never be relied on for matching, they are intended for catching input errors early.\n\n  Own Id: OTP-19238 Aux Id: PR-8831","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Public_Key 1.13.3.3 - Public_Key Release Notes","doc":"","ref":"notes.html#public_key-1-13-3-3"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Public_Key Release Notes","doc":"* For completeness handle rsa_pss implicit default value, although this will probably not be commonly used as it provides very weak security.\n\n  Own Id: OTP-19179","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Public_Key 1.13.3.2 - Public_Key Release Notes","doc":"","ref":"notes.html#public_key-1-13-3-2"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Public_Key Release Notes","doc":"- ssl application will validate id-kp-serverAuth and id-kp-clientAuth extended\n  key usage only in end entity certificates. public_key application will\n  disallow \"anyExtendedKeyUsage\" for CA certificates that includes the extended\n  key usage extension and marks it critical.\n\n  Own Id: OTP-18739","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Public_Key 1.13.3.1 - Public_Key Release Notes","doc":"","ref":"notes.html#public_key-1-13-3-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Public_Key Release Notes","doc":"- Country name comparison shall be case insensitive\n\n  Own Id: OTP-18718 Aux Id: GH-7546","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Public_Key 1.13.3 - Public_Key Release Notes","doc":"","ref":"notes.html#public_key-1-13-3"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Public_Key Release Notes","doc":"- As different solutions of verifying certificate revocation exists move the\n  decode of 'CRLDistributionPoints' so that it will only be decode. When it is\n  actually used in the verification process. This would enable interoperability\n  with systems that use certificates with an invalid empty CRLDistributionPoints\n  extension that they want to ignore and make verification by other means.\n\n  Own Id: OTP-18316 Aux Id: GH-6402, PR-6883\n\n- public_key:pkix_path_validation validates certificates expiring after 2050\n\n  Own Id: OTP-18356 Aux Id: GH-6403\n\n- Do not leave exit message in message queue after calling `cacerts_load()` on\n  MacOS.\n\n  Own Id: OTP-18392 Aux Id: GH-6656","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Improvements and New Features - Public_Key Release Notes","doc":"- Replace size/1 with either tuple_size/1 or byte_size/1\n\n  The [`size/1`](`size/1`) BIF is not optimized by the JIT, and its use can\n  result in worse types for Dialyzer.\n\n  When one knows that the value being tested must be a tuple,\n  [`tuple_size/1`](`tuple_size/1`) should always be preferred.\n\n  When one knows that the value being tested must be a binary,\n  [`byte_size/1`](`byte_size/1`) should be preferred. However,\n  [`byte_size/1`](`byte_size/1`) also accepts a bitstring (rounding up size to a\n  whole number of bytes), so one must make sure that the call to `byte_size/` is\n  preceded by a call to [`is_binary/1`](`is_binary/1`) to ensure that bitstrings\n  are rejected. Note that the compiler removes redundant calls to\n  [`is_binary/1`](`is_binary/1`), so if one is not sure whether previous code\n  had made sure that the argument is a binary, it does not harm to add an\n  [`is_binary/1`](`is_binary/1`) test immediately before the call to\n  [`byte_size/1`](`byte_size/1`).\n\n  Own Id: OTP-18432 Aux Id:\n  GH-6672,PR-6793,PR-6784,PR-6787,PR-6785,PR-6682,PR-6800,PR-6797,PR-6798,PR-6799,PR-6796,PR-6813,PR-6671,PR-6673,PR-6684,PR-6694,GH-6677,PR-6696,PR-6670,PR-6674","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Public_Key 1.13.2 - Public_Key Release Notes","doc":"","ref":"notes.html#public_key-1-13-2"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Public_Key Release Notes","doc":"- Disregard LDAP URIs when HTTP URIs are expected.\n\n  Own Id: OTP-18333 Aux Id: GH-6363","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Public_Key 1.13.1 - Public_Key Release Notes","doc":"","ref":"notes.html#public_key-1-13-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Public_Key Release Notes","doc":"- Support more Linux distributions in cacerts_load/0.\n\n  Own Id: OTP-18154 Aux Id: PR-6002\n\n- Correct asn1 typenames available in type pki_asn1_type()\n\n  Own Id: OTP-18189 Aux Id: ERIERL-829\n\n- Sign/verify does now behave as in OTP-24 and earlier for eddsa.\n\n  Own Id: OTP-18205 Aux Id: GH-6219","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Public_Key 1.13 - Public_Key Release Notes","doc":"","ref":"notes.html#public_key-1-13"},{"type":"extras","title":"Improvements and New Features - Public_Key Release Notes","doc":"- Added functions to retrieve OS provided CA-certs.\n\n  Own Id: OTP-17798 Aux Id: GH-5760\n\n- Allow key file passwords to be input as a single binary, that is we change the\n  data type to be the more for the purpose logical data type iodata() instead of\n  string().\n\n  Own Id: OTP-17890\n\n- The deprecated public_key functions ssh_decode/2, ssh_encode/2,\n  ssh_hostkey_fingerprint/1 and ssh_hostkey_fingerprint/2 are removed.\n\n  They are replaced by ssh_file:decode/2, ssh_file:encode/2,\n  ssh:hostkey_fingerprint/1 and ssh:hostkey_fingerprint/2 respectively.\n\n  Note that the decode/2 and encode/2 are not exact replacement functions, some\n  minor changes may be needed. Se the manual for more information.\n\n  \\*** POTENTIAL INCOMPATIBILITY \\***\n\n  Own Id: OTP-17921","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Public_Key 1.12.0.2 - Public_Key Release Notes","doc":"","ref":"notes.html#public_key-1-12-0-2"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Public_Key Release Notes","doc":"- Country name comparison shall be case insensitive\n\n  Own Id: OTP-18718 Aux Id: GH-7546","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Public_Key 1.12.0.1 - Public_Key Release Notes","doc":"","ref":"notes.html#public_key-1-12-0-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Public_Key Release Notes","doc":"- Correct asn1 typenames available in type pki_asn1_type()\n\n  Own Id: OTP-18189 Aux Id: ERIERL-829","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Public_Key 1.12 - Public_Key Release Notes","doc":"","ref":"notes.html#public_key-1-12"},{"type":"extras","title":"Improvements and New Features - Public_Key Release Notes","doc":"- Support password fun for protected keyfiles in ssl:connect function.\n\n  Own Id: OTP-17816 Aux Id: PR-5607","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Public_Key 1.11.3 - Public_Key Release Notes","doc":"","ref":"notes.html#public_key-1-11-3"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Public_Key Release Notes","doc":"- Avoid re-encoding of decoded certificates. This could cause unexpected\n  failures as some subtle encoding errors can be tolerated when decoding but\n  hence creating another sequence of bytes if the decoded value is re-encoded.\n\n  Own Id: OTP-17657","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Public_Key 1.11.2 - Public_Key Release Notes","doc":"","ref":"notes.html#public_key-1-11-2"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Public_Key Release Notes","doc":"- public_key:pkix_sign/2 now honors the salt length from the provided input\n  parameters. Earlier this could result in incorrect signatures if not using\n  recommended defaults.\n\n  Own Id: OTP-17534 Aux Id: GH-5054, PR-5057","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Improvements and New Features - Public_Key Release Notes","doc":"- When decoding an 'ECPrivateKey' unwrap the private key. For more precise\n  information see RFC 8410, section 7.\n\n  Own Id: OTP-17609 Aux Id: GH-5157, GH-5156","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Public_Key 1.11.1 - Public_Key Release Notes","doc":"","ref":"notes.html#public_key-1-11-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Public_Key Release Notes","doc":"- Handle cross-signed root certificates when old root expired as reported in\n  GH-4877.\n\n  Own Id: OTP-17475 Aux Id: GH-4877","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Public_Key 1.11 - Public_Key Release Notes","doc":"","ref":"notes.html#public_key-1-11"},{"type":"extras","title":"Improvements and New Features - Public_Key Release Notes","doc":"- TLS connections now support EdDSA certificates.\n\n  Own Id: OTP-17142 Aux Id: PR-4756, GH-4637, GH-4650\n\n- The functions public_key:ssh_encode/2, public_key:ssh_decode/2,\n  public_key:ssh_hostkey_fingerprint/1 and public_key:ssh_hostkey_fingerprint/2\n  are deprecated.\n\n  Replacement functions are available in SSH, see the\n  [Deprecations](`e:general_info:deprecations.md#otp-24`) chapter in the\n  Erlang/OTP documentation.\n\n  Own Id: OTP-17352\n\n- Enhance documentation and logging of certificate handling.\n\n  Own Id: OTP-17384 Aux Id: GH-4800","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Public_Key 1.10.0.1 - Public_Key Release Notes","doc":"","ref":"notes.html#public_key-1-10-0-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Public_Key Release Notes","doc":"- Handle cross-signed root certificates when old root expired as reported in\n  GH-4877.\n\n  Own Id: OTP-17475 Aux Id: GH-4877","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Public_Key 1.10 - Public_Key Release Notes","doc":"","ref":"notes.html#public_key-1-10"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Public_Key Release Notes","doc":"- Fixed case insensitive hostname check.\n\n  Own Id: OTP-17242 Aux Id: GH-4500","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Improvements and New Features - Public_Key Release Notes","doc":"- Add sanity check of trusted anchor certificate expiration to\n  pkix_path_validation/3. Although the anchor is considered a trusted input this\n  sanity check does provide extra security for the users of the public_key\n  application as this property needs to be checked at time of usage and fits\n  very well with the other checks performed here.\n\n  Own Id: OTP-16907\n\n- Adjust generation of test certificates to conform to RFC 5280 rules for\n  formatting of the certificates validity\n\n  Own Id: OTP-17111","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Public_Key 1.9.2 - Public_Key Release Notes","doc":"","ref":"notes.html#public_key-1-9-2"},{"type":"extras","title":"Improvements and New Features - Public_Key Release Notes","doc":"- Corrected dialyzer spec for pkix_path_validation/3\n\n  Own Id: OTP-17069","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Public_Key 1.9.1 - Public_Key Release Notes","doc":"","ref":"notes.html#public_key-1-9-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Public_Key Release Notes","doc":"- Fix the issue that pem_decode will crash with an invalid input.\n\n  Own Id: OTP-16902 Aux Id: ERIERL-534","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Public_Key 1.9 - Public_Key Release Notes","doc":"","ref":"notes.html#public_key-1-9"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Public_Key Release Notes","doc":"- Fixed an insignificant whitespace issue when decoding PEM file.\n\n  Own Id: OTP-16801 Aux Id: ERL-1309","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Improvements and New Features - Public_Key Release Notes","doc":"- Experimental OCSP client support.\n\n  Own Id: OTP-16448\n\n- Use user returned path validation error for selfsigned cert. It allows users\n  of the ssl application to customize the generated TLS alert, within the range\n  of defined alerts.\n\n  Own Id: OTP-16592\n\n- add API function to retrieve the subject-ID of an X509 certificate\n\n  Own Id: OTP-16705","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Public_Key 1.8 - Public_Key Release Notes","doc":"","ref":"notes.html#public_key-1-8"},{"type":"extras","title":"Improvements and New Features - Public_Key Release Notes","doc":"- Added support for RSA-PSS signature schemes\n\n  Own Id: OTP-15247\n\n- Calls of deprecated functions in the\n  [Old Crypto API](`e:crypto:new_api.md#the-old-api`) are replaced by calls of\n  their [substitutions](`e:crypto:new_api.md#the-new-api`).\n\n  Own Id: OTP-16346","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Public_Key 1.7.2 - Public_Key Release Notes","doc":"","ref":"notes.html#public_key-1-7-2"},{"type":"extras","title":"Improvements and New Features - Public_Key Release Notes","doc":"- Add support for key exchange with Edward curves and PSS-RSA padding in\n  signature verification.\n\n  Own Id: OTP-16528","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Public_Key 1.7.1 - Public_Key Release Notes","doc":"","ref":"notes.html#public_key-1-7-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Public_Key Release Notes","doc":"- Corrected CRL handling which could cause CRL verification to fail. This could\n  happen when the CRL distribution point explicitly specifies the CRL issuer,\n  that is not using the fallback.\n\n  Own Id: OTP-16156 Aux Id: ERL-1030","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Public_Key 1.7 - Public_Key Release Notes","doc":"","ref":"notes.html#public_key-1-7"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Public_Key Release Notes","doc":"- Support Password based encryption with AES\n\n  Own Id: OTP-15870 Aux Id: ERL-952","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Improvements and New Features - Public_Key Release Notes","doc":"- Change dialyzer spec to avoid confusion\n\n  Own Id: OTP-15843 Aux Id: ERL-915","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Public_Key 1.6.7 - Public_Key Release Notes","doc":"","ref":"notes.html#public_key-1-6-7"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Public_Key Release Notes","doc":"- RSA options passed to crypto for encrypt and decrypt with public or private\n  key.\n\n  Own Id: OTP-15754 Aux Id: ERL-878\n\n- Fix dialyzer warnings caused by a faulty type specification for digest_type().\n\n  This change updates digest_type() and the functions operating with this\n  argument type to accept both 'sha1' and 'sha' as digest_type().\n\n  Own Id: OTP-15776","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Improvements and New Features - Public_Key Release Notes","doc":"- Add possibility to read PEM files encrypted with old PEM encryption using\n  AES-256\n\n  Own Id: OTP-13726\n\n- Relax decoding of certificates to so that \"harmless\" third party encoding\n  errors may be accepted but not created by the public_key application. This\n  adds acceptance of using an incorrect three character country code, the PKIX\n  standard use two character country codes. It is also accepted that the country\n  code is utf8 encoded but the specification says it should be ASCII.\n\n  Own Id: OTP-15687 Aux Id: PR-2162","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Public_Key 1.6.6.1 - Public_Key Release Notes","doc":"","ref":"notes.html#public_key-1-6-6-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Public_Key Release Notes","doc":"- Support Password based encryption with AES\n\n  Own Id: OTP-15870 Aux Id: ERL-952","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Public_Key 1.6.6 - Public_Key Release Notes","doc":"","ref":"notes.html#public_key-1-6-6"},{"type":"extras","title":"Improvements and New Features - Public_Key Release Notes","doc":"- Back port of bug fix ERL-893 from OTP-22 and document enhancements that will\n  solve dialyzer warnings for users of the ssl application.\n\n  This change also affects public_key, eldap (and inet doc).\n\n  Own Id: OTP-15785 Aux Id: ERL-929, ERL-893, PR-2215","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Public_Key 1.6.5 - Public_Key Release Notes","doc":"","ref":"notes.html#public_key-1-6-5"},{"type":"extras","title":"Improvements and New Features - Public_Key Release Notes","doc":"- Add export of dialyzer type\n\n  Own Id: OTP-15624","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Public_Key 1.6.4 - Public_Key Release Notes","doc":"","ref":"notes.html#public_key-1-6-4"},{"type":"extras","title":"Improvements and New Features - Public_Key Release Notes","doc":"- Added ed25519 and ed448 sign/verify.\n\n  Requires OpenSSL 1.1.1 or higher as cryptolib under the OTP application\n  `crypto`.\n\n  Own Id: OTP-15419 Aux Id: OTP-15094","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Public_Key 1.6.3 - Public_Key Release Notes","doc":"","ref":"notes.html#public_key-1-6-3"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Public_Key Release Notes","doc":"- Add DSA SHA2 oids in public_keys ASN1-spec and public_key:pkix_sign_types/1\n\n  Own Id: OTP-15367","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Public_Key 1.6.2 - Public_Key Release Notes","doc":"","ref":"notes.html#public_key-1-6-2"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Public_Key Release Notes","doc":"- Removed `#DSAPrivateKey{}` as acceptable input to `public_key:verify/5`.\n\n  Own Id: OTP-15284","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Improvements and New Features - Public_Key Release Notes","doc":"- The typing in the CRYPTO and PUBLIC_KEY applications are reworked and a few\n  mistakes are corrected.\n\n  The documentation is now generated from the typing and some clarifications are\n  made.\n\n  A new chapter on Algorithm Details such as key sizes and availability is added\n  to the CRYPTO User's Guide.\n\n  Own Id: OTP-15134","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Public_Key 1.6.1 - Public_Key Release Notes","doc":"","ref":"notes.html#public_key-1-6-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Public_Key Release Notes","doc":"- Some of the keylengths in the newly generated moduli file in public_key are\n  not universally supported. This could cause the SSH key exchange\n  diffie-hellman-group-exchange-sha\\* to fail.\n\n  Those keylengths are now removed.\n\n  Own Id: OTP-15151 Aux Id: OTP-15113","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Public_Key 1.6 - Public_Key Release Notes","doc":"","ref":"notes.html#public_key-1-6"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Public_Key Release Notes","doc":"- Update calls to the base64 module to conform to that module's type\n  specifications.\n\n  Own Id: OTP-14788 Aux Id: OTP-14624","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Improvements and New Features - Public_Key Release Notes","doc":"- Use uri_string module instead of http_uri.\n\n  Own Id: OTP-14902\n\n- A new function - `public_key:pkix_verify_hostname_match_fun/1` \\- returns a\n  fun to be given as option `match_fun` to `public_key:pkix_verify_hostname/3`\n  or via ssl.\n\n  The fun makes the verify hostname matching according to the specific rules for\n  the protocol in the argument. Presently only `https` is supported.\n\n  Own Id: OTP-14962 Aux Id: ERL-542, OTP-15102\n\n- Complete PKCS-8 encoding support and enhance the decoding of 'PrivateKeyInfo'\n  to conform to the rest of Erlang public_key API.\n\n  Own Id: OTP-15093\n\n- A new moduli file is generated. This file is used for the recommended\n  `diffie-hellman-group-exchange-sha256` key exchange algorithm in SSH.\n\n  Own Id: OTP-15113","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Public_Key 1.5.2 - Public_Key Release Notes","doc":"","ref":"notes.html#public_key-1-5-2"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Public_Key Release Notes","doc":"- Fixed a bug in `public_key:ssh_encode/2` that made it possible to erroneously\n  encode e.g. an RSA key with another type e.g. ECDSA in the resulting binary.\n\n  Own Id: OTP-14570 Aux Id: ERIERL-52, OTP-14676\n\n- Corrected handling of parameterized EC keys in public_key:generate_key/1 so\n  that it will work as expected instead of causing a runtime error in crypto.\n\n  Own Id: OTP-14620","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Public_Key 1.5.1 - Public_Key Release Notes","doc":"","ref":"notes.html#public_key-1-5-1"},{"type":"extras","title":"Improvements and New Features - Public_Key Release Notes","doc":"- Hostname verification: Add handling of the general name `iPAddress` in\n  certificate's subject alternative name extension (`subjAltName`).\n\n  Own Id: OTP-14653\n\n- Correct key handling in pkix_test_data/1 and use a generic example mail\n  address instead of an existing one.\n\n  Own Id: OTP-14766","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Public_Key 1.5 - Public_Key Release Notes","doc":"","ref":"notes.html#public_key-1-5"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Public_Key Release Notes","doc":"- public_key now handles elliptic curve parameters in a consistent way so that\n  decoded ECDSA keys can be correctly re-encoded.\n\n  \\*** POTENTIAL INCOMPATIBILITY \\***\n\n  Own Id: OTP-14621 Aux Id: ERL-480, ERL-481","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Improvements and New Features - Public_Key Release Notes","doc":"- Extend crypto:sign, crypto:verify, public_key:sign and public_key:verify with:\n\n  \\* support for RSASSA-PS padding for signatures and for saltlength setting  \n  \\* X9.31 RSA padding.  \n  \\* sha, sha224, sha256, sha384, and sha512 for dss signatures as mentioned in\n  NIST SP 800-57 Part 1.  \n  \\* ripemd160 to be used for RSA signatures.\n\n  This is a manual merge of half of the pull request 838 by potatosalad from\n  Sept 2015.\n\n  Own Id: OTP-13704 Aux Id: PR838\n\n- Add API function pkix_test_data/1 for facilitating automated testing. This is\n  useful for applications that perform X509-certifcate path validation of so\n  called certificate chains, such as TLS.\n\n  Own Id: OTP-14181\n\n- Improved error propagation and reports\n\n  Own Id: OTP-14236\n\n- RSAPrivateKey version is set to 'two-prime' instead of using the underlying\n  enumeration value directly.\n\n  Own Id: OTP-14534\n\n- Deprecated function `crypto:rand_uniform/2` is replaced by `rand:uniform/1`.\n\n  Own Id: OTP-14608","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Public_Key 1.4.1 - Public_Key Release Notes","doc":"","ref":"notes.html#public_key-1-4-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Public_Key Release Notes","doc":"- Bug for `public_key:generate_key({namedCurve,OID})` fixed.\n\n  Own Id: OTP-14258","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Improvements and New Features - Public_Key Release Notes","doc":"- Modernized internal representation used for crl validation by use of maps.\n\n  Own Id: OTP-14111\n\n- Support EC key in pkix_sign/2\n\n  Own Id: OTP-14294","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Public_Key 1.4 - Public_Key Release Notes","doc":"","ref":"notes.html#public_key-1-4"},{"type":"extras","title":"Improvements and New Features - Public_Key Release Notes","doc":"- New function `pkix_verify_hostname/2,3` Implements certificate hostname\n  checking. See the manual and RFC 6125.\n\n  Own Id: OTP-13009\n\n- The ssh host key fingerprint generation now also takes a list of algorithms\n  and returns a list of corresponding fingerprints. See\n  `public_key:ssh_hostkey_fingerprint/2` and the option `silently_accept_hosts`\n  in `ssh:connect`.\n\n  Own Id: OTP-14223","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Public_Key 1.3 - Public_Key Release Notes","doc":"","ref":"notes.html#public_key-1-3"},{"type":"extras","title":"Improvements and New Features - Public_Key Release Notes","doc":"- New function `public_key:ssh_hostkey_fingerprint/1,2` to calculate the SSH\n  host key fingerprint string.\n\n  Own Id: OTP-13888 Aux Id: OTP-13887","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Public_Key 1.2 - Public_Key Release Notes","doc":"","ref":"notes.html#public_key-1-2"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Public_Key Release Notes","doc":"- The ASN-1 type GeneralName can have more values, then the most common\n  directory name, the code now handles this.\n\n  Own Id: OTP-13554","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Improvements and New Features - Public_Key Release Notes","doc":"- Handle PEM encoded EC public keys\n\n  Own Id: OTP-13408","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Public_Key 1.1.1 - Public_Key Release Notes","doc":"","ref":"notes.html#public_key-1-1-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Public_Key Release Notes","doc":"- An encapsulated PEM header shall be followed by a blank line\n\n  Own Id: OTP-13381 Aux Id: seq13070","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Public_Key 1.1 - Public_Key Release Notes","doc":"","ref":"notes.html#public_key-1-1"},{"type":"extras","title":"Improvements and New Features - Public_Key Release Notes","doc":"- The 'ecdsa-sha2-nistp256', 'ecdsa-sha2-nistp384' and 'ecdsa-sha2-nistp521'\n  signature algorithms for ssh are implemented. See RFC 5656.\n\n  Own Id: OTP-12936\n\n- There is now a file (public_key/priv/moduli) which lists\n  size-generator-modulus triples. The purpose is to give servers the possibility\n  to select the crypto primes randomly among a list of pregenerated triples.\n  This reduces the risk for some attacks on diffie-hellman negotiation.\n\n  See the reference manual for public_key:dh_gex_group/4 where the handling of\n  this is described.\n\n  The ssh server (ssh:daemon) uses this.\n\n  Own Id: OTP-13054 Aux Id: OTP-13052\n\n- Add different upper bounds for different string types as suggested by comment\n  in PKIX1Explicit88.\n\n  Own Id: OTP-13132","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Public_Key 1.0.1 - Public_Key Release Notes","doc":"","ref":"notes.html#public_key-1-0-1"},{"type":"extras","title":"Improvements and New Features - Public_Key Release Notes","doc":"- Document enhancements\n\n  Own Id: OTP-12986","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Public_Key 1.0 - Public_Key Release Notes","doc":"","ref":"notes.html#public_key-1-0"},{"type":"extras","title":"Improvements and New Features - Public_Key Release Notes","doc":"- public_key: Remove legacy switch compact_bit_string\n\n  E.i bitstrings will not be decode as \\{Unused, Binary\\}, they are now Erlang\n  bitstrings.\n\n  Also the compact_bit_string implies the legacy_erlang_types switch So removing\n  the switch will also make OCTET STRING values be represented as binaries.\n\n  Undecoded open type will now be wrapped in a asn1_OPENTYPE tuple.\n\n  This will change some values in records returned by the public_key API making\n  this change a potentiall incompatibility.\n\n  \\*** POTENTIAL INCOMPATIBILITY \\***\n\n  Own Id: OTP-12110","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Public_Key 0.23 - Public_Key Release Notes","doc":"","ref":"notes.html#public_key-0-23"},{"type":"extras","title":"Improvements and New Features - Public_Key Release Notes","doc":"- Improve/extend support for CRL handling.\n\n  Own Id: OTP-12547 Aux Id: OTP-10362","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Public_Key 0.22.1 - Public_Key Release Notes","doc":"","ref":"notes.html#public_key-0-22-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Public_Key Release Notes","doc":"- Added missing encoding support for PBES2, and also completed support for PBES1\n  that was incomplete.\n\n  Own Id: OTP-11915","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Public_Key 0.22 - Public_Key Release Notes","doc":"","ref":"notes.html#public_key-0-22"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Public_Key Release Notes","doc":"- Fix incorrect dialyzer spec and types, also enhance documentation.\n\n  Thanks to Ayaz Tuncer.\n\n  Own Id: OTP-11627\n\n- Application upgrade (appup) files are corrected for the following\n  applications:\n\n  `asn1, common_test, compiler, crypto, debugger, dialyzer, edoc, eldap, erl_docgen, et, eunit, gs, hipe, inets, observer, odbc, os_mon, otp_mibs, parsetools, percept, public_key, reltool, runtime_tools, ssh, syntax_tools, test_server, tools, typer, webtool, wx, xmerl`\n\n  A new test utility for testing appup files is added to test_server. This is\n  now used by most applications in OTP.\n\n  (Thanks to Tobias Schlager)\n\n  Own Id: OTP-11744","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Improvements and New Features - Public_Key Release Notes","doc":"- Moved elliptic curve definition from the crypto NIF/OpenSSL into Erlang code,\n  adds the RFC-5639 brainpool curves and makes TLS use them (RFC-7027).\n\n  Thanks to Andreas Schultz\n\n  Own Id: OTP-11578\n\n- Handle v1 CRLs, with no extensions and fixes issues with IDP (Issuing\n  Distribution Point) comparison during CRL validation.\n\n  Thanks to Andrew Thompson\n\n  Own Id: OTP-11761","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Public_Key 0.21 - Public_Key Release Notes","doc":"","ref":"notes.html#public_key-0-21"},{"type":"extras","title":"Improvements and New Features - Public_Key Release Notes","doc":"- Fixed a little typo in public_key documentation. Thanks to Tomas Morstein.\n\n  Own Id: OTP-11380\n\n- public_key: Workaround for incorrectly encoded utf8 emailAddress. Thanks to\n  Andrew Bennett.\n\n  Own Id: OTP-11470","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Public_Key 0.20 - Public_Key Release Notes","doc":"","ref":"notes.html#public_key-0-20"},{"type":"extras","title":"Improvements and New Features - Public_Key Release Notes","doc":"- Extend PKCS-7 to support SCEP (Simple Certificate Enrollment Protocol).\n\n  Own Id: OTP-10874\n\n- public_key:pem_entry_decode/2 now handles AES-128-CBC ciphered keys. Thanks to\n  Simon Cornish.\n\n  Own Id: OTP-11281","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Public_Key 0.19 - Public_Key Release Notes","doc":"","ref":"notes.html#public_key-0-19"},{"type":"extras","title":"Improvements and New Features - Public_Key Release Notes","doc":"- Add support for ISO oids 1.3.14.3.2.29 and 1.3.14.3.2.27 that are sometimes\n  used instead of the PKCS defined oids 1.2.840.113549.1.1.5 and\n  1.2.840.10040.4.3. Add function pkix_sign_types:/1 that translates oids to to\n  algorithm atoms ex:\n\n  > public_key:pkix_sign_types(\\{1,3,14,3,2,29\\}). \\{sha,rsa\\}\n\n  Own Id: OTP-10873\n\n- Integrate elliptic curve contribution from Andreas Schultz\n\n  In order to be able to support elliptic curve cipher suites in SSL/TLS,\n  additions to handle elliptic curve infrastructure has been added to public_key\n  and crypto.\n\n  This also has resulted in a rewrite of the crypto API to gain consistency and\n  remove unnecessary overhead. All OTP applications using crypto has been\n  updated to use the new API.\n\n  Impact: Elliptic curve cryptography (ECC) offers equivalent security with\n  smaller key sizes than other public key algorithms. Smaller key sizes result\n  in savings for power, memory, bandwidth, and computational cost that make ECC\n  especially attractive for constrained environments.\n\n  Own Id: OTP-11009","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Public_Key 0.18 - Public_Key Release Notes","doc":"","ref":"notes.html#public_key-0-18"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Public_Key Release Notes","doc":"- Fix subjectPublicKeyInfo type comment in public_key. Thanks to Ryosuke Nakai.\n\n  Own Id: OTP-10670","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Improvements and New Features - Public_Key Release Notes","doc":"- public_key now supports CRL validation and documents the function\n  public_key:pkix_path_validation/3\n\n  Own Id: OTP-7045\n\n- Some examples overflowing the width of PDF pages have been corrected.\n\n  Own Id: OTP-10665\n\n- Fixed typo's in public_key spec.\n\n  Own Id: OTP-10723\n\n- Corrected PKCS-10 documentation and added some PKCS-9 support that is fairly\n  commonly used by PKCS-10. Full support for PKCS-9 will be added later.\n\n  Own Id: OTP-10767","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Public_Key 0.17 - Public_Key Release Notes","doc":"","ref":"notes.html#public_key-0-17"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Public_Key Release Notes","doc":"- ssh_decode now handles comments, at the end of the line, containing with\n  spaces correctly\n\n  Own Id: OTP-9361\n\n- Add missing references to sha224 and sha384\n\n  Own Id: OTP-9362 Aux Id: seq12116","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Improvements and New Features - Public_Key Release Notes","doc":"- public_key now supports PKCS-10 and includes experimental support for PKCS-7\n\n  Own Id: OTP-10509 Aux Id: kunagi-291 \\[202]","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Public_Key 0.16 - Public_Key Release Notes","doc":"","ref":"notes.html#public_key-0-16"},{"type":"extras","title":"Improvements and New Features - Public_Key Release Notes","doc":"- Add crypto and public_key support for the hash functions SHA224, SHA256,\n  SHA384 and SHA512 and also hmac and rsa_sign/verify support using these hash\n  functions. Thanks to Andreas Schultz for making a prototype.\n\n  Own Id: OTP-9908\n\n- Optimize RSA private key handling in `crypto` and `public_key`.\n\n  Own Id: OTP-10065","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Public_Key 0.15 - Public_Key Release Notes","doc":"","ref":"notes.html#public_key-0-15"},{"type":"extras","title":"Improvements and New Features - Public_Key Release Notes","doc":"- Changed ssh implementation to use the public_key application for all public\n  key handling. This is also a first step for enabling a callback API for\n  supplying public keys and handling keys protected with password phrases.\n\n  Additionally the test suites where improved so that they do not copy the users\n  keys to test server directories as this is a security liability. Also ipv6 and\n  file access issues found in the process has been fixed.\n\n  This change also solves OTP-7677 and OTP-7235\n\n  This changes also involves some updates to public_keys ssh-functions.\n\n  Own Id: OTP-9911","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Public_Key 0.14 - Public_Key Release Notes","doc":"","ref":"notes.html#public_key-0-14"},{"type":"extras","title":"Improvements and New Features - Public_Key Release Notes","doc":"- public_key, ssl and crypto now supports PKCS-8\n\n  Own Id: OTP-9312\n\n- The asn1 decoder/encoder now uses a runtime nif from the asn1 application if\n  it is available.\n\n  Own Id: OTP-9414","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Public_Key 0.13 - Public_Key Release Notes","doc":"","ref":"notes.html#public_key-0-13"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Public_Key Release Notes","doc":"- replace \"a ssl\" with \"an ssl\" reindent pkix_path_validation/3 Trivial\n  documentation fixes (Thanks to Christian von Roques )\n\n  Own Id: OTP-9464","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Public_Key 0.12 - Public_Key Release Notes","doc":"","ref":"notes.html#public_key-0-12"},{"type":"extras","title":"Improvements and New Features - Public_Key Release Notes","doc":"- The public_key application now supports encode/decode of ssh public-key files.\n\n  Own Id: OTP-9144","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Public_Key 0.11 - Public_Key Release Notes","doc":"","ref":"notes.html#public_key-0-11"},{"type":"extras","title":"Improvements and New Features - Public_Key Release Notes","doc":"- Allows the public_key module to decode and encode RSA and DSA keys encoded\n  using the SubjectPublicKeyInfo format. When pem_entry_encode is called on an\n  RSA or DSA public key type, the key is wrapped in the SubjectPublicKeyInfo\n  format.\n\n  Own Id: OTP-9061","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Public_Key 0.10 - Public_Key Release Notes","doc":"","ref":"notes.html#public_key-0-10"},{"type":"extras","title":"Improvements and New Features - Public_Key Release Notes","doc":"- Improved dialyzer specs.\n\n  Own Id: OTP-8964","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Public_Key 0.9 - Public_Key Release Notes","doc":"","ref":"notes.html#public_key-0-9"},{"type":"extras","title":"Improvements and New Features - Public_Key Release Notes","doc":"- Updated ssl to ignore CA certs that violate the asn1-spec for a certificate,\n  and updated public key asn1 spec to handle inherited DSS-params.\n\n  Own Id: OTP-7884\n\n- Changed ssl implementation to retain backwards compatibility for old option\n  \\{verify, 0\\} that shall be equivalent to \\{verify, verify_none\\}, also\n  separate the cases unknown ca and selfsigned peer cert, and restored return\n  value of deprecated function public_key:pem_to_der/1.\n\n  Own Id: OTP-8858\n\n- Better handling of v1 and v2 certificates. V1 and v2 certificates does not\n  have any extensions so then validate_extensions should just accept that there\n  are none and not end up in missing_basic_constraints clause.\n\n  Own Id: OTP-8867\n\n- Changed the verify fun so that it differentiate between the peer certificate\n  and CA certificates by using valid_peer or valid as the second argument to the\n  verify fun. It may not always be trivial or even possible to know when the\n  peer certificate is reached otherwise.\n\n  \\*** POTENTIAL INCOMPATIBILITY \\***\n\n  Own Id: OTP-8873","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Public_Key 0.8 - Public_Key Release Notes","doc":"","ref":"notes.html#public_key-0-8"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Public_Key Release Notes","doc":"- Handling of unknown CA certificates was changed in ssl and public_key to work\n  as intended.\n\n  Own Id: OTP-8788","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Improvements and New Features - Public_Key Release Notes","doc":"- Revise the public_key API - Cleaned up and documented the public_key API to\n  make it useful for general use, also changed ssl to use the new API.\n\n  Own Id: OTP-8722\n\n- Added the functionality so that the verification fun will be called when a\n  certificate is considered valid by the path validation to allow access to each\n  certificate in the path to the user application. Also try to verify\n  subject-AltName, if unable to verify it let the application verify it.\n\n  Own Id: OTP-8825","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Public_Key 0.7 - Public_Key Release Notes","doc":"","ref":"notes.html#public_key-0-7"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Public_Key Release Notes","doc":"- Certificates without any extensions could not be handled by public_key.\n\n  Own Id: OTP-8626","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Improvements and New Features - Public_Key Release Notes","doc":"- Code cleanup and minor bugfixes.\n\n  Own Id: OTP-8649","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Public_Key 0.6 - Public_Key Release Notes","doc":"","ref":"notes.html#public_key-0-6"},{"type":"extras","title":"Improvements and New Features - Public_Key Release Notes","doc":"- Support for Diffie-Hellman. ssl-3.11 requires public_key-0.6.\n\n  Own Id: OTP-7046\n\n- Moved extended key usage test for ssl values to ssl.\n\n  Own Id: OTP-8553 Aux Id: seq11541, OTP-8554","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Public_Key 0.5 - Public_Key Release Notes","doc":"","ref":"notes.html#public_key-0-5"},{"type":"extras","title":"Improvements and New Features - Public_Key Release Notes","doc":"- Added `public_key:pkix_transform/2` to enable ssl to send CA list during\n  Certificate Request.\n\n  `NOTE`: SSL (new_ssl) requires public_key-0.5. ssl usage.\n\n  Own Id: OTP-8372","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Public_Key 0.4 - Public_Key Release Notes","doc":"","ref":"notes.html#public_key-0-4"},{"type":"extras","title":"Improvements and New Features - Public_Key Release Notes","doc":"- The documentation is now built with open source tools (xsltproc and fop) that\n  exists on most platforms. One visible change is that the frames are removed.\n\n  Own Id: OTP-8250","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Public_Key 0.3 - Public_Key Release Notes","doc":"","ref":"notes.html#public_key-0-3"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Public_Key Release Notes","doc":"- Unknown attributes in certificates are left encoded instead of crashing. Patch\n  by Will \"wglozer\" thanks.\n\n  Own Id: OTP-8100","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Improvements and New Features - Public_Key Release Notes","doc":"- Allow public_key:pem_to_der/\\[1,2] to take a binary as argument in addition to\n  a filename. Patch by Geoff Cant, thanks.\n\n  Own Id: OTP-8142","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Public_Key 0.2 - Public_Key Release Notes","doc":"","ref":"notes.html#public_key-0-2"},{"type":"extras","title":"Improvements and New Features - Public_Key Release Notes","doc":"- X509 certificate handling has been extended and improved as a result of more\n  extensive testing of both the ssl and public_key application. Even more\n  extensions of the certificate handling is yet to be implemented.\n\n  Own Id: OTP-7860","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Public_Key 0.1 - Public_Key Release Notes","doc":"","ref":"notes.html#public_key-0-1"},{"type":"extras","title":"Improvements and New Features - Public_Key Release Notes","doc":"- First version.\n\n  Own Id: OTP-7637","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Public-Key Records","doc":"<!--\n%CopyrightBegin%\n\nCopyright Ericsson AB 2023-2024. All Rights Reserved.\n\nLicensed under the Apache License, Version 2.0 (the \"License\");\nyou may not use this file except in compliance with the License.\nYou may obtain a copy of the License at\n\n    http://www.apache.org/licenses/LICENSE-2.0\n\nUnless required by applicable law or agreed to in writing, software\ndistributed under the License is distributed on an \"AS IS\" BASIS,\nWITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\nSee the License for the specific language governing permissions and\nlimitations under the License.\n\n%CopyrightEnd%\n-->\n# Public-Key Records\n\nThis chapter briefly describes Erlang records derived from ASN.1 specifications\nused to handle public key infrastructure. The scope is to describe the data\ntypes of each component, not the semantics. For information on the semantics,\nrefer to the relevant standards and RFCs linked in the sections below.\n\nUse the following include directive to get access to the records and constant\nmacros described in the following sections:\n\n```erlang\n -include_lib(\"public_key/include/public_key.hrl\").\n```","ref":"public_key_records.html"},{"type":"extras","title":"Data Types - Public-Key Records","doc":"Common non-standard Erlang data types used to describe the record fields in the\nfollowing sections and which are not defined in the Public Key\n[Reference Manual](`m:public_key`) follows here:\n\n```erlang\ntime() = utc_time() | general_time()\n\nutc_time()  = {utcTime, \"YYMMDDHHMMSSZ\"}\n\ngeneral_time() = {generalTime, \"YYYYMMDDHHMMSSZ\"}\n\ngeneral_name() = {rfc822Name, string()} |\n\n                 {dNSName, string()} |\n\n                 {x400Address, string() |\n\n                 {directoryName, {rdnSequence, [#'AttributeTypeAndValue'{}]}} |\n\n                 {ediPartyName, special_string()} |\n\n                 {ediPartyName, special_string(), special_string()} |\n\n                 {uniformResourceIdentifier, string()} |\n\n                 {iPAddress, string()} |\n\n                 {registeredId, oid()} |\n\n                 {otherName, term()}\n\nspecial_string() = {teletexString, string()} |\n \n                   {printableString, string()} |\n\n                   {universalString, string()} |\n\n                   {utf8String, binary()} |\n\n                   {bmpString, string()}\n\ndist_reason() = unused | keyCompromise | cACompromise | affiliationChanged |\n                cessationOfOperation | certificateHold | privilegeWithdrawn | aACompromise\n\nOID_macro() = ?OID_name()\n\nOID_name() = atom()\n```","ref":"public_key_records.html#data-types"},{"type":"extras","title":"RSA - Public-Key Records","doc":"Erlang representation of\n[Rivest-Shamir-Adleman cryptosystem (RSA)](http://www.ietf.org/rfc/rfc3447.txt)\nkeys follows:\n\n```erlang\n#'RSAPublicKey'{\n   modulus,       % pos_integer()\n   publicExponent % pos_integer()\n  }.\n\n#'RSAPrivateKey'{\n   version,         % two-prime | multi\n   modulus,         % pos_integer()\n   publicExponent,  % pos_integer()\n   privateExponent, % pos_integer()\n   prime1,          % pos_integer()\n   prime2,          % pos_integer()\n   exponent1,       % pos_integer()\n   exponent2,       % pos_integer()\n   coefficient,     % pos_integer()\n   otherPrimeInfos  % [#OtherPrimeInfo{}] | asn1_NOVALUE\n  }.\n\n#'OtherPrimeInfo'{\n   prime,           % pos_integer()\n   exponent,        % pos_integer()\n   coefficient      % pos_integer()\n  }.\n\n#'RSASSA-PSS-params'{\n   hashAlgorithm,     % #'HashAlgorithm'{}},\n   maskGenAlgorithm,  % #'MaskGenAlgorithm'{}},\n   saltLength,        % pos_integer(),\n   trailerField,      % pos_integer()\n  }.\n\n#'HashAlgorithm'{\n   algorithm,  % oid()\n   parameters  % defaults to asn1_NOVALUE\n  }.\n\n#'MaskGenAlgorithm'{\n   algorithm,  % oid()\n   parameters, % defaults to asn1_NOVALUE\n  }.\n```","ref":"public_key_records.html#rsa"},{"type":"extras","title":"DSA - Public-Key Records","doc":"Erlang representation of\n[Digital Signature Algorithm (DSA)](http://www.ietf.org/rfc/rfc6979.txt) keys\n\n```erlang\n#'DSAPrivateKey'{\n   version,      % pos_integer()\n   p,            % pos_integer()\n   q,            % pos_integer()\n   g,            % pos_integer()\n   y,            % pos_integer()\n   x             % pos_integer()\n  }.\n\n#'Dss-Parms'{\n   p,         % pos_integer()\n   q,         % pos_integer()\n   g          % pos_integer()\n  }.\n```","ref":"public_key_records.html#dsa"},{"type":"extras","title":"ECDSA and EDDSA - Public-Key Records","doc":"Erlang representation of\n[Elliptic Curve Digital Signature Algorithm (ECDSA)](http://www.ietf.org/rfc/rfc6979.txt)\nand\n[Edwards-Curve Digital Signature Algorithm (EDDSA)](https://tools.ietf.org/html/rfc8032)\nwhere parameters in the private key will be\n`{namedCurve, ?'id-Ed25519' | ?'id-Ed448'}`.\n\n```erlang\n#'ECPrivateKey'{\n   version,       % pos_integer()\n   privateKey,    % binary()\n   parameters,    % {ecParameters, #'ECParameters'{}} |\n                  % {namedCurve, Oid::tuple()} |\n                  % {implicitlyCA, 'NULL'}\n   publicKey      % bitstring()\n  }.\n\n#'ECParameters'{\n   version,    % pos_integer()\n   fieldID,    % #'FieldID'{}\n   curve,      % #'Curve'{}\n   base,       % binary()\n   order,      % pos_integer()\n   cofactor    % pos_integer()\n  }.\n\n#'Curve'{\n   a,        % binary()\n   b,        % binary()\n   seed      % bitstring() - optional\n  }.\n\n#'FieldID'{\n   fieldType,    % oid()\n   parameters    % Depending on fieldType\n  }.\n\n#'ECPoint'{\n   point %  binary() - the public key\n  }.\n```","ref":"public_key_records.html#ecdsa-and-eddsa"},{"type":"extras","title":"PKIX Certificates - Public-Key Records","doc":"Erlang representation of PKIX certificates derived from ASN.1 specifications see\nalso [X509 certificates (RFC 5280)](http://www.ietf.org/rfc/rfc5280.txt), also\nreferred to as `plain` type, are as follows:\n\n```erlang\n#'Certificate'{\n   tbsCertificate,        % #'TBSCertificate'{}\n   signatureAlgorithm,    % #'AlgorithmIdentifier'{}\n   signature              % bitstring()\n  }.\n\n#'TBSCertificate'{\n   version,              % v1 | v2 | v3\n   serialNumber,         % pos_integer()\n   signature,            % #'AlgorithmIdentifier'{}\n   issuer,               % {rdnSequence, [#AttributeTypeAndValue'{}]\n   validity,             % #'Validity'{}\n   subject,              % {rdnSequence, [#AttributeTypeAndValue'{}]}\n   subjectPublicKeyInfo, % #'SubjectPublicKeyInfo'{}\n   issuerUniqueID,       % binary() | asn1_novalue\n   subjectUniqueID,      % binary() | asn1_novalue\n   extensions            % [#'Extension'{}]\n  }.\n\n#'AlgorithmIdentifier'{\n   algorithm,  % oid()\n   parameters  % der_encoded()\n  }.\n```\n\nErlang alternate representation of PKIX certificate, also referred to as `otp`\ntype\n\n```erlang\n#'OTPCertificate'{\n   tbsCertificate,        % #'OTPTBSCertificate'{}\n   signatureAlgorithm,    % #'SignatureAlgorithm'\n   signature              % bitstring()\n  }.\n\n#'OTPTBSCertificate'{\n   version,              % v1 | v2 | v3\n   serialNumber,         % pos_integer()\n   signature,            % #'SignatureAlgorithm'\n   issuer,               % {rdnSequence, [#AttributeTypeAndValue'{}]}\n   validity,             % #'Validity'{}\n   subject,              % {rdnSequence, [#AttributeTypeAndValue'{}]}\n   subjectPublicKeyInfo, % #'OTPSubjectPublicKeyInfo'{}\n   issuerUniqueID,       % binary() | asn1_novalue\n   subjectUniqueID,      % binary() | asn1_novalue\n   extensions            % [#'Extension'{}]\n  }.\n\n#'SignatureAlgorithm'{\n   algorithm,  % id_signature_algorithm()\n   parameters  % asn1_novalue | #'Dss-Parms'{}\n  }.\n```\n\n`id_signature_algorithm() = OID_macro()`\n\nThe available OID names are as follows:\n\n| _OID Name_                                   |\n| -------------------------------------------- |\n| id-dsa-with-sha1                             |\n| id-dsaWithSHA1 (ISO or OID to above)         |\n| md2WithRSAEncryption                         |\n| md5WithRSAEncryption                         |\n| sha1WithRSAEncryption                        |\n| sha-1WithRSAEncryption (ISO or OID to above) |\n| sha224WithRSAEncryption                      |\n| sha256WithRSAEncryption                      |\n| sha512WithRSAEncryption                      |\n| ecdsa-with-SHA1                              |\n\n_Table: Signature Algorithm OIDs_\n\nThe data type `'AttributeTypeAndValue'`, is represented as the following erlang\nrecord:\n\n```erlang\n#'AttributeTypeAndValue'{\n   type,   % id_attributes()\n   value   % term()\n  }.\n```\n\nThe attribute OID name atoms and their corresponding value types are as follows:\n\n| _OID Name_                | _Value Type_                  |\n| ------------------------- | ----------------------------- |\n| id-at-name                | special_string()              |\n| id-at-surname             | special_string()              |\n| id-at-givenName           | special_string()              |\n| id-at-initials            | special_string()              |\n| id-at-generationQualifier | special_string()              |\n| id-at-commonName          | special_string()              |\n| id-at-localityName        | special_string()              |\n| id-at-stateOrProvinceName | special_string()              |\n| id-at-organizationName    | special_string()              |\n| id-at-title               | special_string()              |\n| id-at-dnQualifier         | \\{printableString, string()\\} |\n| id-at-countryName         | \\{printableString, string()\\} |\n| id-at-serialNumber        | \\{printableString, string()\\} |\n| id-at-pseudonym           | special_string()              |\n\n_Table: Attribute OIDs_\n\nThe data types `'Validity'`, `'SubjectPublicKeyInfo'`, and\n`'SubjectPublicKeyInfoAlgorithm'` are represented as the following Erlang\nrecords:\n\n```erlang\n#'Validity'{\n   notBefore, % time()\n   notAfter   % time()\n  }.\n\n#'SubjectPublicKeyInfo'{\n   algorithm,       % #AlgorithmIdentifier{}\n   subjectPublicKey % binary()\n  }.\n\n#'SubjectPublicKeyInfoAlgorithm'{\n   algorithm,  % id_public_key_algorithm()\n   parameters  % public_key_params()\n  }.\n```\n\nThe public-key algorithm OID name atoms are as follows:\n\n| _OID Name_              |\n| ----------------------- |\n| rsaEncryption           |\n| id-dsa                  |\n| dhpublicnumber          |\n| id-keyExchangeAlgorithm |\n| id-ecPublicKey          |\n\n_Table: Public-Key Algorithm OIDs_\n\n```erlang\n#'Extension'{\n   extnID,    % id_extensions() | oid()\n   critical,  % boolean()\n   extnValue  % der_encoded()\n  }.\n```\n\n`id_extensions()`\n[Standard Certificate Extensions](public_key_records.md#StdCertExt),\n[Private Internet Extensions](public_key_records.md#PrivIntExt),\n[CRL Extensions](public_key_records.md#CRLCertExt) and\n[CRL Entry Extensions](public_key_records.md#CRLEntryExt).\n\n[](){: #StdCertExt }","ref":"public_key_records.html#pkix-certificates"},{"type":"extras","title":"Standard Certificate Extensions - Public-Key Records","doc":"The standard certificate extensions OID name atoms and their corresponding value\ntypes are as follows:\n\n| _OID Name_                       | _Value Type_                   |\n| -------------------------------- | ------------------------------ |\n| id-ce-authorityKeyIdentifier     | \\#'AuthorityKeyIdentifier'\\{\\} |\n| id-ce-subjectKeyIdentifier       | oid()                          |\n| id-ce-keyUsage                   | \\[key_usage()]                 |\n| id-ce-privateKeyUsagePeriod      | \\#'PrivateKeyUsagePeriod'\\{\\}  |\n| id-ce-certificatePolicies        | \\#'PolicyInformation'\\{\\}      |\n| id-ce-policyMappings             | \\#'PolicyMappings_SEQOF'\\{\\}   |\n| id-ce-subjectAltName             | general_name()                 |\n| id-ce-issuerAltName              | general_name()                 |\n| id-ce-subjectDirectoryAttributes | \\[#'Attribute'\\{\\}]            |\n| id-ce-basicConstraints           | \\#'BasicConstraints'\\{\\}       |\n| id-ce-nameConstraints            | \\#'NameConstraints'\\{\\}        |\n| id-ce-policyConstraints          | \\#'PolicyConstraints'\\{\\}      |\n| id-ce-extKeyUsage                | \\[id_key_purpose()]            |\n| id-ce-cRLDistributionPoints      | \\[#'DistributionPoint'\\{\\}]    |\n| id-ce-inhibitAnyPolicy           | pos_integer()                      |\n| id-ce-freshestCRL                | \\[#'DistributionPoint'\\{\\}]    |\n\n_Table: Standard Certificate Extensions_\n\nHere:\n\n```erlang\nkey_usage() = digitalSignature | nonRepudiation | keyEncipherment\n            | dataEncipherment | keyAgreement | keyCertSign\n            | cRLSign | encipherOnly | decipherOnly\n```\nAnd for `id_key_purpose()`:\n\n| _OID Name_            |\n| --------------------- |\n| id-kp-serverAuth      |\n| id-kp-clientAuth      |\n| id-kp-codeSigning     |\n| id-kp-emailProtection |\n| id-kp-timeStamping    |\n| id-kp-OCSPSigning     |\n\n_Table: Key Purpose OIDs_\n\n```erlang\n#'AuthorityKeyIdentifier'{\n   keyIdentifier,            % oid()\n   authorityCertIssuer,      % general_name()\n   authorityCertSerialNumber % pos_integer()\n  }.\n\n#'PrivateKeyUsagePeriod'{\n   notBefore,   % general_time()\n   notAfter     % general_time()\n  }.\n\n#'PolicyInformation'{\n   policyIdentifier,  % oid()\n   policyQualifiers   % [#PolicyQualifierInfo{}]\n  }.\n\n#'PolicyQualifierInfo'{\n   policyQualifierId,   % oid()\n   qualifier            % string() | #'UserNotice'{}\n  }.\n\n#'UserNotice'{\n   noticeRef,   % #'NoticeReference'{}\n   explicitText % string()\n  }.\n\n#'NoticeReference'{\n   organization,    % string()\n   noticeNumbers    % [pos_integer()]\n  }.\n\n#'PolicyMappings_SEQOF'{\n   issuerDomainPolicy,  % oid()\n   subjectDomainPolicy  % oid()\n  }.\n\n#'Attribute'{\n   type,  % oid()\n   values % [der_encoded()]\n  }).\n\n#'BasicConstraints'{\n   cA,               % boolean()\n   pathLenConstraint % pos_integer()\n  }).\n\n#'NameConstraints'{\n   permittedSubtrees, % [#'GeneralSubtree'{}]\n   excludedSubtrees   % [#'GeneralSubtree'{}]\n  }).\n\n#'GeneralSubtree'{\n   base,    % general_name()\n   minimum, % pos_integer()\n   maximum  % pos_integer()\n  }).\n\n#'PolicyConstraints'{\n   requireExplicitPolicy, % pos_integer()\n   inhibitPolicyMapping   % pos_integer()\n  }).\n\n#'DistributionPoint'{\n   distributionPoint, % {fullName, [general_name()]} | {nameRelativeToCRLIssuer,[#AttributeTypeAndValue{}]}\n   reasons,           % [dist_reason()]\n   cRLIssuer          % [general_name()]\n  }).\n```\n\n[](){: #PrivIntExt }","ref":"public_key_records.html#standard-certificate-extensions"},{"type":"extras","title":"Private Internet Extensions - Public-Key Records","doc":"The private internet extensions OID name atoms and their corresponding value\ntypes are as follows:\n\n| _OID Name_                | _Value Type_                |\n| ------------------------- | --------------------------- |\n| id-pe-authorityInfoAccess | \\[#'AccessDescription'\\{\\}] |\n| id-pe-subjectInfoAccess   | \\[#'AccessDescription'\\{\\}] |\n\n_Table: Private Internet Extensions_\n\n```erlang\n#'AccessDescription'{\n   accessMethod,    % oid()\n   accessLocation   % general_name()\n  }).\n```","ref":"public_key_records.html#private-internet-extensions"},{"type":"extras","title":"CRL and CRL Extensions Profile - Public-Key Records","doc":"Erlang representation of CRL and CRL extensions profile derived from ASN.1\nspecifications and RFC 5280 are as follows:\n\n```erlang\n#'CertificateList'{\n   tbsCertList,        % #'TBSCertList{}\n   signatureAlgorithm, % #'AlgorithmIdentifier'{}\n   signature           % bitstring()\n  }).\n\n#'TBSCertList'{\n   version,             % v2 (if defined)\n   signature,           % #AlgorithmIdentifier{}\n   issuer,              % {rdnSequence, [#AttributeTypeAndValue'{}]}\n   thisUpdate,          % time()\n   nextUpdate,          % time()\n   revokedCertificates, % [#'TBSCertList_revokedCertificates_SEQOF'{}]\n   crlExtensions        % [#'Extension'{}]\n  }).\n\n#'TBSCertList_revokedCertificates_SEQOF'{\n   userCertificate,      % pos_integer()\n   revocationDate,       % timer()\n   crlEntryExtensions    % [#'Extension'{}]\n  }).\n```\n\n[](){: #CRLCertExt }","ref":"public_key_records.html#crl-and-crl-extensions-profile"},{"type":"extras","title":"CRL Extensions - Public-Key Records","doc":"The CRL extensions OID name atoms and their corresponding value types are as\nfollows:\n\n| _OID Name_                     | _Value Type_                                    |\n| ------------------------------ | ----------------------------------------------- |\n| id-ce-authorityKeyIdentifier   | \\#'AuthorityKeyIdentifier\\{\\}                   |\n| id-ce-issuerAltName            | \\{rdnSequence, \\[#AttributeTypeAndValue'\\{\\}]\\} |\n| id-ce-cRLNumber                | pos_integer()                                       |\n| id-ce-deltaCRLIndicator        | pos_integer()                                       |\n| id-ce-issuingDistributionPoint | \\#'IssuingDistributionPoint'\\{\\}                |\n| id-ce-freshestCRL              | \\[#'Distributionpoint'\\{\\}]                     |\n\n_Table: CRL Extensions_\n\nHere, the data type `'IssuingDistributionPoint'` is represented as the following\nErlang record:\n\n```erlang\n#'IssuingDistributionPoint'{\n   distributionPoint,         % {fullName, [general_name()]} | {nameRelativeToCRLIssuer, [#'AttributeTypeAndValue'{}]}\n   onlyContainsUserCerts,     % boolean()\n   onlyContainsCACerts,       % boolean()\n   onlySomeReasons,           % [dist_reason()]\n   indirectCRL,               % boolean()\n   onlyContainsAttributeCerts % boolean()\n  }).\n```\n\n[](){: #CRLEntryExt }","ref":"public_key_records.html#crl-extensions"},{"type":"extras","title":"CRL Entry Extensions - Public-Key Records","doc":"The CRL entry extensions OID name atoms and their corresponding value types are\nas follows:\n\n| _OID Name_                | _Value Type_   |\n| ------------------------- | -------------- |\n| id-ce-cRLReason           | crl_reason()   |\n| id-ce-holdInstructionCode | oid()          |\n| id-ce-invalidityDate      | general_time() |\n| id-ce-certificateIssuer   | general_name() |\n\n_Table: CRL Entry Extensions_\n\nHere:\n\n```erlang\n    crl_reason() = unspecified | keyCompromise | cACompromise\n                 | affiliationChanged | superseded | cessationOfOperation\n                 | certificateHold | removeFromCRL\n                 | privilegeWithdrawn | aACompromise\n```","ref":"public_key_records.html#crl-entry-extensions"},{"type":"extras","title":"PKCS#10 Certification Request - Public-Key Records","doc":"Erlang representation of a PKCS#10 certification request derived from ASN.1\nspecifications and RFC 5280 are as follows:\n\n```erlang\n#'CertificationRequest'{\n   certificationRequestInfo, % #'CertificationRequestInfo'{},\n   signatureAlgorithm,       % #'CertificationRequest_signatureAlgorithm'{}}.\n   signature                 % bitstring()\n  }.\n\n#'CertificationRequestInfo'{\n   version,       % atom(),\n   subject,       % {rdnSequence, [#AttributeTypeAndValue'{}]} ,\n   subjectPKInfo, % #'CertificationRequestInfo_subjectPKInfo'{},\n   attributes     % [#'AttributePKCS-10' {}]\n  }.\n\n#'CertificationRequestInfo_subjectPKInfo'{\n   algorithm,        % #'CertificationRequestInfo_subjectPKInfo_algorithm'{}\n   subjectPublicKey  %  bitstring()\n  }.\n\n#'CertificationRequestInfo_subjectPKInfo_algorithm'{\n   algorithm,  % oid(),\n   parameters  % der_encoded()\n  }.\n\n#'CertificationRequest_signatureAlgorithm'{\n   algorithm,  % oid(),\n   parameters  % der_encoded()\n  }.\n\n#'AttributePKCS-10'{\n   type,   % oid(),\n   values  % [der_encoded()]\n  }.\n```\n[](){: #PKCS10}","ref":"public_key_records.html#pkcs-10-certification-request"},{"type":"extras","title":"Examples","doc":"<!--\n%CopyrightBegin%\n\nCopyright Ericsson AB 2023-2024. All Rights Reserved.\n\nLicensed under the Apache License, Version 2.0 (the \"License\");\nyou may not use this file except in compliance with the License.\nYou may obtain a copy of the License at\n\n    http://www.apache.org/licenses/LICENSE-2.0\n\nUnless required by applicable law or agreed to in writing, software\ndistributed under the License is distributed on an \"AS IS\" BASIS,\nWITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\nSee the License for the specific language governing permissions and\nlimitations under the License.\n\n%CopyrightEnd%\n-->\n# Examples\n\nThis section describes examples of how to use the Public Key API. Keys and\ncertificates used in the following sections are generated only for testing the\nPublic Key application.\n\nSome shell printouts in the following examples are abbreviated for increased\nreadability.","ref":"using_public_key.html"},{"type":"extras","title":"PEM Files - Examples","doc":"Public-key data (keys, certificates, and so on) can be stored in Privacy\nEnhanced Mail (PEM) format. The PEM files have the following structure:\n\n```text\n     \n    -----BEGIN  -----\n      :  \n     \n    -----END  -----\n     \n```\n\nA file can contain several `BEGIN/END` blocks. Text lines between blocks are\nignored. Attributes, if present, are ignored except for `Proc-Type` and\n`DEK-Info`, which are used when `DER` data is encrypted.","ref":"using_public_key.html#pem-files"},{"type":"extras","title":"DSA Private Key - Examples","doc":"A DSA private key can look as follows:\n\n> #### Note {: .info }\n>\n> File handling is not done by the Public Key application.\n\n```erlang\n1> {ok, PemBin} = file:read_file(\"dsa.pem\").\n{ok,<<\"-----BEGIN DSA PRIVATE KEY-----\\nMIIBuw\"...>>}\n```\n\nThe following PEM file has only one entry, a private DSA key:\n\n```erlang\n2>[DSAEntry] =  public_key:pem_decode(PemBin).\n[{'DSAPrivateKey',<<48,130,1,187,2,1,0,2,129,129,0,183,\n                    179,230,217,37,99,144,157,21,228,204,\n                    162,207,61,246,...>>,\n                    not_encrypted}]\n```\n\n```erlang\n3> Key = public_key:pem_entry_decode(DSAEntry).\n#'DSAPrivateKey'{version = 0,\n                 p = 12900045185019966618...6593,\n                 q = 1216700114794736143432235288305776850295620488937,\n                 g = 10442040227452349332...47213,\n                 y = 87256807980030509074...403143,\n                 x = 510968529856012146351317363807366575075645839654}\n```","ref":"using_public_key.html#dsa-private-key"},{"type":"extras","title":"RSA Private Key with Password - Examples","doc":"An RSA private key encrypted with a password can look as follows:\n\n```erlang\n1> {ok, PemBin} = file:read_file(\"rsa.pem\").\n{ok,<<\"Bag Attribute\"...>>}\n```\n\nThe following PEM file has only one entry, a private RSA key:\n\n```erlang\n2>[RSAEntry] = public_key:pem_decode(PemBin).\n[{'RSAPrivateKey',<<224,108,117,203,152,40,15,77,128,126,\n                    221,195,154,249,85,208,202,251,109,\n                    119,120,57,29,89,19,9,...>>,\n                  {\"DES-EDE3-CBC\",<<\"kÙeø¼pµL\">>}}]\n```\n\nIn this following example, the password is `\"abcd1234\"`:\n\n```erlang\n3> Key = public_key:pem_entry_decode(RSAEntry, \"abcd1234\").\n#'RSAPrivateKey'{version = 'two-prime',\n                 modulus = 1112355156729921663373...2737107,\n                 publicExponent = 65537,\n                 privateExponent = 58064406231183...2239766033,\n                 prime1 = 11034766614656598484098...7326883017,\n                 prime2 = 10080459293561036618240...77738643771,\n                 exponent1 = 77928819327425934607...22152984217,\n                 exponent2 = 36287623121853605733...20588523793,\n                 coefficient = 924840412626098444...41820968343,\n                 otherPrimeInfos = asn1_NOVALUE}\n```","ref":"using_public_key.html#rsa-private-key-with-password"},{"type":"extras","title":"X509 Certificates - Examples","doc":"The following is an example of X509 certificates:\n\n```erlang\n1> {ok, PemBin} = file:read_file(\"cacerts.pem\").\n{ok,<<\"-----BEGIN CERTIFICATE-----\\nMIIC7jCCAl\"...>>}\n```\n\nThe following file includes two certificates:\n\n```erlang\n2> [CertEntry1, CertEntry2] = public_key:pem_decode(PemBin).\n[{'Certificate',<<48,130,2,238,48,130,2,87,160,3,2,1,2,2,\n                  9,0,230,145,97,214,191,2,120,150,48,13,\n                  ...>>,\n                not_encrypted},\n {'Certificate',<<48,130,3,200,48,130,3,49,160,3,2,1,2,2,1,\n                  1,48,13,6,9,42,134,72,134,247,...>>,\n                not_encrypted}]\n```\n\nCertificates can be decoded as usual:\n\n```erlang\n2> Cert = public_key:pem_entry_decode(CertEntry1).\n#'Certificate'{\n    tbsCertificate =\n        #'TBSCertificate'{\n            version = v3,serialNumber = 16614168075301976214,\n            signature =\n                #'AlgorithmIdentifier'{\n                    algorithm = {1,2,840,113549,1,1,5},\n                    parameters = <<5,0>>},\n            issuer =\n                {rdnSequence,\n                    [[#'AttributeTypeAndValue'{\n                          type = {2,5,4,3},\n                          value = <<19,8,101,114,108,97,110,103,67,65>>}],\n                     [#'AttributeTypeAndValue'{\n                          type = {2,5,4,11},\n                          value = <<19,10,69,114,108,97,110,103,32,79,84,80>>}],\n                     [#'AttributeTypeAndValue'{\n                          type = {2,5,4,10},\n                          value = <<19,11,69,114,105,99,115,115,111,110,32,65,66>>}],\n                     [#'AttributeTypeAndValue'{\n                          type = {2,5,4,7},\n                          value = <<19,9,83,116,111,99,107,104,111,108,109>>}],\n                     [#'AttributeTypeAndValue'{\n                          type = {2,5,4,6},\n                          value = <<19,2,83,69>>}],\n                     [#'AttributeTypeAndValue'{\n                          type = {1,2,840,113549,1,9,1},\n                          value = <<22,22,112,101,116,101,114,64,101,114,...>>}]]},\n            validity =\n                #'Validity'{\n                    notBefore = {utcTime,\"080109082929Z\"},\n                    notAfter = {utcTime,\"080208082929Z\"}},\n            subject =\n                {rdnSequence,\n                    [[#'AttributeTypeAndValue'{\n                          type = {2,5,4,3},\n                          value = <<19,8,101,114,108,97,110,103,67,65>>}],\n                     [#'AttributeTypeAndValue'{\n                          type = {2,5,4,11},\n                          value = <<19,10,69,114,108,97,110,103,32,79,84,80>>}],\n                     [#'AttributeTypeAndValue'{\n                          type = {2,5,4,10},\n                          value = <<19,11,69,114,105,99,115,115,111,110,32,...>>}],\n                     [#'AttributeTypeAndValue'{\n                          type = {2,5,4,7},\n                          value = <<19,9,83,116,111,99,107,104,111,108,...>>}],\n                     [#'AttributeTypeAndValue'{\n                          type = {2,5,4,6},\n                          value = <<19,2,83,69>>}],\n                     [#'AttributeTypeAndValue'{\n                          type = {1,2,840,113549,1,9,1},\n                          value = <<22,22,112,101,116,101,114,64,...>>}]]},\n            subjectPublicKeyInfo =\n                #'SubjectPublicKeyInfo'{\n                    algorithm =\n                        #'AlgorithmIdentifier'{\n                            algorithm = {1,2,840,113549,1,1,1},\n                            parameters = <<5,0>>},\n                    subjectPublicKey =\n                        {0,<<48,129,137,2,129,129,0,203,209,187,77,73,231,90,...>>}},\n            issuerUniqueID = asn1_NOVALUE,\n            subjectUniqueID = asn1_NOVALUE,\n            extensions =\n                [#'Extension'{\n                     extnID = {2,5,29,19},\n                     critical = true,\n                     extnValue = [48,3,1,1,255]},\n                 #'Extension'{\n                     extnID = {2,5,29,15},\n                     critical = false,\n                     extnValue = [3,2,1,6]},\n                 #'Extension'{\n                     extnID = {2,5,29,14},\n                     critical = false,\n                     extnValue = [4,20,27,217,65,152,6,30,142|...]},\n                 #'Extension'{\n                     extnID = {2,5,29,17},\n                     critical = false,\n                     extnValue = [48,24,129,22,112,101,116,101|...]}]},\n    signatureAlgorithm =\n        #'AlgorithmIdentifier'{\n            algorithm = {1,2,840,113549,1,1,5},\n            parameters = <<5,0>>},\n    signature =\n    <<163,186,7,163,216,152,63,47,154,234,139,73,154,96,120,\n    165,2,52,196,195,109,167,192,...>>}\n```\n\nParts of certificates can be decoded with `public_key:der_decode/2`, using the\nASN.1 type of that part. However, an application-specific certificate extension\nrequires application-specific ASN.1 decode/encode-functions. In the recent\nexample, the first value of `rdnSequence` is of ASN.1 type\n`'X520CommonName'. ({2,5,4,3} = ?id-at-commonName)`:\n\n```erlang\npublic_key:der_decode('X520CommonName', <<19,8,101,114,108,97,110,103,67,65>>).\n{printableString,\"erlangCA\"}\n```\n\nHowever, certificates can also be decoded using `pkix_decode_cert/2`, which can\ncustomize and recursively decode standard parts of a certificate:\n\n```erlang\n3> {_, DerCert, _} = CertEntry1.\n```\n\n```erlang\n4> public_key:pkix_decode_cert(DerCert, otp).\n#'OTPCertificate'{\n    tbsCertificate =\n        #'OTPTBSCertificate'{\n            version = v3,serialNumber = 16614168075301976214,\n            signature =\n                #'SignatureAlgorithm'{\n                    algorithm = {1,2,840,113549,1,1,5},\n                    parameters = 'NULL'},\n            issuer =\n                {rdnSequence,\n                    [[#'AttributeTypeAndValue'{\n                          type = {2,5,4,3},\n                          value = {printableString,\"erlangCA\"}}],\n                     [#'AttributeTypeAndValue'{\n                          type = {2,5,4,11},\n                          value = {printableString,\"Erlang OTP\"}}],\n                     [#'AttributeTypeAndValue'{\n                          type = {2,5,4,10},\n                          value = {printableString,\"Ericsson AB\"}}],\n                     [#'AttributeTypeAndValue'{\n                          type = {2,5,4,7},\n                          value = {printableString,\"Stockholm\"}}],\n                     [#'AttributeTypeAndValue'{type = {2,5,4,6},value = \"SE\"}],\n                     [#'AttributeTypeAndValue'{\n                          type = {1,2,840,113549,1,9,1},\n                          value = \"peter@erix.ericsson.se\"}]]},\n            validity =\n                #'Validity'{\n                    notBefore = {utcTime,\"080109082929Z\"},\n                    notAfter = {utcTime,\"080208082929Z\"}},\n            subject =\n                {rdnSequence,\n                    [[#'AttributeTypeAndValue'{\n                          type = {2,5,4,3},\n                          value = {printableString,\"erlangCA\"}}],\n                     [#'AttributeTypeAndValue'{\n                          type = {2,5,4,11},\n                          value = {printableString,\"Erlang OTP\"}}],\n                     [#'AttributeTypeAndValue'{\n                          type = {2,5,4,10},\n                          value = {printableString,\"Ericsson AB\"}}],\n                     [#'AttributeTypeAndValue'{\n                          type = {2,5,4,7},\n                          value = {printableString,\"Stockholm\"}}],\n                     [#'AttributeTypeAndValue'{type = {2,5,4,6},value = \"SE\"}],\n                     [#'AttributeTypeAndValue'{\n                          type = {1,2,840,113549,1,9,1},\n                          value = \"peter@erix.ericsson.se\"}]]},\n            subjectPublicKeyInfo =\n                #'OTPSubjectPublicKeyInfo'{\n                    algorithm =\n                        #'PublicKeyAlgorithm'{\n                            algorithm = {1,2,840,113549,1,1,1},\n                            parameters = 'NULL'},\n                    subjectPublicKey =\n                        #'RSAPublicKey'{\n                            modulus =\n                                1431267547247997...37419,\n                            publicExponent = 65537}},\n            issuerUniqueID = asn1_NOVALUE,\n            subjectUniqueID = asn1_NOVALUE,\n            extensions =\n                [#'Extension'{\n                     extnID = {2,5,29,19},\n                     critical = true,\n                     extnValue =\n                         #'BasicConstraints'{\n                             cA = true,pathLenConstraint = asn1_NOVALUE}},\n                 #'Extension'{\n                     extnID = {2,5,29,15},\n                     critical = false,\n                     extnValue = [keyCertSign,cRLSign]},\n                 #'Extension'{\n                     extnID = {2,5,29,14},\n                     critical = false,\n                     extnValue = [27,217,65,152,6,30,142,132,245|...]},\n                 #'Extension'{\n                     extnID = {2,5,29,17},\n                     critical = false,\n                     extnValue = [{rfc822Name,\"peter@erix.ericsson.se\"}]}]},\n    signatureAlgorithm =\n        #'SignatureAlgorithm'{\n            algorithm = {1,2,840,113549,1,1,5},\n            parameters = 'NULL'},\n    signature =\n         <<163,186,7,163,216,152,63,47,154,234,139,73,154,96,120,\n           165,2,52,196,195,109,167,192,...>>}\n```\n\nThis call is equivalent to `public_key:pem_entry_decode(CertEntry1)`:\n\n```erlang\n5> public_key:pkix_decode_cert(DerCert, plain).\n#'Certificate'{ ...}\n```","ref":"using_public_key.html#x509-certificates"},{"type":"extras","title":"Encoding Public-Key Data to PEM Format - Examples","doc":"If you have public-key data and want to create a PEM file this can be done by\ncalling functions `public_key:pem_entry_encode/2` and `pem_encode/1` and saving\nthe result to a file. For example, assume that you have\n`PubKey = 'RSAPublicKey'{}`. Then you can create a PEM-\"RSA PUBLIC KEY\" file\n(ASN.1 type `'RSAPublicKey'`) or a PEM-\"PUBLIC KEY\" file\n(`'SubjectPublicKeyInfo'` ASN.1 type).\n\nThe second element of the PEM-entry is the ASN.1 `DER` encoded key data:\n\n```erlang\n1> PemEntry = public_key:pem_entry_encode('RSAPublicKey', RSAPubKey).\n{'RSAPublicKey', <<48,72,...>>, not_encrypted}\n\n2> PemBin = public_key:pem_encode([PemEntry]).\n<<\"-----BEGIN RSA PUBLIC KEY-----\\nMEgC...>>\n\n3> file:write_file(\"rsa_pub_key.pem\", PemBin).\nok\n```\n\nor:\n\n```erlang\n1> PemEntry = public_key:pem_entry_encode('SubjectPublicKeyInfo', RSAPubKey).\n{'SubjectPublicKeyInfo', <<48,92...>>, not_encrypted}\n\n2> PemBin = public_key:pem_encode([PemEntry]).\n<<\"-----BEGIN PUBLIC KEY-----\\nMFw...>>\n\n3> file:write_file(\"pub_key.pem\", PemBin).\nok\n```","ref":"using_public_key.html#encoding-public-key-data-to-pem-format"},{"type":"extras","title":"RSA Public-Key Cryptography - Examples","doc":"Suppose you have the following private key and a corresponding public key:\n\n- `PrivateKey = #'RSAPrivateKey{}'` and the plaintext `Msg = binary()`\n- `PublicKey = #'RSAPublicKey'{}`\n\nThen you can proceed as follows:\n\nEncrypt with the private key:\n\n```erlang\nRsaEncrypted = public_key:encrypt_private(Msg, PrivateKey),\nMsg = public_key:decrypt_public(RsaEncrypted, PublicKey),\n```\n\nEncrypt with the public key:\n\n```erlang\nRsaEncrypted = public_key:encrypt_public(Msg, PublicKey),\nMsg = public_key:decrypt_private(RsaEncrypted, PrivateKey),\n```\n\n> #### Note {: .info }\n>\n> You normally do only one of the encrypt or decrypt operations, and the peer\n> does the other. This normally used in legacy applications as a primitive\n> digital signature.\n\n> #### Warning {: .warning }\n>\n> This legacy algorithm is broken although there exists a software prevention\n> when using appropriate OpenSSL cryptolib with Erlang/OTP it is hard to\n> guarantee security and we strongly recommend not using it.","ref":"using_public_key.html#rsa-public-key-cryptography"},{"type":"extras","title":"Digital Signatures - Examples","doc":"Suppose you have the following private key and a corresponding public key:\n\n- `PrivateKey = #'RSAPrivateKey{}'` or `#'DSAPrivateKey'{}` and the plaintext\n  `Msg = binary()`\n- `PublicKey = #'RSAPublicKey'{}` or `{integer(), #'DssParams'{}}`\n\nThen you can proceed as follows:\n\n```erlang\nSignature = public_key:sign(Msg, sha, PrivateKey),\ntrue = public_key:verify(Msg, sha, Signature, PublicKey),\n```\n\n> #### Note {: .info }\n>\n> You normally do only one of the sign or verify operations, and the peer does\n> the other.\n\nIt can be appropriate to calculate the message digest before calling `sign` or\n`verify`, and then use `none` as second argument:\n\n```erlang\nDigest = crypto:sha(Msg),\nSignature = public_key:sign(Digest, none, PrivateKey),\ntrue = public_key:verify(Digest, none, Signature, PublicKey),\n```\n\n[](){: #verify_hostname }","ref":"using_public_key.html#digital-signatures"},{"type":"extras","title":"Verifying a certificate hostname - Examples","doc":"","ref":"using_public_key.html#verifying-a-certificate-hostname"},{"type":"extras","title":"Background - Examples","doc":"When a client checks a server certificate there are a number of checks available\nlike checks that the certificate is not revoked, not forged or not out-of-date.\n\nThere are however attacks that are not detected by those checks. Suppose a bad\nguy has succeeded with a DNS infection. Then the client could believe it is\nconnecting to one host but ends up at another but evil one. Though it is evil,\nit could have a perfectly legal certificate\\! The certificate has a valid\nsignature, it is not revoked, the certificate chain is not faked and has a\ntrusted root and so on.\n\nTo detect that the server is not the intended one, the client must additionally\nperform a _hostname verification_. This procedure is described in\n[RFC 6125](https://tools.ietf.org/html/rfc6125). The idea is that the\ncertificate lists the hostnames it could be fetched from. This is checked by the\ncertificate issuer when the certificate is signed. So if the certificate is\nissued by a trusted root the client could trust the host names signed in it.\n\nThere is a default hostname matching procedure defined in\n[RFC 6125, section 6](https://tools.ietf.org/html/rfc6125#section/6) as well as\nprotocol dependent variations defined in\n[RFC 6125 appendix B](https://tools.ietf.org/html/rfc6125#appendix-B). The\ndefault procedure is implemented in\n[public_key:pkix_verify_hostname/2,3](`public_key:pkix_verify_hostname/2`). It\nis possible for a client to hook in modified rules using the options list.\n\nSome terminology is needed: the certificate presents hostname(s) on which it is\nvalid. Those are called _Presented IDs_. The hostname(s) the client believes it\nconnects to are called _Reference IDs_. The matching rules aims to verify that\nthere is at least one of the Reference IDs that matches one of the Presented\nIDs. If not, the verification fails.\n\nThe IDs contains normal fully qualified domain names like e.g `foo.example.com`,\nbut IP addresses are not recommended. The rfc describes why this is not\nrecommended as well as security considerations about how to acquire the\nReference IDs.\n\nInternationalized domain names are not supported.","ref":"using_public_key.html#background"},{"type":"extras","title":"The verification process - Examples","doc":"Traditionally the Presented IDs were found in the `Subject` certificate field as\n`CN` names. This is still quite common. When printing a certificate they show up\nas:\n\n```text\n $ openssl x509 -text < cert.pem\n ...\n Subject: C=SE, CN=example.com, CN=*.example.com, O=erlang.org\n ...\n```\n\nThe example `Subject` field has one C, two CN and one O part. It is only the CN\n(Common Name) that is used by hostname verification. The two other (C and O) is\nnot used here even when they contain a domain name like the O part. The C and O\nparts are defined elsewhere and meaningful only for other functions.\n\nIn the example the Presented IDs are `example.com` as well as hostnames matching\n`*.example.com`. For example `foo.example.com` and `bar.example.com` both\nmatches but not `foo.bar.example.com`. The name `erlang.org` matches neither\nsince it is not a CN.\n\nIn case where the Presented IDs are fetched from the `Subject` certificate\nfield, the names may contain wildcard characters. The function handles this as\ndefined in\n[chapter 6.4.3 in RFC 6125](https://tools.ietf.org/html/rfc6125#section-6.4.3).\n\nThere may only be one wildcard character and that is in the first label, for\nexample: `*.example.com`. This matches `foo.example.com` but neither\n`example.com` nor `foo.bar.example.com`.\n\nThere may be label characters before or/and after the wildcard. For example:\n`a*d.example.com` matches `abcd.example.com` and `ad.example.com`, but not\n`ab.cd.example.com`.\n\nIn the previous example there is no indication of which protocols are expected.\nSo a client has no indication of whether it is a web server, an ldap server or\nmaybe a sip server it is connected to. There are fields in the certificate that\ncan indicate this. To be more exact, the rfc introduces the usage of the\n`X509v3 Subject Alternative Name` in the `X509v3 extensions` field:\n\n```text\n $ openssl x509 -text < cert.pem\n ...\n X509v3 extensions:\n     X509v3 Subject Alternative Name:\n         DNS:kb.example.org, URI:https://www.example.org\n ...\n```\n\nHere `kb.example.org` serves any protocol while `www.example.org` presents a\nsecure web server.\n\nThe next example has both `Subject` and `Subject Alternate Name` present:\n\n```text\n $ openssl x509 -text < cert.pem\n ...\n Subject: C=SE, CN=example.com, CN=*.example.com, O=erlang.org\n ...\n X509v3 extensions:\n     X509v3 Subject Alternative Name:\n         DNS:kb.example.org, URI:https://www.example.org\n ...\n```\n\nThe RFC states that if a certificate defines Reference IDs in a\n`Subject Alternate Name` field, the `Subject` field MUST NOT be used for host\nname checking, even if it contains valid CN names. Therefore only\n`kb.example.org` and `https://www.example.org` matches. The match fails both for\n`example.com` and `foo.example.com` because they are in the `Subject` field\nwhich is not checked because the `Subject Alternate Name` field is present.\n\n[](){: #verify_hostname_examples }","ref":"using_public_key.html#the-verification-process"},{"type":"extras","title":"Function call examples - Examples","doc":"> #### Note {: .info }\n>\n> Other applications like ssl/tls or https might have options that are passed\n> down to the `public_key:pkix_verify_hostname`. You will probably not have to\n> call it directly\n\nSuppose our client expects to connect to the web server https://www.example.net.\nThis URI is therefore the Reference IDs of the client. The call will be:\n\n```erlang\n public_key:pkix_verify_hostname(CertFromHost,\n                                 [{uri_id, \"https://www.example.net\"}\n                                 ]).\n```\n\nThe call will return `true` or `false` depending on the check. The caller do not\nneed to handle the matching rules in the rfc. The matching will proceed as:\n\n- If there is a `Subject Alternate Name` field, the `{uri_id,string()}` in the\n  function call will be compared to any `{uniformResourceIdentifier,string()}`\n  in the Certificate field. If the two `strings()` are equal (case insensitive),\n  there is a match. The same applies for any `{dns_id,string()}` in the call\n  which is compared with all `{dNSName,string()}` in the Certificate field.\n- If there is NO `Subject Alternate Name` field, the `Subject` field will be\n  checked. All `CN` names will be compared to all hostnames _extracted_ from\n  `{uri_id,string()}` and from `{dns_id,string()}`.","ref":"using_public_key.html#function-call-examples"},{"type":"extras","title":"Extending the search mechanism - Examples","doc":"The caller can use own extraction and matching rules. This is done with the two\noptions `fqdn_fun` and `match_fun`.\n\n[](){: #hostname_extraction }\n\n#### Hostname extraction\n\nThe `fqdn_fun` extracts hostnames (Fully Qualified Domain Names) from uri_id or\nother ReferenceIDs that are not pre-defined in the public_key function. Suppose\nyou have some URI with a very special protocol-part: `myspecial://example.com\"`.\nSince this a non-standard URI there will be no hostname extracted for matching\nCN-names in the `Subject`.\n\nTo \"teach\" the function how to extract, you can give a fun which replaces the\ndefault extraction function. The `fqdn_fun` takes one argument and returns\neither a `t:string/0` to be matched to each CN-name or the atom `default` which\nwill invoke the default fqdn extraction function. The return value `undefined`\nremoves the current URI from the fqdn extraction.\n\n```erlang\n ...\n Extract = fun({uri_id, \"myspecial://\"++HostName}) -> HostName;\n              (_Else) -> default\n           end,\n ...\n public_key:pkix_verify_hostname(CertFromHost, RefIDs,\n                                 [{fqdn_fun, Extract}])\n ...\n```\n\n[](){: #redefining_match_op }\n\n#### Re-defining the match operation\n\nThe default matching handles dns_id and uri_id. In an uri_id the value is tested\nfor equality with a value from the `Subject Alternate Name`. If some other kind\nof matching is needed, use the `match_fun` option.\n\nThe `match_fun` takes two arguments and returns either `true`, `false` or\n`default`. The value `default` will invoke the default match function.\n\n```erlang\n ...\n Match = fun({uri_id,\"myspecial://\"++A},\n             {uniformResourceIdentifier,\"myspecial://\"++B}) ->\n                                                    my_match(A,B);\n            (_RefID, _PresentedID) ->\n                                default\n         end,\n ...\n public_key:pkix_verify_hostname(CertFromHost, RefIDs,\n                                 [{match_fun, Match}]),\n ...\n```\n\nIn case of a match operation between a ReferenceID and a CN value from the\n`Subject` field, the first argument to the fun is the extracted hostname from\nthe ReferenceID, and the second argument is the tuple `{cn, string()}` taken\nfrom the `Subject` field. That makes it possible to have separate matching rules\nfor Presented IDs from the `Subject` field and from the `Subject Alternate Name`\nfield.\n\nThe default matching transformes the ascii values in strings to lowercase before\ncomparing. The `match_fun` is however called without any transformation applied\nto the strings. The reason is to enable the user to do unforeseen handling of\nthe strings where the original format is needed.\n\n### \"Pinning\" a Certificate\n\nThe [RFC 6125](https://tools.ietf.org/html/rfc6125) defines _pinning_ as:\n\n> \"The act of establishing a cached name association between the application\n> service's certificate and one of the client's reference identifiers, despite\n> the fact that none of the presented identifiers matches the given reference\n> identifier. ...\"\n\nThe purpose is to have a mechanism for a human to accept an otherwise faulty\nCertificate. In for example a web browser, you could get a question like\n\n> Warning: you wanted to visit the site www.example.com, but the certificate is\n> for shop.example.com. Accept anyway (yes/no)?\"\n\nThis could be accomplished with the option `fail_callback` which will be called\nif the hostname verification fails:\n\n```erlang\n -include_lib(\"public_key/include/public_key.hrl\"). % Record def\n ...\n Fail = fun(#'OTPCertificate'{}=C) ->\n              case in_my_cache(C) orelse my_accept(C) of\n                  true ->\n                       enter_my_cache(C),\n                       true;\n                  false ->\n                       false\n         end,\n ...\n public_key:pkix_verify_hostname(CertFromHost, RefIDs,\n                                 [{fail_callback, Fail}]),\n ...\n```","ref":"using_public_key.html#extending-the-search-mechanism"}],"content_type":"text/plain","producer":{"name":"ex_doc","version":[48,46,51,52,46,49]}}