/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.internal.impl;

import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;

class SimpleDigest {
    private static final String[] HASH_ALGOS = new String[]{"SHA-1", "MD5"};
    private final MessageDigest digest;

    SimpleDigest() {
        MessageDigest md = null;
        for (String hashAlgo : HASH_ALGOS) {
            try {
                md = MessageDigest.getInstance(hashAlgo);
                break;
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            }
        }
        if (md == null) {
            throw new IllegalStateException("Not supported digests: " + Arrays.toString(HASH_ALGOS));
        }
        this.digest = md;
    }

    public void update(String data2) {
        if (data2 == null || data2.isEmpty()) {
            return;
        }
        this.digest.update(data2.getBytes(StandardCharsets.UTF_8));
    }

    public String digest() {
        byte[] bytes2;
        StringBuilder buffer2 = new StringBuilder(64);
        for (byte aByte : bytes2 = this.digest.digest()) {
            int b = aByte & 0xFF;
            if (b < 16) {
                buffer2.append('0');
            }
            buffer2.append(Integer.toHexString(b));
        }
        return buffer2.toString();
    }
}

