# t20009 - Smart pointer dereference call expression test case
## Config
```yaml
diagrams:
  t20009_sequence:
    type: sequence
    glob:
      - t20009.cc
    include:
      namespaces:
        - clanguml::t20009
    using_namespace: clanguml::t20009
    from:
      - function: "clanguml::t20009::tmain()"
```
## Source code
File `tests/t20009/t20009.cc`
```cpp
#include <memory>
#include <string>

namespace clanguml {
namespace t20009 {
template <typename T> struct A {
    void a(T arg) { }
};

template <typename T> struct B {
    void b(T arg) { a->a(arg); }

    std::unique_ptr<A<T>> a;
};

using BFloatPtr = std::shared_ptr<B<float>>;

void tmain()
{
    std::shared_ptr<B<std::string>> bstring;
    auto bint = std::make_unique<B<int>>();
    BFloatPtr bfloat;

    bstring->b("b");
    bint.get()->b(42);
    bfloat->b(1.0);
}
}
}
```
## Generated PlantUML diagrams
![t20009_sequence](./t20009_sequence.svg "Smart pointer dereference call expression test case")
## Generated Mermaid diagrams
![t20009_sequence](./t20009_sequence_mermaid.svg "Smart pointer dereference call expression test case")
## Generated JSON models
```json
{
  "diagram_type": "sequence",
  "name": "t20009_sequence",
  "participants": [
    {
      "display_name": "tmain()",
      "full_name": "clanguml::t20009::tmain()",
      "id": "6328533492851038858",
      "name": "tmain",
      "namespace": "clanguml::t20009",
      "source_location": {
        "column": 6,
        "file": "t20009.cc",
        "line": 18,
        "translation_unit": "t20009.cc"
      },
      "type": "function"
    },
    {
      "activities": [
        {
          "display_name": "b(std::string)",
          "full_name": "clanguml::t20009::B<std::string>::b(std::string)",
          "id": "15682131055272727033",
          "name": "b",
          "namespace": "clanguml::t20009::B<std",
          "source_location": {
            "column": 10,
            "file": "t20009.cc",
            "line": 11,
            "translation_unit": "t20009.cc"
          },
          "type": "method"
        }
      ],
      "display_name": "B<std::string>",
      "full_name": "clanguml::t20009::B<std::string>",
      "id": "3606508590885021433",
      "name": "B",
      "namespace": "clanguml::t20009",
      "source_location": {
        "column": 30,
        "file": "t20009.cc",
        "line": 10,
        "translation_unit": "t20009.cc"
      },
      "type": "class"
    },
    {
      "activities": [
        {
          "display_name": "a(std::string)",
          "full_name": "clanguml::t20009::A<std::string>::a(std::string)",
          "id": "13734206775742090288",
          "name": "a",
          "namespace": "clanguml::t20009::A<std",
          "source_location": {
            "column": 10,
            "file": "t20009.cc",
            "line": 7,
            "translation_unit": "t20009.cc"
          },
          "type": "method"
        }
      ],
      "display_name": "A<std::string>",
      "full_name": "clanguml::t20009::A<std::string>",
      "id": "9579230486404665750",
      "name": "A",
      "namespace": "clanguml::t20009",
      "source_location": {
        "column": 30,
        "file": "t20009.cc",
        "line": 6,
        "translation_unit": "t20009.cc"
      },
      "type": "class"
    },
    {
      "activities": [
        {
          "display_name": "b(int)",
          "full_name": "clanguml::t20009::B<int>::b(int)",
          "id": "5284463427193629079",
          "name": "b",
          "namespace": "clanguml::t20009",
          "source_location": {
            "column": 10,
            "file": "t20009.cc",
            "line": 11,
            "translation_unit": "t20009.cc"
          },
          "type": "method"
        }
      ],
      "display_name": "B<int>",
      "full_name": "clanguml::t20009::B<int>",
      "id": "16018485456201192723",
      "name": "B",
      "namespace": "clanguml::t20009",
      "source_location": {
        "column": 30,
        "file": "t20009.cc",
        "line": 10,
        "translation_unit": "t20009.cc"
      },
      "type": "class"
    },
    {
      "activities": [
        {
          "display_name": "a(int)",
          "full_name": "clanguml::t20009::A<int>::a(int)",
          "id": "16245035638486440742",
          "name": "a",
          "namespace": "clanguml::t20009",
          "source_location": {
            "column": 10,
            "file": "t20009.cc",
            "line": 7,
            "translation_unit": "t20009.cc"
          },
          "type": "method"
        }
      ],
      "display_name": "A<int>",
      "full_name": "clanguml::t20009::A<int>",
      "id": "9827990036466904972",
      "name": "A",
      "namespace": "clanguml::t20009",
      "source_location": {
        "column": 30,
        "file": "t20009.cc",
        "line": 6,
        "translation_unit": "t20009.cc"
      },
      "type": "class"
    },
    {
      "activities": [
        {
          "display_name": "b(float)",
          "full_name": "clanguml::t20009::B<float>::b(float)",
          "id": "2942441305084666258",
          "name": "b",
          "namespace": "clanguml::t20009",
          "source_location": {
            "column": 10,
            "file": "t20009.cc",
            "line": 11,
            "translation_unit": "t20009.cc"
          },
          "type": "method"
        }
      ],
      "display_name": "B<float>",
      "full_name": "clanguml::t20009::B<float>",
      "id": "11695218629277465628",
      "name": "B",
      "namespace": "clanguml::t20009",
      "source_location": {
        "column": 30,
        "file": "t20009.cc",
        "line": 10,
        "translation_unit": "t20009.cc"
      },
      "type": "class"
    },
    {
      "activities": [
        {
          "display_name": "a(float)",
          "full_name": "clanguml::t20009::A<float>::a(float)",
          "id": "13149871291924650350",
          "name": "a",
          "namespace": "clanguml::t20009",
          "source_location": {
            "column": 10,
            "file": "t20009.cc",
            "line": 7,
            "translation_unit": "t20009.cc"
          },
          "type": "method"
        }
      ],
      "display_name": "A<float>",
      "full_name": "clanguml::t20009::A<float>",
      "id": "9948161970475535740",
      "name": "A",
      "namespace": "clanguml::t20009",
      "source_location": {
        "column": 30,
        "file": "t20009.cc",
        "line": 6,
        "translation_unit": "t20009.cc"
      },
      "type": "class"
    }
  ],
  "sequences": [
    {
      "from": {
        "id": "6328533492851038858",
        "location": "clanguml::t20009::tmain()"
      },
      "messages": [
        {
          "from": {
            "activity_id": "6328533492851038858",
            "participant_id": "6328533492851038858"
          },
          "name": "b(std::string)",
          "return_type": "void",
          "scope": "normal",
          "source_location": {
            "column": 5,
            "file": "t20009.cc",
            "line": 24,
            "translation_unit": "t20009.cc"
          },
          "to": {
            "activity_id": "15682131055272727033",
            "participant_id": "3606508590885021433"
          },
          "type": "message"
        },
        {
          "from": {
            "activity_id": "15682131055272727033",
            "participant_id": "3606508590885021433"
          },
          "name": "a(std::string)",
          "return_type": "void",
          "scope": "normal",
          "source_location": {
            "column": 21,
            "file": "t20009.cc",
            "line": 11,
            "translation_unit": "t20009.cc"
          },
          "to": {
            "activity_id": "13734206775742090288",
            "participant_id": "9579230486404665750"
          },
          "type": "message"
        },
        {
          "from": {
            "activity_id": "6328533492851038858",
            "participant_id": "6328533492851038858"
          },
          "name": "b(int)",
          "return_type": "void",
          "scope": "normal",
          "source_location": {
            "column": 5,
            "file": "t20009.cc",
            "line": 25,
            "translation_unit": "t20009.cc"
          },
          "to": {
            "activity_id": "5284463427193629079",
            "participant_id": "16018485456201192723"
          },
          "type": "message"
        },
        {
          "from": {
            "activity_id": "5284463427193629079",
            "participant_id": "16018485456201192723"
          },
          "name": "a(int)",
          "return_type": "void",
          "scope": "normal",
          "source_location": {
            "column": 21,
            "file": "t20009.cc",
            "line": 11,
            "translation_unit": "t20009.cc"
          },
          "to": {
            "activity_id": "16245035638486440742",
            "participant_id": "9827990036466904972"
          },
          "type": "message"
        },
        {
          "from": {
            "activity_id": "6328533492851038858",
            "participant_id": "6328533492851038858"
          },
          "name": "b(float)",
          "return_type": "void",
          "scope": "normal",
          "source_location": {
            "column": 5,
            "file": "t20009.cc",
            "line": 26,
            "translation_unit": "t20009.cc"
          },
          "to": {
            "activity_id": "2942441305084666258",
            "participant_id": "11695218629277465628"
          },
          "type": "message"
        },
        {
          "from": {
            "activity_id": "2942441305084666258",
            "participant_id": "11695218629277465628"
          },
          "name": "a(float)",
          "return_type": "void",
          "scope": "normal",
          "source_location": {
            "column": 21,
            "file": "t20009.cc",
            "line": 11,
            "translation_unit": "t20009.cc"
          },
          "to": {
            "activity_id": "13149871291924650350",
            "participant_id": "9948161970475535740"
          },
          "type": "message"
        }
      ]
    }
  ],
  "using_namespace": "clanguml::t20009"
}
```
## Generated GraphML models
