# t00029 - PlantUML skip decorator test case
## Config
```yaml
diagrams:
  t00029_class:
    type: class
    glob:
      - t00029.cc
    using_namespace: clanguml::t00029
    include:
      namespaces:
        - clanguml::t00029

```
## Source code
File `tests/t00029/t00029.cc`
```cpp
#include <memory>
#include <vector>

namespace clanguml {
namespace t00029 {

class A { };

/// \uml{skip}
class B { };

template <typename T> class C {
    T param;
};

/// @uml{skip:t00029_class}
template <typename T> class D {
    T param;
};

enum class E { one, two, three };

/// \uml{skip}
enum class F { red, green, blue };

class G1 { };

class G2 { };

class G3 { };

class G4 { };

struct R {
    G1 g1;

    /// \uml{skip}
    G2 g2;

    /// \uml{skiprelationship}
    G3 &g3;

    std::shared_ptr<G4> g4;
};

} // namespace t00029
} // namespace clanguml

```
## Generated PlantUML diagrams
![t00029_class](./t00029_class.svg "PlantUML skip decorator test case")
## Generated Mermaid diagrams
![t00029_class](./t00029_class_mermaid.svg "PlantUML skip decorator test case")
## Generated JSON models
```json
{
  "diagram_type": "class",
  "elements": [
    {
      "bases": [],
      "display_name": "A",
      "id": "15767958614130952114",
      "is_abstract": false,
      "is_nested": false,
      "is_struct": false,
      "is_template": false,
      "is_union": false,
      "members": [],
      "methods": [],
      "name": "A",
      "namespace": "clanguml::t00029",
      "source_location": {
        "column": 7,
        "file": "t00029.cc",
        "line": 7,
        "translation_unit": "t00029.cc"
      },
      "template_parameters": [],
      "type": "class"
    },
    {
      "bases": [],
      "display_name": "C<T>",
      "id": "4350131114162787762",
      "is_abstract": false,
      "is_nested": false,
      "is_struct": false,
      "is_template": true,
      "is_union": false,
      "members": [
        {
          "access": "private",
          "is_static": false,
          "name": "param",
          "source_location": {
            "column": 7,
            "file": "t00029.cc",
            "line": 13,
            "translation_unit": "t00029.cc"
          },
          "type": "T"
        }
      ],
      "methods": [],
      "name": "C",
      "namespace": "clanguml::t00029",
      "source_location": {
        "column": 29,
        "file": "t00029.cc",
        "line": 12,
        "translation_unit": "t00029.cc"
      },
      "template_parameters": [
        {
          "is_variadic": false,
          "kind": "template_type",
          "name": "T",
          "template_parameters": []
        }
      ],
      "type": "class"
    },
    {
      "bases": [],
      "comment": {
        "formatted": "@uml{skip:t00029_class}",
        "raw": "/// @uml{skip:t00029_class}"
      },
      "display_name": "D",
      "id": "11975319755435865873",
      "is_abstract": false,
      "is_nested": false,
      "is_struct": false,
      "is_template": false,
      "is_union": false,
      "members": [
        {
          "access": "private",
          "is_static": false,
          "name": "param",
          "source_location": {
            "column": 7,
            "file": "t00029.cc",
            "line": 18,
            "translation_unit": "t00029.cc"
          },
          "type": "T"
        }
      ],
      "methods": [],
      "name": "D",
      "namespace": "clanguml::t00029",
      "source_location": {
        "column": 29,
        "file": "t00029.cc",
        "line": 17,
        "translation_unit": "t00029.cc"
      },
      "template_parameters": [],
      "type": "class"
    },
    {
      "constants": [
        "one",
        "two",
        "three"
      ],
      "display_name": "E",
      "id": "15494984659652737759",
      "is_nested": false,
      "name": "E",
      "namespace": "clanguml::t00029",
      "source_location": {
        "column": 12,
        "file": "t00029.cc",
        "line": 21,
        "translation_unit": "t00029.cc"
      },
      "type": "enum"
    },
    {
      "bases": [],
      "display_name": "G1",
      "id": "15845744510705526108",
      "is_abstract": false,
      "is_nested": false,
      "is_struct": false,
      "is_template": false,
      "is_union": false,
      "members": [],
      "methods": [],
      "name": "G1",
      "namespace": "clanguml::t00029",
      "source_location": {
        "column": 7,
        "file": "t00029.cc",
        "line": 26,
        "translation_unit": "t00029.cc"
      },
      "template_parameters": [],
      "type": "class"
    },
    {
      "bases": [],
      "display_name": "G2",
      "id": "17637017708750132732",
      "is_abstract": false,
      "is_nested": false,
      "is_struct": false,
      "is_template": false,
      "is_union": false,
      "members": [],
      "methods": [],
      "name": "G2",
      "namespace": "clanguml::t00029",
      "source_location": {
        "column": 7,
        "file": "t00029.cc",
        "line": 28,
        "translation_unit": "t00029.cc"
      },
      "template_parameters": [],
      "type": "class"
    },
    {
      "bases": [],
      "display_name": "G3",
      "id": "6137444133320565051",
      "is_abstract": false,
      "is_nested": false,
      "is_struct": false,
      "is_template": false,
      "is_union": false,
      "members": [],
      "methods": [],
      "name": "G3",
      "namespace": "clanguml::t00029",
      "source_location": {
        "column": 7,
        "file": "t00029.cc",
        "line": 30,
        "translation_unit": "t00029.cc"
      },
      "template_parameters": [],
      "type": "class"
    },
    {
      "bases": [],
      "display_name": "G4",
      "id": "5720596983394161714",
      "is_abstract": false,
      "is_nested": false,
      "is_struct": false,
      "is_template": false,
      "is_union": false,
      "members": [],
      "methods": [],
      "name": "G4",
      "namespace": "clanguml::t00029",
      "source_location": {
        "column": 7,
        "file": "t00029.cc",
        "line": 32,
        "translation_unit": "t00029.cc"
      },
      "template_parameters": [],
      "type": "class"
    },
    {
      "bases": [],
      "display_name": "R",
      "id": "2789997853279223281",
      "is_abstract": false,
      "is_nested": false,
      "is_struct": true,
      "is_template": false,
      "is_union": false,
      "members": [
        {
          "access": "public",
          "is_static": false,
          "name": "g1",
          "source_location": {
            "column": 8,
            "file": "t00029.cc",
            "line": 35,
            "translation_unit": "t00029.cc"
          },
          "type": "G1"
        },
        {
          "access": "public",
          "comment": {
            "formatted": "\\uml{skiprelationship}",
            "raw": "/// \\uml{skiprelationship}"
          },
          "is_static": false,
          "name": "g3",
          "source_location": {
            "column": 9,
            "file": "t00029.cc",
            "line": 41,
            "translation_unit": "t00029.cc"
          },
          "type": "G3 &"
        },
        {
          "access": "public",
          "is_static": false,
          "name": "g4",
          "source_location": {
            "column": 25,
            "file": "t00029.cc",
            "line": 43,
            "translation_unit": "t00029.cc"
          },
          "type": "std::shared_ptr<G4>"
        }
      ],
      "methods": [],
      "name": "R",
      "namespace": "clanguml::t00029",
      "source_location": {
        "column": 8,
        "file": "t00029.cc",
        "line": 34,
        "translation_unit": "t00029.cc"
      },
      "template_parameters": [],
      "type": "class"
    }
  ],
  "name": "t00029_class",
  "package_type": "namespace",
  "relationships": [
    {
      "access": "public",
      "destination": "15845744510705526108",
      "label": "g1",
      "source": "2789997853279223281",
      "type": "aggregation"
    },
    {
      "access": "public",
      "destination": "5720596983394161714",
      "label": "g4",
      "source": "2789997853279223281",
      "type": "association"
    }
  ],
  "using_namespace": "clanguml::t00029"
}
```
## Generated GraphML models
```xml
<?xml version="1.0"?>
<graphml xmlns="http://graphml.graphdrawing.org/xmlns" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xsi:schemaLocation="http://graphml.graphdrawing.org/xmlns http://graphml.graphdrawing.org/xmlns/1.0/graphml.xsd">
 <key attr.name="id" attr.type="string" for="graph" id="gd0" />
 <key attr.name="diagram_type" attr.type="string" for="graph" id="gd1" />
 <key attr.name="name" attr.type="string" for="graph" id="gd2" />
 <key attr.name="using_namespace" attr.type="string" for="graph" id="gd3" />
 <key attr.name="id" attr.type="string" for="node" id="nd0" />
 <key attr.name="type" attr.type="string" for="node" id="nd1" />
 <key attr.name="name" attr.type="string" for="node" id="nd2" />
 <key attr.name="stereotype" attr.type="string" for="node" id="nd3" />
 <key attr.name="url" attr.type="string" for="node" id="nd4" />
 <key attr.name="tooltip" attr.type="string" for="node" id="nd5" />
 <key attr.name="is_template" attr.type="boolean" for="node" id="nd6" />
 <key attr.name="type" attr.type="string" for="edge" id="ed0" />
 <key attr.name="access" attr.type="string" for="edge" id="ed1" />
 <key attr.name="label" attr.type="string" for="edge" id="ed2" />
 <key attr.name="url" attr.type="string" for="edge" id="ed3" />
 <graph id="g0" edgedefault="directed" parse.nodeids="canonical" parse.edgeids="canonical" parse.order="nodesfirst">
  <data key="gd3">clanguml::t00029</data>
  <node id="n0">
   <data key="nd1">class</data>
   <data key="nd2"><![CDATA[A]]></data>
   <data key="nd6">false</data>
  </node>
  <node id="n1">
   <data key="nd1">class</data>
   <data key="nd2"><![CDATA[C<T>]]></data>
   <data key="nd6">true</data>
  </node>
  <node id="n2">
   <data key="nd1">class</data>
   <data key="nd2"><![CDATA[D]]></data>
   <data key="nd6">false</data>
  </node>
  <node id="n3">
   <data key="nd1">enum</data>
   <data key="nd2"><![CDATA[E]]></data>
  </node>
  <node id="n4">
   <data key="nd1">class</data>
   <data key="nd2"><![CDATA[G1]]></data>
   <data key="nd6">false</data>
  </node>
  <node id="n5">
   <data key="nd1">class</data>
   <data key="nd2"><![CDATA[G2]]></data>
   <data key="nd6">false</data>
  </node>
  <node id="n6">
   <data key="nd1">class</data>
   <data key="nd2"><![CDATA[G3]]></data>
   <data key="nd6">false</data>
  </node>
  <node id="n7">
   <data key="nd1">class</data>
   <data key="nd2"><![CDATA[G4]]></data>
   <data key="nd6">false</data>
  </node>
  <node id="n8">
   <data key="nd1">class</data>
   <data key="nd2"><![CDATA[R]]></data>
   <data key="nd6">false</data>
  </node>
  <edge id="e0" source="n8" target="n4">
   <data key="ed0">aggregation</data>
   <data key="ed2">g1</data>
   <data key="ed1">public</data>
  </edge>
  <edge id="e1" source="n8" target="n7">
   <data key="ed0">association</data>
   <data key="ed2">g4</data>
   <data key="ed1">public</data>
  </edge>
 </graph>
</graphml>

```
