# Changelog
All notable changes to this project will be documented in this file.

The format is based on [Keep a Changelog](https://keepachangelog.com/en/1.0.0/),
and this project adheres to [Semantic Versioning](https://semver.org/spec/v2.0.0.html).

## [Unreleased]

## [13.0.0-alpha.9](https://github.com/XAMPPRocky/tokei/compare/v13.0.0-alpha.8...v13.0.0-alpha.9) - 2025-07-21

### Other

- Update README.md
- Fix CRLF or mixed CRLF/LF line terminations in Markdown files ([#1219](https://github.com/XAMPPRocky/tokei/pull/1219))
- Fix a minor typo in CLI help text ([#1217](https://github.com/XAMPPRocky/tokei/pull/1217))
- Fix a missing space in CLI help text ([#1218](https://github.com/XAMPPRocky/tokei/pull/1218))
- Relax lifetime constraints in language::embedding ([#1225](https://github.com/XAMPPRocky/tokei/pull/1225))

## [13.0.0-alpha.8](https://github.com/XAMPPRocky/tokei/compare/v13.0.0-alpha.7...v13.0.0-alpha.8) - 2025-01-14

### Other

- add Mojo support ([#1107](https://github.com/XAMPPRocky/tokei/pull/1107)) ([#1185](https://github.com/XAMPPRocky/tokei/pull/1185))
- Add support for 8th language ([#1192](https://github.com/XAMPPRocky/tokei/pull/1192))
- Add support for `Roc` language ([#1197](https://github.com/XAMPPRocky/tokei/pull/1197))
- Add support for Ballerina language ([#1196](https://github.com/XAMPPRocky/tokei/pull/1196))
- Remove 'conf' extension from the Bitbake config. ([#1001](https://github.com/XAMPPRocky/tokei/pull/1001))
- Add support for Cairo language ([#1193](https://github.com/XAMPPRocky/tokei/pull/1193))
- Add support for Uiua language ([#1191](https://github.com/XAMPPRocky/tokei/pull/1191))

## [13.0.0-alpha.7](https://github.com/XAMPPRocky/tokei/compare/v13.0.0-alpha.6...v13.0.0-alpha.7) - 2024-11-10

### Other

- Fix alternative output formats ([#1188](https://github.com/XAMPPRocky/tokei/pull/1188))
- Add missing extension `fsti` for F* ([#1184](https://github.com/XAMPPRocky/tokei/pull/1184))

## [13.0.0-alpha.6](https://github.com/XAMPPRocky/tokei/compare/v13.0.0-alpha.5...v13.0.0-alpha.6) - 2024-10-11

### Added

- add `mbti` extension for MoonBit ([#1168](https://github.com/XAMPPRocky/tokei/pull/1168))

### Other

- Add language definition for Lauterbach PRACTICE Script ([#1162](https://github.com/XAMPPRocky/tokei/pull/1162))
- Add support for justfiles ([#1175](https://github.com/XAMPPRocky/tokei/pull/1175))
- Add Virgil ([#1178](https://github.com/XAMPPRocky/tokei/pull/1178))
- Add templ support ([#1122](https://github.com/XAMPPRocky/tokei/pull/1122))
- Update README.md with HiCAD from d4a1814 ([#1143](https://github.com/XAMPPRocky/tokei/pull/1143))
- Add BQN support ([#1151](https://github.com/XAMPPRocky/tokei/pull/1151))
- add more extensions for `Hlsl` ([#1164](https://github.com/XAMPPRocky/tokei/pull/1164))
- Add Phix ([#1167](https://github.com/XAMPPRocky/tokei/pull/1167))
- Add APL support ([#1152](https://github.com/XAMPPRocky/tokei/pull/1152))
- Add support for SIL ([#1153](https://github.com/XAMPPRocky/tokei/pull/1153))
- Use `OR` operator in Cargo.toml `license` field ([#1165](https://github.com/XAMPPRocky/tokei/pull/1165))
- Disable legacy Cargo features ([#1158](https://github.com/XAMPPRocky/tokei/pull/1158))
- add slint language support ([#1054](https://github.com/XAMPPRocky/tokei/pull/1054))
- Add Pyret support ([#1032](https://github.com/XAMPPRocky/tokei/pull/1032))
- Recognize GNUmakefile ([#1021](https://github.com/XAMPPRocky/tokei/pull/1021))

## [13.0.0-alpha.5](https://github.com/XAMPPRocky/tokei/compare/v13.0.0-alpha.4...v13.0.0-alpha.5) - 2024-08-23

### Fixed
- fix issue https://github.com/XAMPPRocky/tokei/issues/1147 ([#1149](https://github.com/XAMPPRocky/tokei/pull/1149))

### Other
- Fix issue [#1145](https://github.com/XAMPPRocky/tokei/pull/1145) (part 2) ([#1148](https://github.com/XAMPPRocky/tokei/pull/1148))

## [13.0.0-alpha.4](https://github.com/XAMPPRocky/tokei/compare/v13.0.0-alpha.3...v13.0.0-alpha.4) - 2024-08-22

### Fixed
- fix issue https://github.com/XAMPPRocky/tokei/issues/1145 ([#1146](https://github.com/XAMPPRocky/tokei/pull/1146))

### Other
- Add support for Glimmer JS/TS ([#1052](https://github.com/XAMPPRocky/tokei/pull/1052))
- Fix issue [#1141](https://github.com/XAMPPRocky/tokei/pull/1141) ([#1142](https://github.com/XAMPPRocky/tokei/pull/1142))

## [13.0.0-alpha.3](https://github.com/XAMPPRocky/tokei/compare/v13.0.0-alpha.2...v13.0.0-alpha.3) - 2024-08-20

### Fixed
- fix issue https://github.com/XAMPPRocky/tokei/issues/1138 ([#1139](https://github.com/XAMPPRocky/tokei/pull/1139))

## [13.0.0-alpha.2](https://github.com/XAMPPRocky/tokei/compare/v13.0.0-alpha.1...v13.0.0-alpha.2) - 2024-08-19

### Added
- Add support for Monkey C ([#1081](https://github.com/XAMPPRocky/tokei/pull/1081))
- added plantuml support ([#1125](https://github.com/XAMPPRocky/tokei/pull/1125))
- add language Tact ([#1103](https://github.com/XAMPPRocky/tokei/pull/1103))
- add support for bicep ([#1100](https://github.com/XAMPPRocky/tokei/pull/1100))
- add hledger ([#1121](https://github.com/XAMPPRocky/tokei/pull/1121))
- add SELinux CIL policy source files ([#1124](https://github.com/XAMPPRocky/tokei/pull/1124))
- --files argument now sorts alphabetically ([#1059](https://github.com/XAMPPRocky/tokei/pull/1059))
- add support for LALRPOP ([#1077](https://github.com/XAMPPRocky/tokei/pull/1077))

### Fixed
- read hidden from config file ([#1093](https://github.com/XAMPPRocky/tokei/pull/1093))

### Other
- Fix cargo audit issues ([#1137](https://github.com/XAMPPRocky/tokei/pull/1137))
- Add support for MDX ([#1046](https://github.com/XAMPPRocky/tokei/pull/1046))
- Add PRQL to README.md ([#1088](https://github.com/XAMPPRocky/tokei/pull/1088))
- add fypp extension `.fpp` to `languages.json` for Modern Fortran ([#1060](https://github.com/XAMPPRocky/tokei/pull/1060))
- Add support for Lex ([#1087](https://github.com/XAMPPRocky/tokei/pull/1087))
- Add d2 ([#1091](https://github.com/XAMPPRocky/tokei/pull/1091))
- Add support for Stata ([#1112](https://github.com/XAMPPRocky/tokei/pull/1112))
- Add support for CUE ([#1049](https://github.com/XAMPPRocky/tokei/pull/1049))
- bump libc from 0.2.147 to 0.2.155 ([#1104](https://github.com/XAMPPRocky/tokei/pull/1104))
- add cangjie language support ([#1127](https://github.com/XAMPPRocky/tokei/pull/1127)) ([#1128](https://github.com/XAMPPRocky/tokei/pull/1128))
- Add support for JSLT ([#1129](https://github.com/XAMPPRocky/tokei/pull/1129))
- Add Arturo support ([#1108](https://github.com/XAMPPRocky/tokei/pull/1108))
- Support Bazel's MODULE files and *.bzlmod files ([#1130](https://github.com/XAMPPRocky/tokei/pull/1130))
- read only first 128B from the file when searching for shebang ([#1040](https://github.com/XAMPPRocky/tokei/pull/1040))
- add OpenCL as a languages.json entry ([#980](https://github.com/XAMPPRocky/tokei/pull/980))
- Add GetText Portable Object (PO) files ([#814](https://github.com/XAMPPRocky/tokei/pull/814))
- Support godot shader ([#1118](https://github.com/XAMPPRocky/tokei/pull/1118))
- Add Modelica language ([#1061](https://github.com/XAMPPRocky/tokei/pull/1061))
- Add menhir support ([#781](https://github.com/XAMPPRocky/tokei/pull/781))
- Update README.md
- [issue_1114] remove Cargo.lock from .gitignore ([#1115](https://github.com/XAMPPRocky/tokei/pull/1115))
- [issue_891] give more space for Files column ([#933](https://github.com/XAMPPRocky/tokei/pull/933))
- GitHub Action to publish docker images ([#1096](https://github.com/XAMPPRocky/tokei/pull/1096))
- Support MoonBit language. ([#1095](https://github.com/XAMPPRocky/tokei/pull/1095))
- Add OpenSCAD ([#1097](https://github.com/XAMPPRocky/tokei/pull/1097))
- add jinja extension for Jinja2 ([#1083](https://github.com/XAMPPRocky/tokei/pull/1083))
- Fix slang ([#1089](https://github.com/XAMPPRocky/tokei/pull/1089))
- Temporarily remove Hare
- Support .pyi python file ([#1075](https://github.com/XAMPPRocky/tokei/pull/1075))
- add luau extension to lua ([#1066](https://github.com/XAMPPRocky/tokei/pull/1066))
- Adding support for Snakemake ([#1045](https://github.com/XAMPPRocky/tokei/pull/1045))
- Add Janet to languages.json ([#1042](https://github.com/XAMPPRocky/tokei/pull/1042))
- Add OpenQASM support ([#1041](https://github.com/XAMPPRocky/tokei/pull/1041))
- typst ([#1037](https://github.com/XAMPPRocky/tokei/pull/1037))
- Add the ZoKrates language ([#1035](https://github.com/XAMPPRocky/tokei/pull/1035))
- Add PRQL ([#1030](https://github.com/XAMPPRocky/tokei/pull/1030))
- remove refs ([#1006](https://github.com/XAMPPRocky/tokei/pull/1006))
- Add lingua franca language ([#993](https://github.com/XAMPPRocky/tokei/pull/993))
- Add support for Razor Components ([#992](https://github.com/XAMPPRocky/tokei/pull/992))
- Add arch's PKGBUILD files ([#972](https://github.com/XAMPPRocky/tokei/pull/972))
- Add Hare support ([#971](https://github.com/XAMPPRocky/tokei/pull/971))
- Add Max support ([#963](https://github.com/XAMPPRocky/tokei/pull/963))
- Add support for Chapel ([#960](https://github.com/XAMPPRocky/tokei/pull/960))
- Add language support for Slang ([#956](https://github.com/XAMPPRocky/tokei/pull/956))
- Update TypeScript language ([#953](https://github.com/XAMPPRocky/tokei/pull/953))
- Added support for Circom ([#949](https://github.com/XAMPPRocky/tokei/pull/949))
- link to earthly project ([#1078](https://github.com/XAMPPRocky/tokei/pull/1078))

## [13.0.0-alpha.1](https://github.com/XAMPPRocky/tokei/compare/v13.0.0-alpha.0...v13.0.0-alpha.1) - 2024-03-04

### Fixed
- fixed language names not showing when in Light mode (light background) ([#1048](https://github.com/XAMPPRocky/tokei/pull/1048))

### Other
- Create release-plz.yaml
- Update mean_bean_ci.yml
- Fix LD Script language data ([#1028](https://github.com/XAMPPRocky/tokei/pull/1028))
- Fix language data example in CONTRIBUTING.md ([#1029](https://github.com/XAMPPRocky/tokei/pull/1029))
- Update dependencies
- Add widget install instructions
- Update mean_bean_ci.yml
- Dockerize tokei ([#930](https://github.com/XAMPPRocky/tokei/pull/930))
- Ignore format commits for `languages.json` ([#1013](https://github.com/XAMPPRocky/tokei/pull/1013))
- Upgrade GitHub Actions ([#955](https://github.com/XAMPPRocky/tokei/pull/955))
- add --languages ouput formatter ([#1007](https://github.com/XAMPPRocky/tokei/pull/1007))
- Add Nuget Config, Bazel and EdgeQL Support, Fix Output Formatter ([#999](https://github.com/XAMPPRocky/tokei/pull/999))
- show nushell in the readme ([#991](https://github.com/XAMPPRocky/tokei/pull/991))
- Add support for Redscript ([#994](https://github.com/XAMPPRocky/tokei/pull/994))
- Add support for jq ([#965](https://github.com/XAMPPRocky/tokei/pull/965))
- Add support for Astro ([#966](https://github.com/XAMPPRocky/tokei/pull/966))
- Use XDG conventions on macOS too ([#989](https://github.com/XAMPPRocky/tokei/pull/989))
- Add JSON5 support for languages.json ([#986](https://github.com/XAMPPRocky/tokei/pull/986))
- Delete Smalltalk.cs.st ([#990](https://github.com/XAMPPRocky/tokei/pull/990))
- Add support for smalltalk ([#839](https://github.com/XAMPPRocky/tokei/pull/839))
- Disable *-android
- Add HiCAD to languages.json ([#985](https://github.com/XAMPPRocky/tokei/pull/985))
- Add Nushell to languages.json ([#982](https://github.com/XAMPPRocky/tokei/pull/982))
# 12.1.0

## Introduction
Tokei is a fast and accurate code analysis CLI tool and library, allowing you to
easily and quickly see how many blank lines, comments, and lines of code are in
your codebase. All releases and work on Tokei and tokei.rs ([the free companion
badge service][rs-info]) are [funded by the community through
GitHub Sponsors][sponsor].

You can always download the latest version of tokei through GitHub Releases or
Cargo. Tokei is also available through other [package managers][pkg], though
they may not always contain the latest release.

```
cargo install tokei
```

[pkg]: https://github.com/XAMPPRocky/tokei#package-managers
[rs-info]: https://github.com/XAMPPRocky/tokei/blob/master/README.md#Badges
[sponsor]: https://github.com/sponsors/XAMPPRocky

## What's New?

- [Added `-n/--num-format=[commas, dots, plain, underscores]` for adding
  separator formatting for numbers.](https://github.com/XAMPPRocky/tokei/pull/591)
- [The total is now included in output formats such as JSON.](https://github.com/XAMPPRocky/tokei/pull/580)
- [`--no-ignore` now implies other ignore flags.](https://github.com/XAMPPRocky/tokei/pull/588)
- [Added `--no-ignore-dot` flag to ignore files such as `.ignore`.](https://github.com/XAMPPRocky/tokei/pull/588)
- [Added single line comments to F\*](https://github.com/XAMPPRocky/tokei/pull/670)
- Updated various dependencies.

### Added Languages

- [ABNF](https://github.com/XAMPPRocky/tokei/pull/577)
- [CodeQL](https://github.com/XAMPPRocky/tokei/pull/604)
- [LiveScript](https://github.com/XAMPPRocky/tokei/pull/607)
- [Stylus](https://github.com/XAMPPRocky/tokei/pull/619)
- [DAML](https://github.com/XAMPPRocky/tokei/pull/620)
- [Tera](https://github.com/XAMPPRocky/tokei/pull/627)
- [TTCN-3](https://github.com/XAMPPRocky/tokei/pull/621)
- [Beancount](https://github.com/XAMPPRocky/tokei/pull/630)
- [Gleam](https://github.com/XAMPPRocky/tokei/pull/646)
- [JSONNet](https://github.com/XAMPPRocky/tokei/pull/634)
- [Stan](https://github.com/XAMPPRocky/tokei/pull/633)
- [Gwion](https://github.com/XAMPPRocky/tokei/pull/659)

# 12.0.0

## What's New? 
Tokei 12 comes with some of the biggest user facing changes since 1.0, now in
the latest version tokei will now **analyse and count multiple languages
embedded in your source code** as well as adding support for
**Jupyter Notebooks**. Now for the first time is able to handle and display
different languages contained in a single source file. This is currently available
for a limited set of languages, with plans to add more support for more in the
future. The currently supported languages are;

### HTML + Siblings (Vue, Svelte, Etc...)
Tokei will now analyse and report the source code contained in `<script>`,
`<style>`, and `<template>` tags in HTML and other similar languages. Tokei will
read the value of the`type` attribute from the `<script>` tag and detects the
appropriate language based on its mime type or JavaScript if not present. Tokei
will do the same for `<style>` and `<template>` except reading the `lang`
attribute instead of `type` and defaulting to CSS and HTML each respectively.

### Jupyter Notebooks
Tokei will now read Jupyter Notebook files (`.ipynb`) and will read the source
code and markdown from Jupyter's JSON and output the analysed result.

### Markdown
Tokei will now detect any code blocks marked with specified source language and
count each as their respective languages or as Markdown if not present or not
found. Now you can easily see how many code examples are included in
your documentation.

### Rust
Tokei will now detect blocks of rustdoc documentation  (e.g. `///`/`//!`) and
parse them as markdown.

### Verbatim Strings
Tokei is now also capable of handling "verbatim" strings, which are strings that
do not accept escape sequences like `\`. Thanks to @NickHackman for providing
the implementation! This is initially supported for C++, C#, F#, and Rust.

## New Look
To be able to show these new features, tokei's output has been changed to look
like below. For brevity the CLI only displays one level deep in each language,
however the library's parser is fully recursive and you can get access to the
complete report using the library or by outputting the JSON format.

```
===============================================================================
 Language            Files        Lines         Code     Comments       Blanks
===============================================================================
 BASH                    4           49           30           10            9
 JSON                    1         1332         1332            0            0
 Shell                   1           49           38            1           10
 TOML                    2           77           64            4            9
-------------------------------------------------------------------------------
 Markdown                5         1230            0          965          265
 |- JSON                 1           41           41            0            0
 |- Rust                 2           53           42            6            5
 |- Shell                1           22           18            0            4
 (Total)                           1346          101          971          274
-------------------------------------------------------------------------------
 Rust                   19         3349         2782          116          451
 |- Markdown            12          351            5          295           51
 (Total)                           3700         2787          411          502
===============================================================================
 Total                  32         6553         4352         1397          804
===============================================================================
```

This feature is not just limited to the default output of tokei. You can see it
broken down by each file with the `--files` option.

```
===============================================================================
 Language            Files        Lines         Code     Comments       Blanks
===============================================================================
 Markdown                5         1230            0          965          265
 |- JSON                 1           41           41            0            0
 |- Rust                 2           53           42            6            5
 |- Shell                1           22           18            0            4
 (Total)                           1346          101          971          274
-------------------------------------------------------------------------------
 ./CODE_OF_CONDUCT.md                46            0           28           18
 ./CHANGELOG.md                     570            0          434          136
-- ./markdown.md --------------------------------------------------------------
 |- Markdown                          4            0            3            1
 |- Rust                              6            4            1            1
 |- (Total)                          10            4            4            2
-- ./README.md ----------------------------------------------------------------
 |- Markdown                        498            0          421           77
 |- Shell                            22           18            0            4
 |- (Total)                         520           18          421           81
-- ./CONTRIBUTING.md ----------------------------------------------------------
 |- Markdown                        112            0           79           33
 |- JSON                             41           41            0            0
 |- Rust                             46           38            4            4
 |- (Total)                         200           79           84           37
===============================================================================
 Total                   5         1346          101          971          274
===============================================================================
```

## Breaking Changes
- The JSON Output and format of `Languages` has changed.
- The JSON feature has been removed and is now included by default.
- `Stats` has been split into `Report` and `CodeStats` to better represent the
  separation between analysing a file versus a blob of code.

# 11.2.0

- @alexmaco Added shebang and env detection for Crystal.
- @NickHackman Updated both Vue and HTML to count CSS & JS comments as comments.
- @XAMPPRocky renamed Perl6's display name to Rakudo.
- @dbackeus Added `erb` extension for Ruby HTML.
- @kobataiwan Tokei will now check for a configuration file in your home
  directory as well as your current and configuration directory.
- @dependabot Updated dependencies

**Added Languages**
- @alexmaco Dhall
- @NickHackman Svelte
- @athas Futhark
- @morphy2k Gohtml
- @LucasMW Headache
- @rosasynstylae Tsx
- @XAMPPRocky OpenType Feature Files

# 11.1.0

**Added Languages**

- @rubdos Arduino
- @LuqueDaniel Pan
- @itkovian Ren'Py

- Added `LanguageType::shebangs`, `LanguageType::from_file_extension`, and
  `LanguageType::from_shebang`. (@solanav)


# 11.0.0

**Added languages**

- @bwidawsk GNU Assembly, GDB Script
- @isker Dust, Apache Velocity
- @andreblanke FreeMarker


Thanks to some major internal refactoring, Tokei has received significant
performance improvements, and is now one of the fastest code counters across any
size of codebase. With Tokei 11 showing up to 40–60% faster results than tokei's
previous version. To showcase the improvements I've highlighted benchmarks
of counting five differently sized codebases. Redis (~220k lines), Rust (~16M
lines), and the Unreal Engine (~37.5M lines). In every one of these benchmarks
Tokei 11 performed the best by a noticeable margin.

*All benchmarks were done on a 15-inch MacBook Pro, with a 2.7GHz Intel Core i7
processor and 16GB 2133 MHz LPDDR3 RAM running macOS Catalina 10.15.3. Your
mileage may vary, All benchmarks were done using [hyperfine], using default
settings for all programs.*

[hyperfine]: https://github.com/sharkdp/hyperfine

### Tokei
**Note** This benchmark is not accurate due to `tokei` and `loc` both taking
less than 5ms to complete, there is a high degree of error between the times and
should mostly be considered equivalent. However it is included because it is
notable that `scc` takes nearly 3x as long to complete on smaller codebases
(~5k lines).
![Graph comparing programs running on the tokei source code](https://docs.google.com/spreadsheets/d/e/2PACX-1vRN2Um3G9Mn4Bg6UVWwgntsMy4faZMIP3EDjAfY5Y6Tav7T5z1TxVKmPu7wUNIpUSsSJDfCNH0SAKBB/pubchart?oid=1242634543&format=image)

### Redis
![Graph comparing programs running on the redis source code](https://docs.google.com/spreadsheets/d/e/2PACX-1vRN2Um3G9Mn4Bg6UVWwgntsMy4faZMIP3EDjAfY5Y6Tav7T5z1TxVKmPu7wUNIpUSsSJDfCNH0SAKBB/pubchart?oid=2009389097&format=image)

### Rust
![Graph comparing programs running on the rust source code](https://docs.google.com/spreadsheets/d/e/2PACX-1vRN2Um3G9Mn4Bg6UVWwgntsMy4faZMIP3EDjAfY5Y6Tav7T5z1TxVKmPu7wUNIpUSsSJDfCNH0SAKBB/pubchart?oid=424069399&format=image)

### Unreal
![Graph comparing programs running on the unreal source code](https://docs.google.com/spreadsheets/d/e/2PACX-1vRN2Um3G9Mn4Bg6UVWwgntsMy4faZMIP3EDjAfY5Y6Tav7T5z1TxVKmPu7wUNIpUSsSJDfCNH0SAKBB/pubchart?oid=439405321&format=image)

# 10.1.2

- Added `pyw` extension to Python.
- Updated dependencies

# 10.1.1

- Fixed `.tokeignore` always working even when `--no-ignore` is present.
- Updated dependencies

**Added languages**

- @erikaxel Gherkin (Cucumber)

# 10.1.0

- Added `cjsx` extension to CoffeeScript.
- Tokei will now recognise files with `#!/usr/bin/env ruby` as Ruby.
- Updated dependencies.
- Tokei now uses `crossbeam` channels over `std::mpsc`, which should have a
  noticeable performance improvement on large repos.
- Improved documentation for `libtokei`.

**Added languages**

- @lzybkr PowerShell
- @turbo MoonScript
- @dtolnay Thrift
- @Tranzystorek FlatBuffers
- @NieDzejkob Emojicode
- @DanteFalzone0 HolyC
- @sci4me Odin
- @fkarg Rusty Object Notation (RON)

# 10.0.0

- Fixed minor parsing bugs.
- Width is now limited to 80 unless you use the `--files` flag.
- Added the `mjs` extension to JavaScript.
- Added the `tpp` extension to C++.
- You can now disable Tokei's git ignore detection, similar to ripgrep. See
  `--help` for options.
- You can now add a `.tokeignore` file to your project to specify file paths
  for tokei to always ignore. This file uses the same syntax as `.gitignore`.
- Improved Pascal representation

**Added languages**

- @hobofan solidity
- @stefanmaric GraphQL
- @jhpratt PostCSS
- @evitalis RPM
- @alexmaco Pony
- @yjhmelody WASM, LLVM, Pest
- @XAMPPRocky ASN.1

# 9.0.0

- Tokei now has config files. You can now specify some commonly used arguments
  in a `.tokeirc`/`tokei.toml`. Namely `columns` to set the default column
  output, `types` to filter your count to just a single set of languages, and
  `treat_doc_strings_as_comments` which is a new option that allows you to
  specify whether to treat doc strings such as `"""` in Python as comments
  or code.
  The config files can be specified in two places, the current directory tokei
  is running in and your [system configuration
  directory](//docs.rs/tokei/struct.Config.html#method.from_config_files). The
  priority of options is as follows
  `CLI > <current_directory> > <configuration_directory>`.
- Tokei is now available on [Conda](https://anaconda.org/conda-forge/tokei).
- [Tokei's README has been translated
  to chinese.](https://github.com/chinanf-boy/tokei-zh#tokei-)
- `LanguageType` now implements `Hash`.
- Tokei now batches its console output, this should result in a small
  performance boost.
- There is now a `--columns` argument for manually setting tokei's output width.
- The `--sort` argument is now case-insensitive.
- Tokei will now mark languages who's files failed to parse correctly as
  potentially inaccurate.
- Due to a bug in trust-ci `x86_64-unknown-netbsd` versions will not be
  available in GitHub releases. (You will still be able to install from source.)
- Due to toml-rs's lacking enum support the TOML output option has
  been disabled.

**Added languages**

- @t-richards Liquid
- @diaphore Added the `.glsl` extension to GLSL.
- @ahmedelgabri Twig
- @pmoura Logtalk
- @alekratz Perl, Not Quite Perl
- @XAMPPRocky Automake, .NET Resource, HLSL, INI, Unreal Plugin,
  Unreal Project, Unreal Shader, Unreal Shader Header, Unreal Markdown,
  Visual Basic, Visual Studio Solution, Visual Studio Project, Xcode Config,
- @TheMrNomis SWIG
- @xnorme Added the `.vhdl` extension to VHDL

# 8.0.0

- A language's comments, and quotes are now available through the `LanguageType`
  enum.
- You can filter by language using the `-t/--type` option. e.g. `tokei -t "Rust,C"`
  will print only Rust and C files.
- Tokei now understands terminal width and will expand to fit it. (Thanks
  to @Veykril)
- Added [comparison](./COMPARISON.md) document to compare Tokei to other
  code counters.
- Updated dependencies

**Added languages**

- @BrandonBoone VB6, VBScript, XSLT
- @ialpert BrightScript
- @PJB3005 Dream Maker
- @schmee edn

# 7.0.3

Made various optimisations, up to 65% faster in some cases.

**Added languages**

- @DenialAdams Added Forsyth-Edwards-Notation (FEN)
- @DjebbZ Added ClojureC
- @grimm26 Added HCL/Terraform

# 7.0.2

- Updated dependencies.
- Changed how compilied serialization formats are handled.
- Fixed minor parser inaccuracies.
- Tokei should now recognise more python files from their shebang.

**Added languages**

- @ignatenko Added Meson
- @sprang Added Scheme
- @fengcms Added Vue
- @mark.knol Added Haxe
- @rleungx Added ABAP, COBOL, and Groovy
- @tiehuis Added Zig
- @murielsilveira Added Mint
- @notramo Added Elvish Shell and Kakoune
- @aatxe Added Racket
- @kamilchm Added ReasonML
- @cyplp Added XSL

# 7.0.1

- Updated dependencies

# 7.0.0

- Fixed parsing corner cases
- Changed storage of comments and quotes from `Vec` to static slices.
- Added tracing for debugging single files. Not recommended for use on
  multiple file
- Updated `log`

# 6.1.0

- Fixed inaccuracies relating to the end comment being smaller than start
  comment.

**Added languages**

- @mattico Added Xaml
- @weakish Added Ceylon
- @theduke Added tsx extension to typescript
- @vmchale Added Hamlet, Cassius, Lucius, Cabal, Nix, Happy, Alex, and Madlang
- @notramo Added Crystal

# 6.0.2

- Now can recognise file languages based on their filename.

**Added Languages:**

- @kazimuth CMake, Dockerfile, Rakefile, Scons

# 6.0.1

- Multiple exclude flags now allowed.

**Added Languages:**

- @seiks Added Fish Shell
- @XAMPPRocky Added Module-Definition
- @tbu- Added Vala

# 6.0.0

- Reworked internals
- Now uses serde*derive(\_and thusly requires rust v1.15*)
- Now has better file based testing

**Added languages:**

- @tuncer Added Ur/Web
- @svisser Added PureScript
- @tjodden Add some common extensions for HTML, C++ and Makefile
- @xd009642 Added VHDL

# 5.0.0

- Optimised internals

**Added languages:**

- @GungnirInd Added GDScript
- @tuncer Differentiate between sh and Bash, Added Cogent, F\*, F#
- @pthariensflame Added Agda

# 4.5.0

- Added Regex based hueristics so more expensive multi line handling isn't used
  if there are no multi line comments in the file.
- Now uses the `ignore` crate for getting files. Which now also makes
  determining language from path/file parallelised
- File counting used to only be parallelised per language, now it is also
  parallelised per file per language.
- Updated homepage, and documentation links
- @rmbreak Tokei will now not add directories with `foo.bar` like syntax
  to a language.
- @Michael-F-Bryan tokei will now exit gracefully when a feature is missing
  instead of panicking

**Added languages:**

- @hauleth Added Elixir support

# 4.4.0

- Simplified language definitions, now consolidated into a single JSON file.
- Fixed regression where lines and files weren't sorted.
- @llogiq : made clippy fixes
- @lligo : Added long verbose name

**Added languages:**

- @little-dude : Tcl(_tcl_)
- @svenstaro : GLSL(_vert, tesc, tese, geom, frag, comp_)
- @not-fl3 : Elm(_elm_)

**Changes to existing languages:**

- @xpayn : Added `pm` extension to Perl.

# 4.3.0

- @lligo : Tokei no longer panics on non-character-boundary when printing file names.
- Fixed regression where no comment style files(_json, markdown_) weren't counted.
- Tokei can now handle files in different encodings.(_using the [encoding](https://crates.io/crates/encoding) library_)
- Tokei now prints errors instead of silently skipping them.
- Tokei can now print unused extensions using `-v` option.

**Added languages:**

- Asp(_asa, asp_)
- Asp.NET(_asax, ascx, asmx, aspx, master, sitemap, webinfo_)
- Hex(_hex_)
- Intel Hex(_ihex_)
- ReStructuredText(_rst_)
- Razor(_cshtml_)

**Changes to existing languages Thanks to @mwilli20 :**

- Another Ada extension(_pad_)
- Assembly - Uses `' '` or `" "` and added another extension(_asm_)
- Bash - Uses `' '` or `" "`
- Batch - They don't use quotes for strings, added `::`
- Cold Fusion - Uses `' '` or `" "`
- D - Uses `" "` or
- Dart - Uses `" "` or `' '` or `""" """` or `''' '''`
- Forth - Uses `" "` but new, doesn't have a preset
- Fortrans - Use `" "` or `' '`
- Idris - Uses `" "` or `""" """`
- Julia - Uses `" "` or `""" """`
- Kotlin - Uses `" "` or `""" """`
- Lisp - Comments can be nested
- Moustache - Uses `" "` or `' '`
- Nim - Uses `" "` or `""" """`
- Pascal - Uses `' '`
- Perl - Uses `" "` or `' '`
- Php - Uses `" "` or `' '`
- Python - Uses `" "` or `' '` or `""" """` or `''' '''`
- Ruby - Uses `" "` or `' '`
- Sass - Uses `" "` or `' '`
- Sql - Uses `' '`
- Toml - Uses `" "` or `' '` or `""" """` or `''' '''`
- Typescript - Uses `" "` or `' '` or
- Vimscript - Uses `" "` or `' '`
- Yaml - Uses `" "` or `' '`
- Zsh - Uses `" "` or `' '`
- Clojure - Removed `#`
- Forth - `( Comment)` style comments need a space after the opening paren
- Haskell - Has nested comments
- Idris - Has nested comments
- Jai - Has nested block comments
- Julia - Has nested block comments
- Kotlin - Has nested block comments
- Pascal - Pascal should be multiline from `{` or `(*` to `}` or `*)`
- Perl - Perl5 and earlier for multiline comments need `=pod` to `=cut`.
- Swift - Has nested block comments

### Tokei's code count

```
-------------------------------------------------------------------------------
 Language            Files        Lines         Code     Comments       Blanks
-------------------------------------------------------------------------------
 Rust                   13         2413         1596          601          216
-------------------------------------------------------------------------------
 |ib\language\languages.rs          693          420          197           76
 |anguage\language_type.rs          500          386          102           12
 .\src\main.rs                      314          256           17           41
 |lib\language\language.rs          356          166          166           24
 .\src\lib\utils\fs.rs              129          107            9           13
 |\lib\utils\multi_line.rs          149           89           39           21
 .\src\lib\utils\macros.rs           59           50            3            6
 .\src\lib\stats.rs                  63           45           12            6
 .\src\lib\lib.rs                    76           25           47            4
 .\src\lib\build.rs                  31           23            0            8
 .\src\lib\sort.rs                   28           19            6            3
 .\src\lib\language\mod.rs           11            6            3            2
 .\src\lib\utils\mod.rs               4            4            0            0
-------------------------------------------------------------------------------
 Markdown                4          492          492            0            0
-------------------------------------------------------------------------------
 .\README.md                        252          252            0            0
 .\CHANGELOG.md                     202          202            0            0
 .\CONTRIBUTING.md                   25           25            0            0
 .\CONTRIBUTORS.md                   13           13            0            0
-------------------------------------------------------------------------------
 YAML                    2           70           67            3            0
-------------------------------------------------------------------------------
 .\cli.yml                           53           50            3            0
 .\.travis.yml                       17           17            0            0
-------------------------------------------------------------------------------
 TOML                    1           80           65            0           15
-------------------------------------------------------------------------------
 .\Cargo.toml                        80           65            0           15
-------------------------------------------------------------------------------
 Autoconf                1            9            7            1            1
-------------------------------------------------------------------------------
 .\src\lib\lib.rs.in                  9            7            1            1
-------------------------------------------------------------------------------
 Total                  21         3064         2227          605          232
-------------------------------------------------------------------------------
```

# 4.2.0

Tokei is now more precise, and shouldn't ever panic.
Tokei now handles comments in quotes and more precise nested comments properly.
Fixes #53

### Tokei's code count.

```
-------------------------------------------------------------------------------
 Language            Files        Lines         Code     Comments       Blanks
-------------------------------------------------------------------------------
 Rust                   13         2303         1487          594          222
-------------------------------------------------------------------------------
 |ib\language\languages.rs          682          401          198           83
 |anguage\language_type.rs          467          359           96           12
 .\src\main.rs                      302          243           17           42
 |lib\language\language.rs          356          166          166           24
 .\src\lib\utils\fs.rs              116           95            9           12
 |\lib\utils\multi_line.rs          156           93           41           22
 .\src\lib\stats.rs                  54           36           12            6
 .\src\lib\build.rs                  31           23            0            8
 .\src\lib\lib.rs                    69           22           43            4
 .\src\lib\utils\macros.rs           27           20            3            4
 .\src\lib\sort.rs                   28           19            6            3
 .\src\lib\language\mod.rs           11            6            3            2
 .\src\lib\utils\mod.rs               4            4            0            0
-------------------------------------------------------------------------------
 YAML                    2           68           65            3            0
-------------------------------------------------------------------------------
 .\cli.yml                           49           46            3            0
 .\.travis.yml                       19           19            0            0
-------------------------------------------------------------------------------
 TOML                    1           71           58            0           13
-------------------------------------------------------------------------------
 .\Cargo.toml                        71           58            0           13
-------------------------------------------------------------------------------
 Autoconf                1            9            7            1            1
-------------------------------------------------------------------------------
 .\src\lib\lib.rs.in                  9            7            1            1
-------------------------------------------------------------------------------
 Total                  17         2451         1617          598          236
-------------------------------------------------------------------------------
```

# 4.1.0

Tokei is now **~40%** faster.

**Added languages**

- Ada
- Forth

# 4.0.0

Tokei now has a minimal version without `serde` for faster compilation.

Updated various dependencies.

Internal dependencies removed.

## Regressions

- CBOR is not supported till it supports `serde 0.8`

**Added languages**

- Handlebars

# 3.0.0

Tokei is now available as a library.

Tokei now has a lot more tests.

Tokei now supports TOML

Fixed #41

Fixed #44

Fixed #45

# 2.1.0

Tokei, can now output results in various formats(_cbor, json, yaml_)

Conversely tokei can now take in results in those formats, and add them to the current run.

Premilarily support for nested comments(_currently only supported for rust_)

Change in the output format [PR #35](https://github.com/XAMPPRocky/tokei/pull/35)

Moved `.sc` from Lisp to Scala.

Internals changed to allow for multiple multi line comment formats.

**Added languages:**

- Isabelle

# 2.0.0

Major rewrite, now parallelized.
Can now support sorting files.
Added a progress message for when it is counting files.
Fixed #29

**Added languages:**

- Coq
- Erlang
- Kotlin
- Idris
- Nim
- Oz
- Prolog
- Qcl
- Scala
- Unreal Script
- Wolfram

# 1.6.0

Added file counting.

# 1.5.0

Added Shebang support.

**Added languages:**

- Assembly
- LD Scripts
- Device Trees
- Makefiles
- Plain Text
- C Shell

# 1.4.1

Changed the formatting so tokei looks nice for consoles of 80 column width.

# 1.4.0

Changed from handmade recursive file opening to [walkdir](https://github.com/BurntSushi/walkdir)
