# rust-analyzer Binary

Text editors require the `rust-analyzer` binary to be in
`$PATH`. You can download pre-built binaries from the
[releases](https://github.com/rust-lang/rust-analyzer/releases) page.
You will need to uncompress and rename the binary for your platform,
e.g. from `rust-analyzer-aarch64-apple-darwin.gz` on Mac OS to
`rust-analyzer`, make it executable, then move it into a directory in
your `$PATH`.

On Linux to install the `rust-analyzer` binary into `~/.local/bin`,
these commands should work:

```bash
mkdir -p ~/.local/bin
curl -L https://github.com/rust-lang/rust-analyzer/releases/latest/download/rust-analyzer-x86_64-unknown-linux-gnu.gz | gunzip -c - > ~/.local/bin/rust-analyzer
chmod +x ~/.local/bin/rust-analyzer
```

Make sure that `~/.local/bin` is listed in the `$PATH` variable and use
the appropriate URL if you’re not on a `x86-64` system.

You don’t have to use `~/.local/bin`, any other path like `~/.cargo/bin`
or `/usr/local/bin` will work just as well.

Alternatively, you can install it from source using the command below.
You’ll need the latest stable version of the Rust toolchain.

```bash
git clone https://github.com/rust-lang/rust-analyzer.git && cd rust-analyzer
cargo xtask install --server
```

If your editor can’t find the binary even though the binary is on your
`$PATH`, the likely explanation is that it doesn’t see the same `$PATH`
as the shell, see [this
issue](https://github.com/rust-lang/rust-analyzer/issues/1811). On Unix,
running the editor from a shell or changing the `.desktop` file to set
the environment should help.

### rustup

`rust-analyzer` is available in `rustup`:

```bash
rustup component add rust-analyzer
```

### Arch Linux

The `rust-analyzer` binary can be installed from the repos or AUR (Arch
User Repository):

-   [`rust-analyzer`](https://www.archlinux.org/packages/extra/x86_64/rust-analyzer/)
    (built from latest tagged source)

-   [`rust-analyzer-git`](https://aur.archlinux.org/packages/rust-analyzer-git)
    (latest Git version)

Install it with pacman, for example:

```bash
pacman -S rust-analyzer
```

### Gentoo Linux

`rust-analyzer` is installed when the `rust-analyzer` use flag is set for dev-lang/rust or dev-lang/rust-bin. You also need to set the `rust-src` use flag.

### macOS

The `rust-analyzer` binary can be installed via
[Homebrew](https://brew.sh/).

```bash
brew install rust-analyzer
```

### Windows

It is recommended to install the latest Microsoft Visual C++ Redistributable prior to installation.
Download links can be found
[here](https://learn.microsoft.com/en-us/cpp/windows/latest-supported-vc-redist).

