import re
import pytest

def test_foo():

    ### Errors

    with pytest.raises(FooAtTheEnd, match="foo."): ...
    with pytest.raises(PackageExtraSpecifier, match="Install `foo[bar]` to enjoy all features"): ...
    with pytest.raises(InnocentQuestion, match="Did you mean to use `Literal` instead?"): ...

    with pytest.raises(StringConcatenation, match="Huh"
                                                  "?"): ...
    with pytest.raises(ManuallyEscapedWindowsPathToDotFile, match="C:\\\\Users\\\\Foo\\\\.config"): ...

    with pytest.raises(MiddleDot, match="foo.bar"): ...
    with pytest.raises(EndDot, match="foobar."): ...
    with pytest.raises(EscapedFollowedByUnescaped, match="foo\\.*bar"): ...
    with pytest.raises(UnescapedFollowedByEscaped, match="foo.\\*bar"): ...


    ## Metasequences

    with pytest.raises(StartOfInput, match="foo\\Abar"): ...
    with pytest.raises(WordBoundary, match="foo\\bbar"): ...
    with pytest.raises(NonWordBoundary, match="foo\\Bbar"): ...
    with pytest.raises(Digit, match="foo\\dbar"): ...
    with pytest.raises(NonDigit, match="foo\\Dbar"): ...
    with pytest.raises(Whitespace, match="foo\\sbar"): ...
    with pytest.raises(NonWhitespace, match="foo\\Sbar"): ...
    with pytest.raises(WordCharacter, match="foo\\wbar"): ...
    with pytest.raises(NonWordCharacter, match="foo\\Wbar"): ...
    with pytest.raises(EndOfInput, match="foo\\zbar"): ...

    with pytest.raises(StartOfInput2, match="foobar\\A"): ...
    with pytest.raises(WordBoundary2, match="foobar\\b"): ...
    with pytest.raises(NonWordBoundary2, match="foobar\\B"): ...
    with pytest.raises(Digit2, match="foobar\\d"): ...
    with pytest.raises(NonDigit2, match="foobar\\D"): ...
    with pytest.raises(Whitespace2, match="foobar\\s"): ...
    with pytest.raises(NonWhitespace2, match="foobar\\S"): ...
    with pytest.raises(WordCharacter2, match="foobar\\w"): ...
    with pytest.raises(NonWordCharacter2, match="foobar\\W"): ...
    with pytest.raises(EndOfInput2, match="foobar\\z"): ...


    ### Acceptable false positives

    with pytest.raises(NameEscape, match="\\N{EN DASH}"): ...


    ### No errors

    with pytest.raises(NoMatch): ...
    with pytest.raises(NonLiteral, match=pattern): ...
    with pytest.raises(FunctionCall, match=frobnicate("qux")): ...
    with pytest.raises(ReEscaped, match=re.escape("foobar")): ...
    with pytest.raises(RawString, match=r"fo()bar"): ...
    with pytest.raises(RawStringPart, match=r"foo" '\bar'): ...
    with pytest.raises(NoMetacharacters, match="foobar"): ...
    with pytest.raises(EndBackslash, match="foobar\\"): ...

    with pytest.raises(ManuallyEscaped, match="some\\.fully\\.qualified\\.name"): ...
    with pytest.raises(ManuallyEscapedWindowsPath, match="C:\\\\Users\\\\Foo\\\\file\\.py"): ...

    with pytest.raises(MiddleEscapedDot, match="foo\\.bar"): ...
    with pytest.raises(MiddleEscapedBackslash, match="foo\\\\bar"): ...
    with pytest.raises(EndEscapedDot, match="foobar\\."): ...
    with pytest.raises(EndEscapedBackslash, match="foobar\\\\"): ...


    ## Not-so-special metasequences

    with pytest.raises(Alert, match="\\f"): ...
    with pytest.raises(FormFeed, match="\\f"): ...
    with pytest.raises(Newline, match="\\n"): ...
    with pytest.raises(CarriageReturn, match="\\r"): ...
    with pytest.raises(Tab, match="\\t"): ...
    with pytest.raises(VerticalTab, match="\\v"): ...
    with pytest.raises(HexEscape, match="\\xFF"): ...
    with pytest.raises(_16BitUnicodeEscape, match="\\uFFFF"): ...
    with pytest.raises(_32BitUnicodeEscape, match="\\U0010FFFF"): ...

    ## Escaped metasequences

    with pytest.raises(Whitespace, match="foo\\\\sbar"): ...
    with pytest.raises(NonWhitespace, match="foo\\\\Sbar"): ...

    ## Work by accident

    with pytest.raises(OctalEscape, match="\\042"): ...
