---
icon: lucide/pi
---

# Constants

## Mathematical

* `pi`, `π`
* `τ`
* `e`
* `golden_ratio`, `φ`

## Named numbers

Large numbers

* `hundred`
* `thousand`
* `million`
* `billion`
* `trillion`
* `quadrillion`
* `quintillion`
* `googol`

Unicode fractions:

* `½`, `⅓`, `⅔`, `¼`, `¾`, …

Colloquial:

* `quarter`
* `half`
* `semi`
* `double`
* `triple`
* `dozen`

## Physics

| Description | Identifier | Dimension |
|---|---|---|
| The speed of light in vacuum | `speed_of_light`, `c` | `Velocity` |
| The Newtonian constant of gravitation | `gravitational_constant`, `G` | `Force × Length^2 / Mass^2` |
| Standard acceleration of gravity on earth | `gravity`, `g0` | `Acceleration` |
| The Planck constant | `planck_constant`, `ℎ` | `Mass × Length^2 / Time` |
| The reduced Planck constant | `h_bar`, `ℏ` | `Mass × Length^2 / Time` |
| Mass of the electron | `electron_mass` | `Mass` |
| Elementary charge (charge of the electron) | `elementary_charge`, `electron_charge` | `ElectricCharge` |
| Magnetic constant (vacuum magnetic permeability) | `magnetic_constant`, `µ0`, `mu0` | `Force / Current^2` |
| Electric constant (vacuum electric permittivity) | `electric_constant`, `ε0`, `eps0` | `Capacitance / Length` |
| Bohr magneton | `bohr_magneton`, `µ_B` | `Energy / MagneticFluxDensity` |
| Fine structure constant | `fine_structure_constant`, `alpha`, `α` | `Scalar` |
| Proton mass | `proton_mass` | `Mass` |
| Neutron mass | `neutron_mass` | `Mass` |
| Avogadro constant | `avogadro_constant`, `N_A` | `1 / AmountOfSubstance` |
| Boltzmann constant | `boltzmann_constant`, `k_B` | `Energy / Temperature` |
| Stefan-Boltzmann constant | `stefan_boltzmann_constant` | `Power / (Area × Temperature^4)` |
| Ideal gas constant | `gas_constant`, `R` | `Energy / (AmountOfSubstance × Temperature)` |
| Planck length | `planck_length` | `Length` |
| Planck mass | `planck_mass` | `Mass` |
| Planck time | `planck_time` | `Time` |
| Planck temperature | `planck_temperature` | `Temperature` |
| Planck energy | `planck_energy` | `Energy` |
| Bohr radius | `bohr_radius`, `a0` | `Length` |
| Rydberg constant | `rydberg_constant` | `Wavenumber` |
