# NAME

**hx** - Futuristic take on hexdump, made in Rust.

# SYNOPSIS

```txt
hx [-tcfl][--color=0,1][--cols 0-9][--format oxXb] inputfile
hx [-a rcgpkjsf][--array=rcgpkjsf] inputfile
hx [-up][--func 0-9][--places 0-9]
hx [-hV]
```

# OPTIONS

```txt
hx
Futuristic take on hexdump, made in Rust.

USAGE:
    hx [OPTIONS] [INPUTFILE]
    <stdin> hx [OPTIONS]

FLAGS:
    -h, --help       Prints help information
    -V, --version    Prints version information

OPTIONS:
    -a, --array <array_format>    Set source code format output: rust (r), C (c), golang (g), python (p), kotlin (k),
                                  java (j), swift (s), fsharp (f) [possible values: r, c, g, p, k, j, s, f]
    -t, --color <color>           Set color tint terminal output. 0 to disable, 1 to enable [possible values: 0, 1]
    -c, --cols <columns>          Set column length
    -f, --format <format>         Set format of octet: Octal (o), LowerHex (x), UpperHex (X), Binary (b) [possible
                                  values: o, x, X, b]
    -u, --func <func_length>      Set function wave length
    -l, --len <len>               Set <len> bytes to read
    -p, --places <func_places>    Set function wave output decimal places

ARGS:
    <INPUTFILE>    Pass file path as an argument, or input data may be passed via stdin
```

# DESCRIPTION

**hx** outputs a hexadecimal representation of input.

Defaults to colorized output, with option to disable color via -t [0,1] parameter.

The **NO_COLOR** environment variable is honored if set.

# EXIT STATUS

**hx** exits 0 on success, and >0 if an error occurs.

# EXAMPLES

**hx** with file path as input, outputting colorized hexadecimal:

```sh
$ hx tests/files/alphanumeric.txt
0x000000: 0x61 0x62 0x63 0x64 0x65 0x66 0x67 0x68 0x69 0x6a abcdefghij
0x00000a: 0x6b 0x69 0x6c 0x6d 0x6e 0x6f 0x70 0x71 0x72 0x73 kilmnopqrs
0x000014: 0x74 0x75 0x76 0x77 0x78 0x79 0x7a 0x30 0x31 0x32 tuvwxyz012
0x00001e: 0x33 0x34 0x35 0x36 0x37 0x38 0x39 0x0a 0x30 0x31 3456789.01
0x000028: 0x32 0x33 0x34 0x35 0x36 0x37 0x38 0x39 0x30 0x31 2345678901
0x000032: 0x32 0x33 0x34 0x35 0x36 0x37 0x38 0x39 0x30 0x31 2345678901
0x00003c: 0x32 0x33 0x34 0x35 0x36 0x37 0x38 0x39           23456789
   bytes: 68
```

**hx** with stdin as input, outputting colorized hexadecimal:

```sh
$ cat tests/files/alphanumeric.txt | hx
0x000000: 0x61 0x62 0x63 0x64 0x65 0x66 0x67 0x68 0x69 0x6a abcdefghij
0x00000a: 0x6b 0x69 0x6c 0x6d 0x6e 0x6f 0x70 0x71 0x72 0x73 kilmnopqrs
0x000014: 0x74 0x75 0x76 0x77 0x78 0x79 0x7a 0x30 0x31 0x32 tuvwxyz012
0x00001e: 0x33 0x34 0x35 0x36 0x37 0x38 0x39 0x0a 0x30 0x31 3456789.01
0x000028: 0x32 0x33 0x34 0x35 0x36 0x37 0x38 0x39 0x30 0x31 2345678901
0x000032: 0x32 0x33 0x34 0x35 0x36 0x37 0x38 0x39 0x30 0x31 2345678901
0x00003c: 0x32 0x33 0x34 0x35 0x36 0x37 0x38 0x39           23456789
   bytes: 68
```

# SEE ALSO

cat(1), echo(1), more(1), less(1), head(1), tail(1), hexdump(1)
