/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.fn;

import java.util.function.BiFunction;
import java.util.function.Function;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.expr.Expr;
import org.basex.query.func.fn.PlanFn;
import org.basex.query.value.Value;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.QNm;
import org.basex.query.value.item.Str;
import org.basex.query.value.map.XQMap;
import org.basex.query.value.node.ANode;
import org.basex.query.value.seq.Empty;
import org.basex.query.value.type.Types;
import org.basex.util.Enums;
import org.basex.util.InputInfo;
import org.basex.util.Token;
import org.basex.util.Util;
import org.basex.util.options.EnumOption;
import org.basex.util.options.Options;
import org.basex.util.options.StringOption;
import org.basex.util.options.ValueOption;

public final class FnElementToMap
extends PlanFn {
    @Override
    public Item item(QueryContext qc, InputInfo ii) throws QueryException {
        Item value2;
        Item element = this.arg(0).item(qc, this.info);
        if (element.isEmpty()) {
            return Empty.VALUE;
        }
        ANode elem = this.toElem(element, qc);
        ElementsOptions options = this.toOptions(this.arg(1), new ElementsOptions(), qc);
        PlanFn.Plan plan = new PlanFn.Plan();
        plan.name = options.get(ElementsOptions.NAME_FORMAT);
        plan.marker = options.get(ElementsOptions.ATTRIBUTE_MARKER);
        Value pln = options.get(ElementsOptions.PLAN);
        if (!pln.isEmpty()) {
            this.toMap(pln, qc).forEach((key, value) -> {
                byte[] token = key.string(this.info);
                boolean attr = Token.startsWith(token, 64);
                QNm name = Token.eq(token, Token.cpToken(42)) ? QNm.EMPTY : qc.shared.parseQName(attr ? Token.substring(token, 1) : token, true, this.sc());
                if (name != null) {
                    QNm qnm;
                    Value child;
                    Value type;
                    PlanFn.PlanEntry pe = new PlanFn.PlanEntry(this);
                    pe.attribute = attr;
                    XQMap map = this.toMap((Expr)value, qc);
                    Value layout = map.get(LAYOUT);
                    if (!layout.isEmpty()) {
                        pe.layout = Enums.get(PlanFn.PlanLayout.class, this.toString(layout, qc));
                    }
                    if (!(type = map.get(TYPE)).isEmpty()) {
                        pe.type = Enums.get(PlanFn.PlanType.class, this.toString(type, qc));
                    }
                    if (!(child = map.get(CHILD)).isEmpty() && (qnm = qc.shared.parseQName(this.toToken(child, qc), true, this.sc())) != null) {
                        pe.child = qnm;
                    }
                    plan.entries.put(name, pe);
                    Function<String, QueryException> where = s -> QueryError.INVALIDOPTION_X.get(this.info, Util.info("Missing key '%' (node: %).", s, name));
                    BiFunction<String, Object, QueryException> why = (s, t) -> QueryError.INVALIDOPTION_X.get(this.info, Util.info("Unexpected key '%':'%' (node: %).", s, t, name));
                    if (pe.layout == null) {
                        if (!pe.attribute) {
                            throw where.apply("layout");
                        }
                    } else if (pe.attribute) {
                        throw why.apply("layout", (Object)pe.layout);
                    }
                    if (pe.layout == PlanFn.PlanLayout.LIST || pe.layout == PlanFn.PlanLayout.LIST_PLUS) {
                        if (pe.child == null) {
                            throw where.apply("child");
                        }
                    } else if (pe.child != null) {
                        throw why.apply("child", pe.child);
                    }
                    if (pe.layout == PlanFn.PlanLayout.SIMPLE || pe.layout == PlanFn.PlanLayout.SIMPLE_PLUS || pe.attribute ? !pe.attribute && pe.type == PlanFn.PlanType.SKIP : pe.type != null) {
                        throw why.apply("type", (Object)pe.type);
                    }
                }
            });
        }
        return (value2 = this.entry(elem, plan).apply(elem, null, plan, qc)).isEmpty() ? value2 : XQMap.get(Str.get(FnElementToMap.nodeName(elem, null, plan, qc)), value2);
    }

    public static class ElementsOptions
    extends Options {
        public static final StringOption ATTRIBUTE_MARKER = new StringOption("attribute-marker", "@");
        public static final EnumOption<PlanFn.NameFormat> NAME_FORMAT = new EnumOption<PlanFn.NameFormat>("name-format", PlanFn.NameFormat.DEFAULT);
        public static final ValueOption PLAN = new ValueOption("plan", Types.MAP_ZO);
    }
}

