/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func;

import java.util.ArrayList;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import org.basex.core.Text;
import org.basex.query.CompileContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.QueryPlan;
import org.basex.query.QueryString;
import org.basex.query.QuerySupplier;
import org.basex.query.QueryText;
import org.basex.query.StaticContext;
import org.basex.query.ann.Annotation;
import org.basex.query.expr.Expr;
import org.basex.query.expr.ExprInfo;
import org.basex.query.expr.Single;
import org.basex.query.func.Functions;
import org.basex.query.func.StaticFunc;
import org.basex.query.func.StaticFuncCall;
import org.basex.query.func.java.JavaCall;
import org.basex.query.util.hash.QNmMap;
import org.basex.query.util.hash.QNmSet;
import org.basex.query.util.list.AnnList;
import org.basex.query.util.parse.Params;
import org.basex.query.value.item.QNm;
import org.basex.query.value.type.SeqType;
import org.basex.query.value.type.Types;
import org.basex.query.var.Var;
import org.basex.query.var.VarScope;
import org.basex.util.InputInfo;
import org.basex.util.Token;
import org.basex.util.Util;
import org.basex.util.hash.IntObjectMap;
import org.basex.util.hash.TokenObjectMap;
import org.basex.util.list.IntList;
import org.basex.util.similarity.Levenshtein;

public final class StaticFuncs
extends ExprInfo
implements Iterable<StaticFunc> {
    private final TokenObjectMap<QNmMap<ArrayList<StaticFunc>>> funcsByModule = new TokenObjectMap();
    private final ArrayList<FuncRef> unresolvedRefs = new ArrayList();
    private final Map<StaticFunc, ArrayList<StaticFuncCall>> callsMap = new IdentityHashMap<StaticFunc, ArrayList<StaticFuncCall>>();

    public StaticFunc declare(StaticContext sc, QNm name, Params params, Expr expr, AnnList anns, String doc, VarScope vs, InputInfo info) throws QueryException {
        byte[] modUri = Token.eq(name.uri(), QueryText.FN_URI) ? QueryText.FN_URI : QNm.uri(sc.module);
        StaticFunc sf = new StaticFunc(name, params, expr, anns, vs, info, doc);
        if (this.get(sc, name, sf.min, sf.arity()) != null) {
            throw QueryError.DUPLFUNC_X.get(info, name);
        }
        this.funcsByModule.computeIfAbsent(modUri, QNmMap::new).computeIfAbsent(name, ArrayList::new).add(sf);
        return sf;
    }

    public Expr newRef(QuerySupplier<Expr> resolve) {
        FuncRef fr = new FuncRef(resolve);
        this.unresolvedRefs.add(fr);
        return fr;
    }

    void setFunc(StaticFuncCall call, QueryContext qc) throws QueryException {
        InputInfo info = call.info();
        QNm name = call.name;
        int arity = call.arity();
        StaticFunc func = this.get(info.sc(), name, arity);
        if (func != null) {
            if (func.expr == null) {
                throw QueryError.FUNCNOIMPL_X.get(func.info, new Object[]{func.name.prefixString()});
            }
            call.setFunc(func);
            if (func.updating) {
                qc.updating();
            }
            this.callsMap.computeIfAbsent(func, k -> new ArrayList(1)).add(call);
        } else {
            JavaCall java = JavaCall.get(name, call.exprs, qc, info);
            if (java == null) {
                throw this.unknownFunctionError(name, arity, info);
            }
            call.setExternal(java);
            if (java.updating) {
                qc.updating();
            }
        }
    }

    public void resolve() throws QueryException {
        for (FuncRef fr : this.unresolvedRefs) {
            fr.resolve();
        }
        this.unresolvedRefs.clear();
    }

    public void checkUp() throws QueryException {
        for (StaticFunc func : this) {
            func.checkUp();
        }
    }

    public void compileAll(CompileContext cc) {
        for (StaticFunc func : this) {
            func.compile(cc);
        }
    }

    public StaticFunc get(StaticContext sc, QNm qname, int arity) {
        return this.get(sc, qname, arity, arity);
    }

    private StaticFunc get(StaticContext sc, QNm qname, int min, int max) {
        byte[] funcUri = qname.uri();
        byte[] modUri = Token.eq(funcUri, QueryText.FN_URI) ? QueryText.FN_URI : QNm.uri(sc.module);
        StaticFunc func = this.get(modUri, qname, min, max);
        if (func == null && sc.imports.contains(funcUri) && (func = this.get(funcUri, qname, min, max)) != null && func.anns.contains(Annotation.PRIVATE)) {
            func = null;
        }
        return func;
    }

    private StaticFunc get(byte[] modUri, QNm qname, int min, int max) {
        ArrayList<StaticFunc> funcs;
        QNmMap<ArrayList<StaticFunc>> funcsByName = this.funcsByModule.get(modUri);
        if (funcsByName != null && (funcs = funcsByName.get(qname)) != null) {
            for (StaticFunc func : funcs) {
                if (min > func.arity() || max < func.min) continue;
                return func;
            }
        }
        return null;
    }

    SeqType[] seqTypes(StaticFunc func) {
        ArrayList<StaticFuncCall> calls = this.callsMap.get(func);
        int sl = func.arity();
        if (calls == null || calls.isEmpty() || sl == 0) {
            return null;
        }
        SeqType[] seqTypes = new SeqType[sl];
        for (StaticFuncCall call : calls) {
            for (int s = 0; s < sl; ++s) {
                SeqType st = call.arg(s).seqType();
                SeqType stOld = seqTypes[s];
                seqTypes[s] = stOld == null ? st : stOld.union(st);
            }
        }
        return seqTypes;
    }

    QueryException unknownFunctionError(QNm name, int arity, InputInfo info) {
        byte[] funcUri = name.uri();
        StaticFunc sf = this.get(funcUri, name, arity, arity);
        if (sf != null) {
            return sf.anns.contains(Annotation.PRIVATE) ? QueryError.FUNCPRIVATE_X.get(info, name) : QueryError.INVISIBLEFUNC_X.get(info, name);
        }
        ArrayList<byte[]> modules = new ArrayList<byte[]>(2);
        if (Token.eq(funcUri, QueryText.FN_URI)) {
            modules.add(QueryText.FN_URI);
        } else {
            modules.add(QNm.uri(info.sc().module));
            if (info.sc().imports.contains(funcUri)) {
                modules.add(funcUri);
            }
        }
        IntList arities = new IntList();
        for (byte[] module : modules) {
            ArrayList<StaticFunc> funcs;
            QNmMap<ArrayList<StaticFunc>> funcsByName = this.funcsByModule.get(module);
            if (funcsByName == null || (funcs = funcsByName.get(name)) == null) continue;
            for (StaticFunc func : funcs) {
                for (int a = func.min; a <= func.arity(); ++a) {
                    arities.add(a);
                }
            }
        }
        return arities.isEmpty() ? this.similarError(name, info) : Functions.wrongArity(arity, arities, false, info, name.prefixString());
    }

    QueryException similarError(QNm qname, InputInfo info) {
        QNmSet names = new QNmSet();
        if (info != null) {
            for (StaticFunc func : this) {
                if (func.expr == null || func.anns.contains(Annotation.PRIVATE) && !Token.eq(QNm.uri(info.sc().module), QNm.uri(func.sc.module))) continue;
                names.add(func.name);
            }
        }
        QNm similar = (QNm)Levenshtein.similar(qname.local(), names.keys(), o -> ((QNm)o).local());
        return QueryError.WHICHFUNC_X.get(info, similar != null ? QueryError.similar(qname.prefixString(), similar.prefixString()) : Functions.similar(qname));
    }

    @Override
    public Iterator<StaticFunc> iterator() {
        return new Iterator<StaticFunc>(){
            final Iterator<QNmMap<ArrayList<StaticFunc>>> modules;
            Iterator<ArrayList<StaticFunc>> names;
            Iterator<StaticFunc> funcs;
            {
                this.modules = StaticFuncs.this.funcsByModule.values().iterator();
                this.names = Collections.emptyIterator();
                this.funcs = Collections.emptyIterator();
            }

            @Override
            public boolean hasNext() {
                while (!this.funcs.hasNext()) {
                    if (this.names.hasNext()) {
                        this.funcs = this.names.next().iterator();
                        continue;
                    }
                    if (this.modules.hasNext()) {
                        this.names = this.modules.next().values().iterator();
                        continue;
                    }
                    return false;
                }
                return true;
            }

            @Override
            public StaticFunc next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return this.funcs.next();
            }
        };
    }

    @Override
    public void toXml(QueryPlan plan) {
        if (this.funcsByModule.isEmpty()) {
            return;
        }
        ArrayList list = new ArrayList();
        this.forEach(list::add);
        plan.add(plan.create(this, new Object[0]), (ExprInfo[])list.toArray(StaticFunc[]::new));
    }

    @Override
    public void toString(QueryString qs) {
        for (StaticFunc func : this) {
            if (!func.compiled()) continue;
            qs.token(func).token(Text.NL);
        }
    }

    private static final class FuncRef
    extends Single {
        private final QuerySupplier<Expr> resolve;

        FuncRef(QuerySupplier<Expr> resolve) {
            super(null, null, Types.ITEM_ZM);
            this.resolve = resolve;
        }

        void resolve() throws QueryException {
            this.expr = this.resolve.get();
        }

        @Override
        public void checkUp() throws QueryException {
            this.expr.checkUp();
        }

        @Override
        public boolean vacuous() {
            return this.expr.vacuous();
        }

        @Override
        public Expr compile(CompileContext cc) throws QueryException {
            return this.expr.compile(cc);
        }

        @Override
        public Expr copy(CompileContext cc, IntObjectMap<Var> vm) {
            throw Util.notExpected();
        }

        @Override
        public void toString(QueryString qs) {
            this.expr.toString(qs);
        }
    }
}

