/*
 * Decompiled with CFR 0.152.
 */
package org.basex.io.serial;

import java.io.IOException;
import org.basex.build.Builder;
import org.basex.io.serial.Serializer;
import org.basex.query.util.ft.FTPos;
import org.basex.util.Atts;
import org.basex.util.Token;

public class BuilderSerializer
extends Serializer {
    private final Atts atts = new Atts();
    private final Atts nsp = new Atts();
    private final Builder builder;

    public BuilderSerializer(Builder builder) {
        this.builder = builder;
    }

    @Override
    protected final void text(byte[] value, FTPos ftp) throws IOException {
        this.builder.text(value);
    }

    @Override
    protected final void pi(byte[] name, byte[] value) throws IOException {
        this.builder.pi(value.length > 0 ? Token.concat(name, Token.cpToken(32), value) : name);
    }

    @Override
    protected final void finishOpen() throws IOException {
        this.builder.openElem(this.elem.string(), this.atts, this.nsp);
        this.atts.reset();
        this.nsp.reset();
    }

    @Override
    protected void finishEmpty() throws IOException {
        this.builder.emptyElem(this.elem.string(), this.atts, this.nsp);
        this.atts.reset();
        this.nsp.reset();
    }

    @Override
    protected void finishClose() throws IOException {
        this.builder.closeElem();
    }

    @Override
    protected final void comment(byte[] value) throws IOException {
        this.builder.comment(value);
    }

    @Override
    protected final void attribute(byte[] name, byte[] value, boolean standalone) {
        if (Token.startsWith(name, Token.XMLNS)) {
            if (name.length == 5) {
                this.nsp.add(Token.EMPTY, value);
            } else if (name[5] == 58) {
                this.nsp.add(Token.substring(name, 6), value);
            } else {
                this.atts.add(name, value);
            }
        } else {
            this.atts.add(name, value);
        }
    }

    @Override
    protected void openDoc(byte[] name) throws IOException {
        this.builder.openDoc(name);
    }

    @Override
    protected final void closeDoc() throws IOException {
        this.builder.closeDoc();
    }
}

