/*
 * Decompiled with CFR 0.152.
 */
package org.basex.core.cmd;

import java.io.IOException;
import java.util.zip.ZipFile;
import org.basex.core.Context;
import org.basex.core.Text;
import org.basex.core.cmd.ABackup;
import org.basex.core.parse.CmdBuilder;
import org.basex.core.parse.Commands;
import org.basex.io.IOFile;
import org.basex.util.Table;
import org.basex.util.Util;
import org.basex.util.list.TokenList;

public final class ShowBackups
extends ABackup {
    public ShowBackups() {
        super(new String[0]);
    }

    @Override
    protected boolean run() throws IOException {
        Table table = new Table();
        table.description = Text.BACKUPS_X;
        table.header.add(Text.NAME);
        table.header.add(Text.SIZE);
        table.header.add(Text.COMMENT);
        for (String backup : this.context.databases.backups()) {
            TokenList tl = new TokenList();
            tl.add(backup);
            IOFile zip = this.soptions.dbPath(backup + ".zip");
            tl.add(zip.length());
            tl.add(ShowBackups.comment(backup, this.context));
            table.contents.add(tl);
        }
        this.out.println(table.sort().finish());
        return true;
    }

    @Override
    public boolean updating(Context ctx) {
        return false;
    }

    @Override
    public void build(CmdBuilder cb) {
        cb.init(String.valueOf((Object)Commands.Cmd.SHOW) + " " + String.valueOf((Object)Commands.CmdShow.BACKUPS));
    }

    @Override
    public void addLocks() {
        this.jc().locks.reads.addGlobal();
    }

    public static String comment(String name, Context ctx) {
        String comment = null;
        try (ZipFile zf = new ZipFile(ctx.soptions.dbPath(name + ".zip").file());){
            comment = zf.getComment();
        }
        catch (IOException ex) {
            Util.debug(ex);
        }
        return comment != null ? comment : "";
    }
}

