/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.expr.gflwor;

import org.basex.query.CompileContext;
import org.basex.query.InlineContext;
import org.basex.query.QueryException;
import org.basex.query.expr.ContextValue;
import org.basex.query.expr.Expr;
import org.basex.query.expr.Filter;
import org.basex.query.expr.gflwor.Clause;
import org.basex.query.expr.path.AxisPath;
import org.basex.query.func.Function;
import org.basex.query.util.Flag;
import org.basex.query.value.type.SeqType;
import org.basex.query.var.Var;
import org.basex.query.var.VarUsage;
import org.basex.util.InputInfo;

abstract class ForLet
extends Clause {
    public Var var;
    public Expr expr;
    boolean scoring;

    ForLet(InputInfo info, SeqType seqType, Var var, Expr expr, boolean scoring, Var ... vars) {
        super(info, seqType, vars);
        this.var = var;
        this.expr = expr;
        this.scoring = scoring;
    }

    @Override
    public final Clause compile(CompileContext cc) throws QueryException {
        this.expr = this.expr.compile(cc);
        return this.optimize(cc);
    }

    @Override
    public final boolean has(Flag ... flags) {
        return this.expr.has(flags);
    }

    @Override
    public final boolean inlineable(InlineContext v) {
        return this.expr.inlineable(v);
    }

    @Override
    public final VarUsage count(Var v) {
        return this.expr.count(v);
    }

    @Override
    public final Clause inline(InlineContext ic) throws QueryException {
        Expr inlined = this.expr.inline(ic);
        if (inlined == null) {
            return null;
        }
        this.expr = inlined;
        return this.optimize(ic.cc);
    }

    abstract Expr inlineExpr(CompileContext var1) throws QueryException;

    final boolean toPredicate(CompileContext cc, Expr ex) throws QueryException {
        if (this.vars.length != 1 || this.scoring || this.var.declType != null || this.size() != 1L || !ex.uses(this.var)) {
            return false;
        }
        InlineContext ic = new InlineContext(this.var, new ContextValue(this.info), cc);
        if (!ic.inlineable(ex)) {
            return false;
        }
        Expr pred = cc.get(this.expr, true, () -> ic.inline(ex));
        if (pred.seqType().mayBeNumber()) {
            pred = cc.function(Function.BOOLEAN, this.info, pred);
        }
        this.addPredicate(cc, pred);
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    final void addPredicate(CompileContext cc, Expr ex) throws QueryException {
        Expr expr = this.expr;
        if (expr instanceof AxisPath) {
            AxisPath path = (AxisPath)expr;
            if (!ex.has(Flag.POS)) {
                this.expr = path.addPredicates(cc, ex);
                return;
            }
        }
        if ((expr = this.expr) instanceof Filter) {
            Filter filter = (Filter)expr;
            this.expr = filter.addPredicate(cc, ex);
            return;
        }
        this.expr = Filter.get(cc, this.info, this.expr, ex);
    }

    @Override
    public final void checkUp() throws QueryException {
        this.checkNoUp(this.expr);
    }

    @Override
    public final int exprSize() {
        return this.expr.exprSize();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof ForLet)) return false;
        ForLet fl = (ForLet)obj;
        if (!this.expr.equals(fl.expr)) return false;
        if (!this.var.equals(fl.var)) return false;
        if (this.scoring != fl.scoring) return false;
        return true;
    }
}

