import extras/htmlparser

proc htmlEntityToUtf8*(s: string): string =
  case s
  of "&AElig": "\u00C6"
  of "&AElig;": "\u00C6"
  of "&AMP": "\u0026"
  of "&AMP;": "\u0026"
  of "&Aacute": "\u00C1"
  of "&Aacute;": "\u00C1"
  of "&Abreve;": "\u0102"
  of "&Acirc": "\u00C2"
  of "&Acirc;": "\u00C2"
  of "&Acy;": "\u0410"
  of "&Afr;": "\uD835\uDD04"
  of "&Agrave": "\u00C0"
  of "&Agrave;": "\u00C0"
  of "&Alpha;": "\u0391"
  of "&Amacr;": "\u0100"
  of "&And;": "\u2A53"
  of "&Aogon;": "\u0104"
  of "&Aopf;": "\uD835\uDD38"
  of "&ApplyFunction;": "\u2061"
  of "&Aring": "\u00C5"
  of "&Aring;": "\u00C5"
  of "&Ascr;": "\uD835\uDC9C"
  of "&Assign;": "\u2254"
  of "&Atilde": "\u00C3"
  of "&Atilde;": "\u00C3"
  of "&Auml": "\u00C4"
  of "&Auml;": "\u00C4"
  of "&Backslash;": "\u2216"
  of "&Barv;": "\u2AE7"
  of "&Barwed;": "\u2306"
  of "&Bcy;": "\u0411"
  of "&Because;": "\u2235"
  of "&Bernoullis;": "\u212C"
  of "&Beta;": "\u0392"
  of "&Bfr;": "\uD835\uDD05"
  of "&Bopf;": "\uD835\uDD39"
  of "&Breve;": "\u02D8"
  of "&Bscr;": "\u212C"
  of "&Bumpeq;": "\u224E"
  of "&CHcy;": "\u0427"
  of "&COPY": "\u00A9"
  of "&COPY;": "\u00A9"
  of "&Cacute;": "\u0106"
  of "&Cap;": "\u22D2"
  of "&CapitalDifferentialD;": "\u2145"
  of "&Cayleys;": "\u212D"
  of "&Ccaron;": "\u010C"
  of "&Ccedil": "\u00C7"
  of "&Ccedil;": "\u00C7"
  of "&Ccirc;": "\u0108"
  of "&Cconint;": "\u2230"
  of "&Cdot;": "\u010A"
  of "&Cedilla;": "\u00B8"
  of "&CenterDot;": "\u00B7"
  of "&Cfr;": "\u212D"
  of "&Chi;": "\u03A7"
  of "&CircleDot;": "\u2299"
  of "&CircleMinus;": "\u2296"
  of "&CirclePlus;": "\u2295"
  of "&CircleTimes;": "\u2297"
  of "&ClockwiseContourIntegral;": "\u2232"
  of "&CloseCurlyDoubleQuote;": "\u201D"
  of "&CloseCurlyQuote;": "\u2019"
  of "&Colon;": "\u2237"
  of "&Colone;": "\u2A74"
  of "&Congruent;": "\u2261"
  of "&Conint;": "\u222F"
  of "&ContourIntegral;": "\u222E"
  of "&Copf;": "\u2102"
  of "&Coproduct;": "\u2210"
  of "&CounterClockwiseContourIntegral;": "\u2233"
  of "&Cross;": "\u2A2F"
  of "&Cscr;": "\uD835\uDC9E"
  of "&Cup;": "\u22D3"
  of "&CupCap;": "\u224D"
  of "&DD;": "\u2145"
  of "&DDotrahd;": "\u2911"
  of "&DJcy;": "\u0402"
  of "&DScy;": "\u0405"
  of "&DZcy;": "\u040F"
  of "&Dagger;": "\u2021"
  of "&Darr;": "\u21A1"
  of "&Dashv;": "\u2AE4"
  of "&Dcaron;": "\u010E"
  of "&Dcy;": "\u0414"
  of "&Del;": "\u2207"
  of "&Delta;": "\u0394"
  of "&Dfr;": "\uD835\uDD07"
  of "&DiacriticalAcute;": "\u00B4"
  of "&DiacriticalDot;": "\u02D9"
  of "&DiacriticalDoubleAcute;": "\u02DD"
  of "&DiacriticalGrave;": "\u0060"
  of "&DiacriticalTilde;": "\u02DC"
  of "&Diamond;": "\u22C4"
  of "&DifferentialD;": "\u2146"
  of "&Dopf;": "\uD835\uDD3B"
  of "&Dot;": "\u00A8"
  of "&DotDot;": "\u20DC"
  of "&DotEqual;": "\u2250"
  of "&DoubleContourIntegral;": "\u222F"
  of "&DoubleDot;": "\u00A8"
  of "&DoubleDownArrow;": "\u21D3"
  of "&DoubleLeftArrow;": "\u21D0"
  of "&DoubleLeftRightArrow;": "\u21D4"
  of "&DoubleLeftTee;": "\u2AE4"
  of "&DoubleLongLeftArrow;": "\u27F8"
  of "&DoubleLongLeftRightArrow;": "\u27FA"
  of "&DoubleLongRightArrow;": "\u27F9"
  of "&DoubleRightArrow;": "\u21D2"
  of "&DoubleRightTee;": "\u22A8"
  of "&DoubleUpArrow;": "\u21D1"
  of "&DoubleUpDownArrow;": "\u21D5"
  of "&DoubleVerticalBar;": "\u2225"
  of "&DownArrow;": "\u2193"
  of "&DownArrowBar;": "\u2913"
  of "&DownArrowUpArrow;": "\u21F5"
  of "&DownBreve;": "\u0311"
  of "&DownLeftRightVector;": "\u2950"
  of "&DownLeftTeeVector;": "\u295E"
  of "&DownLeftVector;": "\u21BD"
  of "&DownLeftVectorBar;": "\u2956"
  of "&DownRightTeeVector;": "\u295F"
  of "&DownRightVector;": "\u21C1"
  of "&DownRightVectorBar;": "\u2957"
  of "&DownTee;": "\u22A4"
  of "&DownTeeArrow;": "\u21A7"
  of "&Downarrow;": "\u21D3"
  of "&Dscr;": "\uD835\uDC9F"
  of "&Dstrok;": "\u0110"
  of "&ENG;": "\u014A"
  of "&ETH": "\u00D0"
  of "&ETH;": "\u00D0"
  of "&Eacute": "\u00C9"
  of "&Eacute;": "\u00C9"
  of "&Ecaron;": "\u011A"
  of "&Ecirc": "\u00CA"
  of "&Ecirc;": "\u00CA"
  of "&Ecy;": "\u042D"
  of "&Edot;": "\u0116"
  of "&Efr;": "\uD835\uDD08"
  of "&Egrave": "\u00C8"
  of "&Egrave;": "\u00C8"
  of "&Element;": "\u2208"
  of "&Emacr;": "\u0112"
  of "&EmptySmallSquare;": "\u25FB"
  of "&EmptyVerySmallSquare;": "\u25AB"
  of "&Eogon;": "\u0118"
  of "&Eopf;": "\uD835\uDD3C"
  of "&Epsilon;": "\u0395"
  of "&Equal;": "\u2A75"
  of "&EqualTilde;": "\u2242"
  of "&Equilibrium;": "\u21CC"
  of "&Escr;": "\u2130"
  of "&Esim;": "\u2A73"
  of "&Eta;": "\u0397"
  of "&Euml": "\u00CB"
  of "&Euml;": "\u00CB"
  of "&Exists;": "\u2203"
  of "&ExponentialE;": "\u2147"
  of "&Fcy;": "\u0424"
  of "&Ffr;": "\uD835\uDD09"
  of "&FilledSmallSquare;": "\u25FC"
  of "&FilledVerySmallSquare;": "\u25AA"
  of "&Fopf;": "\uD835\uDD3D"
  of "&ForAll;": "\u2200"
  of "&Fouriertrf;": "\u2131"
  of "&Fscr;": "\u2131"
  of "&GJcy;": "\u0403"
  of "&GT": "\u003E"
  of "&GT;": "\u003E"
  of "&Gamma;": "\u0393"
  of "&Gammad;": "\u03DC"
  of "&Gbreve;": "\u011E"
  of "&Gcedil;": "\u0122"
  of "&Gcirc;": "\u011C"
  of "&Gcy;": "\u0413"
  of "&Gdot;": "\u0120"
  of "&Gfr;": "\uD835\uDD0A"
  of "&Gg;": "\u22D9"
  of "&Gopf;": "\uD835\uDD3E"
  of "&GreaterEqual;": "\u2265"
  of "&GreaterEqualLess;": "\u22DB"
  of "&GreaterFullEqual;": "\u2267"
  of "&GreaterGreater;": "\u2AA2"
  of "&GreaterLess;": "\u2277"
  of "&GreaterSlantEqual;": "\u2A7E"
  of "&GreaterTilde;": "\u2273"
  of "&Gscr;": "\uD835\uDCA2"
  of "&Gt;": "\u226B"
  of "&HARDcy;": "\u042A"
  of "&Hacek;": "\u02C7"
  of "&Hat;": "\u005E"
  of "&Hcirc;": "\u0124"
  of "&Hfr;": "\u210C"
  of "&HilbertSpace;": "\u210B"
  of "&Hopf;": "\u210D"
  of "&HorizontalLine;": "\u2500"
  of "&Hscr;": "\u210B"
  of "&Hstrok;": "\u0126"
  of "&HumpDownHump;": "\u224E"
  of "&HumpEqual;": "\u224F"
  of "&IEcy;": "\u0415"
  of "&IJlig;": "\u0132"
  of "&IOcy;": "\u0401"
  of "&Iacute": "\u00CD"
  of "&Iacute;": "\u00CD"
  of "&Icirc": "\u00CE"
  of "&Icirc;": "\u00CE"
  of "&Icy;": "\u0418"
  of "&Idot;": "\u0130"
  of "&Ifr;": "\u2111"
  of "&Igrave": "\u00CC"
  of "&Igrave;": "\u00CC"
  of "&Im;": "\u2111"
  of "&Imacr;": "\u012A"
  of "&ImaginaryI;": "\u2148"
  of "&Implies;": "\u21D2"
  of "&Int;": "\u222C"
  of "&Integral;": "\u222B"
  of "&Intersection;": "\u22C2"
  of "&InvisibleComma;": "\u2063"
  of "&InvisibleTimes;": "\u2062"
  of "&Iogon;": "\u012E"
  of "&Iopf;": "\uD835\uDD40"
  of "&Iota;": "\u0399"
  of "&Iscr;": "\u2110"
  of "&Itilde;": "\u0128"
  of "&Iukcy;": "\u0406"
  of "&Iuml": "\u00CF"
  of "&Iuml;": "\u00CF"
  of "&Jcirc;": "\u0134"
  of "&Jcy;": "\u0419"
  of "&Jfr;": "\uD835\uDD0D"
  of "&Jopf;": "\uD835\uDD41"
  of "&Jscr;": "\uD835\uDCA5"
  of "&Jsercy;": "\u0408"
  of "&Jukcy;": "\u0404"
  of "&KHcy;": "\u0425"
  of "&KJcy;": "\u040C"
  of "&Kappa;": "\u039A"
  of "&Kcedil;": "\u0136"
  of "&Kcy;": "\u041A"
  of "&Kfr;": "\uD835\uDD0E"
  of "&Kopf;": "\uD835\uDD42"
  of "&Kscr;": "\uD835\uDCA6"
  of "&LJcy;": "\u0409"
  of "&LT": "\u003C"
  of "&LT;": "\u003C"
  of "&Lacute;": "\u0139"
  of "&Lambda;": "\u039B"
  of "&Lang;": "\u27EA"
  of "&Laplacetrf;": "\u2112"
  of "&Larr;": "\u219E"
  of "&Lcaron;": "\u013D"
  of "&Lcedil;": "\u013B"
  of "&Lcy;": "\u041B"
  of "&LeftAngleBracket;": "\u27E8"
  of "&LeftArrow;": "\u2190"
  of "&LeftArrowBar;": "\u21E4"
  of "&LeftArrowRightArrow;": "\u21C6"
  of "&LeftCeiling;": "\u2308"
  of "&LeftDoubleBracket;": "\u27E6"
  of "&LeftDownTeeVector;": "\u2961"
  of "&LeftDownVector;": "\u21C3"
  of "&LeftDownVectorBar;": "\u2959"
  of "&LeftFloor;": "\u230A"
  of "&LeftRightArrow;": "\u2194"
  of "&LeftRightVector;": "\u294E"
  of "&LeftTee;": "\u22A3"
  of "&LeftTeeArrow;": "\u21A4"
  of "&LeftTeeVector;": "\u295A"
  of "&LeftTriangle;": "\u22B2"
  of "&LeftTriangleBar;": "\u29CF"
  of "&LeftTriangleEqual;": "\u22B4"
  of "&LeftUpDownVector;": "\u2951"
  of "&LeftUpTeeVector;": "\u2960"
  of "&LeftUpVector;": "\u21BF"
  of "&LeftUpVectorBar;": "\u2958"
  of "&LeftVector;": "\u21BC"
  of "&LeftVectorBar;": "\u2952"
  of "&Leftarrow;": "\u21D0"
  of "&Leftrightarrow;": "\u21D4"
  of "&LessEqualGreater;": "\u22DA"
  of "&LessFullEqual;": "\u2266"
  of "&LessGreater;": "\u2276"
  of "&LessLess;": "\u2AA1"
  of "&LessSlantEqual;": "\u2A7D"
  of "&LessTilde;": "\u2272"
  of "&Lfr;": "\uD835\uDD0F"
  of "&Ll;": "\u22D8"
  of "&Lleftarrow;": "\u21DA"
  of "&Lmidot;": "\u013F"
  of "&LongLeftArrow;": "\u27F5"
  of "&LongLeftRightArrow;": "\u27F7"
  of "&LongRightArrow;": "\u27F6"
  of "&Longleftarrow;": "\u27F8"
  of "&Longleftrightarrow;": "\u27FA"
  of "&Longrightarrow;": "\u27F9"
  of "&Lopf;": "\uD835\uDD43"
  of "&LowerLeftArrow;": "\u2199"
  of "&LowerRightArrow;": "\u2198"
  of "&Lscr;": "\u2112"
  of "&Lsh;": "\u21B0"
  of "&Lstrok;": "\u0141"
  of "&Lt;": "\u226A"
  of "&Map;": "\u2905"
  of "&Mcy;": "\u041C"
  of "&MediumSpace;": "\u205F"
  of "&Mellintrf;": "\u2133"
  of "&Mfr;": "\uD835\uDD10"
  of "&MinusPlus;": "\u2213"
  of "&Mopf;": "\uD835\uDD44"
  of "&Mscr;": "\u2133"
  of "&Mu;": "\u039C"
  of "&NJcy;": "\u040A"
  of "&Nacute;": "\u0143"
  of "&Ncaron;": "\u0147"
  of "&Ncedil;": "\u0145"
  of "&Ncy;": "\u041D"
  of "&NegativeMediumSpace;": "\u200B"
  of "&NegativeThickSpace;": "\u200B"
  of "&NegativeThinSpace;": "\u200B"
  of "&NegativeVeryThinSpace;": "\u200B"
  of "&NestedGreaterGreater;": "\u226B"
  of "&NestedLessLess;": "\u226A"
  of "&NewLine;": "\u000A"
  of "&Nfr;": "\uD835\uDD11"
  of "&NoBreak;": "\u2060"
  of "&NonBreakingSpace;": "\u00A0"
  of "&Nopf;": "\u2115"
  of "&Not;": "\u2AEC"
  of "&NotCongruent;": "\u2262"
  of "&NotCupCap;": "\u226D"
  of "&NotDoubleVerticalBar;": "\u2226"
  of "&NotElement;": "\u2209"
  of "&NotEqual;": "\u2260"
  of "&NotEqualTilde;": "\u2242\u0338"
  of "&NotExists;": "\u2204"
  of "&NotGreater;": "\u226F"
  of "&NotGreaterEqual;": "\u2271"
  of "&NotGreaterFullEqual;": "\u2267\u0338"
  of "&NotGreaterGreater;": "\u226B\u0338"
  of "&NotGreaterLess;": "\u2279"
  of "&NotGreaterSlantEqual;": "\u2A7E\u0338"
  of "&NotGreaterTilde;": "\u2275"
  of "&NotHumpDownHump;": "\u224E\u0338"
  of "&NotHumpEqual;": "\u224F\u0338"
  of "&NotLeftTriangle;": "\u22EA"
  of "&NotLeftTriangleBar;": "\u29CF\u0338"
  of "&NotLeftTriangleEqual;": "\u22EC"
  of "&NotLess;": "\u226E"
  of "&NotLessEqual;": "\u2270"
  of "&NotLessGreater;": "\u2278"
  of "&NotLessLess;": "\u226A\u0338"
  of "&NotLessSlantEqual;": "\u2A7D\u0338"
  of "&NotLessTilde;": "\u2274"
  of "&NotNestedGreaterGreater;": "\u2AA2\u0338"
  of "&NotNestedLessLess;": "\u2AA1\u0338"
  of "&NotPrecedes;": "\u2280"
  of "&NotPrecedesEqual;": "\u2AAF\u0338"
  of "&NotPrecedesSlantEqual;": "\u22E0"
  of "&NotReverseElement;": "\u220C"
  of "&NotRightTriangle;": "\u22EB"
  of "&NotRightTriangleBar;": "\u29D0\u0338"
  of "&NotRightTriangleEqual;": "\u22ED"
  of "&NotSquareSubset;": "\u228F\u0338"
  of "&NotSquareSubsetEqual;": "\u22E2"
  of "&NotSquareSuperset;": "\u2290\u0338"
  of "&NotSquareSupersetEqual;": "\u22E3"
  of "&NotSubset;": "\u2282\u20D2"
  of "&NotSubsetEqual;": "\u2288"
  of "&NotSucceeds;": "\u2281"
  of "&NotSucceedsEqual;": "\u2AB0\u0338"
  of "&NotSucceedsSlantEqual;": "\u22E1"
  of "&NotSucceedsTilde;": "\u227F\u0338"
  of "&NotSuperset;": "\u2283\u20D2"
  of "&NotSupersetEqual;": "\u2289"
  of "&NotTilde;": "\u2241"
  of "&NotTildeEqual;": "\u2244"
  of "&NotTildeFullEqual;": "\u2247"
  of "&NotTildeTilde;": "\u2249"
  of "&NotVerticalBar;": "\u2224"
  of "&Nscr;": "\uD835\uDCA9"
  of "&Ntilde": "\u00D1"
  of "&Ntilde;": "\u00D1"
  of "&Nu;": "\u039D"
  of "&OElig;": "\u0152"
  of "&Oacute": "\u00D3"
  of "&Oacute;": "\u00D3"
  of "&Ocirc": "\u00D4"
  of "&Ocirc;": "\u00D4"
  of "&Ocy;": "\u041E"
  of "&Odblac;": "\u0150"
  of "&Ofr;": "\uD835\uDD12"
  of "&Ograve": "\u00D2"
  of "&Ograve;": "\u00D2"
  of "&Omacr;": "\u014C"
  of "&Omega;": "\u03A9"
  of "&Omicron;": "\u039F"
  of "&Oopf;": "\uD835\uDD46"
  of "&OpenCurlyDoubleQuote;": "\u201C"
  of "&OpenCurlyQuote;": "\u2018"
  of "&Or;": "\u2A54"
  of "&Oscr;": "\uD835\uDCAA"
  of "&Oslash": "\u00D8"
  of "&Oslash;": "\u00D8"
  of "&Otilde": "\u00D5"
  of "&Otilde;": "\u00D5"
  of "&Otimes;": "\u2A37"
  of "&Ouml": "\u00D6"
  of "&Ouml;": "\u00D6"
  of "&OverBar;": "\u203E"
  of "&OverBrace;": "\u23DE"
  of "&OverBracket;": "\u23B4"
  of "&OverParenthesis;": "\u23DC"
  of "&PartialD;": "\u2202"
  of "&Pcy;": "\u041F"
  of "&Pfr;": "\uD835\uDD13"
  of "&Phi;": "\u03A6"
  of "&Pi;": "\u03A0"
  of "&PlusMinus;": "\u00B1"
  of "&Poincareplane;": "\u210C"
  of "&Popf;": "\u2119"
  of "&Pr;": "\u2ABB"
  of "&Precedes;": "\u227A"
  of "&PrecedesEqual;": "\u2AAF"
  of "&PrecedesSlantEqual;": "\u227C"
  of "&PrecedesTilde;": "\u227E"
  of "&Prime;": "\u2033"
  of "&Product;": "\u220F"
  of "&Proportion;": "\u2237"
  of "&Proportional;": "\u221D"
  of "&Pscr;": "\uD835\uDCAB"
  of "&Psi;": "\u03A8"
  of "&QUOT": "\u0022"
  of "&QUOT;": "\u0022"
  of "&Qfr;": "\uD835\uDD14"
  of "&Qopf;": "\u211A"
  of "&Qscr;": "\uD835\uDCAC"
  of "&RBarr;": "\u2910"
  of "&REG": "\u00AE"
  of "&REG;": "\u00AE"
  of "&Racute;": "\u0154"
  of "&Rang;": "\u27EB"
  of "&Rarr;": "\u21A0"
  of "&Rarrtl;": "\u2916"
  of "&Rcaron;": "\u0158"
  of "&Rcedil;": "\u0156"
  of "&Rcy;": "\u0420"
  of "&Re;": "\u211C"
  of "&ReverseElement;": "\u220B"
  of "&ReverseEquilibrium;": "\u21CB"
  of "&ReverseUpEquilibrium;": "\u296F"
  of "&Rfr;": "\u211C"
  of "&Rho;": "\u03A1"
  of "&RightAngleBracket;": "\u27E9"
  of "&RightArrow;": "\u2192"
  of "&RightArrowBar;": "\u21E5"
  of "&RightArrowLeftArrow;": "\u21C4"
  of "&RightCeiling;": "\u2309"
  of "&RightDoubleBracket;": "\u27E7"
  of "&RightDownTeeVector;": "\u295D"
  of "&RightDownVector;": "\u21C2"
  of "&RightDownVectorBar;": "\u2955"
  of "&RightFloor;": "\u230B"
  of "&RightTee;": "\u22A2"
  of "&RightTeeArrow;": "\u21A6"
  of "&RightTeeVector;": "\u295B"
  of "&RightTriangle;": "\u22B3"
  of "&RightTriangleBar;": "\u29D0"
  of "&RightTriangleEqual;": "\u22B5"
  of "&RightUpDownVector;": "\u294F"
  of "&RightUpTeeVector;": "\u295C"
  of "&RightUpVector;": "\u21BE"
  of "&RightUpVectorBar;": "\u2954"
  of "&RightVector;": "\u21C0"
  of "&RightVectorBar;": "\u2953"
  of "&Rightarrow;": "\u21D2"
  of "&Ropf;": "\u211D"
  of "&RoundImplies;": "\u2970"
  of "&Rrightarrow;": "\u21DB"
  of "&Rscr;": "\u211B"
  of "&Rsh;": "\u21B1"
  of "&RuleDelayed;": "\u29F4"
  of "&SHCHcy;": "\u0429"
  of "&SHcy;": "\u0428"
  of "&SOFTcy;": "\u042C"
  of "&Sacute;": "\u015A"
  of "&Sc;": "\u2ABC"
  of "&Scaron;": "\u0160"
  of "&Scedil;": "\u015E"
  of "&Scirc;": "\u015C"
  of "&Scy;": "\u0421"
  of "&Sfr;": "\uD835\uDD16"
  of "&ShortDownArrow;": "\u2193"
  of "&ShortLeftArrow;": "\u2190"
  of "&ShortRightArrow;": "\u2192"
  of "&ShortUpArrow;": "\u2191"
  of "&Sigma;": "\u03A3"
  of "&SmallCircle;": "\u2218"
  of "&Sopf;": "\uD835\uDD4A"
  of "&Sqrt;": "\u221A"
  of "&Square;": "\u25A1"
  of "&SquareIntersection;": "\u2293"
  of "&SquareSubset;": "\u228F"
  of "&SquareSubsetEqual;": "\u2291"
  of "&SquareSuperset;": "\u2290"
  of "&SquareSupersetEqual;": "\u2292"
  of "&SquareUnion;": "\u2294"
  of "&Sscr;": "\uD835\uDCAE"
  of "&Star;": "\u22C6"
  of "&Sub;": "\u22D0"
  of "&Subset;": "\u22D0"
  of "&SubsetEqual;": "\u2286"
  of "&Succeeds;": "\u227B"
  of "&SucceedsEqual;": "\u2AB0"
  of "&SucceedsSlantEqual;": "\u227D"
  of "&SucceedsTilde;": "\u227F"
  of "&SuchThat;": "\u220B"
  of "&Sum;": "\u2211"
  of "&Sup;": "\u22D1"
  of "&Superset;": "\u2283"
  of "&SupersetEqual;": "\u2287"
  of "&Supset;": "\u22D1"
  of "&THORN": "\u00DE"
  of "&THORN;": "\u00DE"
  of "&TRADE;": "\u2122"
  of "&TSHcy;": "\u040B"
  of "&TScy;": "\u0426"
  of "&Tab;": "\u0009"
  of "&Tau;": "\u03A4"
  of "&Tcaron;": "\u0164"
  of "&Tcedil;": "\u0162"
  of "&Tcy;": "\u0422"
  of "&Tfr;": "\uD835\uDD17"
  of "&Therefore;": "\u2234"
  of "&Theta;": "\u0398"
  of "&ThickSpace;": "\u205F\u200A"
  of "&ThinSpace;": "\u2009"
  of "&Tilde;": "\u223C"
  of "&TildeEqual;": "\u2243"
  of "&TildeFullEqual;": "\u2245"
  of "&TildeTilde;": "\u2248"
  of "&Topf;": "\uD835\uDD4B"
  of "&TripleDot;": "\u20DB"
  of "&Tscr;": "\uD835\uDCAF"
  of "&Tstrok;": "\u0166"
  of "&Uacute": "\u00DA"
  of "&Uacute;": "\u00DA"
  of "&Uarr;": "\u219F"
  of "&Uarrocir;": "\u2949"
  of "&Ubrcy;": "\u040E"
  of "&Ubreve;": "\u016C"
  of "&Ucirc": "\u00DB"
  of "&Ucirc;": "\u00DB"
  of "&Ucy;": "\u0423"
  of "&Udblac;": "\u0170"
  of "&Ufr;": "\uD835\uDD18"
  of "&Ugrave": "\u00D9"
  of "&Ugrave;": "\u00D9"
  of "&Umacr;": "\u016A"
  of "&UnderBar;": "\u005F"
  of "&UnderBrace;": "\u23DF"
  of "&UnderBracket;": "\u23B5"
  of "&UnderParenthesis;": "\u23DD"
  of "&Union;": "\u22C3"
  of "&UnionPlus;": "\u228E"
  of "&Uogon;": "\u0172"
  of "&Uopf;": "\uD835\uDD4C"
  of "&UpArrow;": "\u2191"
  of "&UpArrowBar;": "\u2912"
  of "&UpArrowDownArrow;": "\u21C5"
  of "&UpDownArrow;": "\u2195"
  of "&UpEquilibrium;": "\u296E"
  of "&UpTee;": "\u22A5"
  of "&UpTeeArrow;": "\u21A5"
  of "&Uparrow;": "\u21D1"
  of "&Updownarrow;": "\u21D5"
  of "&UpperLeftArrow;": "\u2196"
  of "&UpperRightArrow;": "\u2197"
  of "&Upsi;": "\u03D2"
  of "&Upsilon;": "\u03A5"
  of "&Uring;": "\u016E"
  of "&Uscr;": "\uD835\uDCB0"
  of "&Utilde;": "\u0168"
  of "&Uuml": "\u00DC"
  of "&Uuml;": "\u00DC"
  of "&VDash;": "\u22AB"
  of "&Vbar;": "\u2AEB"
  of "&Vcy;": "\u0412"
  of "&Vdash;": "\u22A9"
  of "&Vdashl;": "\u2AE6"
  of "&Vee;": "\u22C1"
  of "&Verbar;": "\u2016"
  of "&Vert;": "\u2016"
  of "&VerticalBar;": "\u2223"
  of "&VerticalLine;": "\u007C"
  of "&VerticalSeparator;": "\u2758"
  of "&VerticalTilde;": "\u2240"
  of "&VeryThinSpace;": "\u200A"
  of "&Vfr;": "\uD835\uDD19"
  of "&Vopf;": "\uD835\uDD4D"
  of "&Vscr;": "\uD835\uDCB1"
  of "&Vvdash;": "\u22AA"
  of "&Wcirc;": "\u0174"
  of "&Wedge;": "\u22C0"
  of "&Wfr;": "\uD835\uDD1A"
  of "&Wopf;": "\uD835\uDD4E"
  of "&Wscr;": "\uD835\uDCB2"
  of "&Xfr;": "\uD835\uDD1B"
  of "&Xi;": "\u039E"
  of "&Xopf;": "\uD835\uDD4F"
  of "&Xscr;": "\uD835\uDCB3"
  of "&YAcy;": "\u042F"
  of "&YIcy;": "\u0407"
  of "&YUcy;": "\u042E"
  of "&Yacute": "\u00DD"
  of "&Yacute;": "\u00DD"
  of "&Ycirc;": "\u0176"
  of "&Ycy;": "\u042B"
  of "&Yfr;": "\uD835\uDD1C"
  of "&Yopf;": "\uD835\uDD50"
  of "&Yscr;": "\uD835\uDCB4"
  of "&Yuml;": "\u0178"
  of "&ZHcy;": "\u0416"
  of "&Zacute;": "\u0179"
  of "&Zcaron;": "\u017D"
  of "&Zcy;": "\u0417"
  of "&Zdot;": "\u017B"
  of "&ZeroWidthSpace;": "\u200B"
  of "&Zeta;": "\u0396"
  of "&Zfr;": "\u2128"
  of "&Zopf;": "\u2124"
  of "&Zscr;": "\uD835\uDCB5"
  of "&aacute": "\u00E1"
  of "&aacute;": "\u00E1"
  of "&abreve;": "\u0103"
  of "&ac;": "\u223E"
  of "&acE;": "\u223E\u0333"
  of "&acd;": "\u223F"
  of "&acirc": "\u00E2"
  of "&acirc;": "\u00E2"
  of "&acute": "\u00B4"
  of "&acute;": "\u00B4"
  of "&acy;": "\u0430"
  of "&aelig": "\u00E6"
  of "&aelig;": "\u00E6"
  of "&af;": "\u2061"
  of "&afr;": "\uD835\uDD1E"
  of "&agrave": "\u00E0"
  of "&agrave;": "\u00E0"
  of "&alefsym;": "\u2135"
  of "&aleph;": "\u2135"
  of "&alpha;": "\u03B1"
  of "&amacr;": "\u0101"
  of "&amalg;": "\u2A3F"
  of "&amp": "\u0026"
  of "&amp;": "\u0026"
  of "&and;": "\u2227"
  of "&andand;": "\u2A55"
  of "&andd;": "\u2A5C"
  of "&andslope;": "\u2A58"
  of "&andv;": "\u2A5A"
  of "&ang;": "\u2220"
  of "&ange;": "\u29A4"
  of "&angle;": "\u2220"
  of "&angmsd;": "\u2221"
  of "&angmsdaa;": "\u29A8"
  of "&angmsdab;": "\u29A9"
  of "&angmsdac;": "\u29AA"
  of "&angmsdad;": "\u29AB"
  of "&angmsdae;": "\u29AC"
  of "&angmsdaf;": "\u29AD"
  of "&angmsdag;": "\u29AE"
  of "&angmsdah;": "\u29AF"
  of "&angrt;": "\u221F"
  of "&angrtvb;": "\u22BE"
  of "&angrtvbd;": "\u299D"
  of "&angsph;": "\u2222"
  of "&angst;": "\u00C5"
  of "&angzarr;": "\u237C"
  of "&aogon;": "\u0105"
  of "&aopf;": "\uD835\uDD52"
  of "&ap;": "\u2248"
  of "&apE;": "\u2A70"
  of "&apacir;": "\u2A6F"
  of "&ape;": "\u224A"
  of "&apid;": "\u224B"
  of "&apos;": "\u0027"
  of "&approx;": "\u2248"
  of "&approxeq;": "\u224A"
  of "&aring": "\u00E5"
  of "&aring;": "\u00E5"
  of "&ascr;": "\uD835\uDCB6"
  of "&ast;": "\u002A"
  of "&asymp;": "\u2248"
  of "&asympeq;": "\u224D"
  of "&atilde": "\u00E3"
  of "&atilde;": "\u00E3"
  of "&auml": "\u00E4"
  of "&auml;": "\u00E4"
  of "&awconint;": "\u2233"
  of "&awint;": "\u2A11"
  of "&bNot;": "\u2AED"
  of "&backcong;": "\u224C"
  of "&backepsilon;": "\u03F6"
  of "&backprime;": "\u2035"
  of "&backsim;": "\u223D"
  of "&backsimeq;": "\u22CD"
  of "&barvee;": "\u22BD"
  of "&barwed;": "\u2305"
  of "&barwedge;": "\u2305"
  of "&bbrk;": "\u23B5"
  of "&bbrktbrk;": "\u23B6"
  of "&bcong;": "\u224C"
  of "&bcy;": "\u0431"
  of "&bdquo;": "\u201E"
  of "&becaus;": "\u2235"
  of "&because;": "\u2235"
  of "&bemptyv;": "\u29B0"
  of "&bepsi;": "\u03F6"
  of "&bernou;": "\u212C"
  of "&beta;": "\u03B2"
  of "&beth;": "\u2136"
  of "&between;": "\u226C"
  of "&bfr;": "\uD835\uDD1F"
  of "&bigcap;": "\u22C2"
  of "&bigcirc;": "\u25EF"
  of "&bigcup;": "\u22C3"
  of "&bigodot;": "\u2A00"
  of "&bigoplus;": "\u2A01"
  of "&bigotimes;": "\u2A02"
  of "&bigsqcup;": "\u2A06"
  of "&bigstar;": "\u2605"
  of "&bigtriangledown;": "\u25BD"
  of "&bigtriangleup;": "\u25B3"
  of "&biguplus;": "\u2A04"
  of "&bigvee;": "\u22C1"
  of "&bigwedge;": "\u22C0"
  of "&bkarow;": "\u290D"
  of "&blacklozenge;": "\u29EB"
  of "&blacksquare;": "\u25AA"
  of "&blacktriangle;": "\u25B4"
  of "&blacktriangledown;": "\u25BE"
  of "&blacktriangleleft;": "\u25C2"
  of "&blacktriangleright;": "\u25B8"
  of "&blank;": "\u2423"
  of "&blk12;": "\u2592"
  of "&blk14;": "\u2591"
  of "&blk34;": "\u2593"
  of "&block;": "\u2588"
  of "&bne;": "\u003D\u20E5"
  of "&bnequiv;": "\u2261\u20E5"
  of "&bnot;": "\u2310"
  of "&bopf;": "\uD835\uDD53"
  of "&bot;": "\u22A5"
  of "&bottom;": "\u22A5"
  of "&bowtie;": "\u22C8"
  of "&boxDL;": "\u2557"
  of "&boxDR;": "\u2554"
  of "&boxDl;": "\u2556"
  of "&boxDr;": "\u2553"
  of "&boxH;": "\u2550"
  of "&boxHD;": "\u2566"
  of "&boxHU;": "\u2569"
  of "&boxHd;": "\u2564"
  of "&boxHu;": "\u2567"
  of "&boxUL;": "\u255D"
  of "&boxUR;": "\u255A"
  of "&boxUl;": "\u255C"
  of "&boxUr;": "\u2559"
  of "&boxV;": "\u2551"
  of "&boxVH;": "\u256C"
  of "&boxVL;": "\u2563"
  of "&boxVR;": "\u2560"
  of "&boxVh;": "\u256B"
  of "&boxVl;": "\u2562"
  of "&boxVr;": "\u255F"
  of "&boxbox;": "\u29C9"
  of "&boxdL;": "\u2555"
  of "&boxdR;": "\u2552"
  of "&boxdl;": "\u2510"
  of "&boxdr;": "\u250C"
  of "&boxh;": "\u2500"
  of "&boxhD;": "\u2565"
  of "&boxhU;": "\u2568"
  of "&boxhd;": "\u252C"
  of "&boxhu;": "\u2534"
  of "&boxminus;": "\u229F"
  of "&boxplus;": "\u229E"
  of "&boxtimes;": "\u22A0"
  of "&boxuL;": "\u255B"
  of "&boxuR;": "\u2558"
  of "&boxul;": "\u2518"
  of "&boxur;": "\u2514"
  of "&boxv;": "\u2502"
  of "&boxvH;": "\u256A"
  of "&boxvL;": "\u2561"
  of "&boxvR;": "\u255E"
  of "&boxvh;": "\u253C"
  of "&boxvl;": "\u2524"
  of "&boxvr;": "\u251C"
  of "&bprime;": "\u2035"
  of "&breve;": "\u02D8"
  of "&brvbar": "\u00A6"
  of "&brvbar;": "\u00A6"
  of "&bscr;": "\uD835\uDCB7"
  of "&bsemi;": "\u204F"
  of "&bsim;": "\u223D"
  of "&bsime;": "\u22CD"
  of "&bsol;": "\u005C"
  of "&bsolb;": "\u29C5"
  of "&bsolhsub;": "\u27C8"
  of "&bull;": "\u2022"
  of "&bullet;": "\u2022"
  of "&bump;": "\u224E"
  of "&bumpE;": "\u2AAE"
  of "&bumpe;": "\u224F"
  of "&bumpeq;": "\u224F"
  of "&cacute;": "\u0107"
  of "&cap;": "\u2229"
  of "&capand;": "\u2A44"
  of "&capbrcup;": "\u2A49"
  of "&capcap;": "\u2A4B"
  of "&capcup;": "\u2A47"
  of "&capdot;": "\u2A40"
  of "&caps;": "\u2229\uFE00"
  of "&caret;": "\u2041"
  of "&caron;": "\u02C7"
  of "&ccaps;": "\u2A4D"
  of "&ccaron;": "\u010D"
  of "&ccedil": "\u00E7"
  of "&ccedil;": "\u00E7"
  of "&ccirc;": "\u0109"
  of "&ccups;": "\u2A4C"
  of "&ccupssm;": "\u2A50"
  of "&cdot;": "\u010B"
  of "&cedil": "\u00B8"
  of "&cedil;": "\u00B8"
  of "&cemptyv;": "\u29B2"
  of "&cent": "\u00A2"
  of "&cent;": "\u00A2"
  of "&centerdot;": "\u00B7"
  of "&cfr;": "\uD835\uDD20"
  of "&chcy;": "\u0447"
  of "&check;": "\u2713"
  of "&checkmark;": "\u2713"
  of "&chi;": "\u03C7"
  of "&cir;": "\u25CB"
  of "&cirE;": "\u29C3"
  of "&circ;": "\u02C6"
  of "&circeq;": "\u2257"
  of "&circlearrowleft;": "\u21BA"
  of "&circlearrowright;": "\u21BB"
  of "&circledR;": "\u00AE"
  of "&circledS;": "\u24C8"
  of "&circledast;": "\u229B"
  of "&circledcirc;": "\u229A"
  of "&circleddash;": "\u229D"
  of "&cire;": "\u2257"
  of "&cirfnint;": "\u2A10"
  of "&cirmid;": "\u2AEF"
  of "&cirscir;": "\u29C2"
  of "&clubs;": "\u2663"
  of "&clubsuit;": "\u2663"
  of "&colon;": "\u003A"
  of "&colone;": "\u2254"
  of "&coloneq;": "\u2254"
  of "&comma;": "\u002C"
  of "&commat;": "\u0040"
  of "&comp;": "\u2201"
  of "&compfn;": "\u2218"
  of "&complement;": "\u2201"
  of "&complexes;": "\u2102"
  of "&cong;": "\u2245"
  of "&congdot;": "\u2A6D"
  of "&conint;": "\u222E"
  of "&copf;": "\uD835\uDD54"
  of "&coprod;": "\u2210"
  of "&copy": "\u00A9"
  of "&copy;": "\u00A9"
  of "&copysr;": "\u2117"
  of "&crarr;": "\u21B5"
  of "&cross;": "\u2717"
  of "&cscr;": "\uD835\uDCB8"
  of "&csub;": "\u2ACF"
  of "&csube;": "\u2AD1"
  of "&csup;": "\u2AD0"
  of "&csupe;": "\u2AD2"
  of "&ctdot;": "\u22EF"
  of "&cudarrl;": "\u2938"
  of "&cudarrr;": "\u2935"
  of "&cuepr;": "\u22DE"
  of "&cuesc;": "\u22DF"
  of "&cularr;": "\u21B6"
  of "&cularrp;": "\u293D"
  of "&cup;": "\u222A"
  of "&cupbrcap;": "\u2A48"
  of "&cupcap;": "\u2A46"
  of "&cupcup;": "\u2A4A"
  of "&cupdot;": "\u228D"
  of "&cupor;": "\u2A45"
  of "&cups;": "\u222A\uFE00"
  of "&curarr;": "\u21B7"
  of "&curarrm;": "\u293C"
  of "&curlyeqprec;": "\u22DE"
  of "&curlyeqsucc;": "\u22DF"
  of "&curlyvee;": "\u22CE"
  of "&curlywedge;": "\u22CF"
  of "&curren": "\u00A4"
  of "&curren;": "\u00A4"
  of "&curvearrowleft;": "\u21B6"
  of "&curvearrowright;": "\u21B7"
  of "&cuvee;": "\u22CE"
  of "&cuwed;": "\u22CF"
  of "&cwconint;": "\u2232"
  of "&cwint;": "\u2231"
  of "&cylcty;": "\u232D"
  of "&dArr;": "\u21D3"
  of "&dHar;": "\u2965"
  of "&dagger;": "\u2020"
  of "&daleth;": "\u2138"
  of "&darr;": "\u2193"
  of "&dash;": "\u2010"
  of "&dashv;": "\u22A3"
  of "&dbkarow;": "\u290F"
  of "&dblac;": "\u02DD"
  of "&dcaron;": "\u010F"
  of "&dcy;": "\u0434"
  of "&dd;": "\u2146"
  of "&ddagger;": "\u2021"
  of "&ddarr;": "\u21CA"
  of "&ddotseq;": "\u2A77"
  of "&deg": "\u00B0"
  of "&deg;": "\u00B0"
  of "&delta;": "\u03B4"
  of "&demptyv;": "\u29B1"
  of "&dfisht;": "\u297F"
  of "&dfr;": "\uD835\uDD21"
  of "&dharl;": "\u21C3"
  of "&dharr;": "\u21C2"
  of "&diam;": "\u22C4"
  of "&diamond;": "\u22C4"
  of "&diamondsuit;": "\u2666"
  of "&diams;": "\u2666"
  of "&die;": "\u00A8"
  of "&digamma;": "\u03DD"
  of "&disin;": "\u22F2"
  of "&div;": "\u00F7"
  of "&divide": "\u00F7"
  of "&divide;": "\u00F7"
  of "&divideontimes;": "\u22C7"
  of "&divonx;": "\u22C7"
  of "&djcy;": "\u0452"
  of "&dlcorn;": "\u231E"
  of "&dlcrop;": "\u230D"
  of "&dollar;": "\u0024"
  of "&dopf;": "\uD835\uDD55"
  of "&dot;": "\u02D9"
  of "&doteq;": "\u2250"
  of "&doteqdot;": "\u2251"
  of "&dotminus;": "\u2238"
  of "&dotplus;": "\u2214"
  of "&dotsquare;": "\u22A1"
  of "&doublebarwedge;": "\u2306"
  of "&downarrow;": "\u2193"
  of "&downdownarrows;": "\u21CA"
  of "&downharpoonleft;": "\u21C3"
  of "&downharpoonright;": "\u21C2"
  of "&drbkarow;": "\u2910"
  of "&drcorn;": "\u231F"
  of "&drcrop;": "\u230C"
  of "&dscr;": "\uD835\uDCB9"
  of "&dscy;": "\u0455"
  of "&dsol;": "\u29F6"
  of "&dstrok;": "\u0111"
  of "&dtdot;": "\u22F1"
  of "&dtri;": "\u25BF"
  of "&dtrif;": "\u25BE"
  of "&duarr;": "\u21F5"
  of "&duhar;": "\u296F"
  of "&dwangle;": "\u29A6"
  of "&dzcy;": "\u045F"
  of "&dzigrarr;": "\u27FF"
  of "&eDDot;": "\u2A77"
  of "&eDot;": "\u2251"
  of "&eacute": "\u00E9"
  of "&eacute;": "\u00E9"
  of "&easter;": "\u2A6E"
  of "&ecaron;": "\u011B"
  of "&ecir;": "\u2256"
  of "&ecirc": "\u00EA"
  of "&ecirc;": "\u00EA"
  of "&ecolon;": "\u2255"
  of "&ecy;": "\u044D"
  of "&edot;": "\u0117"
  of "&ee;": "\u2147"
  of "&efDot;": "\u2252"
  of "&efr;": "\uD835\uDD22"
  of "&eg;": "\u2A9A"
  of "&egrave": "\u00E8"
  of "&egrave;": "\u00E8"
  of "&egs;": "\u2A96"
  of "&egsdot;": "\u2A98"
  of "&el;": "\u2A99"
  of "&elinters;": "\u23E7"
  of "&ell;": "\u2113"
  of "&els;": "\u2A95"
  of "&elsdot;": "\u2A97"
  of "&emacr;": "\u0113"
  of "&empty;": "\u2205"
  of "&emptyset;": "\u2205"
  of "&emptyv;": "\u2205"
  of "&emsp13;": "\u2004"
  of "&emsp14;": "\u2005"
  of "&emsp;": "\u2003"
  of "&eng;": "\u014B"
  of "&ensp;": "\u2002"
  of "&eogon;": "\u0119"
  of "&eopf;": "\uD835\uDD56"
  of "&epar;": "\u22D5"
  of "&eparsl;": "\u29E3"
  of "&eplus;": "\u2A71"
  of "&epsi;": "\u03B5"
  of "&epsilon;": "\u03B5"
  of "&epsiv;": "\u03F5"
  of "&eqcirc;": "\u2256"
  of "&eqcolon;": "\u2255"
  of "&eqsim;": "\u2242"
  of "&eqslantgtr;": "\u2A96"
  of "&eqslantless;": "\u2A95"
  of "&equals;": "\u003D"
  of "&equest;": "\u225F"
  of "&equiv;": "\u2261"
  of "&equivDD;": "\u2A78"
  of "&eqvparsl;": "\u29E5"
  of "&erDot;": "\u2253"
  of "&erarr;": "\u2971"
  of "&escr;": "\u212F"
  of "&esdot;": "\u2250"
  of "&esim;": "\u2242"
  of "&eta;": "\u03B7"
  of "&eth": "\u00F0"
  of "&eth;": "\u00F0"
  of "&euml": "\u00EB"
  of "&euml;": "\u00EB"
  of "&euro;": "\u20AC"
  of "&excl;": "\u0021"
  of "&exist;": "\u2203"
  of "&expectation;": "\u2130"
  of "&exponentiale;": "\u2147"
  of "&fallingdotseq;": "\u2252"
  of "&fcy;": "\u0444"
  of "&female;": "\u2640"
  of "&ffilig;": "\uFB03"
  of "&fflig;": "\uFB00"
  of "&ffllig;": "\uFB04"
  of "&ffr;": "\uD835\uDD23"
  of "&filig;": "\uFB01"
  of "&fjlig;": "\u0066\u006A"
  of "&flat;": "\u266D"
  of "&fllig;": "\uFB02"
  of "&fltns;": "\u25B1"
  of "&fnof;": "\u0192"
  of "&fopf;": "\uD835\uDD57"
  of "&forall;": "\u2200"
  of "&fork;": "\u22D4"
  of "&forkv;": "\u2AD9"
  of "&fpartint;": "\u2A0D"
  of "&frac12": "\u00BD"
  of "&frac12;": "\u00BD"
  of "&frac13;": "\u2153"
  of "&frac14": "\u00BC"
  of "&frac14;": "\u00BC"
  of "&frac15;": "\u2155"
  of "&frac16;": "\u2159"
  of "&frac18;": "\u215B"
  of "&frac23;": "\u2154"
  of "&frac25;": "\u2156"
  of "&frac34": "\u00BE"
  of "&frac34;": "\u00BE"
  of "&frac35;": "\u2157"
  of "&frac38;": "\u215C"
  of "&frac45;": "\u2158"
  of "&frac56;": "\u215A"
  of "&frac58;": "\u215D"
  of "&frac78;": "\u215E"
  of "&frasl;": "\u2044"
  of "&frown;": "\u2322"
  of "&fscr;": "\uD835\uDCBB"
  of "&gE;": "\u2267"
  of "&gEl;": "\u2A8C"
  of "&gacute;": "\u01F5"
  of "&gamma;": "\u03B3"
  of "&gammad;": "\u03DD"
  of "&gap;": "\u2A86"
  of "&gbreve;": "\u011F"
  of "&gcirc;": "\u011D"
  of "&gcy;": "\u0433"
  of "&gdot;": "\u0121"
  of "&ge;": "\u2265"
  of "&gel;": "\u22DB"
  of "&geq;": "\u2265"
  of "&geqq;": "\u2267"
  of "&geqslant;": "\u2A7E"
  of "&ges;": "\u2A7E"
  of "&gescc;": "\u2AA9"
  of "&gesdot;": "\u2A80"
  of "&gesdoto;": "\u2A82"
  of "&gesdotol;": "\u2A84"
  of "&gesl;": "\u22DB\uFE00"
  of "&gesles;": "\u2A94"
  of "&gfr;": "\uD835\uDD24"
  of "&gg;": "\u226B"
  of "&ggg;": "\u22D9"
  of "&gimel;": "\u2137"
  of "&gjcy;": "\u0453"
  of "&gl;": "\u2277"
  of "&glE;": "\u2A92"
  of "&gla;": "\u2AA5"
  of "&glj;": "\u2AA4"
  of "&gnE;": "\u2269"
  of "&gnap;": "\u2A8A"
  of "&gnapprox;": "\u2A8A"
  of "&gne;": "\u2A88"
  of "&gneq;": "\u2A88"
  of "&gneqq;": "\u2269"
  of "&gnsim;": "\u22E7"
  of "&gopf;": "\uD835\uDD58"
  of "&grave;": "\u0060"
  of "&gscr;": "\u210A"
  of "&gsim;": "\u2273"
  of "&gsime;": "\u2A8E"
  of "&gsiml;": "\u2A90"
  of "&gt": "\u003E"
  of "&gt;": "\u003E"
  of "&gtcc;": "\u2AA7"
  of "&gtcir;": "\u2A7A"
  of "&gtdot;": "\u22D7"
  of "&gtlPar;": "\u2995"
  of "&gtquest;": "\u2A7C"
  of "&gtrapprox;": "\u2A86"
  of "&gtrarr;": "\u2978"
  of "&gtrdot;": "\u22D7"
  of "&gtreqless;": "\u22DB"
  of "&gtreqqless;": "\u2A8C"
  of "&gtrless;": "\u2277"
  of "&gtrsim;": "\u2273"
  of "&gvertneqq;": "\u2269\uFE00"
  of "&gvnE;": "\u2269\uFE00"
  of "&hArr;": "\u21D4"
  of "&hairsp;": "\u200A"
  of "&half;": "\u00BD"
  of "&hamilt;": "\u210B"
  of "&hardcy;": "\u044A"
  of "&harr;": "\u2194"
  of "&harrcir;": "\u2948"
  of "&harrw;": "\u21AD"
  of "&hbar;": "\u210F"
  of "&hcirc;": "\u0125"
  of "&hearts;": "\u2665"
  of "&heartsuit;": "\u2665"
  of "&hellip;": "\u2026"
  of "&hercon;": "\u22B9"
  of "&hfr;": "\uD835\uDD25"
  of "&hksearow;": "\u2925"
  of "&hkswarow;": "\u2926"
  of "&hoarr;": "\u21FF"
  of "&homtht;": "\u223B"
  of "&hookleftarrow;": "\u21A9"
  of "&hookrightarrow;": "\u21AA"
  of "&hopf;": "\uD835\uDD59"
  of "&horbar;": "\u2015"
  of "&hscr;": "\uD835\uDCBD"
  of "&hslash;": "\u210F"
  of "&hstrok;": "\u0127"
  of "&hybull;": "\u2043"
  of "&hyphen;": "\u2010"
  of "&iacute": "\u00ED"
  of "&iacute;": "\u00ED"
  of "&ic;": "\u2063"
  of "&icirc": "\u00EE"
  of "&icirc;": "\u00EE"
  of "&icy;": "\u0438"
  of "&iecy;": "\u0435"
  of "&iexcl": "\u00A1"
  of "&iexcl;": "\u00A1"
  of "&iff;": "\u21D4"
  of "&ifr;": "\uD835\uDD26"
  of "&igrave": "\u00EC"
  of "&igrave;": "\u00EC"
  of "&ii;": "\u2148"
  of "&iiiint;": "\u2A0C"
  of "&iiint;": "\u222D"
  of "&iinfin;": "\u29DC"
  of "&iiota;": "\u2129"
  of "&ijlig;": "\u0133"
  of "&imacr;": "\u012B"
  of "&image;": "\u2111"
  of "&imagline;": "\u2110"
  of "&imagpart;": "\u2111"
  of "&imath;": "\u0131"
  of "&imof;": "\u22B7"
  of "&imped;": "\u01B5"
  of "&in;": "\u2208"
  of "&incare;": "\u2105"
  of "&infin;": "\u221E"
  of "&infintie;": "\u29DD"
  of "&inodot;": "\u0131"
  of "&int;": "\u222B"
  of "&intcal;": "\u22BA"
  of "&integers;": "\u2124"
  of "&intercal;": "\u22BA"
  of "&intlarhk;": "\u2A17"
  of "&intprod;": "\u2A3C"
  of "&iocy;": "\u0451"
  of "&iogon;": "\u012F"
  of "&iopf;": "\uD835\uDD5A"
  of "&iota;": "\u03B9"
  of "&iprod;": "\u2A3C"
  of "&iquest": "\u00BF"
  of "&iquest;": "\u00BF"
  of "&iscr;": "\uD835\uDCBE"
  of "&isin;": "\u2208"
  of "&isinE;": "\u22F9"
  of "&isindot;": "\u22F5"
  of "&isins;": "\u22F4"
  of "&isinsv;": "\u22F3"
  of "&isinv;": "\u2208"
  of "&it;": "\u2062"
  of "&itilde;": "\u0129"
  of "&iukcy;": "\u0456"
  of "&iuml": "\u00EF"
  of "&iuml;": "\u00EF"
  of "&jcirc;": "\u0135"
  of "&jcy;": "\u0439"
  of "&jfr;": "\uD835\uDD27"
  of "&jmath;": "\u0237"
  of "&jopf;": "\uD835\uDD5B"
  of "&jscr;": "\uD835\uDCBF"
  of "&jsercy;": "\u0458"
  of "&jukcy;": "\u0454"
  of "&kappa;": "\u03BA"
  of "&kappav;": "\u03F0"
  of "&kcedil;": "\u0137"
  of "&kcy;": "\u043A"
  of "&kfr;": "\uD835\uDD28"
  of "&kgreen;": "\u0138"
  of "&khcy;": "\u0445"
  of "&kjcy;": "\u045C"
  of "&kopf;": "\uD835\uDD5C"
  of "&kscr;": "\uD835\uDCC0"
  of "&lAarr;": "\u21DA"
  of "&lArr;": "\u21D0"
  of "&lAtail;": "\u291B"
  of "&lBarr;": "\u290E"
  of "&lE;": "\u2266"
  of "&lEg;": "\u2A8B"
  of "&lHar;": "\u2962"
  of "&lacute;": "\u013A"
  of "&laemptyv;": "\u29B4"
  of "&lagran;": "\u2112"
  of "&lambda;": "\u03BB"
  of "&lang;": "\u27E8"
  of "&langd;": "\u2991"
  of "&langle;": "\u27E8"
  of "&lap;": "\u2A85"
  of "&laquo": "\u00AB"
  of "&laquo;": "\u00AB"
  of "&larr;": "\u2190"
  of "&larrb;": "\u21E4"
  of "&larrbfs;": "\u291F"
  of "&larrfs;": "\u291D"
  of "&larrhk;": "\u21A9"
  of "&larrlp;": "\u21AB"
  of "&larrpl;": "\u2939"
  of "&larrsim;": "\u2973"
  of "&larrtl;": "\u21A2"
  of "&lat;": "\u2AAB"
  of "&latail;": "\u2919"
  of "&late;": "\u2AAD"
  of "&lates;": "\u2AAD\uFE00"
  of "&lbarr;": "\u290C"
  of "&lbbrk;": "\u2772"
  of "&lbrace;": "\u007B"
  of "&lbrack;": "\u005B"
  of "&lbrke;": "\u298B"
  of "&lbrksld;": "\u298F"
  of "&lbrkslu;": "\u298D"
  of "&lcaron;": "\u013E"
  of "&lcedil;": "\u013C"
  of "&lceil;": "\u2308"
  of "&lcub;": "\u007B"
  of "&lcy;": "\u043B"
  of "&ldca;": "\u2936"
  of "&ldquo;": "\u201C"
  of "&ldquor;": "\u201E"
  of "&ldrdhar;": "\u2967"
  of "&ldrushar;": "\u294B"
  of "&ldsh;": "\u21B2"
  of "&le;": "\u2264"
  of "&leftarrow;": "\u2190"
  of "&leftarrowtail;": "\u21A2"
  of "&leftharpoondown;": "\u21BD"
  of "&leftharpoonup;": "\u21BC"
  of "&leftleftarrows;": "\u21C7"
  of "&leftrightarrow;": "\u2194"
  of "&leftrightarrows;": "\u21C6"
  of "&leftrightharpoons;": "\u21CB"
  of "&leftrightsquigarrow;": "\u21AD"
  of "&leftthreetimes;": "\u22CB"
  of "&leg;": "\u22DA"
  of "&leq;": "\u2264"
  of "&leqq;": "\u2266"
  of "&leqslant;": "\u2A7D"
  of "&les;": "\u2A7D"
  of "&lescc;": "\u2AA8"
  of "&lesdot;": "\u2A7F"
  of "&lesdoto;": "\u2A81"
  of "&lesdotor;": "\u2A83"
  of "&lesg;": "\u22DA\uFE00"
  of "&lesges;": "\u2A93"
  of "&lessapprox;": "\u2A85"
  of "&lessdot;": "\u22D6"
  of "&lesseqgtr;": "\u22DA"
  of "&lesseqqgtr;": "\u2A8B"
  of "&lessgtr;": "\u2276"
  of "&lesssim;": "\u2272"
  of "&lfisht;": "\u297C"
  of "&lfloor;": "\u230A"
  of "&lfr;": "\uD835\uDD29"
  of "&lg;": "\u2276"
  of "&lgE;": "\u2A91"
  of "&lhard;": "\u21BD"
  of "&lharu;": "\u21BC"
  of "&lharul;": "\u296A"
  of "&lhblk;": "\u2584"
  of "&ljcy;": "\u0459"
  of "&ll;": "\u226A"
  of "&llarr;": "\u21C7"
  of "&llcorner;": "\u231E"
  of "&llhard;": "\u296B"
  of "&lltri;": "\u25FA"
  of "&lmidot;": "\u0140"
  of "&lmoust;": "\u23B0"
  of "&lmoustache;": "\u23B0"
  of "&lnE;": "\u2268"
  of "&lnap;": "\u2A89"
  of "&lnapprox;": "\u2A89"
  of "&lne;": "\u2A87"
  of "&lneq;": "\u2A87"
  of "&lneqq;": "\u2268"
  of "&lnsim;": "\u22E6"
  of "&loang;": "\u27EC"
  of "&loarr;": "\u21FD"
  of "&lobrk;": "\u27E6"
  of "&longleftarrow;": "\u27F5"
  of "&longleftrightarrow;": "\u27F7"
  of "&longmapsto;": "\u27FC"
  of "&longrightarrow;": "\u27F6"
  of "&looparrowleft;": "\u21AB"
  of "&looparrowright;": "\u21AC"
  of "&lopar;": "\u2985"
  of "&lopf;": "\uD835\uDD5D"
  of "&loplus;": "\u2A2D"
  of "&lotimes;": "\u2A34"
  of "&lowast;": "\u2217"
  of "&lowbar;": "\u005F"
  of "&loz;": "\u25CA"
  of "&lozenge;": "\u25CA"
  of "&lozf;": "\u29EB"
  of "&lpar;": "\u0028"
  of "&lparlt;": "\u2993"
  of "&lrarr;": "\u21C6"
  of "&lrcorner;": "\u231F"
  of "&lrhar;": "\u21CB"
  of "&lrhard;": "\u296D"
  of "&lrm;": "\u200E"
  of "&lrtri;": "\u22BF"
  of "&lsaquo;": "\u2039"
  of "&lscr;": "\uD835\uDCC1"
  of "&lsh;": "\u21B0"
  of "&lsim;": "\u2272"
  of "&lsime;": "\u2A8D"
  of "&lsimg;": "\u2A8F"
  of "&lsqb;": "\u005B"
  of "&lsquo;": "\u2018"
  of "&lsquor;": "\u201A"
  of "&lstrok;": "\u0142"
  of "&lt": "\u003C"
  of "&lt;": "\u003C"
  of "&ltcc;": "\u2AA6"
  of "&ltcir;": "\u2A79"
  of "&ltdot;": "\u22D6"
  of "&lthree;": "\u22CB"
  of "&ltimes;": "\u22C9"
  of "&ltlarr;": "\u2976"
  of "&ltquest;": "\u2A7B"
  of "&ltrPar;": "\u2996"
  of "&ltri;": "\u25C3"
  of "&ltrie;": "\u22B4"
  of "&ltrif;": "\u25C2"
  of "&lurdshar;": "\u294A"
  of "&luruhar;": "\u2966"
  of "&lvertneqq;": "\u2268\uFE00"
  of "&lvnE;": "\u2268\uFE00"
  of "&mDDot;": "\u223A"
  of "&macr": "\u00AF"
  of "&macr;": "\u00AF"
  of "&male;": "\u2642"
  of "&malt;": "\u2720"
  of "&maltese;": "\u2720"
  of "&map;": "\u21A6"
  of "&mapsto;": "\u21A6"
  of "&mapstodown;": "\u21A7"
  of "&mapstoleft;": "\u21A4"
  of "&mapstoup;": "\u21A5"
  of "&marker;": "\u25AE"
  of "&mcomma;": "\u2A29"
  of "&mcy;": "\u043C"
  of "&mdash;": "\u2014"
  of "&measuredangle;": "\u2221"
  of "&mfr;": "\uD835\uDD2A"
  of "&mho;": "\u2127"
  of "&micro": "\u00B5"
  of "&micro;": "\u00B5"
  of "&mid;": "\u2223"
  of "&midast;": "\u002A"
  of "&midcir;": "\u2AF0"
  of "&middot": "\u00B7"
  of "&middot;": "\u00B7"
  of "&minus;": "\u2212"
  of "&minusb;": "\u229F"
  of "&minusd;": "\u2238"
  of "&minusdu;": "\u2A2A"
  of "&mlcp;": "\u2ADB"
  of "&mldr;": "\u2026"
  of "&mnplus;": "\u2213"
  of "&models;": "\u22A7"
  of "&mopf;": "\uD835\uDD5E"
  of "&mp;": "\u2213"
  of "&mscr;": "\uD835\uDCC2"
  of "&mstpos;": "\u223E"
  of "&mu;": "\u03BC"
  of "&multimap;": "\u22B8"
  of "&mumap;": "\u22B8"
  of "&nGg;": "\u22D9\u0338"
  of "&nGt;": "\u226B\u20D2"
  of "&nGtv;": "\u226B\u0338"
  of "&nLeftarrow;": "\u21CD"
  of "&nLeftrightarrow;": "\u21CE"
  of "&nLl;": "\u22D8\u0338"
  of "&nLt;": "\u226A\u20D2"
  of "&nLtv;": "\u226A\u0338"
  of "&nRightarrow;": "\u21CF"
  of "&nVDash;": "\u22AF"
  of "&nVdash;": "\u22AE"
  of "&nabla;": "\u2207"
  of "&nacute;": "\u0144"
  of "&nang;": "\u2220\u20D2"
  of "&nap;": "\u2249"
  of "&napE;": "\u2A70\u0338"
  of "&napid;": "\u224B\u0338"
  of "&napos;": "\u0149"
  of "&napprox;": "\u2249"
  of "&natur;": "\u266E"
  of "&natural;": "\u266E"
  of "&naturals;": "\u2115"
  of "&nbsp": "\u00A0"
  of "&nbsp;": "\u00A0"
  of "&nbump;": "\u224E\u0338"
  of "&nbumpe;": "\u224F\u0338"
  of "&ncap;": "\u2A43"
  of "&ncaron;": "\u0148"
  of "&ncedil;": "\u0146"
  of "&ncong;": "\u2247"
  of "&ncongdot;": "\u2A6D\u0338"
  of "&ncup;": "\u2A42"
  of "&ncy;": "\u043D"
  of "&ndash;": "\u2013"
  of "&ne;": "\u2260"
  of "&neArr;": "\u21D7"
  of "&nearhk;": "\u2924"
  of "&nearr;": "\u2197"
  of "&nearrow;": "\u2197"
  of "&nedot;": "\u2250\u0338"
  of "&nequiv;": "\u2262"
  of "&nesear;": "\u2928"
  of "&nesim;": "\u2242\u0338"
  of "&nexist;": "\u2204"
  of "&nexists;": "\u2204"
  of "&nfr;": "\uD835\uDD2B"
  of "&ngE;": "\u2267\u0338"
  of "&nge;": "\u2271"
  of "&ngeq;": "\u2271"
  of "&ngeqq;": "\u2267\u0338"
  of "&ngeqslant;": "\u2A7E\u0338"
  of "&nges;": "\u2A7E\u0338"
  of "&ngsim;": "\u2275"
  of "&ngt;": "\u226F"
  of "&ngtr;": "\u226F"
  of "&nhArr;": "\u21CE"
  of "&nharr;": "\u21AE"
  of "&nhpar;": "\u2AF2"
  of "&ni;": "\u220B"
  of "&nis;": "\u22FC"
  of "&nisd;": "\u22FA"
  of "&niv;": "\u220B"
  of "&njcy;": "\u045A"
  of "&nlArr;": "\u21CD"
  of "&nlE;": "\u2266\u0338"
  of "&nlarr;": "\u219A"
  of "&nldr;": "\u2025"
  of "&nle;": "\u2270"
  of "&nleftarrow;": "\u219A"
  of "&nleftrightarrow;": "\u21AE"
  of "&nleq;": "\u2270"
  of "&nleqq;": "\u2266\u0338"
  of "&nleqslant;": "\u2A7D\u0338"
  of "&nles;": "\u2A7D\u0338"
  of "&nless;": "\u226E"
  of "&nlsim;": "\u2274"
  of "&nlt;": "\u226E"
  of "&nltri;": "\u22EA"
  of "&nltrie;": "\u22EC"
  of "&nmid;": "\u2224"
  of "&nopf;": "\uD835\uDD5F"
  of "&not": "\u00AC"
  of "&not;": "\u00AC"
  of "&notin;": "\u2209"
  of "&notinE;": "\u22F9\u0338"
  of "&notindot;": "\u22F5\u0338"
  of "&notinva;": "\u2209"
  of "&notinvb;": "\u22F7"
  of "&notinvc;": "\u22F6"
  of "&notni;": "\u220C"
  of "&notniva;": "\u220C"
  of "&notnivb;": "\u22FE"
  of "&notnivc;": "\u22FD"
  of "&npar;": "\u2226"
  of "&nparallel;": "\u2226"
  of "&nparsl;": "\u2AFD\u20E5"
  of "&npart;": "\u2202\u0338"
  of "&npolint;": "\u2A14"
  of "&npr;": "\u2280"
  of "&nprcue;": "\u22E0"
  of "&npre;": "\u2AAF\u0338"
  of "&nprec;": "\u2280"
  of "&npreceq;": "\u2AAF\u0338"
  of "&nrArr;": "\u21CF"
  of "&nrarr;": "\u219B"
  of "&nrarrc;": "\u2933\u0338"
  of "&nrarrw;": "\u219D\u0338"
  of "&nrightarrow;": "\u219B"
  of "&nrtri;": "\u22EB"
  of "&nrtrie;": "\u22ED"
  of "&nsc;": "\u2281"
  of "&nsccue;": "\u22E1"
  of "&nsce;": "\u2AB0\u0338"
  of "&nscr;": "\uD835\uDCC3"
  of "&nshortmid;": "\u2224"
  of "&nshortparallel;": "\u2226"
  of "&nsim;": "\u2241"
  of "&nsime;": "\u2244"
  of "&nsimeq;": "\u2244"
  of "&nsmid;": "\u2224"
  of "&nspar;": "\u2226"
  of "&nsqsube;": "\u22E2"
  of "&nsqsupe;": "\u22E3"
  of "&nsub;": "\u2284"
  of "&nsubE;": "\u2AC5\u0338"
  of "&nsube;": "\u2288"
  of "&nsubset;": "\u2282\u20D2"
  of "&nsubseteq;": "\u2288"
  of "&nsubseteqq;": "\u2AC5\u0338"
  of "&nsucc;": "\u2281"
  of "&nsucceq;": "\u2AB0\u0338"
  of "&nsup;": "\u2285"
  of "&nsupE;": "\u2AC6\u0338"
  of "&nsupe;": "\u2289"
  of "&nsupset;": "\u2283\u20D2"
  of "&nsupseteq;": "\u2289"
  of "&nsupseteqq;": "\u2AC6\u0338"
  of "&ntgl;": "\u2279"
  of "&ntilde": "\u00F1"
  of "&ntilde;": "\u00F1"
  of "&ntlg;": "\u2278"
  of "&ntriangleleft;": "\u22EA"
  of "&ntrianglelefteq;": "\u22EC"
  of "&ntriangleright;": "\u22EB"
  of "&ntrianglerighteq;": "\u22ED"
  of "&nu;": "\u03BD"
  of "&num;": "\u0023"
  of "&numero;": "\u2116"
  of "&numsp;": "\u2007"
  of "&nvDash;": "\u22AD"
  of "&nvHarr;": "\u2904"
  of "&nvap;": "\u224D\u20D2"
  of "&nvdash;": "\u22AC"
  of "&nvge;": "\u2265\u20D2"
  of "&nvgt;": "\u003E\u20D2"
  of "&nvinfin;": "\u29DE"
  of "&nvlArr;": "\u2902"
  of "&nvle;": "\u2264\u20D2"
  of "&nvlt;": "\u003C\u20D2"
  of "&nvltrie;": "\u22B4\u20D2"
  of "&nvrArr;": "\u2903"
  of "&nvrtrie;": "\u22B5\u20D2"
  of "&nvsim;": "\u223C\u20D2"
  of "&nwArr;": "\u21D6"
  of "&nwarhk;": "\u2923"
  of "&nwarr;": "\u2196"
  of "&nwarrow;": "\u2196"
  of "&nwnear;": "\u2927"
  of "&oS;": "\u24C8"
  of "&oacute": "\u00F3"
  of "&oacute;": "\u00F3"
  of "&oast;": "\u229B"
  of "&ocir;": "\u229A"
  of "&ocirc": "\u00F4"
  of "&ocirc;": "\u00F4"
  of "&ocy;": "\u043E"
  of "&odash;": "\u229D"
  of "&odblac;": "\u0151"
  of "&odiv;": "\u2A38"
  of "&odot;": "\u2299"
  of "&odsold;": "\u29BC"
  of "&oelig;": "\u0153"
  of "&ofcir;": "\u29BF"
  of "&ofr;": "\uD835\uDD2C"
  of "&ogon;": "\u02DB"
  of "&ograve": "\u00F2"
  of "&ograve;": "\u00F2"
  of "&ogt;": "\u29C1"
  of "&ohbar;": "\u29B5"
  of "&ohm;": "\u03A9"
  of "&oint;": "\u222E"
  of "&olarr;": "\u21BA"
  of "&olcir;": "\u29BE"
  of "&olcross;": "\u29BB"
  of "&oline;": "\u203E"
  of "&olt;": "\u29C0"
  of "&omacr;": "\u014D"
  of "&omega;": "\u03C9"
  of "&omicron;": "\u03BF"
  of "&omid;": "\u29B6"
  of "&ominus;": "\u2296"
  of "&oopf;": "\uD835\uDD60"
  of "&opar;": "\u29B7"
  of "&operp;": "\u29B9"
  of "&oplus;": "\u2295"
  of "&or;": "\u2228"
  of "&orarr;": "\u21BB"
  of "&ord;": "\u2A5D"
  of "&order;": "\u2134"
  of "&orderof;": "\u2134"
  of "&ordf": "\u00AA"
  of "&ordf;": "\u00AA"
  of "&ordm": "\u00BA"
  of "&ordm;": "\u00BA"
  of "&origof;": "\u22B6"
  of "&oror;": "\u2A56"
  of "&orslope;": "\u2A57"
  of "&orv;": "\u2A5B"
  of "&oscr;": "\u2134"
  of "&oslash": "\u00F8"
  of "&oslash;": "\u00F8"
  of "&osol;": "\u2298"
  of "&otilde": "\u00F5"
  of "&otilde;": "\u00F5"
  of "&otimes;": "\u2297"
  of "&otimesas;": "\u2A36"
  of "&ouml": "\u00F6"
  of "&ouml;": "\u00F6"
  of "&ovbar;": "\u233D"
  of "&par;": "\u2225"
  of "&para": "\u00B6"
  of "&para;": "\u00B6"
  of "&parallel;": "\u2225"
  of "&parsim;": "\u2AF3"
  of "&parsl;": "\u2AFD"
  of "&part;": "\u2202"
  of "&pcy;": "\u043F"
  of "&percnt;": "\u0025"
  of "&period;": "\u002E"
  of "&permil;": "\u2030"
  of "&perp;": "\u22A5"
  of "&pertenk;": "\u2031"
  of "&pfr;": "\uD835\uDD2D"
  of "&phi;": "\u03C6"
  of "&phiv;": "\u03D5"
  of "&phmmat;": "\u2133"
  of "&phone;": "\u260E"
  of "&pi;": "\u03C0"
  of "&pitchfork;": "\u22D4"
  of "&piv;": "\u03D6"
  of "&planck;": "\u210F"
  of "&planckh;": "\u210E"
  of "&plankv;": "\u210F"
  of "&plus;": "\u002B"
  of "&plusacir;": "\u2A23"
  of "&plusb;": "\u229E"
  of "&pluscir;": "\u2A22"
  of "&plusdo;": "\u2214"
  of "&plusdu;": "\u2A25"
  of "&pluse;": "\u2A72"
  of "&plusmn": "\u00B1"
  of "&plusmn;": "\u00B1"
  of "&plussim;": "\u2A26"
  of "&plustwo;": "\u2A27"
  of "&pm;": "\u00B1"
  of "&pointint;": "\u2A15"
  of "&popf;": "\uD835\uDD61"
  of "&pound": "\u00A3"
  of "&pound;": "\u00A3"
  of "&pr;": "\u227A"
  of "&prE;": "\u2AB3"
  of "&prap;": "\u2AB7"
  of "&prcue;": "\u227C"
  of "&pre;": "\u2AAF"
  of "&prec;": "\u227A"
  of "&precapprox;": "\u2AB7"
  of "&preccurlyeq;": "\u227C"
  of "&preceq;": "\u2AAF"
  of "&precnapprox;": "\u2AB9"
  of "&precneqq;": "\u2AB5"
  of "&precnsim;": "\u22E8"
  of "&precsim;": "\u227E"
  of "&prime;": "\u2032"
  of "&primes;": "\u2119"
  of "&prnE;": "\u2AB5"
  of "&prnap;": "\u2AB9"
  of "&prnsim;": "\u22E8"
  of "&prod;": "\u220F"
  of "&profalar;": "\u232E"
  of "&profline;": "\u2312"
  of "&profsurf;": "\u2313"
  of "&prop;": "\u221D"
  of "&propto;": "\u221D"
  of "&prsim;": "\u227E"
  of "&prurel;": "\u22B0"
  of "&pscr;": "\uD835\uDCC5"
  of "&psi;": "\u03C8"
  of "&puncsp;": "\u2008"
  of "&qfr;": "\uD835\uDD2E"
  of "&qint;": "\u2A0C"
  of "&qopf;": "\uD835\uDD62"
  of "&qprime;": "\u2057"
  of "&qscr;": "\uD835\uDCC6"
  of "&quaternions;": "\u210D"
  of "&quatint;": "\u2A16"
  of "&quest;": "\u003F"
  of "&questeq;": "\u225F"
  of "&quot": "\u0022"
  of "&quot;": "\u0022"
  of "&rAarr;": "\u21DB"
  of "&rArr;": "\u21D2"
  of "&rAtail;": "\u291C"
  of "&rBarr;": "\u290F"
  of "&rHar;": "\u2964"
  of "&race;": "\u223D\u0331"
  of "&racute;": "\u0155"
  of "&radic;": "\u221A"
  of "&raemptyv;": "\u29B3"
  of "&rang;": "\u27E9"
  of "&rangd;": "\u2992"
  of "&range;": "\u29A5"
  of "&rangle;": "\u27E9"
  of "&raquo": "\u00BB"
  of "&raquo;": "\u00BB"
  of "&rarr;": "\u2192"
  of "&rarrap;": "\u2975"
  of "&rarrb;": "\u21E5"
  of "&rarrbfs;": "\u2920"
  of "&rarrc;": "\u2933"
  of "&rarrfs;": "\u291E"
  of "&rarrhk;": "\u21AA"
  of "&rarrlp;": "\u21AC"
  of "&rarrpl;": "\u2945"
  of "&rarrsim;": "\u2974"
  of "&rarrtl;": "\u21A3"
  of "&rarrw;": "\u219D"
  of "&ratail;": "\u291A"
  of "&ratio;": "\u2236"
  of "&rationals;": "\u211A"
  of "&rbarr;": "\u290D"
  of "&rbbrk;": "\u2773"
  of "&rbrace;": "\u007D"
  of "&rbrack;": "\u005D"
  of "&rbrke;": "\u298C"
  of "&rbrksld;": "\u298E"
  of "&rbrkslu;": "\u2990"
  of "&rcaron;": "\u0159"
  of "&rcedil;": "\u0157"
  of "&rceil;": "\u2309"
  of "&rcub;": "\u007D"
  of "&rcy;": "\u0440"
  of "&rdca;": "\u2937"
  of "&rdldhar;": "\u2969"
  of "&rdquo;": "\u201D"
  of "&rdquor;": "\u201D"
  of "&rdsh;": "\u21B3"
  of "&real;": "\u211C"
  of "&realine;": "\u211B"
  of "&realpart;": "\u211C"
  of "&reals;": "\u211D"
  of "&rect;": "\u25AD"
  of "&reg": "\u00AE"
  of "&reg;": "\u00AE"
  of "&rfisht;": "\u297D"
  of "&rfloor;": "\u230B"
  of "&rfr;": "\uD835\uDD2F"
  of "&rhard;": "\u21C1"
  of "&rharu;": "\u21C0"
  of "&rharul;": "\u296C"
  of "&rho;": "\u03C1"
  of "&rhov;": "\u03F1"
  of "&rightarrow;": "\u2192"
  of "&rightarrowtail;": "\u21A3"
  of "&rightharpoondown;": "\u21C1"
  of "&rightharpoonup;": "\u21C0"
  of "&rightleftarrows;": "\u21C4"
  of "&rightleftharpoons;": "\u21CC"
  of "&rightrightarrows;": "\u21C9"
  of "&rightsquigarrow;": "\u219D"
  of "&rightthreetimes;": "\u22CC"
  of "&ring;": "\u02DA"
  of "&risingdotseq;": "\u2253"
  of "&rlarr;": "\u21C4"
  of "&rlhar;": "\u21CC"
  of "&rlm;": "\u200F"
  of "&rmoust;": "\u23B1"
  of "&rmoustache;": "\u23B1"
  of "&rnmid;": "\u2AEE"
  of "&roang;": "\u27ED"
  of "&roarr;": "\u21FE"
  of "&robrk;": "\u27E7"
  of "&ropar;": "\u2986"
  of "&ropf;": "\uD835\uDD63"
  of "&roplus;": "\u2A2E"
  of "&rotimes;": "\u2A35"
  of "&rpar;": "\u0029"
  of "&rpargt;": "\u2994"
  of "&rppolint;": "\u2A12"
  of "&rrarr;": "\u21C9"
  of "&rsaquo;": "\u203A"
  of "&rscr;": "\uD835\uDCC7"
  of "&rsh;": "\u21B1"
  of "&rsqb;": "\u005D"
  of "&rsquo;": "\u2019"
  of "&rsquor;": "\u2019"
  of "&rthree;": "\u22CC"
  of "&rtimes;": "\u22CA"
  of "&rtri;": "\u25B9"
  of "&rtrie;": "\u22B5"
  of "&rtrif;": "\u25B8"
  of "&rtriltri;": "\u29CE"
  of "&ruluhar;": "\u2968"
  of "&rx;": "\u211E"
  of "&sacute;": "\u015B"
  of "&sbquo;": "\u201A"
  of "&sc;": "\u227B"
  of "&scE;": "\u2AB4"
  of "&scap;": "\u2AB8"
  of "&scaron;": "\u0161"
  of "&sccue;": "\u227D"
  of "&sce;": "\u2AB0"
  of "&scedil;": "\u015F"
  of "&scirc;": "\u015D"
  of "&scnE;": "\u2AB6"
  of "&scnap;": "\u2ABA"
  of "&scnsim;": "\u22E9"
  of "&scpolint;": "\u2A13"
  of "&scsim;": "\u227F"
  of "&scy;": "\u0441"
  of "&sdot;": "\u22C5"
  of "&sdotb;": "\u22A1"
  of "&sdote;": "\u2A66"
  of "&seArr;": "\u21D8"
  of "&searhk;": "\u2925"
  of "&searr;": "\u2198"
  of "&searrow;": "\u2198"
  of "&sect": "\u00A7"
  of "&sect;": "\u00A7"
  of "&semi;": "\u003B"
  of "&seswar;": "\u2929"
  of "&setminus;": "\u2216"
  of "&setmn;": "\u2216"
  of "&sext;": "\u2736"
  of "&sfr;": "\uD835\uDD30"
  of "&sfrown;": "\u2322"
  of "&sharp;": "\u266F"
  of "&shchcy;": "\u0449"
  of "&shcy;": "\u0448"
  of "&shortmid;": "\u2223"
  of "&shortparallel;": "\u2225"
  of "&shy": "\u00AD"
  of "&shy;": "\u00AD"
  of "&sigma;": "\u03C3"
  of "&sigmaf;": "\u03C2"
  of "&sigmav;": "\u03C2"
  of "&sim;": "\u223C"
  of "&simdot;": "\u2A6A"
  of "&sime;": "\u2243"
  of "&simeq;": "\u2243"
  of "&simg;": "\u2A9E"
  of "&simgE;": "\u2AA0"
  of "&siml;": "\u2A9D"
  of "&simlE;": "\u2A9F"
  of "&simne;": "\u2246"
  of "&simplus;": "\u2A24"
  of "&simrarr;": "\u2972"
  of "&slarr;": "\u2190"
  of "&smallsetminus;": "\u2216"
  of "&smashp;": "\u2A33"
  of "&smeparsl;": "\u29E4"
  of "&smid;": "\u2223"
  of "&smile;": "\u2323"
  of "&smt;": "\u2AAA"
  of "&smte;": "\u2AAC"
  of "&smtes;": "\u2AAC\uFE00"
  of "&softcy;": "\u044C"
  of "&sol;": "\u002F"
  of "&solb;": "\u29C4"
  of "&solbar;": "\u233F"
  of "&sopf;": "\uD835\uDD64"
  of "&spades;": "\u2660"
  of "&spadesuit;": "\u2660"
  of "&spar;": "\u2225"
  of "&sqcap;": "\u2293"
  of "&sqcaps;": "\u2293\uFE00"
  of "&sqcup;": "\u2294"
  of "&sqcups;": "\u2294\uFE00"
  of "&sqsub;": "\u228F"
  of "&sqsube;": "\u2291"
  of "&sqsubset;": "\u228F"
  of "&sqsubseteq;": "\u2291"
  of "&sqsup;": "\u2290"
  of "&sqsupe;": "\u2292"
  of "&sqsupset;": "\u2290"
  of "&sqsupseteq;": "\u2292"
  of "&squ;": "\u25A1"
  of "&square;": "\u25A1"
  of "&squarf;": "\u25AA"
  of "&squf;": "\u25AA"
  of "&srarr;": "\u2192"
  of "&sscr;": "\uD835\uDCC8"
  of "&ssetmn;": "\u2216"
  of "&ssmile;": "\u2323"
  of "&sstarf;": "\u22C6"
  of "&star;": "\u2606"
  of "&starf;": "\u2605"
  of "&straightepsilon;": "\u03F5"
  of "&straightphi;": "\u03D5"
  of "&strns;": "\u00AF"
  of "&sub;": "\u2282"
  of "&subE;": "\u2AC5"
  of "&subdot;": "\u2ABD"
  of "&sube;": "\u2286"
  of "&subedot;": "\u2AC3"
  of "&submult;": "\u2AC1"
  of "&subnE;": "\u2ACB"
  of "&subne;": "\u228A"
  of "&subplus;": "\u2ABF"
  of "&subrarr;": "\u2979"
  of "&subset;": "\u2282"
  of "&subseteq;": "\u2286"
  of "&subseteqq;": "\u2AC5"
  of "&subsetneq;": "\u228A"
  of "&subsetneqq;": "\u2ACB"
  of "&subsim;": "\u2AC7"
  of "&subsub;": "\u2AD5"
  of "&subsup;": "\u2AD3"
  of "&succ;": "\u227B"
  of "&succapprox;": "\u2AB8"
  of "&succcurlyeq;": "\u227D"
  of "&succeq;": "\u2AB0"
  of "&succnapprox;": "\u2ABA"
  of "&succneqq;": "\u2AB6"
  of "&succnsim;": "\u22E9"
  of "&succsim;": "\u227F"
  of "&sum;": "\u2211"
  of "&sung;": "\u266A"
  of "&sup1": "\u00B9"
  of "&sup1;": "\u00B9"
  of "&sup2": "\u00B2"
  of "&sup2;": "\u00B2"
  of "&sup3": "\u00B3"
  of "&sup3;": "\u00B3"
  of "&sup;": "\u2283"
  of "&supE;": "\u2AC6"
  of "&supdot;": "\u2ABE"
  of "&supdsub;": "\u2AD8"
  of "&supe;": "\u2287"
  of "&supedot;": "\u2AC4"
  of "&suphsol;": "\u27C9"
  of "&suphsub;": "\u2AD7"
  of "&suplarr;": "\u297B"
  of "&supmult;": "\u2AC2"
  of "&supnE;": "\u2ACC"
  of "&supne;": "\u228B"
  of "&supplus;": "\u2AC0"
  of "&supset;": "\u2283"
  of "&supseteq;": "\u2287"
  of "&supseteqq;": "\u2AC6"
  of "&supsetneq;": "\u228B"
  of "&supsetneqq;": "\u2ACC"
  of "&supsim;": "\u2AC8"
  of "&supsub;": "\u2AD4"
  of "&supsup;": "\u2AD6"
  of "&swArr;": "\u21D9"
  of "&swarhk;": "\u2926"
  of "&swarr;": "\u2199"
  of "&swarrow;": "\u2199"
  of "&swnwar;": "\u292A"
  of "&szlig": "\u00DF"
  of "&szlig;": "\u00DF"
  of "&target;": "\u2316"
  of "&tau;": "\u03C4"
  of "&tbrk;": "\u23B4"
  of "&tcaron;": "\u0165"
  of "&tcedil;": "\u0163"
  of "&tcy;": "\u0442"
  of "&tdot;": "\u20DB"
  of "&telrec;": "\u2315"
  of "&tfr;": "\uD835\uDD31"
  of "&there4;": "\u2234"
  of "&therefore;": "\u2234"
  of "&theta;": "\u03B8"
  of "&thetasym;": "\u03D1"
  of "&thetav;": "\u03D1"
  of "&thickapprox;": "\u2248"
  of "&thicksim;": "\u223C"
  of "&thinsp;": "\u2009"
  of "&thkap;": "\u2248"
  of "&thksim;": "\u223C"
  of "&thorn": "\u00FE"
  of "&thorn;": "\u00FE"
  of "&tilde;": "\u02DC"
  of "&times": "\u00D7"
  of "&times;": "\u00D7"
  of "&timesb;": "\u22A0"
  of "&timesbar;": "\u2A31"
  of "&timesd;": "\u2A30"
  of "&tint;": "\u222D"
  of "&toea;": "\u2928"
  of "&top;": "\u22A4"
  of "&topbot;": "\u2336"
  of "&topcir;": "\u2AF1"
  of "&topf;": "\uD835\uDD65"
  of "&topfork;": "\u2ADA"
  of "&tosa;": "\u2929"
  of "&tprime;": "\u2034"
  of "&trade;": "\u2122"
  of "&triangle;": "\u25B5"
  of "&triangledown;": "\u25BF"
  of "&triangleleft;": "\u25C3"
  of "&trianglelefteq;": "\u22B4"
  of "&triangleq;": "\u225C"
  of "&triangleright;": "\u25B9"
  of "&trianglerighteq;": "\u22B5"
  of "&tridot;": "\u25EC"
  of "&trie;": "\u225C"
  of "&triminus;": "\u2A3A"
  of "&triplus;": "\u2A39"
  of "&trisb;": "\u29CD"
  of "&tritime;": "\u2A3B"
  of "&trpezium;": "\u23E2"
  of "&tscr;": "\uD835\uDCC9"
  of "&tscy;": "\u0446"
  of "&tshcy;": "\u045B"
  of "&tstrok;": "\u0167"
  of "&twixt;": "\u226C"
  of "&twoheadleftarrow;": "\u219E"
  of "&twoheadrightarrow;": "\u21A0"
  of "&uArr;": "\u21D1"
  of "&uHar;": "\u2963"
  of "&uacute": "\u00FA"
  of "&uacute;": "\u00FA"
  of "&uarr;": "\u2191"
  of "&ubrcy;": "\u045E"
  of "&ubreve;": "\u016D"
  of "&ucirc": "\u00FB"
  of "&ucirc;": "\u00FB"
  of "&ucy;": "\u0443"
  of "&udarr;": "\u21C5"
  of "&udblac;": "\u0171"
  of "&udhar;": "\u296E"
  of "&ufisht;": "\u297E"
  of "&ufr;": "\uD835\uDD32"
  of "&ugrave": "\u00F9"
  of "&ugrave;": "\u00F9"
  of "&uharl;": "\u21BF"
  of "&uharr;": "\u21BE"
  of "&uhblk;": "\u2580"
  of "&ulcorn;": "\u231C"
  of "&ulcorner;": "\u231C"
  of "&ulcrop;": "\u230F"
  of "&ultri;": "\u25F8"
  of "&umacr;": "\u016B"
  of "&uml": "\u00A8"
  of "&uml;": "\u00A8"
  of "&uogon;": "\u0173"
  of "&uopf;": "\uD835\uDD66"
  of "&uparrow;": "\u2191"
  of "&updownarrow;": "\u2195"
  of "&upharpoonleft;": "\u21BF"
  of "&upharpoonright;": "\u21BE"
  of "&uplus;": "\u228E"
  of "&upsi;": "\u03C5"
  of "&upsih;": "\u03D2"
  of "&upsilon;": "\u03C5"
  of "&upuparrows;": "\u21C8"
  of "&urcorn;": "\u231D"
  of "&urcorner;": "\u231D"
  of "&urcrop;": "\u230E"
  of "&uring;": "\u016F"
  of "&urtri;": "\u25F9"
  of "&uscr;": "\uD835\uDCCA"
  of "&utdot;": "\u22F0"
  of "&utilde;": "\u0169"
  of "&utri;": "\u25B5"
  of "&utrif;": "\u25B4"
  of "&uuarr;": "\u21C8"
  of "&uuml": "\u00FC"
  of "&uuml;": "\u00FC"
  of "&uwangle;": "\u29A7"
  of "&vArr;": "\u21D5"
  of "&vBar;": "\u2AE8"
  of "&vBarv;": "\u2AE9"
  of "&vDash;": "\u22A8"
  of "&vangrt;": "\u299C"
  of "&varepsilon;": "\u03F5"
  of "&varkappa;": "\u03F0"
  of "&varnothing;": "\u2205"
  of "&varphi;": "\u03D5"
  of "&varpi;": "\u03D6"
  of "&varpropto;": "\u221D"
  of "&varr;": "\u2195"
  of "&varrho;": "\u03F1"
  of "&varsigma;": "\u03C2"
  of "&varsubsetneq;": "\u228A\uFE00"
  of "&varsubsetneqq;": "\u2ACB\uFE00"
  of "&varsupsetneq;": "\u228B\uFE00"
  of "&varsupsetneqq;": "\u2ACC\uFE00"
  of "&vartheta;": "\u03D1"
  of "&vartriangleleft;": "\u22B2"
  of "&vartriangleright;": "\u22B3"
  of "&vcy;": "\u0432"
  of "&vdash;": "\u22A2"
  of "&vee;": "\u2228"
  of "&veebar;": "\u22BB"
  of "&veeeq;": "\u225A"
  of "&vellip;": "\u22EE"
  of "&verbar;": "\u007C"
  of "&vert;": "\u007C"
  of "&vfr;": "\uD835\uDD33"
  of "&vltri;": "\u22B2"
  of "&vnsub;": "\u2282\u20D2"
  of "&vnsup;": "\u2283\u20D2"
  of "&vopf;": "\uD835\uDD67"
  of "&vprop;": "\u221D"
  of "&vrtri;": "\u22B3"
  of "&vscr;": "\uD835\uDCCB"
  of "&vsubnE;": "\u2ACB\uFE00"
  of "&vsubne;": "\u228A\uFE00"
  of "&vsupnE;": "\u2ACC\uFE00"
  of "&vsupne;": "\u228B\uFE00"
  of "&vzigzag;": "\u299A"
  of "&wcirc;": "\u0175"
  of "&wedbar;": "\u2A5F"
  of "&wedge;": "\u2227"
  of "&wedgeq;": "\u2259"
  of "&weierp;": "\u2118"
  of "&wfr;": "\uD835\uDD34"
  of "&wopf;": "\uD835\uDD68"
  of "&wp;": "\u2118"
  of "&wr;": "\u2240"
  of "&wreath;": "\u2240"
  of "&wscr;": "\uD835\uDCCC"
  of "&xcap;": "\u22C2"
  of "&xcirc;": "\u25EF"
  of "&xcup;": "\u22C3"
  of "&xdtri;": "\u25BD"
  of "&xfr;": "\uD835\uDD35"
  of "&xhArr;": "\u27FA"
  of "&xharr;": "\u27F7"
  of "&xi;": "\u03BE"
  of "&xlArr;": "\u27F8"
  of "&xlarr;": "\u27F5"
  of "&xmap;": "\u27FC"
  of "&xnis;": "\u22FB"
  of "&xodot;": "\u2A00"
  of "&xopf;": "\uD835\uDD69"
  of "&xoplus;": "\u2A01"
  of "&xotime;": "\u2A02"
  of "&xrArr;": "\u27F9"
  of "&xrarr;": "\u27F6"
  of "&xscr;": "\uD835\uDCCD"
  of "&xsqcup;": "\u2A06"
  of "&xuplus;": "\u2A04"
  of "&xutri;": "\u25B3"
  of "&xvee;": "\u22C1"
  of "&xwedge;": "\u22C0"
  of "&yacute": "\u00FD"
  of "&yacute;": "\u00FD"
  of "&yacy;": "\u044F"
  of "&ycirc;": "\u0177"
  of "&ycy;": "\u044B"
  of "&yen": "\u00A5"
  of "&yen;": "\u00A5"
  of "&yfr;": "\uD835\uDD36"
  of "&yicy;": "\u0457"
  of "&yopf;": "\uD835\uDD6A"
  of "&yscr;": "\uD835\uDCCE"
  of "&yucy;": "\u044E"
  of "&yuml": "\u00FF"
  of "&yuml;": "\u00FF"
  of "&zacute;": "\u017A"
  of "&zcaron;": "\u017E"
  of "&zcy;": "\u0437"
  of "&zdot;": "\u017C"
  of "&zeetrf;": "\u2128"
  of "&zeta;": "\u03B6"
  of "&zfr;": "\uD835\uDD37"
  of "&zhcy;": "\u0436"
  of "&zigrarr;": "\u21DD"
  of "&zopf;": "\uD835\uDD6B"
  of "&zscr;": "\uD835\uDCCF"
  of "&zwj;": "\u200D"
  of "&zwnj;": "\u200C"
  else:
    if s.len < 3: ""
    else: s[1..s.len-2].entityToUtf8
