% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/22-dbCreateTableArrow.R
\name{dbCreateTableArrow}
\alias{dbCreateTableArrow}
\title{Create a table in the database based on an Arrow object}
\usage{
dbCreateTableArrow(conn, name, value, ..., temporary = FALSE)
}
\arguments{
\item{conn}{A \link[=DBIConnection-class]{DBI::DBIConnection} object,
as returned by \code{\link[=dbConnect]{dbConnect()}}.}

\item{name}{The table name, passed on to \code{\link[=dbQuoteIdentifier]{dbQuoteIdentifier()}}. Options are:
\itemize{
\item a character string with the unquoted DBMS table name,
e.g. \code{"table_name"},
\item a call to \code{\link[=Id]{Id()}} with components to the fully qualified table name,
e.g. \code{Id(schema = "my_schema", table = "table_name")}
\item a call to \code{\link[=SQL]{SQL()}} with the quoted and fully qualified table name
given verbatim, e.g. \code{SQL('"my_schema"."table_name"')}
}}

\item{value}{An object for which a schema can be determined via
\code{\link[nanoarrow:as_nanoarrow_schema]{nanoarrow::infer_nanoarrow_schema()}}.}

\item{...}{Other parameters passed on to methods.}

\item{temporary}{If \code{TRUE}, will generate a temporary table.}
}
\value{
\code{dbCreateTableArrow()} returns \code{TRUE}, invisibly.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

The default \code{dbCreateTableArrow()} method determines the R data types
of the Arrow schema associated with the Arrow object,
and calls \code{\link[=dbCreateTable]{dbCreateTable()}}.
Backends that implement \code{\link[=dbAppendTableArrow]{dbAppendTableArrow()}} should typically
also implement this generic.
Use \code{\link[=dbCreateTable]{dbCreateTable()}} to create a table from the column types
as defined in a data frame.

\Sexpr[results=rd,stage=render]{DBI:::methods_as_rd("dbCreateTableArrow")}
}
\section{Failure modes}{


If the table exists, an error is raised; the remote table remains unchanged.

An error is raised when calling this method for a closed
or invalid connection.
An error is also raised
if \code{name} cannot be processed with \code{\link[DBI:dbQuoteIdentifier]{DBI::dbQuoteIdentifier()}} or
if this results in a non-scalar.
Invalid values for the \code{temporary} argument
(non-scalars,
unsupported data types,
\code{NA},
incompatible values,
duplicate names)
also raise an error.

}

\section{Additional arguments}{


The following arguments are not part of the \code{dbCreateTableArrow()} generic
(to improve compatibility across backends)
but are part of the DBI specification:
\itemize{
\item \code{temporary} (default: \code{FALSE})
}

They must be provided as named arguments.
See the "Specification" and "Value" sections for details on their usage.

}

\section{Specification}{


The \code{name} argument is processed as follows,
to support databases that allow non-syntactic names for their objects:
\itemize{
\item If an unquoted table name as string: \code{dbCreateTableArrow()} will do the quoting,
perhaps by calling \code{dbQuoteIdentifier(conn, x = name)}
\item If the result of a call to \code{\link[DBI:dbQuoteIdentifier]{DBI::dbQuoteIdentifier()}}: no more quoting is done
}

The \code{value} argument can be:
\itemize{
\item a data frame,
\item a nanoarrow array
\item a nanoarrow array stream
(which will still contain the data after the call)
\item a nanoarrow schema
}

If the \code{temporary} argument is \code{TRUE}, the table is not available in a
second connection and is gone after reconnecting.
Not all backends support this argument.
A regular, non-temporary table is visible in a second connection,
in a pre-existing connection,
and after reconnecting to the database.

SQL keywords can be used freely in table names, column names, and data.
Quotes, commas, and spaces can also be used  for table names and column names,
if the database supports non-syntactic identifiers.

}

\examples{
\dontshow{if (requireNamespace("RSQLite", quietly = TRUE) && requireNamespace("nanoarrow", quietly = TRUE)) withAutoprint(\{ # examplesIf}
con <- dbConnect(RSQLite::SQLite(), ":memory:")
ptype <- data.frame(a = numeric())
dbCreateTableArrow(con, "df", nanoarrow::infer_nanoarrow_schema(ptype))
dbReadTable(con, "df")
dbDisconnect(con)
\dontshow{\}) # examplesIf}
}
\seealso{
Other DBIConnection generics: 
\code{\link{DBIConnection-class}},
\code{\link{dbAppendTable}()},
\code{\link{dbAppendTableArrow}()},
\code{\link{dbCreateTable}()},
\code{\link{dbDataType}()},
\code{\link{dbDisconnect}()},
\code{\link{dbExecute}()},
\code{\link{dbExistsTable}()},
\code{\link{dbGetException}()},
\code{\link{dbGetInfo}()},
\code{\link{dbGetQuery}()},
\code{\link{dbGetQueryArrow}()},
\code{\link{dbIsReadOnly}()},
\code{\link{dbIsValid}()},
\code{\link{dbListFields}()},
\code{\link{dbListObjects}()},
\code{\link{dbListResults}()},
\code{\link{dbListTables}()},
\code{\link{dbQuoteIdentifier}()},
\code{\link{dbReadTable}()},
\code{\link{dbReadTableArrow}()},
\code{\link{dbRemoveTable}()},
\code{\link{dbSendQuery}()},
\code{\link{dbSendQueryArrow}()},
\code{\link{dbSendStatement}()},
\code{\link{dbUnquoteIdentifier}()},
\code{\link{dbWriteTable}()},
\code{\link{dbWriteTableArrow}()}
}
\concept{DBIConnection generics}
