/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.preferences.advanced;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultCellEditor;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import org.openstreetmap.josm.gui.preferences.advanced.AbstractListEditor;
import org.openstreetmap.josm.gui.preferences.advanced.PrefEntry;
import org.openstreetmap.josm.gui.util.TableHelper;
import org.openstreetmap.josm.gui.widgets.JosmTextField;
import org.openstreetmap.josm.spi.preferences.ListSetting;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.SubclassFilteredCollection;
import org.openstreetmap.josm.tools.Utils;

public class ListEditor
extends AbstractListEditor<String> {
    private final ListSettingTableModel model;

    public ListEditor(JComponent gui, PrefEntry entry, ListSetting setting) {
        super((Component)gui, I18n.tr("Change list setting", new Object[0]), entry);
        this.model = new ListSettingTableModel((List)setting.getValue());
        this.setContent(this.build(), false);
    }

    @Override
    public List<String> getData() {
        return new ArrayList<String>(SubclassFilteredCollection.filter(this.model.getData(), object -> !Utils.isEmpty(object)));
    }

    @Override
    protected final JPanel build() {
        JPanel p = new JPanel(new GridBagLayout());
        p.add((Component)new JLabel(I18n.tr("Key: {0}", this.entry.getKey())), GBC.eol().insets(0, 0, 5, 0));
        JTable table = new JTable(this.model);
        TableHelper.setFont(table, this.getClass());
        table.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        table.setTableHeader(null);
        DefaultCellEditor editor = new DefaultCellEditor(new JosmTextField());
        editor.setClickCountToStart(1);
        table.setDefaultEditor(table.getColumnClass(0), editor);
        JScrollPane pane = new JScrollPane(table);
        p.add((Component)pane, GBC.eol().insets(5, 10, 0, 0).fill());
        return p;
    }

    static class ListSettingTableModel
    extends AbstractTableModel {
        private final List<String> data;

        ListSettingTableModel(List<String> orig) {
            this.data = orig != null ? new ArrayList<String>(orig) : new ArrayList<String>();
        }

        public List<String> getData() {
            return this.data;
        }

        @Override
        public int getRowCount() {
            return this.data.size() + 1;
        }

        @Override
        public int getColumnCount() {
            return 1;
        }

        @Override
        public Object getValueAt(int row, int column) {
            return this.data.size() == row ? "" : this.data.get(row);
        }

        @Override
        public void setValueAt(Object o, int row, int column) {
            String s = (String)o;
            if (row == this.data.size()) {
                this.data.add(s);
                this.fireTableRowsInserted(row + 1, row + 1);
            } else {
                this.data.set(row, s);
            }
            this.fireTableCellUpdated(row, column);
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            return true;
        }
    }
}

