/*
 * Decompiled with CFR 0.152.
 */
package shared;

import java.math.BigInteger;
import java.util.Random;
import shared.b;
import shared.uncaughtexception;

public class LargeInteger2 {
    private BigInteger val;

    public LargeInteger2(long l) {
        this.val = BigInteger.valueOf(l);
    }

    public LargeInteger2(int numbits, Random rng) {
        this.val = new BigInteger(numbits, rng);
    }

    public LargeInteger2(String bigendian_hexstr) {
        this.val = new BigInteger(bigendian_hexstr, 16);
    }

    public LargeInteger2(byte[] bigendian_bytes) {
        this(b.BytesToHexString(bigendian_bytes));
    }

    private LargeInteger2(BigInteger val2) {
        this.val = val2;
    }

    public LargeInteger2 modPow(LargeInteger2 exponent, LargeInteger2 mod) {
        BigInteger newval = this.val.modPow(exponent.val, mod.val);
        return new LargeInteger2(newval);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public byte[] toBytes(int size) {
        byte[] result;
        byte[] bytes = this.val.toByteArray();
        if (bytes.length == size) {
            return bytes;
        }
        if (bytes.length < size) {
            int pad = size = bytes.length;
            result = new byte[size];
            int i = 0;
            while (i < bytes.length) {
                result[i + pad] = bytes[i];
                ++i;
            }
            return result;
        }
        if (bytes.length != size + 1) throw new uncaughtexception("Can not fit in given size.");
        if (bytes[0] != 0) throw new uncaughtexception("Can not fit in given size.");
        result = new byte[size];
        int i = 0;
        while (i < size) {
            result[i] = bytes[i + 1];
            ++i;
        }
        return result;
    }

    public String toString(int size) {
        byte[] data = this.toBytes(size);
        String r = b.BytesToHexString(data);
        return r;
    }

    public String toString() {
        return this.toString(64);
    }
}

