/*
 * Decompiled with CFR 0.152.
 */
package prpobjects;

import java.util.ArrayList;
import prpobjects.Guid;
import prpobjects.Uruobjectdesc;
import prpobjects.Wpstr;
import prpobjects.plNetMessage;
import prpobjects.uruobj;
import shared.Format;
import shared.b;
import shared.m;
import shared.readexception;
import uru.Bytedeque;
import uru.context;

public class plNetMsgMembersList
extends uruobj {
    public plNetMessage parent;
    private short size;
    public ArrayList<plNetMsgMemberInfoHelper> members;

    public plNetMsgMembersList(context c) throws readexception {
        this.parent = new plNetMessage(c);
        this.size = c.readShort();
        int size2 = b.Int16ToInt32(this.size);
        this.members = new ArrayList(size2);
        for (int i = 0; i < size2; ++i) {
            this.members.add(new plNetMsgMemberInfoHelper(c));
        }
    }

    @Override
    public void compile(Bytedeque c) {
        this.parent.compile(c);
        short size2 = (short)this.members.size();
        c.writeShort(size2);
        for (plNetMsgMemberInfoHelper member : this.members) {
            member.compile(c);
        }
    }

    private plNetMsgMembersList() {
    }

    public static plNetMsgMembersList createWithPlayeridx(int playerIdx) {
        plNetMsgMembersList r = new plNetMsgMembersList();
        r.parent = plNetMessage.createWithPlayeridx(playerIdx);
        r.members = new ArrayList();
        return r;
    }

    public static class plClientGuid
    extends uruobj {
        public static final int kAcctUuid = 1;
        public static final int kPlayerID = 2;
        public static final int kTempPlayerID = 4;
        public static final int kCCRLevel = 8;
        public static final int kProtectedLogin = 16;
        public static final int kBuildType = 32;
        public static final int kPlayerName = 64;
        public static final int kSrcAddr = 128;
        public static final int kSrcPort = 256;
        public static final int kReserved = 512;
        public static final int kClientKey = 1024;
        short flags;
        Guid acctGuid;
        int playerIdx;
        Wpstr playerName;
        byte CCRLevel;
        byte protectedLogin;
        byte buildType;
        int srcAddr;
        short srcPort;
        short reserved;
        Wpstr clientKey;

        public plClientGuid(context c) {
            this.flags = c.readShort();
            if ((this.flags & 1) != 0) {
                this.acctGuid = new Guid(c);
            }
            if ((this.flags & 2) != 0) {
                this.playerIdx = c.readInt();
            }
            if ((this.flags & 0x40) != 0) {
                this.playerName = new Wpstr(c);
            }
            if ((this.flags & 8) != 0) {
                this.CCRLevel = c.readByte();
            }
            if ((this.flags & 0x10) != 0) {
                this.protectedLogin = c.readByte();
            }
            if ((this.flags & 0x20) != 0) {
                this.buildType = c.readByte();
            }
            if ((this.flags & 0x80) != 0) {
                this.srcAddr = c.readInt();
            }
            if ((this.flags & 0x100) != 0) {
                this.srcPort = c.readShort();
            }
            if ((this.flags & 0x200) != 0) {
                this.reserved = c.readShort();
            }
            if ((this.flags & 0x400) != 0) {
                this.clientKey = new Wpstr(c);
            }
        }

        @Override
        public void compile(Bytedeque c) {
            c.writeShort(this.flags);
            if ((this.flags & 1) != 0) {
                this.acctGuid.write(c);
            }
            if ((this.flags & 2) != 0) {
                c.writeInt(this.playerIdx);
            }
            if ((this.flags & 0x40) != 0) {
                this.playerName.compile(c);
            }
            if ((this.flags & 8) != 0) {
                c.writeByte(this.CCRLevel);
            }
            if ((this.flags & 0x10) != 0) {
                c.writeByte(this.protectedLogin);
            }
            if ((this.flags & 0x20) != 0) {
                c.writeByte(this.buildType);
            }
            if ((this.flags & 0x80) != 0) {
                c.writeInt(this.srcAddr);
            }
            if ((this.flags & 0x100) != 0) {
                c.writeShort(this.srcPort);
            }
            if ((this.flags & 0x200) != 0) {
                c.writeShort(this.reserved);
            }
            if ((this.flags & 0x400) != 0) {
                this.clientKey.compile(c);
            }
        }

        private plClientGuid() {
        }

        public static plClientGuid createEmpty() {
            plClientGuid r = new plClientGuid();
            return r;
        }

        public void setPlayerId(int playerIdx) {
            this.playerIdx = playerIdx;
            this.flags = (short)(this.flags | 2);
        }

        public void setPlayerName(String playerName) {
            this.playerName = Wpstr.create(playerName);
            this.flags = (short)(this.flags | 0x40);
        }

        public void setCCRLevel(byte CCRLevel) {
            this.CCRLevel = CCRLevel;
            this.flags = (short)(this.flags | 8);
        }

        public void setAcctGuid(Guid acctGuid) {
            this.acctGuid = acctGuid;
            this.flags = (short)(this.flags | 1);
        }
    }

    public static class plNetMsgMemberInfoHelper
    extends uruobj {
        public int flags;
        public plClientGuid clientGuid;
        public Uruobjectdesc avatarDesc;

        public plNetMsgMemberInfoHelper(context c) throws readexception {
            this.flags = c.readInt();
            this.clientGuid = new plClientGuid(c);
            this.avatarDesc = new Uruobjectdesc(c);
        }

        @Override
        public void compile(Bytedeque c) {
            if (c.format != Format.moul) {
                m.throwUncaughtException("untested");
            }
            c.writeInt(this.flags);
            this.clientGuid.compile(c);
            this.avatarDesc.compile(c);
        }

        private plNetMsgMemberInfoHelper() {
        }

        public static plNetMsgMemberInfoHelper createWithAvatardesc(Uruobjectdesc avatarDesc) {
            plNetMsgMemberInfoHelper r = new plNetMsgMemberInfoHelper();
            r.flags = 0;
            r.clientGuid = plClientGuid.createEmpty();
            r.avatarDesc = avatarDesc;
            return r;
        }
    }
}

