/*
 * Decompiled with CFR 0.152.
 */
package prpobjects;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Vector;
import prpobjects.BoundingBox;
import prpobjects.DrawableSpansEncoders;
import prpobjects.HexislePlDrawableSpans;
import prpobjects.Transmatrix;
import prpobjects.Typeid;
import prpobjects.Uruobjectref;
import prpobjects.uruobj;
import shared.Flt;
import shared.IBytestream;
import shared.ShortTriplet;
import shared.b;
import shared.e;
import shared.m;
import shared.readexception;
import shared.uncaughtexception;
import uru.Bytedeque;
import uru.Bytestream;
import uru.context;

public class plDrawableSpans
extends uruobj {
    public int props;
    public int renderLevel;
    public int criteria;
    public int materialsCount;
    public Vector<Uruobjectref> materials = new Vector();
    public int icicleCount;
    public PlIcicle[] icicles;
    public int unused;
    public int spanCount;
    public int[] spanSourceIndices;
    public Uruobjectref[] fogEnvironmentRefs;
    public BoundingBox xLocalBounds;
    public BoundingBox xWorldBounds;
    public BoundingBox xMaxWorldBounds;
    public int sourceSpanCount;
    public int matrixsetcount;
    public Transmatrix[] localToWorlds;
    public Transmatrix[] worldToLocals;
    public Transmatrix[] localToBones;
    public Transmatrix[] boneToLocals;
    public int DIIndicesCount;
    public PlDISpanIndex[] DIIndices;
    public int meshcount;
    public PlGBufferGroup[] groups;
    public Typeid embeddedtype;
    public PlSpaceTree xspacetree;
    public Uruobjectref scenenode;
    static final int kSpanTypeMask = -1073741824;
    static final int kSpanIDMask = 0x3FFFFFFF;
    static final int kSpanTypeIcicle = 0;
    static final int kSpanTypeUnknown = Integer.MIN_VALUE;
    static final int kSpanTypeParticleSpan = -1073741824;
    public Vector<PlIcicle> spans = new Vector();
    public int oldiciclecount;

    public plDrawableSpans(context c) throws readexception {
        int i;
        IBytestream data = c.in;
        this.props = data.readInt();
        this.renderLevel = data.readInt();
        this.criteria = data.readInt();
        this.materialsCount = data.readInt();
        this.materials = c.readVector(Uruobjectref.class, this.materialsCount);
        this.icicleCount = data.readInt();
        this.icicles = (PlIcicle[])c.readArray(PlIcicle.class, this.icicleCount);
        for (i = 0; i < this.icicleCount; ++i) {
            if (this.icicles[i].parent.parent.materialindex != 58) continue;
            boolean bl = false;
        }
        if (c.readversion == 7) {
            this.unused = 0;
        } else {
            this.unused = data.readInt();
            e.ensure(this.unused == 0);
        }
        this.spanCount = data.readInt();
        e.ensure(this.spanCount == this.icicleCount);
        this.spanSourceIndices = new int[this.spanCount];
        for (i = 0; i < this.spanCount; ++i) {
            this.spanSourceIndices[i] = c.readInt();
            if ((this.spanSourceIndices[i] & 0xC0000000) == 0) {
                int iciIdx = this.spanSourceIndices[i] & 0x3FFFFFFF;
                if (iciIdx != i) {
                    m.warn("icicles and spans don't align.");
                }
                this.spans.add(this.icicles[iciIdx]);
                continue;
            }
            if ((this.spanSourceIndices[i] & 0xC0000000) != -1073741824) continue;
            throw new uncaughtexception("Unhandled case in PlDrawableSpans");
        }
        this.fogEnvironmentRefs = new Uruobjectref[this.icicleCount];
        for (i = 0; i < this.icicleCount; ++i) {
            this.fogEnvironmentRefs[i] = new Uruobjectref(c);
        }
        if (this.icicleCount > 0) {
            this.xLocalBounds = new BoundingBox(c);
            this.xWorldBounds = new BoundingBox(c);
            this.xMaxWorldBounds = new BoundingBox(c);
        }
        for (i = 0; i < this.spanCount; ++i) {
            if ((this.spans.get((int)i).parent.parent.props & PlSpan.kPropHasPermaLights) != 0) {
                if (this.spans.get((int)i).parent.parent.permaLights != null) {
                    throw new uncaughtexception("Unhandled permalights.");
                }
                this.spans.get((int)i).parent.parent.permaLightsCount = c.readInt();
                this.spans.get((int)i).parent.parent.permaLights = (Uruobjectref[])c.readArray(Uruobjectref.class, this.spans.get((int)i).parent.parent.permaLightsCount);
            }
            if ((this.spans.get((int)i).parent.parent.props & PlSpan.kPropHasPermaProjs) == 0) continue;
            if (this.spans.get((int)i).parent.parent.permaProjs != null) {
                throw new uncaughtexception("Unhandled permaprojs.");
            }
            this.spans.get((int)i).parent.parent.permaProjsCount = c.readInt();
            this.spans.get((int)i).parent.parent.permaProjs = (Uruobjectref[])c.readArray(Uruobjectref.class, this.spans.get((int)i).parent.parent.permaProjsCount);
        }
        this.sourceSpanCount = c.readInt();
        if (this.sourceSpanCount != 0) {
            throw new uncaughtexception("Unhandled sourceSpans.");
        }
        this.matrixsetcount = data.readInt();
        this.localToWorlds = new Transmatrix[this.matrixsetcount];
        this.worldToLocals = new Transmatrix[this.matrixsetcount];
        this.localToBones = new Transmatrix[this.matrixsetcount];
        this.boneToLocals = new Transmatrix[this.matrixsetcount];
        for (i = 0; i < this.matrixsetcount; ++i) {
            this.localToWorlds[i] = new Transmatrix(c);
            this.worldToLocals[i] = new Transmatrix(c);
            this.localToBones[i] = new Transmatrix(c);
            this.boneToLocals[i] = new Transmatrix(c);
        }
        this.DIIndicesCount = data.readInt();
        this.DIIndices = (PlDISpanIndex[])c.readArray(PlDISpanIndex.class, this.DIIndicesCount);
        this.meshcount = data.readInt();
        if (c.readversion == 7) {
            this.groups = new PlGBufferGroup[this.meshcount];
            for (i = 0; i < this.groups.length; ++i) {
                PlGBufferGroup group;
                HexislePlDrawableSpans.HexislePlGBufferGroup higroup = new HexislePlDrawableSpans.HexislePlGBufferGroup(c);
                this.groups[i] = group = higroup.convertToPotsPlGBufferGroup();
            }
        } else {
            this.groups = (PlGBufferGroup[])c.readArray(PlGBufferGroup.class, this.meshcount);
        }
        this.embeddedtype = Typeid.Read(c);
        switch (this.embeddedtype) {
            case plSceneNode: {
                break;
            }
            case nil: {
                break;
            }
            case plSpaceTree: {
                this.xspacetree = new PlSpaceTree(c);
                break;
            }
            default: {
                m.msg("unknown type.");
            }
        }
        this.scenenode = (Uruobjectref)c.readObj(Uruobjectref.class);
    }

    @Override
    public void compile(Bytedeque data) {
        int i;
        data.writeInt(this.props);
        data.writeInt(this.renderLevel);
        data.writeInt(this.criteria);
        data.writeInt(this.materialsCount);
        data.writeVector2(this.materials);
        data.writeInt(this.icicleCount);
        data.writeArray2(this.icicles);
        data.writeInt(this.unused);
        data.writeInt(this.spanCount);
        data.writeInts(this.spanSourceIndices);
        data.writeArray2(this.fogEnvironmentRefs);
        if (this.icicleCount > 0) {
            this.xLocalBounds.compile(data);
            this.xWorldBounds.compile(data);
            this.xMaxWorldBounds.compile(data);
        }
        for (i = 0; i < this.spanCount; ++i) {
            if ((this.spans.get((int)i).parent.parent.props & PlSpan.kPropHasPermaLights) != 0) {
                data.writeInt(this.spans.get((int)i).parent.parent.permaLightsCount);
                data.writeArray2(this.spans.get((int)i).parent.parent.permaLights);
            }
            if ((this.spans.get((int)i).parent.parent.props & PlSpan.kPropHasPermaProjs) == 0) continue;
            data.writeInt(this.spans.get((int)i).parent.parent.permaProjsCount);
            data.writeArray2(this.spans.get((int)i).parent.parent.permaProjs);
        }
        data.writeInt(this.sourceSpanCount);
        data.writeInt(this.matrixsetcount);
        for (i = 0; i < this.matrixsetcount; ++i) {
            this.localToWorlds[i].compile(data);
            this.worldToLocals[i].compile(data);
            this.localToBones[i].compile(data);
            this.boneToLocals[i].compile(data);
        }
        data.writeInt(this.DIIndicesCount);
        data.writeArray2(this.DIIndices);
        data.writeInt(this.meshcount);
        data.writeArray2(this.groups);
        this.embeddedtype.compile(data);
        switch (this.embeddedtype) {
            case nil: {
                break;
            }
            case plSpaceTree: {
                this.xspacetree.compile(data);
                break;
            }
            default: {
                m.throwUncaughtException("unknown type.");
            }
        }
        this.scenenode.compile(data);
    }

    public plDrawableSpans() {
    }

    public int addMaterial(Uruobjectref mat) {
        this.materials.add(mat);
        ++this.materialsCount;
        return this.materialsCount - 1;
    }

    public static class PlGBufferGroup
    extends uruobj {
        public byte fformat;
        public int size;
        public int vertexstoragecount;
        public SubMesh[] submeshes;
        public int surfacecount;
        public Surface[] surfaces;
        public PlGBufferCell[][] fCells;

        public PlGBufferGroup() {
        }

        public PlGBufferGroup(context c) throws readexception {
            IBytestream data = c.in;
            if (c.readversion == 7) {
                HexislePlDrawableSpans.ReadPlGBufferGroup(c);
            } else {
                int i;
                this.fformat = data.readByte();
                this.size = data.readInt();
                this.vertexstoragecount = data.readInt();
                this.submeshes = new SubMesh[this.vertexstoragecount];
                for (i = 0; i < this.vertexstoragecount; ++i) {
                    this.submeshes[i] = new SubMesh(c, this.fformat);
                }
                this.surfacecount = data.readInt();
                this.surfaces = new Surface[this.surfacecount];
                for (i = 0; i < this.surfacecount; ++i) {
                    this.surfaces[i] = new Surface(c);
                }
                this.fCells = new PlGBufferCell[this.vertexstoragecount][];
                for (i = 0; i < this.vertexstoragecount; ++i) {
                    int bufferCellCount = data.readInt();
                    this.fCells[i] = new PlGBufferCell[bufferCellCount];
                    for (int j = 0; j < bufferCellCount; ++j) {
                        this.fCells[i][j] = new PlGBufferCell(c);
                    }
                }
                boolean bl = false;
            }
        }

        public void createCells() {
            this.fCells = new PlGBufferCell[this.vertexstoragecount][1];
            for (int i = 0; i < this.vertexstoragecount; ++i) {
                PlGBufferCell cell;
                int c2 = b.Int16ToInt32(this.submeshes[i].count);
                this.fCells[i][0] = cell = new PlGBufferCell(0, -1, c2);
            }
        }

        @Override
        public void compile(Bytedeque data) {
            int i;
            data.writeByte(this.fformat);
            data.writeInt(this.size);
            data.writeInt(this.vertexstoragecount);
            for (i = 0; i < this.vertexstoragecount; ++i) {
                this.submeshes[i].compile(data, this.fformat);
            }
            data.writeInt(this.surfacecount);
            for (i = 0; i < this.surfacecount; ++i) {
                this.surfaces[i].compile(data);
            }
            for (i = 0; i < this.vertexstoragecount; ++i) {
                int bufferCellCount = this.fCells[i].length;
                data.writeInt(bufferCellCount);
                for (int j = 0; j < bufferCellCount; ++j) {
                    this.fCells[i][j].compile(data);
                }
            }
        }

        public static class SubMesh {
            short count;
            public byte[] _rawdata;
            int rawdataversion;
            DrawableSpansEncoders.DecompressedPotsVertices verts = null;

            public SubMesh() {
            }

            public int getCount() {
                return b.Int16ToInt32(this.count);
            }

            public float[] getVertices(byte fformat2) {
                int i;
                context c = context.createFromBytestream(new Bytestream(this._rawdata));
                c.readversion = this.rawdataversion;
                int count2 = this.getCount();
                float[] result = new float[count2 * 3];
                int fformat = b.ByteToInt32(fformat2);
                int A = (fformat & 0x40) >>> 6;
                int B = (fformat & 0x30) >>> 4;
                int C = (fformat & 0xF) >>> 0;
                DrawableSpansEncoders.rundataElement x = new DrawableSpansEncoders.rundataElement();
                DrawableSpansEncoders.rundataElement y = new DrawableSpansEncoders.rundataElement();
                DrawableSpansEncoders.rundataElement z = new DrawableSpansEncoders.rundataElement();
                DrawableSpansEncoders.rundataElement[] ws = new DrawableSpansEncoders.rundataElement[3];
                for (int i2 = 0; i2 < 3; ++i2) {
                    ws[i2] = new DrawableSpansEncoders.rundataElement();
                }
                DrawableSpansEncoders.rundataColour blue = new DrawableSpansEncoders.rundataColour();
                DrawableSpansEncoders.rundataColour green = new DrawableSpansEncoders.rundataColour();
                DrawableSpansEncoders.rundataColour red = new DrawableSpansEncoders.rundataColour();
                DrawableSpansEncoders.rundataColour alpha = new DrawableSpansEncoders.rundataColour();
                DrawableSpansEncoders.rundataElement[][] uvs = new DrawableSpansEncoders.rundataElement[15][];
                for (i = 0; i < 15; ++i) {
                    uvs[i] = new DrawableSpansEncoders.rundataElement[3];
                    for (int j = 0; j < 3; ++j) {
                        uvs[i][j] = new DrawableSpansEncoders.rundataElement();
                    }
                }
                for (i = 0; i < count2; ++i) {
                    short s;
                    short out3;
                    short out2;
                    int j;
                    float xval = x.pollAsElement3(c);
                    float yval = y.pollAsElement3(c);
                    float zval = z.pollAsElement3(c);
                    result[i * 3 + 0] = xval;
                    result[i * 3 + 1] = yval;
                    result[i * 3 + 2] = zval;
                    for (j = 0; j < B; ++j) {
                        ws[j].pollAsElement2(c);
                    }
                    if (B != 0 && A != 0) {
                        j = c.in.readInt();
                    }
                    if (c.readversion == 6) {
                        out2 = c.in.readByte();
                        out3 = c.in.readByte();
                        s = c.in.readByte();
                    } else if (c.readversion == 3 || c.readversion == 4) {
                        out2 = c.in.readShort();
                        out3 = c.in.readShort();
                        s = c.in.readShort();
                    }
                    blue.pollAsColour(c);
                    green.pollAsColour(c);
                    red.pollAsColour(c);
                    alpha.pollAsColour(c);
                    for (j = 0; j < C; ++j) {
                        for (int k = 0; k < 3; ++k) {
                            uvs[j][k].pollAsElement(c);
                        }
                    }
                }
                return result;
            }

            public DrawableSpansEncoders.DecompressedPotsVertices decompressAllAndDontSave(byte fformat2) {
                return new DrawableSpansEncoders.DecompressedPotsVertices(this._rawdata, fformat2, this.rawdataversion, this.getCount());
            }

            public DrawableSpansEncoders.DecompressedPotsVertices decompressAllAndSave(byte fformat2) {
                if (this.verts == null) {
                    DrawableSpansEncoders.DecompressedPotsVertices r;
                    this.verts = r = new DrawableSpansEncoders.DecompressedPotsVertices(this._rawdata, fformat2, this.rawdataversion, this.getCount());
                }
                return this.verts;
            }

            public void setWithDecompressedPotsVerts(DrawableSpansEncoders.DecompressedPotsVertices verts) {
                this.verts = verts;
                this.rawdataversion = 3;
                this.count = (short)verts.count;
            }

            public DrawableSpansEncoders.RawPotsVertices parseAll(byte fformat2) {
                int i;
                context c = context.createFromBytestream(new Bytestream(this._rawdata));
                e.force(this.rawdataversion == 3);
                c.readversion = this.rawdataversion;
                int count2 = this.getCount();
                DrawableSpansEncoders.RawPotsVertices r = new DrawableSpansEncoders.RawPotsVertices(count2);
                int fformat = b.ByteToInt32(fformat2);
                int A = (fformat & 0x40) >>> 6;
                int B = (fformat & 0x30) >>> 4;
                int C = (fformat & 0xF) >>> 0;
                DrawableSpansEncoders.rundataElement x = new DrawableSpansEncoders.rundataElement();
                DrawableSpansEncoders.rundataElement y = new DrawableSpansEncoders.rundataElement();
                DrawableSpansEncoders.rundataElement z = new DrawableSpansEncoders.rundataElement();
                DrawableSpansEncoders.rundataElement[] ws = new DrawableSpansEncoders.rundataElement[3];
                for (int i2 = 0; i2 < 3; ++i2) {
                    ws[i2] = new DrawableSpansEncoders.rundataElement();
                }
                DrawableSpansEncoders.rundataColour blue = new DrawableSpansEncoders.rundataColour();
                DrawableSpansEncoders.rundataColour green = new DrawableSpansEncoders.rundataColour();
                DrawableSpansEncoders.rundataColour red = new DrawableSpansEncoders.rundataColour();
                DrawableSpansEncoders.rundataColour alpha = new DrawableSpansEncoders.rundataColour();
                DrawableSpansEncoders.rundataElement[][] uvs = new DrawableSpansEncoders.rundataElement[15][];
                for (i = 0; i < 15; ++i) {
                    uvs[i] = new DrawableSpansEncoders.rundataElement[3];
                    for (int j = 0; j < 3; ++j) {
                        uvs[i][j] = new DrawableSpansEncoders.rundataElement();
                    }
                }
                for (i = 0; i < count2; ++i) {
                    int j;
                    DrawableSpansEncoders.RawPotsVertex v = new DrawableSpansEncoders.RawPotsVertex();
                    v.x = x.pollAsElement(c);
                    v.y = y.pollAsElement(c);
                    v.z = z.pollAsElement(c);
                    v.ws = new DrawableSpansEncoders.RawPotsElement[B];
                    for (j = 0; j < B; ++j) {
                        v.ws[j] = ws[j].pollAsElement(c);
                    }
                    if (B != 0 && A != 0) {
                        v.bones = c.in.readInt();
                    }
                    v.normx = c.in.readShort();
                    v.normy = c.in.readShort();
                    v.normz = c.in.readShort();
                    v.blue = blue.pollAsColour(c);
                    v.green = green.pollAsColour(c);
                    v.red = red.pollAsColour(c);
                    v.alpha = alpha.pollAsColour(c);
                    v.uvs = new DrawableSpansEncoders.RawPotsElement[C][3];
                    for (j = 0; j < C; ++j) {
                        for (int k = 0; k < 3; ++k) {
                            v.uvs[j][k] = uvs[j][k].pollAsElement(c);
                        }
                    }
                    r.vertices[i] = v;
                }
                return r;
            }

            public SubMesh(context c, byte fformat) {
                if ((fformat & 0x80) != 0) {
                    this.count = c.in.readShort();
                    context c2 = c.Fork();
                    int count2 = b.Int16ToInt32(this.count);
                    int dataSize = SubMesh.GetVertexDataSize(count2, fformat, c2);
                    this._rawdata = c.in.readBytes(dataSize);
                    this.rawdataversion = c.readversion;
                    c2.close();
                } else {
                    m.err("not supported.");
                }
            }

            public void compile(Bytedeque data, byte fformat) {
                if ((fformat & 0x80) != 0) {
                    data.writeShort(this.count);
                    if (this.verts == null) {
                        context c = context.createFromBytestream(new Bytestream(this._rawdata));
                        c.compile = true;
                        c.out = data;
                        c.readversion = this.rawdataversion;
                        int count2 = b.Int16ToInt32(this.count);
                        SubMesh.GetVertexDataSize(count2, fformat, c);
                    } else {
                        this.verts.compileSophisticated(data);
                    }
                } else {
                    m.err("not supported.");
                }
            }

            /*
             * WARNING - void declaration
             */
            public static int GetVertexDataSize(int count, byte fformat2, context c) {
                int i;
                int start = c.in.getAbsoluteOffset();
                int fformat = b.ByteToInt32(fformat2);
                int A = (fformat & 0x40) >>> 6;
                int B = (fformat & 0x30) >>> 4;
                int C = (fformat & 0xF) >>> 0;
                class Rundata {
                    Flt basee = null;
                    byte basec = 0;
                    int count = 0;
                    boolean rle = false;
                    byte b1;

                    public short pollAsElement(context c) {
                        if (this.count == 0) {
                            this.basee = new Flt(c);
                            if (c.compile) {
                                this.basee.compile(c.out);
                            }
                            if (c.readversion == 6) {
                                this.b1 = c.in.readByte();
                                if (c.compile && c.writeversion == 6) {
                                    c.out.writeByte(this.b1);
                                }
                            } else if (c.readversion == 3 || c.readversion == 4 || c.readversion == 7) {
                                // empty if block
                            }
                            short out7 = c.in.readShort();
                            if (c.compile) {
                                c.out.writeShort(out7);
                            }
                            this.count = b.Int16ToInt32(out7);
                        }
                        if (this.count != 0) {
                            short out9;
                            if (c.readversion == 6) {
                                if (this.b1 == 0) {
                                    --this.count;
                                    out9 = c.in.readShort();
                                    if (c.compile) {
                                        c.out.writeShort(out9);
                                    }
                                    return out9;
                                }
                                if (this.b1 == 1) {
                                    --this.count;
                                    if (c.compile && c.writeversion == 3) {
                                        c.out.writeShort((short)0);
                                    }
                                    return 0;
                                }
                                m.msg("unknown byte.");
                            } else if (c.readversion == 3 || c.readversion == 4 || c.readversion == 7) {
                                --this.count;
                                out9 = c.in.readShort();
                                if (c.compile) {
                                    c.out.writeShort(out9);
                                }
                            }
                        }
                        return 0;
                    }

                    public void pollAsColour(context c) {
                        if (this.count == 0) {
                            short out5 = c.in.readShort();
                            if (c.compile) {
                                c.out.writeShort(out5);
                            }
                            this.count = b.Int16ToInt32(out5);
                            if ((this.count & 0x8000) != 0) {
                                this.rle = true;
                                this.basec = c.in.readByte();
                                if (c.compile) {
                                    c.out.writeByte(this.basec);
                                }
                                this.count &= Short.MAX_VALUE;
                            } else {
                                this.rle = false;
                            }
                        }
                        if (this.count != 0) {
                            --this.count;
                            if (this.rle) {
                                return;
                            }
                            byte out6 = c.in.readByte();
                            if (c.compile) {
                                c.out.writeByte(out6);
                            }
                            return;
                        }
                        m.err("We shouldn't be able to reach here.");
                    }
                }
                Rundata x = new Rundata();
                Rundata y = new Rundata();
                Rundata z = new Rundata();
                Rundata[] ws = new Rundata[3];
                for (int i2 = 0; i2 < 3; ++i2) {
                    ws[i2] = new Rundata();
                }
                Rundata blue = new Rundata();
                Rundata green = new Rundata();
                Rundata red = new Rundata();
                Rundata alpha = new Rundata();
                Rundata[][] uvs = new Rundata[15][];
                for (i = 0; i < 15; ++i) {
                    uvs[i] = new Rundata[3];
                    for (int j = 0; j < 3; ++j) {
                        uvs[i][j] = new Rundata();
                    }
                }
                for (i = 0; i < count; ++i) {
                    void var22_23;
                    byte by;
                    int n;
                    void var22_26;
                    int possofar = c.in.getAbsoluteOffset() - start;
                    short xval = x.pollAsElement(c);
                    short yval = y.pollAsElement(c);
                    short zval = z.pollAsElement(c);
                    if (c.outputVertices) {
                        float f = x.basee.toJavaFloat();
                        c.vertices.add(Float.valueOf(f += (float)xval / 1024.0f));
                        f = x.basee.toJavaFloat();
                        c.vertices.add(Float.valueOf(f += (float)yval / 1024.0f));
                        f = x.basee.toJavaFloat();
                        c.vertices.add(Float.valueOf(f += (float)zval / 1024.0f));
                    }
                    boolean bl = false;
                    while (var22_26 < B) {
                        ws[var22_26].pollAsElement(c);
                        ++var22_26;
                    }
                    if (B != 0 && A != 0) {
                        int n2 = c.in.readInt();
                        if (c.compile) {
                            c.out.writeInt(n2);
                        }
                    }
                    if (c.readversion == 6) {
                        byte by2 = c.in.readByte();
                        n = c.in.readByte();
                        by = c.in.readByte();
                        if (c.compile) {
                            int out2i = b.ByteToInt32(by2);
                            int fin2 = out2i * 257 - 32768;
                            if (fin2 < Short.MIN_VALUE || fin2 > Short.MAX_VALUE) {
                                boolean bl2 = false;
                            }
                            short sfin2 = (short)fin2;
                            c.out.writeShort(sfin2);
                            int out3i = b.ByteToInt32((byte)n);
                            int fin3 = out3i * 257 - 32768;
                            if (fin3 < Short.MIN_VALUE || fin3 > Short.MAX_VALUE) {
                                boolean bl3 = false;
                            }
                            short sfin3 = (short)fin3;
                            c.out.writeShort(sfin3);
                            int out4i = b.ByteToInt32(by);
                            int fin4 = out4i * 257 - 32768;
                            if (fin4 < Short.MIN_VALUE || fin4 > Short.MAX_VALUE) {
                                boolean bl4 = false;
                            }
                            short sfin4 = (short)fin4;
                            c.out.writeShort(sfin4);
                        }
                    } else if (c.readversion == 3 || c.readversion == 4) {
                        short s = c.in.readShort();
                        n = c.in.readShort();
                        by = c.in.readShort();
                        if (c.compile) {
                            c.out.writeShort(s);
                            c.out.writeShort((short)n);
                            c.out.writeShort(by);
                        }
                    }
                    blue.pollAsColour(c);
                    green.pollAsColour(c);
                    red.pollAsColour(c);
                    alpha.pollAsColour(c);
                    boolean bl5 = false;
                    while (var22_23 < C) {
                        for (n = 0; n < 3; ++n) {
                            uvs[var22_23][n].pollAsElement(c);
                        }
                        ++var22_23;
                    }
                }
                int stop = c.in.getAbsoluteOffset();
                return stop - start;
            }
        }

        public static class Surface {
            public int numshorts;
            public ShortTriplet[] faces;

            public Surface() {
            }

            public Surface(context c) throws readexception {
                this.numshorts = c.readInt();
                int numfaces = this.numshorts / 3;
                e.force(numfaces * 3 == this.numshorts);
                this.faces = (ShortTriplet[])c.readArray(ShortTriplet.class, numfaces);
            }

            public void compile(Bytedeque c) {
                c.writeInt(this.numshorts);
                c.writeArray2(this.faces);
            }
        }
    }

    public static class modPlSpaceTree {
        public modNode root;
        private PlSpaceTree source;
        private HashMap<Integer, Integer> renumberingsource;
        public plDrawableSpans treespansource;

        public PlSpaceTree generatePlSpaceTree() {
            PlSpaceTree r = new PlSpaceTree();
            PlSpaceTree.Nodes rootnode = new PlSpaceTree.Nodes();
            rootnode.parent = (short)-1;
            modNode[] nodes = this.getSortedNodeList();
            PlSpaceTree.Nodes[] nodes2 = new PlSpaceTree.Nodes[nodes.length];
            for (int i = 0; i < nodes.length; ++i) {
                modNode node = nodes[i];
                PlSpaceTree.Nodes node2 = new PlSpaceTree.Nodes();
                if (node == null) {
                    int n = 0;
                }
                if (node.isleaf()) {
                    node2.boundingbox = node.icicleBounds;
                    node2.parent = (short)(node.parent == null ? -1 : (short)node.parent.index);
                    node2.type = (short)node.type;
                    node2.left = (short)node.icicle;
                    node2.right = 0;
                } else {
                    node2.boundingbox = node.icicleBounds;
                    node2.parent = (short)(node.parent == null ? -1 : (short)node.parent.index);
                    node2.type = (short)node.type;
                    node2.left = (short)node.left.index;
                    node2.right = (short)node.right.index;
                }
                nodes2[i] = node2;
            }
            r.nodes2 = nodes2;
            r.allnodes = r.nodes2.length;
            int leafcount = 0;
            for (modNode node : nodes) {
                if (!node.isleaf()) continue;
                ++leafcount;
            }
            r.leafnodes = leafcount;
            r.childnodes = (short)(r.allnodes - 1);
            return r;
        }

        private modNode[] getSortedNodeList() {
            Vector<modNode> nodes = new Vector<modNode>();
            this.getNodeList(nodes, this.root);
            int count = nodes.size();
            int leafcount = 0;
            for (modNode node : nodes) {
                if (!node.isleaf()) continue;
                ++leafcount;
            }
            modNode[] result = new modNode[nodes.size()];
            int curPos = leafcount;
            for (int i = 0; i < count; ++i) {
                modNode node = nodes.get(i);
                if (node.isleaf()) {
                    node.index = node.icicle;
                } else if (node == this.root) {
                    node.index = count - 1;
                } else {
                    node.index = curPos;
                    ++curPos;
                }
                if (result[node.index] != null) {
                    boolean bl = false;
                }
                result[((modNode)node).index] = node;
            }
            return result;
        }

        private void getNodeList(Vector<modNode> nodes, modNode curnode) {
            if (curnode.isleaf()) {
                nodes.add(curnode);
            } else {
                curnode.left.parent = curnode;
                curnode.right.parent = curnode;
                this.getNodeList(nodes, curnode.left);
                this.getNodeList(nodes, curnode.right);
                nodes.add(curnode);
            }
        }

        public void renumber(HashMap<Integer, Integer> renumbering) {
            this.renumberingsource = renumbering;
            boolean keep = this.renumber(renumbering, this.root);
            if (!keep) {
                m.warn("Nulling PlSpaceTree...");
                this.root = null;
            }
        }

        private boolean renumber(HashMap<Integer, Integer> renumbering, modNode node) {
            if (node.isleaf()) {
                Integer newicicle = renumbering.get(node.icicle);
                if (newicicle != null) {
                    node.icicle = newicicle;
                    return true;
                }
                return false;
            }
            boolean stillhaveleft = this.renumber(renumbering, node.left);
            boolean stillhaveright = this.renumber(renumbering, node.right);
            if (stillhaveleft) {
                if (stillhaveright) {
                    return true;
                }
                node.icicle = node.left.icicle;
                node.type = node.left.type;
                node.right = node.left.right;
                node.icicleBounds = node.left.icicleBounds;
                node.left = node.left.left;
                return true;
            }
            if (stillhaveright) {
                node.icicle = node.right.icicle;
                node.type = node.right.type;
                node.left = node.right.left;
                node.icicleBounds = node.right.icicleBounds;
                node.right = node.right.right;
                return true;
            }
            return false;
        }

        public void readFromPlSpaceTree(PlSpaceTree t) {
            int roots = 0;
            for (PlSpaceTree.Nodes n : t.nodes2) {
                if (n.parent != -1) continue;
                ++roots;
            }
            if (roots != 1) {
                throw new uncaughtexception("More than one root found.");
            }
            this.source = t;
            PlSpaceTree.Nodes node = t.nodes2[t.nodes2.length - 1];
            this.root = this.readFromSpaceTree(t, node);
        }

        private modNode readFromSpaceTree(PlSpaceTree t, PlSpaceTree.Nodes node) {
            modNode node2 = new modNode();
            node2.icicleBounds = node.boundingbox;
            node2.type = node.type;
            if (!node2.isleaf()) {
                PlSpaceTree.Nodes left = t.nodes2[node.left];
                PlSpaceTree.Nodes right = t.nodes2[node.right];
                node2.left = this.readFromSpaceTree(t, left);
                node2.right = this.readFromSpaceTree(t, right);
            } else {
                node2.icicle = node.left;
            }
            return node2;
        }

        public static class modNode {
            int icicle;
            BoundingBox icicleBounds;
            int type;
            modNode left;
            modNode right;
            private int index;
            private modNode parent;

            public boolean isleaf() {
                return (this.type & 1) != 0;
            }
        }
    }

    public static class PlSpaceTree
    extends uruobj {
        public short childnodes;
        public int leafnodes;
        public int allnodes;
        public Nodes[] nodes2;

        public PlSpaceTree(context c) throws readexception {
            IBytestream data = c.in;
            this.childnodes = data.readShort();
            this.leafnodes = data.readInt();
            this.allnodes = data.readInt();
            this.nodes2 = new Nodes[this.allnodes];
            for (int i = 0; i < this.allnodes; ++i) {
                this.nodes2[i] = new Nodes(c);
            }
        }

        public PlSpaceTree() {
        }

        @Override
        public void compile(Bytedeque data) {
            data.writeShort(this.childnodes);
            data.writeInt(this.leafnodes);
            data.writeInt(this.allnodes);
            for (int i = 0; i < this.allnodes; ++i) {
                this.nodes2[i].compile(data);
            }
        }

        public static class Nodes {
            public BoundingBox boundingbox;
            public short type;
            public short parent;
            public short left;
            public short right;

            public Nodes(context c) throws readexception {
                this.boundingbox = (BoundingBox)c.readObj(BoundingBox.class);
                this.type = c.in.readShort();
                this.parent = c.in.readShort();
                this.left = c.in.readShort();
                this.right = c.in.readShort();
            }

            public Nodes() {
            }

            public void compile(Bytedeque data) {
                this.boundingbox.compile(data);
                data.writeShort(this.type);
                data.writeShort(this.parent);
                data.writeShort(this.left);
                data.writeShort(this.right);
            }
        }
    }

    public static class PlDISpanIndex
    extends uruobj {
        public int flags;
        public int indicesCount;
        public int[] indices;

        public PlDISpanIndex(context c) {
            this.flags = c.in.readInt();
            this.indicesCount = c.in.readInt();
            this.indices = c.in.readInts(this.indicesCount);
        }

        PlDISpanIndex() {
        }

        public static PlDISpanIndex createWithIndex(int ind) {
            PlDISpanIndex r = new PlDISpanIndex();
            r.flags = 0;
            r.indicesCount = 1;
            r.indices = new int[]{ind};
            return r;
        }

        @Override
        public void compile(Bytedeque data) {
            data.writeInt(this.flags);
            data.writeInt(this.indicesCount);
            data.writeInts(this.indices);
        }
    }

    public static class PlIcicle
    extends uruobj {
        public PlVertexSpan parent;
        public int IBufferIdx;
        public int IStartIdx;
        public int ILength;

        public static PlIcicle createEmpty() {
            PlIcicle r = new PlIcicle();
            r.parent = PlVertexSpan.createEmpty();
            return r;
        }

        public PlIcicle(context c) throws readexception {
            this.parent = new PlVertexSpan(c);
            this.IBufferIdx = c.readInt();
            this.IStartIdx = c.readInt();
            this.ILength = c.readInt();
            if ((this.parent.parent.props & 4) != 0) {
                throw new uncaughtexception("Unhandled case in PlIcicle.");
            }
        }

        @Override
        public void compile(Bytedeque c) {
            this.parent.compile(c);
            c.writeInt(this.IBufferIdx);
            c.writeInt(this.IStartIdx);
            c.writeInt(this.ILength);
        }

        PlIcicle() {
        }

        public PlIcicle deepClone() {
            PlIcicle result = new PlIcicle();
            result.parent = this.parent.deepClone();
            result.IBufferIdx = this.IBufferIdx;
            result.IStartIdx = this.IStartIdx;
            result.ILength = this.ILength;
            return result;
        }
    }

    public static class PlVertexSpan
    extends uruobj {
        public PlSpan parent;
        public int groupIdx;
        public int VBufferIdx;
        public int cellIdx;
        public int cellOffset;
        public int VStartIdx;
        public int VLength;

        public PlVertexSpan(context c) throws readexception {
            this.parent = new PlSpan(c);
            this.groupIdx = c.readInt();
            this.VBufferIdx = c.readInt();
            if (c.readversion == 7) {
                this.VStartIdx = c.readInt();
                this.VLength = c.readInt();
                this.cellIdx = 0;
                this.cellOffset = this.VStartIdx;
            } else {
                this.cellIdx = c.readInt();
                this.cellOffset = c.readInt();
                this.VStartIdx = c.readInt();
                this.VLength = c.readInt();
            }
        }

        public static PlVertexSpan createEmpty() {
            PlVertexSpan r = new PlVertexSpan();
            r.parent = PlSpan.createEmpty();
            return r;
        }

        @Override
        public void compile(Bytedeque c) {
            this.parent.compile(c);
            c.writeInt(this.groupIdx);
            c.writeInt(this.VBufferIdx);
            c.writeInt(this.cellIdx);
            c.writeInt(this.cellOffset);
            c.writeInt(this.VStartIdx);
            c.writeInt(this.VLength);
        }

        PlVertexSpan() {
        }

        public PlVertexSpan deepClone() {
            PlVertexSpan result = new PlVertexSpan();
            result.parent = this.parent.deepClone();
            result.groupIdx = this.groupIdx;
            result.VBufferIdx = this.VBufferIdx;
            result.cellIdx = this.cellIdx;
            result.cellOffset = this.cellOffset;
            result.VStartIdx = this.VStartIdx;
            result.VLength = this.VLength;
            return result;
        }
    }

    public static class PlSpan
    extends uruobj {
        public int subType;
        public int materialindex;
        public Transmatrix localToWorld;
        public Transmatrix worldToLocal;
        public int props;
        public BoundingBox localBounds;
        public BoundingBox worldBounds;
        public int numMatrices;
        public int baseMatrix;
        public short localUVWChans;
        public short maxBoneIdx;
        public short penBoneIdx;
        public Flt minDist;
        public Flt maxDist;
        public Flt waterHeight;
        public static int kLiteMaterial = 0;
        public static int kPropNoDraw = 1;
        public static int kPropNoShadowCast = 2;
        public static int kPropFacesSortable = 4;
        public static int kPropVolatile = 8;
        public static int kWaterHeight = 16;
        public static int kPropRunTimeLight = 32;
        public static int kPropReverseSort = 64;
        public static int kPropHasPermaLights = 128;
        public static int kPropHasPermaProjs = 256;
        public static int kLiteVtxPreshaded = 512;
        public static int kLiteVtxNonPreshaded = 1024;
        public static int kLiteProjection = 2048;
        public static int kLiteShadowErase = 4096;
        public static int kLiteShadow = 8192;
        public static int kPropMatHasSpecular = 65536;
        public static int kPropProjAsVtx = 131072;
        public static int kPropSkipProjection = 262144;
        public static int kPropNoShadow = 524288;
        public static int kPropForceShadow = 0x100000;
        public static int kPropDisableNormal = 0x200000;
        public static int kPropCharacter = 0x400000;
        public static int kPartialSort = 0x800000;
        public static int kVisLOS = 0x1000000;
        public int permaLightsCount;
        public Uruobjectref[] permaLights;
        public int permaProjsCount;
        public Uruobjectref[] permaProjs;

        public PlSpan(context c) throws readexception {
            this.subType = c.readInt();
            e.ensureflags(this.subType, 1, 0);
            this.materialindex = c.readInt();
            if ((this.materialindex == 0 || this.materialindex == 3) && c.curRootObject.objectname.toString().toLowerCase().startsWith("minkata_minkexteriorday_4000000c_2blendspans")) {
                boolean bl = false;
            }
            this.localToWorld = (Transmatrix)c.readObj(Transmatrix.class);
            this.worldToLocal = (Transmatrix)c.readObj(Transmatrix.class);
            this.props = c.readInt();
            this.localBounds = (BoundingBox)c.readObj(BoundingBox.class);
            this.worldBounds = (BoundingBox)c.readObj(BoundingBox.class);
            this.numMatrices = c.readInt();
            this.baseMatrix = c.readInt();
            this.localUVWChans = c.readShort();
            this.maxBoneIdx = c.readShort();
            this.penBoneIdx = c.readShort();
            this.minDist = (Flt)c.readObj(Flt.class);
            this.maxDist = (Flt)c.readObj(Flt.class);
            if ((this.props & 0x10) != 0) {
                this.waterHeight = (Flt)c.readObj(Flt.class);
            }
        }

        public static PlSpan createEmpty() {
            PlSpan r = new PlSpan();
            return r;
        }

        @Override
        public void compile(Bytedeque c) {
            c.writeInt(this.subType);
            c.writeInt(this.materialindex);
            this.localToWorld.compile(c);
            this.worldToLocal.compile(c);
            c.writeInt(this.props);
            this.localBounds.compile(c);
            this.worldBounds.compile(c);
            c.writeInt(this.numMatrices);
            c.writeInt(this.baseMatrix);
            c.writeShort(this.localUVWChans);
            c.writeShort(this.maxBoneIdx);
            c.writeShort(this.penBoneIdx);
            this.minDist.compile(c);
            this.maxDist.compile(c);
            if ((this.props & 0x10) != 0) {
                this.waterHeight.compile(c);
            }
        }

        PlSpan() {
        }

        public PlSpan deepClone() {
            PlSpan r = new PlSpan();
            r.subType = this.subType;
            r.materialindex = this.materialindex;
            r.localToWorld = this.localToWorld.deepClone();
            r.worldToLocal = this.worldToLocal.deepClone();
            r.props = this.props;
            r.localBounds = this.localBounds.deepClone();
            r.worldBounds = this.worldBounds.deepClone();
            r.numMatrices = this.numMatrices;
            r.baseMatrix = this.baseMatrix;
            r.localUVWChans = this.localUVWChans;
            r.maxBoneIdx = this.maxBoneIdx;
            r.penBoneIdx = this.penBoneIdx;
            r.minDist = this.minDist.deepClone();
            r.maxDist = this.maxDist.deepClone();
            r.waterHeight = this.waterHeight.deepClone();
            return r;
        }
    }

    public static class modPlDrawableSpans {
        int props;
        int renderLevel;
        int criteria;
        Uruobjectref scenenode;
        BoundingBox xLocalBounds;
        BoundingBox xWorldBounds;
        BoundingBox xMaxWorldBounds;
        Transmatrix[] localToBones;
        Transmatrix[] boneToLocals;
        Transmatrix[] worldToLocals;
        Transmatrix[] localToWorlds;
        Uruobjectref[] fogEnvironmentRefs;
        HashSet<HashSet<modPlIcicle>> modicicles = new HashSet();

        public void addFromSubsetgroupindex(plDrawableSpans span, int subsetGroupIndex) {
            if (subsetGroupIndex != -1) {
                PlDISpanIndex spanindex = span.DIIndices[subsetGroupIndex];
                HashSet<modPlIcicle> icicles = new HashSet<modPlIcicle>();
                for (int subsetind : spanindex.indices) {
                    PlIcicle icicle = span.icicles[subsetind];
                    Uruobjectref material = span.materials.get(icicle.parent.parent.materialindex);
                    PlGBufferGroup bg = span.groups[icicle.parent.groupIdx];
                    modPlIcicle mi = new modPlIcicle();
                    mi.icicle = icicle.deepClone();
                    mi.material = material.deepClone();
                    mi.buffergroup = bg;
                    icicles.add(mi);
                }
                this.modicicles.add(icicles);
            }
        }

        public void copyDefaultsFromOtherDrawableSpans(plDrawableSpans span) {
            this.props = span.props;
            this.renderLevel = span.renderLevel;
            this.criteria = span.criteria;
            this.fogEnvironmentRefs = span.fogEnvironmentRefs;
            this.xLocalBounds = span.xLocalBounds;
            this.xWorldBounds = span.xWorldBounds;
            this.xMaxWorldBounds = span.xMaxWorldBounds;
            this.localToBones = span.localToBones;
            this.boneToLocals = span.boneToLocals;
            this.localToWorlds = span.localToWorlds;
            this.worldToLocals = span.worldToLocals;
            this.scenenode = span.scenenode;
        }

        public plDrawableSpans createDrawableSpans() {
            plDrawableSpans r = new plDrawableSpans();
            r.props = this.props;
            r.renderLevel = this.renderLevel;
            r.criteria = this.criteria;
            r.unused = 0;
            r.fogEnvironmentRefs = this.fogEnvironmentRefs;
            r.xLocalBounds = this.xLocalBounds;
            r.xWorldBounds = this.xWorldBounds;
            r.xMaxWorldBounds = this.xMaxWorldBounds;
            r.localToBones = this.localToBones;
            r.boneToLocals = this.boneToLocals;
            r.localToWorlds = this.localToWorlds;
            r.worldToLocals = this.worldToLocals;
            r.embeddedtype = Typeid.plSceneNode;
            r.xspacetree = null;
            r.scenenode = this.scenenode;
            m.err("not finished.");
            return r;
        }

        public static class modPlIcicle {
            PlIcicle icicle;
            Uruobjectref material;
            PlGBufferGroup buffergroup;
        }
    }

    public static class PlGBufferCell {
        int fVtxStart;
        int fColorStart;
        int fLength;

        public PlGBufferCell(context c) {
            boolean bl;
            this.fVtxStart = c.readInt();
            this.fColorStart = c.readInt();
            this.fLength = c.readInt();
            if (this.fVtxStart != 0) {
                bl = false;
            }
            if (this.fColorStart != -1) {
                bl = false;
            }
        }

        public PlGBufferCell(int vtxstart, int colorstart, int length) {
            this.fVtxStart = vtxstart;
            this.fColorStart = colorstart;
            this.fLength = length;
        }

        public void compile(Bytedeque c) {
            c.writeInt(this.fVtxStart);
            c.writeInt(this.fColorStart);
            c.writeInt(this.fLength);
        }
    }
}

