/*
 * Decompiled with CFR 0.152.
 */
package prpobjects;

import prpobjects.uruobj;
import shared.Flt;
import shared.RGBA;
import uru.Bytedeque;
import uru.context;

public class Rgba
extends uruobj {
    public Flt r;
    public Flt g;
    public Flt b;
    public Flt a;

    public Rgba(context c) {
        this.r = new Flt(c);
        this.g = new Flt(c);
        this.b = new Flt(c);
        this.a = new Flt(c);
    }

    public Rgba(Flt r, Flt g, Flt b2, Flt a) {
        this.r = r;
        this.g = g;
        this.b = b2;
        this.a = a;
    }

    @Override
    public void compile(Bytedeque deque) {
        this.r.compile(deque);
        this.g.compile(deque);
        this.b.compile(deque);
        this.a.compile(deque);
    }

    public String toString() {
        return this.r.toString() + ":" + this.g.toString() + ":" + this.b.toString() + ":" + this.a.toString();
    }

    private Rgba() {
    }

    public Rgba(Rgba d) {
        this.a = d.a.deepClone();
        this.b = d.b.deepClone();
        this.g = d.g.deepClone();
        this.r = d.r.deepClone();
    }

    public static Rgba createFromRGBA(RGBA data) {
        Rgba r = new Rgba();
        r.r = Flt.createFromJavaFloat(data.r);
        r.g = Flt.createFromJavaFloat(data.g);
        r.b = Flt.createFromJavaFloat(data.b);
        r.a = Flt.createFromJavaFloat(data.a);
        return r;
    }

    public static Rgba createFromVals(float r, float g, float b2, float a) {
        Rgba r2 = new Rgba();
        r2.r = Flt.createFromJavaFloat(r);
        r2.g = Flt.createFromJavaFloat(g);
        r2.b = Flt.createFromJavaFloat(b2);
        r2.a = Flt.createFromJavaFloat(a);
        return r2;
    }

    public Rgba deepClone() {
        return new Rgba(this);
    }
}

