/*
 * Decompiled with CFR 0.152.
 */
package moulserver;

import java.io.File;
import java.util.ArrayList;
import java.util.Vector;
import moulserver.AuthServer;
import moulserver.ConnectionState;
import moulserver.Enums;
import moulserver.Manager;
import moulserver.RawNode;
import moulserver.Results;
import moulserver.SdlBinary;
import prpobjects.Guid;
import shared.ByteArrayBytestream;
import shared.FileUtils;
import shared.IBytedeque;
import shared.IBytestream;
import shared.Str;
import shared.b;
import shared.m;
import shared.mystobj;
import shared.nested;
import shared.uncaughtexception;
import uru.context;

public abstract class Node {
    public static final int kNoteGeneric = 0;
    public static final int kNoteCCRPetition = 1;
    public static final int kNoteDevice = 2;
    public static final int kNoteInvite = 3;
    public static final int kNoteVisit = 4;
    public static final int kNoteUnVisit = 5;
    public static final int kNumNoteTypes = 6;
    public static final int kNone = 0;
    public static final int kJPEG = 1;
    public static final int kOwnerRead = 1;
    public static final int kOwnerWrite = 2;
    public static final int kGroupRead = 4;
    public static final int kGroupWrite = 8;
    public static final int kOtherRead = 16;
    public static final int kOtherWrite = 32;
    public static final int kDefaultPermissions = 23;
    RawNode n;
    private static Node root;

    public <T extends Node> T cast() {
        return (T)this;
    }

    public int getType() {
        return this.n.nodeType;
    }

    public void setType(int val) {
        this.n.nodeType = val;
    }

    public int getIdx() {
        return this.n.nodeIdx;
    }

    public void setIdx(int val) {
        this.n.nodeIdx = val;
    }

    public byte[] getAllBytes() {
        return this.n.getBytes();
    }

    public String toString() {
        return this.n.toString();
    }

    public static Node getRoot() {
        if (root == null) {
            Results results = Manager.manager.database.sqlquery("SELECT * FROM vault WHERE type=? LIMIT 1", 6);
            root = results.first() ? new VaultServerNode(new RawNode(results)) : new VaultServerNode();
        }
        return root;
    }

    public void addChild(Node child) {
        this.addChild(child.getIdx());
    }

    public void addChild(int childIdx) {
        Node.createLink(this.n.nodeIdx, childIdx, 0, (byte)0);
    }

    public static boolean createLink(int parentIdx, int childIdx, int ownerIdx, byte seen) {
        Results results = Manager.manager.database.sqlquery("SELECT * FROM ref_vault WHERE parent_idx=? AND child_idx=? LIMIT 1", parentIdx, childIdx);
        if (!results.first()) {
            Ref ref = new Ref(parentIdx, childIdx, ownerIdx, seen);
            m.msg("Adding link: " + Integer.toString(parentIdx));
            Manager.manager.vaultlistener.SignalNodeAdded(parentIdx, childIdx, ownerIdx);
            return true;
        }
        return false;
    }

    public static <T extends Node> T getNodeWithIndex(int idx) {
        Results results = Manager.manager.database.sqlquery("SELECT * FROM vault WHERE idx=?", idx);
        if (!results.first()) {
            m.throwUncaughtException("SQL query found not results!");
        }
        return Node.getNode(results);
    }

    public static <T extends Node> T getNode(Results r) {
        RawNode rawnode = new RawNode(r);
        return (T)Node.getNode2(rawnode);
    }

    public static <T extends Node> T getNode(byte[] rawdata) {
        RawNode rawnode = new RawNode(rawdata);
        return (T)Node.getNode2(rawnode);
    }

    public static Node getNode2(RawNode r) {
        try {
            int type = r.nodeType;
            switch (type) {
                case 6: {
                    return new VaultServerNode(r);
                }
                case 2: {
                    return new PlayerNode(r);
                }
                case 23: {
                    return new PlayerInfoNode(r);
                }
                case 33: {
                    return new AgeInfoNode(r);
                }
                case 28: {
                    return new AgeLinkNode(r);
                }
                case 29: {
                    return new ChronicleNode(r);
                }
                case 22: {
                    return new FolderNode(r);
                }
                case 27: {
                    return new SDLNode(r);
                }
                case 34: {
                    return new AgeInfoListNode(r);
                }
                case 30: {
                    return new PlayerInfoListNode(r);
                }
                case 26: {
                    return new TextNoteNode(r);
                }
                case 24: {
                    return new SystemNode(r);
                }
                case 3: {
                    return new AgeNode(r);
                }
                case 25: {
                    return new ImageNode(r);
                }
                case 35: {
                    return new MarkerListNode(r);
                }
            }
            throw new uncaughtexception("Oops; add this node to the list: " + Integer.toString(type));
        }
        catch (Exception e2) {
            throw new nested(e2);
        }
    }

    public static ArrayList<Ref> FindTreeRefs(int rootNodeIdx) {
        ArrayList<Ref> r = new ArrayList<Ref>();
        Node.FindTreeRefs(rootNodeIdx, r);
        return r;
    }

    private static void FindTreeRefs(int idx, ArrayList<Ref> r) {
        Results results = Manager.manager.database.sqlquery("SELECT * FROM ref_vault WHERE parent_idx=?", idx);
        ArrayList<Ref> children = results.castAsRefs();
        r.addAll(children);
        for (Ref child : children) {
            Node.FindTreeRefs(child.childIdx, r);
        }
    }

    public static ArrayList<Ref> getChildrenOfIdx(int idx) {
        Results results = Manager.manager.database.sqlquery("SELECT * FROM ref_vault WHERE parent_idx=?", idx);
        ArrayList<Ref> r = results.castAsRefs();
        return r;
    }

    public static ArrayList<Ref> getParentsOfIdx(int idx) {
        Results results = Manager.manager.database.sqlquery("SELECT * FROM ref_vault WHERE child_idx=?", idx);
        ArrayList<Ref> r = results.castAsRefs();
        return r;
    }

    public ArrayList<Ref> getChildrenRefs() {
        return Node.getChildrenOfIdx(this.getIdx());
    }

    public ArrayList<Node> getChildrenNodes() {
        ArrayList<Node> r = new ArrayList<Node>();
        for (Ref ref : this.getChildrenRefs()) {
            Object node = Node.getNodeWithIndex(ref.childIdx);
            r.add((Node)node);
        }
        return r;
    }

    public static void SaveNode(byte[] nodeData, AuthServer.VaultNodeChanged changenode, ConnectionState cs) {
        RawNode newnode = new RawNode(nodeData);
        Object oldnode = Node.getNodeWithIndex(changenode.nodeId);
        if (newnode.nodeIdx != null && newnode.nodeIdx != changenode.nodeId) {
            m.throwUncaughtException("unexpected");
        }
        newnode.nodeIdx = changenode.nodeId;
        long newfields = newnode.fields | ((Node)oldnode).n.fields;
        newnode.update(newfields, changenode.revisionId);
    }

    public static void test() {
        File f = new File("d:/DelmeDrizzleTest/vault/");
        for (File child : f.listFiles()) {
            if (!child.isFile()) continue;
            byte[] data = FileUtils.ReadFile(child);
            ByteArrayBytestream c = ByteArrayBytestream.createFromByteArray(data);
            RawNode n = new RawNode(c);
            if (n.nodeType == 27) {
                SDLNode n2 = (SDLNode)n.getInterface();
                byte[] sdldata = n2.sdlData();
                if (sdldata != null) {
                    ByteArrayBytestream c2 = ByteArrayBytestream.createFromByteArray(sdldata);
                    context c3 = context.createFromBytestream(c2);
                    c3.readversion = 6;
                    SdlBinary sdlBinary = new SdlBinary(c3);
                }
                boolean bl = false;
            }
            if (c.getBytesRemaining() != 0) {
                boolean bl = false;
            }
            m.msg(n.toString());
        }
    }

    public static class Ref
    extends mystobj {
        int parentIdx;
        int childIdx;
        int ownerIdx;
        byte seen;

        public Ref(IBytestream c) {
            this.parentIdx = c.readInt();
            this.childIdx = c.readInt();
            this.ownerIdx = c.readInt();
            this.seen = c.readByte();
        }

        public Ref() {
        }

        public Ref(Results r) {
            this.parentIdx = r.getInt("parent_idx");
            this.childIdx = r.getInt("child_idx");
            this.ownerIdx = r.getInt("owner_idx");
            this.seen = r.getByte("seen");
        }

        public Ref(int parentIdx, int childIdx, int ownerIdx, byte seen) {
            this.parentIdx = parentIdx;
            this.childIdx = childIdx;
            this.ownerIdx = ownerIdx;
            this.seen = seen;
            Manager.manager.database.sqlupdate("INSERT INTO ref_vault(parent_idx,child_idx,owner_idx,seen) VALUES(?,?,?,?)", parentIdx, childIdx, ownerIdx, seen);
        }

        @Override
        public void write(IBytedeque c) {
            c.writeInt(this.parentIdx);
            c.writeInt(this.childIdx);
            c.writeInt(this.ownerIdx);
            c.writeByte(this.seen);
        }

        public String dump() {
            return "Parent=" + Integer.toString(this.parentIdx) + " Child=" + Integer.toString(this.childIdx) + " Owner=" + Integer.toString(this.ownerIdx) + " Seen=" + Byte.toString(this.seen);
        }

        public String toString() {
            return this.dump();
        }

        public boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            if (o.getClass() != Ref.class) {
                return false;
            }
            Ref o2 = (Ref)o;
            if (o2.parentIdx != this.parentIdx) {
                return false;
            }
            return o2.childIdx == this.childIdx;
        }

        public int hashCode() {
            return this.parentIdx >> 16 + this.childIdx;
        }
    }

    public static class MarkerListNode
    extends Node {
        public String getGamename() {
            return this.n.text_1b.toString();
        }

        public void setGamename(String val) {
            this.n.text_1b = new Str(val);
        }

        public MarkerListNode() {
            this.n = new RawNode(35);
            this.n.insert();
        }

        public MarkerListNode(RawNode r) {
            this.n = r;
        }
    }

    public static class ImageNode
    extends Node {
        public static int typeJpeg = 1;

        @Override
        public int getType() {
            return this.n.int32_1;
        }

        @Override
        public void setType(int val) {
            this.n.int32_1 = val;
        }

        public String getTitle() {
            return this.n.string64_1 == null ? "" : this.n.string64_1.toString();
        }

        public void setTitle(String val) {
            this.n.string64_1 = new Str(val);
        }

        public byte[] getImageData() {
            return this.n.blob_1b.blob;
        }

        public void setImageData(byte[] val) {
            this.n.blob_1b.blob = val;
        }

        public ImageNode(String title, byte[] imageData) {
            this.n = new RawNode(25);
            this.setType(1);
            this.setTitle(title);
            this.setImageData(imageData);
            this.n.insert();
        }

        public ImageNode(RawNode r) {
            this.n = r;
        }
    }

    public static class VaultServerNode
    extends Node {
        public VaultServerNode() {
            this.n = new RawNode(6);
            this.n.insert();
        }

        public VaultServerNode(RawNode r) {
            this.n = r;
        }
    }

    public static class PlayerNode
    extends Node {
        public String getPlayerName() {
            return this.n.iString64_1.toString();
        }

        public String getAvatarShape() {
            return this.n.string64_1.toString();
        }

        public Guid getAccountGuid() {
            return this.n.uuid_1;
        }

        public int getExplorer() {
            return this.n.int32_2;
        }

        public PlayerNode(String playerName, String avatarShape, Guid accountGuid, int explorer) {
            this.n = new RawNode(2);
            this.n.iString64_1 = new Str(playerName);
            this.n.string64_1 = new Str(avatarShape);
            this.n.uuid_1 = accountGuid;
            this.n.int32_2 = explorer;
            this.n.insert();
        }

        public PlayerNode(RawNode r) {
            this.n = r;
        }

        public static PlayerNode findByName(String playerName) {
            Results results = Manager.manager.database.sqlquery("SELECT * FROM vault WHERE type=? AND lstr_1=? LIMIT 1", 2, playerName);
            if (results.first()) {
                return new PlayerNode(new RawNode(results));
            }
            return null;
        }

        public static Vector<PlayerNode> findAll() {
            Vector<PlayerNode> r = new Vector<PlayerNode>();
            Results results = Manager.manager.database.sqlquery("SELECT * FROM vault WHERE type=?", 2);
            boolean hasrow = results.first();
            while (hasrow) {
                r.add(new PlayerNode(new RawNode(results)));
                hasrow = results.next();
            }
            return r;
        }
    }

    public static class PlayerInfoNode
    extends Node {
        public String getPlayerName() {
            return this.n.iString64_1.toString();
        }

        public int getPlayerId() {
            return this.n.uint32_1;
        }

        public Guid getCurrentAgeGuid() {
            return this.n.uuid_1;
        }

        public String getCurrentAgeFilename() {
            return this.n.string64_1.toString();
        }

        public int getCurrentLinkStatus() {
            return this.n.int32_1;
        }

        public void setCurrentLinkStatus(int val) {
            this.n.int32_1 = val;
        }

        public PlayerInfoNode(int playerId) {
            PlayerNode player = (PlayerNode)PlayerNode.getNodeWithIndex(playerId);
            this.n = new RawNode(23);
            this.n.iString64_1 = new Str(player.getPlayerName());
            this.n.uint32_1 = playerId;
            this.n.uuid_1 = Guid.none2();
            this.n.string64_1 = new Str("");
            this.n.int32_1 = 0;
            this.n.insert();
        }

        public PlayerInfoNode(RawNode r) {
            this.n = r;
        }

        public static PlayerInfoNode getFromPlayerId(int playerId) {
            Results r = Manager.manager.database.sqlquery("SELECT * FROM vault WHERE type=? AND uint_1=? LIMIT 1", 23, playerId);
            if (!r.first()) {
                m.throwUncaughtException("PlayerInfo not found: " + Integer.toString(playerId));
            }
            return (PlayerInfoNode)Node.getNode(r);
        }
    }

    public static class Blob {
        byte[] blob;

        public Blob(IBytestream c) {
            int size = c.readInt();
            this.blob = c.readBytes(size);
        }

        public Blob(byte[] data) {
            this.blob = data;
        }

        public void write(IBytedeque c) {
            c.writeInt(this.blob.length);
            c.writeBytes(this.blob);
        }

        public String toString() {
            return b.BytesToString(this.blob);
        }

        public byte[] toBytes() {
            return this.blob;
        }
    }

    public static class SDLNode
    extends Node {
        public SDLNode(RawNode n) {
            this.n = n;
        }

        public SDLNode(String statedescname, Guid creatorGuid, int creatorIdx) {
            this.n = new RawNode(27);
            this.setStatedescName(statedescname);
            this.n.creatorUuid = creatorGuid;
            this.n.creatorIdx = creatorIdx;
            this.n.insert();
        }

        public Integer xu1() {
            return this.n.int32_1;
        }

        public String getStatedescName() {
            return this.n.string64_1.toString();
        }

        public void setStatedescName(String val) {
            this.n.string64_1 = new Str(val);
        }

        public byte[] getSdlBytecode() {
            return this.n.blob_1b.toBytes();
        }

        public void setSdlBytecode(byte[] val) {
            this.n.blob_1b = new Blob(val);
        }

        public byte[] sdlData() {
            if (this.n.blob_1b == null) {
                return null;
            }
            return this.n.blob_1b.blob;
        }
    }

    public static class PlayerInfoListNode
    extends Node {
        public int getFolderType() {
            return this.n.int32_1;
        }

        public void setFolderType(int val) {
            this.n.int32_1 = val;
        }

        public String getFolderName() {
            return this.n.string64_1.toString();
        }

        public void setFolderName(String val) {
            this.n.string64_1 = new Str(val);
        }

        public PlayerInfoListNode(int type) {
            this.n = new RawNode(30);
            this.setFolderType(type);
            this.n.insert();
        }

        public PlayerInfoListNode(RawNode r) {
            this.n = r;
        }
    }

    public static class FolderNode
    extends Node {
        public int getFolderType() {
            return this.n.int32_1;
        }

        public void setFolderType(int val) {
            this.n.int32_1 = val;
        }

        public String getFolderName() {
            return this.n.string64_1.toString();
        }

        public void setFolderName(String val) {
            this.n.string64_1 = new Str(val);
        }

        public FolderNode(int type) {
            this.n = new RawNode(22);
            this.setFolderType(type);
            this.n.insert();
        }

        public FolderNode(int type, String name) {
            this.n = new RawNode(22);
            this.setFolderType(type);
            this.setFolderName(name);
            this.n.insert();
        }

        public FolderNode(RawNode r) {
            this.n = r;
        }
    }

    public static class AgeInfoNode
    extends Node {
        public int getAgeId() {
            return this.n.uint32_1;
        }

        public void setAgeId(int val) {
            this.n.uint32_1 = val;
        }

        public int getAgeCzarId() {
            return this.n.uint32_2;
        }

        public void setAgeCzarId(int val) {
            this.n.uint32_2 = val;
        }

        public String getAgeFilename() {
            return this.n.string64_2.toString();
        }

        public void setAgeFilename(String val) {
            this.n.string64_2 = new Str(val);
        }

        public String getAgeInstancename() {
            return this.n.string64_3.toString();
        }

        public void setAgeInstancename(String val) {
            this.n.string64_3 = new Str(val);
        }

        public String getAgeUserDefinedName() {
            return this.n.string64_4.toString();
        }

        public void setAgeUserDefinedName(String val) {
            this.n.string64_4 = new Str(val);
        }

        public String getAgeDescription() {
            return this.n.text_1b.toString();
        }

        public void setAgeDescription(String val) {
            this.n.text_1b = new Str(val);
        }

        public Guid getAgeInstanceGuid() {
            return this.n.uuid_1;
        }

        public void setAgeInstanceGuid(Guid val) {
            this.n.uuid_1 = val;
        }

        public AgeInfoNode(AgeNode agenode, String ageFilename, String ageInstancename, String ageUserDefinedName, String ageDescription) {
            this.n = new RawNode(33);
            this.n.int32_3 = -1;
            this.n.int32_1 = 0;
            this.n.uint32_3 = 0;
            this.setAgeId(agenode.getIdx());
            this.setAgeCzarId(0);
            this.setAgeFilename(ageFilename);
            this.setAgeInstancename(ageInstancename);
            if (ageUserDefinedName != null) {
                this.setAgeUserDefinedName(ageUserDefinedName);
            }
            this.setAgeDescription(ageDescription);
            this.setAgeInstanceGuid(agenode.getAgeInstanceGuid());
            this.n.creatorIdx = agenode.getIdx();
            this.n.creatorUuid = agenode.n.creatorUuid;
            this.n.insert();
        }

        public AgeInfoNode(RawNode r) {
            this.n = r;
        }

        public static AgeInfoNode getFromAgeInstanceGuid(Guid guid) {
            Results r = Manager.manager.database.sqlquery("SELECT * FROM vault WHERE type=? AND uuid_1=? LIMIT 1", 33, guid.toBytes());
            if (!r.first()) {
                m.throwUncaughtException("AgeInfo not found: " + guid.toString());
            }
            return (AgeInfoNode)Node.getNode(r);
        }
    }

    public static class AgeNode
    extends Node {
        public Guid getAgeInstanceGuid() {
            return this.n.uuid_1;
        }

        public void setAgeInstanceGuid(Guid val) {
            this.n.uuid_1 = val;
        }

        public String getAgeFilename() {
            return this.n.string64_1.toString();
        }

        public void setAgeFilename(String val) {
            this.n.string64_1 = new Str(val);
        }

        public AgeNode(int playerId, Guid ageInstanceGuid, String ageFilename) {
            this.n = new RawNode(3);
            this.setAgeInstanceGuid(ageInstanceGuid);
            this.setAgeFilename(ageFilename);
            this.n.creatorUuid = ageInstanceGuid;
            this.n.insert();
        }

        public static AgeNode findFromGuid(Guid guid) {
            Results r = Manager.manager.database.sqlquery("SELECT * FROM vault WHERE type=? AND uuid_1=? LIMIT 1", 3, guid.toBytes());
            if (!r.first()) {
                m.throwUncaughtException("AgeNode not found: " + guid.toString());
            }
            return new AgeNode(new RawNode(r));
        }

        public AgeNode(RawNode r) {
            this.n = r;
        }
    }

    public static class ChronicleNode
    extends Node {
        public int getChronicleType() {
            return this.n.int32_1;
        }

        public void setChronicleType(int val) {
            this.n.int32_1 = val;
        }

        public String getChronicleName() {
            return this.n.string64_1.toString();
        }

        public void setChronicleName(String val) {
            this.n.string64_1 = new Str(val);
        }

        public String getChronicleValue() {
            return this.n.text_1b.toString();
        }

        public void setChronicleValue(String val) {
            this.n.text_1b = new Str(val);
        }

        public ChronicleNode(int type, String name, String value) {
            this.n = new RawNode(29);
            this.setChronicleType(type);
            this.setChronicleName(name);
            this.setChronicleValue(value);
            this.n.insert();
        }

        public ChronicleNode(RawNode r) {
            this.n = r;
        }
    }

    public static class AgeLinkNode
    extends Node {
        public byte[] getSpawnpointInfo() {
            return this.n.blob_1b.toBytes();
        }

        public void setSpawnpointInfo(byte[] val) {
            this.n.blob_1b = new Blob(val);
        }

        public AgeLinkNode(String spawnpointInfo) {
            this.n = new RawNode(28);
            if (spawnpointInfo != null) {
                this.setSpawnpointInfo(b.StringToBytes(spawnpointInfo));
            }
            this.n.insert();
        }

        public AgeLinkNode(RawNode r) {
            this.n = r;
        }
    }

    public static class AgeInfoListNode
    extends Node {
        public int getFolderType() {
            return this.n.int32_1;
        }

        public void setFolderType(int val) {
            this.n.int32_1 = val;
        }

        public AgeInfoListNode(int type) {
            this.n = new RawNode(34);
            this.setFolderType(type);
            this.n.insert();
        }

        public AgeInfoListNode(RawNode r) {
            this.n = r;
        }
    }

    public static class TextNoteNode
    extends Node {
        public Str getTitle2() {
            return this.n.string64_1;
        }

        public String getTitle() {
            return this.n.string64_1 == null ? "" : this.n.string64_1.toString();
        }

        public void setTitle(String val) {
            this.n.string64_1 = new Str(val);
        }

        public String getContents() {
            return this.n.text_1b.toString();
        }

        public void setContents(String val) {
            this.n.text_1b = new Str(val);
        }

        public TextNoteNode(String title, String contents) {
            this.n = new RawNode(26);
            this.setTitle(title);
            this.setContents(contents);
            this.n.insert();
        }

        public TextNoteNode(RawNode r) {
            this.n = r;
        }
    }

    public static class SystemNode
    extends Node {
        public SystemNode() {
            this.n = new RawNode(24);
            this.n.insert();
        }

        public SystemNode(RawNode r) {
            this.n = r;
        }

        public static SystemNode findIfExists() {
            Results results = Manager.manager.database.sqlquery("SELECT * FROM vault WHERE type=?", 24);
            if (!results.first()) {
                return null;
            }
            return (SystemNode)SystemNode.getNode(results);
        }
    }

    public static class FolderType
    extends Enums.Int {
        public static final int kUserDefinedNode = 0;
        public static final int kInboxFolder = 1;
        public static final int kBuddyListFolder = 2;
        public static final int kIgnoreListFolder = 3;
        public static final int kPeopleIKnowAboutFolder = 4;
        public static final int kVaultMgrGlobalDataFolder = 5;
        public static final int kChronicleFolder = 6;
        public static final int kAvatarOutfitFolder = 7;
        public static final int kAgeTypeJournalFolder = 8;
        public static final int kSubAgesFolder = 9;
        public static final int kDeviceInboxFolder = 10;
        public static final int kHoodMembersFolder = 11;
        public static final int kAllPlayersFolder = 12;
        public static final int kAgeMembersFolder = 13;
        public static final int kAgeJournalsFolder = 14;
        public static final int kAgeDevicesFolder = 15;
        public static final int kAgeInstanceSDLNode = 16;
        public static final int kAgeGlobalSDLNode = 17;
        public static final int kCanVisitFolder = 18;
        public static final int kAgeOwnersFolder = 19;
        public static final int kAllAgeGlobalSDLNodesFolder = 20;
        public static final int kPlayerInfoNode = 21;
        public static final int kPublicAgesFolder = 22;
        public static final int kAgesIOwnFolder = 23;
        public static final int kAgesICanVisitFolder = 24;
        public static final int kAvatarClosetFolder = 25;
        public static final int kAgeInfoNode = 26;
        public static final int kSystemNode = 27;
        public static final int kPlayerInviteFolder = 28;
        public static final int kCCRPlayersFolder = 29;
        public static final int kGlobalInboxFolder = 30;
        public static final int kChildAgesFolder = 31;
        public static final int kGameScoresFolder = 32;
        public static final int kLastStandardNode = 33;
    }

    public static class NodeType
    extends Enums.Int {
        public static final int kNodeInvalid = 0;
        public static final int kNodeVNodeMgrLow = 1;
        public static final int kNodePlayer = 2;
        public static final int kNodeAge = 3;
        public static final int kNodeGameServer = 4;
        public static final int kNodeAdmin = 5;
        public static final int kNodeVaultServer = 6;
        public static final int kNodeCCR = 7;
        public static final int kNodeVNodeMgrHigh = 21;
        public static final int kNodeFolder = 22;
        public static final int kNodePlayerInfo = 23;
        public static final int kNodeSystem = 24;
        public static final int kNodeImage = 25;
        public static final int kNodeTextNote = 26;
        public static final int kNodeSDL = 27;
        public static final int kNodeAgeLink = 28;
        public static final int kNodeChronicle = 29;
        public static final int kNodePlayerInfoList = 30;
        public static final int kNodeUNUSED = 31;
        public static final int kNodeMarker = 32;
        public static final int kNodeAgeInfo = 33;
        public static final int kNodeAgeInfoList = 34;
        public static final int kNodeMarkerList = 35;
    }
}

