/*
 * Decompiled with CFR 0.152.
 */
package SevenZip.Compression.Branch;

import SevenZip.ICompressFilter;

public class BCJ_x86_Decoder
implements ICompressFilter {
    int[] _prevMask = new int[1];
    int[] _prevPos = new int[1];
    static final boolean[] kMaskToAllowedStatus = new boolean[]{true, true, true, false, true, false, false, false};
    static final int[] kMaskToBitNumber = new int[]{0, 1, 2, 2, 3, 3, 3, 3};
    int _bufferPos;

    void x86Init() {
        this._prevMask[0] = 0;
        this._prevPos[0] = -5;
    }

    static final boolean Test86MSByte(int b2) {
        return b2 == 0 || b2 == 255;
    }

    static final int x86_Convert(byte[] buffer, int endPos, int nowPos, int[] prevMask, int[] prevPos, boolean encoding) {
        int bufferPos = 0;
        if (endPos < 5) {
            return 0;
        }
        if (nowPos - prevPos[0] > 5) {
            prevPos[0] = nowPos - 5;
        }
        int limit = endPos - 5;
        while (bufferPos <= limit) {
            int b2 = buffer[bufferPos] & 0xFF;
            if (b2 != 232 && b2 != 233) {
                ++bufferPos;
                continue;
            }
            int offset = nowPos + bufferPos - prevPos[0];
            prevPos[0] = nowPos + bufferPos;
            if (offset > 5) {
                prevMask[0] = 0;
            } else {
                for (int i = 0; i < offset; ++i) {
                    prevMask[0] = prevMask[0] & 0x77;
                    prevMask[0] = prevMask[0] << 1;
                }
            }
            b2 = buffer[bufferPos + 4] & 0xFF;
            if (BCJ_x86_Decoder.Test86MSByte(b2) && kMaskToAllowedStatus[prevMask[0] >> 1 & 7] && prevMask[0] >>> 1 < 16) {
                int dest;
                int src = b2 << 24 | (buffer[bufferPos + 3] & 0xFF) << 16 | (buffer[bufferPos + 2] & 0xFF) << 8 | buffer[bufferPos + 1] & 0xFF;
                while (true) {
                    int index;
                    dest = encoding ? nowPos + bufferPos + 5 + src : src - (nowPos + bufferPos + 5);
                    if (prevMask[0] == 0 || !BCJ_x86_Decoder.Test86MSByte(b2 = dest >> 24 - (index = kMaskToBitNumber[prevMask[0] >>> 1]) * 8 & 0xFF)) break;
                    src = dest ^ (1 << 32 - index * 8) - 1;
                }
                buffer[bufferPos + 4] = (byte)(~((dest >> 24 & 1) - 1));
                buffer[bufferPos + 3] = (byte)(dest >> 16);
                buffer[bufferPos + 2] = (byte)(dest >> 8);
                buffer[bufferPos + 1] = (byte)dest;
                bufferPos += 5;
                prevMask[0] = 0;
                continue;
            }
            ++bufferPos;
            prevMask[0] = prevMask[0] | 1;
            if (!BCJ_x86_Decoder.Test86MSByte(b2)) continue;
            prevMask[0] = prevMask[0] | 0x10;
        }
        return bufferPos;
    }

    public int SubFilter(byte[] data, int size) {
        return BCJ_x86_Decoder.x86_Convert(data, size, this._bufferPos, this._prevMask, this._prevPos, false);
    }

    public void SubInit() {
        this.x86Init();
    }

    @Override
    public int Init() {
        this._bufferPos = 0;
        this.SubInit();
        return 0;
    }

    @Override
    public int Filter(byte[] data, int size) {
        int processedSize = this.SubFilter(data, size);
        this._bufferPos += processedSize;
        return processedSize;
    }
}

