/*
   This file is part of TALER
   Copyright (C) 2025 Taler Systems SA

   TALER is free software; you can redistribute it and/or modify it under the
   terms of the GNU General Public License as published by the Free Software
   Foundation; either version 3, or (at your option) any later version.

   TALER is distributed in the hope that it will be useful, but WITHOUT ANY
   WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
   A PARTICULAR PURPOSE.  See the GNU General Public License for more details.

   You should have received a copy of the GNU General Public License along with
   TALER; see the file COPYING.  If not, see <http://www.gnu.org/licenses/>
 */
/**
 * @file backenddb/pg_increment_money_pots.h
 * @brief implementation of the increment_money_pots function for Postgres
 * @author Christian Grothoff
 */
#ifndef PG_INCREMENT_MONEY_POTS_H
#define PG_INCREMENT_MONEY_POTS_H

#include <taler/taler_util.h>
#include <taler/taler_json_lib.h>
#include "taler_merchantdb_plugin.h"

/**
 * Increment amounts in money pots.  If a money pot does not exist,
 * it is simply skipped (without causing an error!).
 *
 * @param cls closure
 * @param instance_id instance to update money pot for
 * @param money_pots_len length of the @a money_pots_ids
 *        and @a pot_increments arrays
 * @param money_pot_ids serial numbers of the pots to increment
 * @param pot_increments new amounts to add to the respective pot
 * @return database result code
 */
enum GNUNET_DB_QueryStatus
TMH_PG_increment_money_pots (
  void *cls,
  const char *instance_id,
  size_t money_pots_len,
  const uint64_t *money_pot_ids,
  const struct TALER_Amount *pot_increments);


#endif
