/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.placement.genetic2;

import com.sun.electric.tool.placement.PlacementFrame;
import com.sun.electric.tool.placement.genetic2.DeltaIndividual;
import com.sun.electric.tool.placement.genetic2.Reference;
import java.util.List;
import java.util.Random;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

public class SimulatedAnnealing {
    Annealer[] annealers;
    private Random rand;
    private long evolutionStepTime;
    double p;
    int numThreads;
    ExecutorService threadExecutor;
    Reference ref;

    SimulatedAnnealing(List<PlacementFrame.PlacementNode> nodesToPlace, List<PlacementFrame.PlacementNetwork> allNetworks, long evoStepTime, int numThreads, Reference ref) {
        this.ref = ref;
        this.rand = new Random();
        this.evolutionStepTime = evoStepTime;
        this.numThreads = numThreads;
        this.p = 0.0;
        Random[] rands = new Random[numThreads];
        this.annealers = new Annealer[numThreads];
        for (int i = 0; i < numThreads; ++i) {
            rands[i] = new Random();
            this.annealers[i] = new Annealer(rands[i]);
        }
        this.threadExecutor = Executors.newFixedThreadPool(numThreads);
    }

    public void setProgress(double p) {
        this.p = p;
        this.ref.setProgress(p);
        for (Annealer a : this.annealers) {
            a.setProgress(p);
        }
    }

    public void go() {
        Future[] futures = new Future[this.numThreads];
        long t = System.currentTimeMillis();
        block2: while (System.currentTimeMillis() - t < this.evolutionStepTime) {
            int i;
            for (i = 0; i < this.numThreads; ++i) {
                futures[i] = this.threadExecutor.submit(this.annealers[i]);
            }
            for (i = 0; i < this.numThreads; ++i) {
                try {
                    futures[i].get();
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            for (Annealer a : this.annealers) {
                double bDiff = a.dIndi.getBadness() - this.ref.getBadness();
                double r = Math.abs(this.rand.nextGaussian() * (0.9 - this.p));
                if (!(bDiff < 0.0) && !(r > bDiff * 0.005)) continue;
                this.ref.update(a.dIndi);
                continue block2;
            }
        }
    }

    class Annealer
    implements Runnable {
        DeltaIndividual dIndi;
        Random rand;
        double p;

        public Annealer(Random rand) {
            this.dIndi = new DeltaIndividual(SimulatedAnnealing.this.ref, rand);
            this.rand = rand;
        }

        public void setProgress(double p) {
            this.p = p;
            this.dIndi.setProgress(p);
        }

        @Override
        public void run() {
            this.dIndi.reboot(this.rand);
        }
    }
}

