/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.database.variable;

import com.sun.electric.database.EditingPreferences;
import com.sun.electric.database.ImmutableElectricObject;
import com.sun.electric.database.geometry.ERectangle;
import com.sun.electric.database.geometry.Poly;
import com.sun.electric.database.geometry.PolyBase;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.EDatabase;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.text.Name;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.Geometric;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.database.variable.AbstractTextDescriptor;
import com.sun.electric.database.variable.CodeExpression;
import com.sun.electric.database.variable.DisplayedText;
import com.sun.electric.database.variable.EditWindow0;
import com.sun.electric.database.variable.MutableTextDescriptor;
import com.sun.electric.database.variable.TextDescriptor;
import com.sun.electric.database.variable.VarContext;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.technology.TechPool;
import com.sun.electric.technology.technologies.Artwork;
import com.sun.electric.technology.technologies.Generic;
import com.sun.electric.technology.technologies.Schematics;
import com.sun.electric.tool.user.ActivityLogger;
import com.sun.electric.util.TextUtils;
import com.sun.electric.util.math.FixpRectangle;
import com.sun.electric.util.math.FixpTransform;
import com.sun.electric.util.math.MutableInteger;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class ElectricObject
implements Serializable {
    protected ElectricObject() {
    }

    public abstract ImmutableElectricObject getD();

    public abstract boolean isLinked();

    public <T> T getVarValue(Variable.Key key, Class<T> type) {
        return this.getVarValue(key, type, null);
    }

    public <T> T getVarValue(Variable.Key key, Class<T> type, T defaultValue) {
        Object value;
        Variable var = this.getVar(key);
        if (var != null && type.isInstance(value = var.getObject())) {
            return type.cast(value);
        }
        return defaultValue;
    }

    public Variable getVar(String name) {
        Variable.Key key = Variable.findKey(name);
        return key != null ? this.getVar(key) : null;
    }

    public Variable getVar(Variable.Key key) {
        this.checkExamine();
        return this.getD().getVar(key);
    }

    public Variable getParameterOrVariable(String name) {
        Variable.Key key = Variable.findKey(name);
        return key != null ? this.getParameterOrVariable(key) : null;
    }

    public Variable getParameterOrVariable(Variable.Key key) {
        this.checkExamine();
        return this.getD().getVar(key);
    }

    public TextDescriptor getTextDescriptor(Variable.Key varKey) {
        Variable var = this.getParameterOrVariable(varKey);
        if (var == null) {
            return null;
        }
        return var.getTextDescriptor();
    }

    public MutableTextDescriptor getMutableTextDescriptor(Variable.Key varKey) {
        TextDescriptor td = this.getTextDescriptor(varKey);
        if (td == null) {
            return null;
        }
        return new MutableTextDescriptor(td);
    }

    public CodeExpression.Code getCode(Variable.Key varKey) {
        Variable var = this.getParameterOrVariable(varKey);
        return var != null ? var.getCode() : CodeExpression.Code.NONE;
    }

    public boolean isParam(Variable.Key varKey) {
        return false;
    }

    public String getReadableName(Variable var) {
        String betterName;
        Object trueName = "";
        String name = var.getKey().getName();
        trueName = var.isAttribute() ? (this.isParam(var.getKey()) ? (String)trueName + "Parameter '" + name.substring(5) + "'" : (String)trueName + "Attribute '" + name.substring(5) + "'") : ((betterName = Variable.betterVariableName(name)) != null ? (String)trueName + betterName : (String)trueName + "Variable '" + name + "'");
        return trueName;
    }

    public String getFullDescription(Variable var) {
        String trueName = this.getReadableName(var);
        Object description = null;
        if (this instanceof Export) {
            description = trueName + " on " + this;
        } else if (this instanceof PortInst) {
            PortInst pi = (PortInst)this;
            description = trueName + " on " + pi.getPortProto() + " of " + pi.getNodeInst().describe(true);
        } else if (this instanceof ArcInst) {
            description = trueName + " on " + this;
        } else if (this instanceof NodeInst) {
            String varName;
            String betterName;
            NodeInst ni = (NodeInst)this;
            description = trueName + " on " + ni;
            if (ni.getProto() == Generic.tech().invisiblePinNode && (betterName = Variable.betterVariableName(varName = var.getKey().getName())) != null) {
                description = betterName;
            }
        } else if (this instanceof Cell) {
            description = trueName + " of " + this;
        }
        return description;
    }

    public void addDisplayableVariables(Rectangle2D rect, List<Poly> polys, EditWindow0 wnd, boolean multipleStrings, boolean showTempNames) {
        this.checkExamine();
        double cX = rect.getCenterX();
        double cY = rect.getCenterY();
        int startOfMyPolys = polys.size();
        Iterator<Variable> it = this.getParametersAndVariables();
        while (it.hasNext()) {
            Variable var = it.next();
            if (!var.isDisplay()) continue;
            this.addPolyList(polys, var, cX, cY, wnd, multipleStrings);
        }
        for (int i = startOfMyPolys; i < polys.size(); ++i) {
            Poly poly = polys.get(i);
            poly.setStyle(Poly.rotateType(poly.getStyle(), this));
        }
    }

    public Poly[] getDisplayableVariables(Rectangle2D rect, EditWindow0 wnd, boolean multipleStrings, boolean showTempNames) {
        ArrayList<Poly> polys = new ArrayList<Poly>();
        this.addDisplayableVariables(rect, polys, wnd, multipleStrings, showTempNames);
        return polys.toArray(Poly.NULL_ARRAY);
    }

    public Poly computeTextPoly(EditWindow0 wnd, Variable.Key varKey) {
        this.checkExamine();
        Poly poly = null;
        if (varKey != null) {
            LinkedList<Poly> polys = new LinkedList<Poly>();
            if (this instanceof Export) {
                Export pp = (Export)this;
                if (varKey == Export.EXPORT_NAME) {
                    poly = pp.getNamePoly();
                } else {
                    FixpRectangle bounds = pp.getNamePoly().getBounds2D();
                    pp.addPolyList(polys, pp.getVar(varKey), ((RectangularShape)bounds).getCenterX(), ((RectangularShape)bounds).getCenterY(), wnd, false);
                    if (!polys.isEmpty()) {
                        poly = polys.getFirst();
                    }
                }
            } else if (this instanceof PortInst) {
                PortInst pi = (PortInst)this;
                FixpRectangle bounds = pi.getPoly().getBounds2D();
                pi.addPolyList(polys, pi.getVar(varKey), ((RectangularShape)bounds).getCenterX(), ((RectangularShape)bounds).getCenterY(), wnd, false);
                if (!polys.isEmpty()) {
                    poly = polys.getFirst();
                }
            } else if (this instanceof Geometric) {
                Geometric geom = (Geometric)this;
                if (varKey == NodeInst.NODE_PROTO) {
                    if (!(geom instanceof NodeInst)) {
                        return null;
                    }
                    NodeInst ni = (NodeInst)this;
                    TextDescriptor td = ni.getTextDescriptor(NodeInst.NODE_PROTO);
                    Poly.Type style = td.getPos().getPolyType();
                    PolyBase.Point[] pointList = style == Poly.Type.TEXTBOX ? Poly.makePoints(ni.getBounds()) : new PolyBase.Point[]{Poly.fromLambda(ni.getTrueCenterX() + td.getXOff(), ni.getTrueCenterY() + td.getYOff())};
                    poly = new Poly(pointList);
                    poly.setStyle(style);
                    poly.setTextDescriptor(td);
                    poly.setString(ni.getProto().describe(false));
                } else {
                    String theText;
                    double x = geom.getTrueCenterX();
                    double y = geom.getTrueCenterY();
                    if (geom instanceof NodeInst) {
                        NodeInst ni = (NodeInst)geom;
                        Rectangle2D uBounds = ni.getUntransformedBounds();
                        x = uBounds.getCenterX();
                        y = uBounds.getCenterY();
                    }
                    TextDescriptor td = geom.getTextDescriptor(varKey);
                    Poly.Type style = td.getPos().getPolyType();
                    int varLength = 1;
                    Variable var = null;
                    if (varKey == NodeInst.NODE_NAME) {
                        theText = ((NodeInst)geom).getName();
                    } else if (varKey == ArcInst.ARC_NAME) {
                        theText = ((ArcInst)geom).getName();
                    } else {
                        VarContext context = null;
                        if (wnd != null) {
                            context = wnd.getVarContext();
                        }
                        var = geom.getParameterOrVariable(varKey);
                        theText = var.describe(0, context, this);
                        varLength = var.getLength();
                    }
                    this.addPolyListInternal(polys, var, x, y, wnd, false, varLength, style, td, varKey, theText);
                    if (!polys.isEmpty() && varLength == 1 && geom instanceof NodeInst) {
                        NodeInst ni = (NodeInst)geom;
                        polys.get(0).transform(ni.rotateOut());
                    }
                    if (!polys.isEmpty()) {
                        poly = polys.get(0);
                    }
                }
            } else if (this instanceof Cell) {
                Cell cell = (Cell)this;
                cell.addPolyList(polys, cell.getParameterOrVariable(varKey), 0.0, 0.0, wnd, false);
                if (!polys.isEmpty()) {
                    poly = polys.getFirst();
                }
            }
        }
        if (poly != null) {
            poly.setExactTextBounds(wnd, this);
        }
        return poly;
    }

    public Rectangle2D getTextBounds(EditWindow0 wnd) {
        ArcInst ai;
        Name name;
        FixpRectangle polyBound;
        Poly poly;
        FixpRectangle bounds = null;
        Iterator<Variable> vIt = this.getParametersAndVariables();
        while (vIt.hasNext()) {
            Variable var = vIt.next();
            if (!var.isDisplay() || (poly = this.computeTextPoly(wnd, var.getKey())) == null) continue;
            polyBound = poly.getBounds2D();
            if (bounds == null) {
                bounds = polyBound;
                continue;
            }
            Rectangle2D.union(bounds, polyBound, bounds);
        }
        if (this instanceof ArcInst && !(name = (ai = (ArcInst)this).getNameKey()).isTempname() && (poly = this.computeTextPoly(wnd, ArcInst.ARC_NAME)) != null) {
            polyBound = poly.getBounds2D();
            if (bounds == null) {
                bounds = polyBound;
            } else {
                Rectangle2D.union(bounds, polyBound, bounds);
            }
        }
        if (this instanceof NodeInst) {
            NodeInst ni = (NodeInst)this;
            name = ni.getNameKey();
            if (!name.isTempname() && (poly = this.computeTextPoly(wnd, NodeInst.NODE_NAME)) != null) {
                polyBound = poly.getBounds2D();
                if (bounds == null) {
                    bounds = polyBound;
                } else {
                    Rectangle2D.union(bounds, polyBound, bounds);
                }
            }
            Iterator<Export> it = ni.getExports();
            while (it.hasNext()) {
                Export pp = it.next();
                Poly poly2 = pp.computeTextPoly(wnd, Export.EXPORT_NAME);
                if (poly2 == null) continue;
                FixpRectangle polyBound2 = poly2.getBounds2D();
                if (bounds == null) {
                    bounds = polyBound2;
                    continue;
                }
                Rectangle2D.union(bounds, polyBound2, bounds);
            }
        }
        return bounds;
    }

    protected void addPolyList(List<Poly> polys, Variable var, double cX, double cY, EditWindow0 wnd, boolean multipleStrings) {
        int varLength = var.getLength();
        Poly.Type style = var.getPos().getPolyType();
        TextDescriptor td = var.getTextDescriptor();
        VarContext context = null;
        if (wnd != null) {
            context = wnd.getVarContext();
        }
        String firstLine = var.describe(0, context, this);
        this.addPolyListInternal(polys, var, cX, cY, wnd, multipleStrings, varLength, style, td, var.getKey(), firstLine);
    }

    private void addPolyListInternal(List<Poly> polys, Variable var, double cX, double cY, EditWindow0 wnd, boolean multipleStrings, int varLength, Poly.Type style, TextDescriptor td, Variable.Key varKey, String firstLine) {
        double lineOffX = 0.0;
        double lineOffY = 0.0;
        FixpTransform trans = null;
        double offX = td.getXOff();
        double offY = td.getYOff();
        if (this instanceof NodeInst && (offX != 0.0 || offY != 0.0)) {
            td = td.withOff(0.0, 0.0);
        }
        boolean headerString = false;
        double fontHeight = 1.0;
        double scale = 1.0;
        if (wnd != null) {
            fontHeight = td.getTrueSize(wnd);
            scale = wnd.getScale();
            fontHeight *= wnd.getGlobalTextScale();
        }
        if (varLength > 1) {
            double lineDist = fontHeight / scale;
            int rotQuadrant = td.getRotation().getIndex();
            switch (rotQuadrant) {
                case 0: {
                    lineOffY = lineDist;
                    break;
                }
                case 1: {
                    lineOffX = -lineDist;
                    break;
                }
                case 2: {
                    lineOffY = -lineDist;
                    break;
                }
                case 3: {
                    lineOffX = lineDist;
                }
            }
            Poly.Type rotStyle = style;
            if (this instanceof NodeInst && style != Poly.Type.TEXTCENT && style != Poly.Type.TEXTBOX) {
                NodeInst ni = (NodeInst)this;
                trans = ni.rotateIn();
                int origAngle = style.getTextAngle();
                if (ni.isMirroredAboutXAxis() != ni.isMirroredAboutYAxis() && (origAngle % 1800 == 0 || origAngle % 1800 == 1350)) {
                    origAngle += 1800;
                }
                int n = (origAngle - ni.getAngle() + 3600) % 3600;
            }
            if (td.getDispPart() == AbstractTextDescriptor.DispPos.NAMEVALUE) {
                headerString = true;
                ++varLength;
            }
            if (trans != null && multipleStrings) {
                Point2D.Double pt = new Point2D.Double(cX, cY);
                trans.transform(pt, pt);
                cX = ((Point2D)pt).getX();
                cY = ((Point2D)pt).getY();
            }
            if (multipleStrings) {
                if (rotStyle == Poly.Type.TEXTCENT || rotStyle == Poly.Type.TEXTBOX || rotStyle == Poly.Type.TEXTLEFT || rotStyle == Poly.Type.TEXTRIGHT) {
                    cX += lineOffX * (double)(varLength - 1) / 2.0;
                    cY += lineOffY * (double)(varLength - 1) / 2.0;
                }
                if (rotStyle == Poly.Type.TEXTBOT || rotStyle == Poly.Type.TEXTBOTLEFT || rotStyle == Poly.Type.TEXTBOTRIGHT) {
                    cX += lineOffX * (double)(varLength - 1);
                    cY += lineOffY * (double)(varLength - 1);
                }
            } else {
                if (rotStyle == Poly.Type.TEXTCENT || rotStyle == Poly.Type.TEXTBOX || rotStyle == Poly.Type.TEXTLEFT || rotStyle == Poly.Type.TEXTRIGHT) {
                    cX -= lineOffX * (double)(varLength - 1) / 2.0;
                    cY -= lineOffY * (double)(varLength - 1) / 2.0;
                }
                if (rotStyle == Poly.Type.TEXTTOP || rotStyle == Poly.Type.TEXTTOPLEFT || rotStyle == Poly.Type.TEXTTOPRIGHT) {
                    cX -= lineOffX * (double)(varLength - 1);
                    cY -= lineOffY * (double)(varLength - 1);
                }
                varLength = 1;
                headerString = false;
            }
        }
        VarContext context = null;
        if (wnd != null) {
            context = wnd.getVarContext();
        }
        for (int i = 0; i < varLength; ++i) {
            PolyBase.Point[] pointList;
            Object message = null;
            TextDescriptor entryTD = td;
            if (varLength > 1 && headerString) {
                if (i == 0) {
                    message = var.getTrueName() + "[" + (varLength - 1) + "]:";
                    entryTD = entryTD.withUnderline(true);
                } else {
                    message = i == 1 ? firstLine : var.describe(i - 1, context, this);
                }
            } else {
                Object object = message = i == 0 ? firstLine : var.describe(i, context, this);
            }
            if (style == Poly.Type.TEXTBOX && this instanceof Geometric) {
                Geometric geom = (Geometric)this;
                ERectangle bounds = geom.getBounds();
                pointList = Poly.makePoints(bounds);
            } else {
                pointList = new PolyBase.Point[]{Poly.fromLambda(cX + offX, cY + offY)};
                if (trans != null && multipleStrings) {
                    trans.transform(pointList[0], pointList[0]);
                }
            }
            Poly poly = new Poly(pointList);
            poly.setString((String)message);
            poly.setStyle(style);
            poly.setTextDescriptor(entryTD);
            poly.setDisplayedText(new DisplayedText(this, varKey));
            poly.setLayer(null);
            polys.add(poly);
            cX -= lineOffX;
            cY -= lineOffY;
        }
    }

    public Variable newVar(String name, Object value, EditingPreferences ep) {
        return this.newVar(Variable.newKey(name), value, ep);
    }

    public Variable newDisplayVar(Variable.Key key, Object value, EditingPreferences ep) {
        return this.newVar(key, value, ep, true);
    }

    public Variable newVar(Variable.Key key, Object value, EditingPreferences ep) {
        return this.newVar(key, value, ep, false);
    }

    private Variable newVar(Variable.Key key, Object value, EditingPreferences ep, boolean display) {
        AbstractTextDescriptor.TextType textType = this instanceof Cell ? AbstractTextDescriptor.TextType.CELL : (this instanceof Export ? AbstractTextDescriptor.TextType.EXPORT : (this instanceof NodeInst ? AbstractTextDescriptor.TextType.NODE : (this instanceof ArcInst ? AbstractTextDescriptor.TextType.ARC : AbstractTextDescriptor.TextType.ANNOTATION)));
        TextDescriptor td = ep.getTextDescriptor(textType, display);
        return this.newVar(key, value, td);
    }

    public Variable newVar(Variable.Key key, Object value, TextDescriptor td) {
        if (value == null) {
            return null;
        }
        if (this.isDeprecatedVariable(key)) {
            System.out.println("Deprecated variable " + key + " on " + this);
        }
        Variable var = null;
        try {
            var = Variable.newInst(key, value, td);
        }
        catch (IllegalArgumentException e) {
            ActivityLogger.logException(e);
            return null;
        }
        this.addVar(var);
        return this.getVar(key);
    }

    public abstract void addVar(Variable var1);

    public Variable updateVar(Variable.Key key, Object value, EditingPreferences ep) {
        Variable var = this.getVar(key);
        if (var == null) {
            return this.newVar(key, value, ep);
        }
        this.addVar(var.withObject(value));
        return this.getVar(key);
    }

    public Variable updateVarText(Variable.Key key, String text, EditingPreferences ep) {
        Variable var = this.getVar(key);
        if (var == null) {
            return this.newVar(key, (Object)text, ep);
        }
        this.addVar(var.withText(text));
        return this.getVar(key);
    }

    public Variable updateVarCode(Variable.Key key, CodeExpression.Code code) {
        Variable var = this.getVar(key);
        if (var == null) {
            return null;
        }
        this.addVar(var.withCode(code));
        return this.getVar(key);
    }

    public void setTextDescriptor(Variable.Key varKey, TextDescriptor td) {
        Variable var = this.getVar(varKey);
        if (var == null) {
            return;
        }
        td = td.withParam(false);
        this.addVar(var.withTextDescriptor(td));
    }

    public synchronized void setOff(Variable.Key varKey, double xd, double yd) {
        TextDescriptor td = this.getTextDescriptor(varKey);
        if (td != null) {
            this.setTextDescriptor(varKey, td.withOff(xd, yd));
        }
    }

    public void copyTextDescriptorFrom(ElectricObject other, Variable.Key varKey) {
        TextDescriptor td = other.getTextDescriptor(varKey);
        if (td == null) {
            return;
        }
        this.setTextDescriptor(varKey, td);
    }

    public Variable renameVar(String name, String newName) {
        return this.renameVar(Variable.findKey(name), newName);
    }

    public Variable renameVar(Variable.Key key, String newName) {
        Variable.Key newKey = Variable.newKey(newName);
        Variable var = this.getVar(newKey);
        if (var != null) {
            return null;
        }
        Variable oldvar = this.getVar(key);
        if (oldvar == null) {
            return null;
        }
        Variable newVar = this.newVar(newKey, oldvar.getObject(), oldvar.getTextDescriptor());
        if (newVar == null) {
            return null;
        }
        this.delVar(oldvar.getKey());
        return newVar;
    }

    public abstract void delVar(Variable.Key var1);

    public static String uniqueObjectName(String name, Cell cell, Class<?> cls, boolean leaveIndexValues, boolean fromRight) {
        String newName = name;
        int i = 0;
        while (!cell.isUniqueName(newName, cls, null)) {
            newName = ElectricObject.uniqueObjectNameLow(newName, cell, cls, null, null, leaveIndexValues, fromRight);
            if (i > 100) {
                System.out.println("Can't create unique object name in " + cell + " from original " + name + " attempted " + newName);
                return null;
            }
            ++i;
        }
        return newName;
    }

    public static String uniqueObjectName(String name, Cell cell, Class<?> cls, Set<String> already, Map<String, MutableInteger> nextPlainIndex, boolean leaveIndexValues, boolean fromRight) {
        String newName;
        String lcName = newName = name;
        int i = 0;
        while (already.contains(lcName)) {
            newName = ElectricObject.uniqueObjectNameLow(newName, cell, cls, already, nextPlainIndex, leaveIndexValues, fromRight);
            if (i > 100) {
                System.out.println("Can't create unique object name in " + cell + " from original " + name + " attempted " + newName);
                return null;
            }
            lcName = newName;
            ++i;
        }
        return newName;
    }

    /*
     * WARNING - void declaration
     */
    private static String uniqueObjectNameLow(String name, Cell cell, Class<?> cls, Set<String> already, Map<String, MutableInteger> nextPlainIndex, boolean leaveIndexValues, boolean fromRight) {
        int minusMinusPos;
        if (already != null ? !already.contains(name) : cell.isUniqueName(name, cls, null)) {
            return name;
        }
        int plusPlusPos = name.indexOf("++");
        if (plusPlusPos >= 0) {
            int numStart;
            for (numStart = plusPlusPos; numStart > 0 && TextUtils.isDigit(name.charAt(numStart - 1)); --numStart) {
            }
            if (numStart < plusPlusPos) {
                int nextIndex = TextUtils.atoi(name.substring(numStart)) + 1;
                while (true) {
                    String newname = name.substring(0, numStart) + nextIndex + name.substring(plusPlusPos);
                    if (already != null ? !already.contains(newname) : cell.isUniqueName(newname, cls, null)) {
                        return newname;
                    }
                    ++nextIndex;
                }
            }
        }
        if ((minusMinusPos = name.indexOf("--")) >= 0) {
            int numStart;
            for (numStart = minusMinusPos; numStart > 0 && TextUtils.isDigit(name.charAt(numStart - 1)); --numStart) {
            }
            if (numStart < minusMinusPos) {
                for (int nextIndex = TextUtils.atoi(name.substring(numStart)) - 1; nextIndex >= 0; --nextIndex) {
                    String newname = name.substring(0, numStart) + nextIndex + name.substring(minusMinusPos);
                    if (!(already != null ? !already.contains(newname) : cell.isUniqueName(newname, cls, null))) continue;
                    return newname;
                }
            }
        }
        ArrayList<ArrayName> names = new ArrayList<ArrayName>();
        boolean inBracket = false;
        int len = name.length();
        int startOfBase = 0;
        int startOfIndex = -1;
        for (int i = 0; i < len; ++i) {
            char ch = name.charAt(i);
            if (ch == '[') {
                if (startOfIndex < 0) {
                    startOfIndex = i;
                }
                inBracket = true;
            }
            if (ch == ']') {
                inBracket = false;
            }
            if ((ch != ',' || inBracket) && i != len - 1) continue;
            if (i == len - 1) {
                ++i;
            }
            ArrayName an = new ArrayName();
            int endOfBase = startOfIndex;
            if (endOfBase < 0) {
                endOfBase = i;
            }
            an.baseName = name.substring(startOfBase, endOfBase);
            if (startOfIndex >= 0) {
                an.indexPart = name.substring(startOfIndex, i);
            }
            names.add(an);
            startOfBase = i + 1;
            startOfIndex = -1;
        }
        char separateChar = '_';
        for (ArrayName an : names) {
            int startPos;
            boolean indexAdjusted = false;
            String index = an.indexPart;
            if (index != null && !leaveIndexValues) {
                int en;
                int st;
                ArrayList<Object> bracketedExpressions = new ArrayList<Object>();
                int pos = 0;
                while ((st = index.indexOf(91, pos)) >= 0 && (en = index.indexOf(93, st)) >= 0) {
                    BracketedExpression be = new BracketedExpression();
                    be.start = st;
                    be.end = en;
                    if (fromRight) {
                        bracketedExpressions.add(0, be);
                    } else {
                        bracketedExpressions.add(be);
                    }
                    pos = en;
                }
                int possibleEnd = 0;
                int possibleStart = -1;
                for (BracketedExpression bracketedExpression : bracketedExpressions) {
                    int startPos2 = bracketedExpression.start;
                    int endPos = bracketedExpression.end;
                    String expr = index.substring(startPos2 + 1, endPos);
                    if (expr.indexOf(44) >= 0) continue;
                    int i = expr.indexOf(58);
                    if (i >= 0) {
                        String newIndex;
                        String firstIndex = expr.substring(0, i);
                        String secondIndex = expr.substring(i + 1);
                        if (!TextUtils.isANumber(firstIndex) || !TextUtils.isANumber(secondIndex)) continue;
                        int startIndex = TextUtils.atoi(firstIndex);
                        int endIndex = TextUtils.atoi(secondIndex);
                        int spacing = Math.abs(endIndex - startIndex) + 1;
                        int nextIndex = 1;
                        while (true) {
                            newIndex = index.substring(0, startPos2) + "[" + (startIndex + spacing * nextIndex) + ":" + (endIndex + spacing * nextIndex) + index.substring(endPos);
                            String indexedName = an.baseName + newIndex;
                            boolean unique = already != null ? !already.contains(indexedName) : cell.isUniqueName(indexedName, cls, null);
                            if (unique) break;
                            ++nextIndex;
                        }
                        indexAdjusted = true;
                        an.indexPart = newIndex;
                        if (!indexAdjusted) continue;
                        break;
                    }
                    if (TextUtils.isANumber(expr)) {
                        String newIndex;
                        int nextIndex = TextUtils.atoi(expr) + 1;
                        while (true) {
                            newIndex = index.substring(0, startPos2) + "[" + nextIndex + index.substring(endPos);
                            String indexedName = an.baseName + newIndex;
                            boolean unique = already != null ? !already.contains(indexedName) : cell.isUniqueName(indexedName, cls, null);
                            if (unique) break;
                            ++nextIndex;
                        }
                        indexAdjusted = true;
                        an.indexPart = newIndex;
                        if (indexAdjusted) break;
                    }
                    if (possibleStart >= 0) continue;
                    possibleStart = startPos2;
                    possibleEnd = endPos;
                }
                if (!indexAdjusted && possibleStart >= 0) {
                    int i;
                    for (i = possibleEnd - 1; i > possibleStart && TextUtils.isDigit(index.charAt(i)); --i) {
                    }
                    int n = TextUtils.atoi(index.substring(i + 1)) + 1;
                    int startPos2 = i + 1;
                    if (index.charAt(startPos2 - 1) == separateChar) {
                        --startPos2;
                    }
                    while (true) {
                        void var24_37;
                        String newIndex = index.substring(0, startPos2) + separateChar + (int)var24_37 + index.substring(possibleEnd);
                        String indexedName = an.baseName + newIndex;
                        boolean unique = already != null ? !already.contains(indexedName) : cell.isUniqueName(indexedName, cls, null);
                        if (unique) {
                            indexAdjusted = true;
                            an.indexPart = newIndex;
                            break;
                        }
                        ++var24_37;
                    }
                }
            }
            if (indexAdjusted) continue;
            String base = an.baseName;
            int endPos = base.length();
            String localSepString = String.valueOf(separateChar);
            for (startPos = base.length(); startPos > 0 && TextUtils.isDigit(base.charAt(startPos - 1)); --startPos) {
            }
            int nextIndex = 1;
            if (startPos >= endPos) {
                if (startPos > 0 && base.charAt(startPos - 1) == separateChar) {
                    --startPos;
                }
            } else {
                nextIndex = TextUtils.atoi(base.substring(startPos)) + 1;
                localSepString = "";
            }
            String string = base.substring(0, startPos) + localSepString;
            Object suffix = base.substring(endPos);
            if (an.indexPart != null) {
                suffix = (String)suffix + an.indexPart;
            }
            if (nextPlainIndex != null) {
                String prefixAndSuffix = string + "0" + (String)suffix;
                MutableInteger nxt = nextPlainIndex.get(prefixAndSuffix);
                if (nxt == null) {
                    nxt = new MutableInteger(cell.getUniqueNameIndex(string, (String)suffix, cls, nextIndex));
                    nextPlainIndex.put(prefixAndSuffix, nxt);
                }
                nextIndex = nxt.intValue();
                nxt.increment();
            } else {
                nextIndex = cell.getUniqueNameIndex(string, (String)suffix, cls, nextIndex);
            }
            an.baseName = string + nextIndex + base.substring(endPos);
        }
        StringBuffer result = new StringBuffer();
        boolean first = true;
        for (ArrayName an : names) {
            if (first) {
                first = false;
            } else {
                result.append(",");
            }
            result.append(an.baseName);
            if (an.indexPart == null) continue;
            result.append(an.indexPart);
        }
        return result.toString();
    }

    public boolean isDeprecatedVariable(Variable.Key key) {
        char chr;
        String name = key.toString();
        if (name.length() == 0) {
            return true;
        }
        return name.length() == 1 && !Character.isLetter(chr = name.charAt(0));
    }

    public synchronized Iterator<Variable> getVariables() {
        return this.getD().getVariables();
    }

    public synchronized int getNumVariables() {
        return this.getD().getNumVariables();
    }

    public Iterator<Variable> getParametersAndVariables() {
        return this.getVariables();
    }

    public void checkChanging() {
        EDatabase database = this.getDatabase();
        if (database != null) {
            database.checkChanging();
        }
    }

    public void checkUndoing() {
        this.getDatabase().checkUndoing();
    }

    public void checkExamine() {
        EDatabase database = this.getDatabase();
        if (database != null) {
            database.checkExamine();
        }
    }

    public abstract EDatabase getDatabase();

    public TechPool getTechPool() {
        return this.getDatabase().getTechPool();
    }

    public Artwork getArtwork() {
        return this.getTechPool().getArtwork();
    }

    public Generic getGeneric() {
        return this.getTechPool().getGeneric();
    }

    public Schematics getSchematics() {
        return this.getTechPool().getSchematics();
    }

    protected boolean isDatabaseObject() {
        return true;
    }

    public Cell whichCell() {
        return null;
    }

    public void getInfo() {
        this.checkExamine();
        boolean firstvar = true;
        Iterator<Variable> it = this.getParametersAndVariables();
        while (it.hasNext()) {
            String par;
            Variable val = it.next();
            Variable.Key key = val.getKey();
            if (val == null) continue;
            if (firstvar) {
                System.out.println("Variables:");
            }
            firstvar = false;
            Object addr = val.getObject();
            String string = par = this.isParam(key) ? "(param)" : "";
            if (addr instanceof Object[]) {
                Object[] ary = (Object[])addr;
                System.out.print("   " + key.getName() + "(" + ary.length + ") = [");
                for (int i = 0; i < ary.length; ++i) {
                    if (i > 4) {
                        System.out.print("...");
                        break;
                    }
                    if (ary[i] instanceof String) {
                        System.out.print("\"");
                    }
                    System.out.print(ary[i]);
                    if (ary[i] instanceof String) {
                        System.out.print("\"");
                    }
                    if (i >= ary.length - 1) continue;
                    System.out.print(", ");
                }
                System.out.println("] " + par);
                continue;
            }
            System.out.println("   " + key.getName() + "= " + addr + " " + par);
        }
    }

    public String toString() {
        return this.getClass().getName();
    }

    protected void check() {
    }

    private static class ArrayName {
        private String baseName;
        private String indexPart;

        private ArrayName() {
        }
    }

    private static class BracketedExpression {
        int start;
        int end;

        private BracketedExpression() {
        }
    }
}

