import polib
import os

def prompt_filepath(prompt_text):
    while True:
        path = input(prompt_text).strip()
        if os.path.isfile(path):
            return path
        else:
            print("File not found. Please enter a valid path.")

def main():
    print("=== PO Translation Replacer ===")
    main_po_path = prompt_filepath("Enter path to the main .po file (with headers): ")
    replacements_po_path = prompt_filepath("Enter path to the replacements .po file (msgid/msgstr only): ")

    # Load PO files
    main_po = polib.pofile(main_po_path)
    replacements_po = polib.pofile(replacements_po_path)

    replaced_count = 0
    not_found = []

    for repl_entry in replacements_po:
        target_entry = main_po.find(repl_entry.msgid)
        if target_entry:
            if target_entry.msgstr != repl_entry.msgstr:
                target_entry.msgstr = repl_entry.msgstr
                replaced_count += 1
        else:
            not_found.append(repl_entry.msgid)

    output_path = "output.po"
    main_po.save(output_path)

    print(f"\n✅ Replacement complete. {replaced_count} entries updated.")
    if not_found:
        print(f"⚠️ {len(not_found)} msgids from replacements not found in main file.")
    print(f"📄 Updated file saved as: {output_path}")

if __name__ == "__main__":
    main()

