/*
 * Decompiled with CFR 0.152.
 */
package jedecma;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JPanel;
import jedecma.AnaDat;
import jedecma.CtrTextField;
import jedecma.Jedecma;
import jedecma.MyJComboBox;
import jedecma.MyJTextField;
import jedecma.MyJlabel;
import jedecma.MyLock;
import jedecma.ProfTable;
import jedecma.Uti1;
import jedecma.ZipCodeSrc;

public class AnaEdit
extends JDialog {
    private static final long serialVersionUID = 1L;
    private JPanel mainPan;
    private JPanel anaPan;
    private JPanel butPan;
    private JButton okBut;
    private JButton quitBut;
    private JButton profBut;
    private JButton postCodeBut;
    AnaDat ana;
    int ancode;
    private String lockCode;
    boolean busy;
    boolean abort;
    MyJTextField anbrtd;
    MyJTextField anname;
    MyJTextField anaddr;
    MyJTextField ancapc;
    MyJTextField anloca;
    MyJTextField anrprv;
    MyJTextField anbprv;
    MyJTextField anteln;
    MyJTextField antel2;
    MyJTextField annote;
    MyJTextField anfami;
    MyJTextField anmena;
    MyJTextField anchld;
    MyJTextField an1cha;
    MyJTextField anmenp;
    MyJTextField anheig;
    MyJTextField anweig;
    MyJTextField email;
    MyJComboBox ansuck;
    MyJComboBox anmens;
    JComboBox anprof;

    public AnaEdit() {
        this.setModal(true);
        this.busy = false;
        this.abort = false;
        this.lockCode = "";
    }

    public void edit(String name, String bdat, String bloc) {
        System.out.println("AnaEdit: edit(" + name + ", " + bdat + ", " + bloc + ")");
        AnaDat a = new AnaDat();
        int code = a.getAnaUid(Jedecma.dbmgr, name, bdat, bloc);
        if (code >= 0) {
            this.edit(code);
        }
    }

    public void edit(int code) {
        String nrs = String.valueOf(code);
        if (code < 0) {
            Uti1.error("AnaEdit: " + Jedecma.localMessagesBundle.getString("INVALID_PAT_CODE") + " " + nrs, false);
            this.abort = true;
            this.stop();
        }
        System.out.println("AnaEdit: edit(" + code + ")");
        this.ancode = code;
        this.ana = new AnaDat();
        String title = String.valueOf(Jedecma.localMessagesBundle.getString("PAT_EDIT")) + " " + nrs;
        if (this.ancode == 0) {
            title = Jedecma.localMessagesBundle.getString("PAT_NEW");
            this.lockCode = "";
        }
        this.setTitle(title);
        if (this.ancode > 0) {
            this.lockCode = "EDECAN." + nrs;
            int lockrv = MyLock.setLock(Jedecma.dbmgr, this.lockCode, Jedecma.user.userid, true);
            if (lockrv < 0) {
                Uti1.error("AnaEdit: " + Jedecma.localMessagesBundle.getString("CODE") + ": " + nrs + " " + Jedecma.localMessagesBundle.getString("IN_USE") + " (" + lockrv + ")", false);
                this.busy = true;
            } else {
                this.busy = false;
            }
            int rc = this.ana.readAna(Jedecma.dbmgr, this.ancode);
            if (rc != 0) {
                Uti1.error(String.valueOf(Jedecma.localMessagesBundle.getString("CODE")) + " " + String.valueOf(this.ancode) + " " + Jedecma.localMessagesBundle.getString("NOT_AVAILABLE"), false);
                this.abort = true;
                this.stop();
            }
        }
        if (!this.abort) {
            this.mainPan = new JPanel();
            this.mainPan.setLayout(new BoxLayout(this.mainPan, 1));
            this.anaPan = new JPanel();
            this.anaPan.setBorder(BorderFactory.createTitledBorder(""));
            this.mainPan.add(this.anaPan);
            GridBagLayout gb = new GridBagLayout();
            GridBagConstraints gbc = new GridBagConstraints();
            this.anaPan.setLayout(gb);
            MyJlabel lab = new MyJlabel(Jedecma.localMessagesBundle.getString("NAME"));
            Uti1.bldConst(gbc, 0, 0, 1, 1, 0, 0);
            gb.setConstraints(lab, gbc);
            this.anaPan.add(lab);
            this.anname = new MyJTextField(30, this.ana.anname, new float[0], 7);
            this.anname.addFocusListener(new CtrTextField());
            Uti1.bldConst(gbc, 1, 0, 4, 1, 1, 0);
            gb.setConstraints(this.anname, gbc);
            this.anaPan.add(this.anname);
            lab = new MyJlabel(Jedecma.localMessagesBundle.getString("BIRTH_DATE"));
            Uti1.bldConst(gbc, 5, 0, 1, 1, 0, 0);
            gb.setConstraints(lab, gbc);
            this.anaPan.add(lab);
            String ws = "";
            if (Uti1.date2String(this.ana.anbrtd).length() > 0) {
                ws = Uti1.date2String(this.ana.anbrtd);
            }
            this.anbrtd = new MyJTextField(10, ws, new float[0], 6);
            this.anbrtd.addFocusListener(new CtrTextField());
            Uti1.bldConst(gbc, 6, 0, 1, 1, 1, 0);
            gb.setConstraints(this.anbrtd, gbc);
            this.anaPan.add(this.anbrtd);
            lab = new MyJlabel(Jedecma.localMessagesBundle.getString("BIRTH_PROV"));
            Uti1.bldConst(gbc, 7, 0, 1, 1, 0, 0);
            gb.setConstraints(lab, gbc);
            this.anaPan.add(lab);
            this.anbprv = new MyJTextField(4, this.ana.anbprv, new float[0], 7);
            this.anbprv.addFocusListener(new CtrTextField());
            Uti1.bldConst(gbc, 8, 0, 1, 1, 1, 0);
            gb.setConstraints(this.anbprv, gbc);
            this.anaPan.add(this.anbprv);
            lab = new MyJlabel(Jedecma.localMessagesBundle.getString("ADDRESS"));
            Uti1.bldConst(gbc, 0, 1, 1, 1, 0, 0);
            gb.setConstraints(lab, gbc);
            this.anaPan.add(lab);
            this.anaddr = new MyJTextField(30, this.ana.anaddr, new float[0], 7);
            this.anaddr.addFocusListener(new CtrTextField());
            Uti1.bldConst(gbc, 1, 1, 4, 1, 1, 0);
            gb.setConstraints(this.anaddr, gbc);
            this.anaPan.add(this.anaddr);
            lab = new MyJlabel(Jedecma.localMessagesBundle.getString("POST_CODE"));
            Uti1.bldConst(gbc, 0, 2, 1, 1, 0, 0);
            gb.setConstraints(lab, gbc);
            this.anaPan.add(lab);
            this.ancapc = new MyJTextField(5, this.ana.ancapc, new float[]{0.0f, 99999.0f}, 1);
            this.ancapc.addFocusListener(new CtrTextField());
            Uti1.bldConst(gbc, 1, 2, 1, 1, 1, 0);
            gb.setConstraints(this.ancapc, gbc);
            this.anaPan.add(this.ancapc);
            lab = new MyJlabel(Jedecma.localMessagesBundle.getString("CITY"));
            Uti1.bldConst(gbc, 2, 2, 1, 1, 0, 0);
            gb.setConstraints(lab, gbc);
            this.anaPan.add(lab);
            this.anloca = new MyJTextField(30, this.ana.anloca, new float[0], 7);
            this.anloca.addFocusListener(new CtrTextField());
            Uti1.bldConst(gbc, 3, 2, 4, 1, 0, 0);
            gb.setConstraints(this.anloca, gbc);
            this.anaPan.add(this.anloca);
            this.postCodeBut = new JButton(Jedecma.localMessagesBundle.getString("SEARCH"));
            this.postCodeBut.setMnemonic(67);
            Uti1.bldConst(gbc, 7, 2, 1, 1, 0, 0);
            gb.setConstraints(this.postCodeBut, gbc);
            this.anaPan.add(this.postCodeBut);
            this.postCodeBut.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AnaEdit.this.postCodeBut.setEnabled(false);
                    ZipCodeSrc zcs = new ZipCodeSrc();
                    zcs.setSelProv(AnaEdit.this.anrprv.getText());
                    zcs.setSelCity(AnaEdit.this.anloca.getText());
                    zcs.start();
                    if (zcs.itemSelected()) {
                        AnaEdit.this.anrprv.setText(zcs.getSelProv());
                        AnaEdit.this.ancapc.setText(zcs.getSelCode());
                        AnaEdit.this.anloca.setText(zcs.getSelCity());
                    }
                    AnaEdit.this.postCodeBut.setEnabled(true);
                }
            });
            lab = new MyJlabel(Jedecma.localMessagesBundle.getString("PROV"));
            Uti1.bldConst(gbc, 8, 2, 1, 1, 0, 0);
            gb.setConstraints(lab, gbc);
            this.anaPan.add(lab);
            this.anrprv = new MyJTextField(4, this.ana.anrprv, new float[0], 7);
            this.anrprv.addFocusListener(new CtrTextField());
            Uti1.bldConst(gbc, 9, 2, 1, 1, 1, 0);
            gb.setConstraints(this.anrprv, gbc);
            this.anaPan.add(this.anrprv);
            lab = new MyJlabel(String.valueOf(Jedecma.localMessagesBundle.getString("TEL")) + " 1");
            Uti1.bldConst(gbc, 0, 3, 1, 1, 0, 0);
            gb.setConstraints(lab, gbc);
            this.anaPan.add(lab);
            this.anteln = new MyJTextField(15, this.ana.anteln, new float[0], 7);
            this.anteln.addFocusListener(new CtrTextField());
            Uti1.bldConst(gbc, 1, 3, 3, 1, 1, 0);
            gb.setConstraints(this.anteln, gbc);
            this.anaPan.add(this.anteln);
            lab = new MyJlabel(Jedecma.localMessagesBundle.getString("JOB"));
            Uti1.bldConst(gbc, 4, 3, 1, 1, 0, 0);
            gb.setConstraints(lab, gbc);
            this.anaPan.add(lab);
            String[] items = new String[]{Jedecma.localMessagesBundle.getString("CB_NA")};
            this.anprof = new JComboBox<String>(items);
            if (Jedecma.jComboBoxFont != null) {
                this.anprof.setFont(Jedecma.jComboBoxFont);
            }
            this.anprof.setKeySelectionManager(new myKeyManager());
            int rc = this.loadProf(this.anprof);
            this.setJCBValue(this.anprof, this.ana.anprof);
            Uti1.bldConst(gbc, 5, 3, 3, 1, 1, 0);
            gb.setConstraints(this.anprof, gbc);
            this.anaPan.add(this.anprof);
            lab = new MyJlabel(String.valueOf(Jedecma.localMessagesBundle.getString("TEL")) + " 2");
            Uti1.bldConst(gbc, 0, 4, 1, 1, 0, 0);
            gb.setConstraints(lab, gbc);
            this.anaPan.add(lab);
            this.antel2 = new MyJTextField(15, this.ana.antel2, new float[0], 7);
            this.antel2.addFocusListener(new CtrTextField());
            Uti1.bldConst(gbc, 1, 4, 3, 1, 1, 0);
            gb.setConstraints(this.antel2, gbc);
            this.anaPan.add(this.antel2);
            lab = new MyJlabel(Jedecma.localMessagesBundle.getString("NOTE"));
            Uti1.bldConst(gbc, 4, 4, 1, 1, 0, 0);
            gb.setConstraints(lab, gbc);
            this.anaPan.add(lab);
            this.annote = new MyJTextField(30, this.ana.annote, new float[0], 7);
            this.annote.addFocusListener(new CtrTextField());
            Uti1.bldConst(gbc, 5, 4, 4, 1, 0, 0);
            gb.setConstraints(this.annote, gbc);
            this.anaPan.add(this.annote);
            lab = new MyJlabel(Jedecma.localMessagesBundle.getString("EMAIL_ADDRESS"));
            Uti1.bldConst(gbc, 0, 5, 1, 1, 0, 0);
            gb.setConstraints(lab, gbc);
            this.anaPan.add(lab);
            this.email = new MyJTextField(50, this.ana.email, new float[0], 0);
            this.email.addFocusListener(new CtrTextField());
            Uti1.bldConst(gbc, 1, 5, 8, 1, 1, 0);
            gb.setConstraints(this.email, gbc);
            this.anaPan.add(this.email);
            lab = new MyJlabel(String.valueOf(Jedecma.localMessagesBundle.getString("WEIGHT")) + " kg.");
            Uti1.bldConst(gbc, 0, 6, 1, 1, 0, 0);
            gb.setConstraints(lab, gbc);
            this.anaPan.add(lab);
            this.anweig = new MyJTextField(5, String.valueOf(this.ana.anweig), new float[]{0.0f, 250.0f}, 2);
            this.anweig.addFocusListener(new CtrTextField());
            Uti1.bldConst(gbc, 1, 6, 1, 1, 1, 0);
            gb.setConstraints(this.anweig, gbc);
            this.anaPan.add(this.anweig);
            lab = new MyJlabel(String.valueOf(Jedecma.localMessagesBundle.getString("HEIGHT")) + " cm.");
            Uti1.bldConst(gbc, 2, 6, 1, 1, 0, 0);
            gb.setConstraints(lab, gbc);
            this.anaPan.add(lab);
            this.anheig = new MyJTextField(5, String.valueOf(this.ana.anheig), new float[]{0.0f, 220.0f}, 2);
            this.anheig.addFocusListener(new CtrTextField());
            Uti1.bldConst(gbc, 3, 6, 1, 1, 1, 0);
            gb.setConstraints(this.anheig, gbc);
            this.anaPan.add(this.anheig);
            lab = new MyJlabel(Jedecma.localMessagesBundle.getString("FAM_PATHOL"));
            Uti1.bldConst(gbc, 4, 6, 1, 1, 0, 0);
            gb.setConstraints(lab, gbc);
            this.anaPan.add(lab);
            this.anfami = new MyJTextField(20, this.ana.anfami, new float[0], 7);
            this.anfami.addFocusListener(new CtrTextField());
            Uti1.bldConst(gbc, 5, 6, 3, 1, 1, 0);
            gb.setConstraints(this.anfami, gbc);
            this.anaPan.add(this.anfami);
            lab = new MyJlabel(Jedecma.localMessagesBundle.getString("NR_CHILDREN"));
            Uti1.bldConst(gbc, 0, 7, 1, 1, 0, 0);
            gb.setConstraints(lab, gbc);
            this.anaPan.add(lab);
            this.anchld = new MyJTextField(5, String.valueOf(this.ana.anchld), new float[]{0.0f, 20.0f}, 1);
            this.anchld.addFocusListener(new CtrTextField());
            Uti1.bldConst(gbc, 1, 7, 1, 1, 1, 0);
            gb.setConstraints(this.anchld, gbc);
            this.anaPan.add(this.anchld);
            lab = new MyJlabel(Jedecma.localMessagesBundle.getString("AGE_1ST_CHILDBIRTH"));
            Uti1.bldConst(gbc, 2, 7, 1, 1, 0, 0);
            gb.setConstraints(lab, gbc);
            this.anaPan.add(lab);
            this.an1cha = new MyJTextField(5, String.valueOf(this.ana.an1cha), new float[]{0.0f, 99.0f}, 1);
            this.an1cha.addFocusListener(new CtrTextField());
            Uti1.bldConst(gbc, 3, 7, 1, 1, 1, 0);
            gb.setConstraints(this.an1cha, gbc);
            this.anaPan.add(this.an1cha);
            lab = new MyJlabel(Jedecma.localMessagesBundle.getString("SUCKLE"));
            Uti1.bldConst(gbc, 4, 7, 1, 1, 0, 0);
            gb.setConstraints(lab, gbc);
            this.anaPan.add(lab);
            this.ansuck = new MyJComboBox(new String[]{"0=" + Jedecma.localMessagesBundle.getString("CB_NA"), "1=" + Jedecma.localMessagesBundle.getString("CB_NO"), "2=" + Jedecma.localMessagesBundle.getString("CB_YES")}, String.valueOf(this.ana.ansuck));
            Uti1.bldConst(gbc, 5, 7, 1, 1, 1, 0);
            gb.setConstraints(this.ansuck, gbc);
            this.anaPan.add(this.ansuck);
            lab = new MyJlabel(Jedecma.localMessagesBundle.getString("AGE_MENARCHE"));
            Uti1.bldConst(gbc, 0, 8, 1, 1, 0, 0);
            gb.setConstraints(lab, gbc);
            this.anaPan.add(lab);
            this.anmena = new MyJTextField(5, String.valueOf(this.ana.anmena), new float[]{0.0f, 99.0f}, 1);
            this.anmena.addFocusListener(new CtrTextField());
            Uti1.bldConst(gbc, 1, 8, 1, 1, 1, 0);
            gb.setConstraints(this.anmena, gbc);
            this.anaPan.add(this.anmena);
            lab = new MyJlabel(Jedecma.localMessagesBundle.getString("MENSTR"));
            Uti1.bldConst(gbc, 2, 8, 1, 1, 0, 0);
            gb.setConstraints(lab, gbc);
            this.anaPan.add(lab);
            this.anmens = new MyJComboBox(new String[]{"0=" + Jedecma.localMessagesBundle.getString("CB_NA"), "1=" + Jedecma.localMessagesBundle.getString("MENSTR_REG"), "2=" + Jedecma.localMessagesBundle.getString("MENSTR_IRR")}, String.valueOf(this.ana.anmens));
            Uti1.bldConst(gbc, 3, 8, 1, 1, 1, 0);
            gb.setConstraints(this.anmens, gbc);
            this.anaPan.add(this.anmens);
            lab = new MyJlabel(Jedecma.localMessagesBundle.getString("MENOP"));
            Uti1.bldConst(gbc, 4, 8, 1, 1, 0, 0);
            gb.setConstraints(lab, gbc);
            this.anaPan.add(lab);
            this.anmenp = new MyJTextField(5, String.valueOf(this.ana.anmenp), new float[]{0.0f, 99.0f}, 1);
            this.anmenp.addFocusListener(new CtrTextField());
            Uti1.bldConst(gbc, 5, 8, 1, 1, 1, 0);
            gb.setConstraints(this.anmenp, gbc);
            this.anaPan.add(this.anmenp);
            this.butPan = new JPanel();
            this.mainPan.add(this.butPan);
            this.getContentPane().add(this.mainPan);
            this.okBut = new JButton("Ok");
            this.okBut.setMnemonic(79);
            this.butPan.add(this.okBut);
            this.okBut.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int rc = AnaEdit.this.saveData();
                    if (rc == 0) {
                        AnaEdit.this.stop();
                    }
                }
            });
            this.okBut.setEnabled(!this.busy);
            if (!Jedecma.ak.isEnableWrite()) {
                this.okBut.setEnabled(false);
            }
            this.quitBut = new JButton(Jedecma.localMessagesBundle.getString("CANCEL"));
            this.quitBut.setMnemonic(65);
            this.butPan.add(this.quitBut);
            this.quitBut.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AnaEdit.this.stop();
                }
            });
            this.profBut = new JButton(Jedecma.localMessagesBundle.getString("JOB"));
            this.profBut.setMnemonic(80);
            this.butPan.add(this.profBut);
            this.profBut.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    new ProfTable();
                    int rc = AnaEdit.this.loadProf(AnaEdit.this.anprof);
                }
            });
            this.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    if (AnaEdit.this.lockCode.length() > 0) {
                        MyLock.delLock(Jedecma.dbmgr, AnaEdit.this.lockCode, Jedecma.user.userid);
                    }
                }
            });
            this.pack();
            this.setVisible(true);
        }
    }

    public void stop() {
        if (this.lockCode.length() > 0) {
            MyLock.delLock(Jedecma.dbmgr, this.lockCode, Jedecma.user.userid);
        }
        this.dispose();
    }

    public int saveData() {
        int rc = 0;
        this.ana.anbrtd = Uti1.string2Date(this.anbrtd.getText());
        this.ana.anname = this.ana.anname.length() == 0 ? Uti1.uniqSpaces(this.anname.getText()) : this.anname.getText();
        this.ana.anaddr = this.anaddr.getText();
        this.ana.ancapc = this.ancapc.getText();
        this.ana.anloca = this.anloca.getText();
        this.ana.anrprv = this.anrprv.getText();
        this.ana.anbprv = this.anbprv.getText();
        this.ana.anteln = this.anteln.getText();
        this.ana.antel2 = this.antel2.getText();
        this.ana.email = this.email.getText();
        this.ana.anprof = this.getJCBValue(this.anprof);
        this.ana.annote = this.annote.getText();
        this.ana.anfami = this.anfami.getText();
        this.ana.anmena = Integer.parseInt(this.anmena.getText());
        this.ana.anchld = Integer.parseInt(this.anchld.getText());
        this.ana.an1cha = Integer.parseInt(this.an1cha.getText());
        this.ana.ansuck = Integer.parseInt(this.ansuck.getInpValue());
        this.ana.anmens = Integer.parseInt(this.anmens.getInpValue());
        this.ana.anmenp = Integer.parseInt(this.anmenp.getText());
        this.ana.anheig = Float.parseFloat(this.anheig.getText());
        this.ana.anweig = Float.parseFloat(this.anweig.getText());
        this.ana.writeAna(Jedecma.dbmgr, this.ancode);
        this.ancode = this.ana.ancode;
        return rc;
    }

    public int loadProf(JComboBox cb) {
        int rv = 0;
        int pos = 1;
        while (pos < cb.getItemCount()) {
            cb.removeItemAt(pos);
            ++pos;
        }
        String profcod = "";
        String profdes = "";
        ResultSet rSet = Jedecma.dbmgr.executeQuery("SELECT PROFCOD, PROFDES FROM TBLPROF ORDER BY PROFCOD");
        try {
            while (rSet.next()) {
                profcod = rSet.getString("PROFCOD");
                profdes = rSet.getString("PROFDES");
                cb.addItem(String.valueOf(profcod) + "=" + profdes);
            }
        }
        catch (SQLException ex) {
            System.err.println(ex);
            rv = 1;
        }
        return rv;
    }

    public String getJCBValue(JComboBox jcb) {
        int b;
        int si = jcb.getSelectedIndex();
        String ws = "";
        if (si >= 0 && si <= jcb.getItemCount() && (b = (ws = (String)jcb.getItemAt(si)).indexOf("=")) > -1) {
            ws = ws.substring(0, b);
        }
        return ws;
    }

    public void setJCBValue(JComboBox cb, String value) {
        int vl = value.length();
        if (vl > 0) {
            int pos = 1;
            while (pos < cb.getItemCount()) {
                String iItem = (String)cb.getItemAt(pos);
                String s = iItem.substring(0, vl);
                if (value.equals(s)) {
                    cb.setSelectedIndex(pos);
                    break;
                }
                ++pos;
            }
        }
    }

    class myKeyManager
    implements JComboBox.KeySelectionManager {
        String keys = null;
        int curSelected = 0;

        myKeyManager() {
        }

        public int selectionForKey(char aKey, ComboBoxModel aModel) {
            int iCount = aModel.getSize();
            int iPatternLen = 0;
            int iSelected = 0;
            String sItem = null;
            if (Character.getNumericValue(aKey) == -1) {
                this.keys = null;
            } else {
                this.keys = this.keys != null ? String.valueOf(this.keys) + new Character(aKey).toString() : new Character(aKey).toString();
                if (this.keys != null) {
                    iPatternLen = this.keys.length();
                    this.keys = this.keys.toUpperCase();
                }
                int pos = 0;
                while (pos < iCount) {
                    sItem = (String)aModel.getElementAt(pos);
                    if (sItem.length() >= iPatternLen) {
                        if (sItem.substring(0, iPatternLen).equals(this.keys)) {
                            this.curSelected = iSelected = pos;
                            break;
                        }
                    } else {
                        iSelected = this.curSelected;
                    }
                    ++pos;
                }
            }
            return this.curSelected;
        }
    }
}

