.TH groff_pdfnote @MAN7EXT@ "@MDATE@" "groff-pdfmark @VERSION@"
.
.SH Name
groff_pdfnote \- insert virtual "sticky notes" in groff PDF documents
.
.\" ====================================================================
.\" Legal Terms
.\" ====================================================================
.\"
.\" Copyright (C) 2024, Free Software Foundation, Inc.
.\"
.\" This file is part of groff-pdfmark, an independently maintained
.\" add-on for the GNU roff type-setting system.
.\"
.\" Permission is granted to copy, distribute and/or modify this
.\" document under the terms of the GNU Free Documentation License,
.\" Version 1.3 or any later version published by the Free Software
.\" Foundation; with no Invariant Sections, no Front-Cover Texts,
.\" and no Back-Cover Texts.
.\"
.\" A copy of the Free Documentation License is included as a file
.\" called fdl-v1.3.txt, in the fdl directory of the groff-pdfmark
.\" source package, whence it is programmatically marked up, to be
.\" processed by groff -m pdfmark, for inclusion as an appendix to
.\" the pdfmark.pdf document.
.\"
.\" ====================================================================
.
.\" Save and disable compatibility mode (e.g., for Solaris 10/11).
.nr _? \n(.C
.do rnn _? *groff_pdfnote_7_man_C
.cp 0
.
.\" ====================================================================
.\" Local Macro Definitions
.\" ====================================================================
.
.\" @IMPORT_LOCAL_FALLBACK_MACROS@
.
.ig
.\" ====================================================================
.SH Synopsis
.\" ====================================================================
..
.
.
.\" ====================================================================
.SH Description
.\" ====================================================================
.
This manual page serves as a formal reference
for the use of the
.B \%pdfnote
macro,
as implemented for the
.MR groff @MAN7EXT@
document processing language.
.
This macro
is provided by the
.MR groff_pdfmark @MAN7EXT@
package;
it offers a mechanism whereby an author may insert
.IR "editorial annotations" ,
in the form of virtual \(lqsticky notes\(rq,
into any PDF document which is created by
.MR groff @MAN1EXT@ .
.
.
.\" ====================================================================
.SH Usage
.\" ====================================================================
.
The
.B \%pdfnote
macro is made available for use within any
.MR groff @MAN7EXT@
input data stream into which the
.MR groff_pdfmark @MAN7EXT@
macro package is incorporated,
either by inclusion from the
.MR groff @MAN1EXT@ ,
or the
.MR pdfroff @MAN1EXT@
command line:
.RS 3n
.sp -0.25v
.SY groff\ \-m\|pdfmark
.RI \|[ option \|.\|.\|.\&]\ [ file \|.\|.\|.\&]
.SY pdfroff\ \-m\|pdfmark
.RI \|[ option \|.\|.\|.\&]\ [ file \|.\|.\|.\&]
.YS
.RE
.sp -0.25v
.P
or by inclusion within the
.MR groff @MAN7EXT@
source data itself:
.RS 3n
.sp -0.25v
.SY .\^mso\ pdfmark\^.\^tmac
.YS
.RE
.
.P
Once the
.MR groff_pdfmark @MAN7EXT@
macro package has been loaded,
virtual \(lqsticky note\(rq annotations may be inserted into any
.MR groff @MAN1EXT@
PDF output data stream\|\(em\|or
.MR pdfroff @MAN1EXT@
output stream\|\(em\|by invocation of a macro call of the form:
.RS 3n
.SY .\^pdfnote
.RB [ \-T
.RI \(dq title\ text
.RI .\|.\|.\&\(dq
.BR \(rs [#
.IR comment \ .\|.\|.\&]
.SY \&
.RB [[ \-PD
.RI < paragraph-spacing >]
.BR \(rs [#
.IR comment \ .\|.\|.\&]]
.SY \&
.RB [[ -C
.RI < red-value >\ < green-value >\ < blue-value >]
.BR \(rs [#
.IR comment \ .\|.\|.\&]]
.SY \&
.RB [[ \-O ]\ [ -I
.RI < icon-style >]
.RB [ \-\- ]
.BR \(rs [#
.IR comment \ .\|.\|.\&]]
.SY \&
.RI [ "first line of body text"
.RI .\|.\|.\&
.BR \(rs [#
.IR comment \ .\|.\|.\&]]
.SY \&
.RI [ "internal line(s) of body text" \ .\|.\|.\&
.BR \(rs [#
.IR comment \ .\|.\|.\&]]
.SY \&
.RI [.\|.\|.\&
.BR \(rs [#
.IR comment \ .\|.\|.\&]]
.SY \&
.IR "last line of body text" \ .\|.\|.\&
.YS
.RE
.
.P
with options:
.RS 3n
.ll -3n
.TP 3.75n
.BR \-T \0\(dq\c
.IR title\ text \ .\|.\|.\&\(dq
Set
.RI \%\(lq title\ text \ .\|.\|.\&\(rq
within the title bar of the PDF annotation,
when it is presented in its
.I open
state.
Note that
.RI \%\(lq title\ text \ .\|.\|.\&\(rq
.I must
be specified as a single argument to the
.B \%pdfnote
macro,
and thus,
.I must
be quoted as such,
(by enclosing it between ASCII double quotation mark tokens),
.I if
it comprises multiple lexical words,
separated by white space.
.
.TP 3.75n
.B \-O
Register a preference that the associated
.B \%pdfnote
should initially be presented in its
.I \%open
state,
when the containing PDF document is opened.
(Note that there is no guarantee that
this preference will actually be honoured,
by whichever PDF viewer has been chosen to open the document).
.
.TP 3.75n
.BR \%\-I \0\c
.RI < icon-style >
Specify the style of icon,
which is to be associated with a particular
.BR \%pdfnote ;
this should be identified by the
.RI \%< icon-style >
argument,
which
.I must
be specified as any
.I one
of the icon style names supported
by the PDF viewer which is in use,
(noting that
.I all
PDF viewers are
.I required
to support each of the styles:
.IR \%Note ,
.IR \%Comment ,
.IR \%Help ,
.IR \%Insert ,
.IR \%Key ,
.IR \%NewParagraph ,
and
.IR \%Paragraph ,
with
.I \%Note
representing the default icon style).
.
.TP 3.75n
.BR \%\-C \0\c
.RI < red-value >\ < green-value >\ <blue-value >
Specifies the desired background colour for
the virtual \(lqsticky note\(rq panel,
and its associated icon.
.
The desired colour is specified as a triplet of numerical values,
in the RGB colour space,
with each of the
.RI \%< red-value >,
.RI \%< green-value >,
and
.RI \%< blue-value >
arguments being expressed as a
.I positive
decimal value in the range 0.0 to 1.0;
(subject to the limitation that
the capability for interpretation of such RGB colour specifications
may not be fully supported by
.I \%all
PDF viewer applications).
.
.TP 3.75n
.BR \%\-PD \0\c
.RI < paragraph-spacing >
Specifies the number of blank lines,
(a
.I positive whole number,
with the default being
.IR \%zero ),
which should be used to separate paragraphs,
when a new paragraph mark,
(see section on
.SR 1 Control\ Settings ),
is inserted into the body of a
.BR \%pdfnote .
.
.TP 3.75n
.B \-\-
Suppress interpretation of any of the further macro arguments,
which have been passed in the current
.B \%.\^pdfnote
call,
as a potential macro option;
this can be useful when the argument which follows
has a form resembling an option,
but is intended to be be included within
the body text of the
.BR \%pdfnote .
.ll +3n
.RE
.
.P
Notice that each individual
.B \%pdfnote
.I must
be represented,
within the
.MR groff @MAN7EXT@
document source data stream,
as a
.I single
macro call.
Since it will often be inconvenient to express the
.I entire
content of many
.BR \%pdfnote s,
on just one
.I physical
input line for each,
a single
.I logical
input line may be constructed,
by ending each
.I physical
input line,
from the initiating
.B \%.\^pdfmark
call line,
until,
but
.IR excluding ,
the last line of the
.B \%pdfnote
body,
with an escaped newline\|\(em\|or with
.MR groff @MAN7EXT@ 's
\(lq\fC\(rs#\fP\(rq escape sequence,
and an optional trailing comment.
.
.
.\" ====================================================================
.SH Control Settings
.\" ====================================================================
.
In addition to the option arguments,
as described in the preceding
.SR 1 Usage
section,
the
.B \%pdfnote
macro interprets the following control registers,
to determine the placement,
and the layout,
of each
.B \%pdfnote
annotation,
which is inserted into the PDF
document output stream:
.
.RS 3n
.ll -3n
.sp -0.125v
.TP 3.75n
.B \%PDFNOTE\^.\h'0.05n'OFFSET
This is defined as a
.MR groff @MAN7EXT@
string variable;
its value represents an expression,
which,
when evaluated,
computes the offset,
in device units,
relative to the last text output position
on the current page,
of the \%left-hand boundary of the page region
in which the annotation should be placed.
Defined,
by default,
as:
.RS 6.25n
.sp 0.15v
.EX
\&.ds PDFNOTE.OFFSET "\(rs\(rsn[.k]+\(rs\(rsn[.o]+\(rs\(rsn[.in]\(rs"
.EE
.RE
.sp -0.25v
.IP \& 3.75n
which causes
.B \%pdfnote
annotations to be embedded,
within the running text,
.I immediately
following the glyph which was,
most recently,
inserted into the PDF text output stream.
.
.IP \& 3.75n
This default placement of
.B \%pdfnote
annotations will tend to occlude parts of the running text,
on the PDF output page.
It can be challenging to circumvent such occlusion;
thus,
users may prefer to redefine
.BR \%PDFNOTE\^.\h'0.05n'OFFSET ,
to relocate
.B \%pdfnote
annotations,
for example,
to the \%left-hand page margin:
.RS 6.25n
.sp 0.15v
.EX
\&.ds PDFNOTE.OFFSET "\(rs\(rsn[.o]\-\(rs\(rsn[PDFNOTE.WIDTH]\-1m\(rs"
.EE
.RE
.sp -0.25v
.IP \& 3.75n
thus computing the placement for the \%left-hand side of the
.B \%pdfnote
region,
within the \%left-hand page margin,
(as defined by the
.RB \%\(lq .\^po \(rq
request),
accounting for the nominal width of the
.B \%pdfnote
region itself,
and allowing for 1\^em of space between the \%right-hand side of the
.B \%pdfnote
region and the leftmost extent of the running text;
it
.I assumes
that the margin width is sufficient to accommodate this,
.I but does not verify
this assumption.
.
.TP 3.75n
.B \%PDFNOTE\^.\^LEADING
Complementary to the
.B \%PDFNOTE\^.\h'0.05n'OFFSET
control,
.B \%PDFNOTE\^.\^LEADING
establishes the placement for the topmost edge of the
.B \%pdfnote
display region;
it represents,
in device units relative to the baseline of the line of running text
which was most recently written to the PDF output stream,
the displacement of the top of the
.B \%pdfnote
display region,
and is defined,
by default,
as:
.RS 6.25n
.sp 0.15v
.EX
\&.nr PDFNOTE.LEADING 0.3v
.EE
.RE
.sp -0.25v
.IP \& 3.75n
which sets the top of the
.B \%pdfnote
display region to be 30\^% of the current line height
.I below
the baseline of the preceding line of running text.
.
.IP \& 3.75n
Notice that,
whereas
.B \%PDFNOTE\^.\h'0.05n'OFFSET
is defined as a
.IR string ,
which will ultimately be interpreted as a numeric expression,
.B \%PDFNOTE\^.\^LEADING
is defined,
from the outset,
as a simple numeric value;
this distinction should be borne in mind,
if it is desired to redefine either
.B \%PDFNOTE\^.\h'0.05n'OFFSET
or
.BR \%PDFNOTE\^.\^LEADING \^.
.
.TP 3.75n
.B \%PDFNOTE\^.\h'-0.1n'WIDTH
.TQ 3.75n
.B \%PDFNOTE\^.\^HEIGHT
With default definitions of:
.RS 6.25n
.sp 0.15v
.EX
\&.nr PDFNOTE.WIDTH  0.8c
\&.nr PDFNOTE.HEIGHT 0.9c
.EE
.RE
.sp -0.25v
.IP \& 3.75n
this pair of numeric registers defines the width,
and the height respectively,
of each
.B \%pdfnote
display region;
when they are evaluated in conjunction with the
.B \%PDFNOTE\^.\h'0.05n'OFFSET
and
.B \%PDFNOTE\^.\^LEADING
registers,
'ne 2v
the placement and extent of each
.B \%pdfnote
display region is completely specified.
.
.TP 3.75n
.B \%PDFNOTE\^.\h'0.05n'QUOTED
Since the entire content of any
.B \%pdfnote
.I must
be passed as a list of arguments,
in a
.B \%pdfnote
macro call,
and given that,
when any ASCII double quote character
is included in such an argument list,
it is commonly preceded by white space,
which causes it to be interpreted as an argument grouping mark;
in this context,
it can be challenging to specify such quoting characters
with the intent that they should appear within
the body text of any
.BR \%pdfnote \^.
.
.IP \& 3.75n
While it may be possible to specify literal ASCII quotation marks,
by placing
.I two
of them consecutively,
for each individual literal mark,
within a quoted argument group,
a possibly more intuitive alternative is offered by the
.B \%PDFNOTE\^.\h'0.05n'QUOTED
string.
.
Defined as a template,
(which should be considered to be represented as a
.IR "string constant" ),
this may be interpolated,
within the body text region of any
.B \%pdfnote
macro argument list,
in the form:
.RS 6.25n
.sp 0.15v
.EX
\(rs*[PDFNOTE.QUOTED text to be quoted ...]
.EE
.RE
.sp -0.25v
.IP \& 3.75n
which results in insertion of "\fCtext to be quoted ...\fP",
enclosed between literal ASCII double quotation marks,
into the text of the resultant
.BR \%pdfnote \^.
.
.TP 3.75n
.B \%PDFNOTE\^.\^NEWLINE
Even more so,
than the inclusion of literal ASCII double quotation marks
within the text of any
.BR \%pdfnote \^,
it can be extremely challenging to insert hard line breaks.
This challenge may be overcome,
by interpolation of:
.RS 6.25n
.sp 0.15v
.EX
\(rs*[PDFNOTE.NEWLINE]
.EE
.RE
.sp -0.25v
.IP \& 3.75n
at appropriate points within the text region of
the arguments passed to the
.B \%pdfnote
macro.
.
.IP \& 3.75n
As in the case of
.BR \%PDFNOTE\^.\h'0.05n'QUOTED \^,
the definition of
.B \%PDFNOTE\^.\^NEWLINE
is also formulated as a
.MR groff @MAN7EXT@
string,
which should be considered to represent a
.IR "string constant" .
.
.TP 3.75n
.B \%PDFNOTE\^.\^PILCROW
Named to reflect its association with the traditional
typographer's end-of-paragraph mark,
this is a specialization of the
.B \%PDFNOTE\^.\^NEWLINE
feature.
Interpolated within
.B \%pdfnote
macro arguments,
in similar fashion:
.RS 6.25n
.sp 0.15v
.EX
\(rs*[PDFNOTE.PILCROW]
.EE
.RE
.sp -0.25v
.IP \& 3.75n
its effect differs from that of
.B \%PDFNOTE\^.\^NEWLINE
only insofar as it repeats the effect of
.BR \%PDFNOTE\^.\^NEWLINE \^,
to introduce the paragraph break,
and then as many additional times as have been specified for the
.RI \%< paragraph-spacing >
argument,
in the most recent
.B \%pdfnote
macro call,
in which the
.RB \(lq \-PD \(rq
option was specified.
.
.IP \& 3.75n
Once again,
the definition of
.B \%PDFNOTE\^.\^PILCROW
should be considered to represent a
.IR "string constant" .
.ll +3n
.RE
.
.
.\" ====================================================================
.SH Files
.\" ====================================================================
.
.TP 6.75n
.I @SITE_TMACDIR@/pdfmark.tmac
This implements the core functionality of the entire
.I \%groff-pdfmark
macro suite,
including the implementation of,
and supporting infrastructure for,
the
.B \%pdfnote
macro.
.
.
.\" ====================================================================
.SH Authors
.\" ====================================================================
.
The
.B \%pdfnote
macro is provided by the
.I \%groff-pdfmark
package,
which was written by
.MT @AUTHOR_MT_ADDRESS@
Keith\ Marshall
.ME ;
it is independently maintained at
.UR @PROJECT_HOSTING_SITE@
Keith's
.I \%groff-pdfmark
project hosting \%web-site
.UE ,
whence the latest version may
.I always
be obtained.
.
.
.\" ====================================================================
.SH See Also
.\" ====================================================================
.
.\" @ENUMERATE_MR_REFERENCES@
.
.P
More comprehensive documentation,
on the use of the
.I \%groff-pdfmark
macro suite may be found,
in PDF format,
in the reference guide
.RI \[lq] "Portable Document Format Publishing with GNU Troff" \[rq],
which has also been written by Keith Marshall;
the most recently published version of this guide may be read online,
by following the appropriate document reference link on
.UR @PROJECT_HOSTING_SITE@
the
.I \%groff-pdfmark
project hosting \%web-site
.UE ,
whence a copy may also be downloaded.
.
.\" ====================================================================
.
.\" Restore compatibility mode (for, e.g., Solaris 10/11).
.cp \n[*groff_pdfnote_7_man_C]
.do rr *groff_pdfnote_7_man_C
.
.\" ====================================================================
.
.\" Local Variables:
.\" fill-column: 72
.\" mode: nroff
.\" End:
.\" vim: set filetype=groff textwidth=72:
