/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.distribution;

import org.apache.commons.math3.special.Gamma;
import org.apache.commons.math3.util.FastMath;

final class SaddlePointExpansion {
    private static final double HALF_LOG_2_PI = 0.5 * FastMath.log(Math.PI * 2);
    private static final double[] EXACT_STIRLING_ERRORS = new double[]{0.0, 0.15342640972002736, 0.08106146679532726, 0.05481412105191765, 0.0413406959554093, 0.03316287351993629, 0.02767792568499834, 0.023746163656297496, 0.020790672103765093, 0.018488450532673187, 0.016644691189821193, 0.015134973221917378, 0.013876128823070748, 0.012810465242920227, 0.01189670994589177, 0.011104559758206917, 0.010411265261972096, 0.009799416126158804, 0.009255462182712733, 0.008768700134139386, 0.00833056343336287, 0.00793411456431402, 0.007573675487951841, 0.007244554301320383, 0.00694284010720953, 0.006665247032707682, 0.006408994188004207, 0.006171712263039458, 0.0059513701127588475, 0.0057462165130101155, 0.005554733551962801};

    private SaddlePointExpansion() {
    }

    static double getStirlingError(double z2) {
        double ret;
        if (z2 < 15.0) {
            double z22 = 2.0 * z2;
            ret = FastMath.floor(z22) == z22 ? EXACT_STIRLING_ERRORS[(int)z22] : Gamma.logGamma(z2 + 1.0) - (z2 + 0.5) * FastMath.log(z2) + z2 - HALF_LOG_2_PI;
        } else {
            double z23 = z2 * z2;
            ret = (0.08333333333333333 - (0.002777777777777778 - (7.936507936507937E-4 - (5.952380952380953E-4 - 8.417508417508417E-4 / z23) / z23) / z23) / z23) / z2;
        }
        return ret;
    }

    static double getDeviancePart(double x2, double mu) {
        double ret;
        if (FastMath.abs(x2 - mu) < 0.1 * (x2 + mu)) {
            double d2 = x2 - mu;
            double v2 = d2 / (x2 + mu);
            double s1 = v2 * d2;
            double s2 = Double.NaN;
            double ej = 2.0 * x2 * v2;
            v2 *= v2;
            int j2 = 1;
            while (s1 != s2) {
                s2 = s1;
                s1 = s2 + (ej *= v2) / (double)(j2 * 2 + 1);
                ++j2;
            }
            ret = s1;
        } else {
            ret = x2 * FastMath.log(x2 / mu) + mu - x2;
        }
        return ret;
    }

    static double logBinomialProbability(int x2, int n2, double p2, double q2) {
        double ret;
        if (x2 == 0) {
            ret = p2 < 0.1 ? -SaddlePointExpansion.getDeviancePart(n2, (double)n2 * q2) - (double)n2 * p2 : (double)n2 * FastMath.log(q2);
        } else if (x2 == n2) {
            ret = q2 < 0.1 ? -SaddlePointExpansion.getDeviancePart(n2, (double)n2 * p2) - (double)n2 * q2 : (double)n2 * FastMath.log(p2);
        } else {
            ret = SaddlePointExpansion.getStirlingError(n2) - SaddlePointExpansion.getStirlingError(x2) - SaddlePointExpansion.getStirlingError(n2 - x2) - SaddlePointExpansion.getDeviancePart(x2, (double)n2 * p2) - SaddlePointExpansion.getDeviancePart(n2 - x2, (double)n2 * q2);
            double f2 = Math.PI * 2 * (double)x2 * (double)(n2 - x2) / (double)n2;
            ret = -0.5 * FastMath.log(f2) + ret;
        }
        return ret;
    }
}

