/*
 * Decompiled with CFR 0.152.
 */
package gde.device.graupner;

import gde.GDE;
import gde.config.Settings;
import gde.data.Record;
import gde.data.RecordSet;
import gde.device.DesktopPropertyType;
import gde.device.DesktopPropertyTypes;
import gde.device.DeviceConfiguration;
import gde.device.InputTypes;
import gde.device.graupner.Ultramat;
import gde.exception.DataInconsitsentException;
import gde.messages.Messages;
import java.io.FileNotFoundException;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.JAXBException;
import org.eclipse.swt.custom.CTabItem;

public class UltraDuoPlus60
extends Ultramat {
    static final Logger logger = Logger.getLogger(UltraDuoPlus60.class.getName());

    public UltraDuoPlus60(String deviceProperties) throws FileNotFoundException, JAXBException {
        super(deviceProperties);
        Messages.setDeviceResourceBundle((String)"gde.device.graupner.messages", (Locale)Settings.getInstance().getLocale(), (ClassLoader)((Object)((Object)this)).getClass().getClassLoader());
        this.USAGE_MODE = new String[]{Messages.getString((String)"GDE_MSGT2200"), Messages.getString((String)"GDE_MSGT2201"), Messages.getString((String)"GDE_MSGT2202"), Messages.getString((String)"GDE_MSGT2203"), Messages.getString((String)"GDE_MSGT2204"), Messages.getString((String)"GDE_MSGT2205"), Messages.getString((String)"GDE_MSGT2206"), Messages.getString((String)"GDE_MSGT2207"), Messages.getString((String)"GDE_MSGT2208"), Messages.getString((String)"GDE_MSGT2209")};
        this.CHARGE_MODE = new String[]{Messages.getString((String)"GDE_MSGT2210"), Messages.getString((String)"GDE_MSGT2211"), Messages.getString((String)"GDE_MSGT2212"), Messages.getString((String)"GDE_MSGT2213"), Messages.getString((String)"GDE_MSGT2214"), Messages.getString((String)"GDE_MSGT2215"), Messages.getString((String)"GDE_MSGT2216"), Messages.getString((String)"GDE_MSGT2217"), Messages.getString((String)"GDE_MSGT2218"), Messages.getString((String)"GDE_MSGT2219"), Messages.getString((String)"GDE_MSGT2220"), Messages.getString((String)"GDE_MSGT2221"), Messages.getString((String)"GDE_MSGT2222")};
        this.DISCHARGE_MODE = new String[]{Messages.getString((String)"GDE_MSGT2210"), Messages.getString((String)"GDE_MSGT2211"), Messages.getString((String)"GDE_MSGT2212"), Messages.getString((String)"GDE_MSGT2213"), Messages.getString((String)"GDE_MSGT2223"), Messages.getString((String)"GDE_MSGT2224"), Messages.getString((String)"GDE_MSGT2220"), Messages.getString((String)"GDE_MSGT2222")};
        this.DELAY_MODE = new String[]{Messages.getString((String)"GDE_MSGT2225"), Messages.getString((String)"GDE_MSGT2226"), Messages.getString((String)"GDE_MSGT2227"), Messages.getString((String)"GDE_MSGT2228")};
        this.CURRENT_MODE = new String[]{Messages.getString((String)"GDE_MSGT2229"), Messages.getString((String)"GDE_MSGT2230"), Messages.getString((String)"GDE_MSGT2231"), Messages.getString((String)"GDE_MSGT2232"), Messages.getString((String)"GDE_MSGT2233"), Messages.getString((String)"GDE_MSGT2234"), Messages.getString((String)"GDE_MSGT2235"), Messages.getString((String)"GDE_MSGT2236"), Messages.getString((String)"GDE_MSGT2237")};
        if (this.application.getMenuToolBar() != null) {
            this.configureSerialPortMenu(1, "", "");
        }
    }

    public UltraDuoPlus60(DeviceConfiguration deviceConfig) {
        super(deviceConfig);
        Messages.setDeviceResourceBundle((String)"gde.device.graupner.messages", (Locale)Settings.getInstance().getLocale(), (ClassLoader)((Object)((Object)this)).getClass().getClassLoader());
        this.USAGE_MODE = new String[]{Messages.getString((String)"GDE_MSGT2200"), Messages.getString((String)"GDE_MSGT2201"), Messages.getString((String)"GDE_MSGT2202"), Messages.getString((String)"GDE_MSGT2203"), Messages.getString((String)"GDE_MSGT2204"), Messages.getString((String)"GDE_MSGT2205"), Messages.getString((String)"GDE_MSGT2206"), Messages.getString((String)"GDE_MSGT2207"), Messages.getString((String)"GDE_MSGT2208"), Messages.getString((String)"GDE_MSGT2209")};
        this.CHARGE_MODE = new String[]{Messages.getString((String)"GDE_MSGT2210"), Messages.getString((String)"GDE_MSGT2211"), Messages.getString((String)"GDE_MSGT2212"), Messages.getString((String)"GDE_MSGT2213"), Messages.getString((String)"GDE_MSGT2214"), Messages.getString((String)"GDE_MSGT2215"), Messages.getString((String)"GDE_MSGT2216"), Messages.getString((String)"GDE_MSGT2217"), Messages.getString((String)"GDE_MSGT2218"), Messages.getString((String)"GDE_MSGT2219"), Messages.getString((String)"GDE_MSGT2220"), Messages.getString((String)"GDE_MSGT2221"), Messages.getString((String)"GDE_MSGT2222")};
        this.DISCHARGE_MODE = new String[]{Messages.getString((String)"GDE_MSGT2210"), Messages.getString((String)"GDE_MSGT2211"), Messages.getString((String)"GDE_MSGT2212"), Messages.getString((String)"GDE_MSGT2213"), Messages.getString((String)"GDE_MSGT2223"), Messages.getString((String)"GDE_MSGT2224"), Messages.getString((String)"GDE_MSGT2220"), Messages.getString((String)"GDE_MSGT2222")};
        this.DELAY_MODE = new String[]{Messages.getString((String)"GDE_MSGT2225"), Messages.getString((String)"GDE_MSGT2226"), Messages.getString((String)"GDE_MSGT2227"), Messages.getString((String)"GDE_MSGT2228")};
        this.CURRENT_MODE = new String[]{Messages.getString((String)"GDE_MSGT2229"), Messages.getString((String)"GDE_MSGT2230"), Messages.getString((String)"GDE_MSGT2231"), Messages.getString((String)"GDE_MSGT2232"), Messages.getString((String)"GDE_MSGT2233"), Messages.getString((String)"GDE_MSGT2234"), Messages.getString((String)"GDE_MSGT2235"), Messages.getString((String)"GDE_MSGT2236"), Messages.getString((String)"GDE_MSGT2237")};
        this.configureSerialPortMenu(1, "", "");
    }

    @Override
    public int getLovDataByteSize() {
        return 150;
    }

    @Override
    public synchronized void addConvertedLovDataBufferAsRawDataPoints(RecordSet recordSet, byte[] dataBuffer, int recordDataSize, boolean doUpdateProgressBar) throws DataInconsitsentException {
        String sThreadId = String.format("%06d", Thread.currentThread().threadId());
        int deviceDataBufferSize = Math.abs(this.getDataBlockSize(InputTypes.SERIAL_IO));
        int deviceDataBufferSize2 = deviceDataBufferSize / 2;
        int channel2Offset = deviceDataBufferSize2 - 5;
        int[] points = new int[this.getNumberOfMeasurements(recordSet.getChannelConfigNumber())];
        int offset = 4;
        int progressCycle = 0;
        int lovDataSize = this.getLovDataByteSize();
        int outputChannel = recordSet.getChannelConfigNumber();
        if (dataBuffer[offset] == 12) {
            byte[] convertBuffer = new byte[deviceDataBufferSize];
            if (doUpdateProgressBar) {
                this.application.setProgress(progressCycle, sThreadId);
            }
            for (int i = 0; i < recordDataSize; ++i) {
                if (outputChannel == 1) {
                    System.arraycopy(dataBuffer, offset + i * lovDataSize, convertBuffer, 0, deviceDataBufferSize2);
                } else if (outputChannel == 2) {
                    System.arraycopy(dataBuffer, channel2Offset + offset + i * lovDataSize, convertBuffer, 0, deviceDataBufferSize2);
                } else if (outputChannel == 3) {
                    System.arraycopy(dataBuffer, offset + i * lovDataSize, convertBuffer, 0, deviceDataBufferSize);
                }
                recordSet.addPoints(this.convertDataBytes(points, convertBuffer));
                if (!doUpdateProgressBar || i % 50 != 0) continue;
                this.application.setProgress(++progressCycle * 5000 / recordDataSize, sThreadId);
            }
            recordSet.setTimeStep_ms(this.getAverageTimeStep_ms() != null ? this.getAverageTimeStep_ms() : 1000.0);
        }
        if (doUpdateProgressBar) {
            this.application.setProgress(100, sThreadId);
        }
        this.updateVisibilityStatus(recordSet, true);
        recordSet.syncScaleOfSyncableRecords();
    }

    @Override
    public int[] convertDataBytes(int[] points, byte[] dataBuffer) {
        int maxVotage = Integer.MIN_VALUE;
        int minVotage = Integer.MAX_VALUE;
        int deviceDataBufferSize = Math.abs(this.getDataBlockSize(InputTypes.SERIAL_IO));
        if (deviceDataBufferSize == dataBuffer.length && this.isLinkedMode(dataBuffer)) {
            try {
                points[1] = Integer.parseInt(String.format("%c%c%c%c", Character.valueOf((char)dataBuffer[21]), Character.valueOf((char)dataBuffer[22]), Character.valueOf((char)dataBuffer[23]), Character.valueOf((char)dataBuffer[24])), 16);
                points[2] = Integer.parseInt(String.format("%c%c%c%c", Character.valueOf((char)dataBuffer[85]), Character.valueOf((char)dataBuffer[86]), Character.valueOf((char)dataBuffer[87]), Character.valueOf((char)dataBuffer[88])), 16);
                points[0] = points[1] + points[2];
                points[4] = Integer.parseInt(String.format("%c%c%c%c", Character.valueOf((char)dataBuffer[25]), Character.valueOf((char)dataBuffer[26]), Character.valueOf((char)dataBuffer[27]), Character.valueOf((char)dataBuffer[28])), 16);
                points[5] = Integer.parseInt(String.format("%c%c%c%c", Character.valueOf((char)dataBuffer[89]), Character.valueOf((char)dataBuffer[90]), Character.valueOf((char)dataBuffer[91]), Character.valueOf((char)dataBuffer[92])), 16);
                points[3] = points[4] + points[5];
                points[7] = Integer.parseInt(String.format("%c%c%c%c", Character.valueOf((char)dataBuffer[29]), Character.valueOf((char)dataBuffer[30]), Character.valueOf((char)dataBuffer[31]), Character.valueOf((char)dataBuffer[32])), 16);
                points[8] = Integer.parseInt(String.format("%c%c%c%c", Character.valueOf((char)dataBuffer[93]), Character.valueOf((char)dataBuffer[94]), Character.valueOf((char)dataBuffer[95]), Character.valueOf((char)dataBuffer[96])), 16);
                points[6] = points[7] + points[8];
                points[10] = Double.valueOf((double)(points[1] * points[4]) / 1000.0).intValue();
                points[11] = Double.valueOf((double)(points[2] * points[5]) / 1000.0).intValue();
                points[9] = points[10] + points[11];
                points[13] = Double.valueOf((double)(points[0] * points[2]) / 1000.0).intValue();
                points[14] = Double.valueOf((double)(points[0] * points[2]) / 1000.0).intValue();
                points[12] = points[13] + points[14];
                points[15] = Integer.parseInt(String.format("%c%c%c%c", Character.valueOf((char)dataBuffer[33]), Character.valueOf((char)dataBuffer[34]), Character.valueOf((char)dataBuffer[35]), Character.valueOf((char)dataBuffer[36])), 16);
                String sign = String.format("%c%c", Character.valueOf((char)dataBuffer[37]), Character.valueOf((char)dataBuffer[38]));
                if (sign != null && sign.length() > 0 && Integer.parseInt(sign) == 0) {
                    points[15] = -1 * points[15];
                }
                points[16] = Integer.parseInt(String.format("%c%c%c%c", Character.valueOf((char)dataBuffer[97]), Character.valueOf((char)dataBuffer[98]), Character.valueOf((char)dataBuffer[99]), Character.valueOf((char)dataBuffer[100])), 16);
                sign = String.format("%c%c", Character.valueOf((char)dataBuffer[101]), Character.valueOf((char)dataBuffer[102]));
                if (sign != null && sign.length() > 0 && Integer.parseInt(sign) == 0) {
                    points[16] = -1 * points[16];
                }
                points[17] = Integer.parseInt(String.format("%c%c%c%c", Character.valueOf((char)dataBuffer[11]), Character.valueOf((char)dataBuffer[12]), Character.valueOf((char)dataBuffer[13]), Character.valueOf((char)dataBuffer[14])), 16) + Integer.parseInt(String.format("%c%c%c%c", Character.valueOf((char)dataBuffer[75]), Character.valueOf((char)dataBuffer[76]), Character.valueOf((char)dataBuffer[77]), Character.valueOf((char)dataBuffer[78])), 16) >>> 1;
                points[18] = 0;
                int i = 0;
                int j = 0;
                while (i < 7) {
                    points[i + 19] = Integer.parseInt(String.format("%c%c%c%c", Character.valueOf((char)dataBuffer[41 + j]), Character.valueOf((char)dataBuffer[42 + j]), Character.valueOf((char)dataBuffer[43 + j]), Character.valueOf((char)dataBuffer[44 + j])), 16);
                    if (points[i + 19] > 0) {
                        maxVotage = points[i + 19] > maxVotage ? points[i + 19] : maxVotage;
                        minVotage = points[i + 19] < minVotage ? points[i + 19] : minVotage;
                    }
                    ++i;
                    j += 4;
                }
                i = 0;
                j = 0;
                while (i < 7) {
                    points[i + 26] = Integer.parseInt(String.format("%c%c%c%c", Character.valueOf((char)dataBuffer[105 + j]), Character.valueOf((char)dataBuffer[106 + j]), Character.valueOf((char)dataBuffer[107 + j]), Character.valueOf((char)dataBuffer[108 + j])), 16);
                    if (points[i + 26] > 0) {
                        maxVotage = points[i + 26] > maxVotage ? points[i + 26] : maxVotage;
                        minVotage = points[i + 26] < minVotage ? points[i + 26] : minVotage;
                    }
                    ++i;
                    j += 4;
                }
            }
            catch (NumberFormatException e) {
                log.log(Level.WARNING, e.getMessage(), e);
            }
            points[18] = maxVotage != Integer.MIN_VALUE && minVotage != Integer.MAX_VALUE ? maxVotage - minVotage : 0;
        } else {
            try {
                points[0] = Integer.parseInt(String.format("%c%c%c%c", Character.valueOf((char)dataBuffer[21]), Character.valueOf((char)dataBuffer[22]), Character.valueOf((char)dataBuffer[23]), Character.valueOf((char)dataBuffer[24])), 16);
                points[1] = Integer.parseInt(String.format("%c%c%c%c", Character.valueOf((char)dataBuffer[25]), Character.valueOf((char)dataBuffer[26]), Character.valueOf((char)dataBuffer[27]), Character.valueOf((char)dataBuffer[28])), 16);
                points[2] = Integer.parseInt(String.format("%c%c%c%c", Character.valueOf((char)dataBuffer[29]), Character.valueOf((char)dataBuffer[30]), Character.valueOf((char)dataBuffer[31]), Character.valueOf((char)dataBuffer[32])), 16);
                points[3] = Double.valueOf((double)(points[0] * points[1]) / 1000.0).intValue();
                points[4] = Double.valueOf((double)(points[0] * points[2]) / 1000.0).intValue();
                points[5] = Integer.parseInt(String.format("%c%c%c%c", Character.valueOf((char)dataBuffer[33]), Character.valueOf((char)dataBuffer[34]), Character.valueOf((char)dataBuffer[35]), Character.valueOf((char)dataBuffer[36])), 16);
                String sign = String.format("%c%c", Character.valueOf((char)dataBuffer[37]), Character.valueOf((char)dataBuffer[38]));
                if (sign != null && sign.length() > 0 && Integer.parseInt(sign) == 0) {
                    points[5] = -1 * points[5];
                }
                points[6] = Integer.parseInt(String.format("%c%c%c%c", Character.valueOf((char)dataBuffer[11]), Character.valueOf((char)dataBuffer[12]), Character.valueOf((char)dataBuffer[13]), Character.valueOf((char)dataBuffer[14])), 16);
                points[7] = 0;
                int i = 0;
                int j = 0;
                while (i < points.length - 8) {
                    points[i + 8] = Integer.parseInt(String.format("%c%c%c%c", Character.valueOf((char)dataBuffer[41 + j]), Character.valueOf((char)dataBuffer[42 + j]), Character.valueOf((char)dataBuffer[43 + j]), Character.valueOf((char)dataBuffer[44 + j])), 16);
                    if (points[i + 8] > 0) {
                        maxVotage = points[i + 8] > maxVotage ? points[i + 8] : maxVotage;
                        minVotage = points[i + 8] < minVotage ? points[i + 8] : minVotage;
                    }
                    ++i;
                    j += 4;
                }
            }
            catch (Exception e) {
                log.log(Level.WARNING, e.getMessage(), e);
            }
            points[7] = maxVotage != Integer.MIN_VALUE && minVotage != Integer.MAX_VALUE ? maxVotage - minVotage : 0;
        }
        return points;
    }

    @Override
    public void addDataBufferAsRawDataPoints(RecordSet recordSet, byte[] dataBuffer, int recordDataSize, boolean doUpdateProgressBar) throws DataInconsitsentException {
        int dataBufferSize = 4 * recordSet.getNoneCalculationRecordNames().length;
        byte[] convertBuffer = new byte[dataBufferSize];
        int[] points = new int[recordSet.size()];
        String sThreadId = String.format("%06d", Thread.currentThread().threadId());
        int progressCycle = 0;
        if (doUpdateProgressBar) {
            this.application.setProgress(progressCycle, sThreadId);
        }
        if (recordSet.getChannelConfigNumber() == 3) {
            for (int i = 0; i < recordDataSize; ++i) {
                int maxVotage = Integer.MIN_VALUE;
                int minVotage = Integer.MAX_VALUE;
                logger.log(Level.FINER, i + " i*dataBufferSize+timeStampBufferSize = " + i * dataBufferSize);
                System.arraycopy(dataBuffer, i * dataBufferSize, convertBuffer, 0, dataBufferSize);
                points[1] = ((convertBuffer[0] & 0xFF) << 24) + ((convertBuffer[1] & 0xFF) << 16) + ((convertBuffer[2] & 0xFF) << 8) + ((convertBuffer[3] & 0xFF) << 0);
                points[2] = ((convertBuffer[4] & 0xFF) << 24) + ((convertBuffer[5] & 0xFF) << 16) + ((convertBuffer[6] & 0xFF) << 8) + ((convertBuffer[7] & 0xFF) << 0);
                points[0] = points[1] + points[2];
                points[4] = ((convertBuffer[8] & 0xFF) << 24) + ((convertBuffer[9] & 0xFF) << 16) + ((convertBuffer[10] & 0xFF) << 8) + ((convertBuffer[11] & 0xFF) << 0);
                points[5] = ((convertBuffer[12] & 0xFF) << 24) + ((convertBuffer[13] & 0xFF) << 16) + ((convertBuffer[14] & 0xFF) << 8) + ((convertBuffer[15] & 0xFF) << 0);
                points[3] = points[4] + points[5];
                points[7] = ((convertBuffer[16] & 0xFF) << 24) + ((convertBuffer[17] & 0xFF) << 16) + ((convertBuffer[18] & 0xFF) << 8) + ((convertBuffer[19] & 0xFF) << 0);
                points[8] = ((convertBuffer[20] & 0xFF) << 24) + ((convertBuffer[21] & 0xFF) << 16) + ((convertBuffer[22] & 0xFF) << 8) + ((convertBuffer[23] & 0xFF) << 0);
                points[6] = points[7] + points[8];
                points[9] = Double.valueOf((double)points[0] / 1000.0 * (double)points[3]).intValue();
                points[10] = Double.valueOf((double)points[1] / 1000.0 * (double)points[4]).intValue();
                points[11] = Double.valueOf((double)points[2] / 1000.0 * (double)points[5]).intValue();
                points[12] = Double.valueOf((double)points[0] / 1000.0 * (double)points[6]).intValue();
                points[13] = Double.valueOf((double)points[0] / 1000.0 * (double)points[7]).intValue();
                points[14] = Double.valueOf((double)points[0] / 1000.0 * (double)points[8]).intValue();
                points[15] = ((convertBuffer[24] & 0xFF) << 24) + ((convertBuffer[25] & 0xFF) << 16) + ((convertBuffer[26] & 0xFF) << 8) + ((convertBuffer[27] & 0xFF) << 0);
                points[16] = ((convertBuffer[28] & 0xFF) << 24) + ((convertBuffer[29] & 0xFF) << 16) + ((convertBuffer[30] & 0xFF) << 8) + ((convertBuffer[31] & 0xFF) << 0);
                points[17] = ((convertBuffer[32] & 0xFF) << 24) + ((convertBuffer[33] & 0xFF) << 16) + ((convertBuffer[34] & 0xFF) << 8) + ((convertBuffer[35] & 0xFF) << 0);
                points[18] = 0;
                int j = 0;
                int k = 0;
                while (j < points.length - 20) {
                    points[j + 19] = ((convertBuffer[k + 36] & 0xFF) << 24) + ((convertBuffer[k + 37] & 0xFF) << 16) + ((convertBuffer[k + 38] & 0xFF) << 8) + ((convertBuffer[k + 39] & 0xFF) << 0);
                    if (points[j + 19] > 0) {
                        maxVotage = points[j + 19] > maxVotage ? points[j + 19] : maxVotage;
                        minVotage = points[j + 19] < minVotage ? points[j + 19] : minVotage;
                    }
                    ++j;
                    k += 4;
                }
                points[18] = maxVotage != Integer.MIN_VALUE && minVotage != Integer.MAX_VALUE ? maxVotage - minVotage : 0;
                recordSet.addPoints(points);
                if (!doUpdateProgressBar || i % 50 != 0) continue;
                this.application.setProgress(++progressCycle * 2500 / recordDataSize, sThreadId);
            }
        } else {
            for (int i = 0; i < recordDataSize; ++i) {
                int maxVotage = Integer.MIN_VALUE;
                int minVotage = Integer.MAX_VALUE;
                logger.log(Level.FINER, i + " i*dataBufferSize+timeStampBufferSize = " + i * dataBufferSize);
                System.arraycopy(dataBuffer, i * dataBufferSize, convertBuffer, 0, dataBufferSize);
                points[0] = ((convertBuffer[0] & 0xFF) << 24) + ((convertBuffer[1] & 0xFF) << 16) + ((convertBuffer[2] & 0xFF) << 8) + ((convertBuffer[3] & 0xFF) << 0);
                points[1] = ((convertBuffer[4] & 0xFF) << 24) + ((convertBuffer[5] & 0xFF) << 16) + ((convertBuffer[6] & 0xFF) << 8) + ((convertBuffer[7] & 0xFF) << 0);
                points[2] = ((convertBuffer[8] & 0xFF) << 24) + ((convertBuffer[9] & 0xFF) << 16) + ((convertBuffer[10] & 0xFF) << 8) + ((convertBuffer[11] & 0xFF) << 0);
                points[3] = Double.valueOf((double)points[0] / 1000.0 * (double)points[1]).intValue();
                points[4] = Double.valueOf((double)points[0] / 1000.0 * (double)points[2]).intValue();
                points[5] = ((convertBuffer[12] & 0xFF) << 24) + ((convertBuffer[13] & 0xFF) << 16) + ((convertBuffer[14] & 0xFF) << 8) + ((convertBuffer[15] & 0xFF) << 0);
                points[6] = ((convertBuffer[16] & 0xFF) << 24) + ((convertBuffer[17] & 0xFF) << 16) + ((convertBuffer[18] & 0xFF) << 8) + ((convertBuffer[19] & 0xFF) << 0);
                points[7] = 0;
                int j = 0;
                int k = 0;
                while (j < points.length - 8) {
                    points[j + 8] = ((convertBuffer[k + 20] & 0xFF) << 24) + ((convertBuffer[k + 21] & 0xFF) << 16) + ((convertBuffer[k + 22] & 0xFF) << 8) + ((convertBuffer[k + 23] & 0xFF) << 0);
                    if (points[j + 8] > 0) {
                        maxVotage = points[j + 8] > maxVotage ? points[j + 8] : maxVotage;
                        minVotage = points[j + 8] < minVotage ? points[j + 8] : minVotage;
                    }
                    ++j;
                    k += 4;
                }
                points[7] = maxVotage != Integer.MIN_VALUE && minVotage != Integer.MAX_VALUE ? maxVotage - minVotage : 0;
                recordSet.addPoints(points);
                if (!doUpdateProgressBar || i % 50 != 0) continue;
                this.application.setProgress(++progressCycle * 2500 / recordDataSize, sThreadId);
            }
        }
        if (doUpdateProgressBar) {
            this.application.setProgress(100, sThreadId);
        }
        recordSet.syncScaleOfSyncableRecords();
    }

    @Override
    public void updateVisibilityStatus(RecordSet recordSet, boolean includeReasonableDataCheck) {
        Record record;
        int i;
        int displayableCounter = 0;
        recordSet.setAllDisplayable();
        int numCells = recordSet.getChannelConfigNumber() < 3 ? 7 : 14;
        for (i = recordSet.size() - numCells - 1; i < recordSet.size(); ++i) {
            record.setDisplayable((record = recordSet.get(i)).getOrdinal() <= 5 || record.hasReasonableData());
            log.log(Level.FINER, record.getName() + " setDisplayable=" + (record.getOrdinal() <= 5 || record.hasReasonableData()));
            if (!record.isActive() || !record.isDisplayable()) continue;
            ++displayableCounter;
        }
        if (logger.isLoggable(Level.FINE)) {
            for (i = 0; i < recordSet.size(); ++i) {
                record = recordSet.get(i);
                logger.log(Level.FINE, record.getName() + " isActive=" + record.isActive() + " isVisible=" + record.isVisible() + " isDisplayable=" + record.isDisplayable());
            }
        }
        recordSet.setConfiguredDisplayable(displayableCounter);
    }

    @Override
    public Ultramat.GraupnerDeviceType getDeviceTypeIdentifier() {
        return Ultramat.GraupnerDeviceType.UltraDuoPlus60;
    }

    @Override
    public int getDesktopTargetReferenceOrdinal(DesktopPropertyTypes desktopPropertyType) {
        DesktopPropertyType property = this.getDesktopProperty(desktopPropertyType);
        if (this.channels.getActiveChannelNumber() == 3) {
            return property != null ? property.getTargetReferenceOrdinal() + 11 : -1;
        }
        return property != null ? property.getTargetReferenceOrdinal() : -1;
    }

    @Override
    public int[] getCellVoltageOrdinals() {
        return new int[]{0, this.channels.getActiveChannelNumber() == 3 ? 6 : 2};
    }

    @Override
    public boolean isProcessing(int outletNum, byte[] dataBuffer) {
        if (outletNum == 1) {
            String operationModeOut1 = String.format("%c%c", Character.valueOf((char)dataBuffer[15]), Character.valueOf((char)dataBuffer[16]));
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "operationModeOut1 = " + (operationModeOut1 != null && operationModeOut1.length() > 0 ? this.USAGE_MODE[Integer.parseInt(operationModeOut1, 16)] : operationModeOut1));
            }
            if (this.settings.isReduceChargeDischarge()) {
                return operationModeOut1 != null && operationModeOut1.length() == 2 && (operationModeOut1.equals("01") || operationModeOut1.equals("02") || this.settings.isContinuousRecordSet() && operationModeOut1.equals("03"));
            }
            return operationModeOut1 != null && operationModeOut1.length() == 2 && !operationModeOut1.equals("00") && !operationModeOut1.equals("06");
        }
        if (outletNum == 2) {
            String operationModeOut2 = String.format("%c%c", Character.valueOf((char)dataBuffer[79]), Character.valueOf((char)dataBuffer[80]));
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "operationModeOut2 = " + (operationModeOut2 != null && operationModeOut2.length() > 0 ? this.USAGE_MODE[Integer.parseInt(operationModeOut2, 16)] : operationModeOut2));
            }
            if (this.settings.isReduceChargeDischarge()) {
                return operationModeOut2 != null && operationModeOut2.length() == 2 && (operationModeOut2.equals("01") || operationModeOut2.equals("02") || this.settings.isContinuousRecordSet() && operationModeOut2.equals("03"));
            }
            return operationModeOut2 != null && operationModeOut2.length() == 2 && !operationModeOut2.equals("00") && !operationModeOut2.equals("06");
        }
        return false;
    }

    @Override
    public int getProcessingMode(byte[] dataBuffer) {
        String operationMode = String.format("%c%c", Character.valueOf((char)dataBuffer[15]), Character.valueOf((char)dataBuffer[16]));
        return operationMode != null && operationMode.length() > 0 ? Integer.parseInt(operationMode, 16) : 0;
    }

    @Override
    public String getProcessingType(byte[] dataBuffer) {
        String type = "";
        String operationMode = String.format("%c%c", Character.valueOf((char)dataBuffer[15]), Character.valueOf((char)dataBuffer[16]));
        int opMode = operationMode != null && operationMode.length() > 0 ? Integer.parseInt(operationMode, 16) : 0;
        String operationType = String.format("%c%c", Character.valueOf((char)dataBuffer[17]), Character.valueOf((char)dataBuffer[18]));
        switch (opMode) {
            case 1: {
                type = operationType != null && operationType.length() > 0 ? this.CHARGE_MODE[Integer.parseInt(operationType, 16)] : "";
                break;
            }
            case 2: {
                type = operationType != null && operationType.length() > 0 ? this.DISCHARGE_MODE[Integer.parseInt(operationType, 16)] : "";
                break;
            }
            case 3: {
                type = operationType != null && operationType.length() > 0 ? this.DELAY_MODE[Integer.parseInt(operationType, 16)] : "";
                break;
            }
            case 5: {
                type = operationType != null && operationType.length() > 0 ? this.CURRENT_MODE[Integer.parseInt(operationType, 16)] : "";
                break;
            }
            case 6: {
                GDE.getUiNotification().setStatusMessage(Messages.getString((String)"GDE_MSGE2218") + String.format("%02d", Integer.parseInt(operationType, 16)), 3);
            }
        }
        return type;
    }

    @Override
    public boolean isLinkedMode(byte[] dataBuffer) {
        String operationMode1 = String.format("%c%c", Character.valueOf((char)dataBuffer[15]), Character.valueOf((char)dataBuffer[16]));
        String operationMode2 = String.format("%c%c", Character.valueOf((char)dataBuffer[79]), Character.valueOf((char)dataBuffer[80]));
        String operationType1 = String.format("%c%c", Character.valueOf((char)dataBuffer[17]), Character.valueOf((char)dataBuffer[18]));
        String operationType2 = String.format("%c%c", Character.valueOf((char)dataBuffer[81]), Character.valueOf((char)dataBuffer[82]));
        return operationMode1.equals(operationMode2) && operationType1.equals(operationType2) && (operationMode1.equals("01") && operationType1.equals("09") || operationMode1.equals("02") && operationType1.equals("05"));
    }

    @Override
    public int getBatteryMemoryNumber(int outletNum, byte[] dataBuffer) {
        String batteryMemoryNumber = String.format("%c%c", Character.valueOf((char)dataBuffer[5]), Character.valueOf((char)dataBuffer[6]));
        if (outletNum == 2) {
            try {
                batteryMemoryNumber = String.format("%c%c", Character.valueOf((char)dataBuffer[69]), Character.valueOf((char)dataBuffer[70]));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return Integer.parseInt(batteryMemoryNumber, 16);
    }

    @Override
    public int getCycleNumber(int outletNum, byte[] dataBuffer) {
        String cycleNumber = String.format("%c%c", Character.valueOf((char)dataBuffer[19]), Character.valueOf((char)dataBuffer[20]));
        if (outletNum == 2) {
            try {
                cycleNumber = String.format("%c%c", Character.valueOf((char)dataBuffer[83]), Character.valueOf((char)dataBuffer[84]));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return Integer.parseInt(cycleNumber, 16);
    }

    @Override
    public void setTemperatureUnit(int channelNumber, RecordSet recordSet, byte[] dataBuffer) {
        String unit = String.format("%c%c", Character.valueOf((char)dataBuffer[39]), Character.valueOf((char)dataBuffer[40]));
        if (unit != null && unit.length() > 0) {
            if (channelNumber == 3) {
                if (Integer.parseInt(unit) == 0) {
                    this.setMeasurementUnit(recordSet.getChannelConfigNumber(), 15, "\u00b0C");
                    this.setMeasurementUnit(recordSet.getChannelConfigNumber(), 16, "\u00b0C");
                } else if (Integer.parseInt(unit) == 1) {
                    this.setMeasurementUnit(recordSet.getChannelConfigNumber(), 15, "\u00b0F");
                    this.setMeasurementUnit(recordSet.getChannelConfigNumber(), 16, "\u00b0F");
                }
            } else if (Integer.parseInt(unit) == 0) {
                this.setMeasurementUnit(recordSet.getChannelConfigNumber(), 5, "\u00b0C");
            } else if (Integer.parseInt(unit) == 1) {
                this.setMeasurementUnit(recordSet.getChannelConfigNumber(), 5, "\u00b0F");
            }
        }
    }

    public CTabItem getUtilityDeviceTabItem() {
        return this.application.getUtilGraphicsWindow(Messages.getString((String)"GDE_MSGT2340"));
    }
}

