/*
 * Decompiled with CFR 0.152.
 */
package gde.device.elprog;

import gde.GDE;
import gde.config.Settings;
import gde.data.Channel;
import gde.data.Channels;
import gde.data.Record;
import gde.data.RecordSet;
import gde.device.DataBlockType;
import gde.device.DeviceConfiguration;
import gde.device.IDevice;
import gde.device.InputTypes;
import gde.device.elprog.CSVSerialDataReaderWriter;
import gde.device.elprog.PulsarDataParser;
import gde.device.elprog.PulsarGathererThread;
import gde.device.elprog.PulsarSerialPort;
import gde.exception.ApplicationConfigurationException;
import gde.exception.DataInconsitsentException;
import gde.exception.DevicePropertiesInconsistenceException;
import gde.exception.SerialPortException;
import gde.io.IDataParser;
import gde.io.LogViewReader;
import gde.log.Level;
import gde.messages.Messages;
import gde.ui.DataExplorer;
import gde.utils.FileUtils;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Logger;
import javax.xml.bind.JAXBException;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;

public class Pulsar3
extends DeviceConfiguration
implements IDevice {
    static final Logger log = Logger.getLogger(Pulsar3.class.getName());
    protected final Settings settings = Settings.getInstance();
    protected final DataExplorer application = DataExplorer.getInstance();
    protected final Channels channels = Channels.getInstance();
    protected final PulsarSerialPort serialPort;
    protected PulsarGathererThread gathererThread;
    protected boolean isFileIO = false;
    protected boolean isSerialIO = false;
    protected Map<Integer, String> batteryTypes = new HashMap<Integer, String>();

    public Pulsar3(String deviceProperties) throws FileNotFoundException, JAXBException {
        super(deviceProperties);
        Messages.setDeviceResourceBundle((String)"gde.device.elprog.messages", (Locale)Settings.getInstance().getLocale(), (ClassLoader)((Object)((Object)this)).getClass().getClassLoader());
        if (this.application.getMenuToolBar() != null) {
            for (DataBlockType.Format format : this.getDataBlockType().getFormat()) {
                if (!this.isSerialIO) {
                    boolean bl = this.isSerialIO = format.getInputType() == InputTypes.SERIAL_IO;
                }
                if (this.isFileIO) continue;
                this.isFileIO = format.getInputType() == InputTypes.FILE_IO;
            }
            if (this.isSerialIO) {
                this.configureSerialPortMenu(1, "", "");
            } else {
                this.configureSerialPortMenu(2, Messages.getString((String)"GDE_MSGT3903"), Messages.getString((String)"GDE_MSGT3903"));
            }
            if (this.isFileIO) {
                this.updateFileImportMenu(this.application.getMenuBar().getImportMenu());
            }
        }
        this.serialPort = new PulsarSerialPort(this, this.application);
        this.initBatteryTypes();
        LogViewReader.putDeviceMap((String)"pulsar 3", (String)"Pulsar3");
    }

    public Pulsar3(DeviceConfiguration deviceConfig) {
        super(deviceConfig);
        Messages.setDeviceResourceBundle((String)"gde.device.elprog.messages", (Locale)Settings.getInstance().getLocale(), (ClassLoader)((Object)((Object)this)).getClass().getClassLoader());
        if (this.application.getMenuToolBar() != null) {
            for (DataBlockType.Format format : this.getDataBlockType().getFormat()) {
                if (!this.isSerialIO) {
                    boolean bl = this.isSerialIO = format.getInputType() == InputTypes.SERIAL_IO;
                }
                if (this.isFileIO) continue;
                this.isFileIO = format.getInputType() == InputTypes.FILE_IO;
            }
            if (this.isSerialIO) {
                this.configureSerialPortMenu(1, "", "");
            } else {
                this.configureSerialPortMenu(2, Messages.getString((String)"GDE_MSGT3903"), Messages.getString((String)"GDE_MSGT3903"));
            }
            if (this.isFileIO) {
                this.updateFileImportMenu(this.application.getMenuBar().getImportMenu());
            }
        }
        this.serialPort = new PulsarSerialPort(this, this.application);
        this.initBatteryTypes();
        LogViewReader.putDeviceMap((String)"pulsar 3", (String)"Pulsar3");
    }

    protected void initBatteryTypes() {
        this.batteryTypes.put(0, "NiCd");
        this.batteryTypes.put(1, "NiMH");
        this.batteryTypes.put(4, "LiIo");
        this.batteryTypes.put(5, "LiPo");
        this.batteryTypes.put(7, "LiFe");
    }

    public void updateFileImportMenu(Menu importMenue) {
        if (importMenue.getItem(importMenue.getItemCount() - 1).getText().equals(Messages.getString((String)"GDE_MSGT0018"))) {
            new MenuItem(importMenue, 2);
            MenuItem importDeviceLogItem = new MenuItem(importMenue, 8);
            importDeviceLogItem.setText(Messages.getString((String)"GDE_MSGT3904", (Object[])GDE.MOD1));
            importDeviceLogItem.setAccelerator(SWT.MOD1 + Messages.getAcceleratorChar((String)"GDE_MSGT3904"));
            importDeviceLogItem.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    log.log(java.util.logging.Level.FINEST, "importDeviceLogItem action performed! " + String.valueOf(e));
                    if (!Pulsar3.this.isSerialIO) {
                        Pulsar3.this.open_closeCommPort();
                    } else {
                        Pulsar3.this.importDeviceData();
                    }
                }
            });
        }
    }

    public void importDeviceData() {
        final FileDialog fd = FileUtils.getImportDirectoryFileDialog((IDevice)this, (String)Messages.getString((String)"GDE_MSGT3900"));
        Thread reader = new Thread("reader"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    Pulsar3.this.application.setPortConnected(true);
                    for (String tmpFileName : fd.getFileNames()) {
                        String selectedImportFile = fd.getFilterPath() + "/" + tmpFileName;
                        log.log(Level.FINE, "selectedImportFile = " + selectedImportFile);
                        if (fd.getFileName().length() <= 4) continue;
                        String recordNameExtend = "";
                        try {
                            block9: {
                                BufferedReader reader = null;
                                try {
                                    reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(selectedImportFile), "ISO-8859-1"));
                                    String line = reader.readLine();
                                    if (line.startsWith("#")) {
                                        recordNameExtend = Pulsar3.this.batteryTypes.get(Integer.valueOf(line.substring(4, 6)));
                                        recordNameExtend = recordNameExtend == null ? "" : recordNameExtend;
                                    }
                                    reader.close();
                                }
                                catch (Exception e) {
                                    if (reader == null) break block9;
                                    reader.close();
                                }
                            }
                            CSVSerialDataReaderWriter.read(selectedImportFile, Pulsar3.this, recordNameExtend, 1, (IDataParser)new PulsarDataParser(Pulsar3.this.getDataBlockTimeUnitFactor(), Pulsar3.this.getDataBlockLeader(), Pulsar3.this.getDataBlockSeparator().value(), null, null, Math.abs(Pulsar3.this.getDataBlockSize(InputTypes.FILE_IO)), Pulsar3.this.getDataBlockFormat(InputTypes.FILE_IO), false, 2));
                        }
                        catch (Throwable e) {
                            log.log(Level.WARNING, e.getMessage(), e);
                        }
                    }
                }
                finally {
                    Pulsar3.this.application.setPortConnected(false);
                }
            }
        };
        reader.start();
    }

    public boolean recordSetNumberFollowChannel() {
        return false;
    }

    public HashMap<String, String> getLovKeyMappings(HashMap<String, String> lov2osdMap) {
        return lov2osdMap;
    }

    public String getConvertedRecordConfigurations(HashMap<String, String> header, HashMap<String, String> lov2osdMap, int channelNumber) {
        return " ";
    }

    public int getLovDataByteSize() {
        return 158;
    }

    public void addConvertedLovDataBufferAsRawDataPoints(RecordSet recordSet, byte[] dataBuffer, int recordDataSize, boolean doUpdateProgressBar) throws DataInconsitsentException {
        String sThreadId = String.format("%06d", Thread.currentThread().threadId());
        int deviceDataBufferSize = this.getLovDataByteSize();
        int[] points = new int[this.getNumberOfMeasurements(1)];
        int offset = 0;
        int progressCycle = 0;
        int lovDataSize = this.getLovDataByteSize();
        byte[] convertBuffer = new byte[deviceDataBufferSize];
        if (doUpdateProgressBar) {
            this.application.setProgress(progressCycle, sThreadId);
        }
        for (int i = 0; i < recordDataSize; ++i) {
            System.arraycopy(dataBuffer, offset, convertBuffer, 0, deviceDataBufferSize);
            recordSet.addPoints(this.convertDataBytes(points, convertBuffer));
            offset += lovDataSize + 10;
            if (!doUpdateProgressBar || i % 50 != 0) continue;
            this.application.setProgress(++progressCycle * 5000 / recordDataSize, sThreadId);
        }
        if (doUpdateProgressBar) {
            this.application.setProgress(100, sThreadId);
        }
    }

    public int[] convertDataBytes(int[] points, byte[] dataBuffer) {
        PulsarDataParser data = new PulsarDataParser(this.getDataBlockTimeUnitFactor(), this.getDataBlockLeader(), this.getDataBlockSeparator().value(), null, null, Math.abs(this.getDataBlockSize(InputTypes.FILE_IO)), this.getDataBlockFormat(InputTypes.SERIAL_IO), false);
        try {
            byte[] lineBuffer = new byte[Math.abs(this.getDataBlockSize(InputTypes.SERIAL_IO))];
            System.arraycopy(dataBuffer, 0, lineBuffer, 0, dataBuffer.length);
            data.parse(new String(lineBuffer), 1);
        }
        catch (DevicePropertiesInconsistenceException e) {
            log.log(Level.SEVERE, e.getMessage(), e);
        }
        return data.getValues(points);
    }

    public void addDataBufferAsRawDataPoints(RecordSet recordSet, byte[] dataBuffer, int recordDataSize, boolean doUpdateProgressBar) throws DataInconsitsentException {
        int dataBufferSize = 4 * recordSet.getNoneCalculationRecordNames().length;
        int[] points = new int[recordSet.getNoneCalculationRecordNames().length];
        String sThreadId = String.format("%06d", Thread.currentThread().threadId());
        int progressCycle = 1;
        if (doUpdateProgressBar) {
            this.application.setProgress(progressCycle, sThreadId);
        }
        int index = 0;
        for (int i = 0; i < recordDataSize; ++i) {
            index = i * dataBufferSize;
            if (log.isLoggable(Level.FINER)) {
                log.log(Level.FINER, i + " i*dataBufferSize = " + index);
            }
            for (int j = 0; j < points.length; ++j) {
                points[j] = ((dataBuffer[0 + j * 4 + index] & 0xFF) << 24) + ((dataBuffer[1 + j * 4 + index] & 0xFF) << 16) + ((dataBuffer[2 + j * 4 + index] & 0xFF) << 8) + ((dataBuffer[3 + j * 4 + index] & 0xFF) << 0);
            }
            recordSet.addPoints(points);
            if (!doUpdateProgressBar || i % 50 != 0) continue;
            this.application.setProgress(++progressCycle * 5000 / recordDataSize, sThreadId);
        }
        if (doUpdateProgressBar) {
            this.application.setProgress(100, sThreadId);
        }
        recordSet.syncScaleOfSyncableRecords();
    }

    public String[] prepareDataTableRow(RecordSet recordSet, String[] dataTableRow, int rowIndex) {
        try {
            int index = 0;
            for (Record record : recordSet.getVisibleAndDisplayableRecordsForTable()) {
                double factor = record.getFactor();
                if (record.getOrdinal() > 7 && record.getUnit().equals("V")) {
                    try {
                        dataTableRow[index + 1] = String.format("%.3f", (double)record.realGet(rowIndex).intValue() / 1000.0 * factor);
                    }
                    catch (Exception e) {
                        dataTableRow[index + 1] = String.format("%.3f", (double)record.realGet(record.realSize() - 1).intValue() / 1000.0 * factor);
                    }
                } else {
                    try {
                        dataTableRow[index + 1] = record.getDecimalFormat().format((double)record.realGet(rowIndex).intValue() / 1000.0 * factor);
                    }
                    catch (Exception e) {
                        dataTableRow[index + 1] = record.getDecimalFormat().format((double)record.realGet(record.realSize() - 1).intValue() / 1000.0 * factor);
                    }
                }
                ++index;
            }
        }
        catch (RuntimeException e) {
            log.log(Level.SEVERE, e.getMessage(), e);
        }
        return dataTableRow;
    }

    public double translateValue(Record record, double value) {
        double factor = record.getFactor();
        double newValue = value * factor;
        log.log(Level.FINE, "for " + record.getName() + " in value = " + value + " out value = " + newValue);
        return newValue;
    }

    public double reverseTranslateValue(Record record, double value) {
        double factor = record.getFactor();
        double newValue = value / factor;
        log.log(Level.FINE, "for " + record.getName() + " in value = " + value + " out value = " + newValue);
        return newValue;
    }

    public void makeInActiveDisplayable(RecordSet recordSet) {
        if (recordSet.isRaw()) {
            try {
                int displayableCounter = 0;
                for (int i = 0; i < recordSet.size(); ++i) {
                    Record record = recordSet.get(i);
                    if (!record.isActive() || !record.hasReasonableData()) continue;
                    ++displayableCounter;
                }
                log.log(Level.FINE, "displayableCounter = " + displayableCounter);
                recordSet.setConfiguredDisplayable(displayableCounter);
                if (recordSet.getName().equals(this.channels.getActiveChannel().getActiveRecordSet().getName())) {
                    this.application.updateGraphicsWindow();
                }
            }
            catch (RuntimeException e) {
                log.log(Level.SEVERE, e.getMessage(), e);
            }
        }
    }

    public void updateVisibilityStatus(RecordSet recordSet, boolean includeReasonableDataCheck) {
        Record record;
        int i;
        int displayableCounter = 0;
        recordSet.setAllDisplayable();
        for (i = 7; i < recordSet.size(); ++i) {
            record = recordSet.get(i);
            record.setDisplayable(record.hasReasonableData());
            if (log.isLoggable(Level.FINER)) {
                log.log(Level.FINER, record.getName() + " setDisplayable=" + record.hasReasonableData());
            }
            if (!record.isActive() || !record.isDisplayable()) continue;
            ++displayableCounter;
        }
        if (log.isLoggable(Level.FINE)) {
            for (i = 0; i < recordSet.size(); ++i) {
                record = recordSet.get(i);
                log.log(Level.FINE, record.getName() + " isActive=" + record.isActive() + " isVisible=" + record.isVisible() + " isDisplayable=" + record.isDisplayable());
            }
        }
        recordSet.setConfiguredDisplayable(displayableCounter);
    }

    public String[] getUsedPropertyKeys() {
        return new String[]{IDevice.OFFSET, IDevice.FACTOR};
    }

    public void open_closeCommPort() {
        block12: {
            if (this.serialPort != null) {
                if (!this.serialPort.isConnected()) {
                    try {
                        Channel activChannel = Channels.getInstance().getActiveChannel();
                        if (activChannel == null) break block12;
                        this.gathererThread = new PulsarGathererThread(this.application, this, this.serialPort, activChannel.getNumber());
                        try {
                            if (this.serialPort.isConnected()) {
                                this.gathererThread.start();
                            }
                        }
                        catch (RuntimeException e) {
                            log.log(Level.SEVERE, e.getMessage(), e);
                        }
                        catch (Throwable e) {
                            log.log(Level.SEVERE, e.getMessage(), e);
                        }
                    }
                    catch (SerialPortException e) {
                        log.log(Level.SEVERE, e.getMessage(), e);
                        this.application.openMessageDialog(Messages.getString((String)"GDE_MSGE0015", (Object[])new Object[]{((Object)((Object)e)).getClass().getSimpleName() + " : " + e.getMessage()}));
                    }
                    catch (ApplicationConfigurationException e) {
                        log.log(Level.SEVERE, e.getMessage(), e);
                        this.application.openMessageDialog(Messages.getString((String)"GDE_MSGE0010"));
                        this.application.getDeviceSelectionDialog().open();
                    }
                    catch (Throwable e) {
                        log.log(Level.SEVERE, e.getMessage(), e);
                    }
                } else {
                    if (this.gathererThread != null) {
                        this.gathererThread.stopDataGatheringThread(false, null);
                    }
                    this.serialPort.close();
                }
            }
        }
    }

    public int[] getCellVoltageOrdinals() {
        return new int[]{0, 2};
    }

    public String getProcessName(byte[] buffer) throws Exception {
        return String.format("%s [%s]", this.getRecordSetStateNameReplacement(buffer[3]), this.batteryTypes.get(Integer.valueOf(new String(buffer).substring(4, 6))));
    }

    public boolean isProcessing(byte[] buffer) {
        switch ((char)buffer[8]) {
            case 'E': 
            case 'M': {
                return false;
            }
        }
        return true;
    }
}

