/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.analysis.differentiation;

import org.apache.commons.math3.analysis.MultivariateVectorFunction;
import org.apache.commons.math3.analysis.differentiation.DerivativeStructure;
import org.apache.commons.math3.analysis.differentiation.MultivariateDifferentiableFunction;

public class GradientFunction
implements MultivariateVectorFunction {
    private final MultivariateDifferentiableFunction f;

    public GradientFunction(MultivariateDifferentiableFunction f2) {
        this.f = f2;
    }

    public double[] value(double[] point) {
        DerivativeStructure[] dsX = new DerivativeStructure[point.length];
        for (int i2 = 0; i2 < point.length; ++i2) {
            dsX[i2] = new DerivativeStructure(point.length, 1, i2, point[i2]);
        }
        DerivativeStructure dsY = this.f.value(dsX);
        double[] y2 = new double[point.length];
        int[] orders = new int[point.length];
        for (int i3 = 0; i3 < point.length; ++i3) {
            orders[i3] = 1;
            y2[i3] = dsY.getPartialDerivative(orders);
            orders[i3] = 0;
        }
        return y2;
    }
}

