/*
 * Decompiled with CFR 0.152.
 */
package gde.histo.gpslocations;

import com.sun.istack.Nullable;
import gde.DataAccess;
import gde.histo.gpslocations.GeoCodes;
import gde.histo.utils.GpsCoordinate;
import gde.log.Logger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.logging.Level;
import java.util.stream.Collectors;

public final class GpsCluster
extends ArrayList<GpsCoordinate> {
    private static final long serialVersionUID = 5239035277133565077L;
    private static final String $CLASS_NAME = GpsCluster.class.getName();
    private static final Logger log = Logger.getLogger($CLASS_NAME);
    private GpsCoordinate reference;
    private Map<GpsCoordinate, GpsCluster> assignedClusters = new HashMap<GpsCoordinate, GpsCluster>();

    public GpsCoordinate getCenter() {
        GpsCoordinate centerCoordinate;
        double xAvg = 0.0;
        double yAvg = 0.0;
        double zAvg = 0.0;
        for (int i = 0; i < this.size(); ++i) {
            GpsCoordinate gpsCoordinate = (GpsCoordinate)this.get(i);
            double phi = Math.toRadians(gpsCoordinate.getLatitude());
            double lambda = Math.toRadians(gpsCoordinate.getLongitude());
            xAvg += (Math.cos(phi) * Math.cos(lambda) - xAvg) / (double)(i + 1);
            yAvg += (Math.cos(phi) * Math.sin(lambda) - yAvg) / (double)(i + 1);
            zAvg += (Math.sin(phi) - zAvg) / (double)(i + 1);
            log.log(Level.FINER, "coordinate=", gpsCoordinate);
        }
        if (Math.abs(xAvg) < 1.0E-11 && Math.abs(yAvg) < 1.0E-11 && Math.abs(zAvg) < 1.0E-11) {
            centerCoordinate = new GpsCoordinate(51.477778, 0.0);
        } else {
            double hyp = Math.sqrt(xAvg * xAvg + yAvg * yAvg);
            centerCoordinate = new GpsCoordinate(Math.toDegrees(Math.atan2(zAvg, hyp)), Math.toDegrees(Math.atan2(yAvg, xAvg)));
        }
        log.log(Level.FINER, "result=", centerCoordinate);
        return centerCoordinate;
    }

    public GpsCoordinate getClustersCenter() {
        GpsCoordinate centerCoordinate;
        double xAvg = 0.0;
        double yAvg = 0.0;
        double zAvg = 0.0;
        List<GpsCluster> clusters = this.getClusters();
        for (int i = 0; i < clusters.size(); ++i) {
            GpsCoordinate gpsCoordinate = clusters.get(i).getCenter();
            double phi = Math.toRadians(gpsCoordinate.getLatitude());
            double lambda = Math.toRadians(gpsCoordinate.getLongitude());
            xAvg += (Math.cos(phi) * Math.cos(lambda) - xAvg) / (double)(i + 1);
            yAvg += (Math.cos(phi) * Math.sin(lambda) - yAvg) / (double)(i + 1);
            zAvg += (Math.sin(phi) - zAvg) / (double)(i + 1);
            log.log(Level.FINER, "coordinate=", gpsCoordinate);
        }
        if (Math.abs(xAvg) < 1.0E-11 && Math.abs(yAvg) < 1.0E-11 && Math.abs(zAvg) < 1.0E-11) {
            centerCoordinate = new GpsCoordinate(51.477778, 0.0);
        } else {
            double hyp = Math.sqrt(xAvg * xAvg + yAvg * yAvg);
            centerCoordinate = new GpsCoordinate(Math.toDegrees(Math.atan2(zAvg, hyp)), Math.toDegrees(Math.atan2(yAvg, xAvg)));
        }
        log.log(Level.FINER, "result=", centerCoordinate);
        return centerCoordinate;
    }

    public void setClusters(double locationRadius) {
        this.assignedClusters.clear();
        GpsCluster wip = new GpsCluster();
        for (GpsCoordinate cc : this) {
            if (cc == null) continue;
            wip.add(cc);
        }
        if (wip.size() > 0) {
            this.reference = (GpsCoordinate)wip.get(wip.size() / 2);
            while (wip.size() > 0) {
                DistanceProcessor distanceProcessor = wip.parallelStream().collect(() -> new DistanceProcessor(), (dp, u) -> dp.accept((GpsCoordinate)u, locationRadius), DistanceProcessor::combine);
                this.assignedClusters.putAll(distanceProcessor.identifiedClusters);
                wip = distanceProcessor.relicts;
                this.setReference(distanceProcessor.getResiduumReference());
                log.finer(() -> "number of clusters : " + this.getClusters().size() + "  new Cluster members : " + this.assignedClusters.size());
            }
        }
    }

    public List<String> defineGpsLocations(double gpsLocationRadius, DataAccess dataAccess) {
        ArrayList<String> tmpGpsLocations = new ArrayList<String>();
        for (GpsCoordinate gpsCoordinate : this) {
            if (gpsCoordinate != null) {
                GpsCoordinate centeredGpsCoordinate = this.getAssignedClusters().get(gpsCoordinate).getCenter();
                tmpGpsLocations.add(GeoCodes.getOrAcquireLocation(centeredGpsCoordinate, gpsLocationRadius, dataAccess));
                continue;
            }
            tmpGpsLocations.add("");
        }
        return tmpGpsLocations;
    }

    public GpsCoordinate getReference() {
        return this.reference;
    }

    private void setReference(GpsCoordinate reference) {
        this.reference = reference;
    }

    public Map<GpsCoordinate, GpsCluster> getAssignedClusters() {
        return this.assignedClusters;
    }

    public List<GpsCluster> getClusters() {
        return this.assignedClusters.values().parallelStream().distinct().collect(Collectors.toList());
    }

    private class DistanceProcessor
    implements BiConsumer<GpsCoordinate, Double> {
        private GpsCluster clusteredItems = new GpsCluster();
        private Map<GpsCoordinate, GpsCluster> identifiedClusters = new HashMap<GpsCoordinate, GpsCluster>();
        private GpsCluster relicts = new GpsCluster();
        private List<Double> relictSqDistances = new ArrayList<Double>();
        private double relictSqDistanceSum = 0.0;

        private DistanceProcessor() {
        }

        @Override
        public void accept(GpsCoordinate newGpsCoordinate, Double gpsLocationRadius) {
            if (GpsCluster.this.getReference() == newGpsCoordinate) {
                log.finest(() -> "add myself to the empty clusteredItems list" + this.clusteredItems.size());
                this.clusteredItems.add(newGpsCoordinate);
                this.identifiedClusters.put(newGpsCoordinate, this.clusteredItems);
            } else {
                double distance = GpsCluster.this.getReference().getDistance(newGpsCoordinate);
                log.finest(() -> String.format("ClusterRadius=%f  distance=%f  to %s", gpsLocationRadius, distance, newGpsCoordinate));
                if (distance <= gpsLocationRadius) {
                    this.clusteredItems.add(newGpsCoordinate);
                    this.identifiedClusters.put(newGpsCoordinate, this.clusteredItems);
                } else {
                    this.relicts.add(newGpsCoordinate);
                    this.relictSqDistances.add(distance * distance);
                    this.relictSqDistanceSum += distance * distance;
                }
            }
        }

        public void combine(DistanceProcessor other) {
            this.clusteredItems.addAll(other.clusteredItems);
            this.identifiedClusters.putAll(other.identifiedClusters);
            this.relicts.addAll(other.relicts);
            this.relictSqDistances.addAll(other.relictSqDistances);
            this.relictSqDistanceSum += other.relictSqDistanceSum;
        }

        @Nullable
        public GpsCoordinate getResiduumReference() {
            double arbitrarySqDistance = Math.random() * this.relictSqDistanceSum;
            double cumulativeSqDistance = 0.0;
            for (int i = 0; i < this.relictSqDistances.size(); ++i) {
                if (!(arbitrarySqDistance <= (cumulativeSqDistance += this.relictSqDistances.get(i).doubleValue()))) continue;
                GpsCoordinate residuumReference = (GpsCoordinate)this.relicts.get(i);
                log.finer(() -> String.format("relictsSize=%d  new reference=%s", this.relicts.size(), residuumReference));
                return residuumReference;
            }
            return null;
        }
    }
}

