/*
 * Decompiled with CFR 0.152.
 */
package com.monstarmike.tlmreader;

import com.monstarmike.tlmreader.IFlight;
import com.monstarmike.tlmreader.datablock.DataBlock;
import com.monstarmike.tlmreader.datablock.HeaderBlock;
import com.monstarmike.tlmreader.datablock.HeaderNameBlock;
import com.monstarmike.tlmreader.datablock.HeaderRpmBlock;
import com.monstarmike.tlmreader.datablock.normalizer.DataNormalizer;
import com.monstarmike.tlmreader.datablock.normalizer.processor.ProcessorEvaluator;
import com.monstarmike.tlmreader.datablock.normalizer.processor.RedundantDataBlocksProcessor;
import java.util.ArrayList;
import java.util.List;

public class Flight
implements IFlight {
    private ArrayList<HeaderBlock> headerData = new ArrayList();
    private ArrayList<DataBlock> blockData = new ArrayList();
    String modelName;
    private HeaderRpmBlock rpmHeader;

    @Override
    public long getDuration_ms() {
        int start = 0;
        int end = 0;
        if (!this.blockData.isEmpty()) {
            start = this.blockData.get(0).getTimestamp();
            end = this.blockData.get(this.blockData.size() - 1).getTimestamp();
        }
        return (end - start) * 10;
    }

    public void normalizeDataBlocks() {
        List<HeaderBlock> headerBlocks = this.getHeaderBlocks();
        for (HeaderBlock headerBlock : headerBlocks) {
            DataNormalizer normalizer = headerBlock.getNormalizer();
            normalizer.normalize(this.getDataBlocks());
        }
    }

    @Override
    public void addHeaderNameBlock(HeaderNameBlock block) {
        this.modelName = block.getModelName();
        this.headerData.add(block);
    }

    @Override
    public void addRpmHeaderBlock(HeaderRpmBlock block) {
        this.headerData.add(block);
        this.rpmHeader = block;
    }

    public void addHeaderBlock(HeaderBlock block) {
        this.headerData.add(block);
    }

    @Override
    public void addDataBlock(DataBlock block) {
        this.blockData.add(block);
    }

    @Override
    public List<HeaderBlock> getHeaderBlocks() {
        return this.headerData;
    }

    public List<DataBlock> getDataBlocks() {
        return this.blockData;
    }

    public String toString() {
        return String.valueOf(this.modelName) + " duration: " + this.getDuration_ms() + " ms";
    }

    public boolean hasRpmHeader() {
        return this.rpmHeader != null;
    }

    @Override
    public HeaderRpmBlock getRpmHeader() {
        return this.rpmHeader;
    }

    @Override
    public int getNumberOfDataBlocks() {
        return this.blockData.size();
    }

    public void removeRedundantDataBlocks() {
        ProcessorEvaluator<DataBlock> evaluator = new ProcessorEvaluator<DataBlock>();
        evaluator.registerProcessor(new RedundantDataBlocksProcessor());
        evaluator.process(this.getDataBlocks());
    }
}

